/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.object.PsDebug;

public class PsXmlNode
implements Serializable {
    protected String m_type;
    protected Hashtable m_attribute;
    protected String m_content;
    protected Vector m_mixedContent;
    protected PsXmlNode m_father;
    protected PsXmlNode m_sibling;
    protected PsXmlNode m_child;
    private PsXmlNode m_lastChild;
    private boolean m_isExpanded;
    protected boolean m_bMixedMode;

    public PsXmlNode getChild(String type) {
        PsXmlNode run = this.m_child;
        while (run != null) {
            String runType = run.getType();
            if (runType != null && runType.equals(type)) {
                return run;
            }
            run = run.getSibling();
        }
        run = this.m_child;
        while (run != null) {
            PsXmlNode child = run.getChild(type);
            if (child != null) {
                return child;
            }
            run = run.getSibling();
        }
        return null;
    }

    public PsXmlNode getChild() {
        return this.m_child;
    }

    public void setChild(PsXmlNode child) {
        if (child != null) {
            child.setFather(this);
        }
        this.m_child = child;
        this.m_lastChild = child;
    }

    public Enumeration getMixedContent() {
        if (this.m_mixedContent == null) {
            return null;
        }
        return this.m_mixedContent.elements();
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public String appendContent(String content) {
        this.m_content = this.m_content == null ? content : this.m_content.concat(content);
        return this.m_content;
    }

    public int getNumChildren() {
        int num = 0;
        PsXmlNode run = this.m_child;
        while (run != null) {
            ++num;
            run = run.getSibling();
        }
        return num;
    }

    public boolean isExpanded() {
        return this.m_isExpanded;
    }

    public PsXmlNode getSibling() {
        return this.m_sibling;
    }

    public void setSibling(PsXmlNode sibling) {
        if (sibling == null) {
            this.m_sibling = null;
            return;
        }
        this.m_sibling = sibling;
        sibling.setFather(this.m_father);
    }

    public PsXmlNode getFather() {
        return this.m_father;
    }

    public void setFather(PsXmlNode father) {
        this.m_father = father;
    }

    public void addMixedContent(Object obj) {
        if (this.m_mixedContent == null) {
            this.m_mixedContent = new Vector();
        }
        this.m_mixedContent.addElement(obj);
    }

    public PsXmlNode[] getChildren() {
        int numChildren = this.getNumChildren();
        if (numChildren == 0) {
            return null;
        }
        PsXmlNode[] child = new PsXmlNode[numChildren];
        PsXmlNode run = this.m_child;
        int i = 0;
        while (i < numChildren) {
            child[i] = run;
            run = run.getSibling();
            ++i;
        }
        return child;
    }

    public PsXmlNode[] getChildren(String type) {
        Vector<PsXmlNode> nodes = null;
        PsXmlNode run = this.m_child;
        while (run != null) {
            if (run.getType().equals(type)) {
                if (nodes == null) {
                    nodes = new Vector<PsXmlNode>();
                }
                nodes.addElement(run);
            }
            run = run.getSibling();
        }
        if (nodes != null) {
            Object[] arr = new PsXmlNode[nodes.size()];
            nodes.copyInto(arr);
            return arr;
        }
        return null;
    }

    public void addAttribute(String key, String value) {
        if (value == null || value.equals("")) {
            return;
        }
        if (this.m_attribute == null) {
            this.m_attribute = new Hashtable();
        }
        this.m_attribute.put(key, value);
    }

    public PsXmlNode addChild(String type, String content) {
        PsXmlNode child = this.addChild(type);
        if (child == null) {
            return null;
        }
        child.setContent(content);
        return child;
    }

    public PsXmlNode addChild(String type, boolean content) {
        return this.addChild(type, String.valueOf(content));
    }

    public PsXmlNode addChild(String type, double content) {
        return this.addChild(type, String.valueOf(content));
    }

    public PsXmlNode addChild(String type, float content) {
        return this.addChild(type, String.valueOf(content));
    }

    public PsXmlNode addChild(String type, int content) {
        return this.addChild(type, String.valueOf(content));
    }

    public PsXmlNode addChild(String type) {
        if (type == null || type.equals("")) {
            return null;
        }
        return this.addChild(new PsXmlNode(type));
    }

    public PsXmlNode addChild(PsXmlNode child) {
        if (child == null) {
            PsDebug.warning("missing child argument");
            return null;
        }
        child.setFather(this);
        if (this.m_child == null) {
            this.m_child = child;
            this.m_lastChild = child;
        } else {
            this.m_lastChild.m_sibling = child;
            this.m_lastChild = child;
        }
        return child;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getAttribute(String key) {
        if (this.m_attribute == null) {
            return null;
        }
        return (String)this.m_attribute.get(key);
    }

    public PsXmlNode(String type) {
        this.m_type = type;
        this.m_isExpanded = true;
        this.m_bMixedMode = false;
    }

    public void setMixedMode(boolean flag) {
        this.m_bMixedMode = flag;
    }

    public void expand(boolean flag) {
        this.m_isExpanded = flag;
    }

    public boolean hasContent() {
        return this.m_content != null;
    }

    public void removeAttribute(String key) {
        if (this.m_attribute == null) {
            return;
        }
        this.m_attribute.remove(key);
    }

    public boolean hasChild(String type) {
        PsXmlNode run = this.m_child;
        while (run != null) {
            String runType = run.getType();
            if (runType != null && runType.equals(type)) {
                return true;
            }
            run = run.getSibling();
        }
        return false;
    }

    public Hashtable getAttributes() {
        return this.m_attribute;
    }

    public boolean isMixedMode() {
        return this.m_bMixedMode;
    }

    public static StringBuffer writeNode(StringBuffer xml, PsXmlNode node, String tab) {
        if (xml == null) {
            xml = new StringBuffer("");
        }
        if (node == null) {
            return xml;
        }
        xml.append(tab + "<" + node.getType());
        Hashtable attribute = node.getAttributes();
        if (attribute != null) {
            Enumeration e = attribute.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = node.getAttribute(key);
                xml.append(" " + key + "=\"" + value + "\"");
            }
        }
        if (!node.isMixedMode()) {
            String content = node.getContent();
            PsXmlNode child = node.getChild();
            if ((content == null || content.equals("")) && child == null) {
                xml.append("/>\n");
            } else {
                xml.append(">");
                boolean endTagOnSameLine = true;
                int ind = -1;
                if (content != null) {
                    ind = content.indexOf(10);
                }
                if (content != null && ind > -1 || child != null) {
                    endTagOnSameLine = false;
                    xml.append("\n");
                }
                if (content != null) {
                    int prevInd = 0;
                    String ttab = tab + "\t";
                    if (ind != -1) {
                        do {
                            xml.append(ttab + content.substring(prevInd, ind + 1));
                            prevInd = ind + 1;
                        } while ((ind = content.indexOf(10, ind + 1)) != -1);
                        if (prevInd < content.length()) {
                            xml.append(ttab + content.substring(prevInd, content.length()) + "\n");
                        }
                    } else {
                        if (!endTagOnSameLine) {
                            xml.append(ttab);
                        }
                        xml.append(content);
                        if (!endTagOnSameLine) {
                            xml.append("\n");
                        }
                    }
                }
                if (child != null) {
                    xml = PsXmlNode.writeNode(xml, child, tab + "\t");
                    PsXmlNode sibling = child.getSibling();
                    while (sibling != null) {
                        xml = PsXmlNode.writeNode(xml, sibling, tab + "\t");
                        sibling = sibling.getSibling();
                    }
                }
                if (!endTagOnSameLine) {
                    xml.append(tab);
                }
                xml.append("</" + node.getType() + ">\n");
            }
        } else {
            Enumeration enumeration = node.getMixedContent();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                xml.append("/>\n");
            } else {
                xml.append(">");
                boolean endTagOnSameLine = true;
                String stTab = "";
                while (enumeration.hasMoreElements()) {
                    Object elem = enumeration.nextElement();
                    if (elem instanceof String) {
                        String content = (String)elem;
                        int ind = -1;
                        if (content != null) {
                            ind = content.indexOf(10);
                        }
                        if (content != null && ind > -1 || node.getChild() != null) {
                            endTagOnSameLine = false;
                        }
                        if (content == null) continue;
                        int prevInd = 0;
                        String ttab = tab + stTab;
                        if (ind != -1) {
                            do {
                                xml.append(ttab + content.substring(prevInd, ind + 1));
                                prevInd = ind + 1;
                            } while ((ind = content.indexOf(10, ind + 1)) != -1);
                            if (prevInd >= content.length()) continue;
                            xml.append(ttab + content.substring(prevInd, content.length()) + "\n");
                            continue;
                        }
                        if (content.length() == 1 && (content.equals(".") || content.equals(",") || content.equals("?") || content.equals("!") || content.equals(";") || content.equals(":"))) {
                            if (xml.charAt(xml.length() - 1) == '\n') {
                                xml.setLength(xml.length() - 1);
                            }
                            xml.append(content + "\n");
                            continue;
                        }
                        if (!endTagOnSameLine) {
                            xml.append(ttab);
                        }
                        xml.append(content);
                        xml.append(" ");
                        continue;
                    }
                    PsXmlNode child = (PsXmlNode)elem;
                    if (child == null) continue;
                    xml = PsXmlNode.writeNode(xml, child, tab + stTab);
                }
                if (!endTagOnSameLine) {
                    xml.append(tab);
                }
                xml.append("</" + node.getType() + ">\n");
            }
        }
        return xml;
    }

    public static boolean writeNode(Writer writer, PsXmlNode node, String tab) throws IOException {
        if (writer == null) {
            PsDebug.warning("Missing writer to save data to.");
            return false;
        }
        if (node == null) {
            return true;
        }
        writer.write(tab + "<" + node.getType());
        Hashtable attribute = node.getAttributes();
        if (attribute != null) {
            Enumeration e = attribute.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = node.getAttribute(key);
                writer.write(" " + key + "=\"" + value + "\"");
            }
        }
        if (!node.isMixedMode()) {
            String content = node.getContent();
            PsXmlNode child = node.getChild();
            if ((content == null || content.equals("")) && child == null) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean endTagOnSameLine = true;
                int ind = -1;
                if (content != null) {
                    ind = content.indexOf(10);
                }
                if (content != null && ind > -1 || child != null) {
                    endTagOnSameLine = false;
                    writer.write("\n");
                }
                if (content != null) {
                    int prevInd = 0;
                    String ttab = tab + "\t";
                    if (ind != -1) {
                        do {
                            writer.write(ttab + content.substring(prevInd, ind + 1));
                            prevInd = ind + 1;
                        } while ((ind = content.indexOf(10, ind + 1)) != -1);
                        if (prevInd < content.length()) {
                            writer.write(ttab + content.substring(prevInd, content.length()) + "\n");
                        }
                    } else {
                        if (!endTagOnSameLine) {
                            writer.write(ttab);
                        }
                        writer.write(content);
                        if (!endTagOnSameLine) {
                            writer.write("\n");
                        }
                    }
                }
                if (child != null) {
                    PsXmlNode.writeNode(writer, child, tab + "\t");
                    PsXmlNode sibling = child.getSibling();
                    while (sibling != null) {
                        PsXmlNode.writeNode(writer, sibling, tab + "\t");
                        sibling = sibling.getSibling();
                    }
                }
                if (!endTagOnSameLine) {
                    writer.write(tab);
                }
                writer.write("</" + node.getType() + ">\n");
            }
        } else {
            Enumeration enumeration = node.getMixedContent();
            if (enumeration == null || !enumeration.hasMoreElements()) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean endTagOnSameLine = true;
                String stTab = "";
                while (enumeration.hasMoreElements()) {
                    Object elem = enumeration.nextElement();
                    if (elem instanceof String) {
                        String content = (String)elem;
                        int ind = -1;
                        if (content != null) {
                            ind = content.indexOf(10);
                        }
                        if (content != null && ind > -1 || node.getChild() != null) {
                            endTagOnSameLine = false;
                        }
                        if (content == null) continue;
                        int prevInd = 0;
                        String ttab = tab + stTab;
                        if (ind != -1) {
                            do {
                                writer.write(ttab + content.substring(prevInd, ind + 1));
                                prevInd = ind + 1;
                            } while ((ind = content.indexOf(10, ind + 1)) != -1);
                            if (prevInd >= content.length()) continue;
                            writer.write(ttab + content.substring(prevInd, content.length()) + "\n");
                            continue;
                        }
                        if (!endTagOnSameLine) {
                            writer.write(ttab);
                        }
                        writer.write(content);
                        writer.write(" ");
                        continue;
                    }
                    PsXmlNode child = (PsXmlNode)elem;
                    if (child == null) continue;
                    PsXmlNode.writeNode(writer, child, tab + stTab);
                }
                if (!endTagOnSameLine) {
                    writer.write(tab);
                }
                writer.write("</" + node.getType() + ">\n");
            }
        }
        return true;
    }

    public void removeChildren() {
        this.m_child = null;
        this.m_lastChild = null;
    }
}

