/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public abstract class PsMethodMenu
extends Vector
implements ActionListener,
ItemListener,
PsUpdateIf {
    protected String m_name;
    private transient PsObject m_parent;
    protected String m_language;
    Vector m_subMenu = new Vector();

    public Menu addMenu(String aLabel) {
        if (aLabel == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        Menu menu = this.getMenu(aLabel);
        if (menu != null) {
            return menu;
        }
        PsDebug.notify("creating menu " + aLabel);
        menu = new Menu(aLabel);
        menu.setFont(PsConfig.getFont(2));
        this.addElement(menu);
        return menu;
    }

    public Menu addMenu(String parentLabel, String aLabel) {
        Menu parentMenu = this.getMenu(parentLabel);
        if (parentMenu == null) {
            PsDebug.warning("parent menu does not exist, name = " + parentLabel);
            return null;
        }
        if (aLabel == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        Menu menu = this.getMenu(aLabel);
        if (menu != null) {
            return menu;
        }
        PsDebug.notify("creating menu " + aLabel);
        menu = new Menu(aLabel);
        menu.setFont(PsConfig.getFont(2));
        parentMenu.add(menu);
        this.m_subMenu.addElement(menu);
        return menu;
    }

    public boolean applyMethod(String method) {
        return false;
    }

    public MenuItem getMenuItem(String menuName, String itemName) {
        if (menuName == null || itemName == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        Menu menu = this.getMenu(menuName);
        if (menu == null) {
            return null;
        }
        int noi = menu.getItemCount();
        int i = 0;
        while (i < noi) {
            MenuItem item = menu.getItem(i);
            if (itemName.equals(item.getLabel())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public void setParent(PsUpdateIf aParent) {
        this.m_parent = (PsObject)aParent;
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.m_parent == null) {
            return;
        }
        String label = (String)event.getItem();
        this.applyMethod(label);
        this.m_parent.update(this.m_parent);
    }

    public PsMethodMenu() {
        this.m_language = PsConfig.getLanguage();
    }

    public boolean hasMenuItem(String menuName, String itemName) {
        return this.getMenuItem(menuName, itemName) != null;
    }

    public void removeMenuItem(String menuName, String itemName) {
        if (menuName == null || itemName == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (!this.hasMenuItem(menuName, itemName)) {
            PsDebug.notify("missing menuItem");
            return;
        }
        Menu menu = this.getMenu(menuName);
        MenuItem item = this.getMenuItem(menuName, itemName);
        item.removeActionListener(this);
        menu.remove(item);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public static int getIndexOfMethod(String[] aMethodList, String aMethod) {
        if (aMethodList != null || aMethodList.length > 0) {
            int i = 0;
            while (i < aMethodList.length) {
                if (aMethod.equals(aMethodList[i])) {
                    return i;
                }
                ++i;
            }
        }
        PsDebug.notify("method not found = " + aMethod);
        return -1;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public boolean update(Object event) {
        return event != null && event == this.m_parent;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.m_parent == null) {
            return;
        }
        String arg = event.getActionCommand();
        this.applyMethod(arg);
        this.m_parent.update(this.m_parent);
    }

    public MenuItem addMenuItem(String menuName, String itemName) {
        if (menuName == null || itemName == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        MenuItem item = this.getMenuItem(menuName, itemName);
        if (item != null) {
            return item;
        }
        Menu menu = this.getMenu(menuName);
        if (menu == null) {
            PsDebug.warning("missing menu = " + menuName);
            return null;
        }
        item = new MenuItem(itemName);
        item.addActionListener(this);
        item.setFont(PsConfig.getFont(2));
        menu.add(item);
        return item;
    }

    public CheckboxMenuItem addMenuItem(String menuName, String itemName, boolean state) {
        if (menuName == null || itemName == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        CheckboxMenuItem item = (CheckboxMenuItem)this.getMenuItem(menuName, itemName);
        if (item != null) {
            item.setState(state);
            return item;
        }
        Menu menu = this.getMenu(menuName);
        if (menu == null) {
            PsDebug.warning("missing menu = " + menuName);
            return null;
        }
        item = new CheckboxMenuItem(itemName, state);
        item.addItemListener(this);
        item.setFont(PsConfig.getFont(2));
        menu.add(item);
        return item;
    }

    public Menu getMenu(String aLabel) {
        Menu item;
        if (aLabel == null) {
            PsDebug.warning("missing argument label");
            return null;
        }
        int noi = this.size();
        int i = 0;
        while (i < noi) {
            item = (Menu)this.elementAt(i);
            if (aLabel.equals(item.getLabel())) {
                return item;
            }
            ++i;
        }
        noi = this.m_subMenu.size();
        i = 0;
        while (i < noi) {
            item = (Menu)this.m_subMenu.elementAt(i);
            if (aLabel.equals(item.getLabel())) {
                return item;
            }
            ++i;
        }
        PsDebug.notify("menu not found = " + aLabel);
        return null;
    }

    public String getName() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public void setName(String aName) {
        if (aName == null) {
            PsDebug.warning("missing name");
            return;
        }
        this.m_name = aName;
    }

    public void init(PsObject anObject) {
        this.m_parent = anObject;
    }

    public Object clone() {
        PsMethodMenu clone = (PsMethodMenu)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_parent = null;
        clone.removeAllElements();
        return clone;
    }

    public boolean hasMenu(String aLabel) {
        return this.getMenu(aLabel) != null;
    }

    public void removeMenu(String aLabel) {
        if (aLabel == null) {
            PsDebug.warning("missing argument label");
            return;
        }
        Menu menu = this.getMenu(aLabel);
        this.removeElement(menu);
    }
}

