/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PsMainFrame
extends Frame
implements WindowListener,
Serializable {
    public static void parseArgs(String[] args, Properties props) {
        if (args == null || args.length == 0) {
            PsDebug.notify("empty argument list");
            return;
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            PsDebug.notify("arg = " + arg);
            int ind = arg.indexOf(61);
            if (ind == -1) {
                ((Hashtable)props).put("model", arg);
            } else {
                ((Hashtable)props).put(arg.substring(0, ind).toLowerCase(), arg.substring(ind + 1));
            }
            ++i;
        }
    }

    public PsMainFrame(Component comp, String title, String[] args) {
        super(title);
        if (args != null) {
            PsMainFrame.parseArgs(args, System.getProperties());
        }
        if (comp != null) {
            this.add("Center", comp);
        }
        this.enableEvents(64L);
    }

    public void windowDeactivated(WindowEvent event) {
        if (PsConfig.getViewer() != null) {
            this.removeKeyListener(PsConfig.getViewer());
        }
    }

    public PsMainFrame(String title, String[] args) {
        this(null, title, args);
    }

    public PsMainFrame(Component comp, String[] args) {
        this(comp, PsConfig.getProgram() + " v" + PsConfig.getVersion(), args);
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201) {
            this.windowClosing(event);
        } else if (event.getID() == 205) {
            this.windowActivated(event);
        } else if (event.getID() == 206) {
            this.windowDeactivated(event);
        } else if (event.getID() == 200) {
            this.windowOpened(event);
        } else if (event.getID() == 202) {
            this.windowClosed(event);
        } else if (event.getID() == 203) {
            this.windowIconified(event);
        } else if (event.getID() == 204) {
            this.windowDeiconified(event);
        }
        super.processWindowEvent(event);
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
        if (PsConfig.getViewer() != null) {
            this.addKeyListener(PsConfig.getViewer());
        }
    }

    public static String getParameter(String name) {
        return System.getProperty(name.toLowerCase());
    }

    public void setBounds(Rectangle rect) {
        Insets insets = this.getInsets();
        int ver = insets.bottom + insets.top;
        int hor = insets.left + insets.right;
        super.setBounds(new Rectangle(rect.x, rect.y, rect.width + hor, rect.height + ver));
    }

    public void windowIconified(WindowEvent event) {
    }

    public void setLocation(int x, int y) {
        if (x < 0 || x > 635) {
            x = 10;
        }
        if (y < 0 || y > 475) {
            y = 10;
        }
        super.setLocation(x, y);
    }
}

