/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;

public final class PuDouble
extends PsObject {
    protected int m_iValue;
    protected int m_numOfIncrements;
    protected static final int m_iLineIncr = 1;
    protected int m_iPageIncr;
    protected double m_shownAccuracy = 100000.0;
    private double m_defValue = 0.0;
    private double m_defMinimum = -10.0;
    private double m_defMaximum = 10.0;
    private double m_defLineIncr = 0.1;
    private double m_defPageIncr = 1.0;
    protected double m_value;
    protected double m_minimum;
    protected double m_maximum;
    protected double m_lineIncr;
    protected double m_pageIncr;
    protected boolean m_enabled = true;

    public void setValue(double aValue) {
        if (aValue <= this.m_minimum) {
            aValue = this.m_minimum;
            this.m_iValue = 0;
        } else if (this.m_maximum <= aValue) {
            aValue = this.m_maximum;
            this.m_iValue = this.m_numOfIncrements;
        } else {
            this.m_iValue = (int)((aValue - this.m_minimum) / this.m_lineIncr);
        }
        if (this.m_value == aValue) {
            return;
        }
        this.m_value = aValue;
        this.updatePanels(this);
    }

    public double getValue() {
        return this.m_value;
    }

    public double getMin() {
        return this.m_minimum;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public PuDouble(String aName, PsUpdateIf aParent) {
        this.setTag(4);
        this.setTag(7);
        this.setParent(aParent);
        this.setName(aName);
        this.init();
    }

    public void blend(double a, PuDouble v, double b, PuDouble w) {
        this.m_defValue = a * v.m_defValue + b * w.m_defValue;
        this.m_defMinimum = a * v.m_defMinimum + b * w.m_defMinimum;
        this.m_defMaximum = a * v.m_defMaximum + b * w.m_defMaximum;
        this.m_defLineIncr = a * v.m_defLineIncr + b * w.m_defLineIncr;
        this.m_defPageIncr = a * v.m_defPageIncr + b * w.m_defPageIncr;
        this.m_value = a * v.m_value + b * w.m_value;
        this.m_minimum = a * v.m_minimum + b * w.m_minimum;
        this.m_maximum = a * v.m_maximum + b * w.m_maximum;
        this.m_lineIncr = a * v.m_lineIncr + b * w.m_lineIncr;
        this.m_pageIncr = a * v.m_pageIncr + b * w.m_pageIncr;
    }

    public double getDefPageIncr() {
        return this.m_defPageIncr;
    }

    public void setDefBounds(double aMin, double aMax, double aLineIncr, double aPageIncr) {
        this.m_defMinimum = aMin;
        this.m_defMaximum = aMax;
        this.m_defLineIncr = aLineIncr;
        this.m_defPageIncr = aPageIncr;
    }

    protected void setIntValue(int aValue) {
        this.m_value = this.m_minimum + (double)aValue * this.m_lineIncr;
        this.m_iValue = aValue;
    }

    public void setDefValue(double value) {
        this.m_defValue = value;
    }

    public boolean update(Object anObject) {
        if (anObject == this.m_infoPanel) {
            return super.update(null);
        }
        return super.update(anObject);
    }

    protected void setValueFromPanel(double aValue, Object event) {
        if (aValue <= this.m_minimum) {
            this.m_value = this.m_minimum;
            this.m_iValue = 0;
            this.updatePanels(this);
        } else if (this.m_maximum <= aValue) {
            this.m_value = this.m_maximum;
            this.m_iValue = this.m_numOfIncrements;
            this.updatePanels(this);
        } else {
            this.m_iValue = (int)((aValue - this.m_minimum) / this.m_lineIncr);
            if (this.m_value == aValue) {
                return;
            }
            this.m_value = aValue;
            this.updatePanels(event);
        }
    }

    public double getDefMinimum() {
        return this.m_defMinimum;
    }

    public double getLineIncr() {
        return this.m_lineIncr;
    }

    public void copy(PuDouble num) {
        super.copy(num);
        this.m_iValue = num.m_iValue;
        this.m_numOfIncrements = num.m_numOfIncrements;
        this.m_iPageIncr = num.m_iPageIncr;
        this.m_shownAccuracy = num.m_shownAccuracy;
        this.m_defValue = num.m_defValue;
        this.m_defMinimum = num.m_defMinimum;
        this.m_defMaximum = num.m_defMaximum;
        this.m_defLineIncr = num.m_defLineIncr;
        this.m_defPageIncr = num.m_defPageIncr;
        this.m_value = num.m_value;
        this.m_minimum = num.m_minimum;
        this.m_maximum = num.m_maximum;
        this.m_lineIncr = num.m_lineIncr;
        this.m_pageIncr = num.m_pageIncr;
    }

    public double getMax() {
        return this.m_maximum;
    }

    public double getPageIncr() {
        return this.m_pageIncr;
    }

    public void setBounds(double aMin, double aMax, double aLineIncr, double aPageIncr) {
        this.m_minimum = aMin;
        this.m_maximum = aMax;
        this.m_lineIncr = aLineIncr;
        this.m_pageIncr = aPageIncr;
        this.m_numOfIncrements = (int)((this.m_maximum - this.m_minimum + aPageIncr) / this.m_lineIncr);
        this.m_iPageIncr = (int)(aPageIncr / aLineIncr);
        this.setValue(this.m_value);
    }

    public void init() {
        super.init();
        this.m_shownAccuracy = 100000.0;
        this.setBounds(this.m_defMinimum, this.m_defMaximum, this.m_defLineIncr, this.m_defPageIncr);
        this.m_value = 0.0;
        this.m_iValue = (int)((this.m_value - this.m_minimum) / this.m_lineIncr);
        this.setValue(this.m_defValue);
        this.updatePanels(this);
    }

    public void setBounds(double aMin, double aMax) {
        this.setBounds(aMin, aMax, this.m_defLineIncr, this.m_defPageIncr);
    }

    public void setEnabled(boolean flag) {
        PsDebug.notify("setEnabled(" + flag + ")");
        if (this.m_enabled == flag) {
            return;
        }
        this.m_enabled = flag;
        if (this.hasInspector("Info")) {
            this.getInspector("Info").setEnabled(flag);
        }
    }

    public double getDefMaximum() {
        return this.m_defMaximum;
    }

    public double getDefLineIncr() {
        return this.m_defLineIncr;
    }
}

