/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.io.Serializable;
import jv.object.PsDebug;

public class PuComplex
implements Cloneable,
Serializable {
    public static final PuComplex ZERO = new PuComplex(0.0, 0.0);
    public static final PuComplex ONE = new PuComplex(1.0, 0.0);
    public static final PuComplex I = new PuComplex(0.0, 1.0);
    public static final PuComplex NEG_ONE = new PuComplex(-1.0, 0.0);
    public static final PuComplex NEG_I = new PuComplex(0.0, -1.0);
    public static final PuComplex PI_OVER_4 = new PuComplex(0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI3_OVER_4 = new PuComplex(-0.7071067811865476, 0.7071067811865476);
    public static final PuComplex PI5_OVER_4 = new PuComplex(-0.7071067811865476, -0.7071067811865476);
    public static final PuComplex PI7_OVER_4 = new PuComplex(0.7071067811865476, -0.7071067811865476);
    public double re = 0.0;
    public double im = 0.0;

    public static PuComplex log(PuComplex u) {
        if (u.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            return new PuComplex(Double.NEGATIVE_INFINITY, 0.0);
        }
        return new PuComplex(Math.log(u.abs()), u.arg());
    }

    public PuComplex log() {
        if (this.abs() == 0.0) {
            PsDebug.warning("log(0) error");
            return this;
        }
        double rr = Math.log(this.abs());
        double ii = this.arg();
        this.re = rr;
        this.im = ii;
        return this;
    }

    public static PuComplex add(PuComplex u, PuComplex v) {
        PuComplex w = new PuComplex();
        w.re = u.re + v.re;
        w.im = u.im + v.im;
        return w;
    }

    public PuComplex add(PuComplex v) {
        this.re += v.re;
        this.im += v.im;
        return this;
    }

    public static PuComplex add(PuComplex u, double v) {
        PuComplex w = new PuComplex();
        w.re = u.re + v;
        w.im = u.im;
        return w;
    }

    public PuComplex add(double v) {
        this.re += v;
        return this;
    }

    public static PuComplex sqr(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = u.re * u.re - u.im * u.im;
        w.im = 2.0 * u.re * u.im;
        return w;
    }

    public PuComplex sqr() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * rr - ii * ii;
        this.im = 2.0 * rr * ii;
        return this;
    }

    public static double re(PuComplex u) {
        return u.re;
    }

    public static PuComplex exp(PuComplex u) {
        PuComplex w = new PuComplex();
        double r = Math.exp(u.re);
        w.re = r * Math.cos(u.im);
        w.im = r * Math.sin(u.im);
        return w;
    }

    public PuComplex exp() {
        double r = Math.exp(this.re);
        double f = this.im;
        this.re = r * Math.cos(f);
        this.im = r * Math.sin(f);
        return this;
    }

    public static PuComplex sqrt(PuComplex u) {
        return PuComplex.polarToRect(Math.sqrt(u.abs()), u.arg() / 2.0);
    }

    public static PuComplex polarToRect(double r, double f) {
        PuComplex w = new PuComplex();
        w.re = r * Math.cos(f);
        w.im = r * Math.sin(f);
        return w;
    }

    public PuComplex sqrt() {
        double rr = Math.sqrt(this.abs());
        double ii = this.arg() / 2.0;
        this.re = rr * Math.cos(ii);
        this.im = rr * Math.sin(ii);
        return this;
    }

    public static PuComplex pow(PuComplex u, PuComplex v) {
        if (u.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        return PuComplex.exp(PuComplex.mult(v, PuComplex.log(u)));
    }

    public static PuComplex pow(PuComplex u, double r) {
        if (u.abs() == 0.0) {
            PsDebug.warning("PuComplex.pow(0,*) called.");
            return ZERO;
        }
        return PuComplex.exp(PuComplex.mult(PuComplex.log(u), r));
    }

    public static PuComplex cosh(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = Math.cos(u.im) * (Math.exp(u.re) + Math.exp(-u.re)) / 2.0;
        w.im = Math.sin(u.im) * (Math.exp(u.re) - Math.exp(-u.re)) / 2.0;
        return w;
    }

    public boolean equals(PuComplex w, PuComplex z, double tolerance) {
        return Math.abs(w.re - z.re) < tolerance && Math.abs(w.im - z.im) < tolerance;
    }

    public boolean equals(PuComplex z, double tolerance) {
        return Math.abs(this.re - z.re) < tolerance && Math.abs(this.im - z.im) < tolerance;
    }

    public static PuComplex mult(PuComplex u, PuComplex v) {
        PuComplex w = new PuComplex();
        w.re = u.re * v.re - u.im * v.im;
        w.im = u.re * v.im + u.im * v.re;
        return w;
    }

    public PuComplex mult(PuComplex v) {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * v.re - ii * v.im;
        this.im = rr * v.im + ii * v.re;
        return this;
    }

    public static PuComplex mult(PuComplex u, double v) {
        PuComplex w = new PuComplex();
        w.re = u.re * v;
        w.im = u.im * v;
        return w;
    }

    public PuComplex mult(double v) {
        this.re *= v;
        this.im *= v;
        return this;
    }

    public static PuComplex cube(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = u.re * (u.re * u.re - 3.0 * u.im * u.im);
        w.im = u.im * (3.0 * u.re * u.re - u.im * u.im);
        return w;
    }

    public PuComplex cube() {
        double rr = this.re;
        double ii = this.im;
        this.re = rr * (rr * rr - 3.0 * ii * ii);
        this.im = ii * (3.0 * rr * rr - ii * ii);
        return this;
    }

    public static PuComplex inv(PuComplex u) {
        double nn = u.re * u.re + u.im * u.im;
        if (nn == 0.0) {
            PsDebug.warning("divide by zero");
            return new PuComplex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        PuComplex w = new PuComplex();
        w.re = u.re / nn;
        w.im = -u.im / nn;
        return w;
    }

    public PuComplex inv() {
        double nn = this.re * this.re + this.im * this.im;
        if (nn == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = Double.POSITIVE_INFINITY;
            this.im = Double.POSITIVE_INFINITY;
            return this;
        }
        this.re /= nn;
        this.im /= -nn;
        return this;
    }

    public double sqrAbs() {
        return this.re * this.re + this.im * this.im;
    }

    public static PuComplex div(PuComplex u, PuComplex v) {
        PuComplex w = new PuComplex();
        double nn = v.re * v.re + v.im * v.im;
        if (nn == 0.0) {
            PsDebug.warning("divide by zero");
            w.re = u.re > 0.0 ? Double.POSITIVE_INFINITY : (u.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            w.im = u.im > 0.0 ? Double.POSITIVE_INFINITY : (u.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return w;
        }
        w.re = (u.re * v.re + u.im * v.im) / nn;
        w.im = (u.im * v.re - u.re * v.im) / nn;
        return w;
    }

    public PuComplex div(PuComplex v) {
        double rr = this.re;
        double ii = this.im;
        double nn = v.re * v.re + v.im * v.im;
        if (nn == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re = (rr * v.re + ii * v.im) / nn;
        this.im = (ii * v.re - rr * v.im) / nn;
        return this;
    }

    public static PuComplex div(PuComplex u, double r) {
        PuComplex w = new PuComplex();
        if (r == 0.0) {
            PsDebug.warning("divide by zero");
            w.re = u.re > 0.0 ? Double.POSITIVE_INFINITY : (u.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            w.im = u.im > 0.0 ? Double.POSITIVE_INFINITY : (u.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return w;
        }
        w.re = u.re / r;
        w.im = u.im / r;
        return w;
    }

    public PuComplex div(double r) {
        if (r == 0.0) {
            PsDebug.warning("divide by zero");
            this.re = this.re > 0.0 ? Double.POSITIVE_INFINITY : (this.re < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            this.im = this.im > 0.0 ? Double.POSITIVE_INFINITY : (this.im < 0.0 ? Double.NEGATIVE_INFINITY : Double.NaN);
            return this;
        }
        this.re /= r;
        this.im /= r;
        return this;
    }

    public static PuComplex conj(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = u.re;
        w.im = -u.im;
        return w;
    }

    public PuComplex conj() {
        this.im *= -1.0;
        return this;
    }

    public static PuComplex cos(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = Math.cos(u.re) * (Math.exp(u.im) + Math.exp(-u.im)) / 2.0;
        w.im = Math.sin(u.re) * (Math.exp(u.im) - Math.exp(-u.im)) / 2.0;
        return w;
    }

    public PuComplex set(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
        return this;
    }

    public static PuComplex sin(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = Math.sin(u.re) * (Math.exp(u.im) + Math.exp(-u.im)) / 2.0;
        w.im = Math.cos(u.re) * (Math.exp(u.im) - Math.exp(-u.im)) / 2.0;
        return w;
    }

    public static PuComplex neg(PuComplex u) {
        return new PuComplex(-u.re, -u.im);
    }

    public PuComplex() {
    }

    public PuComplex(double aReal) {
        this.re = aReal;
        this.im = 0.0;
    }

    public PuComplex(PuComplex u) {
        this.re = u.re;
        this.im = u.im;
    }

    public PuComplex(double aReal, double aImag) {
        this.re = aReal;
        this.im = aImag;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public static double im(PuComplex u) {
        return u.im;
    }

    public PuComplex neg() {
        this.re = -this.re;
        this.im = -this.im;
        return this;
    }

    public static double arg(PuComplex u) {
        if (Math.abs(u.re) > Math.abs(u.im)) {
            if (u.re > 0.0) {
                if (u.im >= 0.0) {
                    return Math.atan(u.im / u.re);
                }
                return Math.atan(u.im / u.re) + Math.PI * 2;
            }
            return Math.atan(u.im / u.re) + Math.PI;
        }
        if (u.im > 0.0) {
            return 1.5707963267948966 - Math.atan(u.re / u.im);
        }
        if (u.im < 0.0) {
            return 4.71238898038469 - Math.atan(u.re / u.im);
        }
        return 0.0;
    }

    public double arg() {
        if (Math.abs(this.re) > Math.abs(this.im)) {
            if (this.re > 0.0) {
                if (this.im >= 0.0) {
                    return Math.atan(this.im / this.re);
                }
                return Math.atan(this.im / this.re) + Math.PI * 2;
            }
            return Math.atan(this.im / this.re) + Math.PI;
        }
        if (this.im > 0.0) {
            return 1.5707963267948966 - Math.atan(this.re / this.im);
        }
        if (this.im < 0.0) {
            return 4.71238898038469 - Math.atan(this.re / this.im);
        }
        return 0.0;
    }

    public static PuComplex sinh(PuComplex u) {
        PuComplex w = new PuComplex();
        w.re = Math.cos(u.im) * (Math.exp(u.re) - Math.exp(-u.re)) / 2.0;
        w.im = Math.sin(u.im) * (Math.exp(u.re) + Math.exp(-u.re)) / 2.0;
        return w;
    }

    public static PuComplex sub(PuComplex u, PuComplex v) {
        PuComplex w = new PuComplex();
        w.re = u.re - v.re;
        w.im = u.im - v.im;
        return w;
    }

    public PuComplex sub(PuComplex v) {
        this.re -= v.re;
        this.im -= v.im;
        return this;
    }

    public static PuComplex sub(PuComplex u, double v) {
        PuComplex w = new PuComplex();
        w.re = u.re - v;
        w.im = u.im;
        return w;
    }

    public PuComplex sub(double v) {
        this.re -= v;
        return this;
    }

    public PuComplex copy(PuComplex v) {
        this.re = v.re;
        this.im = v.im;
        return this;
    }

    public static double abs(PuComplex u) {
        return u.abs();
    }

    public double abs() {
        return Math.sqrt(this.re * this.re + this.im * this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }
}

