/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.objectGui.GuiStackLayout;
import jv.vecmath.PiVector;

public class PuColorPicker
extends PsPanel
implements MouseListener,
MouseMotionListener {
    private static final int m_preferredWidth = 600;
    private static final int m_preferredHeight = 230;
    protected PuInteger m_red;
    protected PuInteger m_green;
    protected PuInteger m_blue;
    protected PuInteger m_bright;
    protected int m_wheelXPos = 0;
    protected int m_wheelYPos = 0;
    protected int m_wheelWidth = 176;
    protected int m_wheelHeight = 176;
    protected PsPanel m_pWheel;
    protected PsPanel m_pDefColor;
    protected PsPanel m_pNewColor;
    protected Color m_defColor;
    protected Color m_undimmedColor;
    protected PiVector m_pix;
    private static /* synthetic */ Class class$jv$number$PuColorPicker;

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        Object source = event.getSource();
        if (source == this.m_pWheel) {
            this.setColor(this.colorAt(event.getX(), event.getY()));
        } else if (source == this.m_pDefColor) {
            this.m_bright.setValue(100);
            this.setDimmedColor(this.m_defColor, 100);
        }
    }

    public void mouseDragged(MouseEvent event) {
        this.mousePressed(event);
    }

    public static Image getWheel(int imgWidth, int imgHeight, int brightness, int[] pix) {
        if (pix == null) {
            pix = new int[imgWidth * imgHeight];
        }
        int ind = 0;
        int xCenter = imgWidth / 2;
        int yCenter = imgHeight / 2;
        int imgDiam = xCenter;
        int transp = -16777216;
        int pixelWhite = transp | 0xFF0000 | 0xFF00 | 0xFF;
        int pixelLightGrey = transp | 0xC00000 | 0xC000 | 0xC0;
        int pixelDarkGrey = transp | 0x550000 | 0x5500 | 0x55;
        int pixelBlack = transp;
        int yDist = yCenter;
        int j = 0;
        while (j < imgHeight) {
            int xDist = -xCenter;
            int i = 0;
            while (i < imgWidth) {
                int pixel;
                if (imgDiam == 0) {
                    pixel = pixelWhite;
                } else {
                    int radius = (int)(256.0 * Math.sqrt(xDist * xDist + yDist * yDist) / (double)imgDiam);
                    int angle = (int)(255.0 * (Math.atan2(-yDist, -xDist) + Math.PI) / (Math.PI * 2));
                    if (radius > 255) {
                        pixel = xDist < 0 && yDist > 0 ? pixelWhite : (xDist > 0 && yDist > 0 ? pixelLightGrey : (xDist < 0 && yDist < 0 ? pixelDarkGrey : pixelBlack));
                    } else {
                        Color color = PdColor.hsv2rgb(angle, radius, brightness);
                        int red = color.getRed();
                        int green = color.getGreen();
                        int blue = color.getBlue();
                        pixel = transp | red << 16 | green << 8 | blue;
                    }
                }
                pix[ind++] = pixel;
                ++xDist;
                ++i;
            }
            --yDist;
            ++j;
        }
        Image m_destImage = PsConfig.getFrame().createImage(new MemoryImageSource(imgWidth, imgHeight, pix, 0, imgWidth));
        return m_destImage;
    }

    public PuColorPicker(Color initColor) {
        this.setLayout(new GuiStackLayout(0));
        if (initColor == null) {
            initColor = Color.white;
        }
        this.m_defColor = initColor;
        this.m_pWheel = new PsPanel();
        this.m_pWheel.setBorderType(2);
        this.m_pWheel.setSize(this.m_wheelWidth, this.m_wheelHeight);
        this.m_pix = new PiVector(this.m_wheelWidth * this.m_wheelHeight);
        this.m_pWheel.setImage(PuColorPicker.getWheel(this.m_wheelWidth, this.m_wheelHeight, 255, this.m_pix.m_data));
        this.m_pWheel.addMouseListener(this);
        this.m_pWheel.addMouseMotionListener(this);
        this.add(this.m_pWheel);
        PsPanel pColors = new PsPanel();
        pColors.setLayout(new PsStackLayout(10));
        this.m_pDefColor = new PsPanel();
        this.m_pDefColor.addMouseListener(this);
        this.m_pDefColor.setLayout(null);
        this.m_pDefColor.setBorderType(3);
        this.m_pDefColor.setSize(40, 60);
        this.m_pDefColor.setBackground(this.m_defColor);
        pColors.add(this.m_pDefColor);
        this.m_pNewColor = new PsPanel();
        this.m_pNewColor.setLayout(null);
        this.m_pNewColor.setBorderType(3);
        this.m_pNewColor.setSize(40, 60);
        this.m_pNewColor.setBackground(this.m_defColor);
        pColors.add(this.m_pNewColor);
        this.add(pColors);
        PsPanel pWidget = new PsPanel();
        pWidget.setLayout(new PsStackLayout(3));
        pWidget.addTitle(PsConfig.getMessage("ColorPicker"));
        this.m_red = new PuInteger(PsConfig.getMessage("Red"), this);
        pWidget.add(this.m_red.getInfoPanel());
        this.m_green = new PuInteger(PsConfig.getMessage("Green"), this);
        pWidget.add(this.m_green.getInfoPanel());
        this.m_blue = new PuInteger(PsConfig.getMessage("Blue"), this);
        pWidget.add(this.m_blue.getInfoPanel());
        pWidget.addLine(1);
        this.m_bright = new PuInteger(PsConfig.getMessage("Brightness"), this);
        pWidget.add(this.m_bright.getInfoPanel());
        pWidget.addLine(1);
        this.add("Wide", pWidget);
        this.validate();
        if (this.getClass() == (class$jv$number$PuColorPicker != null ? class$jv$number$PuColorPicker : (class$jv$number$PuColorPicker = PuColorPicker.class$("jv.number.PuColorPicker")))) {
            this.init();
        }
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseMoved(MouseEvent event) {
    }

    private Color colorAt(int x, int y) {
        if (this.m_pix == null || this.m_pix.getSize() == 0) {
            PsDebug.warning("missing or empty pixel array m_pix");
            return null;
        }
        if (x < 0) {
            x = 0;
        }
        if (x >= this.m_wheelWidth) {
            x = this.m_wheelWidth - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.m_wheelHeight) {
            y = this.m_wheelHeight - 1;
        }
        int i = this.m_pix.getEntry(x + y * this.m_wheelHeight);
        return new Color(i);
    }

    public Color getColor() {
        return this.m_pNewColor.getBackground();
    }

    public void setColor(Color rgbColor) {
        this.m_undimmedColor = rgbColor;
        this.m_red.setValue(rgbColor.getRed());
        this.m_green.setValue(rgbColor.getGreen());
        this.m_blue.setValue(rgbColor.getBlue());
        this.m_pNewColor.setBackground(rgbColor);
        this.m_pNewColor.repaint();
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
    }

    public boolean update(Object event) {
        if (event == this.m_red || event == this.m_green || event == this.m_blue) {
            if (this.m_bright.getValue() != 100) {
                this.m_bright.setValue(100);
                this.setDimmedColor(this.getColor(), 100);
                return true;
            }
            this.setColor(new Color(this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue()));
            return true;
        }
        if (event == this.m_bright) {
            this.setDimmedColor(this.m_undimmedColor, this.m_bright.getValue());
            return true;
        }
        return super.update(event);
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public Color getDefColor() {
        return this.m_defColor;
    }

    public void setDefColor(Color rgbColor) {
        this.m_defColor = rgbColor;
    }

    protected void setDimmedColor(Color rgbColor, int brightness) {
        double d = Math.sqrt((double)brightness / 100.0);
        int red = (int)((double)rgbColor.getRed() * d);
        int green = (int)((double)rgbColor.getGreen() * d);
        int blue = (int)((double)rgbColor.getBlue() * d);
        this.m_pWheel.setImage(PuColorPicker.getWheel(this.m_wheelWidth, this.m_wheelHeight, (int)(255.0 * d), this.m_pix.m_data));
        this.m_pWheel.repaint();
        this.m_red.setValue(red);
        this.m_green.setValue(green);
        this.m_blue.setValue(blue);
        this.m_pNewColor.setBackground(new Color(red, green, blue));
        this.m_pNewColor.repaint();
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 230);
    }

    public void init() {
        super.init();
        this.m_red.setDefBounds(0, 255, 1, 10);
        this.m_red.setDefValue(this.m_defColor.getRed());
        this.m_red.init();
        this.m_green.setDefBounds(0, 255, 1, 10);
        this.m_green.setDefValue(this.m_defColor.getGreen());
        this.m_green.init();
        this.m_blue.setDefBounds(0, 255, 1, 10);
        this.m_blue.setDefValue(this.m_defColor.getBlue());
        this.m_blue.init();
        this.m_bright.setDefBounds(0, 100, 1, 10);
        this.m_bright.setDefValue(100);
        this.m_bright.init();
        this.setColor(this.m_defColor);
    }
}

