/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PuData;

public final class PdColor
extends PsObject {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private static final int m_numDefColors = 3;
    protected boolean m_hasAlpha;
    protected int[] m_data;
    protected boolean m_enabled = true;

    public static Color rgb2hsl(int ri, int gi, int bi) {
        double h;
        double s;
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double min = Math.min(Math.min(r, g), b);
        double max = Math.max(Math.max(r, g), b);
        double l = (max + min) / 2.0;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            s = l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min);
            double delta = max - min;
            h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
            if ((h /= 6.0) < 0.0) {
                h += 1.0;
            }
        }
        return new Color((int)(h * 255.0), (int)(l * 255.0), (int)(s * 255.0));
    }

    public int getRed() {
        if (this.getSize() == 3) {
            return this.m_data[0];
        }
        return 0;
    }

    public int getEntry(int ind) {
        if (ind < 0 || this.getSize() <= ind) {
            PsDebug.warning("index=" + ind + " out of range");
            return 0;
        }
        return this.m_data[ind];
    }

    public void setEntry(int ind, int value) {
        if (ind < 0 || this.getSize() <= ind) {
            PsDebug.warning("index=" + ind + " out of range");
            return;
        }
        this.m_data[ind] = value;
    }

    public int indexOfMax() {
        int index = 0;
        int max = 0;
        int numColors = this.getSize();
        int i = 0;
        while (i < numColors) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static void hsv2rgb(PdColor rgb, PdColor hsv) {
        Color _rgb = PdColor.hsv2rgb(hsv.m_data[0], hsv.m_data[1], hsv.m_data[2]);
        rgb.setColor(_rgb);
    }

    public static Color hsv2rgb(Color hsv) {
        return PdColor.hsv2rgb(hsv.getRed(), hsv.getGreen(), hsv.getBlue());
    }

    public static Color hsv2rgb(int h, int s, int v) {
        if (s == 0) {
            return new Color(v, v, v);
        }
        float f = (float)((double)h * 6.0 / 256.0);
        int i = (int)f;
        float ds = (float)((double)(v * s) / 255.0);
        int p = (int)((float)v - ds);
        int q = (int)((float)v - (f -= (float)i) * ds);
        int t = (int)((double)v - (1.0 - (double)f) * (double)ds);
        switch (i) {
            case 0: {
                return new Color(v, t, p);
            }
            case 1: {
                return new Color(q, v, p);
            }
            case 2: {
                return new Color(p, v, t);
            }
            case 3: {
                return new Color(p, q, v);
            }
            case 4: {
                return new Color(t, p, v);
            }
            case 5: {
                return new Color(v, p, q);
            }
        }
        return new Color(0, 0, 0);
    }

    private static double value(double n1, double n2, double hue) {
        if (hue < 0.0) {
            hue += 360.0;
        }
        if (hue > 360.0) {
            hue -= 360.0;
        }
        if (hue < 60.0) {
            return n1 + (n2 - n1) * hue / 60.0;
        }
        if (hue < 180.0) {
            return n2;
        }
        if (hue < 240.0) {
            return n1 + (n2 - n1) * (240.0 - hue) / 60.0;
        }
        return n1;
    }

    public int getBlue() {
        if (this.getSize() == 3) {
            return this.m_data[2];
        }
        return 0;
    }

    public static Color hsl2rgb(int hi, int li, int si) {
        double b;
        double g;
        double r;
        double h = (double)hi / 255.0 * 360.0;
        double l = (double)li / 255.0;
        double s = (double)si / 255.0;
        double m2 = l < 0.5 ? l * (1.0 + s) : l + s - l * s;
        double m1 = 2.0 * l - m2;
        if (s == 0.0) {
            r = l;
            g = l;
            b = l;
        } else {
            r = PdColor.value(m1, m2, h + 120.0);
            g = PdColor.value(m1, m2, h);
            b = PdColor.value(m1, m2, h - 120.0);
        }
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public boolean equals(Color col) {
        int len = this.getSize();
        if (col == null && len == 0) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (len < 3) {
            return false;
        }
        if (this.getRed() != col.getRed()) {
            return false;
        }
        if (this.getGreen() != col.getGreen()) {
            return false;
        }
        return this.getBlue() == col.getBlue();
    }

    public boolean equals(PdColor col) {
        int len = this.getSize();
        if (col == null && len == 0) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (len != col.getSize()) {
            return false;
        }
        --len;
        while (len >= 0) {
            if (this.m_data[len] != col.m_data[len]) {
                return false;
            }
            --len;
        }
        return true;
    }

    public static PdColor copyNew(PdColor v) {
        if (v == null) {
            PsDebug.warning("missing argument color");
            return null;
        }
        PdColor newColor = new PdColor(v.getSize(), v.hasAlpha());
        newColor.copy(v);
        return newColor;
    }

    public static PdColor[] copyNew(PdColor[] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdColor.copyNew(data, data.length);
    }

    public static Color getDimmedColor(Color col, double dim) {
        if (dim == 1.0) {
            return col;
        }
        if (dim <= 0.0) {
            return Color.black;
        }
        int rgb = col.getRGB();
        int red = (int)(dim * (double)(rgb >> 16 & 0xFF));
        int green = (int)(dim * (double)(rgb >> 8 & 0xFF));
        int blue = (int)(dim * (double)(rgb & 0xFF));
        if (dim > 1.0) {
            if (red > 255) {
                red = 255;
            }
            if (green > 255) {
                green = 255;
            }
            if (blue > 255) {
                blue = 255;
            }
        }
        return new Color(red, green, blue);
    }

    public static Color getDimmedColor(Color col, double dim, double offset) {
        int rgb = col.getRGB();
        int red = (int)(offset + dim * (double)(rgb >> 16 & 0xFF));
        int green = (int)(offset + dim * (double)(rgb >> 8 & 0xFF));
        int blue = (int)(offset + dim * (double)(rgb & 0xFF));
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }

    public static PdColor[] copyNew(PdColor[] data, int size) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdColor[] newData = new PdColor[size];
        int i = 0;
        while (i < size) {
            PdColor cfr_ignored_0 = newData[i];
            PdColor.copyNew(data[i]);
            ++i;
        }
        return newData;
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        if (this.hasAlpha()) {
            return this.m_data.length - 1;
        }
        return this.m_data.length;
    }

    public void setSize(int aSize) {
        if (this.hasAlpha()) {
            ++aSize;
        }
        if (this.m_data != null && this.m_data.length == aSize) {
            return;
        }
        this.m_data = PuData.realloc(this.m_data, aSize);
    }

    public int getGrey() {
        if (this.getSize() == 1) {
            return this.m_data[0];
        }
        return 0;
    }

    public void blendBase(PdColor v, double b, PdColor w) {
        this.blend(1.0, v, b, w);
    }

    public Object clone() {
        PdColor clone = (PdColor)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_data = (int[])this.m_data.clone();
        return clone;
    }

    public int min() {
        int min = 255;
        int numColors = this.getSize();
        int i = 0;
        while (i < numColors) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
            }
            ++i;
        }
        return min;
    }

    public boolean hasAlpha() {
        return this.m_hasAlpha;
    }

    public void set(int grey) {
        if (this.getSize() < 1) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = grey;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void set(int red, int green, int blue) {
        if (this.getSize() < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return;
        }
        this.m_data[0] = red;
        this.m_data[1] = green;
        this.m_data[2] = blue;
    }

    public void set(int red, int green, int blue, int alpha) {
        this.set(red, green, blue);
        this.setAlpha(alpha);
    }

    public void set(double grey) {
        this.set((int)(255.0 * grey));
    }

    public PdColor() {
        this(3, false);
    }

    public PdColor(int size, boolean bAlpha) {
        this.enableAlpha(bAlpha);
        this.setSize(size);
        this.init();
    }

    public PdColor(String aName, PsUpdateIf aParent) {
        this.setName(aName);
        this.setParent(aParent);
        this.enableAlpha(false);
        this.setSize(3);
        this.init();
    }

    public Color getColor() {
        if (this.getSize() < 3) {
            PsDebug.warning("too small number of components == " + this.getSize());
            return null;
        }
        return new Color(this.m_data[0], this.m_data[1], this.m_data[2]);
    }

    public void setColor(Color aColor) {
        if (aColor == null) {
            PsDebug.warning("missing aColor");
            return;
        }
        int rgb = aColor.getRGB();
        this.set(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        if (this.hasInspector("Info")) {
            this.getInspector("Info").update(this);
        }
    }

    public void set(double red, double green, double blue) {
        this.set((int)(255.0 * red), (int)(255.0 * green), (int)(255.0 * blue));
    }

    public void set(double red, double green, double blue, double alpha) {
        this.set((int)(255.0 * red), (int)(255.0 * green), (int)(255.0 * blue));
        this.setAlpha((int)(255.0 * alpha));
    }

    public int max() {
        int max = 0;
        int numColors = this.getSize();
        int i = 0;
        while (i < numColors) {
            if (this.m_data[i] > max) {
                max = this.m_data[i];
            }
            ++i;
        }
        return max;
    }

    public static Color blend(double a, Color v, double b, Color w) {
        return new Color((int)(a * (double)v.getRed() + b * (double)w.getRed()), (int)(a * (double)v.getGreen() + b * (double)w.getGreen()), (int)(a * (double)v.getBlue() + b * (double)w.getBlue()));
    }

    public void blend(double a, PdColor v, double b, PdColor w) {
        int i = 0;
        while (i < this.m_data.length) {
            int newCol = (int)((double)v.m_data[i] * a + (double)w.m_data[i] * b);
            this.m_data[i] = newCol <= 0 ? 0 : (newCol >= 255 ? 255 : newCol);
            ++i;
        }
    }

    public static void rgb2hsv(PdColor hsv, PdColor rgb) {
        int max = rgb.max();
        int min = rgb.min();
        hsv.m_data[2] = max;
        hsv.m_data[1] = max == 0 ? 0 : (int)((double)(max - min) * 255.0 / (double)max);
        if (hsv.m_data[1] == 0) {
            hsv.m_data[0] = 0;
        } else {
            double h = 0.0;
            double delta = max - min;
            h = rgb.m_data[0] == max ? (double)(rgb.m_data[1] - rgb.m_data[2]) / delta : (rgb.m_data[1] == max ? 2.0 + (double)(rgb.m_data[2] - rgb.m_data[0]) / delta : 4.0 + (double)(rgb.m_data[0] - rgb.m_data[1]) / delta);
            if ((h *= 60.0) < 0.0) {
                h += 360.0;
            }
            hsv.m_data[0] = (int)h;
        }
    }

    public void copy(PdColor v) {
        if (v == null) {
            PsDebug.warning("missing argument color");
            return;
        }
        int vSize = v.getSize();
        if (this.m_data != null && this.getSize() != vSize) {
            PsDebug.warning("argument color has different size");
            return;
        }
        if (this.hasAlpha() != v.hasAlpha()) {
            this.enableAlpha(v.hasAlpha());
        }
        if (this.m_data == null) {
            this.setSize(vSize);
        }
        System.arraycopy(v.m_data, 0, this.m_data, 0, vSize);
        super.copy(v);
    }

    public void copy(int[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(aSize);
        }
        if (this.getSize() != aSize) {
            PsDebug.warning("missing space in destination");
            return;
        }
        System.arraycopy(this.m_data, 0, anArray, 0, aSize);
    }

    public void copy(double[] anArray, int aSize) {
        if (anArray == null) {
            PsDebug.warning("missing argument array");
            return;
        }
        if (this.m_data == null) {
            this.setSize(aSize);
        }
        if (this.getSize() != aSize) {
            PsDebug.warning("missing space in destination");
            return;
        }
        int i = 0;
        while (i < aSize) {
            this.m_data[i] = (int)(255.0 * anArray[i]);
            ++i;
        }
    }

    public static boolean copy(Color[] dataDest, int destInd, Color[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i] = dataSrc[srcInd + i];
            ++i;
        }
        return true;
    }

    public int getAlpha() {
        if (!this.hasAlpha()) {
            return 0;
        }
        return this.m_data[this.getSize()];
    }

    public void enableAlpha(boolean aValue) {
        if (this.m_hasAlpha == aValue) {
            return;
        }
        int numComp = this.getSize();
        this.m_hasAlpha = aValue;
        this.setSize(numComp);
    }

    public void setAlpha(int x) {
        if (!this.hasAlpha()) {
            PsDebug.warning("alpha not enabled");
            return;
        }
        this.m_data[this.getSize()] = x;
    }

    public void setAlpha(double x) {
        this.setAlpha((int)(255.0 * x));
    }

    public static boolean copy(PdColor[] dataDest, int destInd, PdColor[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.warning("missing space in dataDest");
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i].copy(dataSrc[srcInd + i]);
            ++i;
        }
        return true;
    }

    public static Color yiq2rgb(int yi, int ii, int qi) {
        double y = (double)yi / 255.0;
        double i = ((double)ii / 255.0 * 2.0 - 1.0) * 0.596;
        double q = ((double)qi / 255.0 * 2.0 - 1.0) * 0.522;
        double r = Math.min(1.0, Math.max(0.0, y + 0.956 * i + 0.623 * q));
        double g = Math.min(1.0, Math.max(0.0, y - 0.272 * i - 0.648 * q));
        double b = Math.min(1.0, Math.max(0.0, y - 1.105 * i + 0.705 * q));
        return new Color((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }

    public void init() {
        super.init();
        this.setConstant(0);
    }

    public void setEnabled(boolean flag) {
        PsDebug.notify("setEnabled(" + flag + ")");
        if (this.m_enabled == flag) {
            return;
        }
        this.m_enabled = flag;
        if (this.hasInspector("Info")) {
            this.getInspector("Info").setEnabled(flag);
        }
    }

    public int getGreen() {
        if (this.getSize() == 3) {
            return this.m_data[1];
        }
        return 0;
    }

    public void setConstant(int val) {
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = val;
            ++i;
        }
    }

    public int indexOfMin() {
        int index = 0;
        int min = 255;
        int numColors = this.getSize();
        int i = 0;
        while (i < numColors) {
            if (this.m_data[i] < min) {
                min = this.m_data[i];
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static Color rgb2yiq(int ri, int gi, int bi) {
        double r = (double)ri / 255.0;
        double g = (double)gi / 255.0;
        double b = (double)bi / 255.0;
        double y = 0.299 * r + 0.587 * g + 0.114 * b;
        double i = 0.596 * r - 0.274 * g - 0.322 * b;
        double q = 0.211 * r - 0.522 * g + 0.311 * b;
        i = (i / 0.596 + 1.0) / 2.0;
        q = (q / 0.522 + 1.0) / 2.0;
        return new Color((int)(y * 255.0), (int)(i * 255.0), (int)(q * 255.0));
    }

    public static Color parseColor(String colorString) {
        if (colorString == null) {
            PsDebug.warning("missing color string.");
            return null;
        }
        try {
            String[] comp = PuString.splitString(colorString, ' ');
            int r = Integer.parseInt(comp[0]);
            int g = Integer.parseInt(comp[1]);
            int b = Integer.parseInt(comp[2]);
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format in color = " + colorString);
            return null;
        }
    }

    public static Color[] realloc(Color[] data, int arraySize) {
        if (data != null && data.length == arraySize) {
            return data;
        }
        Color[] newData = new Color[arraySize];
        int commonSize = 0;
        if (data != null && (commonSize = Math.min(data.length, arraySize)) != 0) {
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = commonSize;
        while (i < arraySize) {
            newData[i] = Color.black;
            ++i;
        }
        return newData;
    }

    public static PdColor[] realloc(PdColor[] data, int arraySize, int colorSize) {
        return PdColor.realloc(data, arraySize, colorSize, false);
    }

    public static PdColor[] realloc(PdColor[] data, int arraySize, int colorSize, boolean bAlpha) {
        int commonSize;
        if (data != null && data.length == arraySize) {
            int j = 0;
            while (j < data.length) {
                data[j].enableAlpha(bAlpha);
                data[j].setSize(colorSize);
                ++j;
            }
            return data;
        }
        PdColor[] newData = new PdColor[arraySize];
        if (data == null) {
            commonSize = 0;
        } else {
            commonSize = Math.min(data.length, arraySize);
            System.arraycopy(data, 0, newData, 0, commonSize);
        }
        int i = 0;
        while (i < commonSize) {
            if (newData[i].hasAlpha() != bAlpha) {
                newData[i].enableAlpha(bAlpha);
            }
            if (newData[i].getSize() != colorSize) {
                newData[i].setSize(colorSize);
            }
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdColor(colorSize, bAlpha);
            ++i;
        }
        return newData;
    }
}

