/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import jv.loader.PgLoaderIf;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxLoader
implements PgLoaderIf {
    protected boolean m_bIsAnimation = false;
    protected static boolean m_bIsEnabledSmallSize = false;
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    protected static void setEnabledSmallSize(boolean flag) {
        m_bIsEnabledSmallSize = flag;
    }

    protected static PgJvxSrc[] parseRsrcTree(PsXmlSrc src) {
        String strVersion = null;
        String strVersionType = null;
        String strTitle = null;
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode version = PsXmlSrc.getRsrcNode(root, "version");
        if (version == null) {
            PsDebug.warning("missing version information, using default.");
            strVersion = "0.0";
            strVersionType = "dump";
        } else {
            strVersion = version.getContent();
            strVersionType = version.getAttribute("type");
        }
        strTitle = PsXmlSrc.getRsrc(root, "title");
        PsXmlNode authors = PsXmlSrc.getRsrcNode(root, "authors");
        PsAuthorInfo authorInfo = null;
        if (authors != null) {
            authorInfo = new PsAuthorInfo();
            authorInfo.setXmlNode(authors);
        }
        PsXmlNode description = PsXmlSrc.getRsrcNode(root, "description");
        PsGeometryInfo geometryInfo = null;
        if (description != null) {
            geometryInfo = new PsGeometryInfo();
            geometryInfo.setXmlNode(description, null);
        }
        PgJvxSrc[] m_geom = null;
        String[] attr = new String[]{"tag", "name"};
        PsXmlNode geometries = PsXmlSrc.getRsrcNode(root, "geometries");
        if (geometries != null) {
            PsXmlNode[] geometry = PsXmlSrc.getRsrcNodes(geometries, "geometry");
            if (geometry == null || geometry.length == 0) {
                return null;
            }
            m_geom = new PgJvxSrc[geometry.length];
            int i = 0;
            while (i < geometry.length) {
                PsXmlNode[] vectorField;
                PsXmlNode faceSet;
                PsXmlNode lineSet;
                String s;
                PdVector[] dList;
                PsXmlNode normals;
                Color[] cList;
                PsXmlNode colors;
                PiVector labelAtt;
                PgJvxSrc geom = new PgJvxSrc();
                if (authorInfo != null) {
                    geom.setAuthorInfo(authorInfo);
                }
                if (geometryInfo != null) {
                    geom.setGeometryInfo(geometryInfo);
                }
                m_geom[i] = geom;
                geom.setVersion(strVersion);
                geom.setVersionType(strVersionType);
                geom.setTitle(strTitle);
                geom.setName(geometry[i].getAttribute("name"));
                geom.setVisible(PgJvxLoader.parseVisibility(geometry[i].getAttribute("visible")) != 0);
                PsXmlNode[] labelAttNode = geometry[i].getChildren("labelAtt");
                if (labelAttNode != null && labelAttNode.length > 0 && labelAttNode[0] != null && (labelAtt = PgJvxLoader.parseLabelAtt(labelAttNode[0])) != null) {
                    geom.setLabelAttribute(5, labelAtt);
                    geom.showTitle(labelAtt.getEntry(5) == 1);
                }
                Color c = null;
                double d = 0.0;
                PsXmlNode pointSet = PsXmlSrc.getRsrcNode(geometry[i], "pointSet");
                if (pointSet != null) {
                    PsXmlNode textures;
                    String dimStr = pointSet.getAttribute("dim");
                    if (dimStr == null) {
                        PsDebug.warning("missing dimension of geometry[" + i + "]");
                        return null;
                    }
                    geom.setDimOfVertices(Integer.parseInt(dimStr));
                    geom.showVertices(PgJvxLoader.parseVisibility(pointSet.getAttribute("point")) != 0);
                    geom.showVertexNormals(PgJvxLoader.parseVisibility(pointSet.getAttribute("normal")) == 1);
                    geom.showVertexNormalArrow(PgJvxLoader.parseVisibility(pointSet.getAttribute("normalArrow")) == 1);
                    geom.showVertexColors(PgJvxLoader.parseVisibility(pointSet.getAttribute("color")) == 1);
                    geom.setType(30);
                    PsXmlNode points = PsXmlSrc.getRsrcNode(pointSet, "points");
                    if (points != null) {
                        PdVector[] vertex = PsXmlLoader.parseDoubleList(points, "p", attr);
                        if (vertex != null) {
                            geom.setDimOfVertices(vertex[0].getSize());
                            geom.setNumVertices(vertex.length);
                            geom.setVertices(vertex);
                        } else {
                            String[][] fun = PgJvxLoader.parseFunList(points, "pf", attr);
                            if (fun != null) {
                                geom.setDimOfVertices(fun[0].length);
                                geom.setNumVertices(fun.length);
                                geom.setVertexFunctions(fun);
                            }
                        }
                        if (points.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(points, "thickness");
                            geom.setGlobalVertexSize(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(points, "color")) != null) {
                            geom.setGlobalVertexColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(points, "colorTag")) != null) {
                            geom.setGlobalVertexTagColor(c);
                        }
                        if ((labelAtt = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(points, "labelAtt"))) != null) {
                            geom.setLabelAttribute(0, labelAtt);
                            geom.showVertexLabels(labelAtt.getEntry(5) == 1);
                        }
                    }
                    if ((colors = PsXmlSrc.getRsrcNode(pointSet, "colors")) != null && (cList = PsXmlLoader.parseColorList(colors, "c")) != null) {
                        geom.setVertexColors(cList);
                    }
                    if ((normals = PsXmlSrc.getRsrcNode(pointSet, "normals")) != null) {
                        dList = PsXmlLoader.parseDoubleList(normals, "n", null);
                        if (dList != null) {
                            geom.setVertexNormals(dList);
                        }
                        if (normals.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals, "thickness");
                            geom.setGlobalVertexNormalSize(d);
                        }
                        if (normals.hasChild("length")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals, "length");
                            geom.setGlobalVertexNormalLength(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(normals, "color")) != null) {
                            geom.setGlobalVertexNormalColor(c);
                        }
                    }
                    if ((textures = PsXmlSrc.getRsrcNode(pointSet, "textures")) != null) {
                        PsXmlNode image;
                        geom.showVertexTexture(PgJvxLoader.parseVisibility(pointSet.getAttribute("texture")) == 1);
                        String textureType = textures.getAttribute("type");
                        if (textureType == null || textureType.equals("image")) {
                            // empty if block
                        }
                        if ((dList = PsXmlLoader.parseDoubleList(textures, "t", null)) != null) {
                            geom.setVertexTextures(dList);
                        }
                        if ((s = (image = PsXmlSrc.getRsrcNode(textures, "image")).getContent()) != null) {
                            String repeat = image.getAttribute("repeat");
                            if (repeat != null && !"no".equals(repeat)) {
                                PsDebug.warning("repeat mode in images not supported yet.");
                            }
                            geom.setTextureImageName(s);
                        }
                    }
                }
                if ((lineSet = PsXmlSrc.getRsrcNode(geometry[i], "lineSet")) != null) {
                    geom.showPolygonStartArrow(PgJvxLoader.parseVisibility(lineSet.getAttribute("startArrow")) == 1);
                    geom.showPolygonEndArrow(PgJvxLoader.parseVisibility(lineSet.getAttribute("arrow")) == 1);
                    geom.showPolygons(PgJvxLoader.parseVisibility(lineSet.getAttribute("line")) != 0);
                    geom.showPolygonNormals(PgJvxLoader.parseVisibility(lineSet.getAttribute("normal")) == 1);
                    geom.showPolygonNormalArrow(PgJvxLoader.parseVisibility(lineSet.getAttribute("normalArrow")) == 1);
                    geom.showPolygonColors(PgJvxLoader.parseVisibility(lineSet.getAttribute("color")) == 1);
                    geom.setType(32);
                    PsXmlNode lines = PsXmlSrc.getRsrcNode(lineSet, "lines");
                    if (lines != null) {
                        PiVector[] polygon = PsXmlLoader.parseIntegerList(lines, "l", attr);
                        if (polygon != null) {
                            geom.setDimOfPolygons(-1);
                            geom.setNumPolygons(polygon.length);
                            geom.setPolygons(polygon);
                        }
                        if (lines.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(lines, "thickness");
                            geom.setGlobalPolygonSize(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(lines, "color")) != null) {
                            geom.setGlobalPolygonColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(lines, "colorTag")) != null) {
                            geom.setGlobalPolygonTagColor(c);
                        }
                        if ((labelAtt = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(lines, "labelAtt"))) != null) {
                            geom.setLabelAttribute(2, labelAtt);
                            geom.showPolygonLabels(labelAtt.getEntry(5) == 1);
                        }
                    }
                    if ((colors = PsXmlSrc.getRsrcNode(lineSet, "colors")) != null && (cList = PsXmlLoader.parseColorList(colors, "c")) != null) {
                        geom.setPolygonColors(cList);
                    }
                    if ((normals = PsXmlSrc.getRsrcNode(lineSet, "normals")) != null) {
                        dList = PsXmlLoader.parseDoubleList(normals, "n", null);
                        if (dList != null) {
                            geom.setPolygonNormals(dList);
                        }
                        if (normals.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals, "thickness");
                            geom.setGlobalPolygonNormalSize(d);
                        }
                        if (normals.hasChild("length")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals, "length");
                            geom.setGlobalPolygonNormalLength(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(normals, "color")) != null) {
                            geom.setGlobalPolygonNormalColor(c);
                        }
                    }
                }
                if ((faceSet = PsXmlSrc.getRsrcNode(geometry[i], "faceSet")) != null) {
                    PsXmlNode boundaries;
                    PsXmlNode normals2;
                    PsXmlNode backColors;
                    PsXmlNode colors2;
                    PsXmlNode edges;
                    PiVector[] neighbour;
                    PsXmlNode neighbours;
                    geom.showElements(PgJvxLoader.parseVisibility(faceSet.getAttribute("face")) != 0);
                    geom.showEdges(PgJvxLoader.parseVisibility(faceSet.getAttribute("edge")) != 0);
                    geom.showElementNormals(PgJvxLoader.parseVisibility(faceSet.getAttribute("normal")) == 1);
                    geom.showElementNormalArrow(PgJvxLoader.parseVisibility(faceSet.getAttribute("normalArrow")) == 1);
                    geom.showElementColors(PgJvxLoader.parseVisibility(faceSet.getAttribute("color")) == 1);
                    geom.showElementBackColor(PgJvxLoader.parseVisibility(faceSet.getAttribute("colorBackGlobal")) == 1);
                    geom.showElementBackColors(PgJvxLoader.parseVisibility(faceSet.getAttribute("colorBackLocal")) == 1);
                    geom.showVertexTexture(PgJvxLoader.parseVisibility(faceSet.getAttribute("texture")) == 1);
                    geom.showElementTexture(PgJvxLoader.parseVisibility(faceSet.getAttribute("texture")) == 1);
                    boolean bShowBackface = PgJvxLoader.parseVisibility(faceSet.getAttribute("backface")) != 0;
                    geom.showBackface(bShowBackface);
                    geom.showBoundaries(PgJvxLoader.parseVisibility(faceSet.getAttribute("boundary")) == 1);
                    geom.showOutline(PgJvxLoader.parseVisibility(faceSet.getAttribute("outline")) == 1);
                    geom.setType(33);
                    PsXmlNode faces = PsXmlSrc.getRsrcNode(faceSet, "faces");
                    if (faces != null) {
                        PiVector[] element = PsXmlLoader.parseIntegerList(faces, "f", attr);
                        if (element != null) {
                            geom.setDimOfElements(-1);
                            geom.setNumElements(element.length);
                            geom.setElements(element);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(faces, "color")) != null) {
                            geom.setGlobalElementColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(faces, "colorBack")) != null) {
                            geom.setGlobalElementBackColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(faces, "colorTag")) != null) {
                            geom.setGlobalElementTagColor(c);
                        }
                        if ((labelAtt = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(faces, "labelAtt"))) != null) {
                            geom.setLabelAttribute(3, labelAtt);
                            geom.showElementLabels(labelAtt.getEntry(5) == 1);
                        }
                    }
                    if ((neighbours = PsXmlSrc.getRsrcNode(faceSet, "neighbours")) != null && (neighbour = PsXmlLoader.parseIntegerList(neighbours, "nb", null)) != null) {
                        geom.setNeighbours(neighbour);
                    }
                    if ((edges = PsXmlSrc.getRsrcNode(faceSet, "edges")) != null) {
                        PiVector[] iList = PsXmlLoader.parseIntegerList(edges, "e", null);
                        if (iList != null) {
                            geom.setEdges(iList);
                        }
                        if (edges.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(edges, "thickness");
                            geom.setGlobalEdgeSize(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(edges, "color")) != null) {
                            geom.setGlobalEdgeColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(edges, "colorTag")) != null) {
                            geom.setGlobalEdgeTagColor(c);
                        }
                        if ((labelAtt = PgJvxLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(edges, "labelAtt"))) != null) {
                            geom.setLabelAttribute(1, labelAtt);
                            geom.showEdgeLabels(labelAtt.getEntry(5) == 1);
                        }
                    }
                    if ((colors2 = PsXmlSrc.getRsrcNode(faceSet, "colors")) != null && (cList = PsXmlLoader.parseColorList(colors2, "c")) != null) {
                        geom.setElementColors(cList);
                    }
                    if ((backColors = PsXmlSrc.getRsrcNode(faceSet, "colorsBack")) != null && (cList = PsXmlLoader.parseColorList(backColors, "c")) != null) {
                        geom.setElementBackColors(cList);
                    }
                    if ((normals2 = PsXmlSrc.getRsrcNode(faceSet, "normals")) != null) {
                        dList = PsXmlLoader.parseDoubleList(normals2, "n", null);
                        if (dList != null) {
                            geom.setElementNormals(dList);
                        }
                        if (normals2.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals2, "thickness");
                            geom.setGlobalElementNormalSize(d);
                        }
                        if (normals2.hasChild("length")) {
                            d = PsXmlSrc.getRsrcAsDouble(normals2, "length");
                            geom.setGlobalElementNormalLength(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(normals2, "color")) != null) {
                            geom.setGlobalElementNormalColor(c);
                        }
                    } else if (!bShowBackface || geom.isShowingElementNormals()) {
                        geom.makeElementNormals();
                    }
                    PsXmlNode textures = PsXmlSrc.getRsrcNode(faceSet, "textures");
                    if (textures != null) {
                        PsXmlNode image;
                        String textureType = textures.getAttribute("type");
                        if (textureType == null || textureType.equals("image")) {
                            // empty if block
                        }
                        PdVector[] texCoord = PsXmlLoader.parseDoubleList(textures, "t", null);
                        int noe = geom.getNumElements();
                        if (texCoord != null && noe > 0) {
                            geom.assureElementTextures();
                            PdVector[][] texture = geom.getElementTextures();
                            int num = 0;
                            PiVector[] elem = geom.getElements();
                            int k = 0;
                            while (k < noe) {
                                int elemSize = elem[k].getSize();
                                int kk = 0;
                                while (kk < elemSize) {
                                    texture[k][kk].copy(texCoord[num++]);
                                    ++kk;
                                }
                                ++k;
                            }
                            if (num != texCoord.length) {
                                PsDebug.warning("element texture coordinates do not match elements.");
                                geom.setElementTextures(null);
                            }
                        }
                        if ((s = (image = PsXmlSrc.getRsrcNode(textures, "image")).getContent()) != null) {
                            String repeat = image.getAttribute("repeat");
                            if (repeat != null && !"no".equals(repeat)) {
                                PsDebug.warning("repeat mode in images not supported yet.");
                            }
                            geom.setTextureImageName(s);
                        }
                    }
                    if ((boundaries = PsXmlSrc.getRsrcNode(faceSet, "boundaries")) != null) {
                        if (boundaries.hasChild("thickness")) {
                            d = PsXmlSrc.getRsrcAsDouble(boundaries, "thickness");
                            geom.setGlobalBndSize(d);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(boundaries, "color")) != null) {
                            geom.setGlobalBndColor(c);
                        }
                        if ((c = PsXmlLoader.parseColorRGB(boundaries, "colorTag")) != null) {
                            geom.setGlobalBndTagColor(c);
                        }
                    }
                }
                if ((vectorField = PsXmlSrc.getRsrcNodes(geometry[i], "vectorField")) != null && vectorField.length > 0) {
                    geom.setNumVectorFields(vectorField.length);
                    int j = 0;
                    while (j < vectorField.length) {
                        PsXmlNode colors3;
                        geom.setVectorFieldName(j, vectorField[j].getAttribute("name"));
                        String base = vectorField[j].getAttribute("base");
                        if (base != null) {
                            if (base.equals("vertex")) {
                                geom.setVectorElementBased(j, false);
                            } else if (base.equals("element")) {
                                geom.setVectorElementBased(j, true);
                            }
                        }
                        geom.showVectorArrows(j, PgJvxLoader.parseVisibility(vectorField[j].getAttribute("arrow")) == 1);
                        PsXmlNode vectors = PsXmlSrc.getRsrcNode(vectorField[j], "vectors");
                        if (vectors != null) {
                            int num;
                            dList = PsXmlLoader.parseDoubleList(vectors, "v", null);
                            if (dList != null && (num = dList.length) > 0) {
                                geom.setNumVectors(j, num, dList[0].getSize());
                                geom.setVectors(j, dList);
                            }
                            if (vectors.hasChild("thickness")) {
                                d = PsXmlSrc.getRsrcAsDouble(vectors, "thickness");
                                geom.setGlobalVectorSize(j, d);
                            }
                            if (vectors.hasChild("length")) {
                                d = PsXmlSrc.getRsrcAsDouble(vectors, "length");
                                geom.setGlobalVectorLength(j, d);
                            }
                            if ((c = PsXmlLoader.parseColorRGB(vectors, "color")) != null) {
                                geom.setGlobalVectorColor(j, c);
                            }
                        }
                        if ((colors3 = PsXmlSrc.getRsrcNode(vectorField[j], "colors")) != null && (cList = PsXmlLoader.parseColorList(colors3, "c")) != null) {
                            geom.setVectorColors(j, cList);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } else {
            PsDebug.warning("missing references node.");
        }
        return m_geom;
    }

    public PgJvxSrc[] read(BufferedReader in) {
        if (in == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        PsXmlSrc src = PsXmlLoader.read(in);
        if (src == null) {
            PsDebug.warning("failed to parse XML stream");
            return null;
        }
        PgJvxSrc[] geom = PgJvxLoader.parseRsrcTree(src);
        if (geom == null) {
            PsDebug.warning("failed to interpret JVX tree");
            return null;
        }
        return geom;
    }

    public static PgJvxSrc[] read(String fileName) {
        BufferedReader in = PsUtil.open(fileName);
        if (in == null) {
            PsDebug.warning("could not open = " + fileName);
            return null;
        }
        PgJvxLoader loader = new PgJvxLoader();
        PgJvxSrc[] geomArr = loader.read(in);
        if (geomArr != null) {
            int i = 0;
            while (i < geomArr.length) {
                if (geomArr[i] != null && (geomArr[i].getName() == null || geomArr[i].getName().startsWith("object_"))) {
                    if (i == 0) {
                        geomArr[i].setName(PsUtil.getFileBaseName(fileName));
                    } else {
                        geomArr[i].setName(PsUtil.getFileBaseName(fileName) + "[" + i + "]");
                    }
                }
                ++i;
            }
        }
        try {
            in.close();
        }
        catch (IOException ie) {
            // empty catch block
        }
        return geomArr;
    }

    private static boolean hasAttribute(String attr, String value) {
        return attr != null && attr.equalsIgnoreCase(value);
    }

    protected static PsXmlNode fillLabelAttr(boolean isVisible) {
        PsXmlNode labelAtt = new PsXmlNode("labelAtt");
        labelAtt.addAttribute("visible", PgJvxLoader.fillVisibility(isVisible));
        return labelAtt;
    }

    protected static PsXmlNode fillLabelAttr(boolean isVisible, int horAlign, int verAlign, int font, int xOffset, int yOffset) {
        PsXmlNode labelAtt = new PsXmlNode("labelAtt");
        labelAtt.addAttribute("visible", PgJvxLoader.fillVisibility(isVisible));
        switch (horAlign) {
            case 0: {
                labelAtt.addAttribute("horAlign", "head");
                break;
            }
            case 1: {
                labelAtt.addAttribute("horAlign", "center");
                break;
            }
            case 2: {
                labelAtt.addAttribute("horAlign", "tail");
                break;
            }
        }
        switch (verAlign) {
            case 0: {
                labelAtt.addAttribute("verAlign", "head");
                break;
            }
            case 1: {
                labelAtt.addAttribute("verAlign", "center");
                break;
            }
            case 2: {
                labelAtt.addAttribute("verAlign", "tail");
                break;
            }
        }
        switch (font) {
            case 0: {
                labelAtt.addAttribute("font", "text");
                break;
            }
            case 1: {
                labelAtt.addAttribute("font", "fixed");
                break;
            }
            case 3: {
                labelAtt.addAttribute("font", "header2");
                break;
            }
            case 4: {
                labelAtt.addAttribute("font", "header4");
                break;
            }
            case 2: {
                labelAtt.addAttribute("font", "menu");
                break;
            }
        }
        labelAtt.addAttribute("xOffset", String.valueOf(xOffset));
        labelAtt.addAttribute("yOffset", String.valueOf(yOffset));
        return labelAtt;
    }

    public PvDisplayOption getDisplayOption() {
        return null;
    }

    public void setDisplayOption(PvDisplayOption option) {
    }

    public void setAnimation(boolean flag) {
        this.m_bIsAnimation = flag;
    }

    protected static boolean isEnabledSmallSize() {
        return m_bIsEnabledSmallSize;
    }

    protected static int parseVisibility(String attr) {
        if (attr == null) {
            return -1;
        }
        if (attr.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String[][] parseFunList(PsXmlNode parentNode, String type, String[] attr) {
        PsXmlNode[] p = PsXmlSrc.getRsrcNodes(parentNode, type);
        if (p == null || p.length == 0) {
            return null;
        }
        String[][] vertex = new String[p.length][];
        int j = 0;
        while (j < p.length) {
            String pStr = p[j].getContent();
            if (pStr != null) {
                String[] comp = PuString.splitString(pStr, ' ');
                vertex[j] = new String[comp.length];
                int k = 0;
                while (k < comp.length) {
                    vertex[j][k] = comp[k];
                    ++k;
                }
            }
            ++j;
        }
        return vertex;
    }

    public boolean write(Writer writer, PgJvxSrc[] geom) {
        if (geom == null || geom.length == 0) {
            PsDebug.warning("missing geometries.");
            return false;
        }
        PsXmlSrc src = PgJvxLoader.fillRsrcTree(null, geom);
        if (src == null) {
            PsDebug.warning("failed to generate XML tree");
            return false;
        }
        try {
            return PsXmlSrc.write(writer, src);
        }
        catch (IOException ex) {
            PsDebug.warning("failed to generate XML tree", ex);
            return false;
        }
    }

    public static String write(PgJvxSrc[] geom) {
        if (geom == null || geom.length == 0) {
            PsDebug.warning("missing geometries.");
            return null;
        }
        PsXmlSrc src = PgJvxLoader.fillRsrcTree(null, geom);
        if (src == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlSrc.write(src);
    }

    protected static PiVector parseLabelAtt(PsXmlNode attr) {
        if (attr == null) {
            return null;
        }
        PiVector labelAtt = new PiVector(6);
        String visible = attr.getAttribute("visible");
        if (visible != null && "hide".equalsIgnoreCase(visible)) {
            labelAtt.setEntry(5, 0);
        } else {
            labelAtt.setEntry(5, 1);
        }
        String horAlign = attr.getAttribute("horAlign");
        if (horAlign == null || "head".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(horAlign)) {
            labelAtt.setEntry(2, 2);
        }
        String verAlign = attr.getAttribute("verAlign");
        if (verAlign == null || "base".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 0);
        } else if ("middle".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(verAlign)) {
            labelAtt.setEntry(3, 2);
        }
        String font = attr.getAttribute("font");
        if (font == null || "text".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(font)) {
            labelAtt.setEntry(4, 2);
        } else if (font == null) {
            labelAtt.setEntry(4, 0);
        }
        try {
            PsXmlNode yOffset;
            PsXmlNode xOffset = PsXmlSrc.getRsrcNode(attr, "xOffset");
            if (xOffset != null) {
                labelAtt.setEntry(0, Integer.parseInt(xOffset.getContent()));
            }
            if ((yOffset = PsXmlSrc.getRsrcNode(attr, "yOffset")) != null) {
                labelAtt.setEntry(1, Integer.parseInt(yOffset.getContent()));
            }
        }
        catch (NumberFormatException e) {
            PsDebug.warning("wrong format parsing offset");
            return null;
        }
        return labelAtt;
    }

    public boolean isAnimation() {
        return this.m_bIsAnimation;
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc src, PgJvxSrc[] m_geom) {
        PsXmlNode description;
        PsGeometryInfo geometryInfo;
        PsXmlNode authors;
        PsXmlNode root;
        if (m_geom == null || m_geom.length == 0) {
            return null;
        }
        if (src == null) {
            src = new PsXmlSrc();
        }
        if ((root = src.getRootNode()) == null) {
            root = new PsXmlNode("jvx-model");
            src.setRootNode(root);
        }
        PgJvxSrc geom = m_geom[0];
        src.setDocName("jvx-model");
        PsXmlNode[] meta = new PsXmlNode[2];
        meta[0] = root.addChild("meta");
        meta[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        meta[1] = root.addChild("meta");
        meta[1].addAttribute("date", new Date().toString());
        PsXmlNode version = root.addChild("version", geom.getVersion());
        version.addAttribute("type", geom.getVersionType());
        if (geom.getTitle() != null) {
            root.addChild("title", geom.getTitle());
        } else {
            root.addChild("title", geom.getName());
        }
        PsAuthorInfo author = geom.getAuthors();
        if (author != null && (authors = author.getXmlNode()) != null) {
            root.addChild(authors);
        }
        if ((geometryInfo = geom.getGeometryInfo()) != null && (description = geometryInfo.getXmlNode()) != null) {
            root.addChild(description);
        }
        PsXmlNode geometries = root.addChild("geometries");
        if (m_geom != null) {
            int i = 0;
            while (i < m_geom.length) {
                PdVector cen;
                PdVector[] bounds;
                PsXmlNode normals;
                PsXmlNode colors;
                geom = m_geom[i];
                PsXmlNode geometry = geometries.addChild("geometry");
                geometry.addAttribute("name", geom.getName());
                if (!geom.isVisible()) {
                    geometry.addAttribute("visible", "hide");
                }
                if (geom.getType() == 30 || geom.getType() == 31 || geom.getType() == 32 || geom.getType() == 33) {
                    PsXmlNode pointSet = geometry.addChild("pointSet");
                    pointSet.addAttribute("dim", String.valueOf(geom.getDimOfVertices()));
                    if (geom.isShowingVertices()) {
                        pointSet.addAttribute("point", "show");
                    } else if (!geom.isShowingVertices()) {
                        pointSet.addAttribute("point", "hide");
                    }
                    if (geom.isShowingVertexColors() && geom.getVertexColors() != null) {
                        pointSet.addAttribute("color", "show");
                    }
                    if (geom.isShowingVertexNormals() && geom.getVertexNormals() != null) {
                        pointSet.addAttribute("normal", "show");
                    }
                    if (geom.isShowingVertexNormalArrow() && geom.getVertexNormals() != null) {
                        pointSet.addAttribute("normalArrow", "show");
                    }
                    PsXmlNode points = pointSet.addChild("points");
                    PsXmlLoader.addVectorList(points, "p", geom.getVertices(), geom.getNumVertices());
                    points.addChild("thickness", geom.getGlobalVertexSize());
                    if (geom.getGlobalVertexColor() != null) {
                        PsXmlLoader.addColor(points, "color", geom.getGlobalVertexColor());
                    }
                    if (geom.getGlobalVertexTagColor() != null) {
                        PsXmlLoader.addColor(points, "colorTag", geom.getGlobalVertexTagColor());
                    }
                    if (geom.isShowingIndices() || geom.isShowingVertexLabels()) {
                        points.addChild(PgJvxLoader.fillLabelAttr(geom.isShowingIndices() || geom.isShowingVertexLabels()));
                    }
                    if (geom.getVertexColors() != null && (!m_bIsEnabledSmallSize || geom.isShowingVertices() && geom.isShowingVertexColors())) {
                        colors = pointSet.addChild("colors");
                        colors.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(colors, "c", geom.getVertexColors(), geom.getNumVertices());
                    }
                    if (geom.getVertexNormals() != null && (!m_bIsEnabledSmallSize || geom.isShowingVertexNormals())) {
                        normals = pointSet.addChild("normals");
                        PsXmlLoader.addVectorList(normals, "n", geom.getVertexNormals(), geom.getNumVertices());
                        normals.addChild("thickness", geom.getGlobalVertexNormalSize());
                        normals.addChild("length", geom.getGlobalVertexNormalLength());
                        if (geom.getGlobalVertexNormalColor() != null) {
                            PsXmlLoader.addColor(normals, "color", geom.getGlobalVertexNormalColor());
                        }
                    }
                    if (geom.getVertexTextures() != null && (!m_bIsEnabledSmallSize || geom.isShowingVertexTexture())) {
                        PsXmlNode textures = pointSet.addChild("textures");
                        textures.addAttribute("dim", String.valueOf(2));
                        PsXmlLoader.addVectorList(textures, "t", geom.getVertexTextures(), geom.getNumVertices());
                        if (geom.getTextureImage() != null) {
                            textures.addAttribute("type", "image");
                            String textureFileName = geom.getTextureImageName();
                            if (textureFileName == null) {
                                textureFileName = geom.getName() + "_texture.gif";
                            }
                            PsXmlNode image = textures.addChild("image", textureFileName);
                            image.addAttribute("repeat", "no");
                        }
                    }
                }
                if (geom.getType() == 31 || geom.getType() == 32) {
                    PsXmlNode lineSet = geometry.addChild("lineSet");
                    if (geom.isShowingPolygons()) {
                        lineSet.addAttribute("line", "show");
                    } else if (!geom.isShowingPolygons()) {
                        lineSet.addAttribute("line", "hide");
                    }
                    if (geom.isShowingPolygonStartArrow()) {
                        lineSet.addAttribute("arrowStart", "show");
                    }
                    if (geom.isShowingPolygonEndArrow()) {
                        lineSet.addAttribute("arrow", "show");
                    }
                    if (geom.isShowingPolygonColors()) {
                        lineSet.addAttribute("color", "show");
                    }
                    if (geom.isShowingPolygonNormals()) {
                        lineSet.addAttribute("normal", "show");
                    }
                    if (geom.isShowingPolygonNormalArrow()) {
                        lineSet.addAttribute("normalArrow", "show");
                    }
                    PsXmlNode lines = lineSet.addChild("lines");
                    PsXmlLoader.addVectorList(lines, "l", geom.getPolygons(), geom.getNumPolygons());
                    lines.addChild("thickness", geom.getGlobalPolygonSize());
                    if (geom.getGlobalPolygonColor() != null) {
                        PsXmlLoader.addColor(lines, "color", geom.getGlobalPolygonColor());
                    }
                    if (geom.getGlobalPolygonTagColor() != null) {
                        PsXmlLoader.addColor(lines, "colorTag", geom.getGlobalPolygonTagColor());
                    }
                    if (geom.isShowingIndices() || geom.isShowingPolygonLabels()) {
                        lines.addChild(PgJvxLoader.fillLabelAttr(geom.isShowingIndices() || geom.isShowingPolygonLabels()));
                    }
                    if (geom.getPolygonColors() != null && (!m_bIsEnabledSmallSize || geom.isShowingPolygonColors())) {
                        colors = lineSet.addChild("colors");
                        colors.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(colors, "c", geom.getPolygonColors(), geom.getNumPolygons());
                    }
                    if (geom.getPolygonNormals() != null && (!m_bIsEnabledSmallSize || geom.isShowingPolygonNormals())) {
                        normals = lineSet.addChild("normals");
                        PsXmlLoader.addVectorList(normals, "n", geom.getPolygonNormals(), geom.getNumPolygons());
                        normals.addChild("thickness", geom.getGlobalPolygonNormalSize());
                        normals.addChild("length", geom.getGlobalPolygonNormalLength());
                        if (geom.getGlobalPolygonNormalColor() != null) {
                            PsXmlLoader.addColor(normals, "color", geom.getGlobalPolygonNormalColor());
                        }
                    }
                }
                if (geom.getType() == 33) {
                    PsXmlNode colors2;
                    PsXmlNode elementSet = geometry.addChild("faceSet");
                    if (geom.isShowingEdges()) {
                        elementSet.addAttribute("edge", "show");
                    } else {
                        elementSet.addAttribute("edge", "hide");
                    }
                    if (geom.isShowingElements()) {
                        elementSet.addAttribute("face", "show");
                    } else {
                        elementSet.addAttribute("face", "hide");
                    }
                    if (geom.isShowingElementColors() && geom.getElementColors() != null) {
                        elementSet.addAttribute("color", "show");
                    }
                    if (geom.isShowingElementBackColor()) {
                        elementSet.addAttribute("colorBackGlobal", "show");
                    }
                    if (geom.isShowingElementBackColors() && geom.getElementBackColors() != null) {
                        elementSet.addAttribute("colorBackLocal", "show");
                    }
                    if (geom.isShowingElementNormals() && geom.getElementNormals() != null) {
                        elementSet.addAttribute("normal", "show");
                    }
                    if (geom.isShowingElementNormalArrow() && geom.getElementNormals() != null) {
                        elementSet.addAttribute("normalArrow", "show");
                    }
                    if (geom.isShowingVertexTexture() && geom.getVertexTextures() != null || geom.isShowingElementTexture() && geom.getElementTextures() != null) {
                        elementSet.addAttribute("texture", "show");
                    }
                    if (!geom.isShowingBackface()) {
                        elementSet.addAttribute("backface", "hide");
                    }
                    if (geom.isShowingBoundaries()) {
                        elementSet.addAttribute("boundary", "show");
                    }
                    PsXmlNode faces = elementSet.addChild("faces");
                    PsXmlLoader.addVectorList(faces, "f", geom.getElements(), geom.getNumElements());
                    if (geom.getGlobalElementColor() != null) {
                        PsXmlLoader.addColor(faces, "color", geom.getGlobalElementColor());
                    }
                    if (geom.isShowingElementBackColor()) {
                        PsXmlLoader.addColor(faces, "colorBack", geom.getGlobalElementBackColor());
                    }
                    if (geom.getGlobalElementTagColor() != null) {
                        PsXmlLoader.addColor(faces, "colorTag", geom.getGlobalElementTagColor());
                    }
                    if (geom.isShowingIndices() || geom.isShowingElementLabels()) {
                        faces.addChild(PgJvxLoader.fillLabelAttr(geom.isShowingIndices() || geom.isShowingElementLabels()));
                    }
                    if (geom.getNeighbours() != null && !m_bIsEnabledSmallSize) {
                        PsXmlNode neighbours = elementSet.addChild("neighbours");
                        PsXmlLoader.addVectorList(neighbours, "nb", geom.getNeighbours(), geom.getNumElements());
                    }
                    PsXmlNode edges = elementSet.addChild("edges");
                    if (geom.getNumEdges() > 0) {
                        PsXmlLoader.addVectorList(edges, "e", geom.getEdges(), geom.getNumEdges());
                    }
                    edges.addChild("thickness", geom.getGlobalEdgeSize());
                    if (geom.getGlobalEdgeColor() != null) {
                        PsXmlLoader.addColor(edges, "color", geom.getGlobalEdgeColor());
                    }
                    if (geom.getGlobalEdgeTagColor() != null) {
                        PsXmlLoader.addColor(edges, "colorTag", geom.getGlobalEdgeTagColor());
                    }
                    if (geom.isShowingIndices() || geom.isShowingEdgeLabels()) {
                        edges.addChild(PgJvxLoader.fillLabelAttr(geom.isShowingIndices() || geom.isShowingEdgeLabels()));
                    }
                    if (geom.getElementColors() != null && (!m_bIsEnabledSmallSize || geom.isShowingElements() && geom.isShowingElementColors())) {
                        colors2 = elementSet.addChild("colors");
                        colors2.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(colors2, "c", geom.getElementColors(), geom.getNumElements());
                    }
                    if (geom.getElementBackColors() != null && (!m_bIsEnabledSmallSize || geom.isShowingElements() && geom.isShowingElementBackColors())) {
                        colors2 = elementSet.addChild("colorsBack");
                        colors2.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(colors2, "c", geom.getElementBackColors(), geom.getNumElements());
                    }
                    if (geom.getElementNormals() != null && (!m_bIsEnabledSmallSize || geom.isShowingElementNormals())) {
                        PsXmlNode normals2 = elementSet.addChild("normals");
                        PsXmlLoader.addVectorList(normals2, "n", geom.getElementNormals(), geom.getNumElements());
                        normals2.addChild("thickness", geom.getGlobalElementNormalSize());
                        normals2.addChild("length", geom.getGlobalElementNormalLength());
                        if (geom.getGlobalElementNormalColor() != null) {
                            PsXmlLoader.addColor(normals2, "color", geom.getGlobalElementNormalColor());
                        }
                    }
                    if (geom.getElementTextures() != null && (!m_bIsEnabledSmallSize || geom.isShowingElementTexture())) {
                        PsXmlNode textures = elementSet.addChild("textures");
                        textures.addAttribute("dim", String.valueOf(2));
                        PsXmlLoader.addVectorList(textures, "t", geom.getElementTextures(), geom.getNumElements());
                        if (geom.getTextureImage() != null) {
                            textures.addAttribute("type", "image");
                            String textureFileName = geom.getTextureImageName();
                            if (textureFileName == null) {
                                textureFileName = geom.getName() + "_texture.gif";
                            }
                            PsXmlNode image = textures.addChild("image", textureFileName);
                            image.addAttribute("repeat", "no");
                        }
                    }
                    if (geom.isShowingBoundaries()) {
                        PsXmlNode boundaries = elementSet.addChild("boundaries");
                        boundaries.addChild("thickness", geom.getGlobalBndSize());
                        if (geom.getGlobalBndColor() != null) {
                            PsXmlLoader.addColor(boundaries, "color", geom.getGlobalBndColor());
                        }
                        if (geom.getGlobalBndTagColor() != null) {
                            PsXmlLoader.addColor(boundaries, "colorTag", geom.getGlobalBndTagColor());
                        }
                    }
                }
                if (geom.getNumVectorFields() != 0) {
                    int novf = geom.getNumVectorFields();
                    int k = 0;
                    while (k < novf) {
                        PsXmlNode vectorField = geometry.addChild("vectorField");
                        if (geom.getVectorFieldName(k) != null) {
                            vectorField.addAttribute("name", geom.getVectorFieldName(k));
                        }
                        if (geom.isShowingVectorArrows(k)) {
                            vectorField.addAttribute("arrow", "show");
                        } else {
                            vectorField.addAttribute("arrow", "hide");
                        }
                        if (geom.isVectorElementBased(k)) {
                            vectorField.addAttribute("base", "element");
                        } else {
                            vectorField.addAttribute("base", "vertex");
                        }
                        PdVector[] vArr = geom.getVectors(k);
                        if (vArr == null || vArr.length == 0) {
                            PsDebug.warning("missing vectors of vector field[" + k + "]");
                        } else {
                            PsXmlNode vectors = vectorField.addChild("vectors");
                            PsXmlLoader.addVectorList(vectors, "v", vArr, vArr.length);
                            vectors.addChild("thickness", geom.getGlobalVectorSize(k));
                            vectors.addChild("length", geom.getGlobalVectorLength(k));
                            if (geom.getGlobalVectorColor(k) != null) {
                                PsXmlLoader.addColor(vectors, "color", geom.getGlobalVectorColor(k));
                            }
                            if (geom.getVectorFieldColors(k) != null) {
                                PsXmlNode colors3 = vectorField.addChild("colors");
                                colors3.addAttribute("type", "rgb");
                                PsXmlLoader.addVectorList(colors3, "c", geom.getVectorFieldColors(k), vArr.length);
                            }
                        }
                        ++k;
                    }
                }
                if ((bounds = geom.getBounds()) != null && bounds.length == 2) {
                    PsXmlNode bndbox = geometry.addChild("bndbox");
                    if (geom.isShowingBndBox()) {
                        bndbox.addAttribute("visible", "show");
                    } else {
                        bndbox.addAttribute("visible", "hide");
                    }
                    bndbox.addChild("p", PuData.toString(bounds[0].getEntries()));
                    bndbox.addChild("p", PuData.toString(bounds[1].getEntries()));
                }
                if ((cen = geom.getCenter()) != null) {
                    PsXmlNode center = geometry.addChild("center");
                    if (geom.isShowingCenter()) {
                        center.addAttribute("visible", "show");
                    } else {
                        center.addAttribute("visible", "hide");
                    }
                    center.addChild("p", PuData.toString(cen.getEntries()));
                }
                if (geom.isShowingTitle()) {
                    geometry.addChild(PgJvxLoader.fillLabelAttr(geom.isShowingTitle()));
                }
                ++i;
            }
        }
        return src;
    }

    protected static String fillVisibility(boolean isVisible) {
        if (isVisible) {
            return "show";
        }
        return "hide";
    }
}

