/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgUtil
extends PsObject {
    public static PiVector[] triangulate(PdVector[] polygon) {
        int numVertices = polygon.length;
        if (numVertices < 3) {
            PsDebug.warning("numVertices < 3");
            return null;
        }
        PiVector[] elemList = PiVector.realloc(null, numVertices - 2, 3);
        PdVector[] currVertex = new PdVector[numVertices];
        double[] angle = new double[numVertices];
        int[] indVec = new int[numVertices];
        int i = 0;
        while (i < numVertices) {
            indVec[i] = (i + 1) % numVertices;
            ++i;
        }
        int maxIndPrev = -1;
        int indPrev = numVertices - 1;
        int indStart = 0;
        int numElems = 0;
        while (numElems < numVertices - 3) {
            int remainNum = numVertices - numElems;
            int ind = indStart;
            i = 0;
            while (i < remainNum) {
                currVertex[i] = polygon[ind];
                ind = indVec[ind];
                ++i;
            }
            PdVector.angleWithOrientation(angle, currVertex, remainNum);
            double maxAngle = Double.NEGATIVE_INFINITY;
            int maxInd = -1;
            ind = indStart;
            i = 0;
            while (i < remainNum) {
                if (angle[i] > maxAngle) {
                    maxAngle = angle[i];
                    maxInd = ind;
                    maxIndPrev = indPrev;
                }
                indPrev = ind;
                ind = indVec[ind];
                ++i;
            }
            if (maxInd == -1) {
                PsDebug.error("missing max angle", polygon);
                return null;
            }
            elemList[numElems].set(maxIndPrev, maxInd, indVec[maxInd]);
            indVec[maxIndPrev] = indVec[maxInd];
            indPrev = maxIndPrev;
            indStart = indVec[maxInd];
            ++numElems;
        }
        elemList[numElems].set(indStart, indVec[indStart], indVec[indVec[indStart]]);
        return elemList;
    }
}

