/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.util.Vector;
import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementEdge;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgElementSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected int m_dimOfElements;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected Color[] m_elementBackColor;
    protected PdVector[] m_elementNormal;
    protected PiVector[] m_neighbour;
    protected PgBndPolygon[] m_bndList;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected PuDouble m_globalBndSize;
    protected boolean m_bConforming = true;
    protected PiVector[] m_elementSaved;
    protected int m_savedNumVertices;
    protected boolean m_bShowElementTexture;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowOutline;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected Color[] m_edgeColor;
    protected boolean m_bShowEdgeColors;
    protected PdColor m_globalEdgeColor;
    protected PdColor m_globalEdgeTagColor;
    protected PuDouble m_globalEdgeSize;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowBackface;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected PuDouble m_globalElementNormalLength;
    protected PuDouble m_globalElementNormalSize;
    protected PdColor m_globalElementNormalColor;
    protected boolean m_bShowElementColors;
    protected PdColor m_globalElementColor;
    protected PdColor m_globalElementTagColor;
    protected PdColor m_globalElementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    private static /* synthetic */ Class class$jv$geom$PgElementSet;

    public boolean refineGlobalIntoFour() {
        int k;
        int j;
        int len;
        int i;
        boolean check;
        double[] dArray = new double[10];
        dArray[1] = -0.0625;
        dArray[2] = 0.125;
        dArray[3] = -0.0625;
        dArray[4] = 0.5;
        dArray[5] = 0.5;
        dArray[6] = -0.0625;
        dArray[7] = 0.125;
        dArray[8] = -0.0625;
        double[] butterfly = dArray;
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{3, 4, 5};
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 4;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{1, 3, 5};
        nArrayArray[3] = new int[]{2, 4, 3};
        int[][] subScheme = nArrayArray;
        int[] newVertexInd = new int[6];
        if (this.m_dimOfElements != 3 && !(check = PgElementSet.triangulate(this))) {
            PsDebug.error("initial triangulation failed", this);
            return false;
        }
        this.makeNeighbour();
        int nov = this.m_numVertices;
        int noe = this.m_numElements;
        int newNov = this.m_numVertices + this.getNumEdges();
        this.setNumVertices(newNov);
        PdVector[][] oldTextures = this.hasElementTextures() ? this.getElementTextures() : new PdVector[1][1];
        this.setNumElements(4 * noe);
        if (this.m_bndList != null) {
            i = 0;
            while (i < this.m_bndList.length) {
                if (!this.m_bndList[i].hasTag(2)) {
                    len = this.m_bndList[i].getNumVertices();
                    PgBndPolygon bnd = this.m_bndList[i];
                    bnd.setNumVertices(2 * len - 1);
                    j = len - 1;
                    while (j >= 0) {
                        bnd.m_vertexInd.m_data[2 * j] = bnd.m_vertexInd.m_data[j];
                        --j;
                    }
                }
                ++i;
            }
        }
        PiVector ind1v = new PiVector(newNov - nov);
        PiVector ind2v = new PiVector(newNov - nov);
        int ind = nov - 1;
        i = noe - 1;
        while (i >= 0) {
            j = 0;
            while (j < 3) {
                if (this.m_neighbour[i].m_data[j] < i) {
                    if (++ind == this.m_numVertices) {
                        PsDebug.error("internal error", this);
                        return false;
                    }
                    int ind1 = this.m_element[i].m_data[(j + 3 - 1) % 3];
                    int ind2 = this.m_element[i].m_data[(j + 1) % 3];
                    ind1v.setEntry(ind - nov, ind1);
                    ind2v.setEntry(ind - nov, ind2);
                    this.m_vertex[ind].blend(0.5, this.m_vertex[ind1], 0.5, this.m_vertex[ind2]);
                }
                ++j;
            }
            --i;
        }
        if (this.hasVertexColors()) {
            ind = nov - 1;
            i = noe - 1;
            while (i >= 0) {
                j = 0;
                while (j < 3) {
                    if (this.m_neighbour[i].m_data[j] < i) {
                        Color col1 = this.getVertexColor(this.m_element[i].m_data[(j + 3 - 1) % 3]);
                        Color col2 = this.getVertexColor(this.m_element[i].m_data[(j + 1) % 3]);
                        Color newCol = PdColor.blend(0.5, col1, 0.5, col2);
                        this.setVertexColor(++ind, newCol);
                    }
                    ++j;
                }
                --i;
            }
        }
        if (this.hasVertexNormals()) {
            ind = nov - 1;
            i = noe - 1;
            while (i >= 0) {
                j = 0;
                while (j < 3) {
                    if (this.m_neighbour[i].m_data[j] < i) {
                        PdVector nor1 = this.getVertexNormal(this.m_element[i].m_data[(j + 3 - 1) % 3]);
                        PdVector nor2 = this.getVertexNormal(this.m_element[i].m_data[(j + 1) % 3]);
                        PdVector newNor = PdVector.blendNew(0.5, nor1, 0.5, nor2);
                        this.setVertexNormal(++ind, newNor);
                    }
                    ++j;
                }
                --i;
            }
        }
        if (this.hasVertexTextures()) {
            PdVector[] tex = this.getVertexTextures();
            ind = nov - 1;
            i = noe - 1;
            while (i >= 0) {
                j = 0;
                while (j < 3) {
                    if (this.m_neighbour[i].m_data[j] < i) {
                        PdVector tex1 = tex[this.m_element[i].m_data[(j + 3 - 1) % 3]];
                        PdVector tex2 = tex[this.m_element[i].m_data[(j + 1) % 3]];
                        PdVector newTex = new PdVector(this.getDimOfTextures());
                        newTex.blend(0.5, tex1, 0.5, tex2);
                        tex[++ind] = newTex;
                    }
                    ++j;
                }
                --i;
            }
        }
        boolean bHasBnd = this.hasBoundary();
        ind = nov - 1;
        i = noe - 1;
        while (i >= 0) {
            j = 0;
            while (j < 3) {
                block59: {
                    int l;
                    block58: {
                        newVertexInd[j] = this.m_element[i].m_data[j];
                        if (this.m_neighbour[i].m_data[j] >= i) break block58;
                        int ind1 = this.m_element[i].m_data[(j + 3 - 1) % 3];
                        int ind2 = this.m_element[i].m_data[(j + 1) % 3];
                        newVertexInd[j + 3] = ++ind;
                        if (this.m_neighbour[i].m_data[j] != -1 || !bHasBnd) break block59;
                        boolean bEdgeFound = false;
                        k = 0;
                        while (k < this.m_bndList.length && !bEdgeFound) {
                            if (!this.m_bndList[k].hasTag(2)) {
                                len = this.m_bndList[k].getNumVertices();
                                l = 0;
                                while (l < len - 2) {
                                    if (this.m_bndList[k].m_vertexInd.m_data[l] == ind1 && this.m_bndList[k].m_vertexInd.m_data[l + 2] == ind2 || this.m_bndList[k].m_vertexInd.m_data[l] == ind2 && this.m_bndList[k].m_vertexInd.m_data[l + 2] == ind1) {
                                        this.m_bndList[k].m_vertexInd.m_data[l + 1] = ind;
                                        bEdgeFound = true;
                                        break;
                                    }
                                    l += 2;
                                }
                            }
                            ++k;
                        }
                        if (bEdgeFound) break block59;
                        PsDebug.warning("boundary edge not found\n\tEdge = (" + ind1 + ", " + ind2 + ")");
                        break block59;
                    }
                    int adjElem = this.m_neighbour[i].m_data[j];
                    l = 0;
                    while (l < 3) {
                        if (this.m_neighbour[adjElem].m_data[l] == i) {
                            newVertexInd[j + 3] = this.m_element[adjElem].m_data[l];
                            break;
                        }
                        ++l;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < 4) {
                k = 0;
                while (k < 3) {
                    this.m_element[i + j * noe].m_data[k] = newVertexInd[subScheme[j][k]];
                    ++k;
                }
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < noe) {
            j = 0;
            while (j < 3) {
                int child1 = i + (j + 1) * noe;
                int child2 = i + ((j + 1) % 3 + 1) * noe;
                int adj = this.m_neighbour[i].m_data[(j + 2) % 3];
                if (adj == -1) {
                    this.m_neighbour[child1].m_data[2] = -1;
                    this.m_neighbour[child2].m_data[1] = -1;
                } else {
                    k = 1;
                    while (k < 4) {
                        if (this.m_element[adj + k * noe].m_data[0] == this.m_element[child1].m_data[0]) break;
                        ++k;
                    }
                    this.m_neighbour[child1].m_data[2] = adj + k * noe;
                    this.m_neighbour[child2].m_data[1] = adj + ((k + 1) % 3 + 1) * noe;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < noe) {
            j = 0;
            while (j < 3) {
                this.m_neighbour[i].m_data[j] = i + (j + 1) * noe;
                this.m_neighbour[i + (j + 1) * noe].m_data[0] = i;
                ++j;
            }
            ++i;
        }
        if (this.hasElementColors()) {
            Color[] parentColor = this.getElementColors();
            i = 0;
            while (i < noe) {
                this.setElementColor(i + noe, parentColor[i]);
                this.setElementColor(i + 2 * noe, parentColor[i]);
                this.setElementColor(i + 3 * noe, parentColor[i]);
                ++i;
            }
        }
        if (this.m_elementBackColor != null) {
            Color[] parentColor = this.getElementBackColors();
            i = 0;
            while (i < noe) {
                this.setElementBackColor(i + noe, parentColor[i]);
                this.setElementBackColor(i + 2 * noe, parentColor[i]);
                this.setElementBackColor(i + 3 * noe, parentColor[i]);
                ++i;
            }
        }
        if (this.hasElementNormals()) {
            PdVector[] parentNormal = this.getElementNormals();
            i = 0;
            while (i < noe) {
                this.setElementNormal(i + noe, parentNormal[i]);
                this.setElementNormal(i + 2 * noe, parentNormal[i]);
                this.setElementNormal(i + 3 * noe, parentNormal[i]);
                ++i;
            }
        }
        int numVF = this.getNumVectorFields();
        i = 0;
        while (i < numVF) {
            Object vec;
            PgVectorField vf = this.getVectorField(i);
            if (vf.getBasedOn() == 0) {
                vf.setNumVectors(newNov);
                vec = vf.getVectors();
                j = nov;
                while (j < newNov) {
                    vec[j].blend(0.5, vec[ind1v.getEntry(j - nov)], 0.5, vec[ind2v.getEntry(j - nov)]);
                    ++j;
                }
            } else {
                vf.setNumVectors(noe * 4);
                j = 0;
                while (j < noe) {
                    vec = vf.getVector(j);
                    vf.setVector(j + noe, (PdVector)vec);
                    vf.setVector(j + 2 * noe, (PdVector)vec);
                    vf.setVector(j + 3 * noe, (PdVector)vec);
                    ++j;
                }
            }
            ++i;
        }
        if (this.hasElementTextures()) {
            PdVector[][] textures = this.getElementTextures();
            PdVector[] localTex = new PdVector[6];
            i = 0;
            while (i < 6) {
                localTex[i] = new PdVector();
                ++i;
            }
            i = 0;
            while (i < noe) {
                localTex[0].copy(oldTextures[i][0]);
                localTex[1].copy(oldTextures[i][1]);
                localTex[2].copy(oldTextures[i][2]);
                localTex[3].blend(0.5, oldTextures[i][1], 0.5, oldTextures[i][2]);
                localTex[4].blend(0.5, oldTextures[i][2], 0.5, oldTextures[i][0]);
                localTex[5].blend(0.5, oldTextures[i][0], 0.5, oldTextures[i][1]);
                j = 0;
                while (j < 4) {
                    if (j != 0) {
                        textures[j * noe + i] = new PdVector[3];
                    }
                    k = 0;
                    while (k < 3) {
                        textures[j * noe + i][k] = PdVector.copyNew(localTex[subScheme[j][k]]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.m_bndList != null) {
            k = 0;
            while (k < this.m_bndList.length) {
                if (!this.m_bndList[k].hasTag(2) && !this.m_bndList[k].makeElementInd()) {
                    this.removeBoundaries();
                    break;
                }
                ++k;
            }
        }
        return true;
    }

    public void computePlane(int numULines, int numVLines, double uMin, double vMin, double uMax, double vMax) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computePlane(numULines, numVLines, uMin, vMin, uMax, vMax);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    public static boolean triangulate(PgElementSet geom) {
        int j;
        int numTriangles = 0;
        int i = 0;
        while (i < geom.m_numElements) {
            numTriangles += geom.m_element[i].m_data.length;
            ++i;
        }
        PiVector oldElemIndex = new PiVector(numTriangles -= 2 * geom.getNumElements());
        PiVector[] triangleList = new PiVector[numTriangles];
        boolean bHasElemTexture = geom.hasElementTextures();
        PdVector[][] newTextures = null;
        if (bHasElemTexture) {
            newTextures = new PdVector[numTriangles][3];
        }
        int triInd = 0;
        i = 0;
        while (i < geom.m_numElements) {
            int len = geom.m_element[i].getSize();
            if (triInd + len - 2 > numTriangles) {
                PsDebug.warning("too many triangles, programming error");
            }
            PdVector[] patch = geom.getElementVertices(i);
            PiVector[] elemList = PgUtil.triangulate(patch);
            j = 0;
            while (j < len - 2) {
                int k;
                if (bHasElemTexture) {
                    k = 0;
                    while (k < 3) {
                        newTextures[triInd + j][k] = PdVector.copyNew(geom.m_elementTexture[i][elemList[j].m_data[k]]);
                        ++k;
                    }
                }
                k = 0;
                while (k < 3) {
                    elemList[j].m_data[k] = geom.m_element[i].m_data[elemList[j].m_data[k]];
                    ++k;
                }
                triangleList[triInd + j] = elemList[j];
                oldElemIndex.m_data[triInd + j] = i;
                ++j;
            }
            triInd += len - 2;
            ++i;
        }
        geom.setDimOfElements(3);
        geom.setNumElements(numTriangles);
        geom.setElements(triangleList);
        if (geom.hasElementColors()) {
            i = numTriangles - 1;
            while (i >= 0) {
                geom.setElementColor(i, geom.getElementColor(oldElemIndex.m_data[i]));
                --i;
            }
        }
        if (geom.getElementBackColors() != null) {
            i = numTriangles - 1;
            while (i >= 0) {
                geom.setElementBackColor(i, geom.getElementBackColor(oldElemIndex.m_data[i]));
                --i;
            }
        }
        if (geom.hasElementNormals()) {
            i = numTriangles - 1;
            while (i >= 0) {
                geom.setElementNormal(i, geom.getElementNormal(oldElemIndex.m_data[i]));
                --i;
            }
        }
        if (bHasElemTexture) {
            geom.setElementTextures(newTextures);
        }
        int numvecfields = geom.getNumVectorFields();
        i = 0;
        while (i < numvecfields) {
            PgVectorField orig = geom.getVectorField(i);
            if (orig.getBasedOn() != 0) {
                orig.setNumVectors(numTriangles);
                j = numTriangles - 1;
                while (j >= 0) {
                    orig.setVector(j, orig.getVector(oldElemIndex.m_data[j]));
                    --j;
                }
            }
            ++i;
        }
        int numBnds = geom.getNumBoundaries();
        i = 0;
        while (i < numBnds) {
            if (!geom.m_bndList[i].makeElementInd()) {
                geom.removeBoundaries();
                break;
            }
            ++i;
        }
        geom.makeNeighbour();
        return true;
    }

    public PvPickEvent intersectionWithLine(PdVector rayBase, PdVector rayDir) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector elemNormal = new PdVector(3);
        PdVector minNormal = new PdVector(3);
        int vertexInd = -1;
        int minElem = -1;
        int minSubElem = -1;
        double dist = Double.MAX_VALUE;
        double minDist = Double.MAX_VALUE;
        PdVector pos = new PdVector(3);
        PdVector pos2D = this.m_dim == 2 ? new PdVector(2) : pos;
        PdVector minPos = new PdVector(3);
        PdBary bary = new PdBary(3);
        PdBary minBary = new PdBary(3);
        PdVector elemBase = null;
        if (this.m_dim == 2) {
            elemBase = new PdVector(3);
        }
        int i = 0;
        while (i < this.m_numElements) {
            PdVector[] v = this.getElementVertices(i);
            if (v != null && v.length >= 3) {
                if (this.m_dim == 2) {
                    elemBase.copyArray(v[0]);
                } else {
                    elemBase = v[0];
                }
                int j = 1;
                while (j < v.length - 1) {
                    if (elemNormal.normalOfPlane(v[0], v[j], v[j + 1]) && !((dist = PuVectorGeom.intersectionOfLineAndPlane(pos, rayBase, rayDir, elemBase, elemNormal)) >= minDist)) {
                        if (this.m_dim == 2) {
                            pos2D.m_data[0] = pos.m_data[0];
                            pos2D.m_data[1] = pos.m_data[1];
                        }
                        PdBary.getBary(bary, pos2D, v[0], v[j], v[j + 1]);
                        if (bary.isInside()) {
                            minDist = dist;
                            minElem = i;
                            minSubElem = j;
                            minBary.copy(bary);
                            minNormal.copy(elemNormal);
                            minPos.copy(pos);
                            if (Math.abs(1.0 - bary.getEntry(0)) < 0.1) {
                                vertexInd = this.m_element[i].getEntry(0);
                            } else if (Math.abs(1.0 - bary.getEntry(1)) < 0.1) {
                                vertexInd = this.m_element[i].getEntry(j);
                            } else if (Math.abs(1.0 - bary.getEntry(2)) < 0.1) {
                                vertexInd = this.m_element[i].getEntry(j + 1);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (minElem == -1) {
            return null;
        }
        PvPickEvent point = new PvPickEvent(this.m_dim);
        point.setVertex(minPos);
        point.setDistance(minDist);
        point.setElementInd(minElem);
        point.setElementSubInd(minSubElem);
        point.setBary(minBary);
        point.setVertexInd(vertexInd);
        point.setViewBase(rayBase);
        point.setViewDir(rayDir);
        point.setNormal(minNormal);
        return point;
    }

    public boolean hasElementNormals() {
        return this.m_elementNormal != null && this.m_elementNormal.length == this.m_maxNumElements;
    }

    public boolean makeElementNormals() {
        int i2;
        if (this.m_numElements < 1) {
            return false;
        }
        this.assureElementNormals();
        if ((this.m_dim == 1 || this.m_dim == 2) && this.m_dimOfVectors == 3) {
            int i2 = 0;
            while (i2 < this.m_numElements) {
                this.m_elementNormal[i2].set(0.0, 0.0, 1.0);
                ++i2;
            }
            return true;
        }
        if (this.m_dim == 3 && this.m_dimOfVectors == 3) {
            PdVector edgeB = new PdVector(this.m_dim);
            PdVector edgeC = new PdVector(this.m_dim);
            PdVector normal = new PdVector(this.m_dimOfVectors);
            PdVector.setConstant(this.m_elementNormal, 0.0);
            i2 = 0;
            while (i2 < this.m_numElements) {
                int numEdges = this.m_element[i2].getSize();
                if (numEdges >= 2) {
                    PdVector vertexB = this.m_vertex[this.m_element[i2].m_data[(-2 + numEdges) % numEdges]];
                    PdVector vertexC = this.m_vertex[this.m_element[i2].m_data[(-1 + numEdges) % numEdges]];
                    edgeB.sub(vertexC, vertexB);
                    int j = 0;
                    while (j < numEdges) {
                        PdVector vertexA = vertexB;
                        vertexB = vertexC;
                        vertexC = this.m_vertex[this.m_element[i2].m_data[j]];
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        if (bOk && normal.normalize()) {
                            this.m_elementNormal[i2].add(normal);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < this.m_numElements) {
            this.m_elementNormal[i2].normalize();
            ++i2;
        }
        return true;
    }

    public boolean makeVertexNormals() {
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, 0.0);
        if ((this.m_dim == 1 || this.m_dim == 2) && this.m_dimOfVectors == 3) {
            int i = 0;
            while (i < this.m_numVertices) {
                this.m_vertexNormal[i].set(0.0, 0.0, 1.0);
                ++i;
            }
            return true;
        }
        if (this.m_dim == 3 && this.m_dimOfVectors == 3) {
            PdVector edgeB = new PdVector(this.m_dim);
            PdVector edgeC = new PdVector(this.m_dim);
            PdVector normal = new PdVector(this.m_dimOfVectors);
            PdVector.setConstant(this.m_vertexNormal, 0.0);
            int i = 0;
            while (i < this.m_numElements) {
                int numEdges = this.m_element[i].getSize();
                if (numEdges >= 2) {
                    PdVector vertexB = this.m_vertex[this.m_element[i].m_data[(-2 + numEdges) % numEdges]];
                    PdVector vertexC = this.m_vertex[this.m_element[i].m_data[(-1 + numEdges) % numEdges]];
                    edgeB.sub(vertexC, vertexB);
                    int j = 0;
                    while (j < numEdges) {
                        int vertexInd = this.m_element[i].m_data[(j - 1 + numEdges) % numEdges];
                        PdVector vertexA = vertexB;
                        vertexB = vertexC;
                        vertexC = this.m_vertex[this.m_element[i].m_data[j]];
                        edgeC.sub(vertexC, vertexB);
                        boolean bOk = normal.cross(edgeB, edgeC);
                        edgeB.copyArray(edgeC);
                        if (bOk && normal.normalize()) {
                            this.m_vertexNormal[vertexInd].add(normal);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertexNormal[i].normalize();
            ++i;
        }
        return true;
    }

    public PiVector getNeighbour(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_neighbour[anIndex];
    }

    public PiVector getEdge(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numEdges) {
            return null;
        }
        return this.m_edge[anIndex];
    }

    public boolean setEdge(int anIndex, PiVector aEdge) {
        if (anIndex < 0 || aEdge == null) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (anIndex >= this.m_numEdges) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numEdges + "=m_numEdges, bad programming style", this);
            this.setNumEdges(anIndex + 1, -1);
        }
        this.m_edge[anIndex].copy(aEdge);
        return true;
    }

    public PgElementEdge[] getEdgeList() {
        int j;
        int k;
        if (this.m_numElements < 1) {
            return null;
        }
        PgElementEdge edge = null;
        int[] vInd = new int[2];
        int numEdges = 0;
        int numVertices = 0;
        int i = 0;
        while (i < this.m_numElements) {
            int len = this.m_element[i].getSize();
            k = 0;
            while (k < len) {
                if (this.m_element[i].m_data[k] >= numVertices) {
                    numVertices = this.m_element[i].m_data[k] + 1;
                }
                ++k;
            }
            ++i;
        }
        Vector[] edgesAtVertex = new Vector[numVertices];
        i = 0;
        while (i < this.m_numElements) {
            int numElementEdges = this.m_element[i].getSize();
            k = 0;
            while (k < numElementEdges) {
                vInd[0] = this.m_element[i].m_data[k];
                vInd[1] = this.m_element[i].m_data[(k + 1) % numElementEdges];
                if (vInd[0] > vInd[1]) {
                    int vv = vInd[0];
                    vInd[0] = vInd[1];
                    vInd[1] = vv;
                }
                boolean bEdgeFound = false;
                if (edgesAtVertex[vInd[0]] == null) {
                    edgesAtVertex[vInd[0]] = new Vector();
                } else {
                    int numEdgesPerVertex = edgesAtVertex[vInd[0]].size();
                    j = 0;
                    while (j < numEdgesPerVertex) {
                        edge = (PgElementEdge)edgesAtVertex[vInd[0]].elementAt(j);
                        if (edge.getEdgeInd(1) == vInd[1]) {
                            bEdgeFound = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (bEdgeFound) {
                    edge.addElement(i, (k - 1 + numElementEdges) % numElementEdges);
                } else {
                    ++numEdges;
                    edge = new PgElementEdge(vInd[0], vInd[1]);
                    edge.addElement(i, (k - 1 + numElementEdges) % numElementEdges);
                    edgesAtVertex[vInd[0]].addElement(edge);
                }
                ++k;
            }
            ++i;
        }
        PgElementEdge[] edgeList = new PgElementEdge[numEdges];
        int countEdges = 0;
        i = 0;
        while (i < numVertices) {
            if (edgesAtVertex[i] != null) {
                j = 0;
                while (j < edgesAtVertex[i].size()) {
                    edgeList[countEdges] = (PgElementEdge)edgesAtVertex[i].elementAt(j);
                    ++countEdges;
                    ++j;
                }
            }
            ++i;
        }
        if (countEdges != numEdges) {
            PsDebug.warning("numEdges is wrong, edge list is void");
            PsDebug.warning("\t numEdges = " + numEdges + ", countEdges = " + countEdges);
        }
        return edgeList;
    }

    public PgElementEdge getEdge(int vInd1, int vInd2) {
        PgElementEdge edge = null;
        int i = 0;
        while (i < this.m_numElements) {
            block6: {
                int[] data = this.m_element[i].m_data;
                if (data == null) break block6;
                int elemLen = data.length;
                int k = 0;
                while (k < elemLen) {
                    block7: {
                        int kf;
                        block9: {
                            int km;
                            block8: {
                                if (data[k] != vInd1) break block7;
                                int kp = (k + 1) % elemLen;
                                km = (k - 1 + elemLen) % elemLen;
                                if (data[kp] != vInd2) break block8;
                                kf = km;
                                break block9;
                            }
                            if (data[km] != vInd2) break block7;
                            kf = (k - 2 + elemLen) % elemLen;
                        }
                        if (edge == null) {
                            edge = new PgElementEdge(vInd1, vInd2);
                        }
                        edge.addElement(i, kf);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return edge;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public void showElementBackColor(boolean flag) {
        this.m_globalElementBackColor.setEnabled(flag);
        this.m_bShowElementBackColor = flag;
    }

    public Color getElementBackColor(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_elementBackColor[anIndex];
    }

    public boolean setElementBackColor(int anIndex, Color aColor) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementBackColor == null || anIndex >= this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        this.m_elementBackColor[anIndex] = aColor;
        return true;
    }

    public void computeSphere(int numULines, int numVLines, double radius) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSphere(numULines, numVLines, radius);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    public Object clone() {
        PgElementSet clone = (PgElementSet)super.clone();
        if (clone == null) {
            return null;
        }
        clone.m_globalElementColor = (PdColor)this.m_globalElementColor.clone();
        clone.m_globalElementBackColor = (PdColor)this.m_globalElementBackColor.clone();
        clone.m_globalElementTagColor = (PdColor)this.m_globalElementTagColor.clone();
        clone.m_globalElementColor.setParent(clone);
        clone.m_globalElementTagColor.setParent(clone);
        clone.m_globalBndSize = (PuDouble)this.m_globalBndSize.clone();
        clone.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        clone.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        clone.m_globalBndSize.setParent(clone);
        clone.m_globalBndColor.setParent(clone);
        clone.m_globalBndTagColor.setParent(clone);
        clone.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        clone.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        clone.m_globalEdgeTagColor = (PdColor)this.m_globalEdgeTagColor.clone();
        clone.m_globalEdgeSize.setParent(clone);
        clone.m_globalEdgeColor.setParent(clone);
        clone.m_globalEdgeTagColor.setParent(clone);
        clone.m_globalElementNormalLength = (PuDouble)this.m_globalElementNormalLength.clone();
        clone.m_globalElementNormalSize = (PuDouble)this.m_globalElementNormalSize.clone();
        clone.m_globalElementNormalColor = (PdColor)this.m_globalElementNormalColor.clone();
        clone.m_globalElementNormalLength.setParent(clone);
        clone.m_globalElementNormalSize.setParent(clone);
        clone.m_globalElementNormalColor.setParent(clone);
        if (this.m_element != null) {
            clone.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            clone.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            clone.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            clone.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            clone.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            clone.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_bndList != null) {
            clone.removeBoundaries();
            int numBnd = this.getNumBoundaries();
            if (numBnd > 0) {
                PgBndPolygon[] bndClone = (PgBndPolygon[])this.m_bndList.clone();
                int i = 0;
                while (i < numBnd) {
                    bndClone[i] = (PgBndPolygon)bndClone[i].clone();
                    ++i;
                }
                clone.setBoundary(bndClone);
            }
        }
        if (this.m_elementSaved != null) {
            clone.m_elementSaved = (PiVector[])P_Vector.clone(this.m_elementSaved);
        }
        if (this.m_edge != null) {
            clone.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            clone.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        return clone;
    }

    public void buildTriangle(PdVector[] triangle, int discr) {
        if (triangle == null || triangle.length < 3) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int nov = discr * (discr + 1) / 2;
        int noe = (discr - 1) * (discr - 1);
        this.setNumVertices(nov);
        this.setNumElements(noe);
        PdVector p = new PdVector(this.m_dim);
        PdVector q = new PdVector(this.m_dim);
        int ind = 0;
        int i = 0;
        while (i < discr) {
            double u = (double)i / (double)(discr - 1);
            p.blend(1.0 - u, triangle[0], u, triangle[1]);
            q.blend(1.0 - u, triangle[2], u, triangle[1]);
            this.m_vertex[ind++].copy(p);
            int j = 1;
            while (j < discr - i) {
                double v = (double)j / (double)(discr - 1 - i);
                this.m_vertex[ind++].blend(1.0 - v, p, v, q);
                ++j;
            }
            ++i;
        }
        this.makeTriangleConn(discr);
        this.makeTriangleBnd(discr);
    }

    public void setNumEdges(int aNumEdges, int dimOfEdges) {
        if (this.m_numEdges == aNumEdges) {
            return;
        }
        this.m_edge = dimOfEdges > -1 ? PiVector.realloc(this.m_edge, aNumEdges, dimOfEdges) : PiVector.realloc(this.m_edge, aNumEdges);
        this.m_numEdges = aNumEdges;
        if (this.m_edgeColor != null) {
            this.assureEdgeColors();
        }
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public boolean isShowingTaggedEdges() {
        return this.m_bShowTaggedEdges;
    }

    public void showBackface(boolean flag) {
        this.m_bShowBackface = flag;
        if (this.m_bShowBackface && this.m_elementNormal == null) {
            this.makeElementNormals();
        }
    }

    public void showTaggedEdges(boolean flag) {
        this.m_bShowTaggedEdges = flag;
    }

    public void flipEdges() {
        int k;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("valid for triangulations only");
            return;
        }
        PdVector[] p = new PdVector[4];
        PdVector[] d = PdVector.realloc(null, 4, this.m_dim);
        boolean flip = true;
        double[] angle = new double[4];
        int numFlips = 0;
        int numPasses = 0;
        int numVoidFlips = 0;
        PdVector normal0 = new PdVector(3);
        PdVector normal1 = new PdVector(3);
        PdVector normal = new PdVector(3);
        while (flip) {
            if (++numPasses > 10) {
                PsDebug.warning("too many passes");
                break;
            }
            flip = false;
            int i = 0;
            while (i < this.m_numElements) {
                k = 0;
                while (k < 3) {
                    int otherElem = this.m_neighbour[i].m_data[k];
                    if (otherElem != -1 && otherElem <= i) {
                        int ind00 = k;
                        int ind01 = (k + 1) % 3;
                        int ind02 = (k + 2) % 3;
                        int ind10 = this.getOppVertexLocInd(i, k);
                        int ind11 = (ind10 + 1) % 3;
                        int ind12 = (ind10 + 2) % 3;
                        if (this.m_neighbour[i].m_data[ind01] == this.m_neighbour[otherElem].m_data[ind12] && this.m_neighbour[i].m_data[ind01] > -1 || this.m_neighbour[i].m_data[ind02] == this.m_neighbour[otherElem].m_data[ind11] && this.m_neighbour[i].m_data[ind02] > -1) {
                            ++numVoidFlips;
                        } else {
                            p[0] = this.m_vertex[this.m_element[i].m_data[ind00]];
                            p[1] = this.m_vertex[this.m_element[i].m_data[ind01]];
                            p[2] = this.m_vertex[this.m_element[otherElem].m_data[ind10]];
                            p[3] = this.m_vertex[this.m_element[i].m_data[ind02]];
                            int j = 0;
                            while (j < 4) {
                                d[j].sub(p[(j + 1) % 4], p[j]);
                                ++j;
                            }
                            normal0.cross(d[3], d[0]);
                            normal0.normalize();
                            normal1.cross(d[1], d[2]);
                            normal1.normalize();
                            normal.add(normal0, normal1);
                            normal.normalize();
                            j = 0;
                            while (j < 4) {
                                angle[j] = Math.PI - PdVector.angleWithOrientation(d[(j - 1 + 4) % 4], d[j], normal);
                                ++j;
                            }
                            if (angle[0] + angle[2] > angle[1] + angle[3]) {
                                ++numFlips;
                                flip = true;
                                int nb = this.m_neighbour[i].m_data[ind01];
                                if (nb > -1) {
                                    this.m_neighbour[nb].m_data[this.getOppVertexLocInd((int)i, (int)ind01)] = otherElem;
                                }
                                if ((nb = this.m_neighbour[otherElem].m_data[ind11]) > -1) {
                                    this.m_neighbour[nb].m_data[this.getOppVertexLocInd((int)otherElem, (int)ind11)] = i;
                                }
                                this.m_element[i].m_data[ind02] = this.m_element[otherElem].m_data[ind10];
                                this.m_element[otherElem].m_data[ind12] = this.m_element[i].m_data[ind00];
                                this.m_neighbour[i].m_data[ind00] = this.m_neighbour[otherElem].m_data[ind11];
                                this.m_neighbour[otherElem].m_data[ind10] = this.m_neighbour[i].m_data[ind01];
                                this.m_neighbour[i].m_data[ind01] = otherElem;
                                this.m_neighbour[otherElem].m_data[ind11] = i;
                            }
                        }
                    }
                    ++k;
                }
                ++i;
            }
        }
        k = 0;
        while (this.m_bndList != null && k < this.m_bndList.length) {
            if (!this.m_bndList[k].hasTag(2)) {
                this.m_bndList[k].makeElementInd();
            }
            ++k;
        }
        PsDebug.notify("Statistics\n\tnumber of flipped edges = " + numFlips + "\n\tnumber of passes\t\t\t = " + numPasses + "\n\tnumber of void edges\t = " + numVoidFlips);
    }

    public int getNumBoundaryEdges() {
        int numBndEdges = 0;
        if (this.m_neighbour == null) {
            int i = 0;
            while (i < this.m_numElements) {
                numBndEdges += this.m_element[i].getSize();
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_numElements) {
                int j = 0;
                while (j < this.m_element[i].getSize()) {
                    if (this.m_neighbour[i].m_data[j] == -1) {
                        ++numBndEdges;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return numBndEdges;
    }

    public int getNumEdges() {
        int numEdges = 0;
        if (this.m_neighbour == null) {
            int i = 0;
            while (i < this.m_numElements) {
                numEdges += this.m_element[i].getSize();
                ++i;
            }
            return numEdges;
        }
        int i = 0;
        while (i < this.m_numElements) {
            int j = 0;
            while (j < this.m_element[i].getSize()) {
                if (this.m_neighbour[i].m_data[j] < i) {
                    ++numEdges;
                }
                ++j;
            }
            ++i;
        }
        return numEdges;
    }

    public int getNumBoundaryVertices() {
        int nobv = 0;
        int i = 0;
        while (i < this.m_numVertices) {
            if (this.m_vertex[i].hasTag(13)) {
                ++nobv;
            }
            ++i;
        }
        return nobv;
    }

    public void setConforming(boolean flag) {
        this.m_bConforming = flag;
        if (this.m_bndList != null) {
            int i = 0;
            while (i < this.m_bndList.length) {
                if (this.m_bndList[i] != null) {
                    this.m_bndList[i].m_bConforming = flag;
                }
                ++i;
            }
        }
    }

    public void makeQuadrConn(int uDiscr, int vDiscr) {
        if (uDiscr < 2 || vDiscr < 2) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * (uDiscr - 1) * (vDiscr - 1));
            int ind = 0;
            int end = 0;
            int i = 0;
            while (i < uDiscr - 1) {
                int j = 0;
                while (j < vDiscr - 1) {
                    this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, i * vDiscr + j + 1);
                    this.m_element[ind++].set(i * vDiscr + j + 1, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                    this.m_neighbour[end].set(end + 1, end - 2 * (vDiscr - 1) + 1, end - 1);
                    this.m_neighbour[++end].set(end + 2 * (vDiscr - 1) - 1, end + 1, end - 1);
                    ++end;
                    ++j;
                }
                ++i;
            }
            end = 0;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_neighbour[end].m_data[2] = -1;
                this.m_neighbour[end += 2 * (vDiscr - 1) - 1].m_data[1] = -1;
                ++end;
                ++i;
            }
            end = 0;
            int j = 0;
            while (j < vDiscr - 1) {
                this.m_neighbour[end].m_data[1] = -1;
                end += 2;
                ++j;
            }
            end = 2 * (vDiscr - 1) * (uDiscr - 2) + 1;
            j = 0;
            while (j < vDiscr - 1) {
                this.m_neighbour[end].m_data[0] = -1;
                end += 2;
                ++j;
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements((uDiscr - 1) * (vDiscr - 1));
            int ind = 0;
            int end = 0;
            int i = 0;
            while (i < uDiscr - 1) {
                int j = 0;
                while (j < vDiscr - 1) {
                    this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1, i * vDiscr + j + 1);
                    this.m_neighbour[end].set(end + (vDiscr - 1), end + 1, end - (vDiscr - 1), end - 1);
                    ++end;
                    ++j;
                }
                ++i;
            }
            end = 0;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_neighbour[end].m_data[3] = -1;
                this.m_neighbour[end += vDiscr - 1 - 1].m_data[1] = -1;
                ++end;
                ++i;
            }
            end = 0;
            int j = 0;
            while (j < vDiscr - 1) {
                this.m_neighbour[end].m_data[2] = -1;
                ++end;
                ++j;
            }
            end = (vDiscr - 1) * (uDiscr - 2);
            j = 0;
            while (j < vDiscr - 1) {
                this.m_neighbour[end].m_data[0] = -1;
                ++end;
                ++j;
            }
        }
    }

    public void makeAlternatingQuadrConn(int uDiscr, int vDiscr, boolean alternateUDir) {
        if (uDiscr < 2 || vDiscr < 2) {
            return;
        }
        this.setDimOfElements(3);
        this.setNumElements(2 * (uDiscr - 1) * (vDiscr - 1));
        int ind = 0;
        int i = 0;
        while (i < uDiscr - 1) {
            int j = 0;
            while (j < vDiscr - 1) {
                if (!alternateUDir) {
                    if (j % 2 == 0) {
                        this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, i * vDiscr + j + 1);
                        this.m_element[ind++].set(i * vDiscr + j + 1, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                    } else {
                        this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j + 1, i * vDiscr + j + 1);
                        this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                    }
                } else if (i % 2 == 0) {
                    this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, i * vDiscr + j + 1);
                    this.m_element[ind++].set(i * vDiscr + j + 1, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                } else {
                    this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j + 1, i * vDiscr + j + 1);
                    this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                }
                ++j;
            }
            ++i;
        }
        this.makeNeighbour();
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public void showTaggedBoundaries(boolean flag) {
        this.m_bShowTaggedBoundaries = flag;
    }

    public void buildPolygon(PdVector[] polygon, int discr) {
        PsDebug.error("empty method", this);
    }

    public int getNumBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public void computeSnail(int numULines, int numVLines, double numWindings) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSnail(numULines, numVLines, numWindings);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    public void markBoundary() {
        int i = 0;
        while (i < this.m_numVertices) {
            this.m_vertex[i].clearTag(13);
            ++i;
        }
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_element.length) {
            PsDebug.warning("void neighbour connectivity", this);
            return;
        }
        i = 0;
        while (i < this.m_numElements) {
            int len = this.m_neighbour[i].getSize();
            int j = 0;
            while (j < len) {
                if (this.m_neighbour[i].m_data[j] < 0) {
                    if (this.isConforming()) {
                        this.m_vertex[this.m_element[i].m_data[(j + 1) % len]].setTag(13);
                        this.m_vertex[this.m_element[i].m_data[(j + 2) % len]].setTag(13);
                    } else {
                        this.m_vertex[this.m_element[i].m_data[j]].setTag(13);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numElements < 1 || !this.m_bConforming) {
            return true;
        }
        this.assureNeighbours();
        PgElementEdge[] edge = this.getEdgeList();
        if (edge == null) {
            PsDebug.notify("missing edge list");
            return false;
        }
        int i = 0;
        while (i < edge.length) {
            int[] edgeElem = edge[i].getElements();
            if (edgeElem != null) {
                int len = edge[i].getSize();
                if (len == 1) {
                    this.m_neighbour[edgeElem[0]].m_data[edge[i].m_neighbourLocInd[0]] = -1;
                } else if (len == 2) {
                    this.m_neighbour[edgeElem[0]].m_data[edge[i].m_neighbourLocInd[0]] = edgeElem[1];
                    this.m_neighbour[edgeElem[1]].m_data[edge[i].m_neighbourLocInd[1]] = edgeElem[0];
                } else if (len > 2) {
                    int j = 0;
                    while (j < len) {
                        this.m_neighbour[edgeElem[j]].m_data[edge[i].m_neighbourLocInd[j]] = -1;
                        ++j;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public int getNumBoundaryComponents() {
        int v = this.m_numVertices;
        int f = this.m_numElements;
        if (this.m_dimOfElements == 3) {
            int v_b = this.getNumBoundaryEdges();
            int v_i = v - v_b;
            return (f - 2 * v_i - v_b + 2) / 2 + 1;
        }
        int e = this.getNumEdges();
        return 2 - (v - e + f);
    }

    public PgGeometry reflect(PdMatrix mat, boolean bOrient, boolean bVector) {
        int i;
        if (mat == null || mat.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + mat);
            return null;
        }
        PgElementSet reflGeom = (PgElementSet)super.reflect(mat, bOrient, bVector);
        if (!bOrient) {
            PiVector[] reflElement = reflGeom.getElements();
            int i2 = 0;
            while (i2 < this.m_numElements) {
                reflElement[i2].invert();
                ++i2;
            }
            PiVector[] reflNeighbour = reflGeom.getNeighbours();
            if (reflNeighbour != null) {
                i = 0;
                while (i < this.m_numElements) {
                    reflNeighbour[i].invert();
                    int elemLen = reflNeighbour[i].getSize();
                    int k = 3;
                    while (k < elemLen) {
                        reflNeighbour[i].shift(1);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        if (this.hasElementNormals()) {
            PdVector[] normal = this.getElementNormals();
            PdVector[] reflNormal = reflGeom.getElementNormals();
            i = 0;
            while (i < this.m_numElements) {
                reflNormal[i].leftMultAffin(mat, normal[i], false);
                if (!bVector) {
                    reflNormal[i].multScalar(-1.0);
                }
                reflNormal[i].normalize();
                ++i;
            }
        }
        if (!bOrient && this.hasElementTextures()) {
            PdVector[][] reflTex = reflGeom.getElementTextures();
            i = 0;
            while (i < this.m_numElements) {
                int len = reflTex[i].length;
                int nop = len / 2;
                int k = 0;
                while (k < nop) {
                    PdVector tmp = reflTex[i][k];
                    reflTex[i][k] = reflTex[i][len - 1 - k];
                    reflTex[i][len - 1 - k] = tmp;
                    ++k;
                }
                ++i;
            }
        }
        return reflGeom;
    }

    public int addEdge(PiVector anEdge) {
        this.setEdge(this.m_numEdges, anEdge);
        return this.m_numEdges - 1;
    }

    public double getArea() {
        double area = 0.0;
        int i = 0;
        while (i < this.m_numElements) {
            area += this.getAreaOfElement(i);
            ++i;
        }
        return area;
    }

    public boolean hasElementTextures() {
        return this.m_elementTexture != null && this.m_elementTexture.length == this.m_maxNumElements;
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_bShowVertices = false;
        this.m_elementNormal = null;
        this.m_elementColor = null;
        this.m_elementBackColor = null;
        this.m_bShowElementColors = false;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_edgeColor = null;
        this.m_bShowEdgeColors = false;
        this.m_edge = null;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_globalElementColor.setColor(new Color(200, 255, 0));
        this.m_globalElementBackColor.setColor(new Color(255, 200, 0));
        this.m_globalElementBackColor.setEnabled(this.m_bShowElementBackColor);
        this.m_globalElementTagColor.setColor(Color.magenta);
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_globalElementNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalElementNormalSize.setDefValue(1.0);
        this.m_globalElementNormalSize.init();
        this.m_globalElementNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalElementNormalLength.setDefValue(0.5);
        this.m_globalElementNormalLength.init();
        this.m_globalElementNormalColor.setColor(Color.yellow);
        this.m_bShowOutline = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.red);
        this.m_globalEdgeSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_bndList = null;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_globalBndSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalBndSize.setDefValue(3.0);
        this.m_globalBndSize.init();
        this.m_bShowElementTexture = false;
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdges) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdges);
        }
    }

    public void setEdgeColors(Color[] color) {
        if (color == null) {
            this.m_edgeColor = null;
            return;
        }
        if (color.length < this.m_numEdges) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assureEdgeColors();
        PdColor.copy(this.m_edgeColor, 0, color, 0, this.m_numEdges);
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public void setBoundary(PgBndPolygon[] newBnd) {
        this.m_bndList = newBnd;
        int num = this.getNumBoundaries();
        int i = 0;
        while (i < num) {
            this.m_bndList[i].setElementSet(this);
            ++i;
        }
    }

    public void assureBoundary(int num) {
        int i;
        if (this.m_bndList != null && this.m_bndList.length == num) {
            return;
        }
        PgBndPolygon[] tmp = this.m_bndList;
        this.m_bndList = new PgBndPolygon[num];
        int origLength = 0;
        if (tmp != null) {
            origLength = tmp.length;
            i = 0;
            while (i < Math.min(origLength, num)) {
                this.m_bndList[i] = tmp[i];
                ++i;
            }
        }
        i = origLength;
        while (i < num) {
            this.m_bndList[i] = new PgBndPolygon(this.m_dim);
            this.m_bndList[i].setElementSet(this);
            this.m_bndList[i].setDimOfVectors(this.getDimOfVectors());
            ++i;
        }
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showElementColors(boolean flag) {
        this.m_bShowElementColors = flag;
    }

    public void showEdgeColors(boolean flag) {
        this.m_bShowEdgeColors = flag;
    }

    public void showElementTexture(boolean flag) {
        this.m_bShowElementTexture = flag;
    }

    public void setDimOfColors(int aSize) {
        if (aSize < 0 || this.m_dimOfColors == aSize) {
            return;
        }
        super.setDimOfColors(aSize);
    }

    public void setDimOfVectors(int aSize) {
        if (aSize < 0 || aSize == this.m_dim) {
            return;
        }
        super.setDimOfVectors(aSize);
        if (this.m_elementNormal != null) {
            int i = 0;
            while (i < this.m_maxNumElements) {
                this.m_elementNormal[i].setSize(aSize);
                ++i;
            }
        }
        if (this.hasBoundary()) {
            int j = 0;
            while (j < this.m_bndList.length) {
                if (this.m_bndList[j] != null) {
                    this.m_bndList[j].setDimOfVectors(aSize);
                }
                ++j;
            }
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void buildTriangleFromCurve(PgPolygon[] curve, PgBndConstraint[] bndConstr) {
        int k;
        double v;
        int j;
        int jdx;
        PdVector q;
        PdVector p;
        if (curve == null || bndConstr == null) {
            PsDebug.warning("missing argument", this);
            return;
        }
        if (curve.length != 3 || bndConstr.length != 3) {
            PsDebug.warning("wrong argument array list", this);
            return;
        }
        int discr = curve[0].getNumVertices();
        int nov = discr * (discr + 1) / 2;
        int noe = (discr - 1) * (discr - 1);
        this.setNumVertices(nov);
        this.setNumElements(noe);
        int idx = discr;
        int i = 1;
        while (i < discr - 1) {
            p = curve[0].m_vertex[i];
            q = curve[1].m_vertex[discr - 1 - i];
            jdx = 1;
            j = 1;
            while (j < discr - 1 - i) {
                v = (double)j / (double)(discr - 1 - i);
                k = 0;
                while (k < this.m_dim) {
                    this.m_vertex[idx + jdx].m_data[k] = p.m_data[k] + v * (q.m_data[k] - p.m_data[k]);
                    ++k;
                }
                ++jdx;
                ++j;
            }
            idx += discr - i;
            ++i;
        }
        --idx;
        i = 1;
        while (i < discr - 1) {
            p = curve[1].m_vertex[i];
            q = curve[2].m_vertex[discr - 1 - i];
            jdx = -i - 2;
            j = 1;
            while (j < discr - 1 - i) {
                v = (double)j / (double)(discr - 1 - i);
                k = 0;
                while (k < this.m_dim) {
                    int n = k;
                    this.m_vertex[idx + jdx].m_data[n] = this.m_vertex[idx + jdx].m_data[n] + (p.m_data[k] + v * (q.m_data[k] - p.m_data[k]));
                    ++k;
                }
                jdx -= i + j + 2;
                ++j;
            }
            idx -= i + 1;
            ++i;
        }
        --idx;
        i = 1;
        while (i < discr - 1) {
            p = curve[2].m_vertex[i];
            q = curve[0].m_vertex[discr - 1 - i];
            jdx = discr - 1;
            j = 1;
            while (j < discr - 1 - i) {
                v = (double)j / (double)(discr - 1 - i);
                k = 0;
                while (k < this.m_dim) {
                    int n = k;
                    this.m_vertex[idx + jdx].m_data[n] = this.m_vertex[idx + jdx].m_data[n] + (p.m_data[k] + v * (q.m_data[k] - p.m_data[k]));
                    ++k;
                }
                jdx += discr - 1 - j;
                ++j;
            }
            --idx;
            ++i;
        }
        idx = discr;
        i = 1;
        while (i < discr - 1) {
            jdx = 1;
            j = 1;
            while (j < discr - i - 1) {
                k = 0;
                while (k < this.m_dim) {
                    int n = k++;
                    this.m_vertex[idx + jdx].m_data[n] = this.m_vertex[idx + jdx].m_data[n] / 3.0;
                }
                ++jdx;
                ++j;
            }
            idx += discr - i;
            ++i;
        }
        idx = 0;
        i = 0;
        while (i < discr) {
            this.m_vertex[idx].copy(curve[0].m_vertex[i]);
            idx += discr - i;
            ++i;
        }
        --idx;
        i = 0;
        while (i < discr) {
            this.m_vertex[idx].copy(curve[1].m_vertex[i]);
            idx -= i + 1;
            ++i;
        }
        idx += discr;
        i = 0;
        while (i < discr) {
            this.m_vertex[idx].copy(curve[2].m_vertex[i]);
            --idx;
            ++i;
        }
        this.makeTriangleConn(discr);
        this.makeTriangleBnd(discr);
        i = 0;
        while (i < bndConstr.length) {
            this.m_bndList[i].m_bndConstraint = bndConstr[i];
            ++i;
        }
    }

    public boolean setElementTexture(int anIndex, PdVector[] aTexture) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aTexture == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementTexture == null || anIndex >= this.m_elementTexture.length) {
            this.assureElementTextures();
        }
        this.m_elementTexture[anIndex] = PdVector.copyNew(aTexture, aTexture.length);
        return true;
    }

    public void setElementColors(Color[] color) {
        if (color == null) {
            this.m_elementColor = null;
            return;
        }
        if (color.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementColor == null || this.m_numElements > this.m_elementColor.length) {
            this.assureElementColors();
        }
        PdColor.copy(this.m_elementColor, 0, color, 0, this.m_numElements);
    }

    public double getVolumeOfElement(int elemInd) {
        PdVector[] v = this.getElementVertices(elemInd);
        if (v == null || v.length < 3) {
            return 0.0;
        }
        PdVector origin = new PdVector(this.m_dim);
        PdVector normal = new PdVector(this.m_dim);
        origin.setConstant(0.0);
        normal.normalOfPlane(v[0], v[1], v[2]);
        double height = PuVectorGeom.distOfPointToPlane(origin, v[0], normal);
        double area = PdVector.area(v);
        return area * height / 3.0;
    }

    public boolean makeElementFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        int i = 0;
        while (i < this.m_numElements) {
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            int elemLen = this.m_element[i].getSize();
            int j = 0;
            while (j < elemLen) {
                red += (float)this.m_vertexColor[this.m_element[i].m_data[j]].getRed();
                green += (float)this.m_vertexColor[this.m_element[i].m_data[j]].getGreen();
                blue += (float)this.m_vertexColor[this.m_element[i].m_data[j]].getBlue();
                ++j;
            }
            this.setElementColor(i, new Color((int)(red /= (float)elemLen), (int)(green /= (float)elemLen), (int)(blue /= (float)elemLen)));
            ++i;
        }
        return true;
    }

    public boolean makeVertexFromElementColors() {
        if (!this.hasElementColors()) {
            PsDebug.warning("missing element colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numElements == 0) {
            return true;
        }
        this.assureVertexColors();
        PdVector[] color = PdVector.realloc(null, this.m_numVertices, 3);
        int[] colNum = new int[this.m_numVertices];
        int i = 0;
        while (i < this.m_numElements) {
            int elemLen = this.m_element[i].getSize();
            int j = 0;
            while (j < elemLen) {
                int vertInd = this.m_element[i].m_data[j];
                color[vertInd].m_data[0] = color[vertInd].m_data[0] + (double)this.m_elementColor[i].getRed();
                color[vertInd].m_data[1] = color[vertInd].m_data[1] + (double)this.m_elementColor[i].getGreen();
                color[vertInd].m_data[2] = color[vertInd].m_data[2] + (double)this.m_elementColor[i].getBlue();
                int n = vertInd;
                colNum[n] = colNum[n] + 1;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            color[i].multScalar(1.0 / (double)colNum[i]);
            this.setVertexColor(i, new Color((float)color[i].m_data[0], (float)color[i].m_data[1], (float)color[i].m_data[2]));
            ++i;
        }
        return true;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength.getValue();
    }

    public void setGlobalElementNormalLength(double length) {
        this.m_globalElementNormalLength.setValue(length);
    }

    public void buildQuadr(PdVector[] quadr, int uDiscr, int vDiscr) {
        if (quadr == null || quadr.length < 4) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int uSub = 0;
        int vSub = 0;
        int nov = (1 + (uDiscr - 1) * (uSub + 1)) * (1 + (vDiscr - 1) * (vSub + 1));
        int noePerPatch = 4 + 2 * uSub + 2 * vSub - 2;
        int noe = (uDiscr - 1) * (vDiscr - 1) * noePerPatch;
        this.setNumVertices(nov);
        this.setNumElements(noe);
        PdVector p = new PdVector(this.m_dim);
        PdVector q = new PdVector(this.m_dim);
        int ind = 0;
        int i = 0;
        while (i < uDiscr) {
            double u = (double)i / ((double)uDiscr - 1.0);
            p.blend(1.0 - u, quadr[0], u, quadr[1]);
            q.blend(1.0 - u, quadr[3], u, quadr[2]);
            int j = 0;
            while (j < vDiscr) {
                double v = (double)j / ((double)vDiscr - 1.0);
                this.m_vertex[ind++].blend(1.0 - v, p, v, q);
                ++j;
            }
            ++i;
        }
        this.makeQuadrConn(uDiscr, vDiscr);
        this.makeQuadrBnd(uDiscr, vDiscr);
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public void showElementNormals(boolean flag) {
        this.m_bShowElementNormals = flag;
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void setElementNormals(PdVector[] normal) {
        if (normal == null) {
            this.m_elementNormal = null;
            return;
        }
        if (normal.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_elementNormal == null || this.m_numElements > this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        PdVector.copy(this.m_elementNormal, 0, normal, 0, this.m_numElements);
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return false;
        }
        int i = 0;
        while (i < this.m_numElements) {
            int elemLen = this.m_element[i].getSize();
            int j = 0;
            while (j < elemLen) {
                if (this.m_neighbour[i].m_data[j] == -1) {
                    this.m_vertexNormal[this.m_element[i].m_data[(j + 1) % elemLen]].setConstant(0.0);
                    this.m_vertexNormal[this.m_element[i].m_data[(j + 2) % elemLen]].setConstant(0.0);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public PgElementSet() {
        this(3);
    }

    public PgElementSet(int aVertexDim) {
        super(aVertexDim);
        this.setTag(6);
        this.setDimOfSimplex(2);
        this.m_element = new PiVector[0];
        this.m_neighbour = new PiVector[0];
        this.m_elementSaved = null;
        this.m_elementTexture = null;
        this.m_globalElementColor = new PdColor(PsConfig.getMessage("Face"), this);
        this.m_globalElementBackColor = new PdColor(PsConfig.getMessage("FaceBack"), this);
        this.m_globalElementTagColor = new PdColor(PsConfig.getMessage("FaceTag"), this);
        this.m_globalElementNormalLength = new PuDouble(PsConfig.getMessage("globalElementNormalLength"), this);
        this.m_globalElementNormalSize = new PuDouble(PsConfig.getMessage("globalElementNormalSize"), this);
        this.m_globalElementNormalColor = new PdColor(PsConfig.getMessage("globalElementNormalColor"), this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage("Edge"), this);
        this.m_globalEdgeTagColor = new PdColor(PsConfig.getMessage("EdgeTag"), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage("EdgeSize"), this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage("Boundary"), this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage("BoundaryTag"), this);
        this.m_globalBndSize = new PuDouble(PsConfig.getMessage("BoundarySize"), this);
        if (this.getClass() == (class$jv$geom$PgElementSet != null ? class$jv$geom$PgElementSet : (class$jv$geom$PgElementSet = PgElementSet.class$("jv.geom.PgElementSet")))) {
            this.init();
        }
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void paint(PvGeometryIf dc) {
        super.paint(dc);
        dc.setState(83, this.isShowingEdgeLabels());
        dc.setState(84, this.isShowingElementLabels());
        dc.setState(68, this.m_bShowBackface);
        dc.setState(87, this.m_bShowOutline);
        dc.setState(52, this.m_bShowEdges);
        dc.setState(53, this.m_bShowTaggedEdges);
        dc.setState(93, this.m_bShowEdgeColors);
        if (this.m_bShowEdges || this.m_bShowOutline) {
            if (this.m_globalEdgeSize != null) {
                dc.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
            }
            if (this.m_globalEdgeColor != null) {
                dc.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
            }
            if (this.m_globalEdgeTagColor != null) {
                dc.setGlobalEdgeTagColor(this.m_globalEdgeTagColor.getColor());
            }
        }
        dc.setState(58, this.m_bShowBoundaries);
        dc.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_bShowBoundaries || this.m_bShowOutline) {
            if (this.m_globalBndSize != null) {
                dc.setGlobalBndSize(this.m_globalBndSize.getValue());
            }
            if (this.m_globalBndColor != null) {
                dc.setGlobalBndColor(this.m_globalBndColor.getColor());
            }
            if (this.m_globalBndColor != null) {
                dc.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
            }
        }
        dc.setState(56, this.m_bShowElements);
        dc.setState(57, this.m_bShowTaggedElements);
        dc.setState(94, this.m_bShowElementColors);
        dc.setState(99, this.m_bShowElementBackColor);
        dc.setState(100, this.m_bShowElementBackColors);
        dc.setNumElements(this.m_numElements);
        dc.setElements(this.m_element);
        if (this.isConforming()) {
            dc.setNeighbours(this.m_neighbour);
        } else {
            dc.setNeighbours(null);
        }
        dc.setElementColors(this.m_elementColor);
        dc.setElementBackColors(this.m_elementBackColor);
        dc.setState(62, this.m_bShowElementNormals);
        dc.setState(63, this.m_bShowElementNormalArrow);
        dc.setElementNormals(this.m_elementNormal);
        if (this.m_globalElementNormalSize != null) {
            dc.setGlobalElementNormalSize(this.m_globalElementNormalSize.getValue());
        }
        if (this.m_globalElementNormalLength != null) {
            dc.setGlobalElementNormalLength(this.m_globalElementNormalLength.getValue());
        }
        if (this.m_globalElementNormalColor != null) {
            dc.setGlobalElementNormalColor(this.m_globalElementNormalColor.getColor());
        }
        dc.setState(72, this.m_bShowElementTexture);
        if (this.m_bShowElementTexture && this.m_texture != null) {
            dc.setTexture(PsImage.getPixels(this.m_texture.getImage()), this.m_texture.getWidth(), this.m_texture.getHeight());
            dc.setElementTextures(this.m_elementTexture);
        }
        if (this.m_globalElementColor != null) {
            dc.setGlobalElementColor(this.m_globalElementColor.getColor());
        }
        if (this.m_globalElementBackColor != null) {
            dc.setGlobalElementBackColor(this.m_globalElementBackColor.getColor());
        }
        if (this.m_globalElementTagColor != null) {
            dc.setGlobalElementTagColor(this.m_globalElementTagColor.getColor());
        }
    }

    public int[] removeElement(int ind) {
        this.m_element[ind].setTag(2);
        return this.removeMarkedElements();
    }

    public void setTagElement(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_element[anIndex].setTag(aTag);
    }

    public Color getElementColor(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_elementColor[anIndex];
    }

    public boolean setElementColor(int anIndex, Color aColor) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aColor == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementColor == null || anIndex >= this.m_elementColor.length) {
            this.assureElementColors();
        }
        this.m_elementColor[anIndex] = aColor;
        return true;
    }

    public double getAreaOfElement(int elemInd) {
        PdVector[] v = this.getElementVertices(elemInd);
        double area = PdVector.area(v);
        return area;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public void showElementNormalArrow(boolean flag) {
        this.m_bShowElementNormalArrow = flag;
    }

    public PdVector getElementNormal(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_elementNormal[anIndex];
    }

    public boolean setElementNormal(int anIndex, PdVector aNormal) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        if (aNormal == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementNormal == null || anIndex >= this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        this.m_elementNormal[anIndex].copy(aNormal);
        return true;
    }

    public int getSavedNumVertices() {
        return this.m_savedNumVertices;
    }

    public void setSavedNumVertices(int num) {
        this.m_savedNumVertices = num;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc jvx = super.getJvx();
        jvx.showEdgeLabels(this.isShowingEdgeLabels());
        jvx.showElementLabels(this.isShowingElementLabels());
        jvx.showBackface(this.isShowingBackface());
        jvx.showOutline(this.isShowingOutline());
        jvx.setType(33);
        jvx.showElements(this.isShowingElements());
        jvx.setDimOfElements(this.getDimOfElements());
        jvx.setNumElements(this.getNumElements());
        jvx.setElements(this.getElements());
        jvx.setNeighbours(this.getNeighbours());
        jvx.showElementColors(this.isShowingElementColors());
        jvx.setElementColors(this.getElementColors());
        jvx.showElementBackColors(this.isShowingElementBackColors());
        jvx.setElementBackColors(this.getElementBackColors());
        jvx.setGlobalElementColor(this.getGlobalElementColor());
        jvx.setGlobalElementTagColor(this.getGlobalElementTagColor());
        jvx.setGlobalElementBackColor(this.getGlobalElementBackColor());
        jvx.showElementBackColor(this.isShowingElementBackColor());
        if (this.hasElementNormals()) {
            jvx.showElementNormals(this.isShowingElementNormals());
            jvx.setElementNormals(this.getElementNormals());
        } else {
            jvx.showElementNormals(false);
        }
        jvx.showElementNormalArrow(this.isShowingElementNormalArrow());
        jvx.setGlobalElementNormalColor(this.getGlobalElementNormalColor());
        jvx.setGlobalElementNormalLength(this.getGlobalElementNormalLength());
        jvx.setGlobalElementNormalSize(this.getGlobalElementNormalSize());
        if (this.hasElementTextures()) {
            jvx.showElementTexture(this.isShowingElementTextures());
            jvx.setElementTextures(this.getElementTextures());
        } else {
            jvx.showElementTexture(false);
        }
        jvx.showEdges(this.isShowingEdges());
        if (this.hasEdgeColors()) {
            jvx.showEdgeColors(this.isShowingEdgeColors());
            jvx.setEdgeColors(this.getEdgeColors());
        } else {
            jvx.showEdgeColors(false);
        }
        jvx.setGlobalEdgeColor(this.getGlobalEdgeColor());
        jvx.setGlobalEdgeTagColor(this.getGlobalEdgeTagColor());
        jvx.setGlobalEdgeSize(this.getGlobalEdgeSize());
        jvx.showBoundaries(this.isShowingBoundaries());
        jvx.setGlobalBndColor(this.getGlobalBndColor());
        jvx.setGlobalBndTagColor(this.getGlobalBndTagColor());
        jvx.setGlobalBndSize(this.getGlobalBndSize());
        return jvx;
    }

    public void setJvx(PgJvxSrc src) {
        super.setJvx(src);
        this.showEdgeLabels(src.isShowingEdgeLabels());
        this.showElementLabels(src.isShowingElementLabels());
        this.showOutline(src.isShowingOutline());
        this.showBackface(src.isShowingBackface());
        this.showElements(src.isShowingElements());
        int dim = PiVector.getSameSize(src.getElements(), src.getNumElements());
        this.setDimOfElements(dim);
        this.setNumElements(src.getNumElements());
        this.setElements(src.getElements());
        if (src.getNeighbours() != null) {
            this.setNeighbours(src.getNeighbours());
        } else {
            this.makeNeighbour();
        }
        if (src.getGlobalElementColor() != null) {
            this.setGlobalElementColor(src.getGlobalElementColor());
        }
        if (src.getGlobalElementTagColor() != null) {
            this.setGlobalElementTagColor(src.getGlobalElementTagColor());
        }
        this.setElementColors(src.getElementColors());
        this.showElementColors(src.isShowingElementColors());
        this.setElementBackColors(src.getElementBackColors());
        this.showElementBackColors(src.isShowingElementBackColors());
        this.setGlobalElementBackColor(src.getGlobalElementBackColor());
        this.showElementBackColor(src.isShowingElementBackColor());
        this.showElementNormals(src.isShowingElementNormals());
        this.showElementNormalArrow(src.isShowingElementNormalArrow());
        if (src.getElementNormals() != null) {
            this.setElementNormals(src.getElementNormals());
        } else {
            this.makeElementNormals();
        }
        if (src.getVertexNormals() == null) {
            this.makeVertexNormals();
        }
        if (src.getGlobalElementNormalColor() != null) {
            this.setGlobalElementNormalColor(src.getGlobalElementNormalColor());
        }
        if (src.getGlobalElementNormalLength() != 0.0) {
            this.setGlobalElementNormalLength(src.getGlobalElementNormalLength());
        }
        if (src.getGlobalElementNormalSize() != 0.0) {
            this.setGlobalElementNormalSize(src.getGlobalElementNormalSize());
        }
        this.setElementTextures(src.getElementTextures());
        this.showElementTexture(src.isShowingElementTexture());
        this.showEdges(src.isShowingEdges());
        if (src.getEdges() != null) {
            this.setEdges(src.getEdges());
        }
        if (src.getEdgeColors() != null) {
            this.setEdgeColors(src.getEdgeColors());
            this.showEdgeColors(true);
        } else {
            this.showEdgeColors(false);
        }
        if (src.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(src.getGlobalEdgeColor());
        }
        if (src.getGlobalEdgeTagColor() != null) {
            this.setGlobalEdgeTagColor(src.getGlobalEdgeTagColor());
        }
        if (src.getGlobalEdgeSize() != 0.0) {
            this.setGlobalEdgeSize(src.getGlobalEdgeSize());
        }
        this.showBoundaries(src.isShowingBoundaries());
        if (src.getGlobalBndColor() != null) {
            this.setGlobalBndColor(src.getGlobalBndColor());
        }
        if (src.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(src.getGlobalBndTagColor());
        }
        if (src.getGlobalBndSize() != 0.0) {
            this.setGlobalBndSize(src.getGlobalBndSize());
        }
        if (src.getNumVectorFields() > 0) {
            int numFields = src.getNumVectorFields();
            int k = 0;
            while (k < numFields) {
                PdVector[] vector;
                if (src.isVectorElementBased(k) && (vector = src.getVectors(k)) != null && vector.length != 0) {
                    int numVectors = vector.length;
                    PgVectorField vf = new PgVectorField(src.getDimOfVectors(k));
                    vf.setName(src.getVectorFieldName(k));
                    vf.setGeometry(this);
                    vf.setBasedOn(1);
                    vf.setNumVectors(numVectors);
                    if (vf.setVectors(vector)) {
                        this.addVectorField(vf);
                    }
                    this.showVectorArrow(src.isShowingVectorArrows(k));
                    if (src.getGlobalVectorSize(k) != 0.0) {
                        this.setGlobalVectorSize(src.getGlobalVectorSize(k));
                    }
                    if (src.getGlobalVectorLength(k) != 0.0) {
                        this.setGlobalVectorLength(src.getGlobalVectorLength(k));
                    }
                    if (src.getGlobalVectorColor(k) != null) {
                        this.setGlobalVectorColor(src.getGlobalVectorColor(k));
                    }
                }
                ++k;
            }
        }
    }

    public int getNeighbourLocInd(int elemInd, int vInd, int wInd) {
        int elemLen = this.m_element[elemInd].getSize();
        int i = 0;
        while (i < elemLen) {
            if (this.m_element[elemInd].m_data[i] == vInd && this.m_element[elemInd].m_data[(i + 1) % elemLen] == wInd) {
                return (i + elemLen - 1) % elemLen;
            }
            if (this.m_element[elemInd].m_data[i] == wInd && this.m_element[elemInd].m_data[(i + 1) % elemLen] == vInd) {
                return (i + elemLen - 1) % elemLen;
            }
            ++i;
        }
        PsDebug.error("cannot find edge (" + vInd + "," + wInd + ") in element[" + elemInd + "]", this);
        return -1;
    }

    public boolean isShowingTaggedElements() {
        return this.m_bShowTaggedElements;
    }

    public void showTaggedElements(boolean flag) {
        this.m_bShowTaggedElements = flag;
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public void setNumElements(int aNumElements) {
        int i;
        if (aNumElements > this.m_maxNumElements) {
            this.setMaxNumElements(aNumElements);
        } else if (aNumElements < this.m_numElements && this.m_dimOfElements == -1) {
            i = aNumElements;
            while (i < this.m_numElements) {
                this.m_element[i].setSize(0);
                this.m_neighbour[i].setSize(0);
                ++i;
            }
        }
        i = 0;
        while (i < this.m_numElements) {
            int j = this.m_neighbour[i].getSize() - 1;
            while (j >= 0) {
                if (this.m_neighbour[i].m_data[j] >= aNumElements) {
                    this.m_neighbour[i].m_data[j] = -1;
                }
                --j;
            }
            ++i;
        }
        i = this.m_numElements;
        while (i < aNumElements) {
            this.m_neighbour[i].setConstant(-1);
            ++i;
        }
        this.m_numElements = aNumElements;
    }

    public String printEdgeList() {
        PgElementEdge[] edge = this.getEdgeList();
        if (edge == null) {
            PsDebug.notify("missing edge list");
            return "missing edge list";
        }
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append("\t Number of edges    = " + edge.length + "\n");
        strBuf.append("\t Number of vertices = " + this.getNumVertices() + "\n");
        strBuf.append("\t Number of elements = " + this.getNumElements() + "\n");
        int i = 0;
        while (i < edge.length) {
            strBuf.append("\t Edge[" + i + "] = (" + edge[i].getEdgeInd(0) + ", " + edge[i].getEdgeInd(1) + ")");
            strBuf.append("   Adj.Elements = {");
            int len = edge[i].getSize();
            strBuf.append(String.valueOf(edge[i].getElementInd(0)));
            int j = 1;
            while (j < len) {
                strBuf.append(", " + edge[i].getElementInd(j));
                ++j;
            }
            strBuf.append("}\n");
            ++i;
        }
        return strBuf.toString();
    }

    public boolean isShowingOutline() {
        return this.m_bShowOutline;
    }

    public void showOutline(boolean flag) {
        this.m_bShowOutline = flag;
    }

    public void makeTriangleBnd(int discr) {
        int numBnd = 3;
        this.assureBoundary(numBnd);
        int i = 0;
        while (i < numBnd) {
            this.m_bndList[i].setNumVertices(discr);
            this.m_bndList[i].clearTag(2);
            ++i;
        }
        int num = 0;
        int j = 0;
        while (j < discr) {
            this.m_bndList[0].m_vertexInd.m_data[j] = num;
            num += discr - j;
            ++j;
        }
        num = 0;
        j = 0;
        while (j < discr) {
            this.m_bndList[1].m_vertexInd.m_data[j] = (num += discr - j) - 1;
            ++j;
        }
        j = 0;
        while (j < discr) {
            this.m_bndList[2].m_vertexInd.m_data[j] = discr - 1 - j;
            ++j;
        }
        i = 0;
        while (i < numBnd) {
            this.m_bndList[i].makeElementInd();
            ++i;
        }
    }

    public int addElement(PiVector anElement) {
        if (anElement == null || anElement.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return -1;
        }
        int num = this.getNumElements();
        this.setNumElements(num + 1);
        this.setElement(num, anElement);
        return num;
    }

    public boolean addElement(PiVector anElement, int anIndex) {
        if (anIndex < 0 || anIndex > this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " out of range.");
            return false;
        }
        if (anElement == null || anElement.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return false;
        }
        int dim = anElement.getSize();
        if (this.m_numElements == 0) {
            this.m_dimOfElements = dim;
        } else if (this.m_dimOfElements != dim) {
            this.m_dimOfElements = -1;
        }
        this.setNumElements(this.m_numElements + 1);
        if (anIndex == this.m_numElements - 1) {
            this.m_element[this.m_numElements - 1].setSize(dim);
            this.m_element[this.m_numElements - 1].copy(anElement);
            return true;
        }
        int i = this.m_numElements - 2;
        while (i >= anIndex) {
            this.m_element[i + 1].setSize(this.m_element[i].getSize());
            this.m_element[i + 1].copy(this.m_element[i]);
            --i;
        }
        this.m_element[anIndex].setSize(dim);
        this.m_element[anIndex].copy(anElement);
        return true;
    }

    public boolean hasTagElement(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return false;
        }
        return this.m_element[anIndex].hasTag(aTag);
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public void showEdgeLabels(boolean flag) {
        this.m_bShowEdgeLabels = flag;
    }

    public void showElementLabels(boolean flag) {
        this.m_bShowElementLabels = flag;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor.getColor();
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor.setColor(color);
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor.getColor();
    }

    public void setGlobalElementNormalColor(Color color) {
        this.m_globalElementNormalColor.setColor(color);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasElementTextures()) {
            return null;
        }
        int num = this.getNumElementIndices();
        PdVector[] texCoord = new PdVector[num];
        num = 0;
        int k = 0;
        while (k < this.m_numElements) {
            int elemSize = this.m_element[k].getSize();
            int kk = 0;
            while (kk < elemSize) {
                texCoord[num++] = this.m_elementTexture[k][kk];
                ++kk;
            }
            ++k;
        }
        return texCoord;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize.getValue();
    }

    public void setGlobalBndSize(double size) {
        this.m_globalBndSize.setValue(size);
    }

    public void setVertexTextures(PdVector[] aVertexTextureList) {
        if (this.hasVertexTextures()) {
            super.setVertexTextures(aVertexTextureList);
            return;
        }
        if (aVertexTextureList == null) {
            this.m_elementTexture = null;
            return;
        }
        if (aVertexTextureList.length < this.getNumElementIndices()) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureElementTextures();
        int num = 0;
        int k = 0;
        while (k < this.m_numElements) {
            int elemSize = this.m_element[k].getSize();
            int kk = 0;
            while (kk < elemSize) {
                this.m_elementTexture[k][kk].copy(aVertexTextureList[num++]);
                ++kk;
            }
            ++k;
        }
    }

    public boolean isShowingElementTextures() {
        return this.m_bShowElementTexture;
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null || this.m_elementTexture.length != this.m_maxNumElements) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        int i = 0;
        while (i < this.m_maxNumElements) {
            this.m_elementTexture[i] = PdVector.realloc(this.m_elementTexture[i], this.m_element[i].getSize(), this.m_dimOfTextures);
            ++i;
        }
    }

    public void setElementTextures(PdVector[][] texCoords) {
        if (texCoords == null) {
            this.m_elementTexture = null;
            return;
        }
        if (texCoords.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        int i = 0;
        while (i < this.m_numElements) {
            if (texCoords[i] == null || texCoords[i].length != this.m_element[i].getSize()) {
                PsDebug.warning("void length of texCoords[" + i + "]");
                return;
            }
            ++i;
        }
        this.assureElementTextures();
        i = 0;
        while (i < this.m_numElements) {
            PdVector.copy(this.m_elementTexture[i], 0, texCoords[i], 0, this.m_element[i].getSize());
            ++i;
        }
    }

    public double getEdgeLength(int anElem, int locInd) {
        int[] elem = this.m_element[anElem].m_data;
        double dist = PdVector.dist(this.m_vertex[elem[(locInd + 1) % elem.length]], this.m_vertex[elem[(locInd + 2) % elem.length]]);
        return dist;
    }

    public String toString() {
        int i;
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append(super.toString());
        strBuf.append("\t ******* PgElementSet *********\n");
        strBuf.append("\t m_numElements    = " + this.m_numElements + "\n");
        strBuf.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        strBuf.append("\t m_bConforming    = " + this.isConforming() + "\n");
        strBuf.append("\t ******* m_element *******\n");
        if (this.m_element != null) {
            i = 0;
            while (i < this.m_numElements) {
                strBuf.append("\t [" + i + "] = " + this.m_element[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_element = null\n");
        }
        strBuf.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            i = 0;
            while (i < this.m_numElements) {
                strBuf.append("\t [" + i + "] = " + this.m_neighbour[i].toShortString());
                ++i;
            }
        } else {
            strBuf.append("\t m_neighbour = null\n");
        }
        strBuf.append("\t ******* m_elementTexture *******\n");
        if (this.m_elementTexture != null && this.m_numElements > 0) {
            i = 0;
            while (i < this.m_numElements) {
                if (this.m_elementTexture[i] == null) {
                    strBuf.append("\t [" + i + "] = null");
                } else {
                    int j = 0;
                    while (i < this.m_elementTexture[i].length) {
                        strBuf.append("\t [" + i + "][" + j + "] = " + this.m_elementTexture[i][j].toShortString());
                        ++i;
                    }
                }
                ++i;
            }
        } else {
            strBuf.append("\t m_elementTexture = null\n");
        }
        return strBuf.toString();
    }

    public int getOppVertexInd(int elemInd, int locInd) {
        int otherLocInd = this.getOppVertexLocInd(elemInd, locInd);
        if (otherLocInd == -1) {
            return -1;
        }
        if (this.m_neighbour[elemInd].m_data[locInd] < 0) {
            return -1;
        }
        return this.m_element[this.m_neighbour[elemInd].m_data[locInd]].m_data[otherLocInd];
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public void showElements(boolean flag) {
        this.m_bShowElements = flag;
    }

    public int getMaxNumElements() {
        return this.m_maxNumElements;
    }

    protected void setMaxNumElements(int numElements) {
        if (this.m_maxNumElements == numElements) {
            return;
        }
        if (this.m_dimOfElements > -1) {
            this.m_element = PiVector.realloc(this.m_element, numElements, this.m_dimOfElements);
            if (this.m_maxNumElements < numElements) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, numElements, this.m_dimOfElements);
                int i = this.m_maxNumElements;
                while (i < numElements) {
                    this.m_neighbour[i].setConstant(-1);
                    ++i;
                }
            }
        } else {
            this.m_element = PiVector.realloc(this.m_element, numElements);
            if (this.m_maxNumElements < numElements) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, numElements);
            }
        }
        this.m_maxNumElements = numElements;
        this.assureNeighbours();
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public int getDimOfElements() {
        return this.m_dimOfElements;
    }

    public void setDimOfElements(int aSize) {
        if (aSize == this.m_dimOfElements) {
            return;
        }
        if (aSize != -1 && aSize < 3) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        this.m_dimOfElements = aSize;
        if (aSize == -1) {
            int i = this.m_numElements;
            while (i < this.m_maxNumElements) {
                this.m_element[i].setSize(0);
                this.m_neighbour[i].setSize(0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_maxNumElements) {
                this.m_element[i].setSize(aSize);
                this.m_neighbour[i].setSize(aSize);
                this.m_neighbour[i].setConstant(-1);
                ++i;
            }
        }
    }

    public void copyElementSet(PgElementSet geom) {
        int i;
        this.setDimOfElements(geom.getDimOfElements());
        this.setNumElements(geom.getNumElements());
        this.m_bConforming = geom.m_bConforming;
        this.m_savedNumVertices = geom.m_savedNumVertices;
        if (geom.m_elementSaved != null) {
            this.m_elementSaved = PiVector.copyNew(geom.m_elementSaved, geom.m_elementSaved.length);
        }
        if (this.m_dimOfElements == -1) {
            int i2 = 0;
            while (i2 < this.m_numElements) {
                this.m_element[i2].setSize(geom.getElement(i2).getSize());
                ++i2;
            }
        }
        PiVector.copy(this.m_element, 0, geom.getElements(), 0, this.m_numElements);
        PiVector[] neighbour = geom.getNeighbours();
        if (neighbour != null) {
            if (this.m_dimOfElements == -1) {
                i = 0;
                while (i < this.m_numElements) {
                    this.m_neighbour[i].setSize(geom.getNeighbour(i).getSize());
                    ++i;
                }
            }
            PiVector.copy(this.m_neighbour, 0, neighbour, 0, this.m_numElements);
        } else {
            this.m_neighbour = null;
        }
        if (geom.m_edge != null) {
            this.setNumEdges(geom.getNumEdges(), -1);
            PiVector.copy(this.m_edge, 0, geom.getEdges(), 0, this.m_numEdges);
        } else {
            this.m_edge = null;
        }
        if (geom.m_edgeColor != null) {
            this.assureEdgeColors();
            PdColor.copy(this.m_edgeColor, 0, geom.getEdgeColors(), 0, this.m_numEdges);
        } else {
            this.m_edgeColor = null;
        }
        if (geom.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, 0, geom.getElementNormals(), 0, this.m_numElements);
        } else {
            this.m_elementNormal = null;
        }
        if (geom.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy(this.m_elementColor, 0, geom.getElementColors(), 0, this.m_numElements);
        } else {
            this.m_elementColor = null;
        }
        if (geom.m_elementBackColor != null) {
            this.assureElementBackColors();
            PdColor.copy(this.m_elementBackColor, 0, geom.getElementBackColors(), 0, this.m_numElements);
        } else {
            this.m_elementBackColor = null;
        }
        if (geom.m_elementTexture != null) {
            this.assureElementTextures();
            i = 0;
            while (i < this.m_numElements) {
                PdVector.copy(this.m_elementTexture[i], 0, geom.m_elementTexture[i], 0, geom.m_elementTexture[i].length);
                ++i;
            }
        } else {
            this.m_elementTexture = null;
        }
        if (geom.hasBoundary()) {
            PgBndPolygon[] bndList = geom.getBoundaries();
            this.assureBoundary(bndList.length);
            int i3 = 0;
            while (i3 < this.m_bndList.length) {
                this.m_bndList[i3].copy(bndList[i3]);
                ++i3;
            }
        } else {
            this.m_bndList = null;
        }
    }

    public boolean assureDimOfElements() {
        int newNum = PiVector.getSameSize(this.m_element, this.m_numElements);
        if (newNum != this.m_dimOfElements) {
            this.setDimOfElements(newNum);
            return false;
        }
        return true;
    }

    public int[] removeMarkedElements() {
        int j;
        int USED = 1;
        int UNUSED = -1;
        PiVector indVec = new PiVector(this.m_numElements);
        indVec.setConstant(UNUSED);
        int[] index = indVec.m_data;
        int i = 0;
        while (i < this.m_numElements) {
            if (!this.m_element[i].hasTag(2)) {
                index[i] = USED;
            }
            ++i;
        }
        int newnoe = 0;
        i = 0;
        while (i < this.m_numElements) {
            if (index[i] == USED) {
                index[i] = newnoe++;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numElements) {
            if (index[i] != UNUSED) {
                j = 0;
                while (j < this.m_element[i].m_data.length) {
                    if (this.m_neighbour[i].m_data[j] > -1) {
                        this.m_neighbour[i].m_data[j] = index[this.m_neighbour[i].m_data[j]];
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numElements) {
            if (index[i] != UNUSED && index[i] < i) {
                this.m_element[index[i]].setSize(this.m_element[i].getSize());
                this.m_element[index[i]].copy(this.m_element[i]);
                this.m_neighbour[index[i]].setSize(this.m_neighbour[i].getSize());
                this.m_neighbour[index[i]].copy(this.m_neighbour[i]);
            }
            ++i;
        }
        if (this.m_elementNormal != null) {
            i = 0;
            while (i < this.m_numElements) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_elementNormal[index[i]].setSize(this.m_elementNormal[i].getSize());
                    this.m_elementNormal[index[i]].copy(this.m_elementNormal[i]);
                }
                ++i;
            }
        }
        if (this.m_elementColor != null) {
            i = 0;
            while (i < this.m_numElements) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_elementColor[index[i]] = this.m_elementColor[i];
                }
                ++i;
            }
        }
        if (this.m_elementBackColor != null) {
            i = 0;
            while (i < this.m_numElements) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_elementBackColor[index[i]] = this.m_elementBackColor[i];
                }
                ++i;
            }
        }
        if (this.m_elementTexture != null) {
            i = 0;
            while (i < this.m_numElements) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_elementTexture[index[i]] = PdVector.copyNew(this.m_elementTexture[i]);
                }
                ++i;
            }
        }
        if (this.m_bndList != null) {
            i = 0;
            while (i < this.m_bndList.length) {
                if (!this.m_bndList[i].hasTag(2)) {
                    int num = this.m_bndList[i].getNumElements();
                    j = 0;
                    while (j < num) {
                        if (index[this.m_bndList[i].m_elementInd.m_data[j]] == UNUSED) {
                            this.m_bndList[i].setTag(2);
                            break;
                        }
                        this.m_bndList[i].m_elementInd.m_data[j] = index[this.m_bndList[i].m_elementInd.m_data[j]];
                        ++j;
                    }
                }
                ++i;
            }
        }
        int numVF = this.getNumVectorFields();
        i = 0;
        while (i < numVF) {
            PgVectorField vf = this.getVectorField(i);
            if (vf.getBasedOn() != 0) {
                j = 0;
                while (j < this.m_numElements) {
                    if (index[j] != UNUSED && index[j] < j) {
                        vf.setVector(index[j], vf.getVector(j));
                    }
                    ++j;
                }
                vf.setNumVectors(newnoe);
            }
            ++i;
        }
        PsDebug.notify("number of deleted elements = " + (this.m_numElements - newnoe));
        this.setNumElements(newnoe);
        this.setMaxNumElements(newnoe);
        return index;
    }

    public void setElements(PiVector[] element) {
        if ((element == null || element.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (element.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        int dimSav = element[0].getSize();
        int i = 0;
        while (i < this.m_numElements) {
            int dim = element[i].getSize();
            this.m_element[i].setSize(dim);
            if (dimSav != -1 && dim != dimSav) {
                dimSav = -1;
            }
            ++i;
        }
        if (this.m_dimOfElements != dimSav) {
            this.setDimOfElements(dimSav);
        }
        PiVector.copy(this.m_element, 0, element, 0, this.m_numElements);
        if (this.m_dimOfElements == -1) {
            this.assureNeighbours();
        }
    }

    public double getVolume() {
        double volume = 0.0;
        int i = 0;
        while (i < this.m_numElements) {
            volume += this.getVolumeOfElement(i);
            ++i;
        }
        return volume;
    }

    public void computeTorus(int numULines, int numVLines, double radius, double thick) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeTorus(numULines, numVLines, radius, thick);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    public void copy(PgGeometry geom) {
        super.copy(geom);
        if (!(geom instanceof PgElementSet)) {
            return;
        }
        this.copyElementSet((PgElementSet)geom);
        int numvf = this.getNumVectorFields();
        int i = 0;
        while (i < numvf) {
            PgVectorField vf = this.getVectorField(i);
            if (vf.getBasedOn() == 1) {
                vf.setGeometry(this);
            }
            ++i;
        }
    }

    private void schemeButterfly(PdVector mid, int elem0, int locInd0, int elem1, int locInd1, double[] scheme) {
        int[] ind = new int[10];
        ind[0] = -1;
        ind[1] = this.getOppVertexInd(elem0, (locInd0 + 3 - 1) % 3);
        ind[2] = this.m_element[elem0].m_data[locInd0];
        ind[3] = this.getOppVertexInd(elem0, (locInd0 + 1) % 3);
        ind[4] = this.m_element[elem0].m_data[(locInd0 + 1) % 3];
        ind[5] = this.m_element[elem0].m_data[(locInd0 + 3 - 1) % 3];
        if (elem1 != -1) {
            ind[6] = this.getOppVertexInd(elem1, (locInd1 + 1) % 3);
            ind[7] = this.m_element[elem1].m_data[locInd0];
            ind[8] = this.getOppVertexInd(elem1, (locInd1 + 3 - 1) % 3);
        } else {
            ind[8] = -1;
            ind[7] = -1;
            ind[6] = -1;
        }
        ind[9] = -1;
        mid.setConstant(0.0);
        int i = 0;
        while (i < 10) {
            if (ind[i] != -1) {
                mid.blendBase(mid, scheme[i], this.m_vertex[ind[i]]);
            }
            ++i;
        }
    }

    public void computeCylinder(int numULines, int numVLines, double radius, double length) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCylinder(numULines, numVLines, radius, length);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public PgBndPolygon[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
        }
        return this.m_bndList;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public void showBoundaries(boolean flag) {
        this.m_bShowBoundaries = flag;
    }

    public void flipOrientation() {
        super.flipOrientation();
        int maxNumEdges = 100;
        int[] tmp = new int[maxNumEdges];
        int i = 0;
        while (i < this.m_numElements) {
            this.m_element[i].invert();
            int num = this.m_element[i].m_data.length;
            if (num > maxNumEdges) {
                maxNumEdges = 2 * num;
                tmp = new int[maxNumEdges];
            }
            int j = 0;
            while (j < num) {
                tmp[j] = this.m_neighbour[i].m_data[j];
                ++j;
            }
            j = 0;
            while (j < num) {
                this.m_neighbour[i].m_data[j] = tmp[(num - 4 - j + num) % num];
                ++j;
            }
            ++i;
        }
        if (this.m_elementNormal != null) {
            i = 0;
            while (i < this.m_numElements) {
                this.m_elementNormal[i].multScalar(-1.0);
                ++i;
            }
        }
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor.getColor();
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor.getColor();
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor.setColor(color);
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor.setColor(color);
    }

    public int getElementWithVertex(int vertexInd) {
        int i = 0;
        while (i < this.m_numElements) {
            if (this.m_element[i].getIndexOf(vertexInd) > -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean merge(PgGeometryIf aGeom) {
        int globalBackColor;
        int globalColor;
        int j;
        int elemSize;
        int oldNov = this.m_numVertices;
        if (!super.merge(aGeom)) {
            return false;
        }
        if (!(aGeom instanceof PgElementSet)) {
            return false;
        }
        PgElementSet geom = (PgElementSet)aGeom;
        if (this.m_numElements == 0) {
            this.setDimOfElements(geom.m_dimOfElements);
        } else if (geom.m_dimOfElements != this.m_dimOfElements) {
            this.setDimOfElements(-1);
        }
        int oldNoe = this.m_numElements;
        int newNoe = this.m_numElements + geom.m_numElements;
        this.setNumElements(newNoe);
        PiVector.copy(this.m_element, oldNoe, geom.m_element, 0, geom.m_numElements);
        int i = 0;
        while (i < geom.m_numElements) {
            elemSize = geom.m_element[i].getSize();
            if (this.m_dimOfElements == -1) {
                this.m_element[oldNoe + i].setSize(elemSize);
            }
            j = 0;
            while (j < elemSize) {
                int n = j++;
                this.m_element[oldNoe + i].m_data[n] = this.m_element[oldNoe + i].m_data[n] + oldNov;
            }
            ++i;
        }
        if (geom.m_neighbour != null) {
            this.assureNeighbours();
            PiVector.copy(this.m_neighbour, oldNoe, geom.m_neighbour, 0, geom.m_numElements);
            i = 0;
            while (i < geom.m_numElements) {
                elemSize = geom.m_element[i].getSize();
                if (this.m_dimOfElements == -1) {
                    this.m_neighbour[oldNoe + i].setSize(elemSize);
                }
                j = 0;
                while (j < elemSize) {
                    if (geom.m_neighbour[i].m_data[j] > -1) {
                        int n = j;
                        this.m_neighbour[oldNoe + i].m_data[n] = this.m_neighbour[oldNoe + i].m_data[n] + oldNoe;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (geom.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, oldNoe, geom.m_elementNormal, 0, geom.m_numElements);
        }
        if (geom.m_elementColor != null) {
            if (this.m_elementColor == null) {
                this.showElementColors(geom.isShowingElementColors());
                this.assureElementColors();
                globalColor = this.getGlobalElementColor().getRGB();
                i = 0;
                while (i < oldNoe) {
                    this.setElementColor(i, new Color(globalColor));
                    ++i;
                }
            } else {
                this.assureElementColors();
            }
            PdColor.copy(this.m_elementColor, oldNoe, geom.m_elementColor, 0, geom.m_numElements);
        } else if (this.m_elementColor != null) {
            globalColor = geom.getGlobalElementColor().getRGB();
            i = oldNoe;
            while (i < newNoe) {
                this.setElementColor(i, new Color(globalColor));
                ++i;
            }
        }
        if (geom.m_elementBackColor != null) {
            if (this.m_elementBackColor == null) {
                this.showElementBackColors(geom.isShowingElementBackColors());
                this.assureElementBackColors();
                globalBackColor = this.getGlobalElementBackColor().getRGB();
                i = 0;
                while (i < oldNoe) {
                    this.setElementBackColor(i, new Color(globalBackColor));
                    ++i;
                }
            } else {
                this.assureElementBackColors();
            }
            PdColor.copy(this.m_elementBackColor, oldNoe, geom.m_elementBackColor, 0, geom.m_numElements);
        } else if (this.m_elementBackColor != null) {
            globalBackColor = geom.getGlobalElementBackColor().getRGB();
            i = oldNoe;
            while (i < newNoe) {
                this.setElementBackColor(i, new Color(globalBackColor));
                ++i;
            }
        }
        if (geom.m_elementTexture != null) {
            this.assureElementTextures();
            i = 0;
            while (i < geom.m_numElements) {
                elemSize = geom.m_element[i].getSize();
                PdVector.copy(this.m_elementTexture[oldNoe + i], 0, geom.m_elementTexture[i], 0, elemSize);
                ++i;
            }
        }
        if (geom.m_bndList != null) {
            PgBndPolygon[] old = this.getBoundaries();
            this.m_bndList = new PgBndPolygon[old.length + geom.m_bndList.length];
            i = 0;
            while (i < old.length) {
                this.m_bndList[i] = old[i];
                ++i;
            }
            i = 0;
            while (i < geom.m_bndList.length) {
                this.m_bndList[old.length + i] = geom.m_bndList[i];
                ++i;
            }
            i = old.length;
            while (i < this.m_bndList.length) {
                if (this.m_bndList[i].m_vertexInd != null) {
                    j = 0;
                    while (j < this.m_bndList[i].m_numVertices) {
                        int n = j++;
                        this.m_bndList[i].m_vertexInd.m_data[n] = this.m_bndList[i].m_vertexInd.m_data[n] + oldNov;
                    }
                }
                if (this.m_bndList[i].m_elementInd != null) {
                    j = 0;
                    while (j < this.m_bndList[i].m_numVertices - 1) {
                        int n = j++;
                        this.m_bndList[i].m_elementInd.m_data[n] = this.m_bndList[i].m_elementInd.m_data[n] + oldNoe;
                    }
                }
                this.m_bndList[i].m_triang = this;
                this.m_bndList[i].assignVertices();
                ++i;
            }
        }
        return true;
    }

    public void copyConnectivity(PgElementSet geom) {
        this.setDimOfElements(geom.getDimOfElements());
        this.setNumElements(geom.getNumElements());
        this.m_bConforming = geom.m_bConforming;
        PiVector.copy(this.m_element, 0, geom.getElements(), 0, this.m_numElements);
        PiVector[] neighbour = geom.getNeighbours();
        if (neighbour != null) {
            PiVector.copy(this.m_neighbour, 0, neighbour, 0, this.m_numElements);
        }
    }

    public void computeDisk(int numULines, int numVLines, double radius) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeDisk(numULines, numVLines, radius);
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    protected void setDimOfElement(int ind, int aSize) {
        if (this.m_dimOfElements == aSize) {
            return;
        }
        if (ind < 0 || this.m_numElements <= ind) {
            PsDebug.warning("index out of range, ind = " + ind);
            return;
        }
        if (aSize < 3) {
            PsDebug.warning("argument aSize=" + aSize + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(aSize);
        } else if (this.m_dimOfElements != -1) {
            PsDebug.notify("m_dimOfElements != aSize = " + aSize);
            this.setDimOfElements(-1);
        }
        this.m_element[ind].setSize(aSize);
        this.m_neighbour[ind].setSize(aSize);
        this.m_neighbour[ind].setConstant(-1);
    }

    public void clearTagElement(int anIndex, int aTag) {
        if (anIndex < 0 || anIndex > this.m_numElements - 1) {
            PsDebug.warning("index=" + anIndex + " out of range");
            return;
        }
        this.m_element[anIndex].clearTag(aTag);
    }

    public PiVector getElement(int anIndex) {
        if (anIndex < 0 || anIndex >= this.m_numElements) {
            return null;
        }
        return this.m_element[anIndex];
    }

    public void setElement(int elemInd, int a, int b, int c) {
        if (elemInd < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (elemInd >= this.m_numElements) {
            this.setNumElements(elemInd + 1);
        }
        this.setDimOfElement(elemInd, 3);
        this.m_element[elemInd].set(a, b, c);
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    protected void assureNeighbours() {
        int i;
        boolean bInit = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            i = 0;
            while (i < this.m_maxNumElements) {
                if (this.m_neighbour[i].m_data == null || this.m_element[i].m_data == null || this.m_neighbour[i].m_data.length != this.m_element[i].m_data.length) {
                    bInit = true;
                    break;
                }
                ++i;
            }
            if (!bInit) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            i = 0;
            while (i < this.m_maxNumElements) {
                this.m_neighbour[i].setSize(this.m_element[i].getSize());
                ++i;
            }
        }
        if (bInit) {
            i = 0;
            while (i < this.m_maxNumElements) {
                this.m_neighbour[i].setConstant(-1);
                ++i;
            }
        }
    }

    public void setElement(int elemInd, int a, int b, int c, int d) {
        if (elemInd < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (elemInd >= this.m_numElements) {
            this.setNumElements(elemInd + 1);
        }
        this.setDimOfElement(elemInd, 4);
        this.m_element[elemInd].set(a, b, c, d);
    }

    public boolean setElement(int elemInd, int[] anIndArray) {
        if (elemInd >= this.m_numElements) {
            this.setNumElements(elemInd + 1);
        }
        int elemSize = anIndArray.length;
        this.setDimOfElement(elemInd, elemSize);
        this.m_element[elemInd].copy(anIndArray, elemSize);
        return true;
    }

    public boolean setElement(int anIndex, PiVector newElem) {
        if (anIndex < 0 || newElem == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (anIndex >= this.m_numElements) {
            PsDebug.warning("index=" + anIndex + " > " + this.m_numElements + "=m_numElements, bad programming style");
            this.setNumElements(anIndex + 1);
        }
        this.setDimOfElement(anIndex, newElem.getSize());
        this.m_element[anIndex].copy(newElem);
        return true;
    }

    public void setNeighbours(PiVector[] neighbour) {
        if (neighbour == null) {
            this.m_neighbour = null;
            return;
        }
        if (neighbour.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        int i = 0;
        while (i < this.m_numElements) {
            this.m_neighbour[i].setSize(neighbour[i].getSize());
            ++i;
        }
        PiVector.copy(this.m_neighbour, 0, neighbour, 0, this.m_numElements);
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    public void setEdges(PiVector[] edge) {
        if (edge == null || edge.length == 0 || edge.length < this.m_numEdges) {
            PsDebug.warning("void length of edge array");
            return;
        }
        PiVector.copy(this.m_edge, 0, edge, 0, this.m_numEdges);
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean flag) {
        this.m_bShowEdges = flag;
    }

    public int getNumElementIndices() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements * this.m_numElements;
        }
        int num = 0;
        int i = 0;
        while (i < this.m_numElements) {
            num += this.m_element[i].getSize();
            ++i;
        }
        return num;
    }

    public boolean removeUnusedVertices() {
        int j;
        int USED = 1;
        int UNUSED = -1;
        PiVector indVec = new PiVector(this.m_numVertices);
        indVec.setConstant(UNUSED);
        int[] index = indVec.m_data;
        int i = 0;
        while (i < this.m_numElements) {
            j = 0;
            while (j < this.m_element[i].m_data.length) {
                index[this.m_element[i].m_data[j]] = USED;
                ++j;
            }
            ++i;
        }
        int newnop = 0;
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] == USED) {
                index[i] = newnop++;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numVertices) {
            if (index[i] != UNUSED && index[i] < i) {
                this.m_vertex[index[i]] = this.m_vertex[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numElements) {
            j = 0;
            while (j < this.m_element[i].m_data.length) {
                this.m_element[i].m_data[j] = index[this.m_element[i].m_data[j]];
                ++j;
            }
            ++i;
        }
        if (this.m_vertexNormal != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_vertexNormal[index[i]] = this.m_vertexNormal[i];
                }
                ++i;
            }
        }
        if (this.m_vertexColor != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_vertexColor[index[i]] = this.m_vertexColor[i];
                }
                ++i;
            }
        }
        if (this.m_vertexTexture != null) {
            i = 0;
            while (i < this.m_numVertices) {
                if (index[i] != UNUSED && index[i] < i) {
                    this.m_vertexTexture[index[i]] = this.m_vertexTexture[i];
                }
                ++i;
            }
        }
        int numVF = this.getNumVectorFields();
        i = 0;
        while (i < numVF) {
            PgVectorField vf = this.getVectorField(i);
            if (vf.getBasedOn() != 1) {
                j = 0;
                while (j < this.m_numVertices) {
                    if (index[j] != UNUSED && index[j] < j) {
                        vf.setVector(index[j], vf.getVector(j));
                    }
                    ++j;
                }
                vf.setNumVectors(newnop);
            }
            ++i;
        }
        if (this.m_bndList != null) {
            i = 0;
            while (i < this.m_bndList.length) {
                if (!this.m_bndList[i].hasTag(2)) {
                    int num = this.m_bndList[i].getNumVertices();
                    boolean valid = true;
                    j = 0;
                    while (j < num) {
                        if (this.m_bndList[i].m_vertexInd.m_data[j] == -1 || this.m_bndList[i].m_vertexInd.m_data[j] >= this.m_numVertices) {
                            this.m_bndList[i].setTag(2);
                            valid = false;
                            break;
                        }
                        ++j;
                    }
                    if (valid) {
                        j = 0;
                        while (j < num) {
                            this.m_bndList[i].m_vertexInd.m_data[j] = index[this.m_bndList[i].m_vertexInd.m_data[j]];
                            ++j;
                        }
                        this.m_bndList[i].assignVertices();
                    }
                }
                ++i;
            }
        }
        PsDebug.notify("number of deleted vertices = " + (this.m_numVertices - newnop));
        this.setNumVertices(newnop);
        this.setMaxNumVertices(newnop);
        return true;
    }

    public int[] removeMarkedVertices() {
        int DELETE = -1;
        int[] index = super.removeMarkedVertices();
        int i = 0;
        while (i < this.m_numElements) {
            int j = this.m_element[i].getSize() - 1;
            while (j >= 0) {
                if (index[this.m_element[i].m_data[j]] == DELETE) {
                    this.m_element[i].setTag(2);
                    break;
                }
                this.m_element[i].m_data[j] = index[this.m_element[i].m_data[j]];
                --j;
            }
            ++i;
        }
        this.removeMarkedElements();
        return index;
    }

    public boolean update(Object event) {
        PsDebug.notify("called");
        if (event == null) {
            return super.update(null);
        }
        if (event == this.m_globalBndColor) {
            PsDebug.notify("called with event=m_globalBndColor");
            return super.update(null);
        }
        if (event == this.m_globalBndTagColor) {
            PsDebug.notify("called with event=m_globalBndTagColor");
            return super.update(null);
        }
        if (event == this.m_globalBndSize) {
            PsDebug.notify("called with event=m_globalBndSize");
            return super.update(null);
        }
        if (event == this.m_globalEdgeColor) {
            PsDebug.notify("called with event=m_globalEdgeColor");
            return super.update(null);
        }
        if (event == this.m_globalEdgeTagColor) {
            PsDebug.notify("called with event=m_globalEdgeTagColor");
            return super.update(null);
        }
        if (event == this.m_globalEdgeSize) {
            PsDebug.notify("called with event=m_globalEdgeSize");
            return super.update(null);
        }
        if (event == this.m_globalElementColor) {
            PsDebug.notify("called with event=m_globalElementColor");
            return super.update(null);
        }
        if (event == this.m_globalElementBackColor) {
            PsDebug.notify("called with event=m_globalElementBackColor");
            return super.update(null);
        }
        if (event == this.m_globalElementTagColor) {
            PsDebug.notify("called with event=m_globalElementTagColor");
            return super.update(null);
        }
        if (event == this.m_globalElementNormalColor) {
            PsDebug.notify("called with event=m_globalElementNormalColor");
            return super.update(null);
        }
        if (event == this.m_globalElementNormalLength) {
            PsDebug.notify("called with event=m_globalElementNormalLength");
            return super.update(null);
        }
        if (event == this.m_globalElementNormalSize) {
            PsDebug.notify("called with event=m_globalElementNormalSize");
            return super.update(null);
        }
        if (event == this.m_globalVertexNormalColor) {
            PsDebug.notify("called with event=m_globalVertexNormalColor");
            this.m_globalElementNormalColor.setColor(this.m_globalVertexNormalColor.getColor());
            return super.update(event);
        }
        if (event == this.m_globalVertexNormalLength) {
            this.m_globalElementNormalLength.copy(this.m_globalVertexNormalLength);
            return super.update(event);
        }
        if (event == this.m_globalVertexNormalSize) {
            this.m_globalElementNormalSize.copy(this.m_globalVertexNormalSize);
            return super.update(event);
        }
        return super.update(event);
    }

    public PdVector[] getElementVertices(int elemInd) {
        if (elemInd < 0 || this.m_numElements <= elemInd) {
            PsDebug.warning("elemInd out of bounds, elemInd = " + elemInd);
            return null;
        }
        if (this.m_element[elemInd].getSize() == 0) {
            PsDebug.notify("empty element, elemInd = " + elemInd);
            return null;
        }
        int elemSize = this.m_element[elemInd].getSize();
        PdVector[] vectorArray = new PdVector[elemSize];
        --elemSize;
        while (elemSize >= 0) {
            vectorArray[elemSize] = this.m_vertex[this.m_element[elemInd].m_data[elemSize]];
            --elemSize;
        }
        return vectorArray;
    }

    public boolean setElementVertices(int elemInd, PdVector[] vArray) {
        PiVector elem = this.m_element[elemInd];
        int elemSize = elem.getSize();
        if (elemSize != vArray.length) {
            PsDebug.warning("element and array have different length");
            return false;
        }
        --elemSize;
        while (elemSize >= 0) {
            this.setVertex(elem.m_data[elemSize], vArray[elemSize]);
            --elemSize;
        }
        return true;
    }

    public int getOppVertexLocInd(int elemInd, int locInd) {
        if (this.m_neighbour == null) {
            PsDebug.error("missing neighbour variable", this);
            return -1;
        }
        if (elemInd == -1 || locInd == -1) {
            return -1;
        }
        int elemNeigh = this.m_neighbour[elemInd].m_data[locInd];
        if (elemNeigh == -1) {
            return -1;
        }
        int k = this.m_neighbour[elemNeigh].getSize() - 1;
        while (k >= 0) {
            if (this.m_neighbour[elemNeigh].m_data[k] == elemInd) {
                return k;
            }
            --k;
        }
        PsDebug.error("error in neighb. connectivity", this);
        return -1;
    }

    public double getL2Norm() {
        double norm = 0.0;
        int j = 0;
        while (j < this.m_numElements) {
            PdVector[] elemVert = this.getElementVertices(j);
            double triNorm = 0.0;
            int len = this.m_element[j].getSize();
            int i = 1;
            while (i < len - 1) {
                triNorm += elemVert[0].sqrLength() + PdVector.dot(elemVert[0], elemVert[i]);
                triNorm += elemVert[i].sqrLength() + PdVector.dot(elemVert[i], elemVert[i + 1]);
                double triArea = PdVector.area(elemVert[0], elemVert[i], elemVert[i + 1]);
                norm += 2.0 * triArea * (triNorm += elemVert[i + 1].sqrLength() + PdVector.dot(elemVert[i + 1], elemVert[0])) / 12.0;
                ++i;
            }
            ++j;
        }
        return norm;
    }

    public boolean hasEdges() {
        return this.m_edge != null;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        Color[] color = this.getElementColors();
        PdVector[] bnd = this.getAmbientBounds();
        double[] diag = PdVector.subNew((PdVector)bnd[1], (PdVector)bnd[0]).m_data;
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numElements) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_element[i].m_data), bnd[0]);
            if (this.m_dim == 1) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                color[i] = new Color((float)(vec.m_data[0] / diag[0]), (float)(vec.m_data[1] / diag[1]), (float)(vec.m_data[2] / diag[2]));
            }
            ++i;
        }
        return true;
    }

    public void removeBoundaries() {
        this.m_bndList = null;
    }

    public void fixBoundaries() {
        PgBndPolygon[] bndList = this.getBoundaries();
        int i = 0;
        while (i < bndList.length) {
            PgBndConstraint bndConstraint = new PgBndConstraint(this.getDimOfVertices());
            bndConstraint.setShape(3);
            bndList[i].setBndConstraint(bndConstraint);
            ++i;
        }
    }

    public void makeCylinderConn(int uDiscr, int vDiscr) {
        if (uDiscr < 1 || vDiscr < 1) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            if (vDiscr > 2) {
                this.setNumElements(2 * (uDiscr - 1) * vDiscr);
                int ind = 0;
                int i = 0;
                while (i < uDiscr - 1) {
                    int j = 0;
                    while (j < vDiscr - 1) {
                        this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, i * vDiscr + j + 1);
                        this.m_element[ind++].set(i * vDiscr + j + 1, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1);
                        ++j;
                    }
                    this.m_element[ind++].set(i * vDiscr + vDiscr - 1, (i + 1) * vDiscr + vDiscr - 1, i * vDiscr);
                    this.m_element[ind++].set(i * vDiscr, (i + 1) * vDiscr + vDiscr - 1, (i + 1) * vDiscr);
                    ++i;
                }
            } else if (vDiscr == 2) {
                this.setNumElements(2 * (uDiscr - 1));
                int ind = 0;
                int i = 0;
                while (i < uDiscr - 1) {
                    this.m_element[ind++].set(i * vDiscr, (i + 1) * vDiscr, i * vDiscr + 1);
                    this.m_element[ind++].set(i * vDiscr + 1, (i + 1) * vDiscr, (i + 1) * vDiscr + 1);
                    ++i;
                }
            }
        } else {
            this.setDimOfElements(4);
            if (vDiscr > 2) {
                this.setNumElements((uDiscr - 1) * vDiscr);
                int ind = 0;
                int i = 0;
                while (i < uDiscr - 1) {
                    int j = 0;
                    while (j < vDiscr - 1) {
                        this.m_element[ind++].set(i * vDiscr + j, (i + 1) * vDiscr + j, (i + 1) * vDiscr + j + 1, i * vDiscr + j + 1);
                        ++j;
                    }
                    this.m_element[ind++].set(i * vDiscr + vDiscr - 1, (i + 1) * vDiscr + vDiscr - 1, (i + 1) * vDiscr, i * vDiscr);
                    ++i;
                }
            } else if (vDiscr == 2) {
                this.setNumElements(uDiscr - 1);
                int ind = 0;
                int i = 0;
                while (i < uDiscr - 1) {
                    this.m_element[ind++].set(i * vDiscr, (i + 1) * vDiscr, (i + 1) * vDiscr + 1, i * vDiscr + 1);
                    ++i;
                }
            }
        }
        this.makeNeighbour();
    }

    public void makeQuadrBnd(int uDiscr, int vDiscr) {
        int end;
        int numBnd = 4;
        this.assureBoundary(numBnd);
        int i = 0;
        while (i < numBnd) {
            this.m_bndList[i].clearTag(2);
            ++i;
        }
        this.m_bndList[0].setNumVertices(uDiscr);
        this.m_bndList[1].setNumVertices(vDiscr);
        this.m_bndList[2].setNumVertices(uDiscr);
        this.m_bndList[3].setNumVertices(vDiscr);
        i = 0;
        while (i < uDiscr) {
            this.m_bndList[0].m_vertexInd.m_data[i] = i * vDiscr;
            this.m_bndList[2].m_vertexInd.m_data[i] = (uDiscr - i) * vDiscr - 1;
            ++i;
        }
        int j = 0;
        while (j < vDiscr) {
            this.m_bndList[3].m_vertexInd.m_data[j] = vDiscr - 1 - j;
            this.m_bndList[1].m_vertexInd.m_data[j] = (uDiscr - 1) * vDiscr + j;
            ++j;
        }
        if (this.m_dimOfElements == 3) {
            end = 0;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_bndList[0].m_elementInd.m_data[i] = end;
                this.m_bndList[0].m_neighbourLocInd.m_data[i] = 2;
                end += 2 * (vDiscr - 1);
                ++i;
            }
            end = 2 * (uDiscr - 2) * (vDiscr - 1) + 1;
            i = 0;
            while (i < vDiscr - 1) {
                this.m_bndList[1].m_elementInd.m_data[i] = end;
                this.m_bndList[1].m_neighbourLocInd.m_data[i] = 0;
                end += 2;
                ++i;
            }
            end = 2 * (uDiscr - 1) * (vDiscr - 1) - 1;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_bndList[2].m_elementInd.m_data[i] = end;
                this.m_bndList[2].m_neighbourLocInd.m_data[i] = 1;
                end -= 2 * (vDiscr - 1);
                ++i;
            }
            end = 2 * (vDiscr - 1) - 2;
            i = 0;
            while (i < vDiscr - 1) {
                this.m_bndList[3].m_elementInd.m_data[i] = end;
                this.m_bndList[3].m_neighbourLocInd.m_data[i] = 1;
                end -= 2;
                ++i;
            }
        } else {
            end = 0;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_bndList[0].m_elementInd.m_data[i] = end;
                this.m_bndList[0].m_neighbourLocInd.m_data[i] = 3;
                end += vDiscr - 1;
                ++i;
            }
            end = (uDiscr - 2) * (vDiscr - 1);
            i = 0;
            while (i < vDiscr - 1) {
                this.m_bndList[1].m_elementInd.m_data[i] = end++;
                this.m_bndList[1].m_neighbourLocInd.m_data[i] = 0;
                ++i;
            }
            end = (uDiscr - 1) * (vDiscr - 1) - 1;
            i = 0;
            while (i < uDiscr - 1) {
                this.m_bndList[2].m_elementInd.m_data[i] = end;
                this.m_bndList[2].m_neighbourLocInd.m_data[i] = 1;
                end -= vDiscr - 1;
                ++i;
            }
            end = vDiscr - 1 - 1;
            i = 0;
            while (i < vDiscr - 1) {
                this.m_bndList[3].m_elementInd.m_data[i] = end--;
                this.m_bndList[3].m_neighbourLocInd.m_data[i] = 2;
                ++i;
            }
        }
        i = 0;
        while (i < numBnd) {
            this.m_bndList[i].assignVertices();
            ++i;
        }
    }

    public void makeTriangleConn(int discr) {
        if (discr < 1) {
            return;
        }
        int ind = 0;
        int num = 0;
        this.setDimOfElements(3);
        this.setNumElements((discr - 1) * (discr - 1));
        int i = 0;
        while (i < discr - 1) {
            int j = 0;
            while (j < discr - 1 - i) {
                this.m_element[ind++].set(num + j, num + (discr - i) + j, num + j + 1);
                if (j != discr - 2 - i) {
                    this.m_element[ind++].set(num + j + 1, num + (discr - i) + j, num + (discr - i) + j + 1);
                }
                ++j;
            }
            num += discr - i;
            ++i;
        }
        this.makeNeighbour();
    }

    public void makePatchConn(int discr) {
        PsDebug.error("missing method.", this);
    }

    public boolean hasEdgeColors() {
        return this.m_edgeColor != null && this.m_edgeColor.length == this.m_numEdges;
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public boolean hasBoundary() {
        return this.m_bndList != null && this.m_bndList.length != 0;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public void showElementBackColors(boolean flag) {
        this.m_bShowElementBackColors = flag;
    }

    public boolean hasElementColors() {
        return this.m_elementColor != null && this.m_elementColor.length == this.m_maxNumElements;
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void setElementBackColors(Color[] color) {
        if (color == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (color.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementBackColor == null || this.m_numElements > this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        PdColor.copy(this.m_elementBackColor, 0, color, 0, this.m_numElements);
    }

    public boolean checkNeighbour() {
        if (this.m_neighbour == null) {
            PsDebug.warning("missing neighbour information");
            return false;
        }
        int otherLocInd = -1;
        boolean correct = true;
        StringBuffer strBuf = new StringBuffer("");
        int i = 0;
        while (i < this.m_numElements) {
            int len = this.m_element[i].getSize();
            if (len != this.m_neighbour[i].getSize()) {
                correct = false;
                strBuf.append("neighbour array has different length than element array\n");
                strBuf.append("\t element = " + i + " has length = " + len + "\n");
                strBuf.append("\t neighbour has length = " + this.m_neighbour[i].getSize() + "\n");
            }
            int j = 0;
            while (j < len) {
                int elemNeigh = this.m_neighbour[i].m_data[j];
                if (elemNeigh != -1) {
                    int l;
                    if (elemNeigh == i) {
                        correct = false;
                        strBuf.append("element has itself as neighbour\n");
                        strBuf.append("\t element = " + i + " at vertex = " + this.m_element[i].m_data[j] + "\n");
                        l = 0;
                        while (l < len) {
                            strBuf.append("\t element[" + i + "][" + l + "] = " + this.m_element[i].m_data[l] + ", neighbour[" + i + "][" + l + "] = " + this.m_neighbour[i].m_data[l] + "\n");
                            ++l;
                        }
                    } else if (elemNeigh >= this.m_numElements) {
                        correct = false;
                        strBuf.append("neighbour references non-existing element\n");
                        strBuf.append("\t element = " + i + " at vertex = " + this.m_element[i].m_data[j] + " >= m_numElements.\n");
                        l = 0;
                        while (l < len) {
                            strBuf.append("\t element[" + i + "][" + l + "] = " + this.m_element[i].m_data[l] + ", neighbour[" + i + "][" + l + "] = " + this.m_neighbour[i].m_data[l] + "\n");
                            ++l;
                        }
                    } else {
                        int lenNeigh = this.m_neighbour[elemNeigh].getSize();
                        boolean found = false;
                        int k = 0;
                        while (k < lenNeigh) {
                            if (this.m_neighbour[elemNeigh].m_data[k] == i) {
                                found = true;
                                otherLocInd = k;
                                break;
                            }
                            ++k;
                        }
                        if (!(found && (this.m_element[i].m_data[(j + 1) % len] == this.m_element[elemNeigh].m_data[(k + 2) % lenNeigh] && this.m_element[i].m_data[(j + 2) % len] == this.m_element[elemNeigh].m_data[(k + 1) % lenNeigh] || this.m_element[i].m_data[(j + 1) % len] == this.m_element[elemNeigh].m_data[(k + 1) % lenNeigh] && this.m_element[i].m_data[(j + 2) % len] == this.m_element[elemNeigh].m_data[(k + 2) % lenNeigh]))) {
                            correct = false;
                            if (!found) {
                                strBuf.append("two adjacent triangles do not reference\n");
                            } else {
                                strBuf.append("two adjacent triangles reference but have no common edge\n");
                            }
                            strBuf.append("\t element = " + i + " at vertex = " + this.m_element[i].m_data[j] + "\n");
                            l = 0;
                            while (l < len) {
                                strBuf.append("\t element[" + i + "][" + l + "] = " + this.m_element[i].m_data[l] + ", neighbour[" + i + "][" + l + "] = " + this.m_neighbour[i].m_data[l] + "\n");
                                ++l;
                            }
                            if (found) {
                                strBuf.append("\t element = " + elemNeigh + " at vertex = " + this.m_element[elemNeigh].m_data[otherLocInd] + "\n");
                            } else {
                                strBuf.append("\t element = " + elemNeigh + " does not reference back\n");
                            }
                            l = 0;
                            while (l < lenNeigh) {
                                strBuf.append("\t element[" + elemNeigh + "][" + l + "] = " + this.m_element[elemNeigh].m_data[l] + ", neighbour[" + elemNeigh + "][" + l + "] = " + this.m_neighbour[elemNeigh].m_data[l] + "\n");
                                ++l;
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!correct) {
            PsDebug.message(strBuf.toString());
        } else {
            PsDebug.message("neighbour is correct");
        }
        return correct;
    }

    public PiVector[] getSavedElements() {
        return this.m_elementSaved;
    }

    public void setSavedElements(PiVector[] element) {
        if (element == null) {
            this.m_elementSaved = null;
            return;
        }
        if (this.m_elementSaved == null) {
            this.m_elementSaved = PiVector.copyNew(element, this.m_numElements);
        } else {
            this.m_elementSaved = PiVector.realloc(this.m_elementSaved, element.length);
            PiVector.copy(this.m_elementSaved, 0, element, 0, element.length);
        }
    }

    public boolean makeElementColorsFromZ() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] color = this.getElementColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numElements) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_element[i].m_data), bnd[0]);
            float col = (float)vec.m_data[dim] / diag;
            color[i] = new Color(1.0f - col, 0.0f, col);
            ++i;
        }
        return true;
    }

    public boolean close() {
        int j;
        if (this.m_bndList == null || this.m_bndList.length == 0) {
            PsDebug.notify("missing bndList in " + this.getName());
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.warning("less than 2 vertices in " + this.getName());
            return false;
        }
        double max_dist = 0.01;
        boolean shrink_small = true;
        int nob = this.m_bndList.length;
        double[] len = new double[nob];
        int oActive = 0;
        int i = 0;
        while (i < nob) {
            if (!this.m_bndList[i].hasTag(2)) {
                ++oActive;
                len[i] = this.m_bndList[i].getLength();
                if (len[i] > 1.0) {
                    len[i] = 1.0;
                }
            }
            ++i;
        }
        PsDebug.notify("removing interior boundaries");
        i = 0;
        while (i < nob) {
            if (!this.m_bndList[i].hasTag(2)) {
                j = i + 1;
                while (j < nob) {
                    int n;
                    if (!this.m_bndList[j].hasTag(2) && (n = this.m_bndList[i].bndcmp(this.m_bndList[j], Math.min(len[i], len[j]) * max_dist)) != 0) {
                        PsDebug.notify("identifying boundary " + i + " and " + j);
                        this.m_bndList[i].bnd_id(this.m_bndList[j], n);
                        this.m_bndList[i].setTag(2);
                        this.m_bndList[j].setTag(2);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (shrink_small) {
            PsDebug.notify("removing small boundaries");
            i = 0;
            while (i < nob) {
                if (!this.m_bndList[i].hasTag(2) && this.m_bndList[i].bndtst(max_dist) == 1) {
                    PsDebug.notify("removed " + i);
                    this.m_bndList[i].bnd_shrink();
                    this.m_bndList[i].setTag(2);
                }
                ++i;
            }
        }
        i = 0;
        while (i < nob) {
            if (this.m_bndList[i] != null && !this.m_bndList[i].hasTag(2)) {
                this.m_bndList[i].assignVertices();
            }
            ++i;
        }
        PsDebug.notify("pasting boundaries");
        i = 0;
        while (i < nob) {
            if (!this.m_bndList[i].hasTag(2)) {
                j = 0;
                while (j < i) {
                    int type;
                    if (!this.m_bndList[j].hasTag(2) && (type = this.m_bndList[i].bnd_cmp_paste(this.m_bndList[j], Math.min(len[i], len[j]) * max_dist)) != 0) {
                        PsDebug.notify("pasting " + i + " and " + j);
                        if (this.m_bndList[i].bnd_paste(this.m_bndList[j], type)) {
                            this.m_bndList[j].setTag(2);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < nob) {
            if (this.m_bndList[i] != null && !this.m_bndList[i].hasTag(2)) {
                this.m_bndList[i].assignVertices();
            }
            ++i;
        }
        int nActive = nob;
        i = 0;
        while (i < nob) {
            if (this.m_bndList[i] != null && this.m_bndList[i].hasTag(2)) {
                --nActive;
            }
            ++i;
        }
        if (nActive < nob) {
            PgBndPolygon[] newBndList = new PgBndPolygon[nActive];
            int ind = 0;
            i = 0;
            while (i < nob) {
                if (this.m_bndList[i] != null && !this.m_bndList[i].hasTag(2)) {
                    newBndList[ind++] = this.m_bndList[i];
                }
                ++i;
            }
            this.m_bndList = newBndList;
        }
        if (nActive != oActive) {
            PsDebug.notify(oActive - nActive + " boundaries removed");
        }
        this.removeUnusedVertices();
        return true;
    }

    public void computeRotation(PgPolygon meridian, int numULines) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeRotation(meridian, numULines);
        int numVLines = meridian.getNumVertices();
        this.makeQuadrConn(numULines, numVLines);
        this.makeQuadrBnd(numULines, numVLines);
    }

    public boolean makeElementColorsFromZHue() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        int dim = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] color = this.getElementColors();
        PdVector[] bnd = this.getAmbientBounds();
        float diag = (float)(bnd[1].m_data[dim] - bnd[0].m_data[dim]);
        PdVector vec = new PdVector(this.m_dim);
        PdVector center = new PdVector(this.m_dim);
        int i = 0;
        while (i < this.m_numElements) {
            vec.sub(PgGeometry.getCenterOfElement(center, this.m_vertex, this.m_element[i].m_data), bnd[0]);
            float col = (float)vec.m_data[dim] / diag;
            color[i] = new Color(Color.HSBtoRGB(1.0f - col, 1.0f, 1.0f));
            ++i;
        }
        return true;
    }

    public boolean hasElementBackColors() {
        return this.m_elementBackColor != null && this.m_elementBackColor.length == this.m_maxNumElements;
    }

    public boolean blend(double s, PgGeometry ag, double t, PgGeometry bg) {
        if (!super.blend(s, ag, t, bg)) {
            return false;
        }
        if (!(ag instanceof PgElementSet)) {
            return false;
        }
        PgElementSet a = (PgElementSet)ag;
        PgElementSet b = (PgElementSet)bg;
        if (a.m_numElements != b.m_numElements) {
            PsDebug.warning("unequal number of elements");
            return false;
        }
        this.setNumElements(a.m_numElements);
        int i = 0;
        while (i < this.m_numElements) {
            this.m_element[i].copy(a.m_element[i]);
            if (a.m_neighbour != null) {
                this.m_neighbour[i].copy(a.m_neighbour[i]);
            }
            ++i;
        }
        if (a.m_elementNormal != null && b.m_elementNormal != null) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_numElements, this.m_dim);
            i = 0;
            while (i < this.m_numElements) {
                this.m_elementNormal[i].blend(s, a.m_elementNormal[i], t, b.m_elementNormal[i]);
                this.m_elementNormal[i].normalize();
                ++i;
            }
        }
        if (a.m_elementColor != null && b.m_elementColor != null) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_numElements);
            i = 0;
            while (i < this.m_numElements) {
                this.m_elementColor[i] = PdColor.blend(s, a.m_elementColor[i], t, b.m_elementColor[i]);
                ++i;
            }
        }
        if (a.m_elementBackColor != null && b.m_elementBackColor != null) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_numElements);
            i = 0;
            while (i < this.m_numElements) {
                this.m_elementBackColor[i] = PdColor.blend(s, a.m_elementBackColor[i], t, b.m_elementBackColor[i]);
                ++i;
            }
        }
        if (a.hasBoundary() && b.hasBoundary()) {
            this.assureBoundary(a.m_bndList.length);
            i = 0;
            while (i < this.m_bndList.length) {
                this.m_bndList[i].blend(s, a.m_bndList[i], t, b.m_bndList[i]);
                ++i;
            }
        }
        this.m_bConforming = a.m_bConforming;
        return true;
    }

    public void makeQuadrVertexTexture(int uDiscr, int vDiscr) {
        if (uDiscr < 2 || vDiscr < 2) {
            return;
        }
        this.assureVertexTextures();
        double uFac = 1.0 / (-1.0 + (double)uDiscr);
        double vFac = 1.0 / (-1.0 + (double)vDiscr);
        int ind = 0;
        int i = 0;
        while (i < uDiscr) {
            double u = uFac * (double)i;
            int j = 0;
            while (j < vDiscr) {
                double v = vFac * (double)j;
                this.m_vertexTexture[ind].m_data[0] = u;
                this.m_vertexTexture[ind].m_data[1] = v;
                ++ind;
                ++j;
            }
            ++i;
        }
    }

    public void makeQuadrElementTexture(int uDiscr, int vDiscr) {
        if (uDiscr < 2 || vDiscr < 2) {
            return;
        }
        this.assureElementTextures();
        double uFac = 1.0 / (-1.0 + (double)uDiscr);
        double vFac = 1.0 / (-1.0 + (double)vDiscr);
        if (this.m_dimOfElements == 3) {
            int ind = 0;
            int i = 0;
            while (i < uDiscr - 1) {
                int j = 0;
                while (j < vDiscr - 1) {
                    this.m_elementTexture[ind][0].m_data[0] = (double)i * uFac;
                    this.m_elementTexture[ind][0].m_data[1] = (double)j * vFac;
                    this.m_elementTexture[ind][1].m_data[0] = (double)(i + 1) * uFac;
                    this.m_elementTexture[ind][1].m_data[1] = (double)j * vFac;
                    this.m_elementTexture[ind][2].m_data[0] = (double)i * uFac;
                    this.m_elementTexture[ind][2].m_data[1] = (double)(j + 1) * vFac;
                    this.m_elementTexture[++ind][0].m_data[0] = (double)i * uFac;
                    this.m_elementTexture[ind][0].m_data[1] = (double)(j + 1) * vFac;
                    this.m_elementTexture[ind][1].m_data[0] = (double)(i + 1) * uFac;
                    this.m_elementTexture[ind][1].m_data[1] = (double)j * vFac;
                    this.m_elementTexture[ind][2].m_data[0] = (double)(i + 1) * uFac;
                    this.m_elementTexture[ind][2].m_data[1] = (double)(j + 1) * vFac;
                    ++ind;
                    ++j;
                }
                ++i;
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements((uDiscr - 1) * (vDiscr - 1));
            int ind = 0;
            int i = 0;
            while (i < uDiscr - 1) {
                int j = 0;
                while (j < vDiscr - 1) {
                    this.m_elementTexture[ind][0].m_data[0] = (double)i * uFac;
                    this.m_elementTexture[ind][0].m_data[1] = (double)j * vFac;
                    this.m_elementTexture[ind][1].m_data[0] = (double)(i + 1) * uFac;
                    this.m_elementTexture[ind][1].m_data[1] = (double)j * vFac;
                    this.m_elementTexture[ind][2].m_data[0] = (double)(i + 1) * uFac;
                    this.m_elementTexture[ind][2].m_data[1] = (double)(j + 1) * vFac;
                    this.m_elementTexture[ind][3].m_data[0] = (double)i * uFac;
                    this.m_elementTexture[ind][3].m_data[1] = (double)(j + 1) * vFac;
                    ++ind;
                    ++j;
                }
                ++i;
            }
        }
    }

    public void buildQuadrFromCurve(PgPolygon[] curve, PgBndConstraint[] bndConstr) {
        if (curve == null || bndConstr == null) {
            PsDebug.warning("missing argument", this);
            return;
        }
        if (curve.length != 4 || bndConstr.length != 4) {
            PsDebug.warning("wrong argument array list", this);
            return;
        }
        int uDiscr = curve[0].getNumVertices();
        int vDiscr = curve[1].getNumVertices();
        int uSub = 0;
        int vSub = 0;
        int nov = (1 + (uDiscr - 1) * (uSub + 1)) * (1 + (vDiscr - 1) * (vSub + 1));
        int noePerPatch = 4 + 2 * uSub + 2 * vSub - 2;
        int noe = (uDiscr - 1) * (vDiscr - 1) * noePerPatch;
        this.setNumVertices(nov);
        this.setNumElements(noe);
        int ind = 0;
        int i = 0;
        while (i < uDiscr) {
            double u = (double)i / ((double)uDiscr - 1.0);
            PdVector pu = curve[0].m_vertex[i];
            PdVector qu = curve[2].m_vertex[uDiscr - 1 - i];
            int j = 0;
            while (j < vDiscr) {
                double v = (double)j / ((double)vDiscr - 1.0);
                PdVector p = curve[1].m_vertex[j];
                PdVector q = curve[3].m_vertex[vDiscr - 1 - j];
                int k = 0;
                while (k < this.m_dim) {
                    double umean = pu.m_data[k] + v * (qu.m_data[k] - pu.m_data[k]);
                    double vmean = q.m_data[k] + u * (p.m_data[k] - q.m_data[k]);
                    this.m_vertex[ind].m_data[k] = i == 0 || i == uDiscr - 1 ? vmean : (j == 0 || j == vDiscr - 1 ? umean : (umean + vmean) / 2.0);
                    ++k;
                }
                ++ind;
                ++j;
            }
            ++i;
        }
        this.makeQuadrConn(uDiscr, vDiscr);
        this.makeQuadrBnd(uDiscr, vDiscr);
        i = 0;
        while (i < bndConstr.length) {
            this.m_bndList[i].m_bndConstraint = bndConstr[i];
            ++i;
        }
    }

    public void buildPolygonFromCurve(PgPolygon[] curve) {
        PsDebug.error("empty method", this);
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize.getValue();
    }

    public void setGlobalElementNormalSize(double size) {
        this.m_globalElementNormalSize.setValue(size);
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeSize(double size) {
        this.m_globalEdgeSize.setValue(size);
    }

    public double getVertexAngle(int elemInd, int locInd) {
        int elemLen = this.m_element[elemInd].getSize();
        PdVector p = this.m_vertex[this.m_element[elemInd].m_data[locInd]];
        PdVector q = this.m_vertex[this.m_element[elemInd].m_data[(locInd + 1) % elemLen]];
        PdVector r = this.m_vertex[this.m_element[elemInd].m_data[(locInd - 1 + elemLen) % elemLen]];
        return PdVector.angle(p, q, r);
    }

    public PdMatrix getL2Matrix(PdMatrix mat) {
        int j;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("elements must be triangular.");
            return null;
        }
        if (mat == null) {
            mat = new PdMatrix(this.m_numVertices);
        } else if (mat.getSize() != this.m_numVertices) {
            mat.setSize(this.m_numVertices);
        }
        int i = 0;
        while (i < this.m_numElements) {
            double triArea = this.getAreaOfElement(i) / 12.0;
            int[] elemData = this.m_element[i].m_data;
            j = 0;
            while (j < 3) {
                double[] dArray = mat.m_data[elemData[j]];
                int n = elemData[j];
                dArray[n] = dArray[n] + (triArea + triArea);
                double[] dArray2 = mat.m_data[elemData[j]];
                int n2 = elemData[(j + 1) % 3];
                dArray2[n2] = dArray2[n2] + triArea;
                double[] dArray3 = mat.m_data[elemData[(j + 1) % 3]];
                int n3 = elemData[j];
                dArray3[n3] = dArray3[n3] + triArea;
                ++j;
            }
            ++i;
        }
        double norm = 0.0;
        double[] vec = new double[3];
        i = 0;
        while (i < this.m_numVertices) {
            int k = 0;
            while (k < 3) {
                vec[k] = 0.0;
                ++k;
            }
            j = 0;
            while (j < this.m_numVertices) {
                k = 0;
                while (k < 3) {
                    int n = k;
                    vec[n] = vec[n] + mat.m_data[i][j] * this.m_vertex[j].m_data[k];
                    ++k;
                }
                ++j;
            }
            k = 0;
            while (k < 3) {
                norm += this.m_vertex[i].m_data[k] * vec[k];
                ++k;
            }
            ++i;
        }
        if (Math.abs(norm - this.getL2Norm()) > 1.0E-10) {
            PsDebug.warning("different L2-norms:\n\t getL2Norm()   = " + this.getL2Norm() + "\n\t getL2Matrix() = " + norm);
        }
        return mat;
    }
}

