/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OneParameter
extends JPanel {
    Project project;
    public int parNo = 0;
    public JCheckBox cbox = new JCheckBox("", false);
    public JLabel nameLabel = null;
    public double oldFrom = 0.0;
    public double oldTo = 1.0;
    public double newFrom = 0.0;
    public double newTo = 1.0;
    public JTextField from = new JTextField("0.00000");
    public JTextField to = new JTextField("1.00000");
    public JLabel parLabel = new JLabel("0.50000");
    JLabel fromLabel = new JLabel("from:");
    JLabel toLabel = new JLabel("to:");
    JSlider parSlider = null;
    public JLabel fctLabel = null;
    public JTextField fct = new JTextField("");

    OneParameter(Project project) {
        this.project = project;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout());
        this.nameLabel = new JLabel("p" + this.parNo);
        this.fctLabel = new JLabel("  " + this.nameLabel.getText() + ":=");
        this.fct.setText("     " + this.nameLabel.getText() + "  ");
        this.fct.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OneParameter.this.fct.setText(OneParameter.this.fct.getText());
                OneParameter.this.repaint();
            }
        });
        jPanel.add(this.nameLabel);
        this.parSlider = new JSlider(0, 1000);
        this.parSlider.setValue(500);
        this.parSlider.setMinorTickSpacing(10);
        this.parSlider.setMajorTickSpacing(100);
        this.parSlider.setPaintTicks(true);
        this.parSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                OneParameter.this.updateparSliderAndLabel();
            }
        });
        jPanel.add(new JLabel("   "));
        jPanel.add(this.fromLabel);
        jPanel.add(this.from);
        this.from.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(OneParameter.this.from.getText());
                    if (d <= OneParameter.this.oldTo) {
                        OneParameter.this.oldFrom = d = (double)Math.round(d * 1000.0) / 1000.0;
                        OneParameter.this.newFrom = d;
                        OneParameter.this.updateparSliderAndLabel();
                    } else {
                        OneParameter.this.from.setText("" + OneParameter.this.oldFrom);
                    }
                }
                catch (Exception exception) {
                    OneParameter.this.from.setText("" + OneParameter.this.oldFrom);
                }
            }
        });
        this.to.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    double d = Double.parseDouble(OneParameter.this.to.getText());
                    if (d >= OneParameter.this.oldFrom) {
                        OneParameter.this.oldTo = d = (double)Math.round(d * 1000.0) / 1000.0;
                        OneParameter.this.newTo = d;
                        OneParameter.this.updateparSliderAndLabel();
                    } else {
                        OneParameter.this.to.setText("" + OneParameter.this.oldTo);
                    }
                }
                catch (Exception exception) {
                    OneParameter.this.to.setText("" + OneParameter.this.oldTo);
                }
            }
        });
        jPanel.add(this.toLabel);
        jPanel.add(this.to);
        jPanel.add(this.parSlider);
        jPanel.add(this.parLabel);
        jPanel.add(this.fctLabel);
        this.add(this.fct);
        this.add((Component)jPanel, "West");
    }

    public double getValue() {
        return this.parSlider.getValue();
    }

    public void updateparSliderAndLabel() {
        this.parSlider.setMinimum((int)(this.newFrom * 1000.0));
        this.parSlider.setMaximum((int)(this.newTo * 1000.0));
        this.parSlider.setMinorTickSpacing((int)(10.0 * (this.newTo - this.newFrom)));
        this.parSlider.setMajorTickSpacing((int)(100.0 * (this.newTo - this.newFrom)));
        this.parLabel.setText("" + (double)this.parSlider.getValue() / 1000.0);
        this.repaint();
    }

    public boolean isSelected() {
        return this.cbox.isSelected();
    }

    public void setParNo(int n) {
        this.parNo = n;
        this.nameLabel.setText("p" + this.parNo);
        this.fctLabel.setText("  " + this.nameLabel.getText() + ":=");
        this.fct.setText(this.nameLabel.getText());
    }

    public void updateActionCommands(int n) {
    }

    public String getSurfCode() {
        String string = "double " + this.nameLabel.getText() + "=" + this.parLabel.getText() + ";\n";
        string = string + this.nameLabel.getText() + "=" + this.fct.getText() + ";\n";
        return string;
    }

    public String getSurfCode(double d) {
        String string = "double " + this.nameLabel.getText() + "=" + d + ";\n";
        string = string + this.nameLabel.getText() + "=" + this.fct.getText() + ";\n";
        return string;
    }

    public void saveYourself(PrintWriter printWriter) {
        String string = "";
        printWriter.println("////////////////// Parameter: /////////////////////////\n");
        printWriter.println("" + this.parNo + "\n");
        printWriter.println("" + this.newFrom + "\n");
        printWriter.println("" + this.newTo + "\n");
        printWriter.println("" + this.parSlider.getValue() + "\n");
        printWriter.println("" + this.fct.getText() + "\n");
    }

    public String saveYourself() {
        String string = "";
        string = string + "////////////////// Parameter: /////////////////////////\n";
        string = string + "" + this.parNo + "\n";
        string = string + "" + this.newFrom + "\n";
        string = string + "" + this.newTo + "\n";
        string = string + "" + this.parSlider.getValue() + "\n";
        string = string + "" + this.fct.getText() + "\n";
        return string;
    }
}

