<?xml version="1.0"?>

<!-- $Id: news.xsl 1137 2007-05-21 05:38:16Z kate $ -->
<!-- This stylesheets reads the newsitems XML and outputs docbook -->

<xsl:stylesheet extension-element-prefixes="date set exslt"
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:date="http://exslt.org/dates-and-times"
	xmlns:exslt="http://exslt.org/common"
	xmlns:set="http://exslt.org/sets">

	<xsl:output method="xml" indent="yes"/>

	<xsl:template match="date" mode="yearonly">
		<year>
			<xsl:copy-of select="substring-before(text(), '-')"/>
		</year>
	</xsl:template>

	<xsl:template match="/news">
		<xsl:variable name="now" select="date:date-time()"/>

		<xsl:variable name="dates">
			<xsl:apply-templates select="entry/date" mode="yearonly"/>
		</xsl:variable>

		<xsl:variable name="entries">
			<xsl:copy-of select="entry"/>
		</xsl:variable>

		<section>
			<!-- Here we're grouping for one <section> per year -->
			<xsl:for-each select="set:distinct(exslt:node-set($dates)/year)">
				<section>
					<title>
						<xsl:text>News - </xsl:text>
						<xsl:value-of select="."/>
					</title>

					<!-- The . here is a <year> tag from $dates -->
					<xsl:variable name="year" select="./text()"/>

					<itemizedlist>
						<xsl:apply-templates select="exslt:node-set($entries)/entry[substring-before(date/text(), '-') = $year]">
							<xsl:sort data-type="number" select="date" order="descending"/>
						</xsl:apply-templates>
					</itemizedlist>
				</section>
			</xsl:for-each>
		</section>
	</xsl:template>

	<xsl:template match="entry">
		<listitem>
			<para>
				<emphasis>
					<xsl:value-of select="date"/>
					<xsl:text>: </xsl:text>
				</emphasis>
				<xsl:value-of select="content"/>
			</para>
		</listitem>
	</xsl:template>
</xsl:stylesheet>

