/* 
   sand - helps you keep your diary

   sand.h - common parts for program

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/


#ifndef __SAND_H__SAND__
#define __SAND_H__SAND__
#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "ddecode.h"
#include "output.h"
#include "cli.h"

#define EXIT_OK 0
#define EXIT_FAILURE 1
#define EXIT_FAILURE_NO_RC 2
#define RC_DIR ".sand"
#define PROGRAM_NAME "sand"
#define TEMP_PREFIX "~sand"
#define DIARY_NAME ".sand/diary"

char *xmalloc ();
char *xrealloc ();
char *xstrdup ();


void message_ver (char * msg, int msg_mode);
static void message (char * msg) { message_ver(msg, 0);}
void message_err (char * msg);

unsigned char sand_config();

char * get_home_dir();
void   get_create_rc_dir();
char * get_diary_file_name();

dinfo * input_diary(dinfo *diary_ret);
FILE * open_diary(int mode);
int dump_file(FILE * from, FILE * to);

#ifndef __SAND_C__SAND__
/* The name the program was run with, stripped of any leading path. */
extern char *program_name;
/* The rc directory for the program */
extern char *program_rc_dir;
/* The name of the diary file */
extern char *program_diary_file;
/* The program home dir */
extern char *program_home;

extern int want_verbose;		/* --verbose */
extern int want_output_text;           /* --output-text */
extern int want_dump_text;             /* --dump-text */
extern int want_note;                  /* --note */
extern int note_number;
#endif

#endif






