/* 
   sand - helps you keep your diary
   
   output-text.c - output diary note in plain text format 

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

#include <termios.h>
#include <grp.h>
#include <pwd.h>
*/

#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include <string.h>
#include "system.h"
#include "repl_func.h"

#include "ddecode.h"


/* out_text_fputnote - outputs a note in plain text format to a file */ 
int out_text_fputnote(dnote d, FILE * to)
{
  int i, j;
  char * date;
  
  date = dencode_date(d);
  j = strlen(date);
  
  fprintf(to, "%s\n",date);
  for(i = 0; i < j; i++) {putc('=',to);} 
  putc('\n',to);

  if (d.title != (char *) NULL)
    {
      j = strlen(d.title);
      fprintf(to, "%s\n",d.title);
      for(i = 0; i < j; i++) {putc('-',to);} 
      putc('\n',to);
    }

  for(i = 0; i < d.length; i++)
    {
      putc(d.text[i],to);
    }
  
  fprintf(to, "\n\n");

}
