/* 
   sand - helps you keep your diary
   
   output-diary.c - output diary note in diary format 

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

#include <termios.h>
#include <grp.h>
#include <pwd.h>
*/

#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include <string.h>
#include "system.h"
#include "repl_func.h"

#include "ddecode.h"

extern int dump_file(FILE * from, FILE * to);

/* out_diary_fputnote - outputs a note in diary format to a file */ 
int out_diary_fputnote(dnote d, FILE * to)
{
  int i;

  fprintf(to, "<note>\n<date>%s</date>\n",dencode_date(d));
  if (d.title != (char *)NULL)
    fprintf(to,"<title>%s</title>\n", d.title);
  fprintf(to, "<body>\n");

  for(i = 0; i < d.length; i++)
    {
      fputc(d.text[i],to);
    }
  
  fprintf(to, "</body>\n</note>\n");

}

/* out_diary_special_fputnote - outputs a note in diary format to a file
   but with the note text in a file */
int out_diary_special_fputnote(dnote d, FILE * to, FILE * source)
{  

  fprintf(to, "<note>\n<date>%s</date>\n",dencode_date(d));
  if (d.title != (char *)NULL)
    fprintf(to,"<title>%s</title>\n", d.title);
  fprintf(to, "<body>\n");

  dump_file(source,to);
  
  fprintf(to, "</body>\n</note>\n");


}
