/* 
   sand - helps you keep your diary
   
   dencode.c - encoder for diary format 

   Copyright (C) 2001 Per Jonsson

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

#include <termios.h>
#include <grp.h>
#include <pwd.h>
*/

#include <stdio.h>
#include <sys/types.h>
#include <getopt.h>
#include <string.h>
#include <time.h>
#include "system.h"
#include "repl_func.h"
#include "ddecode.h"

char *xmalloc ();
char *xrealloc ();
char *xstrdup ();
char *xcalloc();
extern void message_err (char * msg);

/* Encodes a date according to the rules*/
char * dencode_date (dnote n)
{
  char *buf;

  asprintf(&buf, "%.4u/%.2u/%.2u %.2u:%.2u:%.2u", n.time.year, n.time.month,
	  n.time.day, n.time.hour, n.time.minute, n.time.seconds);
  
  return buf;
}


dnote dencode_note_now(char * s, char * p)
{
  return dencode_note(s, p, time((time_t *)NULL));
}

dnote dencode_note(char * s, char * p, time_t t)
{
  dnote d;

  d.length = strlen(s);
  d.time = time_t2dtime(t);
  d.text = s;

  if (strlen(p) != 0)
    d.title = strdup(p);
  else
    d.title = (char *)NULL;
  
  return d;
}
