/**************************************************************************
 **SA Network Connection Profiler [sancp] - A TCP/IP statistical/collection tool
 * ************************************************************************
 * * Copyright (C) 2003 John Curry <john.curry@metre.net>
 * *
 * * This program is distributed under the terms of version 1.0 of the
 * * Q Public License.  See LICENSE.QPL for further details.
 * *
 * * This program is distributed in the hope that it will be useful,
 * * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * *
 * ***********************************************************************/

#define SANCP_H


//#define DEBUG 1

#include <signal.h>	// set_signals(), SIGHUP, signal, SIGUSR1, SIGUSR2, SIGTERM, SIGINT, SIGKILL, SIGQUIT
#include <arpa/inet.h>  // inet_aton(), inet_ntoa()
#include <errno.h>	// errno, EINTR, EAGAIN, EIO, EISDIR, EBADF, EINVAL, EFAULT
#include <syslog.h>     // LOG_ERR, LOG_CONS, LOG_INFO, LOG_CRIT
			// LOG_LOCAL1, LOG_LOCAL2, LOG_LOCAL3, LOG_LOCAL4, LOG_LOCAL5, LOG_LOCAL6, LOG_LOCAL7

#include <ctype.h>
#include <time.h>
//#include <net/ethernet.h>

//#include <stdio.h> 
//#include <unistd.h>
//#include <sys/socket.h>

// Required for BSD
#include <netinet/in.h>

//#include <net/if.h>
//#include <fcntl.h>
//#include <stdlib.h>
//#include <sys/ioctl.h>
//#include <time.h>
//#include <sys/time.h>
//#include <ctype.h>
//#include <string.h>

#ifndef GVARS_H
#include "gvars.h"
#endif

#define NCP_H
#define Y 'Y'
#define N 'N'
#define MIN_WAIT_TIME 4  // We will wait at least this many seconds before expiring a closed connection

// Include our own version of ether_addr since linux/solaris 
// differ from bsd systems on definition of struct ether_addr

#define ETHER_ADDR_LEN          6       /* length of an Ethernet address */

struct  myether_addr {
        u_char octet[ETHER_ADDR_LEN];
};

/*
 * Structure of a 10Mb/s Ethernet header.
 */
struct  ether_header {    // we pulled this from net/ethernet.h
        u_char  ether_dhost[ETHER_ADDR_LEN];
        u_char  ether_shost[ETHER_ADDR_LEN];
        u_short ether_type;
};



struct vars {
	char *key;
	char *value;
	int  vclass;  // variable class
	struct vars *next;
};

int main(int argc, char *argv[]);
struct cnx *process(struct cnx*, int len, u_char * pkt);
char * createPcapFileName();
char * createFileName(const char* filename);
char * createFileName(const char* filename, bool);
char * createPcapFileName(const struct acl* tacl);
char * createPcapFileName(const struct cnx* tcnx);
extern "C" pcap_t * open_pcap_live(char *,char *);
extern "C" pcap_t * open_pcap_file(char *,char *);
extern "C" void close_pcap_file(pcap_t *);
extern "C" void start_pcap_loop(pcap_t *);
extern "C" void print_linktype(pcap_t *);
void erase_idle(int a);
void reopen_files(int a);
void expire_connections();
struct cnx *update_state_node(struct cnx *);
void build_config(int a);
void parse_args(int arg, char* argv[]);
void parse_format(const char *,const char *);
void print_acl(int a);
void print_stats(int a);
void print_output_schema(outputFileHandle *fH, char *fmtcols, int fmtlen);
void write_schema(char *name, char *fmt, int fmtlen);
void print_schemas();
int fgetcline(char **buf, int size, FILE *fp);
int promisc_mode(char *, int);
void close_files(int a);
void open_files();
void reload_config(int a);
void record_all(int a);
void free_all(int a);
void exit_all(int a);
void manage_cid(int a);

void record(struct cnx *, outputFileHandle *fH);
void set_signals();
void decode(struct cnx*, int len, const u_char * pkt);
void decode_pcap(struct cnx*,struct pcap_pkthdr * pkthdr, u_char * pkt);
int CheckPort(u_int8_t proto,u_int16_t port);
void SChangeUserGroup();
void apply_rule(struct cnx*);
void parse_var(char *,char *);
void parse_known_ports(char *, struct vars*, char *);
void parse_connection_rule(char *, struct vars*, char *);
void open_pcap_output();

/* Hash Table Protos */
#define DEFAULT_FLUSH_INTERVAL 1800 
#define DEFAULT_EXPIRE_INTERVAL 10
#define VERSION "1.6.1-stable"
#define NAME "sancp"
#define LOG_DIR "./" /* default relative to current working directory */
#define CONFIG_DIR "/etc/sancp/"
#define CONFIG_FILE "sancp.conf"
#define PCAP_RAW_FNAME "debug_pcap_raw"
#define PCAP_FNAME "pcap"
#define STATS_FNAME "stats"
#define REALTIME_FNAME "realtime"
#define true 1
#define false 0
#define PROMISC 1
#define MAX_VAR 256
#define MAXFLDS 85		// define number of elements in fmtnames[]
#define MAXFLDSIZE 19		// define largest element in fmtnames[MAXFLDS][MAXFLDLEN]
#define MAXENTRYLEN 256
#define DELIMITER '|'
#define READ_TIMEOUT 500
#define ETHPROTO_IP  0x0008
// network order bytes 0x0806
#define ETHPROTO_ARP  0x0608
// network order bytes 0x8035
#define ETHPROTO_RARP  0x3580
// network order bytes 0x8100
#define ETHPROTO_8021Q  0x0081
#define DEFAULT_DEVICE "any"
#define DEFAULT_NODE 0
#define DEFAULT_LIMIT 0
#define DEFAULT_RID 0
#define DEFAULT_RGID 0
#define DEFAULT_ZONE 0
//#define TCP_TIMEOUT 120
//#define UDP_TIMEOUT 300
//#define ICMP_TIMEOUT 120
#define DEFAULT_TIMEOUT 300 
#define DEFAULT_STATUS 0 
#define DEFAULT_LAG 0
#define DEFAULT_DELIMITER '|'
#define DEFAULT_EOR '\n'
#define MAX_PORTS 65536
#define FROM_INITIATOR 0
#define FROM_TARGET 1
#define ACTION_PASS 0
#define ACTION_LOG 1
#define ACTION_DEFAULT 2
#define CMODE_NONE 0
#define CMODE_BOTH 1
#define CMODE_SRC 2
#define CMODE_DST 3
#define OMODE_PASS 0
#define OMODE_LOG 1
#define OMODE_DEFAULT 2
#define OMODE_FILENAME 3
#define OMODE_TSFILENAME 4
#define OMODE_RULE 5
#define OMODE_UNIQ 6

// Need to distinguish between classes of variables
#define VCLASS_0 1	// eth_proto class vars
#define VCLASS_1 2	// ip_addr class vars
#define VCLASS_2 3	// ip_proto class vars
#define VCLASS_3 4	// port class vars
#define VCLASS_4 5	// rid class vars
#define VCLASS_5 6	// rgid class vars
#define VCLASS_6 7	// zone class vars
#define VCLASS_7 8	// node class vars
#define VCLASS_8 9	// status class vars

#define DISABLED 0
#define ENABLED 1
#define CNX_REVERSED 1
#define CNX_BOTH_PORTS_KNOWN 2
#define CNX_BOTH_PORTS_UNKNOWN 3
#define CNX_REREVERSED 4
#define MAX_PACK_LEN   20000  /* Sufficient for ethernet packets. */
#define ETHER_SIZE     14
#ifdef EXPERIMENTAL_TCPOPTIONS
#define TCPOPT_EOL              0
#define TCPOPT_NOP              1
#define TCPOPT_MAXSEG           2
#define TCPOPT_SACKOK           4    /* Experimental */
#define TCPOPT_WSCALE		3
#define TCPOPTIONS_MAX		8    /* Maximum number of tcpoptions to parse */
#endif


#define R_FIN          0x01
#define R_SYN          0x02
#define R_RST          0x04
#define R_PSH          0x08
#define R_ACK          0x10
#define R_URG          0x20
#define R_RES2         0x40
#define R_RES1         0x80
#define max(i,j)        (((i)>(j)) ? (i) : (j))
#define SIZE_OF_CLASS_C	11

struct t_ports {
	u_int16_t l_port;
	u_int16_t h_port;
	struct t_ports *next;
};


struct os_info {
        u_int8_t ttl;
        u_int16_t len;
        u_int16_t wss;
#ifdef EXPERIMENTAL_TCPOPTIONS
        u_int8_t df:1, nop:1, sack_ok:1;
        u_int16_t mss;
        short wscale;
#else
        u_int8_t df:1;
#endif

};


struct acl {
    struct ether_header eth_hdr;
    u_int16_t h_proto_h;
    u_int16_t h_proto_l;
    u_int32_t s_ip;
    u_int32_t s_mask;
    u_int16_t s_port_l;
    u_int16_t s_port_h;
    u_int32_t d_ip;
    u_int32_t d_mask;
    u_int16_t d_port_l;
    u_int16_t d_port_h;
    u_int8_t proto_l;
    u_int8_t proto_h;
    u_int32_t offset;
    u_int32_t mask;
    u_int32_t value;
    pcapFileHandle * fH;
    u_int8_t stats:1, realtime:1, pcap:1, retro:1, smode:2, rmode:2;
    u_int8_t cmode:2, pmode:4;
    u_int16_t tcplag;
    u_int16_t timeout;
    u_int64_t limit;
    u_int16_t status;
    u_int32_t ctr;
    u_int32_t rid;
    u_int16_t rgid;
    u_int16_t node;
    u_int16_t zone;
    CBuffer *CBufferPtr;
    struct acl *next;
};

void retroactive(struct acl*);

struct cnx {
    	struct ether_header eth_hdr;
	u_int16_t h_proto;
	u_int8_t proto;
        u_int32_t s_ip;
        u_int32_t d_ip;
        u_int16_t s_port;
        u_int16_t d_port;
        u_int64_t s_total_pkts;
        u_int64_t s_total_bytes;
        u_int64_t d_total_pkts;
        u_int64_t d_total_bytes;
        u_int64_t total_bytes;
        time_t start_time;
        time_t last_pkt;
	u_int8_t free:1,direction:1;
    	pcapFileHandle *fH;
    	u_int8_t  cmode:4, pcap:1, realtime:1, stats:1, retro:1;
	u_int8_t  tcpFlags[2];
	u_int8_t  tcpCFlags;
	u_int8_t  reversed;
    	u_int16_t tcplag;
    	u_int64_t limit;
    	u_int16_t status;
    	u_int64_t collected;
	u_int64_t cid;
	u_int16_t timeout;
	u_int16_t hash;
        u_int32_t rid;
        u_int16_t rgid;
	u_int16_t node;
	u_int16_t zone;
    	CBuffer *CBufferPtr;
	struct os_info os_info;
	struct os_info os_info2;
        struct cnx *next;
        struct cnx *prev;
};


void usage();
void outputfields();
void rule_syntax();
