# -*- coding: utf-8 -*-
'''
    :codeauthor: :email:`Jayesh Kariya <jayeshk@saltstack.com>`
'''
# Import Python libs
from __future__ import absolute_import

# Import Salt Testing Libs
from salttesting import skipIf, TestCase
from salttesting.mock import (
    NO_MOCK,
    NO_MOCK_REASON,
    MagicMock,
    patch
)

from salttesting.helpers import ensure_in_syspath

ensure_in_syspath('../../')

# Import Salt Libs
from salt.states import rabbitmq_user

rabbitmq_user.__opts__ = {'test': False}
rabbitmq_user.__salt__ = {}


@skipIf(NO_MOCK, NO_MOCK_REASON)
class RabbitmqUserTestCase(TestCase):
    '''
    Test cases for salt.states.rabbitmq_user
    '''
    # 'absent' function tests: 1

    def test_absent(self):
        '''
        Test to ensure the named user is absent.
        '''
        name = 'foo'

        ret = {'name': name,
               'changes': {},
               'result': True,
               'comment': 'The user \'foo\' is not present.'}

        mock = MagicMock(return_value=False)
        with patch.dict(rabbitmq_user.__salt__, {'rabbitmq.user_exists': mock}):
            self.assertDictEqual(rabbitmq_user.absent(name), ret)


if __name__ == '__main__':
    from integration import run_tests
    run_tests(RabbitmqUserTestCase, needs_daemon=False)
