
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                     Tool Library:                     //
//                        SCIMAP                         //
//  Hydrological Connectivity Indices Collection (HCIC)  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   TLB_Interface.cpp                   //
//                                                       //
//                 Copyright (C) 2025 by                 //
//                      Sim Reaney                       //
//               sim.reaney@durham.ac.uk                 //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include <saga_api/saga_api.h>

//---------------------------------------------------------
CSG_String Get_Info(int i)
{
	switch( i )
	{
	case TLB_INFO_Name:	default:
		return( _TL("SCIMAP Toolkit 1.1") );

	case TLB_INFO_Category:
		return( _TL("Simulation") );

	case TLB_INFO_Author:
		return( "Sim M. Reaney, Durham University 2005-2025" );

	case TLB_INFO_Description:
		return( _TL("SCIMAP Risk Maps for diffuse pollution.") );

	case TLB_INFO_Version:
		return( "1.1.20250414" );

	case TLB_INFO_Menu_Path:
		return( _TL("Simulation|Hydrology|Diffuse Pollution") );
	}
}

//---------------------------------------------------------
#include "SCIMAP.h"
#include "netIndex.h"

//---------------------------------------------------------
CSG_Tool *		Create_Tool(int i)
{
	switch( i )
	{
	case  0: return( new CSCIMAP() );
	case  1: return( new CHCIC() );

	default: return( TLB_INTERFACE_SKIP_TOOL );
	case 10: return( NULL );
	}

}


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
//{{AFX_SAGA

	TLB_INTERFACE

//}}AFX_SAGA
