/*
   Copyright (C) Kay Gorontzi, 2010
   based on the work of Andrew Tridgell, 1998

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define RZIP_MAJOR_VERSION 3
#define RZIP_MINOR_VERSION 0

#define NUM_STREAMS 2

#define _GNU_SOURCE

#include "config.h"

#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <stddef.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <time.h>								// time()
#include <sys/types.h>						// wait()
#include <sys/wait.h>

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#include <fcntl.h>
#include <sys/stat.h>

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif
#include <errno.h>
#include <sys/mman.h>

#ifndef uchar
#define uchar unsigned char
#endif

#ifndef int64
#if (SIZEOF_INT == 8)
#define int64 int
#elif (SIZEOF_LONG == 8)
#define int64 long
#else
#define int64 long long
#endif
#endif

#ifndef int32
#if (SIZEOF_INT == 4)
#define int32 int
#elif (SIZEOF_LONG == 4)
#define int32 long
#elif (SIZEOF_SHORT == 4)
#define int32 short
#endif
#endif

#ifndef int16
#if (SIZEOF_INT == 2)
#define int16 int
#elif (SIZEOF_SHORT == 2)
#define int16 short
#endif
#endif

#ifndef int64
#if (SIZEOF_INT == 8)
#define int64 unsigned int
#elif (SIZEOF_LONG == 8)
#define int64 unsigned long
#else
#define int64 unsigned long long
#endif
#endif

#ifndef uint32
#define uint32 unsigned int32
#endif

#ifndef uint16
#define uint16 unsigned int16
#endif

#ifndef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#endif

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif


#if !HAVE_STRERROR
extern char *sys_errlist[];
#define strerror(i) sys_errlist[i]
#endif

#ifndef HAVE_ERRNO_DECL
extern int errno;
#endif


#define FLAG_SHOW_PROGRESS  2
#define FLAG_KEEP_FILES     4
#define FLAG_TEST_ONLY      8
#define FLAG_FORCE_REPLACE 16
#define FLAG_DECOMPRESS    32
#define FLAG_STOP_AND_GO   64

struct rzip_control {
	const char *infile, *outname;
	char *outfile, *outfiletmp;
	const char *suffix;
	unsigned compression_level;
	unsigned flags;
	unsigned verbosity;
	long     slice_seq;
	time_t   start_time;
	int		cores;							// >1: use multiple cores
};

void fatal(const char *format, ...);
void err_msg(const char *format, ...);
off_t runzip_fd(int fd_in, int fd_out, int fd_hist, off_t expected_size, struct rzip_control *ctrl);
void rzip_fd(struct rzip_control *control, int fd_in, int fd_out);
void *open_stream_out(int f, int n, int bzip_level);
void *open_stream_in(int f, int n);
int write_stream(void *ss, int stream, uchar *p, int len);
int read_stream(void *ss, int stream, uchar *p, int len);
int close_stream_out(void *ss);
int close_stream_in(void *ss);
void *Realloc(void *p, int size);
uint32 crc32_buffer(const uchar *buf, int n, uint32 crc);
