/*
 * YARA rules for ARM PE packer detection.
 * Copyright (c) 2017 Avast Software, licensed under the MIT license
 */

import "pe"

rule upx_dll
{
	meta:
    tool = "P"
		name = "UPX"
		version = "3.91"
		source = "Made by RetDec Team"
		pattern = "010051E30?00001AFF4F2DE92?308FE2?????3E8"
	strings:
		$1 = { 01 00 51 E3 0? 00 00 1A FF 4F 2D E9 2? 30 8F E2 ?? ?? ?3 E8 }
	condition:
		$1 at pe.entry_point
}

rule upx_391_lzma
{
	meta:
    tool = "P"
		name = "UPX"
		version = "3.91 [LZMA]"
		source = "Made by RetDec Team"
		pattern = "FF4F2DE920308FE20700B3E8100C93E80290A0E10D0000EB0400A0E3010000EBFF4FBDE820F09FE514F09FE500?00?00????0?0000100100????0?00000000000000000000000000000000000010010000402DE93C708FE2780097E80D70A0E10D4084E0"
	strings:
		$1 = { FF 4F 2D E9 20 30 8F E2 07 00 B3 E8 10 0C 93 E8 02 90 A0 E1 0D 00 00 EB 04 00 A0 E3 01 00 00 EB FF 4F BD E8 20 F0 9F E5 14 F0 9F E5 00 ?0 0? 00 ?? ?? 0? 00 00 10 01 00 ?? ?? 0? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 01 00 00 40 2D E9 3C 70 8F E2 78 00 97 E8 0D 70 A0 E1 0D 40 84 E0 }
	condition:
		$1 at pe.entry_point
}

rule upx_39x_lzma
{
	meta:
    tool = "P"
		name = "UPX"
		version = "3.9x [LZMA]"
		source = "Made by RetDec Team"
		pattern = "FF4F2DE920308FE20700B3E8100E93E80290A0E10D0000EB0400A0E3010000EBFF4FBDE820F09FE50CF09FE500?00?00????0?0000100100????0?00000000000000000000000000000000000010010000402DE93C708FE2780097E80D70A0E10D4084E0"
	strings:
		$1 = { FF 4F 2D E9 20 30 8F E2 07 00 B3 E8 10 0E 93 E8 02 90 A0 E1 0D 00 00 EB 04 00 A0 E3 01 00 00 EB FF 4F BD E8 20 F0 9F E5 0C F0 9F E5 00 ?0 0? 00 ?? ?? 0? 00 00 10 01 00 ?? ?? 0? 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 01 00 00 40 2D E9 3C 70 8F E2 78 00 97 E8 0D 70 A0 E1 0D 40 84 E0 }
	condition:
		$1 at pe.entry_point
}

rule upx_39x_nrv2b
{
	meta:
    tool = "P"
		name = "UPX"
		version = "3.9x [NRV2B]"
		source = "Made by RetDec Team"
    start = 376
		pattern = "1A00BDE8010040E0032042E0002084E53080BDE8044094E00EF0A0110140D0E40440A4E0044CB0E10EF0A0E10110A0E30EC0A0E1F6FFFFEB0110B1E0F4FFFFEBFBFFFF3A0CF0A0E10130D0E40130C2E4EFFFFFEBFBFFFF2AF3FFFFEB033051E20010A0E30300003A0150D0E4035485E10550F0E1E1FFFF0AE5FFFFEB0110B1E0E3FFFFEB0110B1E001"
	strings:
		$1 = { 1A 00 BD E8 01 00 40 E0 03 20 42 E0 00 20 84 E5 30 80 BD E8 04 40 94 E0 0E F0 A0 11 01 40 D0 E4 04 40 A4 E0 04 4C B0 E1 0E F0 A0 E1 01 10 A0 E3 0E C0 A0 E1 F6 FF FF EB 01 10 B1 E0 F4 FF FF EB FB FF FF 3A 0C F0 A0 E1 01 30 D0 E4 01 30 C2 E4 EF FF FF EB FB FF FF 2A F3 FF FF EB 03 30 51 E2 00 10 A0 E3 03 00 00 3A 01 50 D0 E4 03 54 85 E1 05 50 F0 E1 E1 FF FF 0A E5 FF FF EB 01 10 B1 E0 E3 FF FF EB 01 10 B1 E0 01 }
	condition:
		$1 at pe.entry_point + 376
}

rule upx_39x_nrv2d
{
  meta:
    tool = "P"
    name = "UPX"
    version = "3.9x [NRV2D]"
    source = "Made by RetDec Team"
    start = 454
		pattern = "B1E0044094E0EEFFFF0B0110B1E0044094E0EBFFFF0BF5FFFF3A033051E20010A0E30500003A0150D0E4035485E10550F0E1DEFFFF0AC550B0E1010000EA044094E0DFFFFF0B0110B1E0044094E0DCFFFF0B0110B1E00700001A0110A0E3044094E0D7FFFF0B0110B1E0044094E0D4FFFF0BF9FFFF3A021081E2011081E2050C75E3011081320030D2E50530D2E70130C2E4"
	strings:
		$1 = { B1 E0 04 40 94 E0 EE FF FF 0B 01 10 B1 E0 04 40 94 E0 EB FF FF 0B F5 FF FF 3A 03 30 51 E2 00 10 A0 E3 05 00 00 3A 01 50 D0 E4 03 54 85 E1 05 50 F0 E1 DE FF FF 0A C5 50 B0 E1 01 00 00 EA 04 40 94 E0 DF FF FF 0B 01 10 B1 E0 04 40 94 E0 DC FF FF 0B 01 10 B1 E0 07 00 00 1A 01 10 A0 E3 04 40 94 E0 D7 FF FF 0B 01 10 B1 E0 04 40 94 E0 D4 FF FF 0B F9 FF FF 3A 02 10 81 E2 01 10 81 E2 05 0C 75 E3 01 10 81 32 00 30 D2 E5 05 30 D2 E7 01 30 C2 E4 }
	condition:
		$1 at pe.entry_point + 454
}

rule upx_39x_nrv2e
{
	meta:
    tool = "P"
		name = "UPX"
		version = "3.9x [NRV2E]"
		source = "Made by RetDec Team"
    start = 454
		pattern = "A1E0044094E0EEFFFF0B0110A1E0044094E0EBFFFF0BF5FFFF3A033051E20010A0E30600003A0150D0E4035485E10550F0E1DEFFFF0AC550B0E10F00002A020000EA044094E0DEFFFF0B0B00002A0110A0E3044094E0DAFFFF0B0700002A044094E0D7FFFF0B0110A1E0044094E0D4FFFF0BF9FFFF3A041081E2030000EA044094E0CFFFFF0B0110A1E0021081E2050C75E3"
	strings:
		$1 = { A1 E0 04 40 94 E0 EE FF FF 0B 01 10 A1 E0 04 40 94 E0 EB FF FF 0B F5 FF FF 3A 03 30 51 E2 00 10 A0 E3 06 00 00 3A 01 50 D0 E4 03 54 85 E1 05 50 F0 E1 DE FF FF 0A C5 50 B0 E1 0F 00 00 2A 02 00 00 EA 04 40 94 E0 DE FF FF 0B 0B 00 00 2A 01 10 A0 E3 04 40 94 E0 DA FF FF 0B 07 00 00 2A 04 40 94 E0 D7 FF FF 0B 01 10 A1 E0 04 40 94 E0 D4 FF FF 0B F9 FF FF 3A 04 10 81 E2 03 00 00 EA 04 40 94 E0 CF FF FF 0B 01 10 A1 E0 02 10 81 E2 05 0C 75 E3 }
	condition:
		$1 at pe.entry_point + 454
}
