/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/s.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/s.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with S.
*/
void initFuncParamNamesMap_S(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("SCardAddReaderToGroupA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardAddReaderToGroupA", 2, "szReaderName"); // LPCSTR
	ADD_PARAM_NAME("SCardAddReaderToGroupA", 3, "szGroupName"); // LPCSTR
	ADD_PARAM_NAME("SCardAddReaderToGroupW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardAddReaderToGroupW", 2, "szReaderName"); // LPCWSTR
	ADD_PARAM_NAME("SCardAddReaderToGroupW", 3, "szGroupName"); // LPCWSTR
	ADD_PARAM_NAME("SCardBeginTransaction", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardCancel", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardCancelTransaction", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardConnectA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardConnectA", 2, "szReader"); // LPCSTR
	ADD_PARAM_NAME("SCardConnectA", 3, "dwShareMode"); // DWORD
	ADD_PARAM_NAME("SCardConnectA", 4, "dwPreferredProtocols"); // DWORD
	ADD_PARAM_NAME("SCardConnectA", 5, "phCard"); // LPSCARDHANDLE
	ADD_PARAM_NAME("SCardConnectA", 6, "pdwActiveProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardConnectW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardConnectW", 2, "szReader"); // LPCWSTR
	ADD_PARAM_NAME("SCardConnectW", 3, "dwShareMode"); // DWORD
	ADD_PARAM_NAME("SCardConnectW", 4, "dwPreferredProtocols"); // DWORD
	ADD_PARAM_NAME("SCardConnectW", 5, "phCard"); // LPSCARDHANDLE
	ADD_PARAM_NAME("SCardConnectW", 6, "pdwActiveProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardControl", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardControl", 2, "dwControlCode"); // DWORD
	ADD_PARAM_NAME("SCardControl", 3, "lpInBuffer"); // LPCVOID
	ADD_PARAM_NAME("SCardControl", 4, "nInBufferSize"); // DWORD
	ADD_PARAM_NAME("SCardControl", 5, "lpOutBuffer"); // LPVOID
	ADD_PARAM_NAME("SCardControl", 6, "nOutBufferSize"); // DWORD
	ADD_PARAM_NAME("SCardControl", 7, "lpBytesReturned"); // LPDWORD
	ADD_PARAM_NAME("SCardDisconnect", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardDisconnect", 2, "dwDisposition"); // DWORD
	ADD_PARAM_NAME("SCardEndTransaction", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardEndTransaction", 2, "dwDisposition"); // DWORD
	ADD_PARAM_NAME("SCardEstablishContext", 1, "dwScope"); // DWORD
	ADD_PARAM_NAME("SCardEstablishContext", 2, "pvReserved1"); // LPCVOID
	ADD_PARAM_NAME("SCardEstablishContext", 3, "pvReserved2"); // LPCVOID
	ADD_PARAM_NAME("SCardEstablishContext", 4, "phContext"); // LPSCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetCardTypeA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetCardTypeA", 2, "szCardName"); // LPCSTR
	ADD_PARAM_NAME("SCardForgetCardTypeW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetCardTypeW", 2, "szCardName"); // LPCWSTR
	ADD_PARAM_NAME("SCardForgetReaderA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetReaderA", 2, "szReaderName"); // LPCSTR
	ADD_PARAM_NAME("SCardForgetReaderGroupA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetReaderGroupA", 2, "szGroupName"); // LPCSTR
	ADD_PARAM_NAME("SCardForgetReaderGroupW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetReaderGroupW", 2, "szGroupName"); // LPCWSTR
	ADD_PARAM_NAME("SCardForgetReaderW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardForgetReaderW", 2, "szReaderName"); // LPCWSTR
	ADD_PARAM_NAME("SCardFreeMemory", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardFreeMemory", 2, "pvMem"); // LPCVOID
	ADD_PARAM_NAME("SCardGetAttrib", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardGetAttrib", 2, "dwAttrId"); // DWORD
	ADD_PARAM_NAME("SCardGetAttrib", 3, "pbAttr"); // LPBYTE
	ADD_PARAM_NAME("SCardGetAttrib", 4, "pcbAttrLen"); // LPDWORD
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameA", 2, "szCardName"); // LPCSTR
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameA", 3, "dwProviderId"); // DWORD
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameA", 4, "szProvider"); // LPSTR
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameA", 5, "pcchProvider"); // LPDWORD
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameW", 2, "szCardName"); // LPCWSTR
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameW", 3, "dwProviderId"); // DWORD
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameW", 4, "szProvider"); // LPWSTR
	ADD_PARAM_NAME("SCardGetCardTypeProviderNameW", 5, "pcchProvider"); // LPDWORD
	ADD_PARAM_NAME("SCardGetProviderIdA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetProviderIdA", 2, "szCard"); // LPCSTR
	ADD_PARAM_NAME("SCardGetProviderIdA", 3, "pguidProviderId"); // LPGUID
	ADD_PARAM_NAME("SCardGetProviderIdW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetProviderIdW", 2, "szCard"); // LPCWSTR
	ADD_PARAM_NAME("SCardGetProviderIdW", 3, "pguidProviderId"); // LPGUID
	ADD_PARAM_NAME("SCardGetStatusChangeA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetStatusChangeA", 2, "dwTimeout"); // DWORD
	ADD_PARAM_NAME("SCardGetStatusChangeA", 3, "rgReaderStates"); // LPSCARD_READERSTATEA
	ADD_PARAM_NAME("SCardGetStatusChangeA", 4, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardGetStatusChangeW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardGetStatusChangeW", 2, "dwTimeout"); // DWORD
	ADD_PARAM_NAME("SCardGetStatusChangeW", 3, "rgReaderStates"); // LPSCARD_READERSTATEW
	ADD_PARAM_NAME("SCardGetStatusChangeW", 4, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardGetTransmitCount", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardGetTransmitCount", 2, "pcTransmitCount"); // LPDWORD
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 2, "szCardName"); // LPCSTR
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 3, "pguidPrimaryProvider"); // LPCGUID
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 4, "rgguidInterfaces"); // LPCGUID
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 5, "dwInterfaceCount"); // DWORD
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 6, "pbAtr"); // LPCBYTE
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 7, "pbAtrMask"); // LPCBYTE
	ADD_PARAM_NAME("SCardIntroduceCardTypeA", 8, "cbAtrLen"); // DWORD
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 2, "szCardName"); // LPCWSTR
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 3, "pguidPrimaryProvider"); // LPCGUID
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 4, "rgguidInterfaces"); // LPCGUID
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 5, "dwInterfaceCount"); // DWORD
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 6, "pbAtr"); // LPCBYTE
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 7, "pbAtrMask"); // LPCBYTE
	ADD_PARAM_NAME("SCardIntroduceCardTypeW", 8, "cbAtrLen"); // DWORD
	ADD_PARAM_NAME("SCardIntroduceReaderA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceReaderA", 2, "szReaderName"); // LPCSTR
	ADD_PARAM_NAME("SCardIntroduceReaderA", 3, "szDeviceName"); // LPCSTR
	ADD_PARAM_NAME("SCardIntroduceReaderGroupA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceReaderGroupA", 2, "szGroupName"); // LPCSTR
	ADD_PARAM_NAME("SCardIntroduceReaderGroupW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceReaderGroupW", 2, "szGroupName"); // LPCWSTR
	ADD_PARAM_NAME("SCardIntroduceReaderW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardIntroduceReaderW", 2, "szReaderName"); // LPCWSTR
	ADD_PARAM_NAME("SCardIntroduceReaderW", 3, "szDeviceName"); // LPCWSTR
	ADD_PARAM_NAME("SCardIsValidContext", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListCardsA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListCardsA", 2, "pbAtr"); // LPCBYTE
	ADD_PARAM_NAME("SCardListCardsA", 3, "rgquidInterfaces"); // LPCGUID
	ADD_PARAM_NAME("SCardListCardsA", 4, "cguidInterfaceCount"); // DWORD
	ADD_PARAM_NAME("SCardListCardsA", 5, "mszCards"); // LPSTR
	ADD_PARAM_NAME("SCardListCardsA", 6, "pcchCards"); // LPDWORD
	ADD_PARAM_NAME("SCardListCardsW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListCardsW", 2, "pbAtr"); // LPCBYTE
	ADD_PARAM_NAME("SCardListCardsW", 3, "rgquidInterfaces"); // LPCGUID
	ADD_PARAM_NAME("SCardListCardsW", 4, "cguidInterfaceCount"); // DWORD
	ADD_PARAM_NAME("SCardListCardsW", 5, "mszCards"); // LPWSTR
	ADD_PARAM_NAME("SCardListCardsW", 6, "pcchCards"); // LPDWORD
	ADD_PARAM_NAME("SCardListInterfacesA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListInterfacesA", 2, "szCard"); // LPCSTR
	ADD_PARAM_NAME("SCardListInterfacesA", 3, "pguidInterfaces"); // LPGUID
	ADD_PARAM_NAME("SCardListInterfacesA", 4, "pcguidInterfaces"); // LPDWORD
	ADD_PARAM_NAME("SCardListInterfacesW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListInterfacesW", 2, "szCard"); // LPCWSTR
	ADD_PARAM_NAME("SCardListInterfacesW", 3, "pguidInterfaces"); // LPGUID
	ADD_PARAM_NAME("SCardListInterfacesW", 4, "pcguidInterfaces"); // LPDWORD
	ADD_PARAM_NAME("SCardListReaderGroupsA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListReaderGroupsA", 2, "mszGroups"); // LPSTR
	ADD_PARAM_NAME("SCardListReaderGroupsA", 3, "pcchGroups"); // LPDWORD
	ADD_PARAM_NAME("SCardListReaderGroupsW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListReaderGroupsW", 2, "mszGroups"); // LPWSTR
	ADD_PARAM_NAME("SCardListReaderGroupsW", 3, "pcchGroups"); // LPDWORD
	ADD_PARAM_NAME("SCardListReadersA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListReadersA", 2, "mszGroups"); // LPCSTR
	ADD_PARAM_NAME("SCardListReadersA", 3, "mszReaders"); // LPSTR
	ADD_PARAM_NAME("SCardListReadersA", 4, "pcchReaders"); // LPDWORD
	ADD_PARAM_NAME("SCardListReadersW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardListReadersW", 2, "mszGroups"); // LPCWSTR
	ADD_PARAM_NAME("SCardListReadersW", 3, "mszReaders"); // LPWSTR
	ADD_PARAM_NAME("SCardListReadersW", 4, "pcchReaders"); // LPDWORD
	ADD_PARAM_NAME("SCardLocateCardsA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardLocateCardsA", 2, "mszCards"); // LPCSTR
	ADD_PARAM_NAME("SCardLocateCardsA", 3, "rgReaderStates"); // LPSCARD_READERSTATEA
	ADD_PARAM_NAME("SCardLocateCardsA", 4, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardLocateCardsByATRA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardLocateCardsByATRA", 2, "rgAtrMasks"); // LPSCARD_ATRMASK
	ADD_PARAM_NAME("SCardLocateCardsByATRA", 3, "cAtrs"); // DWORD
	ADD_PARAM_NAME("SCardLocateCardsByATRA", 4, "rgReaderStates"); // LPSCARD_READERSTATEA
	ADD_PARAM_NAME("SCardLocateCardsByATRA", 5, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardLocateCardsByATRW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardLocateCardsByATRW", 2, "rgAtrMasks"); // LPSCARD_ATRMASK
	ADD_PARAM_NAME("SCardLocateCardsByATRW", 3, "cAtrs"); // DWORD
	ADD_PARAM_NAME("SCardLocateCardsByATRW", 4, "rgReaderStates"); // LPSCARD_READERSTATEW
	ADD_PARAM_NAME("SCardLocateCardsByATRW", 5, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardLocateCardsW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardLocateCardsW", 2, "mszCards"); // LPCWSTR
	ADD_PARAM_NAME("SCardLocateCardsW", 3, "rgReaderStates"); // LPSCARD_READERSTATEW
	ADD_PARAM_NAME("SCardLocateCardsW", 4, "cReaders"); // DWORD
	ADD_PARAM_NAME("SCardReadCacheA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardReadCacheA", 2, "CardIdentifier"); // UUID *
	ADD_PARAM_NAME("SCardReadCacheA", 3, "FreshnessCounter"); // DWORD
	ADD_PARAM_NAME("SCardReadCacheA", 4, "LookupName"); // LPSTR
	ADD_PARAM_NAME("SCardReadCacheA", 5, "Data"); // PBYTE
	ADD_PARAM_NAME("SCardReadCacheA", 6, "DataLen"); // DWORD *
	ADD_PARAM_NAME("SCardReadCacheW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardReadCacheW", 2, "CardIdentifier"); // UUID *
	ADD_PARAM_NAME("SCardReadCacheW", 3, "FreshnessCounter"); // DWORD
	ADD_PARAM_NAME("SCardReadCacheW", 4, "LookupName"); // LPWSTR
	ADD_PARAM_NAME("SCardReadCacheW", 5, "Data"); // PBYTE
	ADD_PARAM_NAME("SCardReadCacheW", 6, "DataLen"); // DWORD *
	ADD_PARAM_NAME("SCardReconnect", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardReconnect", 2, "dwShareMode"); // DWORD
	ADD_PARAM_NAME("SCardReconnect", 3, "dwPreferredProtocols"); // DWORD
	ADD_PARAM_NAME("SCardReconnect", 4, "dwInitialization"); // DWORD
	ADD_PARAM_NAME("SCardReconnect", 5, "pdwActiveProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardReleaseContext", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupA", 2, "szReaderName"); // LPCSTR
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupA", 3, "szGroupName"); // LPCSTR
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupW", 2, "szReaderName"); // LPCWSTR
	ADD_PARAM_NAME("SCardRemoveReaderFromGroupW", 3, "szGroupName"); // LPCWSTR
	ADD_PARAM_NAME("SCardSetAttrib", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardSetAttrib", 2, "dwAttrId"); // DWORD
	ADD_PARAM_NAME("SCardSetAttrib", 3, "pbAttr"); // LPCBYTE
	ADD_PARAM_NAME("SCardSetAttrib", 4, "cbAttrLen"); // DWORD
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameA", 2, "szCardName"); // LPCSTR
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameA", 3, "dwProviderId"); // DWORD
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameA", 4, "szProvider"); // LPCSTR
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameW", 2, "szCardName"); // LPCWSTR
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameW", 3, "dwProviderId"); // DWORD
	ADD_PARAM_NAME("SCardSetCardTypeProviderNameW", 4, "szProvider"); // LPCWSTR
	ADD_PARAM_NAME("SCardState", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardState", 2, "pdwState"); // LPDWORD
	ADD_PARAM_NAME("SCardState", 3, "pdwProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardState", 4, "pbAtr"); // LPBYTE
	ADD_PARAM_NAME("SCardState", 5, "pcbAtrLen"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusA", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardStatusA", 2, "szReaderName"); // LPSTR
	ADD_PARAM_NAME("SCardStatusA", 3, "pcchReaderLen"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusA", 4, "pdwState"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusA", 5, "pdwProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusA", 6, "pbAtr"); // LPBYTE
	ADD_PARAM_NAME("SCardStatusA", 7, "pcbAtrLen"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusW", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardStatusW", 2, "szReaderName"); // LPWSTR
	ADD_PARAM_NAME("SCardStatusW", 3, "pcchReaderLen"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusW", 4, "pdwState"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusW", 5, "pdwProtocol"); // LPDWORD
	ADD_PARAM_NAME("SCardStatusW", 6, "pbAtr"); // LPBYTE
	ADD_PARAM_NAME("SCardStatusW", 7, "pcbAtrLen"); // LPDWORD
	ADD_PARAM_NAME("SCardTransmit", 1, "hCard"); // SCARDHANDLE
	ADD_PARAM_NAME("SCardTransmit", 2, "pioSendPci"); // LPCSCARD_IO_REQUEST
	ADD_PARAM_NAME("SCardTransmit", 3, "pbSendBuffer"); // LPCBYTE
	ADD_PARAM_NAME("SCardTransmit", 4, "cbSendLength"); // DWORD
	ADD_PARAM_NAME("SCardTransmit", 5, "pioRecvPci"); // LPSCARD_IO_REQUEST
	ADD_PARAM_NAME("SCardTransmit", 6, "pbRecvBuffer"); // LPBYTE
	ADD_PARAM_NAME("SCardTransmit", 7, "pcbRecvLength"); // LPDWORD
	ADD_PARAM_NAME("SCardUIDlgSelectCardA", 1, "pDlgStruc"); // LPOPENCARDNAMEA_EX
	ADD_PARAM_NAME("SCardUIDlgSelectCardW", 1, "pDlgStruc"); // LPOPENCARDNAMEW_EX
	ADD_PARAM_NAME("SCardWriteCacheA", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardWriteCacheA", 2, "CardIdentifier"); // UUID *
	ADD_PARAM_NAME("SCardWriteCacheA", 3, "FreshnessCounter"); // DWORD
	ADD_PARAM_NAME("SCardWriteCacheA", 4, "LookupName"); // LPSTR
	ADD_PARAM_NAME("SCardWriteCacheA", 5, "Data"); // PBYTE
	ADD_PARAM_NAME("SCardWriteCacheA", 6, "DataLen"); // DWORD
	ADD_PARAM_NAME("SCardWriteCacheW", 1, "hContext"); // SCARDCONTEXT
	ADD_PARAM_NAME("SCardWriteCacheW", 2, "CardIdentifier"); // UUID *
	ADD_PARAM_NAME("SCardWriteCacheW", 3, "FreshnessCounter"); // DWORD
	ADD_PARAM_NAME("SCardWriteCacheW", 4, "LookupName"); // LPWSTR
	ADD_PARAM_NAME("SCardWriteCacheW", 5, "Data"); // PBYTE
	ADD_PARAM_NAME("SCardWriteCacheW", 6, "DataLen"); // DWORD
	ADD_PARAM_NAME("SaferCloseLevel", 1, "hLevelHandle"); // SAFER_LEVEL_HANDLE
	ADD_PARAM_NAME("SaferComputeTokenFromLevel", 1, "LevelHandle"); // SAFER_LEVEL_HANDLE
	ADD_PARAM_NAME("SaferComputeTokenFromLevel", 2, "InAccessToken"); // HANDLE
	ADD_PARAM_NAME("SaferComputeTokenFromLevel", 3, "OutAccessToken"); // PHANDLE
	ADD_PARAM_NAME("SaferComputeTokenFromLevel", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SaferComputeTokenFromLevel", 5, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferCreateLevel", 1, "dwScopeId"); // DWORD
	ADD_PARAM_NAME("SaferCreateLevel", 2, "dwLevelId"); // DWORD
	ADD_PARAM_NAME("SaferCreateLevel", 3, "OpenFlags"); // DWORD
	ADD_PARAM_NAME("SaferCreateLevel", 4, "pLevelHandle"); // SAFER_LEVEL_HANDLE *
	ADD_PARAM_NAME("SaferCreateLevel", 5, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferGetLevelInformation", 1, "LevelHandle"); // SAFER_LEVEL_HANDLE
	ADD_PARAM_NAME("SaferGetLevelInformation", 2, "dwInfoType"); // SAFER_OBJECT_INFO_CLASS
	ADD_PARAM_NAME("SaferGetLevelInformation", 3, "lpQueryBuffer"); // LPVOID
	ADD_PARAM_NAME("SaferGetLevelInformation", 4, "dwInBufferSize"); // DWORD
	ADD_PARAM_NAME("SaferGetLevelInformation", 5, "lpdwOutBufferSize"); // LPDWORD
	ADD_PARAM_NAME("SaferGetPolicyInformation", 1, "dwScopeId"); // DWORD
	ADD_PARAM_NAME("SaferGetPolicyInformation", 2, "SaferPolicyInfoClass"); // SAFER_POLICY_INFO_CLASS
	ADD_PARAM_NAME("SaferGetPolicyInformation", 3, "InfoBufferSize"); // DWORD
	ADD_PARAM_NAME("SaferGetPolicyInformation", 4, "InfoBuffer"); // PVOID
	ADD_PARAM_NAME("SaferGetPolicyInformation", 5, "InfoBufferRetSize"); // PDWORD
	ADD_PARAM_NAME("SaferGetPolicyInformation", 6, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferIdentifyLevel", 1, "dwNumProperties"); // DWORD
	ADD_PARAM_NAME("SaferIdentifyLevel", 2, "pCodeProperties"); // PSAFER_CODE_PROPERTIES
	ADD_PARAM_NAME("SaferIdentifyLevel", 3, "pLevelHandle"); // SAFER_LEVEL_HANDLE *
	ADD_PARAM_NAME("SaferIdentifyLevel", 4, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferRecordEventLogEntry", 1, "hLevel"); // SAFER_LEVEL_HANDLE
	ADD_PARAM_NAME("SaferRecordEventLogEntry", 2, "szTargetPath"); // LPCWSTR
	ADD_PARAM_NAME("SaferRecordEventLogEntry", 3, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferSetLevelInformation", 1, "LevelHandle"); // SAFER_LEVEL_HANDLE
	ADD_PARAM_NAME("SaferSetLevelInformation", 2, "dwInfoType"); // SAFER_OBJECT_INFO_CLASS
	ADD_PARAM_NAME("SaferSetLevelInformation", 3, "lpQueryBuffer"); // LPVOID
	ADD_PARAM_NAME("SaferSetLevelInformation", 4, "dwInBufferSize"); // DWORD
	ADD_PARAM_NAME("SaferSetPolicyInformation", 1, "dwScopeId"); // DWORD
	ADD_PARAM_NAME("SaferSetPolicyInformation", 2, "SaferPolicyInfoClass"); // SAFER_POLICY_INFO_CLASS
	ADD_PARAM_NAME("SaferSetPolicyInformation", 3, "InfoBufferSize"); // DWORD
	ADD_PARAM_NAME("SaferSetPolicyInformation", 4, "InfoBuffer"); // PVOID
	ADD_PARAM_NAME("SaferSetPolicyInformation", 5, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("SaferiIsExecutableFileType", 1, "szFullPathname"); // LPCWSTR
	ADD_PARAM_NAME("SaferiIsExecutableFileType", 2, "bFromShellExecute"); // BOOLEAN
	ADD_PARAM_NAME("SaveDC", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ScaleViewportExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ScaleViewportExtEx", 2, "xn"); // int
	ADD_PARAM_NAME("ScaleViewportExtEx", 3, "dx"); // int
	ADD_PARAM_NAME("ScaleViewportExtEx", 4, "yn"); // int
	ADD_PARAM_NAME("ScaleViewportExtEx", 5, "yd"); // int
	ADD_PARAM_NAME("ScaleViewportExtEx", 6, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("ScaleWindowExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ScaleWindowExtEx", 2, "xn"); // int
	ADD_PARAM_NAME("ScaleWindowExtEx", 3, "xd"); // int
	ADD_PARAM_NAME("ScaleWindowExtEx", 4, "yn"); // int
	ADD_PARAM_NAME("ScaleWindowExtEx", 5, "yd"); // int
	ADD_PARAM_NAME("ScaleWindowExtEx", 6, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("ScheduleJob", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("ScheduleJob", 2, "JobId"); // DWORD
	ADD_PARAM_NAME("ScreenToClient", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ScreenToClient", 2, "lpPoint"); // LPPOINT
	ADD_PARAM_NAME("ScrollConsoleScreenBufferA", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ScrollConsoleScreenBufferA", 2, "lpScrollRectangle"); // CONST SMALL_RECT *
	ADD_PARAM_NAME("ScrollConsoleScreenBufferA", 3, "lpClipRectangle"); // CONST SMALL_RECT *
	ADD_PARAM_NAME("ScrollConsoleScreenBufferA", 4, "dwDestinationOrigin"); // COORD
	ADD_PARAM_NAME("ScrollConsoleScreenBufferA", 5, "lpFill"); // CONST CHAR_INFO *
	ADD_PARAM_NAME("ScrollConsoleScreenBufferW", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("ScrollConsoleScreenBufferW", 2, "lpScrollRectangle"); // CONST SMALL_RECT *
	ADD_PARAM_NAME("ScrollConsoleScreenBufferW", 3, "lpClipRectangle"); // CONST SMALL_RECT *
	ADD_PARAM_NAME("ScrollConsoleScreenBufferW", 4, "dwDestinationOrigin"); // COORD
	ADD_PARAM_NAME("ScrollConsoleScreenBufferW", 5, "lpFill"); // CONST CHAR_INFO *
	ADD_PARAM_NAME("ScrollDC", 1, "hDC"); // HDC
	ADD_PARAM_NAME("ScrollDC", 2, "dx"); // int
	ADD_PARAM_NAME("ScrollDC", 3, "dy"); // int
	ADD_PARAM_NAME("ScrollDC", 4, "lprcScroll"); // CONST RECT *
	ADD_PARAM_NAME("ScrollDC", 5, "lprcClip"); // CONST RECT *
	ADD_PARAM_NAME("ScrollDC", 6, "hrgnUpdate"); // HRGN
	ADD_PARAM_NAME("ScrollDC", 7, "lprcUpdate"); // LPRECT
	ADD_PARAM_NAME("ScrollWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ScrollWindow", 2, "XAmount"); // int
	ADD_PARAM_NAME("ScrollWindow", 3, "YAmount"); // int
	ADD_PARAM_NAME("ScrollWindow", 4, "lpRect"); // CONST RECT *
	ADD_PARAM_NAME("ScrollWindow", 5, "lpClipRect"); // CONST RECT *
	ADD_PARAM_NAME("ScrollWindowEx", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ScrollWindowEx", 2, "dx"); // int
	ADD_PARAM_NAME("ScrollWindowEx", 3, "dy"); // int
	ADD_PARAM_NAME("ScrollWindowEx", 4, "prcScroll"); // CONST RECT *
	ADD_PARAM_NAME("ScrollWindowEx", 5, "prcClip"); // CONST RECT *
	ADD_PARAM_NAME("ScrollWindowEx", 6, "hrgnUpdate"); // HRGN
	ADD_PARAM_NAME("ScrollWindowEx", 7, "prcUpdate"); // LPRECT
	ADD_PARAM_NAME("ScrollWindowEx", 8, "flags"); // UINT
	ADD_PARAM_NAME("SearchPathA", 1, "lpPath"); // LPCSTR
	ADD_PARAM_NAME("SearchPathA", 2, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("SearchPathA", 3, "lpExtension"); // LPCSTR
	ADD_PARAM_NAME("SearchPathA", 4, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("SearchPathA", 5, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("SearchPathA", 6, "lpFilePart"); // LPSTR *
	ADD_PARAM_NAME("SearchPathW", 1, "lpPath"); // LPCWSTR
	ADD_PARAM_NAME("SearchPathW", 2, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("SearchPathW", 3, "lpExtension"); // LPCWSTR
	ADD_PARAM_NAME("SearchPathW", 4, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("SearchPathW", 5, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("SearchPathW", 6, "lpFilePart"); // LPWSTR *
	ADD_PARAM_NAME("SelectClipPath", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SelectClipPath", 2, "mode"); // int
	ADD_PARAM_NAME("SelectClipRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SelectClipRgn", 2, "hrgn"); // HRGN
	ADD_PARAM_NAME("SelectObject", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SelectObject", 2, "h"); // HGDIOBJ
	ADD_PARAM_NAME("SelectPalette", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SelectPalette", 2, "hPal"); // HPALETTE
	ADD_PARAM_NAME("SelectPalette", 3, "bForceBkgd"); // WINBOOL
	ADD_PARAM_NAME("SendDlgItemMessageA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("SendDlgItemMessageA", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("SendDlgItemMessageA", 3, "Msg"); // UINT
	ADD_PARAM_NAME("SendDlgItemMessageA", 4, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendDlgItemMessageA", 5, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendDlgItemMessageW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("SendDlgItemMessageW", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("SendDlgItemMessageW", 3, "Msg"); // UINT
	ADD_PARAM_NAME("SendDlgItemMessageW", 4, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendDlgItemMessageW", 5, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendInput", 1, "cInputs"); // UINT
	ADD_PARAM_NAME("SendInput", 2, "pInputs"); // LPINPUT
	ADD_PARAM_NAME("SendInput", 3, "cbSize"); // int
	ADD_PARAM_NAME("SendMessageA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendMessageCallbackA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageCallbackA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageCallbackA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageCallbackA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendMessageCallbackA", 5, "lpResultCallBack"); // SENDASYNCPROC
	ADD_PARAM_NAME("SendMessageCallbackA", 6, "dwData"); // ULONG_PTR
	ADD_PARAM_NAME("SendMessageCallbackW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageCallbackW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageCallbackW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageCallbackW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendMessageCallbackW", 5, "lpResultCallBack"); // SENDASYNCPROC
	ADD_PARAM_NAME("SendMessageCallbackW", 6, "dwData"); // ULONG_PTR
	ADD_PARAM_NAME("SendMessageTimeoutA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageTimeoutA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageTimeoutA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendMessageTimeoutA", 5, "fuFlags"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutA", 6, "uTimeout"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutA", 7, "lpdwResult"); // PDWORD_PTR
	ADD_PARAM_NAME("SendMessageTimeoutW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageTimeoutW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageTimeoutW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendMessageTimeoutW", 5, "fuFlags"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutW", 6, "uTimeout"); // UINT
	ADD_PARAM_NAME("SendMessageTimeoutW", 7, "lpdwResult"); // PDWORD_PTR
	ADD_PARAM_NAME("SendMessageW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendMessageW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendMessageW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendMessageW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendNotifyMessageA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendNotifyMessageA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendNotifyMessageA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendNotifyMessageA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SendNotifyMessageW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SendNotifyMessageW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("SendNotifyMessageW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("SendNotifyMessageW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("SetAbortProc", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetAbortProc", 2, "lpProc"); // ABORTPROC
	ADD_PARAM_NAME("SetAclInformation", 1, "pAcl"); // PACL
	ADD_PARAM_NAME("SetAclInformation", 2, "pAclInformation"); // LPVOID
	ADD_PARAM_NAME("SetAclInformation", 3, "nAclInformationLength"); // DWORD
	ADD_PARAM_NAME("SetAclInformation", 4, "dwAclInformationClass"); // ACL_INFORMATION_CLASS
	ADD_PARAM_NAME("SetActiveWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetArcDirection", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetArcDirection", 2, "dir"); // int
	ADD_PARAM_NAME("SetBitmapBits", 1, "hbm"); // HBITMAP
	ADD_PARAM_NAME("SetBitmapBits", 2, "cb"); // DWORD
	ADD_PARAM_NAME("SetBitmapBits", 3, "pvBits"); // CONST VOID *
	ADD_PARAM_NAME("SetBitmapDimensionEx", 1, "hbm"); // HBITMAP
	ADD_PARAM_NAME("SetBitmapDimensionEx", 2, "w"); // int
	ADD_PARAM_NAME("SetBitmapDimensionEx", 3, "h"); // int
	ADD_PARAM_NAME("SetBitmapDimensionEx", 4, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("SetBkColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetBkColor", 2, "color"); // COLORREF
	ADD_PARAM_NAME("SetBkMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetBkMode", 2, "mode"); // int
	ADD_PARAM_NAME("SetBoundsRect", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetBoundsRect", 2, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("SetBoundsRect", 3, "flags"); // UINT
	ADD_PARAM_NAME("SetBrushOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetBrushOrgEx", 2, "x"); // int
	ADD_PARAM_NAME("SetBrushOrgEx", 3, "y"); // int
	ADD_PARAM_NAME("SetBrushOrgEx", 4, "lppt"); // LPPOINT
	ADD_PARAM_NAME("SetCalendarInfoA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("SetCalendarInfoA", 2, "Calendar"); // CALID
	ADD_PARAM_NAME("SetCalendarInfoA", 3, "CalType"); // CALTYPE
	ADD_PARAM_NAME("SetCalendarInfoA", 4, "lpCalData"); // LPCSTR
	ADD_PARAM_NAME("SetCalendarInfoW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("SetCalendarInfoW", 2, "Calendar"); // CALID
	ADD_PARAM_NAME("SetCalendarInfoW", 3, "CalType"); // CALTYPE
	ADD_PARAM_NAME("SetCalendarInfoW", 4, "lpCalData"); // LPCWSTR
	ADD_PARAM_NAME("SetCapture", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetCaretBlinkTime", 1, "uMSeconds"); // UINT
	ADD_PARAM_NAME("SetCaretPos", 1, "X"); // int
	ADD_PARAM_NAME("SetCaretPos", 2, "Y"); // int
	ADD_PARAM_NAME("SetClassLongA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetClassLongA", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetClassLongA", 3, "dwNewLong"); // LONG
	ADD_PARAM_NAME("SetClassLongPtrA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetClassLongPtrA", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetClassLongPtrA", 3, "dwNewLong"); // LONG_PTR
	ADD_PARAM_NAME("SetClassLongPtrW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetClassLongPtrW", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetClassLongPtrW", 3, "dwNewLong"); // LONG_PTR
	ADD_PARAM_NAME("SetClassLongW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetClassLongW", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetClassLongW", 3, "dwNewLong"); // LONG
	ADD_PARAM_NAME("SetClassWord", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetClassWord", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetClassWord", 3, "wNewWord"); // WORD
	ADD_PARAM_NAME("SetClipboardData", 1, "uFormat"); // UINT
	ADD_PARAM_NAME("SetClipboardData", 2, "hMem"); // HANDLE
	ADD_PARAM_NAME("SetClipboardViewer", 1, "hWndNewViewer"); // HWND
	ADD_PARAM_NAME("SetColorAdjustment", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetColorAdjustment", 2, "lpca"); // CONST COLORADJUSTMENT *
	ADD_PARAM_NAME("SetColorSpace", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetColorSpace", 2, "hcs"); // HCOLORSPACE
	ADD_PARAM_NAME("SetCommBreak", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetCommConfig", 1, "hCommDev"); // HANDLE
	ADD_PARAM_NAME("SetCommConfig", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("SetCommConfig", 3, "dwSize"); // DWORD
	ADD_PARAM_NAME("SetCommMask", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetCommMask", 2, "dwEvtMask"); // DWORD
	ADD_PARAM_NAME("SetCommState", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetCommState", 2, "lpDCB"); // LPDCB
	ADD_PARAM_NAME("SetCommTimeouts", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetCommTimeouts", 2, "lpCommTimeouts"); // LPCOMMTIMEOUTS
	ADD_PARAM_NAME("SetComputerNameA", 1, "lpComputerName"); // LPCSTR
	ADD_PARAM_NAME("SetComputerNameExA", 1, "NameType"); // COMPUTER_NAME_FORMAT
	ADD_PARAM_NAME("SetComputerNameExA", 2, "lpBuffer"); // LPCSTR
	ADD_PARAM_NAME("SetComputerNameExW", 1, "NameType"); // COMPUTER_NAME_FORMAT
	ADD_PARAM_NAME("SetComputerNameExW", 2, "lpBuffer"); // LPCWSTR
	ADD_PARAM_NAME("SetComputerNameW", 1, "lpComputerName"); // LPCWSTR
	ADD_PARAM_NAME("SetConsoleActiveScreenBuffer", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleCP", 1, "wCodePageID"); // UINT
	ADD_PARAM_NAME("SetConsoleCtrlHandler", 1, "HandlerRoutine"); // PHANDLER_ROUTINE
	ADD_PARAM_NAME("SetConsoleCtrlHandler", 2, "Add"); // WINBOOL
	ADD_PARAM_NAME("SetConsoleCursorInfo", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleCursorInfo", 2, "lpConsoleCursorInfo"); // CONST CONSOLE_CURSOR_INFO *
	ADD_PARAM_NAME("SetConsoleCursorPosition", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleCursorPosition", 2, "dwCursorPosition"); // COORD
	ADD_PARAM_NAME("SetConsoleDisplayMode", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleDisplayMode", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetConsoleDisplayMode", 3, "lpNewScreenBufferDimensions"); // PCOORD
	ADD_PARAM_NAME("SetConsoleHistoryInfo", 1, "lpConsoleHistoryInfo"); // PCONSOLE_HISTORY_INFO
	ADD_PARAM_NAME("SetConsoleMode", 1, "hConsoleHandle"); // HANDLE
	ADD_PARAM_NAME("SetConsoleMode", 2, "dwMode"); // DWORD
	ADD_PARAM_NAME("SetConsoleOutputCP", 1, "wCodePageID"); // UINT
	ADD_PARAM_NAME("SetConsoleScreenBufferInfoEx", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleScreenBufferInfoEx", 2, "lpConsoleScreenBufferInfoEx"); // PCONSOLE_SCREEN_BUFFER_INFOEX
	ADD_PARAM_NAME("SetConsoleScreenBufferSize", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleScreenBufferSize", 2, "dwSize"); // COORD
	ADD_PARAM_NAME("SetConsoleTextAttribute", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleTextAttribute", 2, "wAttributes"); // WORD
	ADD_PARAM_NAME("SetConsoleTitleA", 1, "lpConsoleTitle"); // LPCSTR
	ADD_PARAM_NAME("SetConsoleTitleW", 1, "lpConsoleTitle"); // LPCWSTR
	ADD_PARAM_NAME("SetConsoleWindowInfo", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetConsoleWindowInfo", 2, "bAbsolute"); // WINBOOL
	ADD_PARAM_NAME("SetConsoleWindowInfo", 3, "lpConsoleWindow"); // CONST SMALL_RECT *
	ADD_PARAM_NAME("SetCriticalSectionSpinCount", 1, "lpCriticalSection"); // LPCRITICAL_SECTION
	ADD_PARAM_NAME("SetCriticalSectionSpinCount", 2, "dwSpinCount"); // DWORD
	ADD_PARAM_NAME("SetCurrentConsoleFontEx", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("SetCurrentConsoleFontEx", 2, "bMaximumWindow"); // WINBOOL
	ADD_PARAM_NAME("SetCurrentConsoleFontEx", 3, "lpConsoleCurrentFontEx"); // PCONSOLE_FONT_INFOEX
	ADD_PARAM_NAME("SetCurrentDirectoryA", 1, "lpPathName"); // LPCSTR
	ADD_PARAM_NAME("SetCurrentDirectoryW", 1, "lpPathName"); // LPCWSTR
	ADD_PARAM_NAME("SetCursor", 1, "hCursor"); // HCURSOR
	ADD_PARAM_NAME("SetCursorPos", 1, "X"); // int
	ADD_PARAM_NAME("SetCursorPos", 2, "Y"); // int
	ADD_PARAM_NAME("SetDCBrushColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDCBrushColor", 2, "color"); // COLORREF
	ADD_PARAM_NAME("SetDCPenColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDCPenColor", 2, "color"); // COLORREF
	ADD_PARAM_NAME("SetDIBColorTable", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDIBColorTable", 2, "iStart"); // UINT
	ADD_PARAM_NAME("SetDIBColorTable", 3, "cEntries"); // UINT
	ADD_PARAM_NAME("SetDIBColorTable", 4, "prgbq"); // CONST RGBQUAD *
	ADD_PARAM_NAME("SetDIBits", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDIBits", 2, "hbm"); // HBITMAP
	ADD_PARAM_NAME("SetDIBits", 3, "start"); // UINT
	ADD_PARAM_NAME("SetDIBits", 4, "cLines"); // UINT
	ADD_PARAM_NAME("SetDIBits", 5, "lpBits"); // CONST VOID *
	ADD_PARAM_NAME("SetDIBits", 6, "lpbmi"); // CONST BITMAPINFO *
	ADD_PARAM_NAME("SetDIBits", 7, "ColorUse"); // UINT
	ADD_PARAM_NAME("SetDIBitsToDevice", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDIBitsToDevice", 2, "xDest"); // int
	ADD_PARAM_NAME("SetDIBitsToDevice", 3, "yDest"); // int
	ADD_PARAM_NAME("SetDIBitsToDevice", 4, "w"); // DWORD
	ADD_PARAM_NAME("SetDIBitsToDevice", 5, "h"); // DWORD
	ADD_PARAM_NAME("SetDIBitsToDevice", 6, "xSrc"); // int
	ADD_PARAM_NAME("SetDIBitsToDevice", 7, "ySrc"); // int
	ADD_PARAM_NAME("SetDIBitsToDevice", 8, "StartScan"); // UINT
	ADD_PARAM_NAME("SetDIBitsToDevice", 9, "cLines"); // UINT
	ADD_PARAM_NAME("SetDIBitsToDevice", 10, "lpvBits"); // CONST VOID *
	ADD_PARAM_NAME("SetDIBitsToDevice", 11, "lpbmi"); // CONST BITMAPINFO *
	ADD_PARAM_NAME("SetDIBitsToDevice", 12, "ColorUse"); // UINT
	ADD_PARAM_NAME("SetDebugErrorLevel", 1, "dwLevel"); // DWORD
	ADD_PARAM_NAME("SetDefaultCommConfigA", 1, "lpszName"); // LPCSTR
	ADD_PARAM_NAME("SetDefaultCommConfigA", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("SetDefaultCommConfigA", 3, "dwSize"); // DWORD
	ADD_PARAM_NAME("SetDefaultCommConfigW", 1, "lpszName"); // LPCWSTR
	ADD_PARAM_NAME("SetDefaultCommConfigW", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("SetDefaultCommConfigW", 3, "dwSize"); // DWORD
	ADD_PARAM_NAME("SetDefaultPrinterA", 1, "pszPrinter"); // LPCSTR
	ADD_PARAM_NAME("SetDefaultPrinterW", 1, "pszPrinter"); // LPCWSTR
	ADD_PARAM_NAME("SetDeviceGammaRamp", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetDeviceGammaRamp", 2, "lpRamp"); // LPVOID
	ADD_PARAM_NAME("SetDlgItemInt", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("SetDlgItemInt", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("SetDlgItemInt", 3, "uValue"); // UINT
	ADD_PARAM_NAME("SetDlgItemInt", 4, "bSigned"); // WINBOOL
	ADD_PARAM_NAME("SetDlgItemTextA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("SetDlgItemTextA", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("SetDlgItemTextA", 3, "lpString"); // LPCSTR
	ADD_PARAM_NAME("SetDlgItemTextW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("SetDlgItemTextW", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("SetDlgItemTextW", 3, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("SetDllDirectoryA", 1, "lpPathName"); // LPCSTR
	ADD_PARAM_NAME("SetDllDirectoryW", 1, "lpPathName"); // LPCWSTR
	ADD_PARAM_NAME("SetDoubleClickTime", 1, "uInterval"); // UINT
	ADD_PARAM_NAME("SetDynamicTimeZoneInformation", 1, "lpTimeZoneInformation"); // const DYNAMIC_TIME_ZONE_INFORMATION *
	ADD_PARAM_NAME("SetEndOfFile", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetEnhMetaFileBits", 1, "nSize"); // UINT
	ADD_PARAM_NAME("SetEnhMetaFileBits", 2, "pb"); // CONST BYTE *
	ADD_PARAM_NAME("SetEnvironmentStringsA", 1, "NewEnvironment"); // LPCH
	ADD_PARAM_NAME("SetEnvironmentStringsW", 1, "NewEnvironment"); // LPWCH
	ADD_PARAM_NAME("SetEnvironmentVariableA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("SetEnvironmentVariableA", 2, "lpValue"); // LPCSTR
	ADD_PARAM_NAME("SetEnvironmentVariableW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("SetEnvironmentVariableW", 2, "lpValue"); // LPCWSTR
	ADD_PARAM_NAME("SetErrorMode", 1, "uMode"); // UINT
	ADD_PARAM_NAME("SetEvent", 1, "hEvent"); // HANDLE
	ADD_PARAM_NAME("SetEventWhenCallbackReturns", 1, "pci"); // PTP_CALLBACK_INSTANCE
	ADD_PARAM_NAME("SetEventWhenCallbackReturns", 2, "evt"); // HANDLE
	ADD_PARAM_NAME("SetFileAttributesA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("SetFileAttributesA", 2, "dwFileAttributes"); // DWORD
	ADD_PARAM_NAME("SetFileAttributesTransactedA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("SetFileAttributesTransactedA", 2, "dwFileAttributes"); // DWORD
	ADD_PARAM_NAME("SetFileAttributesTransactedA", 3, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("SetFileAttributesTransactedW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("SetFileAttributesTransactedW", 2, "dwFileAttributes"); // DWORD
	ADD_PARAM_NAME("SetFileAttributesTransactedW", 3, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("SetFileAttributesW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("SetFileAttributesW", 2, "dwFileAttributes"); // DWORD
	ADD_PARAM_NAME("SetFileBandwidthReservation", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileBandwidthReservation", 2, "nPeriodMilliseconds"); // DWORD
	ADD_PARAM_NAME("SetFileBandwidthReservation", 3, "nBytesPerPeriod"); // DWORD
	ADD_PARAM_NAME("SetFileBandwidthReservation", 4, "bDiscardable"); // WINBOOL
	ADD_PARAM_NAME("SetFileBandwidthReservation", 5, "lpTransferSize"); // LPDWORD
	ADD_PARAM_NAME("SetFileBandwidthReservation", 6, "lpNumOutstandingRequests"); // LPDWORD
	ADD_PARAM_NAME("SetFileCompletionNotificationModes", 1, "FileHandle"); // HANDLE
	ADD_PARAM_NAME("SetFileCompletionNotificationModes", 2, "Flags"); // UCHAR
	ADD_PARAM_NAME("SetFileInformationByHandle", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileInformationByHandle", 2, "FileInformationClass"); // FILE_INFO_BY_HANDLE_CLASS
	ADD_PARAM_NAME("SetFileInformationByHandle", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("SetFileInformationByHandle", 4, "dwBufferSize"); // DWORD
	ADD_PARAM_NAME("SetFileIoOverlappedRange", 1, "FileHandle"); // HANDLE
	ADD_PARAM_NAME("SetFileIoOverlappedRange", 2, "OverlappedRangeStart"); // PUCHAR
	ADD_PARAM_NAME("SetFileIoOverlappedRange", 3, "Length"); // ULONG
	ADD_PARAM_NAME("SetFilePointer", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFilePointer", 2, "lDistanceToMove"); // LONG
	ADD_PARAM_NAME("SetFilePointer", 3, "lpDistanceToMoveHigh"); // PLONG
	ADD_PARAM_NAME("SetFilePointer", 4, "dwMoveMethod"); // DWORD
	ADD_PARAM_NAME("SetFilePointerEx", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFilePointerEx", 2, "liDistanceToMove"); // LARGE_INTEGER
	ADD_PARAM_NAME("SetFilePointerEx", 3, "lpNewFilePointer"); // PLARGE_INTEGER
	ADD_PARAM_NAME("SetFilePointerEx", 4, "dwMoveMethod"); // DWORD
	ADD_PARAM_NAME("SetFileSecurityA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("SetFileSecurityA", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetFileSecurityA", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetFileSecurityW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("SetFileSecurityW", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetFileSecurityW", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetFileShortNameA", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileShortNameA", 2, "lpShortName"); // LPCSTR
	ADD_PARAM_NAME("SetFileShortNameW", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileShortNameW", 2, "lpShortName"); // LPCWSTR
	ADD_PARAM_NAME("SetFileTime", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileTime", 2, "lpCreationTime"); // CONST FILETIME *
	ADD_PARAM_NAME("SetFileTime", 3, "lpLastAccessTime"); // CONST FILETIME *
	ADD_PARAM_NAME("SetFileTime", 4, "lpLastWriteTime"); // CONST FILETIME *
	ADD_PARAM_NAME("SetFileValidData", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetFileValidData", 2, "ValidDataLength"); // LONGLONG
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableA", 2, "lpGuid"); // LPCSTR
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableA", 3, "pValue"); // PVOID
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableA", 4, "nSize"); // DWORD
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableW", 2, "lpGuid"); // LPCWSTR
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableW", 3, "pValue"); // PVOID
	ADD_PARAM_NAME("SetFirmwareEnvironmentVariableW", 4, "nSize"); // DWORD
	ADD_PARAM_NAME("SetFocus", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetForegroundWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetFormA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetFormA", 2, "pFormName"); // LPSTR
	ADD_PARAM_NAME("SetFormA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("SetFormA", 4, "pForm"); // LPBYTE
	ADD_PARAM_NAME("SetFormW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetFormW", 2, "pFormName"); // LPWSTR
	ADD_PARAM_NAME("SetFormW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("SetFormW", 4, "pForm"); // LPBYTE
	ADD_PARAM_NAME("SetGestureConfig", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetGestureConfig", 2, "dwReserved"); // DWORD
	ADD_PARAM_NAME("SetGestureConfig", 3, "cIDs"); // UINT
	ADD_PARAM_NAME("SetGestureConfig", 4, "pGestureConfig"); // PGESTURECONFIG
	ADD_PARAM_NAME("SetGestureConfig", 5, "cbSize"); // UINT
	ADD_PARAM_NAME("SetGraphicsMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetGraphicsMode", 2, "iMode"); // int
	ADD_PARAM_NAME("SetHandleCount", 1, "uNumber"); // UINT
	ADD_PARAM_NAME("SetHandleInformation", 1, "hObject"); // HANDLE
	ADD_PARAM_NAME("SetHandleInformation", 2, "dwMask"); // DWORD
	ADD_PARAM_NAME("SetHandleInformation", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetICMMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetICMMode", 2, "mode"); // int
	ADD_PARAM_NAME("SetICMProfileA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetICMProfileA", 2, "lpFileName"); // LPSTR
	ADD_PARAM_NAME("SetICMProfileW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetICMProfileW", 2, "lpFileName"); // LPWSTR
	ADD_PARAM_NAME("SetInformationJobObject", 1, "hJob"); // HANDLE
	ADD_PARAM_NAME("SetInformationJobObject", 2, "JobObjectInformationClass"); // JOBOBJECTINFOCLASS
	ADD_PARAM_NAME("SetInformationJobObject", 3, "lpJobObjectInformation"); // LPVOID
	ADD_PARAM_NAME("SetInformationJobObject", 4, "cbJobObjectInformationLength"); // DWORD
	ADD_PARAM_NAME("SetJobA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetJobA", 2, "JobId"); // DWORD
	ADD_PARAM_NAME("SetJobA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("SetJobA", 4, "pJob"); // LPBYTE
	ADD_PARAM_NAME("SetJobA", 5, "Command"); // DWORD
	ADD_PARAM_NAME("SetJobW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetJobW", 2, "JobId"); // DWORD
	ADD_PARAM_NAME("SetJobW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("SetJobW", 4, "pJob"); // LPBYTE
	ADD_PARAM_NAME("SetJobW", 5, "Command"); // DWORD
	ADD_PARAM_NAME("SetKernelObjectSecurity", 1, "Handle"); // HANDLE
	ADD_PARAM_NAME("SetKernelObjectSecurity", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetKernelObjectSecurity", 3, "SecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetKeyboardState", 1, "lpKeyState"); // LPBYTE
	ADD_PARAM_NAME("SetLastError", 1, "dwErrCode"); // DWORD
	ADD_PARAM_NAME("SetLastErrorEx", 1, "dwErrCode"); // DWORD
	ADD_PARAM_NAME("SetLastErrorEx", 2, "dwType"); // DWORD
	ADD_PARAM_NAME("SetLayeredWindowAttributes", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetLayeredWindowAttributes", 2, "crKey"); // COLORREF
	ADD_PARAM_NAME("SetLayeredWindowAttributes", 3, "bAlpha"); // BYTE
	ADD_PARAM_NAME("SetLayeredWindowAttributes", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetLayout", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetLayout", 2, "l"); // DWORD
	ADD_PARAM_NAME("SetLocalTime", 1, "lpSystemTime"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("SetLocaleInfoA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("SetLocaleInfoA", 2, "LCType"); // LCTYPE
	ADD_PARAM_NAME("SetLocaleInfoA", 3, "lpLCData"); // LPCSTR
	ADD_PARAM_NAME("SetLocaleInfoW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("SetLocaleInfoW", 2, "LCType"); // LCTYPE
	ADD_PARAM_NAME("SetLocaleInfoW", 3, "lpLCData"); // LPCWSTR
	ADD_PARAM_NAME("SetMailslotInfo", 1, "hMailslot"); // HANDLE
	ADD_PARAM_NAME("SetMailslotInfo", 2, "lReadTimeout"); // DWORD
	ADD_PARAM_NAME("SetMapMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetMapMode", 2, "iMode"); // int
	ADD_PARAM_NAME("SetMapperFlags", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetMapperFlags", 2, "flags"); // DWORD
	ADD_PARAM_NAME("SetMenu", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetMenu", 2, "hMenu"); // HMENU
	ADD_PARAM_NAME("SetMenuContextHelpId", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("SetMenuContextHelpId", 2, "dwContextHelpId"); // DWORD
	ADD_PARAM_NAME("SetMenuDefaultItem", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("SetMenuDefaultItem", 2, "uItem"); // UINT
	ADD_PARAM_NAME("SetMenuDefaultItem", 3, "fByPos"); // UINT
	ADD_PARAM_NAME("SetMenuInfo", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("SetMenuInfo", 2, "lpcmi"); // LPCMENUINFO
	ADD_PARAM_NAME("SetMenuItemBitmaps", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("SetMenuItemBitmaps", 2, "uPosition"); // UINT
	ADD_PARAM_NAME("SetMenuItemBitmaps", 3, "uFlags"); // UINT
	ADD_PARAM_NAME("SetMenuItemBitmaps", 4, "hBitmapUnchecked"); // HBITMAP
	ADD_PARAM_NAME("SetMenuItemBitmaps", 5, "hBitmapChecked"); // HBITMAP
	ADD_PARAM_NAME("SetMenuItemInfoA", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("SetMenuItemInfoA", 2, "item"); // UINT
	ADD_PARAM_NAME("SetMenuItemInfoA", 3, "fByPositon"); // WINBOOL
	ADD_PARAM_NAME("SetMenuItemInfoA", 4, "lpmii"); // LPCMENUITEMINFOA
	ADD_PARAM_NAME("SetMenuItemInfoW", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("SetMenuItemInfoW", 2, "item"); // UINT
	ADD_PARAM_NAME("SetMenuItemInfoW", 3, "fByPositon"); // WINBOOL
	ADD_PARAM_NAME("SetMenuItemInfoW", 4, "lpmii"); // LPCMENUITEMINFOW
	ADD_PARAM_NAME("SetMessageExtraInfo", 1, "lParam"); // LPARAM
	ADD_PARAM_NAME("SetMessageQueue", 1, "cMessagesMax"); // int
	ADD_PARAM_NAME("SetMessageWaitingIndicator", 1, "hMsgIndicator"); // HANDLE
	ADD_PARAM_NAME("SetMessageWaitingIndicator", 2, "ulMsgCount"); // ULONG
	ADD_PARAM_NAME("SetMetaFileBitsEx", 1, "cbBuffer"); // UINT
	ADD_PARAM_NAME("SetMetaFileBitsEx", 2, "lpData"); // CONST BYTE *
	ADD_PARAM_NAME("SetMetaRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetMiterLimit", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetMiterLimit", 2, "limit"); // FLOAT
	ADD_PARAM_NAME("SetMiterLimit", 3, "old"); // PFLOAT
	ADD_PARAM_NAME("SetNamedPipeHandleState", 1, "hNamedPipe"); // HANDLE
	ADD_PARAM_NAME("SetNamedPipeHandleState", 2, "lpMode"); // LPDWORD
	ADD_PARAM_NAME("SetNamedPipeHandleState", 3, "lpMaxCollectionCount"); // LPDWORD
	ADD_PARAM_NAME("SetNamedPipeHandleState", 4, "lpCollectDataTimeout"); // LPDWORD
	ADD_PARAM_NAME("SetPaletteEntries", 1, "hpal"); // HPALETTE
	ADD_PARAM_NAME("SetPaletteEntries", 2, "iStart"); // UINT
	ADD_PARAM_NAME("SetPaletteEntries", 3, "cEntries"); // UINT
	ADD_PARAM_NAME("SetPaletteEntries", 4, "pPalEntries"); // CONST PALETTEENTRY *
	ADD_PARAM_NAME("SetParent", 1, "hWndChild"); // HWND
	ADD_PARAM_NAME("SetParent", 2, "hWndNewParent"); // HWND
	ADD_PARAM_NAME("SetPixel", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetPixel", 2, "x"); // int
	ADD_PARAM_NAME("SetPixel", 3, "y"); // int
	ADD_PARAM_NAME("SetPixel", 4, "color"); // COLORREF
	ADD_PARAM_NAME("SetPixelFormat", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetPixelFormat", 2, "format"); // int
	ADD_PARAM_NAME("SetPixelFormat", 3, "ppfd"); // CONST PIXELFORMATDESCRIPTOR *
	ADD_PARAM_NAME("SetPixelV", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetPixelV", 2, "x"); // int
	ADD_PARAM_NAME("SetPixelV", 3, "y"); // int
	ADD_PARAM_NAME("SetPixelV", 4, "color"); // COLORREF
	ADD_PARAM_NAME("SetPolyFillMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetPolyFillMode", 2, "mode"); // int
	ADD_PARAM_NAME("SetPortA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("SetPortA", 2, "pPortName"); // LPSTR
	ADD_PARAM_NAME("SetPortA", 3, "dwLevel"); // DWORD
	ADD_PARAM_NAME("SetPortA", 4, "pPortInfo"); // LPBYTE
	ADD_PARAM_NAME("SetPortW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("SetPortW", 2, "pPortName"); // LPWSTR
	ADD_PARAM_NAME("SetPortW", 3, "dwLevel"); // DWORD
	ADD_PARAM_NAME("SetPortW", 4, "pPortInfo"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("SetPrinterA", 3, "pPrinter"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterA", 4, "Command"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterDataA", 2, "pValueName"); // LPSTR
	ADD_PARAM_NAME("SetPrinterDataA", 3, "Type"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataA", 4, "pData"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterDataA", 5, "cbData"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataExA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterDataExA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("SetPrinterDataExA", 3, "pValueName"); // LPCSTR
	ADD_PARAM_NAME("SetPrinterDataExA", 4, "Type"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataExA", 5, "pData"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterDataExA", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataExW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterDataExW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("SetPrinterDataExW", 3, "pValueName"); // LPCWSTR
	ADD_PARAM_NAME("SetPrinterDataExW", 4, "Type"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataExW", 5, "pData"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterDataExW", 6, "cbData"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterDataW", 2, "pValueName"); // LPWSTR
	ADD_PARAM_NAME("SetPrinterDataW", 3, "Type"); // DWORD
	ADD_PARAM_NAME("SetPrinterDataW", 4, "pData"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterDataW", 5, "cbData"); // DWORD
	ADD_PARAM_NAME("SetPrinterToken", 1, "hToken"); // HANDLE
	ADD_PARAM_NAME("SetPrinterW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SetPrinterW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("SetPrinterW", 3, "pPrinter"); // LPBYTE
	ADD_PARAM_NAME("SetPrinterW", 4, "Command"); // DWORD
	ADD_PARAM_NAME("SetPriorityClass", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("SetPriorityClass", 2, "dwPriorityClass"); // DWORD
	ADD_PARAM_NAME("SetPrivateObjectSecurity", 1, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetPrivateObjectSecurity", 2, "ModificationDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetPrivateObjectSecurity", 3, "ObjectsSecurityDescriptor"); // PSECURITY_DESCRIPTOR *
	ADD_PARAM_NAME("SetPrivateObjectSecurity", 4, "GenericMapping"); // PGENERIC_MAPPING
	ADD_PARAM_NAME("SetPrivateObjectSecurity", 5, "Token"); // HANDLE
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 1, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 2, "ModificationDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 3, "ObjectsSecurityDescriptor"); // PSECURITY_DESCRIPTOR *
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 4, "AutoInheritFlags"); // ULONG
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 5, "GenericMapping"); // PGENERIC_MAPPING
	ADD_PARAM_NAME("SetPrivateObjectSecurityEx", 6, "Token"); // HANDLE
	ADD_PARAM_NAME("SetProcessAffinityMask", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("SetProcessAffinityMask", 2, "dwProcessAffinityMask"); // DWORD_PTR
	ADD_PARAM_NAME("SetProcessAffinityUpdateMode", 1, "ProcessHandle"); // HANDLE
	ADD_PARAM_NAME("SetProcessAffinityUpdateMode", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetProcessDEPPolicy", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetProcessDefaultLayout", 1, "dwDefaultLayout"); // DWORD
	ADD_PARAM_NAME("SetProcessPriorityBoost", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("SetProcessPriorityBoost", 2, "bDisablePriorityBoost"); // WINBOOL
	ADD_PARAM_NAME("SetProcessShutdownParameters", 1, "dwLevel"); // DWORD
	ADD_PARAM_NAME("SetProcessShutdownParameters", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetProcessWindowStation", 1, "hWinSta"); // HWINSTA
	ADD_PARAM_NAME("SetProcessWorkingSetSize", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("SetProcessWorkingSetSize", 2, "dwMinimumWorkingSetSize"); // SIZE_T
	ADD_PARAM_NAME("SetProcessWorkingSetSize", 3, "dwMaximumWorkingSetSize"); // SIZE_T
	ADD_PARAM_NAME("SetProcessWorkingSetSizeEx", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("SetProcessWorkingSetSizeEx", 2, "dwMinimumWorkingSetSize"); // SIZE_T
	ADD_PARAM_NAME("SetProcessWorkingSetSizeEx", 3, "dwMaximumWorkingSetSize"); // SIZE_T
	ADD_PARAM_NAME("SetProcessWorkingSetSizeEx", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("SetPropA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetPropA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("SetPropA", 3, "hData"); // HANDLE
	ADD_PARAM_NAME("SetPropW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetPropW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("SetPropW", 3, "hData"); // HANDLE
	ADD_PARAM_NAME("SetROP2", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetROP2", 2, "rop2"); // int
	ADD_PARAM_NAME("SetRect", 1, "lprc"); // LPRECT
	ADD_PARAM_NAME("SetRect", 2, "xLeft"); // int
	ADD_PARAM_NAME("SetRect", 3, "yTop"); // int
	ADD_PARAM_NAME("SetRect", 4, "xRight"); // int
	ADD_PARAM_NAME("SetRect", 5, "yBottom"); // int
	ADD_PARAM_NAME("SetRectEmpty", 1, "lprc"); // LPRECT
	ADD_PARAM_NAME("SetRectRgn", 1, "hrgn"); // HRGN
	ADD_PARAM_NAME("SetRectRgn", 2, "left"); // int
	ADD_PARAM_NAME("SetRectRgn", 3, "top"); // int
	ADD_PARAM_NAME("SetRectRgn", 4, "right"); // int
	ADD_PARAM_NAME("SetRectRgn", 5, "bottom"); // int
	ADD_PARAM_NAME("SetScrollInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetScrollInfo", 2, "nBar"); // int
	ADD_PARAM_NAME("SetScrollInfo", 3, "lpsi"); // LPCSCROLLINFO
	ADD_PARAM_NAME("SetScrollInfo", 4, "redraw"); // WINBOOL
	ADD_PARAM_NAME("SetScrollPos", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetScrollPos", 2, "nBar"); // int
	ADD_PARAM_NAME("SetScrollPos", 3, "nPos"); // int
	ADD_PARAM_NAME("SetScrollPos", 4, "bRedraw"); // WINBOOL
	ADD_PARAM_NAME("SetScrollRange", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetScrollRange", 2, "nBar"); // int
	ADD_PARAM_NAME("SetScrollRange", 3, "nMinPos"); // int
	ADD_PARAM_NAME("SetScrollRange", 4, "nMaxPos"); // int
	ADD_PARAM_NAME("SetScrollRange", 5, "bRedraw"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityAccessMask", 1, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetSecurityAccessMask", 2, "DesiredAccess"); // LPDWORD
	ADD_PARAM_NAME("SetSecurityDescriptorControl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorControl", 2, "ControlBitsOfInterest"); // SECURITY_DESCRIPTOR_CONTROL
	ADD_PARAM_NAME("SetSecurityDescriptorControl", 3, "ControlBitsToSet"); // SECURITY_DESCRIPTOR_CONTROL
	ADD_PARAM_NAME("SetSecurityDescriptorDacl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorDacl", 2, "bDaclPresent"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityDescriptorDacl", 3, "pDacl"); // PACL
	ADD_PARAM_NAME("SetSecurityDescriptorDacl", 4, "bDaclDefaulted"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityDescriptorGroup", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorGroup", 2, "pGroup"); // PSID
	ADD_PARAM_NAME("SetSecurityDescriptorGroup", 3, "bGroupDefaulted"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityDescriptorOwner", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorOwner", 2, "pOwner"); // PSID
	ADD_PARAM_NAME("SetSecurityDescriptorOwner", 3, "bOwnerDefaulted"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityDescriptorRMControl", 1, "SecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorRMControl", 2, "RMControl"); // PUCHAR
	ADD_PARAM_NAME("SetSecurityDescriptorSacl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetSecurityDescriptorSacl", 2, "bSaclPresent"); // WINBOOL
	ADD_PARAM_NAME("SetSecurityDescriptorSacl", 3, "pSacl"); // PACL
	ADD_PARAM_NAME("SetSecurityDescriptorSacl", 4, "bSaclDefaulted"); // WINBOOL
	ADD_PARAM_NAME("SetServiceObjectSecurity", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("SetServiceObjectSecurity", 2, "dwSecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("SetServiceObjectSecurity", 3, "lpSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetServiceStatus", 1, "hServiceStatus"); // SERVICE_STATUS_HANDLE
	ADD_PARAM_NAME("SetServiceStatus", 2, "lpServiceStatus"); // LPSERVICE_STATUS
	ADD_PARAM_NAME("SetStdHandle", 1, "nStdHandle"); // DWORD
	ADD_PARAM_NAME("SetStdHandle", 2, "hHandle"); // HANDLE
	ADD_PARAM_NAME("SetStretchBltMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetStretchBltMode", 2, "mode"); // int
	ADD_PARAM_NAME("SetSysColors", 1, "cElements"); // int
	ADD_PARAM_NAME("SetSysColors", 2, "lpaElements"); // CONST INT *
	ADD_PARAM_NAME("SetSysColors", 3, "lpaRgbValues"); // CONST COLORREF *
	ADD_PARAM_NAME("SetSystemCursor", 1, "hcur"); // HCURSOR
	ADD_PARAM_NAME("SetSystemCursor", 2, "id"); // DWORD
	ADD_PARAM_NAME("SetSystemFileCacheSize", 1, "MinimumFileCacheSize"); // SIZE_T
	ADD_PARAM_NAME("SetSystemFileCacheSize", 2, "MaximumFileCacheSize"); // SIZE_T
	ADD_PARAM_NAME("SetSystemFileCacheSize", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("SetSystemPaletteUse", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetSystemPaletteUse", 2, "use"); // UINT
	ADD_PARAM_NAME("SetSystemPowerState", 1, "fSuspend"); // WINBOOL
	ADD_PARAM_NAME("SetSystemPowerState", 2, "fForce"); // WINBOOL
	ADD_PARAM_NAME("SetSystemTime", 1, "lpSystemTime"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("SetSystemTimeAdjustment", 1, "dwTimeAdjustment"); // DWORD
	ADD_PARAM_NAME("SetSystemTimeAdjustment", 2, "bTimeAdjustmentDisabled"); // WINBOOL
	ADD_PARAM_NAME("SetTapeParameters", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("SetTapeParameters", 2, "dwOperation"); // DWORD
	ADD_PARAM_NAME("SetTapeParameters", 3, "lpTapeInformation"); // LPVOID
	ADD_PARAM_NAME("SetTapePosition", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("SetTapePosition", 2, "dwPositionMethod"); // DWORD
	ADD_PARAM_NAME("SetTapePosition", 3, "dwPartition"); // DWORD
	ADD_PARAM_NAME("SetTapePosition", 4, "dwOffsetLow"); // DWORD
	ADD_PARAM_NAME("SetTapePosition", 5, "dwOffsetHigh"); // DWORD
	ADD_PARAM_NAME("SetTapePosition", 6, "bImmediate"); // WINBOOL
	ADD_PARAM_NAME("SetTextAlign", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetTextAlign", 2, "align"); // UINT
	ADD_PARAM_NAME("SetTextCharacterExtra", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetTextCharacterExtra", 2, "extra"); // int
	ADD_PARAM_NAME("SetTextColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetTextColor", 2, "color"); // COLORREF
	ADD_PARAM_NAME("SetTextJustification", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetTextJustification", 2, "extra"); // int
	ADD_PARAM_NAME("SetTextJustification", 3, "count"); // int
	ADD_PARAM_NAME("SetThreadAffinityMask", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SetThreadAffinityMask", 2, "dwThreadAffinityMask"); // DWORD_PTR
	ADD_PARAM_NAME("SetThreadContext", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SetThreadContext", 2, "lpContext"); // CONST CONTEXT *
	ADD_PARAM_NAME("SetThreadDesktop", 1, "hDesktop"); // HDESK
	ADD_PARAM_NAME("SetThreadExecutionState", 1, "esFlags"); // EXECUTION_STATE
	ADD_PARAM_NAME("SetThreadIdealProcessor", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SetThreadIdealProcessor", 2, "dwIdealProcessor"); // DWORD
	ADD_PARAM_NAME("SetThreadLocale", 1, "Locale"); // LCID
	ADD_PARAM_NAME("SetThreadPreferredUILanguages", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetThreadPreferredUILanguages", 2, "pwszLanguagesBuffer"); // PCZZWSTR
	ADD_PARAM_NAME("SetThreadPreferredUILanguages", 3, "pulNumLanguages"); // PULONG
	ADD_PARAM_NAME("SetThreadPriority", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SetThreadPriority", 2, "nPriority"); // int
	ADD_PARAM_NAME("SetThreadPriorityBoost", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SetThreadPriorityBoost", 2, "bDisablePriorityBoost"); // WINBOOL
	ADD_PARAM_NAME("SetThreadStackGuarantee", 1, "StackSizeInBytes"); // PULONG
	ADD_PARAM_NAME("SetThreadToken", 1, "Thread"); // PHANDLE
	ADD_PARAM_NAME("SetThreadToken", 2, "Token"); // HANDLE
	ADD_PARAM_NAME("SetThreadUILanguage", 1, "LangId"); // LANGID
	ADD_PARAM_NAME("SetThreadpoolThreadMaximum", 1, "ptpp"); // PTP_POOL
	ADD_PARAM_NAME("SetThreadpoolThreadMaximum", 2, "cthrdMost"); // DWORD
	ADD_PARAM_NAME("SetThreadpoolThreadMinimum", 1, "ptpp"); // PTP_POOL
	ADD_PARAM_NAME("SetThreadpoolThreadMinimum", 2, "cthrdMic"); // DWORD
	ADD_PARAM_NAME("SetThreadpoolTimer", 1, "pti"); // PTP_TIMER
	ADD_PARAM_NAME("SetThreadpoolTimer", 2, "pftDueTime"); // PFILETIME
	ADD_PARAM_NAME("SetThreadpoolTimer", 3, "msPeriod"); // DWORD
	ADD_PARAM_NAME("SetThreadpoolTimer", 4, "msWindowLength"); // DWORD
	ADD_PARAM_NAME("SetThreadpoolWait", 1, "pwa"); // PTP_WAIT
	ADD_PARAM_NAME("SetThreadpoolWait", 2, "h"); // HANDLE
	ADD_PARAM_NAME("SetThreadpoolWait", 3, "pftTimeout"); // PFILETIME
	ADD_PARAM_NAME("SetTimeZoneInformation", 1, "lpTimeZoneInformation"); // CONST TIME_ZONE_INFORMATION *
	ADD_PARAM_NAME("SetTimer", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetTimer", 2, "nIDEvent"); // UINT_PTR
	ADD_PARAM_NAME("SetTimer", 3, "uElapse"); // UINT
	ADD_PARAM_NAME("SetTimer", 4, "lpTimerFunc"); // TIMERPROC
	ADD_PARAM_NAME("SetTimerQueueTimer", 1, "TimerQueue"); // HANDLE
	ADD_PARAM_NAME("SetTimerQueueTimer", 2, "Callback"); // WAITORTIMERCALLBACK
	ADD_PARAM_NAME("SetTimerQueueTimer", 3, "Parameter"); // PVOID
	ADD_PARAM_NAME("SetTimerQueueTimer", 4, "DueTime"); // DWORD
	ADD_PARAM_NAME("SetTimerQueueTimer", 5, "Period"); // DWORD
	ADD_PARAM_NAME("SetTimerQueueTimer", 6, "PreferIo"); // WINBOOL
	ADD_PARAM_NAME("SetTokenInformation", 1, "TokenHandle"); // HANDLE
	ADD_PARAM_NAME("SetTokenInformation", 2, "TokenInformationClass"); // TOKEN_INFORMATION_CLASS
	ADD_PARAM_NAME("SetTokenInformation", 3, "TokenInformation"); // LPVOID
	ADD_PARAM_NAME("SetTokenInformation", 4, "TokenInformationLength"); // DWORD
	ADD_PARAM_NAME("SetUnhandledExceptionFilter", 1, "lpTopLevelExceptionFilter"); // LPTOP_LEVEL_EXCEPTION_FILTER
	ADD_PARAM_NAME("SetUrlCacheConfigInfoA", 1, "lpCacheConfigInfo"); // LPINTERNET_CACHE_CONFIG_INFOA
	ADD_PARAM_NAME("SetUrlCacheConfigInfoA", 2, "dwFieldControl"); // DWORD
	ADD_PARAM_NAME("SetUrlCacheConfigInfoW", 1, "lpCacheConfigInfo"); // LPINTERNET_CACHE_CONFIG_INFOA
	ADD_PARAM_NAME("SetUrlCacheConfigInfoW", 2, "dwFieldControl"); // DWORD
	ADD_PARAM_NAME("SetUserFileEncryptionKey", 1, "pEncryptionCertificate"); // PENCRYPTION_CERTIFICATE
	ADD_PARAM_NAME("SetUserGeoID", 1, "GeoId"); // GEOID
	ADD_PARAM_NAME("SetUserObjectInformationA", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("SetUserObjectInformationA", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetUserObjectInformationA", 3, "pvInfo"); // PVOID
	ADD_PARAM_NAME("SetUserObjectInformationA", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("SetUserObjectInformationW", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("SetUserObjectInformationW", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetUserObjectInformationW", 3, "pvInfo"); // PVOID
	ADD_PARAM_NAME("SetUserObjectInformationW", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("SetUserObjectSecurity", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("SetUserObjectSecurity", 2, "pSIRequested"); // PSECURITY_INFORMATION
	ADD_PARAM_NAME("SetUserObjectSecurity", 3, "pSID"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("SetViewportExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetViewportExtEx", 2, "x"); // int
	ADD_PARAM_NAME("SetViewportExtEx", 3, "y"); // int
	ADD_PARAM_NAME("SetViewportExtEx", 4, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("SetViewportOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetViewportOrgEx", 2, "x"); // int
	ADD_PARAM_NAME("SetViewportOrgEx", 3, "y"); // int
	ADD_PARAM_NAME("SetViewportOrgEx", 4, "lppt"); // LPPOINT
	ADD_PARAM_NAME("SetVolumeLabelA", 1, "lpRootPathName"); // LPCSTR
	ADD_PARAM_NAME("SetVolumeLabelA", 2, "lpVolumeName"); // LPCSTR
	ADD_PARAM_NAME("SetVolumeLabelW", 1, "lpRootPathName"); // LPCWSTR
	ADD_PARAM_NAME("SetVolumeLabelW", 2, "lpVolumeName"); // LPCWSTR
	ADD_PARAM_NAME("SetVolumeMountPointA", 1, "lpszVolumeMountPoint"); // LPCSTR
	ADD_PARAM_NAME("SetVolumeMountPointA", 2, "lpszVolumeName"); // LPCSTR
	ADD_PARAM_NAME("SetVolumeMountPointW", 1, "lpszVolumeMountPoint"); // LPCWSTR
	ADD_PARAM_NAME("SetVolumeMountPointW", 2, "lpszVolumeName"); // LPCWSTR
	ADD_PARAM_NAME("SetWaitableTimer", 1, "hTimer"); // HANDLE
	ADD_PARAM_NAME("SetWaitableTimer", 2, "lpDueTime"); // const LARGE_INTEGER *
	ADD_PARAM_NAME("SetWaitableTimer", 3, "lPeriod"); // LONG
	ADD_PARAM_NAME("SetWaitableTimer", 4, "pfnCompletionRoutine"); // PTIMERAPCROUTINE
	ADD_PARAM_NAME("SetWaitableTimer", 5, "lpArgToCompletionRoutine"); // LPVOID
	ADD_PARAM_NAME("SetWaitableTimer", 6, "fResume"); // WINBOOL
	ADD_PARAM_NAME("SetWinEventHook", 1, "eventMin"); // DWORD
	ADD_PARAM_NAME("SetWinEventHook", 2, "eventMax"); // DWORD
	ADD_PARAM_NAME("SetWinEventHook", 3, "hmodWinEventProc"); // HMODULE
	ADD_PARAM_NAME("SetWinEventHook", 4, "pfnWinEventProc"); // WINEVENTPROC
	ADD_PARAM_NAME("SetWinEventHook", 5, "idProcess"); // DWORD
	ADD_PARAM_NAME("SetWinEventHook", 6, "idThread"); // DWORD
	ADD_PARAM_NAME("SetWinEventHook", 7, "dwFlags"); // DWORD
	ADD_PARAM_NAME("SetWinMetaFileBits", 1, "nSize"); // UINT
	ADD_PARAM_NAME("SetWinMetaFileBits", 2, "lpMeta16Data"); // CONST BYTE *
	ADD_PARAM_NAME("SetWinMetaFileBits", 3, "hdcRef"); // HDC
	ADD_PARAM_NAME("SetWinMetaFileBits", 4, "lpMFP"); // CONST METAFILEPICT *
	ADD_PARAM_NAME("SetWindowContextHelpId", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowContextHelpId", 2, "dwContextHelpId"); // DWORD
	ADD_PARAM_NAME("SetWindowExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetWindowExtEx", 2, "x"); // int
	ADD_PARAM_NAME("SetWindowExtEx", 3, "y"); // int
	ADD_PARAM_NAME("SetWindowExtEx", 4, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("SetWindowLongA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowLongA", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetWindowLongA", 3, "dwNewLong"); // LONG
	ADD_PARAM_NAME("SetWindowLongPtrA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowLongPtrA", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetWindowLongPtrA", 3, "dwNewLong"); // LONG_PTR
	ADD_PARAM_NAME("SetWindowLongPtrW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowLongPtrW", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetWindowLongPtrW", 3, "dwNewLong"); // LONG_PTR
	ADD_PARAM_NAME("SetWindowLongW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowLongW", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetWindowLongW", 3, "dwNewLong"); // LONG
	ADD_PARAM_NAME("SetWindowOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetWindowOrgEx", 2, "x"); // int
	ADD_PARAM_NAME("SetWindowOrgEx", 3, "y"); // int
	ADD_PARAM_NAME("SetWindowOrgEx", 4, "lppt"); // LPPOINT
	ADD_PARAM_NAME("SetWindowPlacement", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowPlacement", 2, "lpwndpl"); // CONST WINDOWPLACEMENT *
	ADD_PARAM_NAME("SetWindowPos", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowPos", 2, "hWndInsertAfter"); // HWND
	ADD_PARAM_NAME("SetWindowPos", 3, "X"); // int
	ADD_PARAM_NAME("SetWindowPos", 4, "Y"); // int
	ADD_PARAM_NAME("SetWindowPos", 5, "cx"); // int
	ADD_PARAM_NAME("SetWindowPos", 6, "cy"); // int
	ADD_PARAM_NAME("SetWindowPos", 7, "uFlags"); // UINT
	ADD_PARAM_NAME("SetWindowRgn", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowRgn", 2, "hRgn"); // HRGN
	ADD_PARAM_NAME("SetWindowRgn", 3, "bRedraw"); // WINBOOL
	ADD_PARAM_NAME("SetWindowTextA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowTextA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("SetWindowTextW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowTextW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("SetWindowWord", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SetWindowWord", 2, "nIndex"); // int
	ADD_PARAM_NAME("SetWindowWord", 3, "wNewWord"); // WORD
	ADD_PARAM_NAME("SetWindowsHookA", 1, "nFilterType"); // int
	ADD_PARAM_NAME("SetWindowsHookA", 2, "pfnFilterProc"); // HOOKPROC
	ADD_PARAM_NAME("SetWindowsHookExA", 1, "idHook"); // int
	ADD_PARAM_NAME("SetWindowsHookExA", 2, "lpfn"); // HOOKPROC
	ADD_PARAM_NAME("SetWindowsHookExA", 3, "hmod"); // HINSTANCE
	ADD_PARAM_NAME("SetWindowsHookExA", 4, "dwThreadId"); // DWORD
	ADD_PARAM_NAME("SetWindowsHookExW", 1, "idHook"); // int
	ADD_PARAM_NAME("SetWindowsHookExW", 2, "lpfn"); // HOOKPROC
	ADD_PARAM_NAME("SetWindowsHookExW", 3, "hmod"); // HINSTANCE
	ADD_PARAM_NAME("SetWindowsHookExW", 4, "dwThreadId"); // DWORD
	ADD_PARAM_NAME("SetWindowsHookW", 1, "nFilterType"); // int
	ADD_PARAM_NAME("SetWindowsHookW", 2, "pfnFilterProc"); // HOOKPROC
	ADD_PARAM_NAME("SetWorldTransform", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SetWorldTransform", 2, "lpxf"); // CONST XFORM *
	ADD_PARAM_NAME("SetupComm", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("SetupComm", 2, "dwInQueue"); // DWORD
	ADD_PARAM_NAME("SetupComm", 3, "dwOutQueue"); // DWORD
	ADD_PARAM_NAME("ShowCaret", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShowCursor", 1, "bShow"); // WINBOOL
	ADD_PARAM_NAME("ShowOwnedPopups", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShowOwnedPopups", 2, "fShow"); // WINBOOL
	ADD_PARAM_NAME("ShowScrollBar", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShowScrollBar", 2, "wBar"); // int
	ADD_PARAM_NAME("ShowScrollBar", 3, "bShow"); // WINBOOL
	ADD_PARAM_NAME("ShowWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShowWindow", 2, "nCmdShow"); // int
	ADD_PARAM_NAME("ShowWindowAsync", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShowWindowAsync", 2, "nCmdShow"); // int
	ADD_PARAM_NAME("ShutdownBlockReasonCreate", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShutdownBlockReasonCreate", 2, "pwszReason"); // LPCWSTR
	ADD_PARAM_NAME("ShutdownBlockReasonDestroy", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShutdownBlockReasonQuery", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("ShutdownBlockReasonQuery", 2, "pwszBuff"); // LPWSTR
	ADD_PARAM_NAME("ShutdownBlockReasonQuery", 3, "pcchBuff"); // DWORD *
	ADD_PARAM_NAME("SignalObjectAndWait", 1, "hObjectToSignal"); // HANDLE
	ADD_PARAM_NAME("SignalObjectAndWait", 2, "hObjectToWaitOn"); // HANDLE
	ADD_PARAM_NAME("SignalObjectAndWait", 3, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("SignalObjectAndWait", 4, "bAlertable"); // WINBOOL
	ADD_PARAM_NAME("SizeofResource", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("SizeofResource", 2, "hResInfo"); // HRSRC
	ADD_PARAM_NAME("Sleep", 1, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("SleepConditionVariableCS", 1, "ConditionVariable"); // PCONDITION_VARIABLE
	ADD_PARAM_NAME("SleepConditionVariableCS", 2, "CriticalSection"); // PCRITICAL_SECTION
	ADD_PARAM_NAME("SleepConditionVariableCS", 3, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("SleepConditionVariableSRW", 1, "ConditionVariable"); // PCONDITION_VARIABLE
	ADD_PARAM_NAME("SleepConditionVariableSRW", 2, "SRWLock"); // PSRWLOCK
	ADD_PARAM_NAME("SleepConditionVariableSRW", 3, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("SleepConditionVariableSRW", 4, "Flags"); // ULONG
	ADD_PARAM_NAME("SleepEx", 1, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("SleepEx", 2, "bAlertable"); // WINBOOL
	ADD_PARAM_NAME("SnmpCancelMsg", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpCancelMsg", 2, "reqId"); // smiINT32
	ADD_PARAM_NAME("SnmpClose", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpContextToStr", 1, "context"); // HSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpContextToStr", 2, "string"); // smiLPOCTETS
	ADD_PARAM_NAME("SnmpCountVbl", 1, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpCreatePdu", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpCreatePdu", 2, "PDU_type"); // smiINT
	ADD_PARAM_NAME("SnmpCreatePdu", 3, "request_id"); // smiINT32
	ADD_PARAM_NAME("SnmpCreatePdu", 4, "error_status"); // smiINT
	ADD_PARAM_NAME("SnmpCreatePdu", 5, "error_index"); // smiINT
	ADD_PARAM_NAME("SnmpCreatePdu", 6, "varbindlist"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpCreateSession", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SnmpCreateSession", 2, "wMsg"); // UINT
	ADD_PARAM_NAME("SnmpCreateSession", 3, "fCallBack"); // SNMPAPI_CALLBACK
	ADD_PARAM_NAME("SnmpCreateSession", 4, "lpClientData"); // LPVOID
	ADD_PARAM_NAME("SnmpCreateVbl", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpCreateVbl", 2, "name"); // smiLPCOID
	ADD_PARAM_NAME("SnmpCreateVbl", 3, "value"); // smiLPCVALUE
	ADD_PARAM_NAME("SnmpDecodeMsg", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpDecodeMsg", 2, "srcEntity"); // LPHSNMP_ENTITY
	ADD_PARAM_NAME("SnmpDecodeMsg", 3, "dstEntity"); // LPHSNMP_ENTITY
	ADD_PARAM_NAME("SnmpDecodeMsg", 4, "context"); // LPHSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpDecodeMsg", 5, "pdu"); // LPHSNMP_PDU
	ADD_PARAM_NAME("SnmpDecodeMsg", 6, "msgBufDesc"); // smiLPCOCTETS
	ADD_PARAM_NAME("SnmpDeleteVb", 1, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpDeleteVb", 2, "index"); // smiUINT32
	ADD_PARAM_NAME("SnmpDuplicatePdu", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpDuplicatePdu", 2, "PDU"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpDuplicateVbl", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpDuplicateVbl", 2, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpEncodeMsg", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpEncodeMsg", 2, "srcEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpEncodeMsg", 3, "dstEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpEncodeMsg", 4, "context"); // HSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpEncodeMsg", 5, "pdu"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpEncodeMsg", 6, "msgBufDesc"); // smiLPOCTETS
	ADD_PARAM_NAME("SnmpEntityToStr", 1, "entity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpEntityToStr", 2, "size"); // smiUINT32
	ADD_PARAM_NAME("SnmpEntityToStr", 3, "string"); // LPSTR
	ADD_PARAM_NAME("SnmpFreeContext", 1, "context"); // HSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpFreeDescriptor", 1, "syntax"); // smiUINT32
	ADD_PARAM_NAME("SnmpFreeDescriptor", 2, "descriptor"); // smiLPOPAQUE
	ADD_PARAM_NAME("SnmpFreeEntity", 1, "entity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpFreePdu", 1, "PDU"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpFreeVbl", 1, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpGetLastError", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpGetPduData", 1, "PDU"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpGetPduData", 2, "PDU_type"); // smiLPINT
	ADD_PARAM_NAME("SnmpGetPduData", 3, "request_id"); // smiLPINT32
	ADD_PARAM_NAME("SnmpGetPduData", 4, "error_status"); // smiLPINT
	ADD_PARAM_NAME("SnmpGetPduData", 5, "error_index"); // smiLPINT
	ADD_PARAM_NAME("SnmpGetPduData", 6, "varbindlist"); // LPHSNMP_VBL
	ADD_PARAM_NAME("SnmpGetRetransmitMode", 1, "nRetransmitMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpGetRetry", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpGetRetry", 2, "nPolicyRetry"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpGetRetry", 3, "nActualRetry"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpGetTimeout", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpGetTimeout", 2, "nPolicyTimeout"); // smiLPTIMETICKS
	ADD_PARAM_NAME("SnmpGetTimeout", 3, "nActualTimeout"); // smiLPTIMETICKS
	ADD_PARAM_NAME("SnmpGetTranslateMode", 1, "nTranslateMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpGetVb", 1, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpGetVb", 2, "index"); // smiUINT32
	ADD_PARAM_NAME("SnmpGetVb", 3, "name"); // smiLPOID
	ADD_PARAM_NAME("SnmpGetVb", 4, "value"); // smiLPVALUE
	ADD_PARAM_NAME("SnmpGetVendorInfo", 1, "vendorInfo"); // smiLPVENDORINFO
	ADD_PARAM_NAME("SnmpListen", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpListen", 2, "lStatus"); // SNMPAPI_STATUS
	ADD_PARAM_NAME("SnmpOidCompare", 1, "xOID"); // smiLPCOID
	ADD_PARAM_NAME("SnmpOidCompare", 2, "yOID"); // smiLPCOID
	ADD_PARAM_NAME("SnmpOidCompare", 3, "maxlen"); // smiUINT32
	ADD_PARAM_NAME("SnmpOidCompare", 4, "result"); // smiLPINT
	ADD_PARAM_NAME("SnmpOidCopy", 1, "srcOID"); // smiLPCOID
	ADD_PARAM_NAME("SnmpOidCopy", 2, "dstOID"); // smiLPOID
	ADD_PARAM_NAME("SnmpOidToStr", 1, "srcOID"); // smiLPCOID
	ADD_PARAM_NAME("SnmpOidToStr", 2, "size"); // smiUINT32
	ADD_PARAM_NAME("SnmpOidToStr", 3, "string"); // LPSTR
	ADD_PARAM_NAME("SnmpOpen", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SnmpOpen", 2, "wMsg"); // UINT
	ADD_PARAM_NAME("SnmpRecvMsg", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpRecvMsg", 2, "srcEntity"); // LPHSNMP_ENTITY
	ADD_PARAM_NAME("SnmpRecvMsg", 3, "dstEntity"); // LPHSNMP_ENTITY
	ADD_PARAM_NAME("SnmpRecvMsg", 4, "context"); // LPHSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpRecvMsg", 5, "PDU"); // LPHSNMP_PDU
	ADD_PARAM_NAME("SnmpRegister", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpRegister", 2, "srcEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpRegister", 3, "dstEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpRegister", 4, "context"); // HSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpRegister", 5, "notification"); // smiLPCOID
	ADD_PARAM_NAME("SnmpRegister", 6, "state"); // smiUINT32
	ADD_PARAM_NAME("SnmpSendMsg", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpSendMsg", 2, "srcEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpSendMsg", 3, "dstEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpSendMsg", 4, "context"); // HSNMP_CONTEXT
	ADD_PARAM_NAME("SnmpSendMsg", 5, "PDU"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpSetPduData", 1, "PDU"); // HSNMP_PDU
	ADD_PARAM_NAME("SnmpSetPduData", 2, "PDU_type"); // const smiINT *
	ADD_PARAM_NAME("SnmpSetPduData", 3, "request_id"); // const smiINT32 *
	ADD_PARAM_NAME("SnmpSetPduData", 4, "non_repeaters"); // const smiINT *
	ADD_PARAM_NAME("SnmpSetPduData", 5, "max_repetitions"); // const smiINT *
	ADD_PARAM_NAME("SnmpSetPduData", 6, "varbindlist"); // const HSNMP_VBL *
	ADD_PARAM_NAME("SnmpSetPort", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpSetPort", 2, "nPort"); // UINT
	ADD_PARAM_NAME("SnmpSetRetransmitMode", 1, "nRetransmitMode"); // smiUINT32
	ADD_PARAM_NAME("SnmpSetRetry", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpSetRetry", 2, "nPolicyRetry"); // smiUINT32
	ADD_PARAM_NAME("SnmpSetTimeout", 1, "hEntity"); // HSNMP_ENTITY
	ADD_PARAM_NAME("SnmpSetTimeout", 2, "nPolicyTimeout"); // smiTIMETICKS
	ADD_PARAM_NAME("SnmpSetTranslateMode", 1, "nTranslateMode"); // smiUINT32
	ADD_PARAM_NAME("SnmpSetVb", 1, "vbl"); // HSNMP_VBL
	ADD_PARAM_NAME("SnmpSetVb", 2, "index"); // smiUINT32
	ADD_PARAM_NAME("SnmpSetVb", 3, "name"); // smiLPCOID
	ADD_PARAM_NAME("SnmpSetVb", 4, "value"); // smiLPCVALUE
	ADD_PARAM_NAME("SnmpStartup", 1, "nMajorVersion"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartup", 2, "nMinorVersion"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartup", 3, "nLevel"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartup", 4, "nTranslateMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartup", 5, "nRetransmitMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartupEx", 1, "nMajorVersion"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartupEx", 2, "nMinorVersion"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartupEx", 3, "nLevel"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartupEx", 4, "nTranslateMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStartupEx", 5, "nRetransmitMode"); // smiLPUINT32
	ADD_PARAM_NAME("SnmpStrToContext", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpStrToContext", 2, "string"); // smiLPCOCTETS
	ADD_PARAM_NAME("SnmpStrToEntity", 1, "session"); // HSNMP_SESSION
	ADD_PARAM_NAME("SnmpStrToEntity", 2, "string"); // LPCSTR
	ADD_PARAM_NAME("SnmpStrToOid", 1, "string"); // LPCSTR
	ADD_PARAM_NAME("SnmpStrToOid", 2, "dstOID"); // smiLPOID
	ADD_PARAM_NAME("SpoolerFindClosePrinterChangeNotification", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 2, "fdwFlags"); // DWORD
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 3, "fdwOptions"); // DWORD
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 4, "phEvent"); // PHANDLE
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 5, "pPrinterNotifyOptions"); // PVOID
	ADD_PARAM_NAME("SpoolerFindFirstPrinterChangeNotification", 6, "pvReserved"); // PVOID
	ADD_PARAM_NAME("SpoolerFindNextPrinterChangeNotification", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SpoolerFindNextPrinterChangeNotification", 2, "pfdwChange"); // LPDWORD
	ADD_PARAM_NAME("SpoolerFindNextPrinterChangeNotification", 3, "pvReserved0"); // PVOID
	ADD_PARAM_NAME("SpoolerFindNextPrinterChangeNotification", 4, "ppPrinterNotifyInfo"); // PVOID
	ADD_PARAM_NAME("SpoolerFreePrinterNotifyInfo", 1, "pInfo"); // PPRINTER_NOTIFY_INFO
	ADD_PARAM_NAME("SpoolerRefreshPrinterChangeNotification", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("SpoolerRefreshPrinterChangeNotification", 2, "dwColor"); // DWORD
	ADD_PARAM_NAME("SpoolerRefreshPrinterChangeNotification", 3, "pOptions"); // PPRINTER_NOTIFY_OPTIONS
	ADD_PARAM_NAME("SpoolerRefreshPrinterChangeNotification", 4, "ppInfo"); // PPRINTER_NOTIFY_INFO *
	ADD_PARAM_NAME("StartDocA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("StartDocA", 2, "lpdi"); // CONST DOCINFOA *
	ADD_PARAM_NAME("StartDocPrinterA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("StartDocPrinterA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("StartDocPrinterA", 3, "pDocInfo"); // LPBYTE
	ADD_PARAM_NAME("StartDocPrinterW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("StartDocPrinterW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("StartDocPrinterW", 3, "pDocInfo"); // LPBYTE
	ADD_PARAM_NAME("StartDocW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("StartDocW", 2, "lpdi"); // CONST DOCINFOW *
	ADD_PARAM_NAME("StartPage", 1, "hdc"); // HDC
	ADD_PARAM_NAME("StartPagePrinter", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("StartServiceA", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("StartServiceA", 2, "dwNumServiceArgs"); // DWORD
	ADD_PARAM_NAME("StartServiceA", 3, "lpServiceArgVectors"); // LPCSTR *
	ADD_PARAM_NAME("StartServiceCtrlDispatcherA", 1, "lpServiceStartTable"); // CONST SERVICE_TABLE_ENTRYA *
	ADD_PARAM_NAME("StartServiceCtrlDispatcherW", 1, "lpServiceStartTable"); // CONST SERVICE_TABLE_ENTRYW *
	ADD_PARAM_NAME("StartServiceW", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("StartServiceW", 2, "dwNumServiceArgs"); // DWORD
	ADD_PARAM_NAME("StartServiceW", 3, "lpServiceArgVectors"); // LPCWSTR *
	ADD_PARAM_NAME("StartThreadpoolIo", 1, "pio"); // PTP_IO
	ADD_PARAM_NAME("StretchBlt", 1, "hdcDest"); // HDC
	ADD_PARAM_NAME("StretchBlt", 2, "xDest"); // int
	ADD_PARAM_NAME("StretchBlt", 3, "yDest"); // int
	ADD_PARAM_NAME("StretchBlt", 4, "wDest"); // int
	ADD_PARAM_NAME("StretchBlt", 5, "hDest"); // int
	ADD_PARAM_NAME("StretchBlt", 6, "hdcSrc"); // HDC
	ADD_PARAM_NAME("StretchBlt", 7, "xSrc"); // int
	ADD_PARAM_NAME("StretchBlt", 8, "ySrc"); // int
	ADD_PARAM_NAME("StretchBlt", 9, "wSrc"); // int
	ADD_PARAM_NAME("StretchBlt", 10, "hSrc"); // int
	ADD_PARAM_NAME("StretchBlt", 11, "rop"); // DWORD
	ADD_PARAM_NAME("StretchDIBits", 1, "hdc"); // HDC
	ADD_PARAM_NAME("StretchDIBits", 2, "xDest"); // int
	ADD_PARAM_NAME("StretchDIBits", 3, "yDest"); // int
	ADD_PARAM_NAME("StretchDIBits", 4, "DestWidth"); // int
	ADD_PARAM_NAME("StretchDIBits", 5, "DestHeight"); // int
	ADD_PARAM_NAME("StretchDIBits", 6, "xSrc"); // int
	ADD_PARAM_NAME("StretchDIBits", 7, "ySrc"); // int
	ADD_PARAM_NAME("StretchDIBits", 8, "SrcWidth"); // int
	ADD_PARAM_NAME("StretchDIBits", 9, "SrcHeight"); // int
	ADD_PARAM_NAME("StretchDIBits", 10, "lpBits"); // CONST VOID *
	ADD_PARAM_NAME("StretchDIBits", 11, "lpbmi"); // CONST BITMAPINFO *
	ADD_PARAM_NAME("StretchDIBits", 12, "iUsage"); // UINT
	ADD_PARAM_NAME("StretchDIBits", 13, "rop"); // DWORD
	ADD_PARAM_NAME("StrokeAndFillPath", 1, "hdc"); // HDC
	ADD_PARAM_NAME("StrokePath", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SubmitThreadpoolWork", 1, "pwk"); // PTP_WORK
	ADD_PARAM_NAME("SubtractRect", 1, "lprcDst"); // LPRECT
	ADD_PARAM_NAME("SubtractRect", 2, "lprcSrc1"); // CONST RECT *
	ADD_PARAM_NAME("SubtractRect", 3, "lprcSrc2"); // CONST RECT *
	ADD_PARAM_NAME("SuspendThread", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("SwapBuffers", 1, "hdc"); // HDC
	ADD_PARAM_NAME("SwapMouseButton", 1, "fSwap"); // WINBOOL
	ADD_PARAM_NAME("SwitchDesktop", 1, "hDesktop"); // HDESK
	ADD_PARAM_NAME("SwitchToFiber", 1, "lpFiber"); // LPVOID
	ADD_PARAM_NAME("SwitchToThisWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("SwitchToThisWindow", 2, "fUnknown"); // WINBOOL
	ADD_PARAM_NAME("SystemParametersInfoA", 1, "uiAction"); // UINT
	ADD_PARAM_NAME("SystemParametersInfoA", 2, "uiParam"); // UINT
	ADD_PARAM_NAME("SystemParametersInfoA", 3, "pvParam"); // PVOID
	ADD_PARAM_NAME("SystemParametersInfoA", 4, "fWinIni"); // UINT
	ADD_PARAM_NAME("SystemParametersInfoW", 1, "uiAction"); // UINT
	ADD_PARAM_NAME("SystemParametersInfoW", 2, "uiParam"); // UINT
	ADD_PARAM_NAME("SystemParametersInfoW", 3, "pvParam"); // PVOID
	ADD_PARAM_NAME("SystemParametersInfoW", 4, "fWinIni"); // UINT
	ADD_PARAM_NAME("SystemTimeToFileTime", 1, "lpSystemTime"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("SystemTimeToFileTime", 2, "lpFileTime"); // LPFILETIME
	ADD_PARAM_NAME("SystemTimeToTzSpecificLocalTime", 1, "lpTimeZoneInformation"); // LPTIME_ZONE_INFORMATION
	ADD_PARAM_NAME("SystemTimeToTzSpecificLocalTime", 2, "lpUniversalTime"); // LPSYSTEMTIME
	ADD_PARAM_NAME("SystemTimeToTzSpecificLocalTime", 3, "lpLocalTime"); // LPSYSTEMTIME
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
