/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/g1.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/g1.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with G
*        (first part).
*/
void initFuncParamNamesMap_G1(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("GdiAlphaBlend", 1, "hdcDest"); // HDC
	ADD_PARAM_NAME("GdiAlphaBlend", 2, "xoriginDest"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 3, "yoriginDest"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 4, "wDest"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 5, "hDest"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 6, "hdcSrc"); // HDC
	ADD_PARAM_NAME("GdiAlphaBlend", 7, "xoriginSrc"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 8, "yoriginSrc"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 9, "wSrc"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 10, "hSrc"); // int
	ADD_PARAM_NAME("GdiAlphaBlend", 11, "ftn"); // BLENDFUNCTION
	ADD_PARAM_NAME("GdiComment", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GdiComment", 2, "nSize"); // UINT
	ADD_PARAM_NAME("GdiComment", 3, "lpData"); // CONST BYTE *
	ADD_PARAM_NAME("GdiGradientFill", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GdiGradientFill", 2, "pVertex"); // PTRIVERTEX
	ADD_PARAM_NAME("GdiGradientFill", 3, "nVertex"); // ULONG
	ADD_PARAM_NAME("GdiGradientFill", 4, "pMesh"); // PVOID
	ADD_PARAM_NAME("GdiGradientFill", 5, "nMesh"); // ULONG
	ADD_PARAM_NAME("GdiGradientFill", 6, "ulMode"); // ULONG
	ADD_PARAM_NAME("GdiSetBatchLimit", 1, "dw"); // DWORD
	ADD_PARAM_NAME("GdiTransparentBlt", 1, "hdcDest"); // HDC
	ADD_PARAM_NAME("GdiTransparentBlt", 2, "xoriginDest"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 3, "yoriginDest"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 4, "wDest"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 5, "hDest"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 6, "hdcSrc"); // HDC
	ADD_PARAM_NAME("GdiTransparentBlt", 7, "xoriginSrc"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 8, "yoriginSrc"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 9, "wSrc"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 10, "hSrc"); // int
	ADD_PARAM_NAME("GdiTransparentBlt", 11, "crTransparent"); // UINT
	ADD_PARAM_NAME("GenerateConsoleCtrlEvent", 1, "dwCtrlEvent"); // DWORD
	ADD_PARAM_NAME("GenerateConsoleCtrlEvent", 2, "dwProcessGroupId"); // DWORD
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 1, "lpOutputBuffer"); // PVOID
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 2, "dwReceiveDataLength"); // DWORD
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 3, "dwLocalAddressLength"); // DWORD
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 4, "dwRemoteAddressLength"); // DWORD
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 5, "LocalSockaddr"); // struct sockaddr * *
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 6, "LocalSockaddrLength"); // LPINT
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 7, "RemoteSockaddr"); // struct sockaddr * *
	ADD_PARAM_NAME("GetAcceptExSockaddrs", 8, "RemoteSockaddrLength"); // LPINT
	ADD_PARAM_NAME("GetAce", 1, "pAcl"); // PACL
	ADD_PARAM_NAME("GetAce", 2, "dwAceIndex"); // DWORD
	ADD_PARAM_NAME("GetAce", 3, "pAce"); // LPVOID *
	ADD_PARAM_NAME("GetAclInformation", 1, "pAcl"); // PACL
	ADD_PARAM_NAME("GetAclInformation", 2, "pAclInformation"); // LPVOID
	ADD_PARAM_NAME("GetAclInformation", 3, "nAclInformationLength"); // DWORD
	ADD_PARAM_NAME("GetAclInformation", 4, "dwAclInformationClass"); // ACL_INFORMATION_CLASS
	ADD_PARAM_NAME("GetActiveProcessorCount", 1, "GroupNumber"); // WORD
	ADD_PARAM_NAME("GetAltTabInfoA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetAltTabInfoA", 2, "iItem"); // int
	ADD_PARAM_NAME("GetAltTabInfoA", 3, "pati"); // PALTTABINFO
	ADD_PARAM_NAME("GetAltTabInfoA", 4, "pszItemText"); // LPSTR
	ADD_PARAM_NAME("GetAltTabInfoA", 5, "cchItemText"); // UINT
	ADD_PARAM_NAME("GetAltTabInfoW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetAltTabInfoW", 2, "iItem"); // int
	ADD_PARAM_NAME("GetAltTabInfoW", 3, "pati"); // PALTTABINFO
	ADD_PARAM_NAME("GetAltTabInfoW", 4, "pszItemText"); // LPWSTR
	ADD_PARAM_NAME("GetAltTabInfoW", 5, "cchItemText"); // UINT
	ADD_PARAM_NAME("GetAncestor", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetAncestor", 2, "gaFlags"); // UINT
	ADD_PARAM_NAME("GetApplicationRecoveryCallback", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetApplicationRecoveryCallback", 2, "pRecoveryCallback"); // APPLICATION_RECOVERY_CALLBACK *
	ADD_PARAM_NAME("GetApplicationRecoveryCallback", 3, "ppvParameter"); // PVOID *
	ADD_PARAM_NAME("GetApplicationRecoveryCallback", 4, "dwPingInterval"); // DWORD
	ADD_PARAM_NAME("GetApplicationRecoveryCallback", 5, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetApplicationRestartSettings", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetApplicationRestartSettings", 2, "pwzCommandline"); // PWSTR
	ADD_PARAM_NAME("GetApplicationRestartSettings", 3, "pcchSize"); // PDWORD
	ADD_PARAM_NAME("GetApplicationRestartSettings", 4, "pdwFlags"); // PDWORD
	ADD_PARAM_NAME("GetArcDirection", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetAspectRatioFilterEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetAspectRatioFilterEx", 2, "lpsize"); // LPSIZE
	ADD_PARAM_NAME("GetAsyncKeyState", 1, "vKey"); // int
	ADD_PARAM_NAME("GetAtomNameA", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("GetAtomNameA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetAtomNameA", 3, "nSize"); // int
	ADD_PARAM_NAME("GetAtomNameW", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("GetAtomNameW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetAtomNameW", 3, "nSize"); // int
	ADD_PARAM_NAME("GetBinaryTypeA", 1, "lpApplicationName"); // LPCSTR
	ADD_PARAM_NAME("GetBinaryTypeA", 2, "lpBinaryType"); // LPDWORD
	ADD_PARAM_NAME("GetBinaryTypeW", 1, "lpApplicationName"); // LPCWSTR
	ADD_PARAM_NAME("GetBinaryTypeW", 2, "lpBinaryType"); // LPDWORD
	ADD_PARAM_NAME("GetBitmapBits", 1, "hbit"); // HBITMAP
	ADD_PARAM_NAME("GetBitmapBits", 2, "cb"); // LONG
	ADD_PARAM_NAME("GetBitmapBits", 3, "lpvBits"); // LPVOID
	ADD_PARAM_NAME("GetBitmapDimensionEx", 1, "hbit"); // HBITMAP
	ADD_PARAM_NAME("GetBitmapDimensionEx", 2, "lpsize"); // LPSIZE
	ADD_PARAM_NAME("GetBkColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetBkMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetBoundsRect", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetBoundsRect", 2, "lprect"); // LPRECT
	ADD_PARAM_NAME("GetBoundsRect", 3, "flags"); // UINT
	ADD_PARAM_NAME("GetBrushOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetBrushOrgEx", 2, "lppt"); // LPPOINT
	ADD_PARAM_NAME("GetCPInfo", 1, "CodePage"); // UINT
	ADD_PARAM_NAME("GetCPInfo", 2, "lpCPInfo"); // LPCPINFO
	ADD_PARAM_NAME("GetCPInfoExA", 1, "CodePage"); // UINT
	ADD_PARAM_NAME("GetCPInfoExA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetCPInfoExA", 3, "lpCPInfoEx"); // LPCPINFOEXA
	ADD_PARAM_NAME("GetCPInfoExW", 1, "CodePage"); // UINT
	ADD_PARAM_NAME("GetCPInfoExW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetCPInfoExW", 3, "lpCPInfoEx"); // LPCPINFOEXW
	ADD_PARAM_NAME("GetCalendarInfoA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetCalendarInfoA", 2, "Calendar"); // CALID
	ADD_PARAM_NAME("GetCalendarInfoA", 3, "CalType"); // CALTYPE
	ADD_PARAM_NAME("GetCalendarInfoA", 4, "lpCalData"); // LPSTR
	ADD_PARAM_NAME("GetCalendarInfoA", 5, "cchData"); // int
	ADD_PARAM_NAME("GetCalendarInfoA", 6, "lpValue"); // LPDWORD
	ADD_PARAM_NAME("GetCalendarInfoW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetCalendarInfoW", 2, "Calendar"); // CALID
	ADD_PARAM_NAME("GetCalendarInfoW", 3, "CalType"); // CALTYPE
	ADD_PARAM_NAME("GetCalendarInfoW", 4, "lpCalData"); // LPWSTR
	ADD_PARAM_NAME("GetCalendarInfoW", 5, "cchData"); // int
	ADD_PARAM_NAME("GetCalendarInfoW", 6, "lpValue"); // LPDWORD
	ADD_PARAM_NAME("GetCaretPos", 1, "lpPoint"); // LPPOINT
	ADD_PARAM_NAME("GetCharABCWidthsA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharABCWidthsA", 2, "wFirst"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsA", 3, "wLast"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsA", 4, "lpABC"); // LPABC
	ADD_PARAM_NAME("GetCharABCWidthsFloatA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharABCWidthsFloatA", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsFloatA", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsFloatA", 4, "lpABC"); // LPABCFLOAT
	ADD_PARAM_NAME("GetCharABCWidthsFloatW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharABCWidthsFloatW", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsFloatW", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsFloatW", 4, "lpABC"); // LPABCFLOAT
	ADD_PARAM_NAME("GetCharABCWidthsI", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharABCWidthsI", 2, "giFirst"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsI", 3, "cgi"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsI", 4, "pgi"); // LPWORD
	ADD_PARAM_NAME("GetCharABCWidthsI", 5, "pabc"); // LPABC
	ADD_PARAM_NAME("GetCharABCWidthsW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharABCWidthsW", 2, "wFirst"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsW", 3, "wLast"); // UINT
	ADD_PARAM_NAME("GetCharABCWidthsW", 4, "lpABC"); // LPABC
	ADD_PARAM_NAME("GetCharWidth32A", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidth32A", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidth32A", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidth32A", 4, "lpBuffer"); // LPINT
	ADD_PARAM_NAME("GetCharWidth32W", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidth32W", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidth32W", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidth32W", 4, "lpBuffer"); // LPINT
	ADD_PARAM_NAME("GetCharWidthA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidthA", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidthA", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidthA", 4, "lpBuffer"); // LPINT
	ADD_PARAM_NAME("GetCharWidthFloatA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidthFloatA", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidthFloatA", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidthFloatA", 4, "lpBuffer"); // PFLOAT
	ADD_PARAM_NAME("GetCharWidthFloatW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidthFloatW", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidthFloatW", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidthFloatW", 4, "lpBuffer"); // PFLOAT
	ADD_PARAM_NAME("GetCharWidthI", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidthI", 2, "giFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidthI", 3, "cgi"); // UINT
	ADD_PARAM_NAME("GetCharWidthI", 4, "pgi"); // LPWORD
	ADD_PARAM_NAME("GetCharWidthI", 5, "piWidths"); // LPINT
	ADD_PARAM_NAME("GetCharWidthW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharWidthW", 2, "iFirst"); // UINT
	ADD_PARAM_NAME("GetCharWidthW", 3, "iLast"); // UINT
	ADD_PARAM_NAME("GetCharWidthW", 4, "lpBuffer"); // LPINT
	ADD_PARAM_NAME("GetCharacterPlacementA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharacterPlacementA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GetCharacterPlacementA", 3, "nCount"); // int
	ADD_PARAM_NAME("GetCharacterPlacementA", 4, "nMexExtent"); // int
	ADD_PARAM_NAME("GetCharacterPlacementA", 5, "lpResults"); // LPGCP_RESULTSA
	ADD_PARAM_NAME("GetCharacterPlacementA", 6, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetCharacterPlacementW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCharacterPlacementW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetCharacterPlacementW", 3, "nCount"); // int
	ADD_PARAM_NAME("GetCharacterPlacementW", 4, "nMexExtent"); // int
	ADD_PARAM_NAME("GetCharacterPlacementW", 5, "lpResults"); // LPGCP_RESULTSW
	ADD_PARAM_NAME("GetCharacterPlacementW", 6, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetClassInfoA", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("GetClassInfoA", 2, "lpClassName"); // LPCSTR
	ADD_PARAM_NAME("GetClassInfoA", 3, "lpWndClass"); // LPWNDCLASSA
	ADD_PARAM_NAME("GetClassInfoExA", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("GetClassInfoExA", 2, "lpszClass"); // LPCSTR
	ADD_PARAM_NAME("GetClassInfoExA", 3, "lpwcx"); // LPWNDCLASSEXA
	ADD_PARAM_NAME("GetClassInfoExW", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("GetClassInfoExW", 2, "lpszClass"); // LPCWSTR
	ADD_PARAM_NAME("GetClassInfoExW", 3, "lpwcx"); // LPWNDCLASSEXW
	ADD_PARAM_NAME("GetClassInfoW", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("GetClassInfoW", 2, "lpClassName"); // LPCWSTR
	ADD_PARAM_NAME("GetClassInfoW", 3, "lpWndClass"); // LPWNDCLASSW
	ADD_PARAM_NAME("GetClassLongA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassLongA", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetClassLongPtrA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassLongPtrA", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetClassLongPtrW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassLongPtrW", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetClassLongW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassLongW", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetClassNameA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassNameA", 2, "lpClassName"); // LPSTR
	ADD_PARAM_NAME("GetClassNameA", 3, "nMaxCount"); // int
	ADD_PARAM_NAME("GetClassNameW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassNameW", 2, "lpClassName"); // LPWSTR
	ADD_PARAM_NAME("GetClassNameW", 3, "nMaxCount"); // int
	ADD_PARAM_NAME("GetClassWord", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClassWord", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetClientRect", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetClientRect", 2, "lpRect"); // LPRECT
	ADD_PARAM_NAME("GetClipBox", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetClipBox", 2, "lprect"); // LPRECT
	ADD_PARAM_NAME("GetClipCursor", 1, "lpRect"); // LPRECT
	ADD_PARAM_NAME("GetClipRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetClipRgn", 2, "hrgn"); // HRGN
	ADD_PARAM_NAME("GetClipboardData", 1, "uFormat"); // UINT
	ADD_PARAM_NAME("GetClipboardFormatNameA", 1, "format"); // UINT
	ADD_PARAM_NAME("GetClipboardFormatNameA", 2, "lpszFormatName"); // LPSTR
	ADD_PARAM_NAME("GetClipboardFormatNameA", 3, "cchMaxCount"); // int
	ADD_PARAM_NAME("GetClipboardFormatNameW", 1, "format"); // UINT
	ADD_PARAM_NAME("GetClipboardFormatNameW", 2, "lpszFormatName"); // LPWSTR
	ADD_PARAM_NAME("GetClipboardFormatNameW", 3, "cchMaxCount"); // int
	ADD_PARAM_NAME("GetColorAdjustment", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetColorAdjustment", 2, "lpca"); // LPCOLORADJUSTMENT
	ADD_PARAM_NAME("GetColorSpace", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetComboBoxInfo", 1, "hwndCombo"); // HWND
	ADD_PARAM_NAME("GetComboBoxInfo", 2, "pcbi"); // PCOMBOBOXINFO
	ADD_PARAM_NAME("GetCommConfig", 1, "hCommDev"); // HANDLE
	ADD_PARAM_NAME("GetCommConfig", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("GetCommConfig", 3, "lpdwSize"); // LPDWORD
	ADD_PARAM_NAME("GetCommMask", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetCommMask", 2, "lpEvtMask"); // LPDWORD
	ADD_PARAM_NAME("GetCommModemStatus", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetCommModemStatus", 2, "lpModemStat"); // LPDWORD
	ADD_PARAM_NAME("GetCommProperties", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetCommProperties", 2, "lpCommProp"); // LPCOMMPROP
	ADD_PARAM_NAME("GetCommState", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetCommState", 2, "lpDCB"); // LPDCB
	ADD_PARAM_NAME("GetCommTimeouts", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetCommTimeouts", 2, "lpCommTimeouts"); // LPCOMMTIMEOUTS
	ADD_PARAM_NAME("GetCompressedFileSizeA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetCompressedFileSizeA", 2, "lpFileSizeHigh"); // LPDWORD
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedA", 1, "lpFileName"); // LPCTSTR
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedA", 2, "lpFileSizeHigh"); // LPDWORD
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedA", 3, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedW", 2, "lpFileSizeHigh"); // LPDWORD
	ADD_PARAM_NAME("GetCompressedFileSizeTransactedW", 3, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetCompressedFileSizeW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetCompressedFileSizeW", 2, "lpFileSizeHigh"); // LPDWORD
	ADD_PARAM_NAME("GetComputerNameA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetComputerNameA", 2, "nSize"); // LPDWORD
	ADD_PARAM_NAME("GetComputerNameExA", 1, "NameType"); // COMPUTER_NAME_FORMAT
	ADD_PARAM_NAME("GetComputerNameExA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetComputerNameExA", 3, "nSize"); // LPDWORD
	ADD_PARAM_NAME("GetComputerNameExW", 1, "NameType"); // COMPUTER_NAME_FORMAT
	ADD_PARAM_NAME("GetComputerNameExW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetComputerNameExW", 3, "nSize"); // LPDWORD
	ADD_PARAM_NAME("GetComputerNameW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetComputerNameW", 2, "nSize"); // LPDWORD
	ADD_PARAM_NAME("GetConsoleAliasA", 1, "Source"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasA", 2, "TargetBuffer"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasA", 3, "TargetBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasA", 4, "ExeName"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasExesA", 1, "ExeNameBuffer"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasExesA", 2, "ExeNameBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasExesW", 1, "ExeNameBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasExesW", 2, "ExeNameBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasW", 1, "Source"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasW", 2, "TargetBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasW", 3, "TargetBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasW", 4, "ExeName"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasesA", 1, "AliasBuffer"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasesA", 2, "AliasBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasesA", 3, "ExeName"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasesLengthA", 1, "ExeName"); // LPSTR
	ADD_PARAM_NAME("GetConsoleAliasesLengthW", 1, "ExeName"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasesW", 1, "AliasBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleAliasesW", 2, "AliasBufferLength"); // DWORD
	ADD_PARAM_NAME("GetConsoleAliasesW", 3, "ExeName"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleCursorInfo", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetConsoleCursorInfo", 2, "lpConsoleCursorInfo"); // PCONSOLE_CURSOR_INFO
	ADD_PARAM_NAME("GetConsoleDisplayMode", 1, "lpModeFlags"); // LPDWORD
	ADD_PARAM_NAME("GetConsoleFontSize", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetConsoleFontSize", 2, "nFont"); // DWORD
	ADD_PARAM_NAME("GetConsoleHistoryInfo", 1, "lpConsoleHistoryInfo"); // PCONSOLE_HISTORY_INFO
	ADD_PARAM_NAME("GetConsoleMode", 1, "hConsoleHandle"); // HANDLE
	ADD_PARAM_NAME("GetConsoleMode", 2, "lpMode"); // LPDWORD
	ADD_PARAM_NAME("GetConsoleOriginalTitleA", 1, "lpConsoleTitle"); // LPSTR
	ADD_PARAM_NAME("GetConsoleOriginalTitleA", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetConsoleOriginalTitleW", 1, "lpConsoleTitle"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleOriginalTitleW", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetConsoleProcessList", 1, "lpdwProcessList"); // LPDWORD
	ADD_PARAM_NAME("GetConsoleProcessList", 2, "dwProcessCount"); // DWORD
	ADD_PARAM_NAME("GetConsoleScreenBufferInfo", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetConsoleScreenBufferInfo", 2, "lpConsoleScreenBufferInfo"); // PCONSOLE_SCREEN_BUFFER_INFO
	ADD_PARAM_NAME("GetConsoleScreenBufferInfoEx", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetConsoleScreenBufferInfoEx", 2, "lpConsoleScreenBufferInfoEx"); // PCONSOLE_SCREEN_BUFFER_INFOEX
	ADD_PARAM_NAME("GetConsoleSelectionInfo", 1, "lpConsoleSelectionInfo"); // PCONSOLE_SELECTION_INFO
	ADD_PARAM_NAME("GetConsoleTitleA", 1, "lpConsoleTitle"); // LPSTR
	ADD_PARAM_NAME("GetConsoleTitleA", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetConsoleTitleW", 1, "lpConsoleTitle"); // LPWSTR
	ADD_PARAM_NAME("GetConsoleTitleW", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetCorePrinterDriversA", 1, "pszServer"); // LPCSTR
	ADD_PARAM_NAME("GetCorePrinterDriversA", 2, "pszEnvironment"); // LPCSTR
	ADD_PARAM_NAME("GetCorePrinterDriversA", 3, "pszzCoreDriverDependencies"); // LPCSTR
	ADD_PARAM_NAME("GetCorePrinterDriversA", 4, "cCorePrinterDrivers"); // DWORD
	ADD_PARAM_NAME("GetCorePrinterDriversA", 5, "pCorePrinterDrivers"); // PCORE_PRINTER_DRIVERA
	ADD_PARAM_NAME("GetCorePrinterDriversW", 1, "pszServer"); // LPCWSTR
	ADD_PARAM_NAME("GetCorePrinterDriversW", 2, "pszEnvironment"); // LPCWSTR
	ADD_PARAM_NAME("GetCorePrinterDriversW", 3, "pszzCoreDriverDependencies"); // LPCWSTR
	ADD_PARAM_NAME("GetCorePrinterDriversW", 4, "cCorePrinterDrivers"); // DWORD
	ADD_PARAM_NAME("GetCorePrinterDriversW", 5, "pCorePrinterDrivers"); // PCORE_PRINTER_DRIVERW
	ADD_PARAM_NAME("GetCurrencyFormatA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetCurrencyFormatA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetCurrencyFormatA", 3, "lpValue"); // LPCSTR
	ADD_PARAM_NAME("GetCurrencyFormatA", 4, "lpFormat"); // CONST CURRENCYFMTA *
	ADD_PARAM_NAME("GetCurrencyFormatA", 5, "lpCurrencyStr"); // LPSTR
	ADD_PARAM_NAME("GetCurrencyFormatA", 6, "cchCurrency"); // int
	ADD_PARAM_NAME("GetCurrencyFormatW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetCurrencyFormatW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetCurrencyFormatW", 3, "lpValue"); // LPCWSTR
	ADD_PARAM_NAME("GetCurrencyFormatW", 4, "lpFormat"); // CONST CURRENCYFMTW *
	ADD_PARAM_NAME("GetCurrencyFormatW", 5, "lpCurrencyStr"); // LPWSTR
	ADD_PARAM_NAME("GetCurrencyFormatW", 6, "cchCurrency"); // int
	ADD_PARAM_NAME("GetCurrentActCtx", 1, "lphActCtx"); // HANDLE *
	ADD_PARAM_NAME("GetCurrentConsoleFont", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetCurrentConsoleFont", 2, "bMaximumWindow"); // WINBOOL
	ADD_PARAM_NAME("GetCurrentConsoleFont", 3, "lpConsoleCurrentFont"); // PCONSOLE_FONT_INFO
	ADD_PARAM_NAME("GetCurrentConsoleFontEx", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetCurrentConsoleFontEx", 2, "bMaximumWindow"); // WINBOOL
	ADD_PARAM_NAME("GetCurrentConsoleFontEx", 3, "lpConsoleCurrentFontEx"); // PCONSOLE_FONT_INFOEX
	ADD_PARAM_NAME("GetCurrentDirectoryA", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetCurrentDirectoryA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetCurrentDirectoryW", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetCurrentDirectoryW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetCurrentHwProfileA", 1, "lpHwProfileInfo"); // LPHW_PROFILE_INFOA
	ADD_PARAM_NAME("GetCurrentHwProfileW", 1, "lpHwProfileInfo"); // LPHW_PROFILE_INFOW
	ADD_PARAM_NAME("GetCurrentObject", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCurrentObject", 2, "type"); // UINT
	ADD_PARAM_NAME("GetCurrentPositionEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetCurrentPositionEx", 2, "lppt"); // LPPOINT
	ADD_PARAM_NAME("GetCurrentProcessorNumberEx", 1, "ProcNumber"); // PPROCESSOR_NUMBER
	ADD_PARAM_NAME("GetCursorInfo", 1, "pci"); // PCURSORINFO
	ADD_PARAM_NAME("GetCursorPos", 1, "lpPoint"); // LPPOINT
	ADD_PARAM_NAME("GetDC", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetDCBrushColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDCEx", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetDCEx", 2, "hrgnClip"); // HRGN
	ADD_PARAM_NAME("GetDCEx", 3, "flags"); // DWORD
	ADD_PARAM_NAME("GetDCOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDCOrgEx", 2, "lppt"); // LPPOINT
	ADD_PARAM_NAME("GetDCPenColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDIBColorTable", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDIBColorTable", 2, "iStart"); // UINT
	ADD_PARAM_NAME("GetDIBColorTable", 3, "cEntries"); // UINT
	ADD_PARAM_NAME("GetDIBColorTable", 4, "prgbq"); // RGBQUAD *
	ADD_PARAM_NAME("GetDIBits", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDIBits", 2, "hbm"); // HBITMAP
	ADD_PARAM_NAME("GetDIBits", 3, "start"); // UINT
	ADD_PARAM_NAME("GetDIBits", 4, "cLines"); // UINT
	ADD_PARAM_NAME("GetDIBits", 5, "lpvBits"); // LPVOID
	ADD_PARAM_NAME("GetDIBits", 6, "lpbmi"); // LPBITMAPINFO
	ADD_PARAM_NAME("GetDIBits", 7, "usage"); // UINT
	ADD_PARAM_NAME("GetDateFormatA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetDateFormatA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetDateFormatA", 3, "lpDate"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("GetDateFormatA", 4, "lpFormat"); // LPCSTR
	ADD_PARAM_NAME("GetDateFormatA", 5, "lpDateStr"); // LPSTR
	ADD_PARAM_NAME("GetDateFormatA", 6, "cchDate"); // int
	ADD_PARAM_NAME("GetDateFormatEx", 1, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetDateFormatEx", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetDateFormatEx", 3, "lpDate"); // const SYSTEMTIME *
	ADD_PARAM_NAME("GetDateFormatEx", 4, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetDateFormatEx", 5, "lpDateStr"); // LPWSTR
	ADD_PARAM_NAME("GetDateFormatEx", 6, "cchDate"); // int
	ADD_PARAM_NAME("GetDateFormatEx", 7, "lpCalendar"); // LPCWSTR
	ADD_PARAM_NAME("GetDateFormatW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetDateFormatW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetDateFormatW", 3, "lpDate"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("GetDateFormatW", 4, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetDateFormatW", 5, "lpDateStr"); // LPWSTR
	ADD_PARAM_NAME("GetDateFormatW", 6, "cchDate"); // int
	ADD_PARAM_NAME("GetDefaultCommConfigA", 1, "lpszName"); // LPCSTR
	ADD_PARAM_NAME("GetDefaultCommConfigA", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("GetDefaultCommConfigA", 3, "lpdwSize"); // LPDWORD
	ADD_PARAM_NAME("GetDefaultCommConfigW", 1, "lpszName"); // LPCWSTR
	ADD_PARAM_NAME("GetDefaultCommConfigW", 2, "lpCC"); // LPCOMMCONFIG
	ADD_PARAM_NAME("GetDefaultCommConfigW", 3, "lpdwSize"); // LPDWORD
	ADD_PARAM_NAME("GetDefaultPrinterA", 1, "pszBuffer"); // LPSTR
	ADD_PARAM_NAME("GetDefaultPrinterA", 2, "pcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetDefaultPrinterW", 1, "pszBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetDefaultPrinterW", 2, "pcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetDeviceCaps", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDeviceCaps", 2, "index"); // int
	ADD_PARAM_NAME("GetDeviceGammaRamp", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetDeviceGammaRamp", 2, "lpRamp"); // LPVOID
	ADD_PARAM_NAME("GetDevicePowerState", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetDevicePowerState", 2, "pfOn"); // WINBOOL *
	ADD_PARAM_NAME("GetDiskFreeSpaceA", 1, "lpRootPathName"); // LPCSTR
	ADD_PARAM_NAME("GetDiskFreeSpaceA", 2, "lpSectorsPerCluster"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceA", 3, "lpBytesPerSector"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceA", 4, "lpNumberOfFreeClusters"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceA", 5, "lpTotalNumberOfClusters"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceExA", 1, "lpDirectoryName"); // LPCSTR
	ADD_PARAM_NAME("GetDiskFreeSpaceExA", 2, "lpFreeBytesAvailableToCaller"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceExA", 3, "lpTotalNumberOfBytes"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceExA", 4, "lpTotalNumberOfFreeBytes"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceExW", 1, "lpDirectoryName"); // LPCWSTR
	ADD_PARAM_NAME("GetDiskFreeSpaceExW", 2, "lpFreeBytesAvailableToCaller"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceExW", 3, "lpTotalNumberOfBytes"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceExW", 4, "lpTotalNumberOfFreeBytes"); // PULARGE_INTEGER
	ADD_PARAM_NAME("GetDiskFreeSpaceW", 1, "lpRootPathName"); // LPCWSTR
	ADD_PARAM_NAME("GetDiskFreeSpaceW", 2, "lpSectorsPerCluster"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceW", 3, "lpBytesPerSector"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceW", 4, "lpNumberOfFreeClusters"); // LPDWORD
	ADD_PARAM_NAME("GetDiskFreeSpaceW", 5, "lpTotalNumberOfClusters"); // LPDWORD
	// ADD_PARAM_NAME("GetDiskInfoA", 1, "?"); // PCSTR
	// ADD_PARAM_NAME("GetDiskInfoA", 2, "?"); // PDWORD
	// ADD_PARAM_NAME("GetDiskInfoA", 3, "?"); // PDWORDLONG
	// ADD_PARAM_NAME("GetDiskInfoA", 4, "?"); // PDWORDLONG
	ADD_PARAM_NAME("GetDlgCtrlID", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetDlgItem", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetDlgItem", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("GetDlgItemInt", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetDlgItemInt", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("GetDlgItemInt", 3, "lpTranslated"); // WINBOOL *
	ADD_PARAM_NAME("GetDlgItemInt", 4, "bSigned"); // WINBOOL
	ADD_PARAM_NAME("GetDlgItemTextA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetDlgItemTextA", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("GetDlgItemTextA", 3, "lpString"); // LPSTR
	ADD_PARAM_NAME("GetDlgItemTextA", 4, "cchMax"); // int
	ADD_PARAM_NAME("GetDlgItemTextW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetDlgItemTextW", 2, "nIDDlgItem"); // int
	ADD_PARAM_NAME("GetDlgItemTextW", 3, "lpString"); // LPWSTR
	ADD_PARAM_NAME("GetDlgItemTextW", 4, "cchMax"); // int
	ADD_PARAM_NAME("GetDllDirectoryA", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetDllDirectoryA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetDllDirectoryW", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetDllDirectoryW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetDriveTypeA", 1, "lpRootPathName"); // LPCSTR
	ADD_PARAM_NAME("GetDriveTypeW", 1, "lpRootPathName"); // LPCWSTR
	ADD_PARAM_NAME("GetDurationFormat", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetDurationFormat", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetDurationFormat", 3, "lpDuration"); // const SYSTEMTIME *
	ADD_PARAM_NAME("GetDurationFormat", 4, "ullDuration"); // ULONGLONG
	ADD_PARAM_NAME("GetDurationFormat", 5, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetDurationFormat", 6, "lpDurationStr"); // LPWSTR
	ADD_PARAM_NAME("GetDurationFormat", 7, "cchDuration"); // int
	ADD_PARAM_NAME("GetDurationFormatEx", 1, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetDurationFormatEx", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetDurationFormatEx", 3, "lpDuration"); // const SYSTEMTIME *
	ADD_PARAM_NAME("GetDurationFormatEx", 4, "ullDuration"); // ULONGLONG
	ADD_PARAM_NAME("GetDurationFormatEx", 5, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetDurationFormatEx", 6, "lpDurationStr"); // LPWSTR
	ADD_PARAM_NAME("GetDurationFormatEx", 7, "cchDuration"); // int
	ADD_PARAM_NAME("GetDynamicTimeZoneInformation", 1, "pTimeZoneInformation"); // PDYNAMIC_TIME_ZONE_INFORMATION
	ADD_PARAM_NAME("GetEnhMetaFileA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("GetEnhMetaFileBits", 1, "hEMF"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFileBits", 2, "nSize"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFileBits", 3, "lpData"); // LPBYTE
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionA", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionA", 2, "cchBuffer"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionA", 3, "lpDescription"); // LPSTR
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionW", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionW", 2, "cchBuffer"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFileDescriptionW", 3, "lpDescription"); // LPWSTR
	ADD_PARAM_NAME("GetEnhMetaFileHeader", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFileHeader", 2, "nSize"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFileHeader", 3, "lpEnhMetaHeader"); // LPENHMETAHEADER
	ADD_PARAM_NAME("GetEnhMetaFilePaletteEntries", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFilePaletteEntries", 2, "nNumEntries"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFilePaletteEntries", 3, "lpPaletteEntries"); // LPPALETTEENTRY
	ADD_PARAM_NAME("GetEnhMetaFilePixelFormat", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetEnhMetaFilePixelFormat", 2, "cbBuffer"); // UINT
	ADD_PARAM_NAME("GetEnhMetaFilePixelFormat", 3, "ppfd"); // PIXELFORMATDESCRIPTOR *
	ADD_PARAM_NAME("GetEnhMetaFileW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("GetEnvironmentVariableA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("GetEnvironmentVariableA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetEnvironmentVariableA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetEnvironmentVariableW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("GetEnvironmentVariableW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetEnvironmentVariableW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetEventLogInformation", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("GetEventLogInformation", 2, "dwInfoLevel"); // DWORD
	ADD_PARAM_NAME("GetEventLogInformation", 3, "lpBuffer"); // LPVOID
	ADD_PARAM_NAME("GetEventLogInformation", 4, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("GetEventLogInformation", 5, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetExitCodeProcess", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetExitCodeProcess", 2, "lpExitCode"); // LPDWORD
	ADD_PARAM_NAME("GetExitCodeThread", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetExitCodeThread", 2, "lpExitCode"); // LPDWORD
	ADD_PARAM_NAME("GetFileAttributesA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFileAttributesExA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFileAttributesExA", 2, "fInfoLevelId"); // GET_FILEEX_INFO_LEVELS
	ADD_PARAM_NAME("GetFileAttributesExA", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("GetFileAttributesExW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFileAttributesExW", 2, "fInfoLevelId"); // GET_FILEEX_INFO_LEVELS
	ADD_PARAM_NAME("GetFileAttributesExW", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("GetFileAttributesTransactedA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFileAttributesTransactedA", 2, "fInfoLevelId"); // GET_FILEEX_INFO_LEVELS
	ADD_PARAM_NAME("GetFileAttributesTransactedA", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("GetFileAttributesTransactedA", 4, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetFileAttributesTransactedW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFileAttributesTransactedW", 2, "fInfoLevelId"); // GET_FILEEX_INFO_LEVELS
	ADD_PARAM_NAME("GetFileAttributesTransactedW", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("GetFileAttributesTransactedW", 4, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetFileAttributesW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFileBandwidthReservation", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileBandwidthReservation", 2, "lpPeriodMilliseconds"); // LPDWORD
	ADD_PARAM_NAME("GetFileBandwidthReservation", 3, "lpBytesPerPeriod"); // LPDWORD
	ADD_PARAM_NAME("GetFileBandwidthReservation", 4, "pDiscardable"); // LPBOOL
	ADD_PARAM_NAME("GetFileBandwidthReservation", 5, "lpTransferSize"); // LPDWORD
	ADD_PARAM_NAME("GetFileBandwidthReservation", 6, "lpNumOutstandingRequests"); // LPDWORD
	ADD_PARAM_NAME("GetFileInformationByHandle", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileInformationByHandle", 2, "lpFileInformation"); // LPBY_HANDLE_FILE_INFORMATION
	ADD_PARAM_NAME("GetFileInformationByHandleEx", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileInformationByHandleEx", 2, "FileInformationClass"); // FILE_INFO_BY_HANDLE_CLASS
	ADD_PARAM_NAME("GetFileInformationByHandleEx", 3, "lpFileInformation"); // LPVOID
	ADD_PARAM_NAME("GetFileInformationByHandleEx", 4, "dwBufferSize"); // DWORD
	ADD_PARAM_NAME("GetFileMUIInfo", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetFileMUIInfo", 2, "pcwszFilePath"); // PCWSTR
	ADD_PARAM_NAME("GetFileMUIInfo", 3, "pFileMUIInfo"); // PFILEMUIINFO
	ADD_PARAM_NAME("GetFileMUIInfo", 4, "pcbFileMUIInfo"); // DWORD *
	ADD_PARAM_NAME("GetFileMUIPath", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetFileMUIPath", 2, "pcwszFilePath"); // PCWSTR
	ADD_PARAM_NAME("GetFileMUIPath", 3, "pwszLanguage"); // PWSTR
	ADD_PARAM_NAME("GetFileMUIPath", 4, "pcchLanguage"); // PULONG
	ADD_PARAM_NAME("GetFileMUIPath", 5, "pwszFileMUIPath"); // PWSTR
	ADD_PARAM_NAME("GetFileMUIPath", 6, "pcchFileMUIPath"); // PULONG
	ADD_PARAM_NAME("GetFileMUIPath", 7, "pululEnumerator"); // PULONGLONG
	ADD_PARAM_NAME("GetFileSecurityA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFileSecurityA", 2, "RequestedInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("GetFileSecurityA", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetFileSecurityA", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetFileSecurityA", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetFileSecurityW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFileSecurityW", 2, "RequestedInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("GetFileSecurityW", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetFileSecurityW", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetFileSecurityW", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetFileSize", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileSize", 2, "lpFileSizeHigh"); // LPDWORD
	ADD_PARAM_NAME("GetFileSizeEx", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileSizeEx", 2, "lpFileSize"); // PLARGE_INTEGER
	ADD_PARAM_NAME("GetFileTime", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileTime", 2, "lpCreationTime"); // LPFILETIME
	ADD_PARAM_NAME("GetFileTime", 3, "lpLastAccessTime"); // LPFILETIME
	ADD_PARAM_NAME("GetFileTime", 4, "lpLastWriteTime"); // LPFILETIME
	ADD_PARAM_NAME("GetFileType", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFileVersionInfoA", 1, "lptstrFilename"); // LPCSTR
	ADD_PARAM_NAME("GetFileVersionInfoA", 2, "dwHandle"); // DWORD
	ADD_PARAM_NAME("GetFileVersionInfoA", 3, "dwLen"); // DWORD
	ADD_PARAM_NAME("GetFileVersionInfoA", 4, "lpData"); // LPVOID
	ADD_PARAM_NAME("GetFileVersionInfoSizeA", 1, "lptstrFilename"); // LPCSTR
	ADD_PARAM_NAME("GetFileVersionInfoSizeA", 2, "lpdwHandle"); // LPDWORD
	ADD_PARAM_NAME("GetFileVersionInfoSizeW", 1, "lptstrFilename"); // LPCWSTR
	ADD_PARAM_NAME("GetFileVersionInfoSizeW", 2, "lpdwHandle"); // LPDWORD
	ADD_PARAM_NAME("GetFileVersionInfoW", 1, "lptstrFilename"); // LPCWSTR
	ADD_PARAM_NAME("GetFileVersionInfoW", 2, "dwHandle"); // DWORD
	ADD_PARAM_NAME("GetFileVersionInfoW", 3, "dwLen"); // DWORD
	ADD_PARAM_NAME("GetFileVersionInfoW", 4, "lpData"); // LPVOID
	ADD_PARAM_NAME("GetFinalPathNameByHandleA", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFinalPathNameByHandleA", 2, "lpszFilePath"); // LPSTR
	ADD_PARAM_NAME("GetFinalPathNameByHandleA", 3, "cchFilePath"); // DWORD
	ADD_PARAM_NAME("GetFinalPathNameByHandleA", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetFinalPathNameByHandleW", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetFinalPathNameByHandleW", 2, "lpszFilePath"); // LPWSTR
	ADD_PARAM_NAME("GetFinalPathNameByHandleW", 3, "cchFilePath"); // DWORD
	ADD_PARAM_NAME("GetFinalPathNameByHandleW", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableA", 2, "lpGuid"); // LPCSTR
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableA", 3, "pBuffer"); // PVOID
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableA", 4, "nSize"); // DWORD
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableW", 2, "lpGuid"); // LPCWSTR
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableW", 3, "pBuffer"); // PVOID
	ADD_PARAM_NAME("GetFirmwareEnvironmentVariableW", 4, "nSize"); // DWORD
	ADD_PARAM_NAME("GetFontData", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetFontData", 2, "dwTable"); // DWORD
	ADD_PARAM_NAME("GetFontData", 3, "dwOffset"); // DWORD
	ADD_PARAM_NAME("GetFontData", 4, "pvBuffer"); // PVOID
	ADD_PARAM_NAME("GetFontData", 5, "cjBuffer"); // DWORD
	ADD_PARAM_NAME("GetFontLanguageInfo", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetFontUnicodeRanges", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetFontUnicodeRanges", 2, "lpgs"); // LPGLYPHSET
	ADD_PARAM_NAME("GetFormA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetFormA", 2, "pFormName"); // LPSTR
	ADD_PARAM_NAME("GetFormA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetFormA", 4, "pForm"); // LPBYTE
	ADD_PARAM_NAME("GetFormA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetFormA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetFormW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetFormW", 2, "pFormName"); // LPWSTR
	ADD_PARAM_NAME("GetFormW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetFormW", 4, "pForm"); // LPBYTE
	ADD_PARAM_NAME("GetFormW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetFormW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetFullPathNameA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFullPathNameA", 2, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetFullPathNameA", 3, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetFullPathNameA", 4, "lpFilePart"); // LPSTR *
	ADD_PARAM_NAME("GetFullPathNameTransactedA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetFullPathNameTransactedA", 2, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetFullPathNameTransactedA", 3, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetFullPathNameTransactedA", 4, "lpFilePart"); // LPSTR *
	ADD_PARAM_NAME("GetFullPathNameTransactedA", 5, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetFullPathNameTransactedW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFullPathNameTransactedW", 2, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetFullPathNameTransactedW", 3, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetFullPathNameTransactedW", 4, "lpFilePart"); // LPWSTR *
	ADD_PARAM_NAME("GetFullPathNameTransactedW", 5, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetFullPathNameW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetFullPathNameW", 2, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetFullPathNameW", 3, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetFullPathNameW", 4, "lpFilePart"); // LPWSTR *
	ADD_PARAM_NAME("GetGUIThreadInfo", 1, "idThread"); // DWORD
	ADD_PARAM_NAME("GetGUIThreadInfo", 2, "pgui"); // PGUITHREADINFO
	ADD_PARAM_NAME("GetGeoInfoA", 1, "Location"); // GEOID
	ADD_PARAM_NAME("GetGeoInfoA", 2, "GeoType"); // GEOTYPE
	ADD_PARAM_NAME("GetGeoInfoA", 3, "lpGeoData"); // LPSTR
	ADD_PARAM_NAME("GetGeoInfoA", 4, "cchData"); // int
	ADD_PARAM_NAME("GetGeoInfoA", 5, "LangId"); // LANGID
	ADD_PARAM_NAME("GetGeoInfoW", 1, "Location"); // GEOID
	ADD_PARAM_NAME("GetGeoInfoW", 2, "GeoType"); // GEOTYPE
	ADD_PARAM_NAME("GetGeoInfoW", 3, "lpGeoData"); // LPWSTR
	ADD_PARAM_NAME("GetGeoInfoW", 4, "cchData"); // int
	ADD_PARAM_NAME("GetGeoInfoW", 5, "LangId"); // LANGID
	ADD_PARAM_NAME("GetGestureConfig", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetGestureConfig", 2, "dwReserved"); // DWORD
	ADD_PARAM_NAME("GetGestureConfig", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetGestureConfig", 4, "pcIDs"); // PUINT
	ADD_PARAM_NAME("GetGestureConfig", 5, "pGestureConfig"); // PGESTURECONFIG
	ADD_PARAM_NAME("GetGestureConfig", 6, "cbSize"); // UINT
	ADD_PARAM_NAME("GetGestureExtraArgs", 1, "hGestureInfo"); // HGESTUREINFO
	ADD_PARAM_NAME("GetGestureExtraArgs", 2, "cbExtraArgs"); // UINT
	ADD_PARAM_NAME("GetGestureExtraArgs", 3, "pExtraArgs"); // PBYTE
	ADD_PARAM_NAME("GetGestureInfo", 1, "hGestureInfo"); // HGESTUREINFO
	ADD_PARAM_NAME("GetGestureInfo", 2, "pGestureInfo"); // PGESTUREINFO
	ADD_PARAM_NAME("GetGlyphIndicesA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetGlyphIndicesA", 2, "lpstr"); // LPCSTR
	ADD_PARAM_NAME("GetGlyphIndicesA", 3, "c"); // int
	ADD_PARAM_NAME("GetGlyphIndicesA", 4, "pgi"); // LPWORD
	ADD_PARAM_NAME("GetGlyphIndicesA", 5, "fl"); // DWORD
	ADD_PARAM_NAME("GetGlyphIndicesW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetGlyphIndicesW", 2, "lpstr"); // LPCWSTR
	ADD_PARAM_NAME("GetGlyphIndicesW", 3, "c"); // int
	ADD_PARAM_NAME("GetGlyphIndicesW", 4, "pgi"); // LPWORD
	ADD_PARAM_NAME("GetGlyphIndicesW", 5, "fl"); // DWORD
	ADD_PARAM_NAME("GetGlyphOutlineA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetGlyphOutlineA", 2, "uChar"); // UINT
	ADD_PARAM_NAME("GetGlyphOutlineA", 3, "fuFormat"); // UINT
	ADD_PARAM_NAME("GetGlyphOutlineA", 4, "lpgm"); // LPGLYPHMETRICS
	ADD_PARAM_NAME("GetGlyphOutlineA", 5, "cjBuffer"); // DWORD
	ADD_PARAM_NAME("GetGlyphOutlineA", 6, "pvBuffer"); // LPVOID
	ADD_PARAM_NAME("GetGlyphOutlineA", 7, "lpmat2"); // CONST MAT2 *
	ADD_PARAM_NAME("GetGlyphOutlineW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetGlyphOutlineW", 2, "uChar"); // UINT
	ADD_PARAM_NAME("GetGlyphOutlineW", 3, "fuFormat"); // UINT
	ADD_PARAM_NAME("GetGlyphOutlineW", 4, "lpgm"); // LPGLYPHMETRICS
	ADD_PARAM_NAME("GetGlyphOutlineW", 5, "cjBuffer"); // DWORD
	ADD_PARAM_NAME("GetGlyphOutlineW", 6, "pvBuffer"); // LPVOID
	ADD_PARAM_NAME("GetGlyphOutlineW", 7, "lpmat2"); // CONST MAT2 *
	ADD_PARAM_NAME("GetGraphicsMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetGuiResources", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetGuiResources", 2, "uiFlags"); // DWORD
	ADD_PARAM_NAME("GetHandleInformation", 1, "hObject"); // HANDLE
	ADD_PARAM_NAME("GetHandleInformation", 2, "lpdwFlags"); // LPDWORD
	ADD_PARAM_NAME("GetICMProfileA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetICMProfileA", 2, "pBufSize"); // LPDWORD
	ADD_PARAM_NAME("GetICMProfileA", 3, "pszFilename"); // LPSTR
	ADD_PARAM_NAME("GetICMProfileW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetICMProfileW", 2, "pBufSize"); // LPDWORD
	ADD_PARAM_NAME("GetICMProfileW", 3, "pszFilename"); // LPWSTR
	ADD_PARAM_NAME("GetIconInfo", 1, "hIcon"); // HICON
	ADD_PARAM_NAME("GetIconInfo", 2, "piconinfo"); // PICONINFO
	ADD_PARAM_NAME("GetJobA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetJobA", 2, "JobId"); // DWORD
	ADD_PARAM_NAME("GetJobA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetJobA", 4, "pJob"); // LPBYTE
	ADD_PARAM_NAME("GetJobA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetJobA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetJobW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetJobW", 2, "JobId"); // DWORD
	ADD_PARAM_NAME("GetJobW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetJobW", 4, "pJob"); // LPBYTE
	ADD_PARAM_NAME("GetJobW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetJobW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetKernelObjectSecurity", 1, "Handle"); // HANDLE
	ADD_PARAM_NAME("GetKernelObjectSecurity", 2, "RequestedInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("GetKernelObjectSecurity", 3, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetKernelObjectSecurity", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetKernelObjectSecurity", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetKerningPairsA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetKerningPairsA", 2, "nPairs"); // DWORD
	ADD_PARAM_NAME("GetKerningPairsA", 3, "lpKernPair"); // LPKERNINGPAIR
	ADD_PARAM_NAME("GetKerningPairsW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetKerningPairsW", 2, "nPairs"); // DWORD
	ADD_PARAM_NAME("GetKerningPairsW", 3, "lpKernPair"); // LPKERNINGPAIR
	ADD_PARAM_NAME("GetKeyNameTextA", 1, "lParam"); // LONG
	ADD_PARAM_NAME("GetKeyNameTextA", 2, "lpString"); // LPSTR
	ADD_PARAM_NAME("GetKeyNameTextA", 3, "cchSize"); // int
	ADD_PARAM_NAME("GetKeyNameTextW", 1, "lParam"); // LONG
	ADD_PARAM_NAME("GetKeyNameTextW", 2, "lpString"); // LPWSTR
	ADD_PARAM_NAME("GetKeyNameTextW", 3, "cchSize"); // int
	ADD_PARAM_NAME("GetKeyState", 1, "nVirtKey"); // int
	ADD_PARAM_NAME("GetKeyboardLayout", 1, "idThread"); // DWORD
	ADD_PARAM_NAME("GetKeyboardLayoutList", 1, "nBuff"); // int
	ADD_PARAM_NAME("GetKeyboardLayoutList", 2, "lpList"); // HKL *
	ADD_PARAM_NAME("GetKeyboardLayoutNameA", 1, "pwszKLID"); // LPSTR
	ADD_PARAM_NAME("GetKeyboardLayoutNameW", 1, "pwszKLID"); // LPWSTR
	ADD_PARAM_NAME("GetKeyboardState", 1, "lpKeyState"); // PBYTE
	ADD_PARAM_NAME("GetKeyboardType", 1, "nTypeFlag"); // int
	ADD_PARAM_NAME("GetLargestConsoleWindowSize", 1, "hConsoleOutput"); // HANDLE
	ADD_PARAM_NAME("GetLastActivePopup", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetLastInputInfo", 1, "plii"); // PLASTINPUTINFO
	ADD_PARAM_NAME("GetLayeredWindowAttributes", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetLayeredWindowAttributes", 2, "pcrKey"); // COLORREF *
	ADD_PARAM_NAME("GetLayeredWindowAttributes", 3, "pbAlpha"); // BYTE *
	ADD_PARAM_NAME("GetLayeredWindowAttributes", 4, "pdwFlags"); // DWORD *
	ADD_PARAM_NAME("GetLayout", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetLengthSid", 1, "pSid"); // PSID
	ADD_PARAM_NAME("GetListBoxInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetLocalTime", 1, "lpSystemTime"); // LPSYSTEMTIME
	ADD_PARAM_NAME("GetLocaleInfoA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetLocaleInfoA", 2, "LCType"); // LCTYPE
	ADD_PARAM_NAME("GetLocaleInfoA", 3, "lpLCData"); // LPSTR
	ADD_PARAM_NAME("GetLocaleInfoA", 4, "cchData"); // int
	ADD_PARAM_NAME("GetLocaleInfoEx", 1, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetLocaleInfoEx", 2, "LCType"); // LCTYPE
	ADD_PARAM_NAME("GetLocaleInfoEx", 3, "lpLCData"); // LPWSTR
	ADD_PARAM_NAME("GetLocaleInfoEx", 4, "cchData"); // int
	ADD_PARAM_NAME("GetLocaleInfoW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetLocaleInfoW", 2, "LCType"); // LCTYPE
	ADD_PARAM_NAME("GetLocaleInfoW", 3, "lpLCData"); // LPWSTR
	ADD_PARAM_NAME("GetLocaleInfoW", 4, "cchData"); // int
	ADD_PARAM_NAME("GetLogColorSpaceA", 1, "hColorSpace"); // HCOLORSPACE
	ADD_PARAM_NAME("GetLogColorSpaceA", 2, "lpBuffer"); // LPLOGCOLORSPACEA
	ADD_PARAM_NAME("GetLogColorSpaceA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetLogColorSpaceW", 1, "hColorSpace"); // HCOLORSPACE
	ADD_PARAM_NAME("GetLogColorSpaceW", 2, "lpBuffer"); // LPLOGCOLORSPACEW
	ADD_PARAM_NAME("GetLogColorSpaceW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetLogicalDriveStringsA", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetLogicalDriveStringsA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetLogicalDriveStringsW", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetLogicalDriveStringsW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetLogicalProcessorInformation", 1, "Buffer"); // PSYSTEM_LOGICAL_PROCESSOR_INFORMATION
	ADD_PARAM_NAME("GetLogicalProcessorInformation", 2, "ReturnedLength"); // PDWORD
	ADD_PARAM_NAME("GetLogicalProcessorInformationEx", 1, "RelationshipType"); // LOGICAL_PROCESSOR_RELATIONSHIP
	ADD_PARAM_NAME("GetLogicalProcessorInformationEx", 2, "Buffer"); // PSYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX
	ADD_PARAM_NAME("GetLogicalProcessorInformationEx", 3, "ReturnedLength"); // PDWORD
	ADD_PARAM_NAME("GetLongPathNameA", 1, "lpszShortPath"); // LPCSTR
	ADD_PARAM_NAME("GetLongPathNameA", 2, "lpszLongPath"); // LPSTR
	ADD_PARAM_NAME("GetLongPathNameA", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetLongPathNameTransactedA", 1, "lpszShortPath"); // LPCSTR
	ADD_PARAM_NAME("GetLongPathNameTransactedA", 2, "lpszLongPath"); // LPSTR
	ADD_PARAM_NAME("GetLongPathNameTransactedA", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetLongPathNameTransactedA", 4, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetLongPathNameTransactedW", 1, "lpszShortPath"); // LPCWSTR
	ADD_PARAM_NAME("GetLongPathNameTransactedW", 2, "lpszLongPath"); // LPWSTR
	ADD_PARAM_NAME("GetLongPathNameTransactedW", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetLongPathNameTransactedW", 4, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("GetLongPathNameW", 1, "lpszShortPath"); // LPCWSTR
	ADD_PARAM_NAME("GetLongPathNameW", 2, "lpszLongPath"); // LPWSTR
	ADD_PARAM_NAME("GetLongPathNameW", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetMailslotInfo", 1, "hMailslot"); // HANDLE
	ADD_PARAM_NAME("GetMailslotInfo", 2, "lpMaxMessageSize"); // LPDWORD
	ADD_PARAM_NAME("GetMailslotInfo", 3, "lpNextSize"); // LPDWORD
	ADD_PARAM_NAME("GetMailslotInfo", 4, "lpMessageCount"); // LPDWORD
	ADD_PARAM_NAME("GetMailslotInfo", 5, "lpReadTimeout"); // LPDWORD
	ADD_PARAM_NAME("GetMapMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetMaximumProcessorCount", 1, "GroupNumber"); // WORD
	ADD_PARAM_NAME("GetMenu", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetMenuBarInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetMenuBarInfo", 2, "idObject"); // LONG
	ADD_PARAM_NAME("GetMenuBarInfo", 3, "idItem"); // LONG
	ADD_PARAM_NAME("GetMenuBarInfo", 4, "pmbi"); // PMENUBARINFO
	ADD_PARAM_NAME("GetMenuContextHelpId", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("GetMenuDefaultItem", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuDefaultItem", 2, "fByPos"); // UINT
	ADD_PARAM_NAME("GetMenuDefaultItem", 3, "gmdiFlags"); // UINT
	ADD_PARAM_NAME("GetMenuInfo", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("GetMenuInfo", 2, "lpcmi"); // LPMENUINFO
	ADD_PARAM_NAME("GetMenuItemCount", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuItemID", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuItemID", 2, "nPos"); // int
	ADD_PARAM_NAME("GetMenuItemInfoA", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("GetMenuItemInfoA", 2, "item"); // UINT
	ADD_PARAM_NAME("GetMenuItemInfoA", 3, "fByPosition"); // WINBOOL
	ADD_PARAM_NAME("GetMenuItemInfoA", 4, "lpmii"); // LPMENUITEMINFOA
	ADD_PARAM_NAME("GetMenuItemInfoW", 1, "hmenu"); // HMENU
	ADD_PARAM_NAME("GetMenuItemInfoW", 2, "item"); // UINT
	ADD_PARAM_NAME("GetMenuItemInfoW", 3, "fByPosition"); // WINBOOL
	ADD_PARAM_NAME("GetMenuItemInfoW", 4, "lpmii"); // LPMENUITEMINFOW
	ADD_PARAM_NAME("GetMenuItemRect", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetMenuItemRect", 2, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuItemRect", 3, "uItem"); // UINT
	ADD_PARAM_NAME("GetMenuItemRect", 4, "lprcItem"); // LPRECT
	ADD_PARAM_NAME("GetMenuState", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuState", 2, "uId"); // UINT
	ADD_PARAM_NAME("GetMenuState", 3, "uFlags"); // UINT
	ADD_PARAM_NAME("GetMenuStringA", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuStringA", 2, "uIDItem"); // UINT
	ADD_PARAM_NAME("GetMenuStringA", 3, "lpString"); // LPSTR
	ADD_PARAM_NAME("GetMenuStringA", 4, "cchMax"); // int
	ADD_PARAM_NAME("GetMenuStringA", 5, "flags"); // UINT
	ADD_PARAM_NAME("GetMenuStringW", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetMenuStringW", 2, "uIDItem"); // UINT
	ADD_PARAM_NAME("GetMenuStringW", 3, "lpString"); // LPWSTR
	ADD_PARAM_NAME("GetMenuStringW", 4, "cchMax"); // int
	ADD_PARAM_NAME("GetMenuStringW", 5, "flags"); // UINT
	ADD_PARAM_NAME("GetMessageA", 1, "lpMsg"); // LPMSG
	ADD_PARAM_NAME("GetMessageA", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("GetMessageA", 3, "wMsgFilterMin"); // UINT
	ADD_PARAM_NAME("GetMessageA", 4, "wMsgFilterMax"); // UINT
	ADD_PARAM_NAME("GetMessageW", 1, "lpMsg"); // LPMSG
	ADD_PARAM_NAME("GetMessageW", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("GetMessageW", 3, "wMsgFilterMin"); // UINT
	ADD_PARAM_NAME("GetMessageW", 4, "wMsgFilterMax"); // UINT
	ADD_PARAM_NAME("GetMetaFileA", 1, "lpName"); // LPCSTR
	ADD_PARAM_NAME("GetMetaFileBitsEx", 1, "hMF"); // HMETAFILE
	ADD_PARAM_NAME("GetMetaFileBitsEx", 2, "cbBuffer"); // UINT
	ADD_PARAM_NAME("GetMetaFileBitsEx", 3, "lpData"); // LPVOID
	ADD_PARAM_NAME("GetMetaFileW", 1, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("GetMetaRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetMetaRgn", 2, "hrgn"); // HRGN
	ADD_PARAM_NAME("GetMiterLimit", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetMiterLimit", 2, "plimit"); // PFLOAT
	ADD_PARAM_NAME("GetModuleFileNameA", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("GetModuleFileNameA", 2, "lpFilename"); // LPCH
	ADD_PARAM_NAME("GetModuleFileNameA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetModuleFileNameW", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("GetModuleFileNameW", 2, "lpFilename"); // LPWCH
	ADD_PARAM_NAME("GetModuleFileNameW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetModuleHandleA", 1, "lpModuleName"); // LPCSTR
	ADD_PARAM_NAME("GetModuleHandleExA", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetModuleHandleExA", 2, "lpModuleName"); // LPCSTR
	ADD_PARAM_NAME("GetModuleHandleExA", 3, "phModule"); // HMODULE *
	ADD_PARAM_NAME("GetModuleHandleExW", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetModuleHandleExW", 2, "lpModuleName"); // LPCWSTR
	ADD_PARAM_NAME("GetModuleHandleExW", 3, "phModule"); // HMODULE *
	ADD_PARAM_NAME("GetModuleHandleW", 1, "lpModuleName"); // LPCWSTR
	ADD_PARAM_NAME("GetMonitorInfoA", 1, "hMonitor"); // HMONITOR
	ADD_PARAM_NAME("GetMonitorInfoA", 2, "lpmi"); // LPMONITORINFO
	ADD_PARAM_NAME("GetMonitorInfoW", 1, "hMonitor"); // HMONITOR
	ADD_PARAM_NAME("GetMonitorInfoW", 2, "lpmi"); // LPMONITORINFO
	ADD_PARAM_NAME("GetMouseMovePointsEx", 1, "cbSize"); // UINT
	ADD_PARAM_NAME("GetMouseMovePointsEx", 2, "lppt"); // LPMOUSEMOVEPOINT
	ADD_PARAM_NAME("GetMouseMovePointsEx", 3, "lpptBuf"); // LPMOUSEMOVEPOINT
	ADD_PARAM_NAME("GetMouseMovePointsEx", 4, "nBufPoints"); // int
	ADD_PARAM_NAME("GetMouseMovePointsEx", 5, "resolution"); // DWORD
	ADD_PARAM_NAME("GetNLSVersion", 1, "Function"); // NLS_FUNCTION
	ADD_PARAM_NAME("GetNLSVersion", 2, "Locale"); // LCID
	ADD_PARAM_NAME("GetNLSVersion", 3, "lpVersionInformation"); // LPNLSVERSIONINFO
	ADD_PARAM_NAME("GetNLSVersionEx", 1, "function"); // NLS_FUNCTION
	ADD_PARAM_NAME("GetNLSVersionEx", 2, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetNLSVersionEx", 3, "lpVersionInformation"); // LPNLSVERSIONINFOEX
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
