/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_c_header_file_for_func.cpp
* @brief Implementation of semantics::win_api::getCHeaderFileForFunc() for
*        WinAPISemantics.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/impl_support/get_c_header_file_for_func.h"
#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_c_header_file_for_func.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

namespace {

/**
* @brief This function is used to initialize FUNC_C_HEADER_MAP later in the
*        file.
*/
const StringStringUMap &initFuncCHeaderMap() {
	static StringStringUMap m;

	// ctype.h
	static const char *CTYPE_H_FUNCS[] = {
		"_isctype",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(CTYPE_H_FUNCS, "ctype.h", m);

	// stdlib.h
	static const char *STDLIB_H_FUNCS[] = {
		"_Exit",
		"__doserrno",
		"__p___argc",
		"__p___argv",
		"__p___wargv",
		"__p__environ",
		"__p__osver",
		"__p__pgmptr",
		"__p__wenviron",
		"__p__winmajor",
		"__p__winminor",
		"__p__winver",
		"__p__wpgmptr",
		"__strtod",
		"_atoi64",
		"_beep",
		"_ecvt",
		"_errno",
		"_exit",
		"_fcvt",
		"_fullpath",
		"_gcvt",
		"_i64toa",
		"_i64tow",
		"_itoa",
		"_itow",
		"_lrotl",
		"_lrotr",
		"_ltoa",
		"_ltow",
		"_makepath",
		"_onexit",
		"_putenv",
		"_rotl",
		"_rotr",
		"_searchenv",
		"_set_error_mode",
		"_seterrormode",
		"_sleep",
		"_splitpath",
		"_ui64toa",
		"_ui64tow",
		"_ultoa",
		"_ultow",
		"_wfullpath",
		"_wgetenv",
		"_wmakepath",
		"_wputenv",
		"_wsearchenv",
		"_wsplitpath",
		"_wsystem",
		"_wtof",
		"_wtoi",
		"_wtoi64",
		"_wtol",
		"abort",
		"abs",
		"atof",
		"atoi",
		"atol",
		"atoll",
		"calloc",
		"div",
		"ecvt",
		"exit",
		"fcvt",
		"free",
		"gcvt",
		"getenv",
		"int",
		"itoa",
		"labs",
		"ldiv",
		"llabs",
		"lldiv",
		"lltoa",
		"lltow",
		"ltoa",
		"malloc",
		"mblen",
		"mbstowcs",
		"mbtowc",
		"putenv",
		"rand",
		"realloc",
		"searchenv",
		"srand",
		"strtod",
		"strtof",
		"strtol",
		"strtold",
		"strtoll",
		"strtoul",
		"strtoull",
		"system",
		"ulltoa",
		"ulltow",
		"void",
		"wcstod",
		"wcstof",
		"wcstol",
		"wcstold",
		"wcstombs",
		"wcstoul",
		"wctomb",
		"wtoll",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STDLIB_H_FUNCS, "stdlib.h", m);

	// stdio.h
	static const char *STDIO_H_FUNCS[] = {
		"_getstdfilex",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STDIO_H_FUNCS, "stdio.h", m);

	// string.h
	static const char *STRING_H_FUNCS[] = {
		"_memccpy",
		"_memicmp",
		"_strcmpi",
		"_strdup",
		"_strerror",
		"_stricmp",
		"_stricoll",
		"_strlwr",
		"_strncoll",
		"_strnicmp",
		"_strnicoll",
		"_strnset",
		"_strrev",
		"_strset",
		"_strupr",
		"_swab",
		"_wcsdup",
		"_wcsicmp",
		"_wcsicoll",
		"_wcslwr",
		"_wcsncoll",
		"_wcsnicmp",
		"_wcsnicoll",
		"_wcsnset",
		"_wcsrev",
		"_wcsset",
		"_wcsupr",
		"memccpy",
		"memchr",
		"memcmp",
		"memcpy",
		"memicmp",
		"memmove",
		"memset",
		"strcasecmp",
		"strcat",
		"strchr",
		"strcmp",
		"strcmpi",
		"strcoll",
		"strcpy",
		"strcspn",
		"strdup",
		"strerror",
		"stricmp",
		"stricoll",
		"strlen",
		"strlwr",
		"strncasecmp",
		"strncat",
		"strncmp",
		"strncpy",
		"strnicmp",
		"strnset",
		"strpbrk",
		"strrchr",
		"strrev",
		"strset",
		"strspn",
		"strstr",
		"strtok",
		"strupr",
		"strxfrm",
		"swab",
		"wcscat",
		"wcschr",
		"wcscmp",
		"wcscmpi",
		"wcscoll",
		"wcscpy",
		"wcscspn",
		"wcsdup",
		"wcsicmp",
		"wcsicoll",
		"wcslen",
		"wcslwr",
		"wcsncat",
		"wcsncmp",
		"wcsncpy",
		"wcsnicmp",
		"wcsnset",
		"wcspbrk",
		"wcsrchr",
		"wcsrev",
		"wcsset",
		"wcsspn",
		"wcsstr",
		"wcstok",
		"wcsupr",
		"wcsxfrm",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(STRING_H_FUNCS, "string.h", m);

	// windows.h
	static const char *WINDOWS_H_FUNCS[] = {
		"AbortDoc",
		"AbortPath",
		"AbortPrinter",
		"AbortSystemShutdownA",
		"AbortSystemShutdownW",
		"AccessCheck",
		"AccessCheckAndAuditAlarmA",
		"AccessCheckAndAuditAlarmW",
		"ActivateKeyboardLayout",
		"AddAccessAllowedAce",
		"AddAccessDeniedAce",
		"AddAce",
		"AddAtomA",
		"AddAtomW",
		"AddAuditAccessAce",
		"AddFontResourceA",
		"AddFontResourceW",
		"AddFormA",
		"AddFormW",
		"AddJobA",
		"AddJobW",
		"AddMonitorA",
		"AddMonitorW",
		"AddPortA",
		"AddPortW",
		"AddPrintProcessorA",
		"AddPrintProcessorW",
		"AddPrintProvidorA",
		"AddPrintProvidorW",
		"AddPrinterA",
		"AddPrinterConnectionA",
		"AddPrinterConnectionW",
		"AddPrinterDriverA",
		"AddPrinterDriverW",
		"AddPrinterW",
		"AdjustTokenGroups",
		"AdjustTokenPrivileges",
		"AdjustWindowRect",
		"AdjustWindowRectEx",
		"AdvancedDocumentPropertiesA",
		"AdvancedDocumentPropertiesW",
		"AllocConsole",
		"AllocateAndInitializeSid",
		"AllocateLocallyUniqueId",
		"AngleArc",
		"AnimatePalette",
		"AnyPopup",
		"AppendMenuA",
		"AppendMenuW",
		"Arc",
		"ArcTo",
		"AreAllAccessesGranted",
		"AreAnyAccessesGranted",
		"AreFileApisANSI",
		"ArrangeIconicWindows",
		"AttachThreadInput",
		"BackupEventLogA",
		"BackupEventLogW",
		"BackupRead",
		"BackupSeek",
		"BackupWrite",
		"Beep",
		"BeginDeferWindowPos",
		"BeginPaint",
		"BeginPath",
		"BeginUpdateResourceA",
		"BeginUpdateResourceW",
		"BindMoniker",
		"BitBlt",
		"BringWindowToTop",
		"BroadcastSystemMessage",
		"BroadcastSystemMessageA",
		"BroadcastSystemMessageW",
		"BstrFromVector",
		"BuildCommDCBA",
		"BuildCommDCBAndTimeoutsA",
		"BuildCommDCBAndTimeoutsW",
		"BuildCommDCBW",
		"CLSIDFromProgID",
		"CLSIDFromString",
		"CallMsgFilterA",
		"CallMsgFilterW",
		"CallNamedPipeA",
		"CallNamedPipeW",
		"CallNextHookEx",
		"CallWindowProcA",
		"CallWindowProcW",
		"CancelDC",
		"CancelDeviceWakeupRequest",
		"CancelIo",
		"CancelWaitableTimer",
		"CascadeWindows",
		"ChangeClipboardChain",
		"ChangeDisplaySettingsA",
		"ChangeDisplaySettingsExA",
		"ChangeDisplaySettingsExW",
		"ChangeDisplaySettingsW",
		"ChangeMenuA",
		"ChangeMenuW",
		"ChangeServiceConfig2A",
		"ChangeServiceConfig2W",
		"ChangeServiceConfigA",
		"ChangeServiceConfigW",
		"CharLowerA",
		"CharLowerBuffA",
		"CharLowerBuffW",
		"CharLowerW",
		"CharNextA",
		"CharNextExA",
		"CharNextW",
		"CharPrevA",
		"CharPrevExA",
		"CharPrevW",
		"CharToOemA",
		"CharToOemBuffA",
		"CharToOemBuffW",
		"CharToOemW",
		"CharUpperA",
		"CharUpperBuffA",
		"CharUpperBuffW",
		"CharUpperW",
		"CheckColorsInGamut",
		"CheckDlgButton",
		"CheckMenuItem",
		"CheckMenuRadioItem",
		"CheckRadioButton",
		"ChildWindowFromPoint",
		"ChildWindowFromPointEx",
		"ChooseColorA",
		"ChooseColorW",
		"ChooseFontA",
		"ChooseFontW",
		"ChoosePixelFormat",
		"Chord",
		"ClearCommBreak",
		"ClearCommError",
		"ClearEventLogA",
		"ClearEventLogW",
		"ClientToScreen",
		"ClipCursor",
		"CloseClipboard",
		"CloseDesktop",
		"CloseDriver",
		"CloseEnhMetaFile",
		"CloseEventLog",
		"CloseFigure",
		"CloseHandle",
		"CloseMetaFile",
		"ClosePrinter",
		"CloseServiceHandle",
		"CloseWindow",
		"CloseWindowStation",
		"CoAddRefServerProcess",
		"CoBuildVersion",
		"CoCopyProxy",
		"CoCreateFreeThreadedMarshaler",
		"CoCreateGuid",
		"CoCreateInstance",
		"CoCreateInstanceEx",
		"CoCreateStandardMalloc",
		"CoDisconnectObject",
		"CoDosDateTimeToFileTime",
		"CoFileTimeNow",
		"CoFileTimeToDosDateTime",
		"CoFreeAllLibraries",
		"CoFreeLibrary",
		"CoFreeUnusedLibraries",
		"CoGetCallContext",
		"CoGetClassObject",
		"CoGetCurrentProcess",
		"CoGetInstanceFromFile",
		"CoGetInstanceFromIStorage",
		"CoGetInterfaceAndReleaseStream",
		"CoGetMalloc",
		"CoGetMarshalSizeMax",
		"CoGetObject",
		"CoGetPSClsid",
		"CoGetStandardMarshal",
		"CoGetStdMarshalEx",
		"CoGetTreatAsClass",
		"CoHasStrongExternalConnections",
		"CoImpersonateClient",
		"CoInitialize",
		"CoInitializeEx",
		"CoInitializeSecurity",
		"CoIsHandlerConnected",
		"CoIsOle1Class",
		"CoLoadLibrary",
		"CoLockObjectExternal",
		"CoMarshalHresult",
		"CoMarshalInterThreadInterfaceInStream",
		"CoMarshalInterface",
		"CoQueryAuthenticationServices",
		"CoQueryClientBlanket",
		"CoQueryProxyBlanket",
		"CoRegisterClassObject",
		"CoRegisterMallocSpy",
		"CoRegisterMessageFilter",
		"CoRegisterPSClsid",
		"CoReleaseMarshalData",
		"CoReleaseServerProcess",
		"CoResumeClassObjects",
		"CoRevertToSelf",
		"CoRevokeClassObject",
		"CoRevokeMallocSpy",
		"CoSetProxyBlanket",
		"CoSuspendClassObjects",
		"CoSwitchCallContext",
		"CoTaskMemAlloc",
		"CoTaskMemFree",
		"CoTaskMemRealloc",
		"CoTreatAsClass",
		"CoUninitialize",
		"CoUnmarshalHresult",
		"CoUnmarshalInterface",
		"CombineRgn",
		"CombineTransform",
		"CommConfigDialogA",
		"CommConfigDialogW",
		"CommDlgExtendedError",
		"CommandLineToArgvW",
		"CompareFileTime",
		"CompareStringA",
		"CompareStringW",
		"ConfigurePortA",
		"ConfigurePortW",
		"ConnectNamedPipe",
		"ConnectToPrinterDlg",
		"ContinueDebugEvent",
		"ControlService",
		"ConvertDefaultLocale",
		"ConvertFiberToThread",
		"ConvertThreadToFiber",
		"CopyAcceleratorTableA",
		"CopyAcceleratorTableW",
		"CopyEnhMetaFileA",
		"CopyEnhMetaFileW",
		"CopyFileA",
		"CopyFileExA",
		"CopyFileExW",
		"CopyFileW",
		"CopyIcon",
		"CopyImage",
		"CopyLZFile",
		"CopyMetaFileA",
		"CopyMetaFileW",
		"CopyRect",
		"CopySid",
		"CountClipboardFormats",
		"CreateAcceleratorTableA",
		"CreateAcceleratorTableW",
		"CreateAntiMoniker",
		"CreateBindCtx",
		"CreateBitmap",
		"CreateBitmapIndirect",
		"CreateBrushIndirect",
		"CreateCaret",
		"CreateColorSpaceA",
		"CreateColorSpaceW",
		"CreateCompatibleBitmap",
		"CreateCompatibleDC",
		"CreateConsoleScreenBuffer",
		"CreateCursor",
		"CreateDCA",
		"CreateDCW",
		"CreateDIBPatternBrush",
		"CreateDIBPatternBrushPt",
		"CreateDIBSection",
		"CreateDIBitmap",
		"CreateDataAdviseHolder",
		"CreateDataCache",
		"CreateDesktopA",
		"CreateDesktopW",
		"CreateDialogIndirectParamA",
		"CreateDialogIndirectParamW",
		"CreateDialogParamA",
		"CreateDialogParamW",
		"CreateDirectoryA",
		"CreateDirectoryExA",
		"CreateDirectoryExW",
		"CreateDirectoryW",
		"CreateDiscardableBitmap",
		"CreateDispTypeInfo",
		"CreateEllipticRgn",
		"CreateEllipticRgnIndirect",
		"CreateEnhMetaFileA",
		"CreateEnhMetaFileW",
		"CreateErrorInfo",
		"CreateEventA",
		"CreateEventW",
		"CreateFiber",
		"CreateFiberEx",
		"CreateFileA",
		"CreateFileMappingA",
		"CreateFileMappingW",
		"CreateFileMoniker",
		"CreateFileW",
		"CreateFontA",
		"CreateFontIndirectA",
		"CreateFontIndirectW",
		"CreateFontW",
		"CreateGenericComposite",
		"CreateHalftonePalette",
		"CreateHatchBrush",
		"CreateICA",
		"CreateICW",
		"CreateILockBytesOnHGlobal",
		"CreateIcon",
		"CreateIconFromResource",
		"CreateIconFromResourceEx",
		"CreateIconIndirect",
		"CreateIoCompletionPort",
		"CreateItemMoniker",
		"CreateMDIWindowA",
		"CreateMDIWindowW",
		"CreateMailslotA",
		"CreateMailslotW",
		"CreateMenu",
		"CreateMetaFileA",
		"CreateMetaFileW",
		"CreateMutexA",
		"CreateMutexW",
		"CreateNamedPipeA",
		"CreateNamedPipeW",
		"CreateOleAdviseHolder",
		"CreatePalette",
		"CreatePatternBrush",
		"CreatePen",
		"CreatePenIndirect",
		"CreatePipe",
		"CreatePointerMoniker",
		"CreatePolyPolygonRgn",
		"CreatePolygonRgn",
		"CreatePopupMenu",
		"CreatePrivateObjectSecurity",
		"CreateProcessA",
		"CreateProcessAsUserA",
		"CreateProcessAsUserW",
		"CreateProcessW",
		"CreateRectRgn",
		"CreateRectRgnIndirect",
		"CreateRemoteThread",
		"CreateRoundRectRgn",
		"CreateScalableFontResourceA",
		"CreateScalableFontResourceW",
		"CreateSemaphoreA",
		"CreateSemaphoreW",
		"CreateServiceA",
		"CreateServiceW",
		"CreateSolidBrush",
		"CreateStdDispatch",
		"CreateStreamOnHGlobal",
		"CreateTapePartition",
		"CreateThread",
		"CreateTypeLib",
		"CreateWaitableTimerA",
		"CreateWaitableTimerW",
		"CreateWindowExA",
		"CreateWindowExW",
		"CreateWindowStationA",
		"CreateWindowStationW",
		"DPtoLP",
		"DceErrorInqTextA",
		"DceErrorInqTextW",
		"DdeAbandonTransaction",
		"DdeAccessData",
		"DdeAddData",
		"DdeClientTransaction",
		"DdeCmpStringHandles",
		"DdeConnect",
		"DdeConnectList",
		"DdeCreateDataHandle",
		"DdeCreateStringHandleA",
		"DdeCreateStringHandleW",
		"DdeDisconnect",
		"DdeDisconnectList",
		"DdeEnableCallback",
		"DdeFreeDataHandle",
		"DdeFreeStringHandle",
		"DdeGetData",
		"DdeGetLastError",
		"DdeImpersonateClient",
		"DdeInitializeA",
		"DdeInitializeW",
		"DdeKeepStringHandle",
		"DdeNameService",
		"DdePostAdvise",
		"DdeQueryConvInfo",
		"DdeQueryNextServer",
		"DdeQueryStringA",
		"DdeQueryStringW",
		"DdeReconnect",
		"DdeSetQualityOfService",
		"DdeSetUserHandle",
		"DdeUnaccessData",
		"DdeUninitialize",
		"DebugActiveProcess",
		"DebugBreak",
		"DefDlgProcA",
		"DefDlgProcW",
		"DefDriverProc",
		"DefFrameProcA",
		"DefFrameProcW",
		"DefMDIChildProcA",
		"DefMDIChildProcW",
		"DefWindowProcA",
		"DefWindowProcW",
		"DeferWindowPos",
		"DefineDosDeviceA",
		"DefineDosDeviceW",
		"DeleteAce",
		"DeleteAtom",
		"DeleteColorSpace",
		"DeleteCriticalSection",
		"DeleteDC",
		"DeleteEnhMetaFile",
		"DeleteFiber",
		"DeleteFileA",
		"DeleteFileW",
		"DeleteFormA",
		"DeleteFormW",
		"DeleteMenu",
		"DeleteMetaFile",
		"DeleteMonitorA",
		"DeleteMonitorW",
		"DeleteObject",
		"DeletePortA",
		"DeletePortW",
		"DeletePrintProcessorA",
		"DeletePrintProcessorW",
		"DeletePrintProvidorA",
		"DeletePrintProvidorW",
		"DeletePrinter",
		"DeletePrinterConnectionA",
		"DeletePrinterConnectionW",
		"DeletePrinterDataA",
		"DeletePrinterDataW",
		"DeletePrinterDriverA",
		"DeletePrinterDriverW",
		"DeleteService",
		"DeregisterEventSource",
		"DeregisterShellHookWindow",
		"DescribePixelFormat",
		"DestroyAcceleratorTable",
		"DestroyCaret",
		"DestroyCursor",
		"DestroyIcon",
		"DestroyMenu",
		"DestroyPrivateObjectSecurity",
		"DestroyWindow",
		"DeviceCapabilitiesA",
		"DeviceCapabilitiesW",
		"DeviceIoControl",
		"DialogBoxIndirectParamA",
		"DialogBoxIndirectParamW",
		"DialogBoxParamA",
		"DialogBoxParamW",
		"DisableThreadLibraryCalls",
		"DisconnectNamedPipe",
		"DispGetIDsOfNames",
		"DispGetParam",
		"DispInvoke",
		"DispatchMessageA",
		"DispatchMessageW",
		"DlgDirListA",
		"DlgDirListComboBoxA",
		"DlgDirListComboBoxW",
		"DlgDirListW",
		"DlgDirSelectComboBoxExA",
		"DlgDirSelectComboBoxExW",
		"DlgDirSelectExA",
		"DlgDirSelectExW",
		"DllCanUnloadNow",
		"DllGetClassObject",
		"DoDragDrop",
		"DocumentPropertiesA",
		"DocumentPropertiesW",
		"DosDateTimeToFileTime",
		"DosDateTimeToVariantTime",
		"DragAcceptFiles",
		"DragDetect",
		"DragFinish",
		"DragObject",
		"DragQueryFileA",
		"DragQueryFileW",
		"DragQueryPoint",
		"DrawAnimatedRects",
		"DrawCaption",
		"DrawEdge",
		"DrawEscape",
		"DrawFocusRect",
		"DrawFrameControl",
		"DrawIcon",
		"DrawIconEx",
		"DrawMenuBar",
		"DrawStateA",
		"DrawStateW",
		"DrawTextA",
		"DrawTextExA",
		"DrawTextExW",
		"DrawTextW",
		"DrvGetModuleHandle",
		"DuplicateHandle",
		"DuplicateIcon",
		"DuplicateToken",
		"DuplicateTokenEx",
		"Ellipse",
		"EmptyClipboard",
		"EnableEUDC",
		"EnableMenuItem",
		"EnableScrollBar",
		"EnableWindow",
		"EncryptFileA",
		"EncryptFileW",
		"EndDeferWindowPos",
		"EndDialog",
		"EndDoc",
		"EndDocPrinter",
		"EndMenu",
		"EndPage",
		"EndPagePrinter",
		"EndPaint",
		"EndPath",
		"EndUpdateResourceA",
		"EndUpdateResourceW",
		"EnterCriticalSection",
		"EnumCalendarInfoA",
		"EnumCalendarInfoW",
		"EnumChildWindows",
		"EnumClipboardFormats",
		"EnumDateFormatsA",
		"EnumDateFormatsW",
		"EnumDependentServicesA",
		"EnumDependentServicesW",
		"EnumDesktopWindows",
		"EnumDesktopsA",
		"EnumDesktopsW",
		"EnumDisplayDevicesA",
		"EnumDisplayDevicesW",
		"EnumDisplayMonitors",
		"EnumDisplaySettingsA",
		"EnumDisplaySettingsW",
		"EnumEnhMetaFile",
		"EnumFontFamiliesA",
		"EnumFontFamiliesExA",
		"EnumFontFamiliesExW",
		"EnumFontFamiliesW",
		"EnumFontsA",
		"EnumFontsW",
		"EnumFormsA",
		"EnumFormsW",
		"EnumICMProfilesA",
		"EnumICMProfilesW",
		"EnumJobsA",
		"EnumJobsW",
		"EnumMetaFile",
		"EnumMonitorsA",
		"EnumMonitorsW",
		"EnumObjects",
		"EnumPortsA",
		"EnumPortsW",
		"EnumPrintProcessorDatatypesA",
		"EnumPrintProcessorDatatypesW",
		"EnumPrintProcessorsA",
		"EnumPrintProcessorsW",
		"EnumPrinterDataA",
		"EnumPrinterDataW",
		"EnumPrinterDriversA",
		"EnumPrinterDriversW",
		"EnumPrintersA",
		"EnumPrintersW",
		"EnumPropsA",
		"EnumPropsExA",
		"EnumPropsExW",
		"EnumPropsW",
		"EnumResourceLanguagesA",
		"EnumResourceLanguagesW",
		"EnumResourceNamesA",
		"EnumResourceNamesW",
		"EnumResourceTypesA",
		"EnumResourceTypesW",
		"EnumServicesStatusA",
		"EnumServicesStatusExA",
		"EnumServicesStatusExW",
		"EnumServicesStatusW",
		"EnumSystemCodePagesA",
		"EnumSystemCodePagesW",
		"EnumSystemGeoID",
		"EnumSystemLocalesA",
		"EnumSystemLocalesW",
		"EnumThreadWindows",
		"EnumTimeFormatsA",
		"EnumTimeFormatsW",
		"EnumWindowStationsA",
		"EnumWindowStationsW",
		"EnumWindows",
		"EqualPrefixSid",
		"EqualRect",
		"EqualRgn",
		"EqualSid",
		"EraseTape",
		"Escape",
		"EscapeCommFunction",
		"ExcludeClipRect",
		"ExcludeUpdateRgn",
		"ExitProcess",
		"ExitThread",
		"ExitWindowsEx",
		"ExpandEnvironmentStringsA",
		"ExpandEnvironmentStringsW",
		"ExtCreatePen",
		"ExtCreateRegion",
		"ExtEscape",
		"ExtFloodFill",
		"ExtSelectClipRgn",
		"ExtTextOutA",
		"ExtTextOutW",
		"ExtractAssociatedIconA",
		"ExtractAssociatedIconW",
		"ExtractIconA",
		"ExtractIconExA",
		"ExtractIconExW",
		"ExtractIconW",
		"FatalAppExitA",
		"FatalAppExitW",
		"FatalExit",
		"FileEncryptionStatusA",
		"FileEncryptionStatusW",
		"FileTimeToDosDateTime",
		"FileTimeToLocalFileTime",
		"FileTimeToSystemTime",
		"FillConsoleOutputAttribute",
		"FillConsoleOutputCharacterA",
		"FillConsoleOutputCharacterW",
		"FillPath",
		"FillRect",
		"FillRgn",
		"FindAtomA",
		"FindAtomW",
		"FindClose",
		"FindCloseChangeNotification",
		"FindClosePrinterChangeNotification",
		"FindExecutableA",
		"FindExecutableW",
		"FindFirstChangeNotificationA",
		"FindFirstChangeNotificationW",
		"FindFirstFileA",
		"FindFirstFileExA",
		"FindFirstFileExW",
		"FindFirstFileW",
		"FindFirstFreeAce",
		"FindFirstPrinterChangeNotification",
		"FindNextChangeNotification",
		"FindNextFileA",
		"FindNextFileW",
		"FindNextPrinterChangeNotification",
		"FindResourceA",
		"FindResourceExA",
		"FindResourceExW",
		"FindResourceW",
		"FindTextA",
		"FindTextW",
		"FindWindowA",
		"FindWindowExA",
		"FindWindowExW",
		"FindWindowW",
		"FixBrushOrgEx",
		"FlashWindow",
		"FlattenPath",
		"FloodFill",
		"FlushConsoleInputBuffer",
		"FlushFileBuffers",
		"FlushInstructionCache",
		"FlushViewOfFile",
		"FoldStringA",
		"FoldStringW",
		"FormatMessageA",
		"FormatMessageW",
		"FrameRect",
		"FrameRgn",
		"FreeConsole",
		"FreeDDElParam",
		"FreeEnvironmentStringsA",
		"FreeEnvironmentStringsW",
		"FreeLibrary",
		"FreeLibraryAndExitThread",
		"FreePrinterNotifyInfo",
		"FreeResource",
		"FreeSid",
		"GdiComment",
		"GdiFlush",
		"GdiGetBatchLimit",
		"GdiSetBatchLimit",
		"GenerateConsoleCtrlEvent",
		"GetACP",
		"GetAce",
		"GetAclInformation",
		"GetActiveObject",
		"GetActiveWindow",
		"GetAltTabInfoA",
		"GetAltTabInfoW",
		"GetAncestor",
		"GetArcDirection",
		"GetAspectRatioFilterEx",
		"GetAsyncKeyState",
		"GetAtomNameA",
		"GetAtomNameW",
		"GetBinaryTypeA",
		"GetBinaryTypeW",
		"GetBitmapBits",
		"GetBitmapDimensionEx",
		"GetBkColor",
		"GetBkMode",
		"GetBoundsRect",
		"GetBrushOrgEx",
		"GetCPInfo",
		"GetCPInfoExA",
		"GetCPInfoExW",
		"GetCalendarInfoA",
		"GetCalendarInfoW",
		"GetCapture",
		"GetCaretBlinkTime",
		"GetCaretPos",
		"GetCharABCWidthsA",
		"GetCharABCWidthsFloatA",
		"GetCharABCWidthsFloatW",
		"GetCharABCWidthsW",
		"GetCharWidth32A",
		"GetCharWidth32W",
		"GetCharWidthA",
		"GetCharWidthFloatA",
		"GetCharWidthFloatW",
		"GetCharWidthW",
		"GetCharacterPlacementA",
		"GetCharacterPlacementW",
		"GetClassFile",
		"GetClassInfoA",
		"GetClassInfoExA",
		"GetClassInfoExW",
		"GetClassInfoW",
		"GetClassLongA",
		"GetClassLongW",
		"GetClassNameA",
		"GetClassNameW",
		"GetClassWord",
		"GetClientRect",
		"GetClipBox",
		"GetClipCursor",
		"GetClipRgn",
		"GetClipboardData",
		"GetClipboardFormatNameA",
		"GetClipboardFormatNameW",
		"GetClipboardOwner",
		"GetClipboardViewer",
		"GetColorAdjustment",
		"GetColorSpace",
		"GetComboBoxInfo",
		"GetCommConfig",
		"GetCommMask",
		"GetCommModemStatus",
		"GetCommProperties",
		"GetCommState",
		"GetCommTimeouts",
		"GetCommandLineA",
		"GetCommandLineW",
		"GetCompressedFileSizeA",
		"GetCompressedFileSizeW",
		"GetComputerNameA",
		"GetComputerNameW",
		"GetConsoleCP",
		"GetConsoleCursorInfo",
		"GetConsoleMode",
		"GetConsoleOutputCP",
		"GetConsoleScreenBufferInfo",
		"GetConsoleTitleA",
		"GetConsoleTitleW",
		"GetConvertStg",
		"GetCurrencyFormatA",
		"GetCurrencyFormatW",
		"GetCurrentDirectoryA",
		"GetCurrentDirectoryW",
		"GetCurrentHwProfileA",
		"GetCurrentHwProfileW",
		"GetCurrentObject",
		"GetCurrentPositionEx",
		"GetCurrentProcess",
		"GetCurrentProcessId",
		"GetCurrentThread",
		"GetCurrentThreadId",
		"GetCursor",
		"GetCursorInfo",
		"GetCursorPos",
		"GetDC",
		"GetDCEx",
		"GetDCOrgEx",
		"GetDIBColorTable",
		"GetDIBits",
		"GetDateFormatA",
		"GetDateFormatW",
		"GetDefaultCommConfigA",
		"GetDefaultCommConfigW",
		"GetDesktopWindow",
		"GetDeviceCaps",
		"GetDeviceGammaRamp",
		"GetDevicePowerState",
		"GetDialogBaseUnits",
		"GetDiskFreeSpaceA",
		"GetDiskFreeSpaceExA",
		"GetDiskFreeSpaceExW",
		"GetDiskFreeSpaceW",
		"GetDlgCtrlID",
		"GetDlgItem",
		"GetDlgItemInt",
		"GetDlgItemTextA",
		"GetDlgItemTextW",
		"GetDoubleClickTime",
		"GetDriveTypeA",
		"GetDriveTypeW",
		"GetDriverModuleHandle",
		"GetEnhMetaFileA",
		"GetEnhMetaFileBits",
		"GetEnhMetaFileDescriptionA",
		"GetEnhMetaFileDescriptionW",
		"GetEnhMetaFileHeader",
		"GetEnhMetaFilePaletteEntries",
		"GetEnhMetaFilePixelFormat",
		"GetEnhMetaFileW",
		"GetEnvironmentStrings",
		"GetEnvironmentStringsA",
		"GetEnvironmentStringsW",
		"GetEnvironmentVariableA",
		"GetEnvironmentVariableW",
		"GetErrorInfo",
		"GetExitCodeProcess",
		"GetExitCodeThread",
		"GetExpandedNameA",
		"GetExpandedNameW",
		"GetFileAttributesA",
		"GetFileAttributesExA",
		"GetFileAttributesExW",
		"GetFileAttributesW",
		"GetFileInformationByHandle",
		"GetFileSecurityA",
		"GetFileSecurityW",
		"GetFileSize",
		"GetFileTime",
		"GetFileTitleA",
		"GetFileTitleW",
		"GetFileType",
		"GetFileVersionInfoA",
		"GetFileVersionInfoSizeA",
		"GetFileVersionInfoSizeW",
		"GetFileVersionInfoW",
		"GetFocus",
		"GetFontData",
		"GetFontLanguageInfo",
		"GetForegroundWindow",
		"GetFormA",
		"GetFormW",
		"GetFullPathNameA",
		"GetFullPathNameW",
		"GetGeoInfoA",
		"GetGeoInfoW",
		"GetGlyphOutlineA",
		"GetGlyphOutlineW",
		"GetGraphicsMode",
		"GetHGlobalFromILockBytes",
		"GetHGlobalFromStream",
		"GetHandleInformation",
		"GetICMProfileA",
		"GetICMProfileW",
		"GetIconInfo",
		"GetInputState",
		"GetJobA",
		"GetJobW",
		"GetKBCodePage",
		"GetKernelObjectSecurity",
		"GetKerningPairsA",
		"GetKerningPairsW",
		"GetKeyNameTextA",
		"GetKeyNameTextW",
		"GetKeyState",
		"GetKeyboardLayout",
		"GetKeyboardLayoutList",
		"GetKeyboardLayoutNameA",
		"GetKeyboardLayoutNameW",
		"GetKeyboardState",
		"GetKeyboardType",
		"GetLargestConsoleWindowSize",
		"GetLastActivePopup",
		"GetLastError",
		"GetLastInputInfo",
		"GetLengthSid",
		"GetListBoxInfo",
		"GetLocalTime",
		"GetLocaleInfoA",
		"GetLocaleInfoW",
		"GetLogColorSpaceA",
		"GetLogColorSpaceW",
		"GetLogicalDriveStringsA",
		"GetLogicalDriveStringsW",
		"GetLogicalDrives",
		"GetMailslotInfo",
		"GetMapMode",
		"GetMenu",
		"GetMenuBarInfo",
		"GetMenuCheckMarkDimensions",
		"GetMenuContextHelpId",
		"GetMenuDefaultItem",
		"GetMenuInfo",
		"GetMenuItemCount",
		"GetMenuItemID",
		"GetMenuItemInfoA",
		"GetMenuItemInfoW",
		"GetMenuItemRect",
		"GetMenuState",
		"GetMenuStringA",
		"GetMenuStringW",
		"GetMessageA",
		"GetMessageExtraInfo",
		"GetMessagePos",
		"GetMessageTime",
		"GetMessageW",
		"GetMetaFileA",
		"GetMetaFileBitsEx",
		"GetMetaFileW",
		"GetMetaRgn",
		"GetMiterLimit",
		"GetModuleFileNameA",
		"GetModuleFileNameW",
		"GetModuleHandleA",
		"GetModuleHandleW",
		"GetMonitorInfoA",
		"GetMonitorInfoW",
		"GetNLSVersion",
		"GetNamedPipeHandleStateA",
		"GetNamedPipeHandleStateW",
		"GetNamedPipeInfo",
		"GetNearestColor",
		"GetNearestPaletteIndex",
		"GetNextDlgGroupItem",
		"GetNextDlgTabItem",
		"GetNumberFormatA",
		"GetNumberFormatW",
		"GetNumberOfConsoleInputEvents",
		"GetNumberOfConsoleMouseButtons",
		"GetNumberOfEventLogRecords",
		"GetOEMCP",
		"GetObjectA",
		"GetObjectType",
		"GetObjectW",
		"GetOldestEventLogRecord",
		"GetOpenClipboardWindow",
		"GetOpenFileNameA",
		"GetOpenFileNameW",
		"GetOutlineTextMetricsA",
		"GetOutlineTextMetricsW",
		"GetOverlappedResult",
		"GetPaletteEntries",
		"GetParent",
		"GetPath",
		"GetPixel",
		"GetPixelFormat",
		"GetPolyFillMode",
		"GetPrintProcessorDirectoryA",
		"GetPrintProcessorDirectoryW",
		"GetPrinterA",
		"GetPrinterDataA",
		"GetPrinterDataW",
		"GetPrinterDriverA",
		"GetPrinterDriverDirectoryA",
		"GetPrinterDriverDirectoryW",
		"GetPrinterDriverW",
		"GetPrinterW",
		"GetPriorityClass",
		"GetPriorityClipboardFormat",
		"GetPrivateObjectSecurity",
		"GetPrivateProfileIntA",
		"GetPrivateProfileIntW",
		"GetPrivateProfileSectionA",
		"GetPrivateProfileSectionNamesA",
		"GetPrivateProfileSectionNamesW",
		"GetPrivateProfileSectionW",
		"GetPrivateProfileStringA",
		"GetPrivateProfileStringW",
		"GetPrivateProfileStructA",
		"GetPrivateProfileStructW",
		"GetProcAddress",
		"GetProcessAffinityMask",
		"GetProcessHeap",
		"GetProcessHeaps",
		"GetProcessPriorityBoost",
		"GetProcessShutdownParameters",
		"GetProcessTimes",
		"GetProcessVersion",
		"GetProcessWindowStation",
		"GetProcessWorkingSetSize",
		"GetProfileIntA",
		"GetProfileIntW",
		"GetProfileSectionA",
		"GetProfileSectionW",
		"GetProfileStringA",
		"GetProfileStringW",
		"GetPropA",
		"GetPropW",
		"GetQueueStatus",
		"GetQueuedCompletionStatus",
		"GetROP2",
		"GetRandomRgn",
		"GetRasterizerCaps",
		"GetRecordInfoFromGuids",
		"GetRecordInfoFromTypeInfo",
		"GetRegionData",
		"GetRgnBox",
		"GetRunningObjectTable",
		"GetSaveFileNameA",
		"GetSaveFileNameW",
		"GetScrollBarInfo",
		"GetScrollInfo",
		"GetScrollPos",
		"GetScrollRange",
		"GetSecurityDescriptorControl",
		"GetSecurityDescriptorDacl",
		"GetSecurityDescriptorGroup",
		"GetSecurityDescriptorLength",
		"GetSecurityDescriptorOwner",
		"GetSecurityDescriptorSacl",
		"GetServiceDisplayNameA",
		"GetServiceDisplayNameW",
		"GetServiceKeyNameA",
		"GetServiceKeyNameW",
		"GetShortPathNameA",
		"GetShortPathNameW",
		"GetSidIdentifierAuthority",
		"GetSidLengthRequired",
		"GetSidSubAuthority",
		"GetSidSubAuthorityCount",
		"GetStartupInfoA",
		"GetStartupInfoW",
		"GetStdHandle",
		"GetStockObject",
		"GetStretchBltMode",
		"GetStringTypeA",
		"GetStringTypeExA",
		"GetStringTypeExW",
		"GetStringTypeW",
		"GetSubMenu",
		"GetSysColor",
		"GetSysColorBrush",
		"GetSystemDefaultLCID",
		"GetSystemDefaultLangID",
		"GetSystemDirectoryA",
		"GetSystemDirectoryW",
		"GetSystemInfo",
		"GetSystemMenu",
		"GetSystemMetrics",
		"GetSystemPaletteEntries",
		"GetSystemPaletteUse",
		"GetSystemPowerStatus",
		"GetSystemTime",
		"GetSystemTimeAdjustment",
		"GetSystemTimeAsFileTime",
		"GetTabbedTextExtentA",
		"GetTabbedTextExtentW",
		"GetTapeParameters",
		"GetTapePosition",
		"GetTapeStatus",
		"GetTempFileNameA",
		"GetTempFileNameW",
		"GetTempPathA",
		"GetTempPathW",
		"GetTextAlign",
		"GetTextCharacterExtra",
		"GetTextCharset",
		"GetTextCharsetInfo",
		"GetTextColor",
		"GetTextExtentExPointA",
		"GetTextExtentExPointW",
		"GetTextExtentPoint32A",
		"GetTextExtentPoint32W",
		"GetTextExtentPointA",
		"GetTextExtentPointW",
		"GetTextFaceA",
		"GetTextFaceW",
		"GetTextMetricsA",
		"GetTextMetricsW",
		"GetThreadContext",
		"GetThreadDesktop",
		"GetThreadLocale",
		"GetThreadPriority",
		"GetThreadPriorityBoost",
		"GetThreadSelectorEntry",
		"GetThreadTimes",
		"GetTickCount",
		"GetTimeFormatA",
		"GetTimeFormatW",
		"GetTimeZoneInformation",
		"GetTokenInformation",
		"GetTopWindow",
		"GetUpdateRect",
		"GetUpdateRgn",
		"GetUserDefaultLCID",
		"GetUserDefaultLangID",
		"GetUserGeoID",
		"GetUserNameA",
		"GetUserNameW",
		"GetUserObjectInformationA",
		"GetUserObjectInformationW",
		"GetUserObjectSecurity",
		"GetVersion",
		"GetVersionExA",
		"GetVersionExW",
		"GetViewportExtEx",
		"GetViewportOrgEx",
		"GetVolumeInformationA",
		"GetVolumeInformationW",
		"GetWinMetaFileBits",
		"GetWindow",
		"GetWindowContextHelpId",
		"GetWindowDC",
		"GetWindowExtEx",
		"GetWindowInfo",
		"GetWindowLongA",
		"GetWindowLongW",
		"GetWindowModuleFileNameA",
		"GetWindowModuleFileNameW",
		"GetWindowOrgEx",
		"GetWindowPlacement",
		"GetWindowRect",
		"GetWindowRgn",
		"GetWindowTextA",
		"GetWindowTextLengthA",
		"GetWindowTextLengthW",
		"GetWindowTextW",
		"GetWindowThreadProcessId",
		"GetWindowWord",
		"GetWindowsDirectoryA",
		"GetWindowsDirectoryW",
		"GetWorldTransform",
		"GetWriteWatch",
		"GlobalAddAtomA",
		"GlobalAddAtomW",
		"GlobalAlloc",
		"GlobalCompact",
		"GlobalDeleteAtom",
		"GlobalFindAtomA",
		"GlobalFindAtomW",
		"GlobalFix",
		"GlobalFlags",
		"GlobalFree",
		"GlobalGetAtomNameA",
		"GlobalGetAtomNameW",
		"GlobalHandle",
		"GlobalLock",
		"GlobalMemoryStatus",
		"GlobalReAlloc",
		"GlobalSize",
		"GlobalUnWire",
		"GlobalUnfix",
		"GlobalUnlock",
		"GlobalWire",
		"GrayStringA",
		"GrayStringW",
		"HeapAlloc",
		"HeapCompact",
		"HeapCreate",
		"HeapDestroy",
		"HeapFree",
		"HeapLock",
		"HeapReAlloc",
		"HeapSize",
		"HeapUnlock",
		"HeapValidate",
		"HeapWalk",
		"HideCaret",
		"HiliteMenuItem",
		"IAdviseSink2_OnLinkSrcChange_Proxy",
		"IAdviseSink2_OnLinkSrcChange_Stub",
		"IAdviseSink2_RemoteOnLinkSrcChange_Proxy",
		"IAdviseSink2_RemoteOnLinkSrcChange_Stub",
		"IAdviseSink_OnClose_Proxy",
		"IAdviseSink_OnClose_Stub",
		"IAdviseSink_OnDataChange_Proxy",
		"IAdviseSink_OnDataChange_Stub",
		"IAdviseSink_OnRename_Proxy",
		"IAdviseSink_OnRename_Stub",
		"IAdviseSink_OnSave_Proxy",
		"IAdviseSink_OnSave_Stub",
		"IAdviseSink_OnViewChange_Proxy",
		"IAdviseSink_OnViewChange_Stub",
		"IAdviseSink_RemoteOnClose_Proxy",
		"IAdviseSink_RemoteOnClose_Stub",
		"IAdviseSink_RemoteOnDataChange_Proxy",
		"IAdviseSink_RemoteOnDataChange_Stub",
		"IAdviseSink_RemoteOnRename_Proxy",
		"IAdviseSink_RemoteOnRename_Stub",
		"IAdviseSink_RemoteOnSave_Proxy",
		"IAdviseSink_RemoteOnSave_Stub",
		"IAdviseSink_RemoteOnViewChange_Proxy",
		"IAdviseSink_RemoteOnViewChange_Stub",
		"IBindCtx_EnumObjectParam_Proxy",
		"IBindCtx_EnumObjectParam_Stub",
		"IBindCtx_GetBindOptions_Proxy",
		"IBindCtx_GetBindOptions_Stub",
		"IBindCtx_GetObjectParam_Proxy",
		"IBindCtx_GetObjectParam_Stub",
		"IBindCtx_GetRunningObjectTable_Proxy",
		"IBindCtx_GetRunningObjectTable_Stub",
		"IBindCtx_RegisterObjectBound_Proxy",
		"IBindCtx_RegisterObjectBound_Stub",
		"IBindCtx_RegisterObjectParam_Proxy",
		"IBindCtx_RegisterObjectParam_Stub",
		"IBindCtx_ReleaseBoundObjects_Proxy",
		"IBindCtx_ReleaseBoundObjects_Stub",
		"IBindCtx_RevokeObjectBound_Proxy",
		"IBindCtx_RevokeObjectBound_Stub",
		"IBindCtx_RevokeObjectParam_Proxy",
		"IBindCtx_RevokeObjectParam_Stub",
		"IBindCtx_SetBindOptions_Proxy",
		"IBindCtx_SetBindOptions_Stub",
		"IClassFactory_CreateInstance_Proxy",
		"IClassFactory_CreateInstance_Stub",
		"IClassFactory_LockServer_Proxy",
		"IClassFactory_LockServer_Stub",
		"IClassFactory_RemoteCreateInstance_Proxy",
		"IClassFactory_RemoteCreateInstance_Stub",
		"IClassFactory_RemoteLockServer_Proxy",
		"IClassFactory_RemoteLockServer_Stub",
		"IDataAdviseHolder_Advise_Proxy",
		"IDataAdviseHolder_Advise_Stub",
		"IDataAdviseHolder_EnumAdvise_Proxy",
		"IDataAdviseHolder_EnumAdvise_Stub",
		"IDataAdviseHolder_SendOnDataChange_Proxy",
		"IDataAdviseHolder_SendOnDataChange_Stub",
		"IDataAdviseHolder_Unadvise_Proxy",
		"IDataAdviseHolder_Unadvise_Stub",
		"IDataObject_DAdvise_Proxy",
		"IDataObject_DAdvise_Stub",
		"IDataObject_DUnadvise_Proxy",
		"IDataObject_DUnadvise_Stub",
		"IDataObject_EnumDAdvise_Proxy",
		"IDataObject_EnumDAdvise_Stub",
		"IDataObject_EnumFormatEtc_Proxy",
		"IDataObject_EnumFormatEtc_Stub",
		"IDataObject_GetCanonicalFormatEtc_Proxy",
		"IDataObject_GetCanonicalFormatEtc_Stub",
		"IDataObject_GetDataHere_Proxy",
		"IDataObject_GetDataHere_Stub",
		"IDataObject_GetData_Proxy",
		"IDataObject_GetData_Stub",
		"IDataObject_QueryGetData_Proxy",
		"IDataObject_QueryGetData_Stub",
		"IDataObject_RemoteGetDataHere_Proxy",
		"IDataObject_RemoteGetDataHere_Stub",
		"IDataObject_RemoteGetData_Proxy",
		"IDataObject_RemoteGetData_Stub",
		"IDataObject_RemoteSetData_Proxy",
		"IDataObject_RemoteSetData_Stub",
		"IDataObject_SetData_Proxy",
		"IDataObject_SetData_Stub",
		"IEnumFORMATETC_Clone_Proxy",
		"IEnumFORMATETC_Clone_Stub",
		"IEnumFORMATETC_Next_Proxy",
		"IEnumFORMATETC_Next_Stub",
		"IEnumFORMATETC_RemoteNext_Proxy",
		"IEnumFORMATETC_RemoteNext_Stub",
		"IEnumFORMATETC_Reset_Proxy",
		"IEnumFORMATETC_Reset_Stub",
		"IEnumFORMATETC_Skip_Proxy",
		"IEnumFORMATETC_Skip_Stub",
		"IEnumMoniker_Clone_Proxy",
		"IEnumMoniker_Clone_Stub",
		"IEnumMoniker_Next_Proxy",
		"IEnumMoniker_Next_Stub",
		"IEnumMoniker_RemoteNext_Proxy",
		"IEnumMoniker_RemoteNext_Stub",
		"IEnumMoniker_Reset_Proxy",
		"IEnumMoniker_Reset_Stub",
		"IEnumMoniker_Skip_Proxy",
		"IEnumMoniker_Skip_Stub",
		"IEnumSTATDATA_Clone_Proxy",
		"IEnumSTATDATA_Clone_Stub",
		"IEnumSTATDATA_Next_Proxy",
		"IEnumSTATDATA_Next_Stub",
		"IEnumSTATDATA_RemoteNext_Proxy",
		"IEnumSTATDATA_RemoteNext_Stub",
		"IEnumSTATDATA_Reset_Proxy",
		"IEnumSTATDATA_Reset_Stub",
		"IEnumSTATDATA_Skip_Proxy",
		"IEnumSTATDATA_Skip_Stub",
		"IEnumSTATSTG_Clone_Proxy",
		"IEnumSTATSTG_Clone_Stub",
		"IEnumSTATSTG_Next_Proxy",
		"IEnumSTATSTG_Next_Stub",
		"IEnumSTATSTG_RemoteNext_Proxy",
		"IEnumSTATSTG_RemoteNext_Stub",
		"IEnumSTATSTG_Reset_Proxy",
		"IEnumSTATSTG_Reset_Stub",
		"IEnumSTATSTG_Skip_Proxy",
		"IEnumSTATSTG_Skip_Stub",
		"IEnumString_Clone_Proxy",
		"IEnumString_Clone_Stub",
		"IEnumString_Next_Proxy",
		"IEnumString_Next_Stub",
		"IEnumString_RemoteNext_Proxy",
		"IEnumString_RemoteNext_Stub",
		"IEnumString_Reset_Proxy",
		"IEnumString_Reset_Stub",
		"IEnumString_Skip_Proxy",
		"IEnumString_Skip_Stub",
		"IEnumUnknown_Clone_Proxy",
		"IEnumUnknown_Clone_Stub",
		"IEnumUnknown_Next_Proxy",
		"IEnumUnknown_Next_Stub",
		"IEnumUnknown_RemoteNext_Proxy",
		"IEnumUnknown_RemoteNext_Stub",
		"IEnumUnknown_Reset_Proxy",
		"IEnumUnknown_Reset_Stub",
		"IEnumUnknown_Skip_Proxy",
		"IEnumUnknown_Skip_Stub",
		"IExternalConnection_AddConnection_Proxy",
		"IExternalConnection_AddConnection_Stub",
		"IExternalConnection_ReleaseConnection_Proxy",
		"IExternalConnection_ReleaseConnection_Stub",
		"IIDFromString",
		"ILockBytes_Flush_Proxy",
		"ILockBytes_Flush_Stub",
		"ILockBytes_LockRegion_Proxy",
		"ILockBytes_LockRegion_Stub",
		"ILockBytes_ReadAt_Proxy",
		"ILockBytes_ReadAt_Stub",
		"ILockBytes_RemoteReadAt_Proxy",
		"ILockBytes_RemoteReadAt_Stub",
		"ILockBytes_RemoteWriteAt_Proxy",
		"ILockBytes_RemoteWriteAt_Stub",
		"ILockBytes_SetSize_Proxy",
		"ILockBytes_SetSize_Stub",
		"ILockBytes_Stat_Proxy",
		"ILockBytes_Stat_Stub",
		"ILockBytes_UnlockRegion_Proxy",
		"ILockBytes_UnlockRegion_Stub",
		"ILockBytes_WriteAt_Proxy",
		"ILockBytes_WriteAt_Stub",
		"IMallocSpy_PostAlloc_Proxy",
		"IMallocSpy_PostAlloc_Stub",
		"IMallocSpy_PostDidAlloc_Proxy",
		"IMallocSpy_PostDidAlloc_Stub",
		"IMallocSpy_PostFree_Proxy",
		"IMallocSpy_PostFree_Stub",
		"IMallocSpy_PostGetSize_Proxy",
		"IMallocSpy_PostGetSize_Stub",
		"IMallocSpy_PostHeapMinimize_Proxy",
		"IMallocSpy_PostHeapMinimize_Stub",
		"IMallocSpy_PostRealloc_Proxy",
		"IMallocSpy_PostRealloc_Stub",
		"IMallocSpy_PreAlloc_Proxy",
		"IMallocSpy_PreAlloc_Stub",
		"IMallocSpy_PreDidAlloc_Proxy",
		"IMallocSpy_PreDidAlloc_Stub",
		"IMallocSpy_PreFree_Proxy",
		"IMallocSpy_PreFree_Stub",
		"IMallocSpy_PreGetSize_Proxy",
		"IMallocSpy_PreGetSize_Stub",
		"IMallocSpy_PreHeapMinimize_Proxy",
		"IMallocSpy_PreHeapMinimize_Stub",
		"IMallocSpy_PreRealloc_Proxy",
		"IMallocSpy_PreRealloc_Stub",
		"IMalloc_Alloc_Proxy",
		"IMalloc_Alloc_Stub",
		"IMalloc_DidAlloc_Proxy",
		"IMalloc_DidAlloc_Stub",
		"IMalloc_Free_Proxy",
		"IMalloc_Free_Stub",
		"IMalloc_GetSize_Proxy",
		"IMalloc_GetSize_Stub",
		"IMalloc_HeapMinimize_Proxy",
		"IMalloc_HeapMinimize_Stub",
		"IMalloc_Realloc_Proxy",
		"IMalloc_Realloc_Stub",
		"IMarshal_DisconnectObject_Proxy",
		"IMarshal_DisconnectObject_Stub",
		"IMarshal_GetMarshalSizeMax_Proxy",
		"IMarshal_GetMarshalSizeMax_Stub",
		"IMarshal_GetUnmarshalClass_Proxy",
		"IMarshal_GetUnmarshalClass_Stub",
		"IMarshal_MarshalInterface_Proxy",
		"IMarshal_MarshalInterface_Stub",
		"IMarshal_ReleaseMarshalData_Proxy",
		"IMarshal_ReleaseMarshalData_Stub",
		"IMarshal_UnmarshalInterface_Proxy",
		"IMarshal_UnmarshalInterface_Stub",
		"IMessageFilter_HandleInComingCall_Proxy",
		"IMessageFilter_HandleInComingCall_Stub",
		"IMessageFilter_MessagePending_Proxy",
		"IMessageFilter_MessagePending_Stub",
		"IMessageFilter_RetryRejectedCall_Proxy",
		"IMessageFilter_RetryRejectedCall_Stub",
		"IMoniker_BindToObject_Proxy",
		"IMoniker_BindToObject_Stub",
		"IMoniker_BindToStorage_Proxy",
		"IMoniker_BindToStorage_Stub",
		"IMoniker_CommonPrefixWith_Proxy",
		"IMoniker_CommonPrefixWith_Stub",
		"IMoniker_ComposeWith_Proxy",
		"IMoniker_ComposeWith_Stub",
		"IMoniker_Enum_Proxy",
		"IMoniker_Enum_Stub",
		"IMoniker_GetDisplayName_Proxy",
		"IMoniker_GetDisplayName_Stub",
		"IMoniker_GetTimeOfLastChange_Proxy",
		"IMoniker_GetTimeOfLastChange_Stub",
		"IMoniker_Hash_Proxy",
		"IMoniker_Hash_Stub",
		"IMoniker_Inverse_Proxy",
		"IMoniker_Inverse_Stub",
		"IMoniker_IsEqual_Proxy",
		"IMoniker_IsEqual_Stub",
		"IMoniker_IsRunning_Proxy",
		"IMoniker_IsRunning_Stub",
		"IMoniker_IsSystemMoniker_Proxy",
		"IMoniker_IsSystemMoniker_Stub",
		"IMoniker_ParseDisplayName_Proxy",
		"IMoniker_ParseDisplayName_Stub",
		"IMoniker_Reduce_Proxy",
		"IMoniker_Reduce_Stub",
		"IMoniker_RelativePathTo_Proxy",
		"IMoniker_RelativePathTo_Stub",
		"IMoniker_RemoteBindToObject_Proxy",
		"IMoniker_RemoteBindToObject_Stub",
		"IMoniker_RemoteBindToStorage_Proxy",
		"IMoniker_RemoteBindToStorage_Stub",
		"IPSFactoryBuffer_CreateProxy_Proxy",
		"IPSFactoryBuffer_CreateProxy_Stub",
		"IPSFactoryBuffer_CreateStub_Proxy",
		"IPSFactoryBuffer_CreateStub_Stub",
		"IPersistFile_GetCurFile_Proxy",
		"IPersistFile_GetCurFile_Stub",
		"IPersistFile_IsDirty_Proxy",
		"IPersistFile_IsDirty_Stub",
		"IPersistFile_Load_Proxy",
		"IPersistFile_Load_Stub",
		"IPersistFile_SaveCompleted_Proxy",
		"IPersistFile_SaveCompleted_Stub",
		"IPersistFile_Save_Proxy",
		"IPersistFile_Save_Stub",
		"IPersistStorage_HandsOffStorage_Proxy",
		"IPersistStorage_HandsOffStorage_Stub",
		"IPersistStorage_InitNew_Proxy",
		"IPersistStorage_InitNew_Stub",
		"IPersistStorage_IsDirty_Proxy",
		"IPersistStorage_IsDirty_Stub",
		"IPersistStorage_Load_Proxy",
		"IPersistStorage_Load_Stub",
		"IPersistStorage_SaveCompleted_Proxy",
		"IPersistStorage_SaveCompleted_Stub",
		"IPersistStorage_Save_Proxy",
		"IPersistStorage_Save_Stub",
		"IPersistStream_GetSizeMax_Proxy",
		"IPersistStream_GetSizeMax_Stub",
		"IPersistStream_IsDirty_Proxy",
		"IPersistStream_IsDirty_Stub",
		"IPersistStream_Load_Proxy",
		"IPersistStream_Load_Stub",
		"IPersistStream_Save_Proxy",
		"IPersistStream_Save_Stub",
		"IPersist_GetClassID_Proxy",
		"IPersist_GetClassID_Stub",
		"IROTData_GetComparisonData_Proxy",
		"IROTData_GetComparisonData_Stub",
		"IRootStorage_SwitchToFile_Proxy",
		"IRootStorage_SwitchToFile_Stub",
		"IRpcChannelBuffer_FreeBuffer_Proxy",
		"IRpcChannelBuffer_FreeBuffer_Stub",
		"IRpcChannelBuffer_GetBuffer_Proxy",
		"IRpcChannelBuffer_GetBuffer_Stub",
		"IRpcChannelBuffer_GetDestCtx_Proxy",
		"IRpcChannelBuffer_GetDestCtx_Stub",
		"IRpcChannelBuffer_IsConnected_Proxy",
		"IRpcChannelBuffer_IsConnected_Stub",
		"IRpcChannelBuffer_SendReceive_Proxy",
		"IRpcChannelBuffer_SendReceive_Stub",
		"IRpcProxyBuffer_Connect_Proxy",
		"IRpcProxyBuffer_Connect_Stub",
		"IRpcProxyBuffer_Disconnect_Proxy",
		"IRpcProxyBuffer_Disconnect_Stub",
		"IRpcStubBuffer_Connect_Proxy",
		"IRpcStubBuffer_Connect_Stub",
		"IRpcStubBuffer_CountRefs_Proxy",
		"IRpcStubBuffer_CountRefs_Stub",
		"IRpcStubBuffer_DebugServerQueryInterface_Proxy",
		"IRpcStubBuffer_DebugServerQueryInterface_Stub",
		"IRpcStubBuffer_DebugServerRelease_Proxy",
		"IRpcStubBuffer_DebugServerRelease_Stub",
		"IRpcStubBuffer_Disconnect_Proxy",
		"IRpcStubBuffer_Disconnect_Stub",
		"IRpcStubBuffer_Invoke_Proxy",
		"IRpcStubBuffer_Invoke_Stub",
		"IRpcStubBuffer_IsIIDSupported_Proxy",
		"IRpcStubBuffer_IsIIDSupported_Stub",
		"IRunnableObject_GetRunningClass_Proxy",
		"IRunnableObject_GetRunningClass_Stub",
		"IRunnableObject_IsRunning_Proxy",
		"IRunnableObject_IsRunning_Stub",
		"IRunnableObject_LockRunning_Proxy",
		"IRunnableObject_LockRunning_Stub",
		"IRunnableObject_Run_Proxy",
		"IRunnableObject_Run_Stub",
		"IRunnableObject_SetContainedObject_Proxy",
		"IRunnableObject_SetContainedObject_Stub",
		"IRunningObjectTable_EnumRunning_Proxy",
		"IRunningObjectTable_EnumRunning_Stub",
		"IRunningObjectTable_GetObject_Proxy",
		"IRunningObjectTable_GetObject_Stub",
		"IRunningObjectTable_GetTimeOfLastChange_Proxy",
		"IRunningObjectTable_GetTimeOfLastChange_Stub",
		"IRunningObjectTable_IsRunning_Proxy",
		"IRunningObjectTable_IsRunning_Stub",
		"IRunningObjectTable_NoteChangeTime_Proxy",
		"IRunningObjectTable_NoteChangeTime_Stub",
		"IRunningObjectTable_Register_Proxy",
		"IRunningObjectTable_Register_Stub",
		"IRunningObjectTable_Revoke_Proxy",
		"IRunningObjectTable_Revoke_Stub",
		"IStdMarshalInfo_GetClassForHandler_Proxy",
		"IStdMarshalInfo_GetClassForHandler_Stub",
		"IStorage_Commit_Proxy",
		"IStorage_Commit_Stub",
		"IStorage_CopyTo_Proxy",
		"IStorage_CopyTo_Stub",
		"IStorage_CreateStorage_Proxy",
		"IStorage_CreateStorage_Stub",
		"IStorage_CreateStream_Proxy",
		"IStorage_CreateStream_Stub",
		"IStorage_DestroyElement_Proxy",
		"IStorage_DestroyElement_Stub",
		"IStorage_EnumElements_Proxy",
		"IStorage_EnumElements_Stub",
		"IStorage_MoveElementTo_Proxy",
		"IStorage_MoveElementTo_Stub",
		"IStorage_OpenStorage_Proxy",
		"IStorage_OpenStorage_Stub",
		"IStorage_OpenStream_Proxy",
		"IStorage_OpenStream_Stub",
		"IStorage_RemoteEnumElements_Proxy",
		"IStorage_RemoteEnumElements_Stub",
		"IStorage_RemoteOpenStream_Proxy",
		"IStorage_RemoteOpenStream_Stub",
		"IStorage_RenameElement_Proxy",
		"IStorage_RenameElement_Stub",
		"IStorage_Revert_Proxy",
		"IStorage_Revert_Stub",
		"IStorage_SetClass_Proxy",
		"IStorage_SetClass_Stub",
		"IStorage_SetElementTimes_Proxy",
		"IStorage_SetElementTimes_Stub",
		"IStorage_SetStateBits_Proxy",
		"IStorage_SetStateBits_Stub",
		"IStorage_Stat_Proxy",
		"IStorage_Stat_Stub",
		"IStream_Clone_Proxy",
		"IStream_Clone_Stub",
		"IStream_Commit_Proxy",
		"IStream_Commit_Stub",
		"IStream_CopyTo_Proxy",
		"IStream_CopyTo_Stub",
		"IStream_LockRegion_Proxy",
		"IStream_LockRegion_Stub",
		"IStream_Read_Proxy",
		"IStream_Read_Stub",
		"IStream_RemoteCopyTo_Proxy",
		"IStream_RemoteCopyTo_Stub",
		"IStream_RemoteRead_Proxy",
		"IStream_RemoteRead_Stub",
		"IStream_RemoteSeek_Proxy",
		"IStream_RemoteSeek_Stub",
		"IStream_RemoteWrite_Proxy",
		"IStream_RemoteWrite_Stub",
		"IStream_Revert_Proxy",
		"IStream_Revert_Stub",
		"IStream_Seek_Proxy",
		"IStream_Seek_Stub",
		"IStream_SetSize_Proxy",
		"IStream_SetSize_Stub",
		"IStream_Stat_Proxy",
		"IStream_Stat_Stub",
		"IStream_UnlockRegion_Proxy",
		"IStream_UnlockRegion_Stub",
		"IStream_Write_Proxy",
		"IStream_Write_Stub",
		"IUnknown_AddRef_Proxy",
		"IUnknown_AddRef_Stub",
		"IUnknown_QueryInterface_Proxy",
		"IUnknown_QueryInterface_Stub",
		"IUnknown_Release_Proxy",
		"IUnknown_Release_Stub",
		"I_NsClientBindDone",
		"I_NsClientBindSearch",
		"I_NsServerBindSearch",
		"I_RpcAllocate",
		"I_RpcAsyncSendReceive",
		"I_RpcBindingCopy",
		"I_RpcBindingInqDynamicEndpoint",
		"I_RpcBindingInqTransportType",
		"I_RpcBindingIsClientLocal",
		"I_RpcBindingSetAsync",
		"I_RpcClearMutex",
		"I_RpcConnectionInqSockBuffSize",
		"I_RpcConnectionSetSockBuffSize",
		"I_RpcDeleteMutex",
		"I_RpcFree",
		"I_RpcFreeBuffer",
		"I_RpcGetAssociationContext",
		"I_RpcGetBuffer",
		"I_RpcGetCurrentCallHandle",
		"I_RpcGetThreadWindowHandle",
		"I_RpcIfInqTransferSyntaxes",
		"I_RpcMapWin32Status",
		"I_RpcMonitorAssociation",
		"I_RpcNsBindingSetEntryName",
		"I_RpcNsGetBuffer",
		"I_RpcNsRaiseException",
		"I_RpcNsSendReceive",
		"I_RpcPauseExecution",
		"I_RpcReBindBuffer",
		"I_RpcRequestMutex",
		"I_RpcSend",
		"I_RpcSendReceive",
		"I_RpcServerThreadContinueListening",
		"I_RpcServerThreadPauseListening",
		"I_RpcServerUnregisterEndpointA",
		"I_RpcServerUnregisterEndpointW",
		"I_RpcSetAssociationContext",
		"I_RpcSsDontSerializeContext",
		"I_RpcStopMonitorAssociation",
		"I_UuidCreate",
		"ImmAssociateContext",
		"ImmConfigureIMEA",
		"ImmConfigureIMEW",
		"ImmCreateContext",
		"ImmDestroyContext",
		"ImmDisableIME",
		"ImmEnumRegisterWordA",
		"ImmEnumRegisterWordW",
		"ImmEscapeA",
		"ImmEscapeW",
		"ImmGetCandidateListA",
		"ImmGetCandidateListCountA",
		"ImmGetCandidateListCountW",
		"ImmGetCandidateListW",
		"ImmGetCandidateWindow",
		"ImmGetCompositionFontA",
		"ImmGetCompositionFontW",
		"ImmGetCompositionStringA",
		"ImmGetCompositionStringW",
		"ImmGetCompositionWindow",
		"ImmGetContext",
		"ImmGetConversionListA",
		"ImmGetConversionListW",
		"ImmGetConversionStatus",
		"ImmGetDefaultIMEWnd",
		"ImmGetDescriptionA",
		"ImmGetDescriptionW",
		"ImmGetGuideLineA",
		"ImmGetGuideLineW",
		"ImmGetIMEFileNameA",
		"ImmGetIMEFileNameW",
		"ImmGetImeMenuItemsA",
		"ImmGetImeMenuItemsW",
		"ImmGetOpenStatus",
		"ImmGetProperty",
		"ImmGetRegisterWordStyleA",
		"ImmGetRegisterWordStyleW",
		"ImmGetStatusWindowPos",
		"ImmGetVirtualKey",
		"ImmInstallIMEA",
		"ImmInstallIMEW",
		"ImmIsIME",
		"ImmIsUIMessageA",
		"ImmIsUIMessageW",
		"ImmNotifyIME",
		"ImmRegisterWordA",
		"ImmRegisterWordW",
		"ImmReleaseContext",
		"ImmSetCandidateWindow",
		"ImmSetCompositionFontA",
		"ImmSetCompositionFontW",
		"ImmSetCompositionStringA",
		"ImmSetCompositionStringW",
		"ImmSetCompositionWindow",
		"ImmSetConversionStatus",
		"ImmSetOpenStatus",
		"ImmSetStatusWindowPos",
		"ImmSimulateHotKey",
		"ImmUnregisterWordA",
		"ImmUnregisterWordW",
		"ImpersonateDdeClientWindow",
		"ImpersonateLoggedOnUser",
		"ImpersonateNamedPipeClient",
		"ImpersonateSelf",
		"InSendMessage",
		"InflateRect",
		"InitAtomTable",
		"InitializeAcl",
		"InitializeCriticalSection",
		"InitializeCriticalSectionAndSpinCount",
		"InitializeSecurityDescriptor",
		"InitializeSid",
		"InitiateSystemShutdownA",
		"InitiateSystemShutdownW",
		"InsertMenuA",
		"InsertMenuItemA",
		"InsertMenuItemW",
		"InsertMenuW",
		"InterlockedCompareExchange",
		"InterlockedDecrement",
		"InterlockedExchange",
		"InterlockedExchangeAdd",
		"InterlockedIncrement",
		"InternalGetWindowText",
		"IntersectClipRect",
		"IntersectRect",
		"InvalidateRect",
		"InvalidateRgn",
		"InvertRect",
		"InvertRgn",
		"IsAccelerator",
		"IsBadCodePtr",
		"IsBadHugeReadPtr",
		"IsBadHugeWritePtr",
		"IsBadReadPtr",
		"IsBadStringPtrA",
		"IsBadStringPtrW",
		"IsBadWritePtr",
		"IsCharAlphaA",
		"IsCharAlphaNumericA",
		"IsCharAlphaNumericW",
		"IsCharAlphaW",
		"IsCharLowerA",
		"IsCharLowerW",
		"IsCharUpperA",
		"IsCharUpperW",
		"IsChild",
		"IsClipboardFormatAvailable",
		"IsDBCSLeadByte",
		"IsDBCSLeadByteEx",
		"IsDebuggerPresent",
		"IsDialogMessageA",
		"IsDialogMessageW",
		"IsDlgButtonChecked",
		"IsIconic",
		"IsMenu",
		"IsNLSDefinedString",
		"IsProcessorFeaturePresent",
		"IsRectEmpty",
		"IsSystemResumeAutomatic",
		"IsTextUnicode",
		"IsValidAcl",
		"IsValidCodePage",
		"IsValidLocale",
		"IsValidSecurityDescriptor",
		"IsValidSid",
		"IsWindow",
		"IsWindowEnabled",
		"IsWindowUnicode",
		"IsWindowVisible",
		"IsZoomed",
		"KillTimer",
		"LCMapStringA",
		"LCMapStringW",
		"LHashValOfNameSys",
		"LHashValOfNameSysA",
		"LPtoDP",
		"LZClose",
		"LZCopy",
		"LZDone",
		"LZInit",
		"LZOpenFileA",
		"LZOpenFileW",
		"LZRead",
		"LZSeek",
		"LZStart",
		"LeaveCriticalSection",
		"LineDDA",
		"LineTo",
		"LoadAcceleratorsA",
		"LoadAcceleratorsW",
		"LoadBitmapA",
		"LoadBitmapW",
		"LoadCursorA",
		"LoadCursorFromFileA",
		"LoadCursorFromFileW",
		"LoadCursorW",
		"LoadIconA",
		"LoadIconW",
		"LoadImageA",
		"LoadImageW",
		"LoadKeyboardLayoutA",
		"LoadKeyboardLayoutW",
		"LoadLibraryA",
		"LoadLibraryExA",
		"LoadLibraryExW",
		"LoadLibraryW",
		"LoadMenuA",
		"LoadMenuIndirectA",
		"LoadMenuIndirectW",
		"LoadMenuW",
		"LoadModule",
		"LoadRegTypeLib",
		"LoadResource",
		"LoadStringA",
		"LoadStringW",
		"LoadTypeLib",
		"LoadTypeLibEx",
		"LocalAlloc",
		"LocalCompact",
		"LocalDiscard",
		"LocalFileTimeToFileTime",
		"LocalFlags",
		"LocalFree",
		"LocalHandle",
		"LocalLock",
		"LocalReAlloc",
		"LocalShrink",
		"LocalSize",
		"LocalUnlock",
		"LockFile",
		"LockFileEx",
		"LockResource",
		"LockServiceDatabase",
		"LockWindowUpdate",
		"LogonUserA",
		"LogonUserW",
		"LookupAccountNameA",
		"LookupAccountNameW",
		"LookupAccountSidA",
		"LookupAccountSidW",
		"LookupIconIdFromDirectory",
		"LookupIconIdFromDirectoryEx",
		"LookupPrivilegeDisplayNameA",
		"LookupPrivilegeDisplayNameW",
		"LookupPrivilegeNameA",
		"LookupPrivilegeNameW",
		"LookupPrivilegeValueA",
		"LookupPrivilegeValueW",
		"MIDL_user_allocate",
		"MIDL_user_free",
		"MIDL_wchar_strcpy",
		"MIDL_wchar_strlen",
		"MakeAbsoluteSD",
		"MakeSelfRelativeSD",
		"MapDialogRect",
		"MapGenericMask",
		"MapViewOfFile",
		"MapViewOfFileEx",
		"MapVirtualKeyA",
		"MapVirtualKeyExA",
		"MapVirtualKeyExW",
		"MapVirtualKeyW",
		"MapWindowPoints",
		"MaskBlt",
		"MenuItemFromPoint",
		"MessageBeep",
		"MessageBoxA",
		"MessageBoxExA",
		"MessageBoxExW",
		"MessageBoxIndirectA",
		"MessageBoxIndirectW",
		"MessageBoxW",
		"MkParseDisplayName",
		"ModifyMenuA",
		"ModifyMenuW",
		"ModifyWorldTransform",
		"MonikerCommonPrefixWith",
		"MonikerRelativePathTo",
		"MoveFileA",
		"MoveFileExA",
		"MoveFileExW",
		"MoveFileW",
		"MoveToEx",
		"MoveWindow",
		"MsgWaitForMultipleObjects",
		"MsgWaitForMultipleObjectsEx",
		"MulDiv",
		"MultiByteToWideChar",
		"MultinetGetConnectionPerformanceA",
		"MultinetGetConnectionPerformanceW",
		"NDRCContextBinding",
		"NDRCContextMarshall",
		"NDRCContextUnmarshall",
		"NDRSContextMarshall",
		"NDRSContextUnmarshall",
		"NDRcopy",
		"NdrAllocate",
		"NdrByteCountPointerBufferSize",
		"NdrByteCountPointerFree",
		"NdrByteCountPointerMarshall",
		"NdrByteCountPointerUnmarshall",
		"NdrClearOutParameters",
		"NdrClientCall",
		"NdrClientCall2",
		"NdrClientContextMarshall",
		"NdrClientContextUnmarshall",
		"NdrClientInitialize",
		"NdrClientInitializeNew",
		"NdrComplexArrayBufferSize",
		"NdrComplexArrayFree",
		"NdrComplexArrayMarshall",
		"NdrComplexArrayMemorySize",
		"NdrComplexArrayUnmarshall",
		"NdrComplexStructBufferSize",
		"NdrComplexStructFree",
		"NdrComplexStructMarshall",
		"NdrComplexStructMemorySize",
		"NdrComplexStructUnmarshall",
		"NdrConformantArrayBufferSize",
		"NdrConformantArrayFree",
		"NdrConformantArrayMarshall",
		"NdrConformantArrayMemorySize",
		"NdrConformantArrayUnmarshall",
		"NdrConformantStringBufferSize",
		"NdrConformantStringMarshall",
		"NdrConformantStringMemorySize",
		"NdrConformantStringUnmarshall",
		"NdrConformantStructBufferSize",
		"NdrConformantStructFree",
		"NdrConformantStructMarshall",
		"NdrConformantStructMemorySize",
		"NdrConformantStructUnmarshall",
		"NdrConformantVaryingArrayBufferSize",
		"NdrConformantVaryingArrayFree",
		"NdrConformantVaryingArrayMarshall",
		"NdrConformantVaryingArrayMemorySize",
		"NdrConformantVaryingArrayUnmarshall",
		"NdrConformantVaryingStructBufferSize",
		"NdrConformantVaryingStructFree",
		"NdrConformantVaryingStructMarshall",
		"NdrConformantVaryingStructMemorySize",
		"NdrConformantVaryingStructUnmarshall",
		"NdrContextHandleSize",
		"NdrConvert",
		"NdrEncapsulatedUnionBufferSize",
		"NdrEncapsulatedUnionFree",
		"NdrEncapsulatedUnionMarshall",
		"NdrEncapsulatedUnionMemorySize",
		"NdrEncapsulatedUnionUnmarshall",
		"NdrFixedArrayBufferSize",
		"NdrFixedArrayFree",
		"NdrFixedArrayMarshall",
		"NdrFixedArrayMemorySize",
		"NdrFixedArrayUnmarshall",
		"NdrFreeBuffer",
		"NdrFullPointerFree",
		"NdrFullPointerInsertRefId",
		"NdrFullPointerQueryPointer",
		"NdrFullPointerQueryRefId",
		"NdrFullPointerXlatFree",
		"NdrFullPointerXlatInit",
		"NdrGetBuffer",
		"NdrHardStructBufferSize",
		"NdrHardStructFree",
		"NdrHardStructMarshall",
		"NdrHardStructMemorySize",
		"NdrHardStructUnmarshall",
		"NdrInterfacePointerBufferSize",
		"NdrInterfacePointerFree",
		"NdrInterfacePointerMarshall",
		"NdrInterfacePointerMemorySize",
		"NdrInterfacePointerUnmarshall",
		"NdrMapCommAndFaultStatus",
		"NdrNonConformantStringBufferSize",
		"NdrNonConformantStringMarshall",
		"NdrNonConformantStringMemorySize",
		"NdrNonConformantStringUnmarshall",
		"NdrNonEncapsulatedUnionBufferSize",
		"NdrNonEncapsulatedUnionFree",
		"NdrNonEncapsulatedUnionMarshall",
		"NdrNonEncapsulatedUnionMemorySize",
		"NdrNonEncapsulatedUnionUnmarshall",
		"NdrNsGetBuffer",
		"NdrNsSendReceive",
		"NdrOleAllocate",
		"NdrOleFree",
		"NdrPointerBufferSize",
		"NdrPointerFree",
		"NdrPointerMarshall",
		"NdrPointerMemorySize",
		"NdrPointerUnmarshall",
		"NdrRpcSmClientAllocate",
		"NdrRpcSmClientFree",
		"NdrRpcSmSetClientToOsf",
		"NdrRpcSsDefaultAllocate",
		"NdrRpcSsDefaultFree",
		"NdrRpcSsDisableAllocate",
		"NdrRpcSsEnableAllocate",
		"NdrSH_Copy",
		"NdrSH_IfAlloc",
		"NdrSH_IfAllocCopy",
		"NdrSH_IfAllocRef",
		"NdrSH_IfAllocSet",
		"NdrSH_IfCopy",
		"NdrSH_IfFree",
		"NdrSH_StringMarshall",
		"NdrSH_StringUnMarshall",
		"NdrSH_TLUPDecision",
		"NdrSH_TLUPDecisionBuffer",
		"NdrSH_UPDecision",
		"NdrSendReceive",
		"NdrServerCall",
		"NdrServerContextMarshall",
		"NdrServerContextUnmarshall",
		"NdrServerInitialize",
		"NdrServerInitializeMarshall",
		"NdrServerInitializeNew",
		"NdrServerInitializeUnmarshall",
		"NdrServerMarshall",
		"NdrServerUnmarshall",
		"NdrSimpleStructBufferSize",
		"NdrSimpleStructFree",
		"NdrSimpleStructMarshall",
		"NdrSimpleStructMemorySize",
		"NdrSimpleStructUnmarshall",
		"NdrSimpleTypeMarshall",
		"NdrSimpleTypeUnmarshall",
		"NdrStubCall",
		"NdrUserMarshalBufferSize",
		"NdrUserMarshalFree",
		"NdrUserMarshalMarshall",
		"NdrUserMarshalMemorySize",
		"NdrUserMarshalUnmarshall",
		"NdrVaryingArrayBufferSize",
		"NdrVaryingArrayFree",
		"NdrVaryingArrayMarshall",
		"NdrVaryingArrayMemorySize",
		"NdrVaryingArrayUnmarshall",
		"NdrXmitOrRepAsBufferSize",
		"NdrXmitOrRepAsFree",
		"NdrXmitOrRepAsMarshall",
		"NdrXmitOrRepAsMemorySize",
		"NdrXmitOrRepAsUnmarshall",
		"Netbios",
		"NotifyBootConfigStatus",
		"NotifyChangeEventLog",
		"OaBuildVersion",
		"ObjectCloseAuditAlarmA",
		"ObjectCloseAuditAlarmW",
		"ObjectDeleteAuditAlarmA",
		"ObjectDeleteAuditAlarmW",
		"ObjectOpenAuditAlarmA",
		"ObjectOpenAuditAlarmW",
		"ObjectPrivilegeAuditAlarmA",
		"ObjectPrivilegeAuditAlarmW",
		"OemKeyScan",
		"OemToCharA",
		"OemToCharBuffA",
		"OemToCharBuffW",
		"OemToCharW",
		"OffsetClipRgn",
		"OffsetRect",
		"OffsetRgn",
		"OffsetViewportOrgEx",
		"OffsetWindowOrgEx",
		"OleBuildVersion",
		"OleConvertIStorageToOLESTREAM",
		"OleConvertIStorageToOLESTREAMEx",
		"OleConvertOLESTREAMToIStorage",
		"OleConvertOLESTREAMToIStorageEx",
		"OleCreate",
		"OleCreateDefaultHandler",
		"OleCreateEmbeddingHelper",
		"OleCreateFromData",
		"OleCreateFromFile",
		"OleCreateLink",
		"OleCreateLinkFromData",
		"OleCreateLinkToFile",
		"OleCreateMenuDescriptor",
		"OleCreateStaticFromData",
		"OleDestroyMenuDescriptor",
		"OleDoAutoConvert",
		"OleDraw",
		"OleDuplicateData",
		"OleFlushClipboard",
		"OleGetAutoConvert",
		"OleGetClipboard",
		"OleGetIconOfClass",
		"OleGetIconOfFile",
		"OleInitialize",
		"OleIsCurrentClipboard",
		"OleIsRunning",
		"OleLoad",
		"OleLoadFromStream",
		"OleLockRunning",
		"OleMetafilePictFromIconAndLabel",
		"OleNoteObjectVisible",
		"OleQueryCreateFromData",
		"OleQueryLinkFromData",
		"OleRegEnumFormatEtc",
		"OleRegEnumVerbs",
		"OleRegGetMiscStatus",
		"OleRegGetUserType",
		"OleRun",
		"OleSave",
		"OleSaveToStream",
		"OleSetAutoConvert",
		"OleSetClipboard",
		"OleSetContainedObject",
		"OleSetMenuDescriptor",
		"OleTranslateAccelerator",
		"OleUninitialize",
		"OpenBackupEventLogA",
		"OpenBackupEventLogW",
		"OpenClipboard",
		"OpenDesktopA",
		"OpenDesktopW",
		"OpenDriver",
		"OpenEventA",
		"OpenEventLogA",
		"OpenEventLogW",
		"OpenEventW",
		"OpenFile",
		"OpenFileMappingA",
		"OpenFileMappingW",
		"OpenIcon",
		"OpenInputDesktop",
		"OpenMutexA",
		"OpenMutexW",
		"OpenPrinterA",
		"OpenPrinterW",
		"OpenProcess",
		"OpenProcessToken",
		"OpenSCManagerA",
		"OpenSCManagerW",
		"OpenSemaphoreA",
		"OpenSemaphoreW",
		"OpenServiceA",
		"OpenServiceW",
		"OpenThreadToken",
		"OpenWaitableTimerA",
		"OpenWaitableTimerW",
		"OpenWindowStationA",
		"OpenWindowStationW",
		"OutputDebugStringA",
		"OutputDebugStringW",
		"PackDDElParam",
		"PageSetupDlgA",
		"PageSetupDlgW",
		"PaintDesktop",
		"PaintRgn",
		"PatBlt",
		"PathToRegion",
		"PeekConsoleInputA",
		"PeekConsoleInputW",
		"PeekMessageA",
		"PeekMessageW",
		"PeekNamedPipe",
		"Pie",
		"PlayEnhMetaFile",
		"PlayEnhMetaFileRecord",
		"PlayMetaFile",
		"PlayMetaFileRecord",
		"PlaySoundA",
		"PlaySoundW",
		"PlgBlt",
		"PolyBezier",
		"PolyBezierTo",
		"PolyDraw",
		"PolyPolygon",
		"PolyPolyline",
		"PolyTextOutA",
		"PolyTextOutW",
		"Polygon",
		"Polyline",
		"PolylineTo",
		"PostMessageA",
		"PostMessageW",
		"PostQueuedCompletionStatus",
		"PostQuitMessage",
		"PostThreadMessageA",
		"PostThreadMessageW",
		"PrepareTape",
		"PrintDlgA",
		"PrintDlgW",
		"PrinterMessageBoxA",
		"PrinterMessageBoxW",
		"PrinterProperties",
		"PrivilegeCheck",
		"PrivilegedServiceAuditAlarmA",
		"PrivilegedServiceAuditAlarmW",
		"ProgIDFromCLSID",
		"PtInRect",
		"PtInRegion",
		"PtVisible",
		"PulseEvent",
		"PurgeComm",
		"QueryDosDeviceA",
		"QueryDosDeviceW",
		"QueryPathOfRegTypeLib",
		"QueryPerformanceCounter",
		"QueryPerformanceFrequency",
		"QueryServiceConfig2A",
		"QueryServiceConfig2W",
		"QueryServiceConfigA",
		"QueryServiceConfigW",
		"QueryServiceLockStatusA",
		"QueryServiceLockStatusW",
		"QueryServiceObjectSecurity",
		"QueryServiceStatus",
		"QueryServiceStatusEx",
		"QueueUserAPC",
		"RPC_CLIENT_FREE",
		"RPC_FORWARD_FUNCTION",
		"RPC_IF_CALLBACK_FN",
		"RPC_OBJECT_INQ_FN",
		"RaiseException",
		"ReadClassStg",
		"ReadClassStm",
		"ReadConsoleA",
		"ReadConsoleInputA",
		"ReadConsoleInputW",
		"ReadConsoleOutputA",
		"ReadConsoleOutputAttribute",
		"ReadConsoleOutputCharacterA",
		"ReadConsoleOutputCharacterW",
		"ReadConsoleOutputW",
		"ReadConsoleW",
		"ReadDirectoryChangesW",
		"ReadEventLogA",
		"ReadEventLogW",
		"ReadFile",
		"ReadFileEx",
		"ReadFileScatter",
		"ReadFmtUserTypeStg",
		"ReadPrinter",
		"ReadProcessMemory",
		"RealChildWindowFromPoint",
		"RealGetWindowClassA",
		"RealGetWindowClassW",
		"RealizePalette",
		"RectInRegion",
		"RectVisible",
		"Rectangle",
		"RedrawWindow",
		"RegCloseKey",
		"RegConnectRegistryA",
		"RegConnectRegistryW",
		"RegCreateKeyA",
		"RegCreateKeyExA",
		"RegCreateKeyExW",
		"RegCreateKeyW",
		"RegDeleteKeyA",
		"RegDeleteKeyW",
		"RegDeleteValueA",
		"RegDeleteValueW",
		"RegEnumKeyA",
		"RegEnumKeyExA",
		"RegEnumKeyExW",
		"RegEnumKeyW",
		"RegEnumValueA",
		"RegEnumValueW",
		"RegFlushKey",
		"RegGetKeySecurity",
		"RegLoadKeyA",
		"RegLoadKeyW",
		"RegNotifyChangeKeyValue",
		"RegOpenKeyA",
		"RegOpenKeyExA",
		"RegOpenKeyExW",
		"RegOpenKeyW",
		"RegQueryInfoKeyA",
		"RegQueryInfoKeyW",
		"RegQueryMultipleValuesA",
		"RegQueryMultipleValuesW",
		"RegQueryValueA",
		"RegQueryValueExA",
		"RegQueryValueExW",
		"RegQueryValueW",
		"RegReplaceKeyA",
		"RegReplaceKeyW",
		"RegRestoreKeyA",
		"RegRestoreKeyW",
		"RegSaveKeyA",
		"RegSaveKeyW",
		"RegSetKeySecurity",
		"RegSetValueA",
		"RegSetValueExA",
		"RegSetValueExW",
		"RegSetValueW",
		"RegUnLoadKeyA",
		"RegUnLoadKeyW",
		"RegisterActiveObject",
		"RegisterClassA",
		"RegisterClassExA",
		"RegisterClassExW",
		"RegisterClassW",
		"RegisterClipboardFormatA",
		"RegisterClipboardFormatW",
		"RegisterDragDrop",
		"RegisterEventSourceA",
		"RegisterEventSourceW",
		"RegisterHotKey",
		"RegisterServiceCtrlHandlerA",
		"RegisterServiceCtrlHandlerExA",
		"RegisterServiceCtrlHandlerExW",
		"RegisterServiceCtrlHandlerW",
		"RegisterTypeLib",
		"RegisterWindowMessageA",
		"RegisterWindowMessageW",
		"ReleaseCapture",
		"ReleaseDC",
		"ReleaseMutex",
		"ReleaseSemaphore",
		"ReleaseStgMedium",
		"RemoveDirectoryA",
		"RemoveDirectoryW",
		"RemoveFontResourceA",
		"RemoveFontResourceW",
		"RemoveMenu",
		"RemovePropA",
		"RemovePropW",
		"ReplaceTextA",
		"ReplaceTextW",
		"ReplyMessage",
		"ReportEventA",
		"ReportEventW",
		"ResetDCA",
		"ResetDCW",
		"ResetEvent",
		"ResetPrinterA",
		"ResetPrinterW",
		"ResetWriteWatch",
		"ResizePalette",
		"RestoreDC",
		"ResumeThread",
		"ReuseDDElParam",
		"RevertToSelf",
		"RevokeActiveObject",
		"RevokeDragDrop",
		"RoundRect",
		"RpcBindingCopy",
		"RpcBindingFree",
		"RpcBindingFromStringBindingA",
		"RpcBindingFromStringBindingW",
		"RpcBindingInqAuthClientA",
		"RpcBindingInqAuthClientW",
		"RpcBindingInqAuthInfoA",
		"RpcBindingInqAuthInfoExA",
		"RpcBindingInqAuthInfoExW",
		"RpcBindingInqAuthInfoW",
		"RpcBindingInqObject",
		"RpcBindingReset",
		"RpcBindingServerFromClient",
		"RpcBindingSetAuthInfoA",
		"RpcBindingSetAuthInfoExA",
		"RpcBindingSetAuthInfoExW",
		"RpcBindingSetAuthInfoW",
		"RpcBindingSetObject",
		"RpcBindingToStringBindingA",
		"RpcBindingToStringBindingW",
		"RpcBindingVectorFree",
		"RpcCancelThread",
		"RpcEpRegisterA",
		"RpcEpRegisterNoReplaceA",
		"RpcEpRegisterNoReplaceW",
		"RpcEpRegisterW",
		"RpcEpResolveBinding",
		"RpcEpUnregister",
		"RpcIfIdVectorFree",
		"RpcIfInqId",
		"RpcImpersonateClient",
		"RpcMgmtBindingInqParameter",
		"RpcMgmtBindingSetParameter",
		"RpcMgmtEnableIdleCleanup",
		"RpcMgmtEpEltInqBegin",
		"RpcMgmtEpEltInqDone",
		"RpcMgmtEpEltInqNextA",
		"RpcMgmtEpEltInqNextW",
		"RpcMgmtEpUnregister",
		"RpcMgmtInqComTimeout",
		"RpcMgmtInqDefaultProtectLevel",
		"RpcMgmtInqIfIds",
		"RpcMgmtInqParameter",
		"RpcMgmtInqServerPrincNameA",
		"RpcMgmtInqServerPrincNameW",
		"RpcMgmtInqStats",
		"RpcMgmtIsServerListening",
		"RpcMgmtSetAuthorizationFn",
		"RpcMgmtSetCancelTimeout",
		"RpcMgmtSetComTimeout",
		"RpcMgmtSetParameter",
		"RpcMgmtSetServerStackSize",
		"RpcMgmtStatsVectorFree",
		"RpcMgmtStopServerListening",
		"RpcMgmtWaitServerListen",
		"RpcNetworkInqProtseqsA",
		"RpcNetworkInqProtseqsW",
		"RpcNetworkIsProtseqValidA",
		"RpcNetworkIsProtseqValidW",
		"RpcNsBindingExportA",
		"RpcNsBindingExportW",
		"RpcNsBindingImportBeginA",
		"RpcNsBindingImportBeginW",
		"RpcNsBindingImportDone",
		"RpcNsBindingImportNext",
		"RpcNsBindingInqEntryNameA",
		"RpcNsBindingInqEntryNameW",
		"RpcNsBindingLookupBeginA",
		"RpcNsBindingLookupBeginW",
		"RpcNsBindingLookupDone",
		"RpcNsBindingLookupNext",
		"RpcNsBindingSelect",
		"RpcNsBindingUnexportA",
		"RpcNsBindingUnexportW",
		"RpcNsEntryExpandNameA",
		"RpcNsEntryExpandNameW",
		"RpcNsEntryObjectInqBeginA",
		"RpcNsEntryObjectInqBeginW",
		"RpcNsEntryObjectInqDone",
		"RpcNsEntryObjectInqNext",
		"RpcNsGroupDeleteA",
		"RpcNsGroupDeleteW",
		"RpcNsGroupMbrAddA",
		"RpcNsGroupMbrAddW",
		"RpcNsGroupMbrInqBeginA",
		"RpcNsGroupMbrInqBeginW",
		"RpcNsGroupMbrInqDone",
		"RpcNsGroupMbrInqNextA",
		"RpcNsGroupMbrInqNextW",
		"RpcNsGroupMbrRemoveA",
		"RpcNsGroupMbrRemoveW",
		"RpcNsMgmtBindingUnexportA",
		"RpcNsMgmtBindingUnexportW",
		"RpcNsMgmtEntryCreateA",
		"RpcNsMgmtEntryCreateW",
		"RpcNsMgmtEntryDeleteA",
		"RpcNsMgmtEntryDeleteW",
		"RpcNsMgmtEntryInqIfIdsA",
		"RpcNsMgmtEntryInqIfIdsW",
		"RpcNsMgmtHandleSetExpAge",
		"RpcNsMgmtInqExpAge",
		"RpcNsMgmtSetExpAge",
		"RpcNsProfileDeleteA",
		"RpcNsProfileDeleteW",
		"RpcNsProfileEltAddA",
		"RpcNsProfileEltAddW",
		"RpcNsProfileEltInqBeginA",
		"RpcNsProfileEltInqBeginW",
		"RpcNsProfileEltInqDone",
		"RpcNsProfileEltInqNextA",
		"RpcNsProfileEltInqNextW",
		"RpcNsProfileEltRemoveA",
		"RpcNsProfileEltRemoveW",
		"RpcObjectInqType",
		"RpcObjectSetType",
		"RpcProtseqVectorFreeA",
		"RpcProtseqVectorFreeW",
		"RpcRaiseException",
		"RpcRevertToSelf",
		"RpcServerInqDefaultPrincNameA",
		"RpcServerInqDefaultPrincNameW",
		"RpcServerInqIf",
		"RpcServerListen",
		"RpcServerRegisterAuthInfoA",
		"RpcServerRegisterAuthInfoW",
		"RpcServerRegisterIf",
		"RpcServerUnregisterIf",
		"RpcServerUseAllProtseqs",
		"RpcServerUseAllProtseqsEx",
		"RpcServerUseAllProtseqsIf",
		"RpcServerUseAllProtseqsIfEx",
		"RpcServerUseProtseqA",
		"RpcServerUseProtseqEpA",
		"RpcServerUseProtseqEpExA",
		"RpcServerUseProtseqEpExW",
		"RpcServerUseProtseqEpW",
		"RpcServerUseProtseqExA",
		"RpcServerUseProtseqExW",
		"RpcServerUseProtseqIfA",
		"RpcServerUseProtseqIfExA",
		"RpcServerUseProtseqIfExW",
		"RpcServerUseProtseqIfW",
		"RpcServerUseProtseqW",
		"RpcSmAllocate",
		"RpcSmClientFree",
		"RpcSmDestroyClientContext",
		"RpcSmDisableAllocate",
		"RpcSmEnableAllocate",
		"RpcSmFree",
		"RpcSmGetThreadHandle",
		"RpcSmSetThreadHandle",
		"RpcSsAllocate",
		"RpcSsDestroyClientContext",
		"RpcSsDisableAllocate",
		"RpcSsDontSerializeContext",
		"RpcSsEnableAllocate",
		"RpcSsFree",
		"RpcSsGetThreadHandle",
		"RpcSsSetThreadHandle",
		"RpcStringBindingComposeA",
		"RpcStringBindingComposeW",
		"RpcStringBindingParseA",
		"RpcStringBindingParseW",
		"RpcStringFreeA",
		"RpcStringFreeW",
		"RpcTestCancel",
		"SHAppBarMessage",
		"SHEmptyRecycleBinA",
		"SHEmptyRecycleBinW",
		"SHFileOperationA",
		"SHFileOperationW",
		"SHFreeNameMappings",
		"SHGetFileInfoA",
		"SHGetFileInfoW",
		"SHQueryRecycleBinA",
		"SHQueryRecycleBinW",
		"SNB_free_inst",
		"SNB_free_xmit",
		"SNB_from_xmit",
		"SNB_to_xmit",
		"SafeArrayAccessData",
		"SafeArrayAllocData",
		"SafeArrayAllocDescriptor",
		"SafeArrayAllocDescriptorEx",
		"SafeArrayCopy",
		"SafeArrayCreate",
		"SafeArrayCreateVector",
		"SafeArrayCreateVectorEx",
		"SafeArrayDestroy",
		"SafeArrayDestroyData",
		"SafeArrayDestroyDescriptor",
		"SafeArrayGetDim",
		"SafeArrayGetElement",
		"SafeArrayGetElemsize",
		"SafeArrayGetIID",
		"SafeArrayGetLBound",
		"SafeArrayGetRecordInfo",
		"SafeArrayGetUBound",
		"SafeArrayGetVartype",
		"SafeArrayLock",
		"SafeArrayPtrOfIndex",
		"SafeArrayPutElement",
		"SafeArrayRedim",
		"SafeArraySetIID",
		"SafeArraySetRecordInfo",
		"SafeArrayUnaccessData",
		"SafeArrayUnlock",
		"SaveDC",
		"ScaleViewportExtEx",
		"ScaleWindowExtEx",
		"ScheduleJob",
		"ScreenToClient",
		"ScrollConsoleScreenBufferA",
		"ScrollConsoleScreenBufferW",
		"ScrollDC",
		"ScrollWindow",
		"ScrollWindowEx",
		"SearchPathA",
		"SearchPathW",
		"SelectClipPath",
		"SelectClipRgn",
		"SelectObject",
		"SelectPalette",
		"SendDlgItemMessageA",
		"SendDlgItemMessageW",
		"SendDriverMessage",
		"SendMessageA",
		"SendMessageCallbackA",
		"SendMessageCallbackW",
		"SendMessageTimeoutA",
		"SendMessageTimeoutW",
		"SendMessageW",
		"SendNotifyMessageA",
		"SendNotifyMessageW",
		"SetAbortProc",
		"SetAclInformation",
		"SetActiveWindow",
		"SetArcDirection",
		"SetBitmapBits",
		"SetBitmapDimensionEx",
		"SetBkColor",
		"SetBkMode",
		"SetBoundsRect",
		"SetBrushOrgEx",
		"SetCalendarInfoA",
		"SetCalendarInfoW",
		"SetCapture",
		"SetCaretBlinkTime",
		"SetCaretPos",
		"SetClassLongA",
		"SetClassLongW",
		"SetClassWord",
		"SetClipboardData",
		"SetClipboardViewer",
		"SetColorAdjustment",
		"SetColorSpace",
		"SetCommBreak",
		"SetCommConfig",
		"SetCommMask",
		"SetCommState",
		"SetCommTimeouts",
		"SetComputerNameA",
		"SetComputerNameW",
		"SetConsoleActiveScreenBuffer",
		"SetConsoleCP",
		"SetConsoleCtrlHandler",
		"SetConsoleCursorInfo",
		"SetConsoleCursorPosition",
		"SetConsoleMode",
		"SetConsoleOutputCP",
		"SetConsoleScreenBufferSize",
		"SetConsoleTextAttribute",
		"SetConsoleTitleA",
		"SetConsoleTitleW",
		"SetConsoleWindowInfo",
		"SetConvertStg",
		"SetCriticalSectionSpinCount",
		"SetCurrentDirectoryA",
		"SetCurrentDirectoryW",
		"SetCursor",
		"SetCursorPos",
		"SetDIBColorTable",
		"SetDIBits",
		"SetDIBitsToDevice",
		"SetDebugErrorLevel",
		"SetDefaultCommConfigA",
		"SetDefaultCommConfigW",
		"SetDeviceGammaRamp",
		"SetDlgItemInt",
		"SetDlgItemTextA",
		"SetDlgItemTextW",
		"SetDoubleClickTime",
		"SetEndOfFile",
		"SetEnhMetaFileBits",
		"SetEnvironmentVariableA",
		"SetEnvironmentVariableW",
		"SetErrorInfo",
		"SetErrorMode",
		"SetEvent",
		"SetFileApisToANSI",
		"SetFileApisToOEM",
		"SetFileAttributesA",
		"SetFileAttributesW",
		"SetFilePointer",
		"SetFilePointerEx",
		"SetFileSecurityA",
		"SetFileSecurityW",
		"SetFileTime",
		"SetFocus",
		"SetForegroundWindow",
		"SetFormA",
		"SetFormW",
		"SetGraphicsMode",
		"SetHandleCount",
		"SetHandleInformation",
		"SetICMMode",
		"SetICMProfileA",
		"SetICMProfileW",
		"SetJobA",
		"SetJobW",
		"SetKernelObjectSecurity",
		"SetKeyboardState",
		"SetLastError",
		"SetLastErrorEx",
		"SetLocalTime",
		"SetLocaleInfoA",
		"SetLocaleInfoW",
		"SetMailslotInfo",
		"SetMapMode",
		"SetMapperFlags",
		"SetMenu",
		"SetMenuContextHelpId",
		"SetMenuDefaultItem",
		"SetMenuInfo",
		"SetMenuItemBitmaps",
		"SetMenuItemInfoA",
		"SetMenuItemInfoW",
		"SetMessageExtraInfo",
		"SetMessageQueue",
		"SetMetaFileBitsEx",
		"SetMetaRgn",
		"SetMiterLimit",
		"SetNamedPipeHandleState",
		"SetPaletteEntries",
		"SetParent",
		"SetPixel",
		"SetPixelFormat",
		"SetPixelV",
		"SetPolyFillMode",
		"SetPrinterA",
		"SetPrinterDataA",
		"SetPrinterDataW",
		"SetPrinterW",
		"SetPriorityClass",
		"SetPrivateObjectSecurity",
		"SetProcessAffinityMask",
		"SetProcessPriorityBoost",
		"SetProcessShutdownParameters",
		"SetProcessWindowStation",
		"SetProcessWorkingSetSize",
		"SetPropA",
		"SetPropW",
		"SetROP2",
		"SetRect",
		"SetRectEmpty",
		"SetRectRgn",
		"SetScrollInfo",
		"SetScrollPos",
		"SetScrollRange",
		"SetSecurityDescriptorControl",
		"SetSecurityDescriptorDacl",
		"SetSecurityDescriptorGroup",
		"SetSecurityDescriptorOwner",
		"SetSecurityDescriptorSacl",
		"SetServiceObjectSecurity",
		"SetServiceStatus",
		"SetStdHandle",
		"SetStretchBltMode",
		"SetSysColors",
		"SetSystemCursor",
		"SetSystemPaletteUse",
		"SetSystemPowerState",
		"SetSystemTime",
		"SetSystemTimeAdjustment",
		"SetTapeParameters",
		"SetTapePosition",
		"SetTextAlign",
		"SetTextCharacterExtra",
		"SetTextColor",
		"SetTextJustification",
		"SetThreadAffinityMask",
		"SetThreadContext",
		"SetThreadDesktop",
		"SetThreadIdealProcessor",
		"SetThreadLocale",
		"SetThreadPriority",
		"SetThreadPriorityBoost",
		"SetThreadToken",
		"SetTimeZoneInformation",
		"SetTimer",
		"SetTokenInformation",
		"SetUnhandledExceptionFilter",
		"SetUserGeoID",
		"SetUserObjectInformationA",
		"SetUserObjectInformationW",
		"SetUserObjectSecurity",
		"SetViewportExtEx",
		"SetViewportOrgEx",
		"SetVolumeLabelA",
		"SetVolumeLabelW",
		"SetWaitableTimer",
		"SetWinMetaFileBits",
		"SetWindowContextHelpId",
		"SetWindowExtEx",
		"SetWindowLongA",
		"SetWindowLongW",
		"SetWindowOrgEx",
		"SetWindowPlacement",
		"SetWindowPos",
		"SetWindowRgn",
		"SetWindowTextA",
		"SetWindowTextW",
		"SetWindowWord",
		"SetWindowsHookA",
		"SetWindowsHookExA",
		"SetWindowsHookExW",
		"SetWindowsHookW",
		"SetWorldTransform",
		"SetupComm",
		"ShellAboutA",
		"ShellAboutW",
		"ShellExecuteA",
		"ShellExecuteExA",
		"ShellExecuteExW",
		"ShellExecuteW",
		"Shell_NotifyIconA",
		"Shell_NotifyIconW",
		"ShowCaret",
		"ShowCursor",
		"ShowOwnedPopups",
		"ShowScrollBar",
		"ShowWindow",
		"ShowWindowAsync",
		"SignalObjectAndWait",
		"SizeofResource",
		"Sleep",
		"SleepEx",
		"StartDocA",
		"StartDocPrinterA",
		"StartDocPrinterW",
		"StartDocW",
		"StartPage",
		"StartPagePrinter",
		"StartServiceA",
		"StartServiceCtrlDispatcherA",
		"StartServiceCtrlDispatcherW",
		"StartServiceW",
		"StgCreateDocfile",
		"StgCreateDocfileOnILockBytes",
		"StgCreateStorageEx",
		"StgIsStorageFile",
		"StgIsStorageILockBytes",
		"StgOpenStorage",
		"StgOpenStorageEx",
		"StgOpenStorageOnILockBytes",
		"StgSetTimes",
		"StretchBlt",
		"StretchDIBits",
		"StringFromCLSID",
		"StringFromGUID2",
		"StringFromIID",
		"StrokeAndFillPath",
		"StrokePath",
		"SubtractRect",
		"SuspendThread",
		"SwapBuffers",
		"SwapMouseButton",
		"SwitchDesktop",
		"SwitchToFiber",
		"SwitchToThread",
		"SysAllocString",
		"SysAllocStringByteLen",
		"SysAllocStringLen",
		"SysFreeString",
		"SysReAllocString",
		"SysReAllocStringLen",
		"SysStringByteLen",
		"SysStringLen",
		"SystemParametersInfoA",
		"SystemParametersInfoW",
		"SystemTimeToFileTime",
		"SystemTimeToTzSpecificLocalTime",
		"SystemTimeToVariantTime",
		"TabbedTextOutA",
		"TabbedTextOutW",
		"TerminateProcess",
		"TerminateThread",
		"TextOutA",
		"TextOutW",
		"TileWindows",
		"TlsAlloc",
		"TlsFree",
		"TlsGetValue",
		"TlsSetValue",
		"ToAscii",
		"ToAsciiEx",
		"ToUnicode",
		"ToUnicodeEx",
		"TrackMouseEvent",
		"TrackPopupMenu",
		"TrackPopupMenuEx",
		"TransactNamedPipe",
		"TranslateAcceleratorA",
		"TranslateAcceleratorW",
		"TranslateCharsetInfo",
		"TranslateMDISysAccel",
		"TranslateMessage",
		"TransmitCommChar",
		"TryEnterCriticalSection",
		"UnRegisterTypeLib",
		"UnhandledExceptionFilter",
		"UnhookWindowsHook",
		"UnhookWindowsHookEx",
		"UnionRect",
		"UnloadKeyboardLayout",
		"UnlockFile",
		"UnlockFileEx",
		"UnlockServiceDatabase",
		"UnmapViewOfFile",
		"UnpackDDElParam",
		"UnrealizeObject",
		"UnregisterClassA",
		"UnregisterClassW",
		"UnregisterHotKey",
		"UpdateColors",
		"UpdateICMRegKeyA",
		"UpdateICMRegKeyW",
		"UpdateResourceA",
		"UpdateResourceW",
		"UpdateWindow",
		"UuidCompare",
		"UuidCreate",
		"UuidCreateNil",
		"UuidEqual",
		"UuidFromStringA",
		"UuidFromStringW",
		"UuidHash",
		"UuidIsNil",
		"UuidToStringA",
		"UuidToStringW",
		"ValidateRect",
		"ValidateRgn",
		"VarAbs",
		"VarAdd",
		"VarAnd",
		"VarBoolFromCy",
		"VarBoolFromDate",
		"VarBoolFromDec",
		"VarBoolFromDisp",
		"VarBoolFromI1",
		"VarBoolFromI2",
		"VarBoolFromI4",
		"VarBoolFromI8",
		"VarBoolFromR4",
		"VarBoolFromR8",
		"VarBoolFromStr",
		"VarBoolFromUI1",
		"VarBoolFromUI2",
		"VarBoolFromUI4",
		"VarBoolFromUI8",
		"VarBstrCat",
		"VarBstrCmp",
		"VarBstrFromBool",
		"VarBstrFromCy",
		"VarBstrFromDate",
		"VarBstrFromDec",
		"VarBstrFromDisp",
		"VarBstrFromI1",
		"VarBstrFromI2",
		"VarBstrFromI4",
		"VarBstrFromI8",
		"VarBstrFromR4",
		"VarBstrFromR8",
		"VarBstrFromUI1",
		"VarBstrFromUI2",
		"VarBstrFromUI4",
		"VarBstrFromUI8",
		"VarCat",
		"VarCmp",
		"VarCyAbs",
		"VarCyAdd",
		"VarCyCmp",
		"VarCyCmpR8",
		"VarCyFix",
		"VarCyFromBool",
		"VarCyFromDate",
		"VarCyFromDec",
		"VarCyFromDisp",
		"VarCyFromI1",
		"VarCyFromI2",
		"VarCyFromI4",
		"VarCyFromI8",
		"VarCyFromR4",
		"VarCyFromR8",
		"VarCyFromStr",
		"VarCyFromUI1",
		"VarCyFromUI2",
		"VarCyFromUI4",
		"VarCyFromUI8",
		"VarCyInt",
		"VarCyMul",
		"VarCyMulI4",
		"VarCyMulI8",
		"VarCyNeg",
		"VarCyRound",
		"VarCySub",
		"VarDateFromBool",
		"VarDateFromCy",
		"VarDateFromDec",
		"VarDateFromDisp",
		"VarDateFromI1",
		"VarDateFromI2",
		"VarDateFromI4",
		"VarDateFromI8",
		"VarDateFromR4",
		"VarDateFromR8",
		"VarDateFromStr",
		"VarDateFromUI1",
		"VarDateFromUI2",
		"VarDateFromUI4",
		"VarDateFromUI8",
		"VarDateFromUdate",
		"VarDateFromUdateEx",
		"VarDecAbs",
		"VarDecAdd",
		"VarDecCmp",
		"VarDecCmpR8",
		"VarDecDiv",
		"VarDecFix",
		"VarDecFromBool",
		"VarDecFromCy",
		"VarDecFromDate",
		"VarDecFromDisp",
		"VarDecFromI1",
		"VarDecFromI2",
		"VarDecFromI4",
		"VarDecFromI8",
		"VarDecFromR4",
		"VarDecFromR8",
		"VarDecFromStr",
		"VarDecFromUI1",
		"VarDecFromUI2",
		"VarDecFromUI4",
		"VarDecFromUI8",
		"VarDecInt",
		"VarDecMul",
		"VarDecNeg",
		"VarDecRound",
		"VarDecSub",
		"VarDiv",
		"VarEqv",
		"VarFix",
		"VarI1FromBool",
		"VarI1FromCy",
		"VarI1FromDate",
		"VarI1FromDec",
		"VarI1FromDisp",
		"VarI1FromI2",
		"VarI1FromI4",
		"VarI1FromI8",
		"VarI1FromR4",
		"VarI1FromR8",
		"VarI1FromStr",
		"VarI1FromUI1",
		"VarI1FromUI2",
		"VarI1FromUI4",
		"VarI1FromUI8",
		"VarI2FromBool",
		"VarI2FromCy",
		"VarI2FromDate",
		"VarI2FromDec",
		"VarI2FromDisp",
		"VarI2FromI1",
		"VarI2FromI4",
		"VarI2FromI8",
		"VarI2FromR4",
		"VarI2FromR8",
		"VarI2FromStr",
		"VarI2FromUI1",
		"VarI2FromUI2",
		"VarI2FromUI4",
		"VarI2FromUI8",
		"VarI4FromBool",
		"VarI4FromCy",
		"VarI4FromDate",
		"VarI4FromDec",
		"VarI4FromDisp",
		"VarI4FromI1",
		"VarI4FromI2",
		"VarI4FromI8",
		"VarI4FromR4",
		"VarI4FromR8",
		"VarI4FromStr",
		"VarI4FromUI1",
		"VarI4FromUI2",
		"VarI4FromUI4",
		"VarI4FromUI8",
		"VarI8FromBool",
		"VarI8FromCy",
		"VarI8FromDate",
		"VarI8FromDec",
		"VarI8FromDisp",
		"VarI8FromI1",
		"VarI8FromI2",
		"VarI8FromI4",
		"VarI8FromInt",
		"VarI8FromR4",
		"VarI8FromR8",
		"VarI8FromStr",
		"VarI8FromUI1",
		"VarI8FromUI2",
		"VarI8FromUI4",
		"VarI8FromUI8",
		"VarIdiv",
		"VarImp",
		"VarInt",
		"VarMod",
		"VarMul",
		"VarNeg",
		"VarNot",
		"VarNumFromParseNum",
		"VarOr",
		"VarParseNumFromStr",
		"VarPow",
		"VarR4CmpR8",
		"VarR4FromBool",
		"VarR4FromCy",
		"VarR4FromDate",
		"VarR4FromDec",
		"VarR4FromDisp",
		"VarR4FromI1",
		"VarR4FromI2",
		"VarR4FromI4",
		"VarR4FromI8",
		"VarR4FromR8",
		"VarR4FromStr",
		"VarR4FromUI1",
		"VarR4FromUI2",
		"VarR4FromUI4",
		"VarR4FromUI8",
		"VarR8FromBool",
		"VarR8FromCy",
		"VarR8FromDate",
		"VarR8FromDec",
		"VarR8FromDisp",
		"VarR8FromI1",
		"VarR8FromI2",
		"VarR8FromI4",
		"VarR8FromI8",
		"VarR8FromR4",
		"VarR8FromStr",
		"VarR8FromUI1",
		"VarR8FromUI2",
		"VarR8FromUI4",
		"VarR8FromUI8",
		"VarR8Pow",
		"VarR8Round",
		"VarRound",
		"VarSub",
		"VarUI1FromBool",
		"VarUI1FromCy",
		"VarUI1FromDate",
		"VarUI1FromDec",
		"VarUI1FromDisp",
		"VarUI1FromI1",
		"VarUI1FromI2",
		"VarUI1FromI4",
		"VarUI1FromI8",
		"VarUI1FromR4",
		"VarUI1FromR8",
		"VarUI1FromStr",
		"VarUI1FromUI2",
		"VarUI1FromUI4",
		"VarUI1FromUI8",
		"VarUI2FromBool",
		"VarUI2FromCy",
		"VarUI2FromDate",
		"VarUI2FromDec",
		"VarUI2FromDisp",
		"VarUI2FromI1",
		"VarUI2FromI2",
		"VarUI2FromI4",
		"VarUI2FromI8",
		"VarUI2FromR4",
		"VarUI2FromR8",
		"VarUI2FromStr",
		"VarUI2FromUI1",
		"VarUI2FromUI4",
		"VarUI2FromUI8",
		"VarUI4FromBool",
		"VarUI4FromCy",
		"VarUI4FromDate",
		"VarUI4FromDec",
		"VarUI4FromDisp",
		"VarUI4FromI1",
		"VarUI4FromI2",
		"VarUI4FromI4",
		"VarUI4FromI8",
		"VarUI4FromR4",
		"VarUI4FromR8",
		"VarUI4FromStr",
		"VarUI4FromUI1",
		"VarUI4FromUI2",
		"VarUI4FromUI8",
		"VarUI8FromBool",
		"VarUI8FromCy",
		"VarUI8FromDate",
		"VarUI8FromDec",
		"VarUI8FromDisp",
		"VarUI8FromI1",
		"VarUI8FromI2",
		"VarUI8FromI4",
		"VarUI8FromI8",
		"VarUI8FromInt",
		"VarUI8FromR4",
		"VarUI8FromR8",
		"VarUI8FromStr",
		"VarUI8FromUI1",
		"VarUI8FromUI2",
		"VarUI8FromUI4",
		"VarUdateFromDate",
		"VarXor",
		"VariantChangeType",
		"VariantChangeTypeEx",
		"VariantClear",
		"VariantCopy",
		"VariantCopyInd",
		"VariantInit",
		"VariantTimeToDosDateTime",
		"VariantTimeToSystemTime",
		"VectorFromBstr",
		"VerFindFileA",
		"VerFindFileW",
		"VerInstallFileA",
		"VerInstallFileW",
		"VerLanguageNameA",
		"VerLanguageNameW",
		"VerQueryValueA",
		"VerQueryValueW",
		"VerifyVersionInfoA",
		"VerifyVersionInfoW",
		"VirtualAlloc",
		"VirtualAllocEx",
		"VirtualFree",
		"VirtualFreeEx",
		"VirtualLock",
		"VirtualProtect",
		"VirtualProtectEx",
		"VirtualQuery",
		"VirtualQueryEx",
		"VirtualUnlock",
		"VkKeyScanA",
		"VkKeyScanExA",
		"VkKeyScanExW",
		"VkKeyScanW",
		"WNetAddConnection2A",
		"WNetAddConnection2W",
		"WNetAddConnection3A",
		"WNetAddConnection3W",
		"WNetAddConnectionA",
		"WNetAddConnectionW",
		"WNetCancelConnection2A",
		"WNetCancelConnection2W",
		"WNetCancelConnectionA",
		"WNetCancelConnectionW",
		"WNetCloseEnum",
		"WNetConnectionDialog",
		"WNetConnectionDialog1A",
		"WNetConnectionDialog1W",
		"WNetDisconnectDialog",
		"WNetDisconnectDialog1A",
		"WNetDisconnectDialog1W",
		"WNetEnumResourceA",
		"WNetEnumResourceW",
		"WNetGetConnectionA",
		"WNetGetConnectionW",
		"WNetGetLastErrorA",
		"WNetGetLastErrorW",
		"WNetGetNetworkInformationA",
		"WNetGetNetworkInformationW",
		"WNetGetProviderNameA",
		"WNetGetProviderNameW",
		"WNetGetResourceInformationA",
		"WNetGetResourceInformationW",
		"WNetGetResourceParentA",
		"WNetGetResourceParentW",
		"WNetGetUniversalNameA",
		"WNetGetUniversalNameW",
		"WNetGetUserA",
		"WNetGetUserW",
		"WNetOpenEnumA",
		"WNetOpenEnumW",
		"WNetSetConnectionA",
		"WNetSetConnectionW",
		"WNetUseConnectionA",
		"WNetUseConnectionW",
		"WSAAccept",
		"WSAAddressToStringA",
		"WSAAddressToStringW",
		"WSAAsyncGetHostByAddr",
		"WSAAsyncGetHostByName",
		"WSAAsyncGetProtoByName",
		"WSAAsyncGetProtoByNumber",
		"WSAAsyncGetServByName",
		"WSAAsyncGetServByPort",
		"WSAAsyncSelect",
		"WSACancelAsyncRequest",
		"WSACancelBlockingCall",
		"WSACleanup",
		"WSACloseEvent",
		"WSAConnect",
		"WSACreateEvent",
		"WSADuplicateSocketA",
		"WSADuplicateSocketW",
		"WSAEnumNameSpaceProvidersA",
		"WSAEnumNameSpaceProvidersW",
		"WSAEnumNetworkEvents",
		"WSAEnumProtocolsA",
		"WSAEnumProtocolsW",
		"WSAEventSelect",
		"WSAGetLastError",
		"WSAGetOverlappedResult",
		"WSAGetQOSByName",
		"WSAGetServiceClassInfoA",
		"WSAGetServiceClassInfoW",
		"WSAGetServiceClassNameByClassIdA",
		"WSAGetServiceClassNameByClassIdW",
		"WSAHtonl",
		"WSAHtons",
		"WSAInstallServiceClassA",
		"WSAInstallServiceClassW",
		"WSAIoctl",
		"WSAIsBlocking",
		"WSAJoinLeaf",
		"WSALookupServiceBeginA",
		"WSALookupServiceBeginW",
		"WSALookupServiceEnd",
		"WSALookupServiceNextA",
		"WSALookupServiceNextW",
		"WSANSPIoctl",
		"WSANtohl",
		"WSANtohs",
		"WSARecv",
		"WSARecvDisconnect",
		"WSARecvFrom",
		"WSARemoveServiceClass",
		"WSAResetEvent",
		"WSASend",
		"WSASendDisconnect",
		"WSASendTo",
		"WSASetBlockingHook",
		"WSASetEvent",
		"WSASetLastError",
		"WSASetServiceA",
		"WSASetServiceW",
		"WSASocketA",
		"WSASocketW",
		"WSAStartup",
		"WSAStringToAddressA",
		"WSAStringToAddressW",
		"WSAUnhookBlockingHook",
		"WSAWaitForMultipleEvents",
		"WaitCommEvent",
		"WaitForDebugEvent",
		"WaitForInputIdle",
		"WaitForMultipleObjects",
		"WaitForMultipleObjectsEx",
		"WaitForPrinterChange",
		"WaitForSingleObject",
		"WaitForSingleObjectEx",
		"WaitMessage",
		"WaitNamedPipeA",
		"WaitNamedPipeW",
		"WideCharToMultiByte",
		"WidenPath",
		"WinExec",
		"WinHelpA",
		"WinHelpW",
		"WinLoadTrustProvider",
		"WinMain",
		"WindowFromDC",
		"WindowFromPoint",
		"WriteClassStg",
		"WriteClassStm",
		"WriteConsoleA",
		"WriteConsoleInputA",
		"WriteConsoleInputW",
		"WriteConsoleOutputA",
		"WriteConsoleOutputAttribute",
		"WriteConsoleOutputCharacterA",
		"WriteConsoleOutputCharacterW",
		"WriteConsoleOutputW",
		"WriteConsoleW",
		"WriteFile",
		"WriteFileEx",
		"WriteFileGather",
		"WriteFmtUserTypeStg",
		"WritePrinter",
		"WritePrivateProfileSectionA",
		"WritePrivateProfileSectionW",
		"WritePrivateProfileStringA",
		"WritePrivateProfileStringW",
		"WritePrivateProfileStructA",
		"WritePrivateProfileStructW",
		"WriteProcessMemory",
		"WriteProfileSectionA",
		"WriteProfileSectionW",
		"WriteProfileStringA",
		"WriteProfileStringW",
		"WriteTapemark",
		"__WSAFDIsSet",
		"_hread",
		"_hwrite",
		"_lclose",
		"_lcreat",
		"_llseek",
		"_lopen",
		"_lread",
		"_lwrite",
		"_open",
		"_read",
		"_write",
		"accept",
		"auxGetDevCapsA",
		"auxGetDevCapsW",
		"auxGetNumDevs",
		"auxGetVolume",
		"auxOutMessage",
		"auxSetVolume",
		"bind",
		"char_array_from_ndr",
		"char_from_ndr",
		"closesocket",
		"connect",
		"data_from_ndr",
		"data_into_ndr",
		"data_size_ndr",
		"double_array_from_ndr",
		"double_from_ndr",
		"enum_from_ndr",
		"float_array_from_ndr",
		"float_from_ndr",
		"gethostbyaddr",
		"gethostbyname",
		"gethostname",
		"getpeername",
		"getprotobyname",
		"getprotobynumber",
		"getservbyname",
		"getservbyport",
		"getsockname",
		"getsockopt",
		"htonl",
		"htons",
		"hyper_array_from_ndr",
		"hyper_from_ndr",
		"hyper_from_ndr_temp",
		"inet_addr",
		"inet_ntoa",
		"ioctlsocket",
		"joyGetDevCapsA",
		"joyGetDevCapsW",
		"joyGetNumDevs",
		"joyGetPos",
		"joyGetPosEx",
		"joyGetThreshold",
		"joyReleaseCapture",
		"joySetCapture",
		"joySetThreshold",
		"keybd_event",
		"listen",
		"long_array_from_ndr",
		"long_from_ndr",
		"long_from_ndr_temp",
		"lstrcatA",
		"lstrcatW",
		"lstrcmpA",
		"lstrcmpW",
		"lstrcmpiA",
		"lstrcmpiW",
		"lstrcpyA",
		"lstrcpyW",
		"lstrcpynA",
		"lstrcpynW",
		"lstrlenA",
		"lstrlenW",
		"mciGetCreatorTask",
		"mciGetDeviceIDA",
		"mciGetDeviceIDFromElementIDA",
		"mciGetDeviceIDFromElementIDW",
		"mciGetDeviceIDW",
		"mciGetErrorStringA",
		"mciGetErrorStringW",
		"mciGetYieldProc",
		"mciSendCommandA",
		"mciSendCommandW",
		"mciSendStringA",
		"mciSendStringW",
		"mciSetYieldProc",
		"midiConnect",
		"midiDisconnect",
		"midiInAddBuffer",
		"midiInClose",
		"midiInGetDevCapsA",
		"midiInGetDevCapsW",
		"midiInGetErrorTextA",
		"midiInGetErrorTextW",
		"midiInGetID",
		"midiInGetNumDevs",
		"midiInMessage",
		"midiInOpen",
		"midiInPrepareHeader",
		"midiInReset",
		"midiInStart",
		"midiInStop",
		"midiInUnprepareHeader",
		"midiOutCacheDrumPatches",
		"midiOutCachePatches",
		"midiOutClose",
		"midiOutGetDevCapsA",
		"midiOutGetDevCapsW",
		"midiOutGetErrorTextA",
		"midiOutGetErrorTextW",
		"midiOutGetID",
		"midiOutGetNumDevs",
		"midiOutGetVolume",
		"midiOutLongMsg",
		"midiOutMessage",
		"midiOutOpen",
		"midiOutPrepareHeader",
		"midiOutReset",
		"midiOutSetVolume",
		"midiOutShortMsg",
		"midiOutUnprepareHeader",
		"midiStreamClose",
		"midiStreamOpen",
		"midiStreamOut",
		"midiStreamPause",
		"midiStreamPosition",
		"midiStreamProperty",
		"midiStreamRestart",
		"midiStreamStop",
		"midl_allocate",
		"mixerClose",
		"mixerGetControlDetailsA",
		"mixerGetControlDetailsW",
		"mixerGetDevCapsA",
		"mixerGetDevCapsW",
		"mixerGetID",
		"mixerGetLineControlsA",
		"mixerGetLineControlsW",
		"mixerGetLineInfoA",
		"mixerGetLineInfoW",
		"mixerGetNumDevs",
		"mixerMessage",
		"mixerOpen",
		"mixerSetControlDetails",
		"mmioAdvance",
		"mmioAscend",
		"mmioClose",
		"mmioCreateChunk",
		"mmioDescend",
		"mmioFlush",
		"mmioGetInfo",
		"mmioInstallIOProcA",
		"mmioInstallIOProcW",
		"mmioOpenA",
		"mmioOpenW",
		"mmioRead",
		"mmioRenameA",
		"mmioRenameW",
		"mmioSeek",
		"mmioSendMessage",
		"mmioSetBuffer",
		"mmioSetInfo",
		"mmioStringToFOURCCA",
		"mmioStringToFOURCCW",
		"mmioWrite",
		"mmsystemGetVersion",
		"mouse_event",
		"ntohl",
		"ntohs",
		"recv",
		"recvfrom",
		"select",
		"send",
		"sendto",
		"setsockopt",
		"short_array_from_ndr",
		"short_from_ndr",
		"short_from_ndr_temp",
		"shutdown",
		"sndPlaySoundA",
		"sndPlaySoundW",
		"socket",
		"timeBeginPeriod",
		"timeEndPeriod",
		"timeGetDevCaps",
		"timeGetSystemTime",
		"timeGetTime",
		"timeKillEvent",
		"timeSetEvent",
		"tree_into_ndr",
		"tree_peek_ndr",
		"tree_size_ndr",
		"wWinMain",
		"waveInAddBuffer",
		"waveInClose",
		"waveInGetDevCapsA",
		"waveInGetDevCapsW",
		"waveInGetErrorTextA",
		"waveInGetErrorTextW",
		"waveInGetID",
		"waveInGetNumDevs",
		"waveInGetPosition",
		"waveInMessage",
		"waveInOpen",
		"waveInPrepareHeader",
		"waveInReset",
		"waveInStart",
		"waveInStop",
		"waveInUnprepareHeader",
		"waveOutBreakLoop",
		"waveOutClose",
		"waveOutGetDevCapsA",
		"waveOutGetDevCapsW",
		"waveOutGetErrorTextA",
		"waveOutGetErrorTextW",
		"waveOutGetID",
		"waveOutGetNumDevs",
		"waveOutGetPitch",
		"waveOutGetPlaybackRate",
		"waveOutGetPosition",
		"waveOutGetVolume",
		"waveOutMessage",
		"waveOutOpen",
		"waveOutPause",
		"waveOutPrepareHeader",
		"waveOutReset",
		"waveOutRestart",
		"waveOutSetPitch",
		"waveOutSetPlaybackRate",
		"waveOutSetVolume",
		"waveOutUnprepareHeader",
		"waveOutWrite",
		"wglCopyContext",
		"wglCreateContext",
		"wglCreateLayerContext",
		"wglDeleteContext",
		"wglDescribeLayerPlane",
		"wglGetCurrentContext",
		"wglGetCurrentDC",
		"wglGetLayerPaletteEntries",
		"wglGetProcAddress",
		"wglMakeCurrent",
		"wglRealizeLayerPalette",
		"wglSetLayerPaletteEntries",
		"wglShareLists",
		"wglSwapLayerBuffers",
		"wglUseFontBitmapsA",
		"wglUseFontBitmapsW",
		"wglUseFontOutlinesA",
		"wglUseFontOutlinesW",
		"wsprintfA",
		"wsprintfW",
		"wvsprintfA",
		"wvsprintfW",
	};
	ADD_FUNCS_TO_C_HEADER_MAP(WINDOWS_H_FUNCS, "windows.h", m);

	return m;
}

/// Mapping of function names to their corresponding header files.
const StringStringUMap &FUNC_C_HEADER_MAP(initFuncCHeaderMap());

} // anonymous namespace

/**
* @brief Implements getCHeaderFileForFunc() for WinAPISemantics.
*
* See its description for more details.
*/
std::optional<std::string> getCHeaderFileForFunc(const std::string &funcName) {
	return getCHeaderFileForFuncFromMap(funcName, FUNC_C_HEADER_MAP);
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
