"""Dictionary of types used in headers and types for lti."""

LTI_TYPES = {
    # default C types and some typedefs
    '__int64': 'i64',
    'bool': 'i1',
    'double': 'double',
    'long double': 'double',
    'float': 'float',
    'char': 'i8',
    'int': 'i32',
    'long': 'i32',
    'long int': 'i64',
    'long long': 'i64',
    'long long int': 'i64',
    'short': 'i16',
    'short int': 'i16',
    'size_t': 'i32',
    'va_list': '...',
    'void': 'void',
    'wchar_t': '%wchar_t',

    # WINAPI
    'BOOL': 'i1',
    'COLORREF': 'i32',
    'DWORD': 'i32',
    'DWORD_PTR': 'i32*',
    'FINDEX_INFO_LEVELS': 'i32',
    'FINDEX_SEARCH_OPS': 'i32',
    'HANDLE': 'i32*',
    'HBITMAP': 'i32*',
    'HDC': 'i32*',
    'HGLOBAL': 'i32*',
    'HKEY': 'i32*',
    'HLOCAL': 'i32*',
    'HMENU': 'i32*',
    'HPALETTE': 'i32*',
    'HRESULT': 'i32',
    'HWND': 'i32*',
    'INT': 'i32',
    'INT_PTR': 'i32*',
    'LONG': 'i32',
    'LPARAM': 'i32*',
    'LPCTSTR': '%wchar_t*',
    'LPCVOID': 'i8*',
    'LPSTR': '%wchar_t*',
    'LPTSTR': '%wchar_t*',
    'LPVOID': 'i8*',
    'LRESULT': 'i32*',
    'PFORMAT_STRING': 'i8*',
    'PSTR': '%wchar_t*',
    'PDWORD_PTR': 'i32*',
    'SIZE_T': 'i32*',
    'UINT': 'i32',
    'UINT_PTR': 'i32*',
    'ULONG_PTR': 'i32*',
    'USHORT': 'i16',
    'VOID': 'void',
    'WORD': 'i16',
    'WPARAM': 'i32*',

    # modifiers
    '*': '*',
    'const': '',
    'signed': '',
    'unsigned': '',
    # specials
    '_In_': '',
    '_In_opt_': '',
    '_Inout_': 'OUT ',
    '_Inout_opt_': 'OUT ',
    '_Out_': 'OUT ',
    '_Out_opt_': 'OUT ',
    '_Reserved_': '',
    # structs
    'struct': '%struct.',
}
