/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/e.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/e.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with E.
*/
void initFuncParamNamesMap_E(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("Ellipse", 1, "hdc"); // HDC
	ADD_PARAM_NAME("Ellipse", 2, "left"); // int
	ADD_PARAM_NAME("Ellipse", 3, "top"); // int
	ADD_PARAM_NAME("Ellipse", 4, "right"); // int
	ADD_PARAM_NAME("Ellipse", 5, "bottom"); // int
	ADD_PARAM_NAME("EnableMenuItem", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("EnableMenuItem", 2, "uIDEnableItem"); // UINT
	ADD_PARAM_NAME("EnableMenuItem", 3, "uEnable"); // UINT
	ADD_PARAM_NAME("EnableScrollBar", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnableScrollBar", 2, "wSBflags"); // UINT
	ADD_PARAM_NAME("EnableScrollBar", 3, "wArrows"); // UINT
	ADD_PARAM_NAME("EnableWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnableWindow", 2, "bEnable"); // WINBOOL
	ADD_PARAM_NAME("EncodePointer", 1, "Ptr"); // PVOID
	ADD_PARAM_NAME("EncodeSystemPointer", 1, "Ptr"); // PVOID
	ADD_PARAM_NAME("EncryptFileA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("EncryptFileW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("EncryptionDisable", 1, "DirPath"); // LPCWSTR
	ADD_PARAM_NAME("EncryptionDisable", 2, "Disable"); // WINBOOL
	ADD_PARAM_NAME("EndDeferWindowPos", 1, "hWinPosInfo"); // HDWP
	ADD_PARAM_NAME("EndDialog", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("EndDialog", 2, "nResult"); // INT_PTR
	ADD_PARAM_NAME("EndDoc", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EndDocPrinter", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EndPage", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EndPagePrinter", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EndPaint", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EndPaint", 2, "lpPaint"); // CONST PAINTSTRUCT *
	ADD_PARAM_NAME("EndPath", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EndTask", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EndTask", 2, "fShutDown"); // WINBOOL
	ADD_PARAM_NAME("EndTask", 3, "fForce"); // WINBOOL
	ADD_PARAM_NAME("EndUpdateResourceA", 1, "hUpdate"); // HANDLE
	ADD_PARAM_NAME("EndUpdateResourceA", 2, "fDiscard"); // WINBOOL
	ADD_PARAM_NAME("EndUpdateResourceW", 1, "hUpdate"); // HANDLE
	ADD_PARAM_NAME("EndUpdateResourceW", 2, "fDiscard"); // WINBOOL
	ADD_PARAM_NAME("EnterCriticalSection", 1, "lpCriticalSection"); // LPCRITICAL_SECTION
	ADD_PARAM_NAME("EnumCalendarInfoA", 1, "lpCalInfoEnumProc"); // CALINFO_ENUMPROCA
	ADD_PARAM_NAME("EnumCalendarInfoA", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumCalendarInfoA", 3, "Calendar"); // CALID
	ADD_PARAM_NAME("EnumCalendarInfoA", 4, "CalType"); // CALTYPE
	ADD_PARAM_NAME("EnumCalendarInfoExA", 1, "lpCalInfoEnumProcEx"); // CALINFO_ENUMPROCEXA
	ADD_PARAM_NAME("EnumCalendarInfoExA", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumCalendarInfoExA", 3, "Calendar"); // CALID
	ADD_PARAM_NAME("EnumCalendarInfoExA", 4, "CalType"); // CALTYPE
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 1, "pCalInfoEnumProcExEx"); // CALINFO_ENUMPROCEXEX
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 2, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 3, "Calendar"); // CALID
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 4, "lpReserved"); // LPCWSTR
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 5, "CalType"); // CALTYPE
	ADD_PARAM_NAME("EnumCalendarInfoExEx", 6, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumCalendarInfoExW", 1, "lpCalInfoEnumProcEx"); // CALINFO_ENUMPROCEXW
	ADD_PARAM_NAME("EnumCalendarInfoExW", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumCalendarInfoExW", 3, "Calendar"); // CALID
	ADD_PARAM_NAME("EnumCalendarInfoExW", 4, "CalType"); // CALTYPE
	ADD_PARAM_NAME("EnumCalendarInfoW", 1, "lpCalInfoEnumProc"); // CALINFO_ENUMPROCW
	ADD_PARAM_NAME("EnumCalendarInfoW", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumCalendarInfoW", 3, "Calendar"); // CALID
	ADD_PARAM_NAME("EnumCalendarInfoW", 4, "CalType"); // CALTYPE
	ADD_PARAM_NAME("EnumChildWindows", 1, "hWndParent"); // HWND
	ADD_PARAM_NAME("EnumChildWindows", 2, "lpEnumFunc"); // WNDENUMPROC
	ADD_PARAM_NAME("EnumChildWindows", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumClipboardFormats", 1, "format"); // UINT
	ADD_PARAM_NAME("EnumDateFormatsA", 1, "lpDateFmtEnumProc"); // DATEFMT_ENUMPROCA
	ADD_PARAM_NAME("EnumDateFormatsA", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumDateFormatsA", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDateFormatsExA", 1, "lpDateFmtEnumProcEx"); // DATEFMT_ENUMPROCEXA
	ADD_PARAM_NAME("EnumDateFormatsExA", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumDateFormatsExA", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDateFormatsExEx", 1, "lpDateFmtEnumProcExEx"); // DATEFMT_ENUMPROCEXEX
	ADD_PARAM_NAME("EnumDateFormatsExEx", 2, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("EnumDateFormatsExEx", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDateFormatsExEx", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumDateFormatsExW", 1, "lpDateFmtEnumProcEx"); // DATEFMT_ENUMPROCEXW
	ADD_PARAM_NAME("EnumDateFormatsExW", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumDateFormatsExW", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDateFormatsW", 1, "lpDateFmtEnumProc"); // DATEFMT_ENUMPROCW
	ADD_PARAM_NAME("EnumDateFormatsW", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumDateFormatsW", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDependentServicesA", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("EnumDependentServicesA", 2, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumDependentServicesA", 3, "lpServices"); // LPENUM_SERVICE_STATUSA
	ADD_PARAM_NAME("EnumDependentServicesA", 4, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumDependentServicesA", 5, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumDependentServicesA", 6, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumDependentServicesW", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("EnumDependentServicesW", 2, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumDependentServicesW", 3, "lpServices"); // LPENUM_SERVICE_STATUSW
	ADD_PARAM_NAME("EnumDependentServicesW", 4, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumDependentServicesW", 5, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumDependentServicesW", 6, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumDesktopWindows", 1, "hDesktop"); // HDESK
	ADD_PARAM_NAME("EnumDesktopWindows", 2, "lpfn"); // WNDENUMPROC
	ADD_PARAM_NAME("EnumDesktopWindows", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumDesktopsA", 1, "hwinsta"); // HWINSTA
	ADD_PARAM_NAME("EnumDesktopsA", 2, "lpEnumFunc"); // DESKTOPENUMPROCA
	ADD_PARAM_NAME("EnumDesktopsA", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumDesktopsW", 1, "hwinsta"); // HWINSTA
	ADD_PARAM_NAME("EnumDesktopsW", 2, "lpEnumFunc"); // DESKTOPENUMPROCW
	ADD_PARAM_NAME("EnumDesktopsW", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumDisplayDevicesA", 1, "lpDevice"); // LPCSTR
	ADD_PARAM_NAME("EnumDisplayDevicesA", 2, "iDevNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplayDevicesA", 3, "lpDisplayDevice"); // PDISPLAY_DEVICEA
	ADD_PARAM_NAME("EnumDisplayDevicesA", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDisplayDevicesW", 1, "lpDevice"); // LPCWSTR
	ADD_PARAM_NAME("EnumDisplayDevicesW", 2, "iDevNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplayDevicesW", 3, "lpDisplayDevice"); // PDISPLAY_DEVICEW
	ADD_PARAM_NAME("EnumDisplayDevicesW", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDisplayMonitors", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumDisplayMonitors", 2, "lprcClip"); // LPCRECT
	ADD_PARAM_NAME("EnumDisplayMonitors", 3, "lpfnEnum"); // MONITORENUMPROC
	ADD_PARAM_NAME("EnumDisplayMonitors", 4, "dwData"); // LPARAM
	ADD_PARAM_NAME("EnumDisplaySettingsA", 1, "lpszDeviceName"); // LPCSTR
	ADD_PARAM_NAME("EnumDisplaySettingsA", 2, "iModeNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsA", 3, "lpDevMode"); // LPDEVMODEA
	ADD_PARAM_NAME("EnumDisplaySettingsExA", 1, "lpszDeviceName"); // LPCSTR
	ADD_PARAM_NAME("EnumDisplaySettingsExA", 2, "iModeNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsExA", 3, "lpDevMode"); // LPDEVMODEA
	ADD_PARAM_NAME("EnumDisplaySettingsExA", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsExW", 1, "lpszDeviceName"); // LPCWSTR
	ADD_PARAM_NAME("EnumDisplaySettingsExW", 2, "iModeNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsExW", 3, "lpDevMode"); // LPDEVMODEW
	ADD_PARAM_NAME("EnumDisplaySettingsExW", 4, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsW", 1, "lpszDeviceName"); // LPCWSTR
	ADD_PARAM_NAME("EnumDisplaySettingsW", 2, "iModeNum"); // DWORD
	ADD_PARAM_NAME("EnumDisplaySettingsW", 3, "lpDevMode"); // LPDEVMODEW
	ADD_PARAM_NAME("EnumEnhMetaFile", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumEnhMetaFile", 2, "hmf"); // HENHMETAFILE
	ADD_PARAM_NAME("EnumEnhMetaFile", 3, "lpProc"); // ENHMFENUMPROC
	ADD_PARAM_NAME("EnumEnhMetaFile", 4, "lpParam"); // LPVOID
	ADD_PARAM_NAME("EnumEnhMetaFile", 5, "lpRect"); // CONST RECT *
	ADD_PARAM_NAME("EnumFontFamiliesA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontFamiliesA", 2, "lpLogfont"); // LPCSTR
	ADD_PARAM_NAME("EnumFontFamiliesA", 3, "lpProc"); // FONTENUMPROCA
	ADD_PARAM_NAME("EnumFontFamiliesA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFontFamiliesExA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontFamiliesExA", 2, "lpLogfont"); // LPLOGFONTA
	ADD_PARAM_NAME("EnumFontFamiliesExA", 3, "lpProc"); // FONTENUMPROCA
	ADD_PARAM_NAME("EnumFontFamiliesExA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFontFamiliesExA", 5, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumFontFamiliesExW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontFamiliesExW", 2, "lpLogfont"); // LPLOGFONTW
	ADD_PARAM_NAME("EnumFontFamiliesExW", 3, "lpProc"); // FONTENUMPROCW
	ADD_PARAM_NAME("EnumFontFamiliesExW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFontFamiliesExW", 5, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumFontFamiliesW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontFamiliesW", 2, "lpLogfont"); // LPCWSTR
	ADD_PARAM_NAME("EnumFontFamiliesW", 3, "lpProc"); // FONTENUMPROCW
	ADD_PARAM_NAME("EnumFontFamiliesW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFontsA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontsA", 2, "lpLogfont"); // LPCSTR
	ADD_PARAM_NAME("EnumFontsA", 3, "lpProc"); // FONTENUMPROCA
	ADD_PARAM_NAME("EnumFontsA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFontsW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumFontsW", 2, "lpLogfont"); // LPCWSTR
	ADD_PARAM_NAME("EnumFontsW", 3, "lpProc"); // FONTENUMPROCW
	ADD_PARAM_NAME("EnumFontsW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumFormsA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumFormsA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumFormsA", 3, "pForm"); // LPBYTE
	ADD_PARAM_NAME("EnumFormsA", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumFormsA", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumFormsA", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumFormsW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumFormsW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumFormsW", 3, "pForm"); // LPBYTE
	ADD_PARAM_NAME("EnumFormsW", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumFormsW", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumFormsW", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumICMProfilesA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumICMProfilesA", 2, "lpProc"); // ICMENUMPROCA
	ADD_PARAM_NAME("EnumICMProfilesA", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumICMProfilesW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumICMProfilesW", 2, "lpProc"); // ICMENUMPROCW
	ADD_PARAM_NAME("EnumICMProfilesW", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumJobsA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumJobsA", 2, "FirstJob"); // DWORD
	ADD_PARAM_NAME("EnumJobsA", 3, "NoJobs"); // DWORD
	ADD_PARAM_NAME("EnumJobsA", 4, "Level"); // DWORD
	ADD_PARAM_NAME("EnumJobsA", 5, "pJob"); // LPBYTE
	ADD_PARAM_NAME("EnumJobsA", 6, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumJobsA", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumJobsA", 8, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumJobsW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumJobsW", 2, "FirstJob"); // DWORD
	ADD_PARAM_NAME("EnumJobsW", 3, "NoJobs"); // DWORD
	ADD_PARAM_NAME("EnumJobsW", 4, "Level"); // DWORD
	ADD_PARAM_NAME("EnumJobsW", 5, "pJob"); // LPBYTE
	ADD_PARAM_NAME("EnumJobsW", 6, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumJobsW", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumJobsW", 8, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumLanguageGroupLocalesA", 1, "lpLangGroupLocaleEnumProc"); // LANGGROUPLOCALE_ENUMPROCA
	ADD_PARAM_NAME("EnumLanguageGroupLocalesA", 2, "LanguageGroup"); // LGRPID
	ADD_PARAM_NAME("EnumLanguageGroupLocalesA", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumLanguageGroupLocalesA", 4, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumLanguageGroupLocalesW", 1, "lpLangGroupLocaleEnumProc"); // LANGGROUPLOCALE_ENUMPROCW
	ADD_PARAM_NAME("EnumLanguageGroupLocalesW", 2, "LanguageGroup"); // LGRPID
	ADD_PARAM_NAME("EnumLanguageGroupLocalesW", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumLanguageGroupLocalesW", 4, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumMetaFile", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumMetaFile", 2, "hmf"); // HMETAFILE
	ADD_PARAM_NAME("EnumMetaFile", 3, "lpProc"); // MFENUMPROC
	ADD_PARAM_NAME("EnumMetaFile", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumMonitorsA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("EnumMonitorsA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumMonitorsA", 3, "pMonitor"); // LPBYTE
	ADD_PARAM_NAME("EnumMonitorsA", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumMonitorsA", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumMonitorsA", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumMonitorsW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("EnumMonitorsW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumMonitorsW", 3, "pMonitor"); // LPBYTE
	ADD_PARAM_NAME("EnumMonitorsW", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumMonitorsW", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumMonitorsW", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumObjects", 1, "hdc"); // HDC
	ADD_PARAM_NAME("EnumObjects", 2, "nType"); // int
	ADD_PARAM_NAME("EnumObjects", 3, "lpFunc"); // GOBJENUMPROC
	ADD_PARAM_NAME("EnumObjects", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumPortsA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("EnumPortsA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPortsA", 3, "pPorts"); // LPBYTE
	ADD_PARAM_NAME("EnumPortsA", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPortsA", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPortsA", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPortsW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("EnumPortsW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPortsW", 3, "pPorts"); // LPBYTE
	ADD_PARAM_NAME("EnumPortsW", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPortsW", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPortsW", 6, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 2, "pPrintProcessorName"); // LPSTR
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 4, "pDatatypes"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesA", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 2, "pPrintProcessorName"); // LPWSTR
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 4, "pDatatypes"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorDatatypesW", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorsA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("EnumPrintProcessorsA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("EnumPrintProcessorsA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorsA", 4, "pPrintProcessorInfo"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintProcessorsA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorsA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorsA", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorsW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("EnumPrintProcessorsW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("EnumPrintProcessorsW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorsW", 4, "pPrintProcessorInfo"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintProcessorsW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintProcessorsW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintProcessorsW", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterDataA", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 3, "pValueName"); // LPSTR
	ADD_PARAM_NAME("EnumPrinterDataA", 4, "cbValueName"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 5, "pcbValueName"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 6, "pType"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 7, "pData"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDataA", 8, "cbData"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataA", 9, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataExA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterDataExA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("EnumPrinterDataExA", 3, "pEnumValues"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDataExA", 4, "cbEnumValues"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataExA", 5, "pcbEnumValues"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataExA", 6, "pnEnumValues"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataExW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterDataExW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("EnumPrinterDataExW", 3, "pEnumValues"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDataExW", 4, "cbEnumValues"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataExW", 5, "pcbEnumValues"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataExW", 6, "pnEnumValues"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterDataW", 2, "dwIndex"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 3, "pValueName"); // LPWSTR
	ADD_PARAM_NAME("EnumPrinterDataW", 4, "cbValueName"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 5, "pcbValueName"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 6, "pType"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 7, "pData"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDataW", 8, "cbData"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDataW", 9, "pcbData"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDriversA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("EnumPrinterDriversA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("EnumPrinterDriversA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDriversA", 4, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDriversA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDriversA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDriversA", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDriversW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("EnumPrinterDriversW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("EnumPrinterDriversW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDriversW", 4, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("EnumPrinterDriversW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrinterDriversW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterDriversW", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterKeyA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterKeyA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("EnumPrinterKeyA", 3, "pSubkey"); // LPSTR
	ADD_PARAM_NAME("EnumPrinterKeyA", 4, "cbSubkey"); // DWORD
	ADD_PARAM_NAME("EnumPrinterKeyA", 5, "pcbSubkey"); // LPDWORD
	ADD_PARAM_NAME("EnumPrinterKeyW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("EnumPrinterKeyW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("EnumPrinterKeyW", 3, "pSubkey"); // LPWSTR
	ADD_PARAM_NAME("EnumPrinterKeyW", 4, "cbSubkey"); // DWORD
	ADD_PARAM_NAME("EnumPrinterKeyW", 5, "pcbSubkey"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintersA", 1, "Flags"); // DWORD
	ADD_PARAM_NAME("EnumPrintersA", 2, "Name"); // LPSTR
	ADD_PARAM_NAME("EnumPrintersA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintersA", 4, "pPrinterEnum"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintersA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintersA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintersA", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintersW", 1, "Flags"); // DWORD
	ADD_PARAM_NAME("EnumPrintersW", 2, "Name"); // LPWSTR
	ADD_PARAM_NAME("EnumPrintersW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("EnumPrintersW", 4, "pPrinterEnum"); // LPBYTE
	ADD_PARAM_NAME("EnumPrintersW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("EnumPrintersW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumPrintersW", 7, "pcReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumPropsA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnumPropsA", 2, "lpEnumFunc"); // PROPENUMPROCA
	ADD_PARAM_NAME("EnumPropsExA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnumPropsExA", 2, "lpEnumFunc"); // PROPENUMPROCEXA
	ADD_PARAM_NAME("EnumPropsExA", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumPropsExW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnumPropsExW", 2, "lpEnumFunc"); // PROPENUMPROCEXW
	ADD_PARAM_NAME("EnumPropsExW", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumPropsW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("EnumPropsW", 2, "lpEnumFunc"); // PROPENUMPROCW
	ADD_PARAM_NAME("EnumResourceLanguagesA", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceLanguagesA", 2, "lpType"); // LPCSTR
	ADD_PARAM_NAME("EnumResourceLanguagesA", 3, "lpName"); // LPCSTR
	ADD_PARAM_NAME("EnumResourceLanguagesA", 4, "lpEnumFunc"); // ENUMRESLANGPROCA
	ADD_PARAM_NAME("EnumResourceLanguagesA", 5, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumResourceLanguagesW", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceLanguagesW", 2, "lpType"); // LPCWSTR
	ADD_PARAM_NAME("EnumResourceLanguagesW", 3, "lpName"); // LPCWSTR
	ADD_PARAM_NAME("EnumResourceLanguagesW", 4, "lpEnumFunc"); // ENUMRESLANGPROCW
	ADD_PARAM_NAME("EnumResourceLanguagesW", 5, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumResourceNamesA", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceNamesA", 2, "lpType"); // LPCSTR
	ADD_PARAM_NAME("EnumResourceNamesA", 3, "lpEnumFunc"); // ENUMRESNAMEPROCA
	ADD_PARAM_NAME("EnumResourceNamesA", 4, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumResourceNamesW", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceNamesW", 2, "lpType"); // LPCWSTR
	ADD_PARAM_NAME("EnumResourceNamesW", 3, "lpEnumFunc"); // ENUMRESNAMEPROCW
	ADD_PARAM_NAME("EnumResourceNamesW", 4, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumResourceTypesA", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceTypesA", 2, "lpEnumFunc"); // ENUMRESTYPEPROCA
	ADD_PARAM_NAME("EnumResourceTypesA", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumResourceTypesW", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("EnumResourceTypesW", 2, "lpEnumFunc"); // ENUMRESTYPEPROCW
	ADD_PARAM_NAME("EnumResourceTypesW", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumServicesStatusA", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("EnumServicesStatusA", 2, "dwServiceType"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusA", 3, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusA", 4, "lpServices"); // LPENUM_SERVICE_STATUSA
	ADD_PARAM_NAME("EnumServicesStatusA", 5, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusA", 6, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusA", 7, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusA", 8, "lpResumeHandle"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("EnumServicesStatusExA", 2, "InfoLevel"); // SC_ENUM_TYPE
	ADD_PARAM_NAME("EnumServicesStatusExA", 3, "dwServiceType"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 4, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 5, "lpServices"); // LPBYTE
	ADD_PARAM_NAME("EnumServicesStatusExA", 6, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 7, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 8, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 9, "lpResumeHandle"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExA", 10, "pszGroupName"); // LPCSTR
	ADD_PARAM_NAME("EnumServicesStatusExW", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("EnumServicesStatusExW", 2, "InfoLevel"); // SC_ENUM_TYPE
	ADD_PARAM_NAME("EnumServicesStatusExW", 3, "dwServiceType"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 4, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 5, "lpServices"); // LPBYTE
	ADD_PARAM_NAME("EnumServicesStatusExW", 6, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 7, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 8, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 9, "lpResumeHandle"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusExW", 10, "pszGroupName"); // LPCWSTR
	ADD_PARAM_NAME("EnumServicesStatusW", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("EnumServicesStatusW", 2, "dwServiceType"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusW", 3, "dwServiceState"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusW", 4, "lpServices"); // LPENUM_SERVICE_STATUSW
	ADD_PARAM_NAME("EnumServicesStatusW", 5, "cbBufSize"); // DWORD
	ADD_PARAM_NAME("EnumServicesStatusW", 6, "pcbBytesNeeded"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusW", 7, "lpServicesReturned"); // LPDWORD
	ADD_PARAM_NAME("EnumServicesStatusW", 8, "lpResumeHandle"); // LPDWORD
	ADD_PARAM_NAME("EnumSystemCodePagesA", 1, "lpCodePageEnumProc"); // CODEPAGE_ENUMPROCA
	ADD_PARAM_NAME("EnumSystemCodePagesA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemCodePagesW", 1, "lpCodePageEnumProc"); // CODEPAGE_ENUMPROCW
	ADD_PARAM_NAME("EnumSystemCodePagesW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemFirmwareTables", 1, "FirmwareTableProviderSignature"); // DWORD
	ADD_PARAM_NAME("EnumSystemFirmwareTables", 2, "pFirmwareTableEnumBuffer"); // PVOID
	ADD_PARAM_NAME("EnumSystemFirmwareTables", 3, "BufferSize"); // DWORD
	ADD_PARAM_NAME("EnumSystemGeoID", 1, "GeoClass"); // GEOCLASS
	ADD_PARAM_NAME("EnumSystemGeoID", 2, "ParentGeoId"); // GEOID
	ADD_PARAM_NAME("EnumSystemGeoID", 3, "lpGeoEnumProc"); // GEO_ENUMPROC
	ADD_PARAM_NAME("EnumSystemLanguageGroupsA", 1, "lpLanguageGroupEnumProc"); // LANGUAGEGROUP_ENUMPROCA
	ADD_PARAM_NAME("EnumSystemLanguageGroupsA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemLanguageGroupsA", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumSystemLanguageGroupsW", 1, "lpLanguageGroupEnumProc"); // LANGUAGEGROUP_ENUMPROCW
	ADD_PARAM_NAME("EnumSystemLanguageGroupsW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemLanguageGroupsW", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumSystemLocalesA", 1, "lpLocaleEnumProc"); // LOCALE_ENUMPROCA
	ADD_PARAM_NAME("EnumSystemLocalesA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemLocalesEx", 1, "lpLocaleEnumProcEx"); // LOCALE_ENUMPROCEX
	ADD_PARAM_NAME("EnumSystemLocalesEx", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumSystemLocalesEx", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumSystemLocalesEx", 4, "lpReserved"); // LPVOID
	ADD_PARAM_NAME("EnumSystemLocalesW", 1, "lpLocaleEnumProc"); // LOCALE_ENUMPROCW
	ADD_PARAM_NAME("EnumSystemLocalesW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumThreadWindows", 1, "dwThreadId"); // DWORD
	ADD_PARAM_NAME("EnumThreadWindows", 2, "lpfn"); // WNDENUMPROC
	ADD_PARAM_NAME("EnumThreadWindows", 3, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumTimeFormatsA", 1, "lpTimeFmtEnumProc"); // TIMEFMT_ENUMPROCA
	ADD_PARAM_NAME("EnumTimeFormatsA", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumTimeFormatsA", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumTimeFormatsEx", 1, "lpTimeFmtEnumProcEx"); // TIMEFMT_ENUMPROCEX
	ADD_PARAM_NAME("EnumTimeFormatsEx", 2, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("EnumTimeFormatsEx", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumTimeFormatsEx", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumTimeFormatsW", 1, "lpTimeFmtEnumProc"); // TIMEFMT_ENUMPROCW
	ADD_PARAM_NAME("EnumTimeFormatsW", 2, "Locale"); // LCID
	ADD_PARAM_NAME("EnumTimeFormatsW", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumUILanguagesA", 1, "lpUILanguageEnumProc"); // UILANGUAGE_ENUMPROCA
	ADD_PARAM_NAME("EnumUILanguagesA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumUILanguagesA", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumUILanguagesW", 1, "lpUILanguageEnumProc"); // UILANGUAGE_ENUMPROCW
	ADD_PARAM_NAME("EnumUILanguagesW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("EnumUILanguagesW", 3, "lParam"); // LONG_PTR
	ADD_PARAM_NAME("EnumWindowStationsA", 1, "lpEnumFunc"); // WINSTAENUMPROCA
	ADD_PARAM_NAME("EnumWindowStationsA", 2, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumWindowStationsW", 1, "lpEnumFunc"); // WINSTAENUMPROCW
	ADD_PARAM_NAME("EnumWindowStationsW", 2, "lParam"); // LPARAM
	ADD_PARAM_NAME("EnumWindows", 1, "lpEnumFunc"); // WNDENUMPROC
	ADD_PARAM_NAME("EnumWindows", 2, "lParam"); // LPARAM
	ADD_PARAM_NAME("EqualDomainSid", 1, "pSid1"); // PSID
	ADD_PARAM_NAME("EqualDomainSid", 2, "pSid2"); // PSID
	ADD_PARAM_NAME("EqualDomainSid", 3, "pfEqual"); // WINBOOL *
	ADD_PARAM_NAME("EqualPrefixSid", 1, "pSid1"); // PSID
	ADD_PARAM_NAME("EqualPrefixSid", 2, "pSid2"); // PSID
	ADD_PARAM_NAME("EqualRect", 1, "lprc1"); // CONST RECT *
	ADD_PARAM_NAME("EqualRect", 2, "lprc2"); // CONST RECT *
	ADD_PARAM_NAME("EqualRgn", 1, "hrgn1"); // HRGN
	ADD_PARAM_NAME("EqualRgn", 2, "hrgn2"); // HRGN
	ADD_PARAM_NAME("EqualSid", 1, "pSid1"); // PSID
	ADD_PARAM_NAME("EqualSid", 2, "pSid2"); // PSID
	ADD_PARAM_NAME("EraseTape", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("EraseTape", 2, "dwEraseType"); // DWORD
	ADD_PARAM_NAME("EraseTape", 3, "bImmediate"); // WINBOOL
	ADD_PARAM_NAME("Escape", 1, "hdc"); // HDC
	ADD_PARAM_NAME("Escape", 2, "iEscape"); // int
	ADD_PARAM_NAME("Escape", 3, "cjIn"); // int
	ADD_PARAM_NAME("Escape", 4, "pvIn"); // LPCSTR
	ADD_PARAM_NAME("Escape", 5, "pvOut"); // LPVOID
	ADD_PARAM_NAME("EscapeCommFunction", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("EscapeCommFunction", 2, "dwFunc"); // DWORD
	ADD_PARAM_NAME("EvtArchiveExportedLog", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtArchiveExportedLog", 2, "LogFilePath"); // LPCWSTR
	ADD_PARAM_NAME("EvtArchiveExportedLog", 3, "Locale"); // LCID
	ADD_PARAM_NAME("EvtArchiveExportedLog", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtCancel", 1, "Object"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtClearLog", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtClearLog", 2, "ChannelPath"); // LPCWSTR
	ADD_PARAM_NAME("EvtClearLog", 3, "TargetFilePath"); // LPCWSTR
	ADD_PARAM_NAME("EvtClearLog", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtClose", 1, "Object"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtCreateBookmark", 1, "BookmarkXml"); // LPCWSTR
	ADD_PARAM_NAME("EvtCreateRenderContext", 1, "ValuePathsCount"); // DWORD
	ADD_PARAM_NAME("EvtCreateRenderContext", 2, "ValuePaths"); // LPCWSTR *
	ADD_PARAM_NAME("EvtCreateRenderContext", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtExportLog", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtExportLog", 2, "Path"); // LPCWSTR
	ADD_PARAM_NAME("EvtExportLog", 3, "Query"); // LPCWSTR
	ADD_PARAM_NAME("EvtExportLog", 4, "TargetFilePath"); // LPCWSTR
	ADD_PARAM_NAME("EvtExportLog", 5, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtFormatMessage", 1, "PublisherMetadata"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtFormatMessage", 2, "Event"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtFormatMessage", 3, "MessageId"); // DWORD
	ADD_PARAM_NAME("EvtFormatMessage", 4, "ValueCount"); // DWORD
	ADD_PARAM_NAME("EvtFormatMessage", 5, "Values"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtFormatMessage", 6, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtFormatMessage", 7, "BufferSize"); // DWORD
	ADD_PARAM_NAME("EvtFormatMessage", 8, "Buffer"); // LPWSTR
	ADD_PARAM_NAME("EvtFormatMessage", 9, "BufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 1, "ChannelConfig"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 2, "PropertyId"); // EVT_CHANNEL_CONFIG_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 4, "PropertyValueBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 5, "PropertyValueBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetChannelConfigProperty", 6, "PropertyValueBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetEventInfo", 1, "Event"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetEventInfo", 2, "PropertyId"); // EVT_EVENT_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetEventInfo", 3, "PropertyValueBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetEventInfo", 4, "PropertyValueBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetEventInfo", 5, "PropertyValueBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 1, "EventMetadata"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 2, "PropertyId"); // EVT_EVENT_METADATA_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 4, "EventMetadataPropertyBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 5, "EventMetadataPropertyBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetEventMetadataProperty", 6, "EventMetadataPropertyBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetExtendedStatus", 1, "BufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetExtendedStatus", 2, "Buffer"); // LPWSTR
	ADD_PARAM_NAME("EvtGetExtendedStatus", 3, "BufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetLogInfo", 1, "Log"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetLogInfo", 2, "PropertyId"); // EVT_LOG_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetLogInfo", 3, "PropertyValueBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetLogInfo", 4, "PropertyValueBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetLogInfo", 5, "PropertyValueBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 1, "ObjectArray"); // EVT_OBJECT_ARRAY_PROPERTY_HANDLE
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 2, "PropertyId"); // DWORD
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 3, "ArrayIndex"); // DWORD
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 5, "PropertyValueBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 6, "PropertyValueBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetObjectArrayProperty", 7, "PropertyValueBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetObjectArraySize", 1, "ObjectArray"); // EVT_OBJECT_ARRAY_PROPERTY_HANDLE
	ADD_PARAM_NAME("EvtGetObjectArraySize", 2, "ObjectArraySize"); // PDWORD
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 1, "PublisherMetadata"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 2, "PropertyId"); // EVT_PUBLISHER_METADATA_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 4, "PublisherMetadataPropertyBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 5, "PublisherMetadataPropertyBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetPublisherMetadataProperty", 6, "PublisherMetadataPropertyBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtGetQueryInfo", 1, "QueryOrSubscription"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtGetQueryInfo", 2, "PropertyId"); // EVT_QUERY_PROPERTY_ID
	ADD_PARAM_NAME("EvtGetQueryInfo", 3, "PropertyValueBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtGetQueryInfo", 4, "PropertyValueBuffer"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtGetQueryInfo", 5, "PropertyValueBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtNext", 1, "ResultSet"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtNext", 2, "EventArraySize"); // DWORD
	ADD_PARAM_NAME("EvtNext", 3, "EventArray"); // EVT_HANDLE *
	ADD_PARAM_NAME("EvtNext", 4, "Timeout"); // DWORD
	ADD_PARAM_NAME("EvtNext", 5, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtNext", 6, "Returned"); // PDWORD
	ADD_PARAM_NAME("EvtNextChannelPath", 1, "ChannelEnum"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtNextChannelPath", 2, "ChannelPathBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtNextChannelPath", 3, "ChannelPathBuffer"); // LPWSTR
	ADD_PARAM_NAME("EvtNextChannelPath", 4, "ChannelPathBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtNextEventMetadata", 1, "EventMetadataEnum"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtNextEventMetadata", 2, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtNextPublisherId", 1, "PublisherEnum"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtNextPublisherId", 2, "PublisherIdBufferSize"); // DWORD
	ADD_PARAM_NAME("EvtNextPublisherId", 3, "PublisherIdBuffer"); // LPWSTR
	ADD_PARAM_NAME("EvtNextPublisherId", 4, "PublisherIdBufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtOpenChannelConfig", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenChannelConfig", 2, "ChannelPath"); // LPCWSTR
	ADD_PARAM_NAME("EvtOpenChannelConfig", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenChannelEnum", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenChannelEnum", 2, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenEventMetadataEnum", 1, "PublisherMetadata"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenEventMetadataEnum", 2, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenLog", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenLog", 2, "Path"); // LPCWSTR
	ADD_PARAM_NAME("EvtOpenLog", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenPublisherEnum", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenPublisherEnum", 2, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenPublisherMetadata", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtOpenPublisherMetadata", 2, "PublisherIdentity"); // LPCWSTR
	ADD_PARAM_NAME("EvtOpenPublisherMetadata", 3, "LogFilePath"); // LPCWSTR
	ADD_PARAM_NAME("EvtOpenPublisherMetadata", 4, "Locale"); // LCID
	ADD_PARAM_NAME("EvtOpenPublisherMetadata", 5, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtOpenSession", 1, "LoginClass"); // EVT_LOGIN_CLASS
	ADD_PARAM_NAME("EvtOpenSession", 2, "Login"); // PVOID
	ADD_PARAM_NAME("EvtOpenSession", 3, "Timeout"); // DWORD
	ADD_PARAM_NAME("EvtOpenSession", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtQuery", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtQuery", 2, "Path"); // LPCWSTR
	ADD_PARAM_NAME("EvtQuery", 3, "Query"); // LPCWSTR
	ADD_PARAM_NAME("EvtQuery", 4, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtRender", 1, "Context"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtRender", 2, "Fragment"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtRender", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtRender", 4, "BufferSize"); // DWORD
	ADD_PARAM_NAME("EvtRender", 5, "Buffer"); // PVOID
	ADD_PARAM_NAME("EvtRender", 6, "BufferUsed"); // PDWORD
	ADD_PARAM_NAME("EvtRender", 7, "PropertyCount"); // PDWORD
	ADD_PARAM_NAME("EvtSaveChannelConfig", 1, "ChannelConfig"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSaveChannelConfig", 2, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtSeek", 1, "ResultSet"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSeek", 2, "Position"); // LONGLONG
	ADD_PARAM_NAME("EvtSeek", 3, "Bookmark"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSeek", 4, "Timeout"); // DWORD
	ADD_PARAM_NAME("EvtSeek", 5, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtSetChannelConfigProperty", 1, "ChannelConfig"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSetChannelConfigProperty", 2, "PropertyId"); // EVT_CHANNEL_CONFIG_PROPERTY_ID
	ADD_PARAM_NAME("EvtSetChannelConfigProperty", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtSetChannelConfigProperty", 4, "PropertyValue"); // PEVT_VARIANT
	ADD_PARAM_NAME("EvtSubscribe", 1, "Session"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSubscribe", 2, "SignalEvent"); // HANDLE
	ADD_PARAM_NAME("EvtSubscribe", 3, "ChannelPath"); // LPCWSTR
	ADD_PARAM_NAME("EvtSubscribe", 4, "Query"); // LPCWSTR
	ADD_PARAM_NAME("EvtSubscribe", 5, "Bookmark"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtSubscribe", 6, "context"); // PVOID
	ADD_PARAM_NAME("EvtSubscribe", 7, "Callback"); // EVT_SUBSCRIBE_CALLBACK
	ADD_PARAM_NAME("EvtSubscribe", 8, "Flags"); // DWORD
	ADD_PARAM_NAME("EvtUpdateBookmark", 1, "Bookmark"); // EVT_HANDLE
	ADD_PARAM_NAME("EvtUpdateBookmark", 2, "Event"); // EVT_HANDLE
	ADD_PARAM_NAME("ExcludeClipRect", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExcludeClipRect", 2, "left"); // int
	ADD_PARAM_NAME("ExcludeClipRect", 3, "top"); // int
	ADD_PARAM_NAME("ExcludeClipRect", 4, "right"); // int
	ADD_PARAM_NAME("ExcludeClipRect", 5, "bottom"); // int
	ADD_PARAM_NAME("ExcludeUpdateRgn", 1, "hDC"); // HDC
	ADD_PARAM_NAME("ExcludeUpdateRgn", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("ExitProcess", 1, "uExitCode"); // UINT
	ADD_PARAM_NAME("ExitThread", 1, "dwExitCode"); // DWORD
	ADD_PARAM_NAME("ExitWindowsEx", 1, "uFlags"); // UINT
	ADD_PARAM_NAME("ExitWindowsEx", 2, "dwReason"); // DWORD
	ADD_PARAM_NAME("ExpandEnvironmentStringsA", 1, "lpSrc"); // LPCSTR
	ADD_PARAM_NAME("ExpandEnvironmentStringsA", 2, "lpDst"); // LPSTR
	ADD_PARAM_NAME("ExpandEnvironmentStringsA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("ExpandEnvironmentStringsW", 1, "lpSrc"); // LPCWSTR
	ADD_PARAM_NAME("ExpandEnvironmentStringsW", 2, "lpDst"); // LPWSTR
	ADD_PARAM_NAME("ExpandEnvironmentStringsW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("ExtCreatePen", 1, "iPenStyle"); // DWORD
	ADD_PARAM_NAME("ExtCreatePen", 2, "cWidth"); // DWORD
	ADD_PARAM_NAME("ExtCreatePen", 3, "plbrush"); // CONST LOGBRUSH *
	ADD_PARAM_NAME("ExtCreatePen", 4, "cStyle"); // DWORD
	ADD_PARAM_NAME("ExtCreatePen", 5, "pstyle"); // CONST DWORD *
	ADD_PARAM_NAME("ExtCreateRegion", 1, "lpx"); // CONST XFORM *
	ADD_PARAM_NAME("ExtCreateRegion", 2, "nCount"); // DWORD
	ADD_PARAM_NAME("ExtCreateRegion", 3, "lpData"); // CONST RGNDATA *
	ADD_PARAM_NAME("ExtEscape", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExtEscape", 2, "iEscape"); // int
	ADD_PARAM_NAME("ExtEscape", 3, "cjInput"); // int
	ADD_PARAM_NAME("ExtEscape", 4, "lpInData"); // LPCSTR
	ADD_PARAM_NAME("ExtEscape", 5, "cjOutput"); // int
	ADD_PARAM_NAME("ExtEscape", 6, "lpOutData"); // LPSTR
	ADD_PARAM_NAME("ExtFloodFill", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExtFloodFill", 2, "x"); // int
	ADD_PARAM_NAME("ExtFloodFill", 3, "y"); // int
	ADD_PARAM_NAME("ExtFloodFill", 4, "color"); // COLORREF
	ADD_PARAM_NAME("ExtFloodFill", 5, "type"); // UINT
	ADD_PARAM_NAME("ExtSelectClipRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExtSelectClipRgn", 2, "hrgn"); // HRGN
	ADD_PARAM_NAME("ExtSelectClipRgn", 3, "mode"); // int
	ADD_PARAM_NAME("ExtTextOutA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExtTextOutA", 2, "x"); // int
	ADD_PARAM_NAME("ExtTextOutA", 3, "y"); // int
	ADD_PARAM_NAME("ExtTextOutA", 4, "options"); // UINT
	ADD_PARAM_NAME("ExtTextOutA", 5, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("ExtTextOutA", 6, "lpString"); // LPCSTR
	ADD_PARAM_NAME("ExtTextOutA", 7, "c"); // UINT
	ADD_PARAM_NAME("ExtTextOutA", 8, "lpDx"); // CONST INT *
	ADD_PARAM_NAME("ExtTextOutW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("ExtTextOutW", 2, "x"); // int
	ADD_PARAM_NAME("ExtTextOutW", 3, "y"); // int
	ADD_PARAM_NAME("ExtTextOutW", 4, "options"); // UINT
	ADD_PARAM_NAME("ExtTextOutW", 5, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("ExtTextOutW", 6, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("ExtTextOutW", 7, "c"); // UINT
	ADD_PARAM_NAME("ExtTextOutW", 8, "lpDx"); // CONST INT *
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
