/**
 * @file src/capstone2llvmir/arm64/arm64_init.cpp
 * @brief Initializations for ARM64 implementation of @c Capstone2LlvmIrTranslator.
 * @copyright (c) 2018 Avast Software, licensed under the MIT license
 */

#include "capstone2llvmir/arm64/arm64_impl.h"

#include <capstone/arm64.h>
#include <AArch64/AArch64BaseInfo.h>

namespace retdec {
namespace capstone2llvmir {

//
//==============================================================================
// Pure virtual methods from Capstone2LlvmIrTranslator_impl
//==============================================================================
//

void Capstone2LlvmIrTranslatorArm64_impl::initializeArchSpecific()
{
	// Nothing.
}

void Capstone2LlvmIrTranslatorArm64_impl::initializeRegNameMap()
{
	std::map<uint32_t, std::string> r2n =
	{
			{ARM64_REG_CPSR_N, "cpsr_n"}, // Negative
			{ARM64_REG_CPSR_Z, "cpsr_z"}, // Zero
			{ARM64_REG_CPSR_C, "cpsr_c"}, // Carry
			{ARM64_REG_CPSR_V, "cpsr_v"}, // Overflow
			{ARM64_REG_PC, "pc"},         // Program counter

			// SYSREGS
			{A64SysReg_OSDTRRX_EL1, "osdtrrx_el1"},
			{A64SysReg_OSDTRTX_EL1, "osdtrtx_el1"},
			{A64SysReg_TEECR32_EL1, "teecr32_el1"},
			{A64SysReg_MDCCINT_EL1, "mdccint_el1"},
			{A64SysReg_MDSCR_EL1, "mdscr_el1"},
			{A64SysReg_DBGDTR_EL0, "dbgdtr_el0"},
			{A64SysReg_OSECCR_EL1, "oseccr_el1"},
			{A64SysReg_DBGVCR32_EL2, "dbgvcr32_el2"},
			{A64SysReg_DBGBVR0_EL1, "dbgbvr0_el1"},
			{A64SysReg_DBGBVR1_EL1, "dbgbvr1_el1"},
			{A64SysReg_DBGBVR2_EL1, "dbgbvr2_el1"},
			{A64SysReg_DBGBVR3_EL1, "dbgbvr3_el1"},
			{A64SysReg_DBGBVR4_EL1, "dbgbvr4_el1"},
			{A64SysReg_DBGBVR5_EL1, "dbgbvr5_el1"},
			{A64SysReg_DBGBVR6_EL1, "dbgbvr6_el1"},
			{A64SysReg_DBGBVR7_EL1, "dbgbvr7_el1"},
			{A64SysReg_DBGBVR8_EL1, "dbgbvr8_el1"},
			{A64SysReg_DBGBVR9_EL1, "dbgbvr9_el1"},
			{A64SysReg_DBGBVR10_EL1, "dbgbvr10_el1"},
			{A64SysReg_DBGBVR11_EL1, "dbgbvr11_el1"},
			{A64SysReg_DBGBVR12_EL1, "dbgbvr12_el1"},
			{A64SysReg_DBGBVR13_EL1, "dbgbvr13_el1"},
			{A64SysReg_DBGBVR14_EL1, "dbgbvr14_el1"},
			{A64SysReg_DBGBVR15_EL1, "dbgbvr15_el1"},
			{A64SysReg_DBGBCR0_EL1, "dbgbcr0_el1"},
			{A64SysReg_DBGBCR1_EL1, "dbgbcr1_el1"},
			{A64SysReg_DBGBCR2_EL1, "dbgbcr2_el1"},
			{A64SysReg_DBGBCR3_EL1, "dbgbcr3_el1"},
			{A64SysReg_DBGBCR4_EL1, "dbgbcr4_el1"},
			{A64SysReg_DBGBCR5_EL1, "dbgbcr5_el1"},
			{A64SysReg_DBGBCR6_EL1, "dbgbcr6_el1"},
			{A64SysReg_DBGBCR7_EL1, "dbgbcr7_el1"},
			{A64SysReg_DBGBCR8_EL1, "dbgbcr8_el1"},
			{A64SysReg_DBGBCR9_EL1, "dbgbcr9_el1"},
			{A64SysReg_DBGBCR10_EL1, "dbgbcr10_el1"},
			{A64SysReg_DBGBCR11_EL1, "dbgbcr11_el1"},
			{A64SysReg_DBGBCR12_EL1, "dbgbcr12_el1"},
			{A64SysReg_DBGBCR13_EL1, "dbgbcr13_el1"},
			{A64SysReg_DBGBCR14_EL1, "dbgbcr14_el1"},
			{A64SysReg_DBGBCR15_EL1, "dbgbcr15_el1"},
			{A64SysReg_DBGWVR0_EL1, "dbgwvr0_el1"},
			{A64SysReg_DBGWVR1_EL1, "dbgwvr1_el1"},
			{A64SysReg_DBGWVR2_EL1, "dbgwvr2_el1"},
			{A64SysReg_DBGWVR3_EL1, "dbgwvr3_el1"},
			{A64SysReg_DBGWVR4_EL1, "dbgwvr4_el1"},
			{A64SysReg_DBGWVR5_EL1, "dbgwvr5_el1"},
			{A64SysReg_DBGWVR6_EL1, "dbgwvr6_el1"},
			{A64SysReg_DBGWVR7_EL1, "dbgwvr7_el1"},
			{A64SysReg_DBGWVR8_EL1, "dbgwvr8_el1"},
			{A64SysReg_DBGWVR9_EL1, "dbgwvr9_el1"},
			{A64SysReg_DBGWVR10_EL1, "dbgwvr10_el1"},
			{A64SysReg_DBGWVR11_EL1, "dbgwvr11_el1"},
			{A64SysReg_DBGWVR12_EL1, "dbgwvr12_el1"},
			{A64SysReg_DBGWVR13_EL1, "dbgwvr13_el1"},
			{A64SysReg_DBGWVR14_EL1, "dbgwvr14_el1"},
			{A64SysReg_DBGWVR15_EL1, "dbgwvr15_el1"},
			{A64SysReg_DBGWCR0_EL1, "dbgwcr0_el1"},
			{A64SysReg_DBGWCR1_EL1, "dbgwcr1_el1"},
			{A64SysReg_DBGWCR2_EL1, "dbgwcr2_el1"},
			{A64SysReg_DBGWCR3_EL1, "dbgwcr3_el1"},
			{A64SysReg_DBGWCR4_EL1, "dbgwcr4_el1"},
			{A64SysReg_DBGWCR5_EL1, "dbgwcr5_el1"},
			{A64SysReg_DBGWCR6_EL1, "dbgwcr6_el1"},
			{A64SysReg_DBGWCR7_EL1, "dbgwcr7_el1"},
			{A64SysReg_DBGWCR8_EL1, "dbgwcr8_el1"},
			{A64SysReg_DBGWCR9_EL1, "dbgwcr9_el1"},
			{A64SysReg_DBGWCR10_EL1, "dbgwcr10_el1"},
			{A64SysReg_DBGWCR11_EL1, "dbgwcr11_el1"},
			{A64SysReg_DBGWCR12_EL1, "dbgwcr12_el1"},
			{A64SysReg_DBGWCR13_EL1, "dbgwcr13_el1"},
			{A64SysReg_DBGWCR14_EL1, "dbgwcr14_el1"},
			{A64SysReg_DBGWCR15_EL1, "dbgwcr15_el1"},
			{A64SysReg_TEEHBR32_EL1, "teehbr32_el1"},
			{A64SysReg_OSDLR_EL1, "osdlr_el1"},
			{A64SysReg_DBGPRCR_EL1, "dbgprcr_el1"},
			{A64SysReg_DBGCLAIMSET_EL1, "dbgclaimset_el1"},
			{A64SysReg_DBGCLAIMCLR_EL1, "dbgclaimclr_el1"},
			{A64SysReg_CSSELR_EL1, "csselr_el1"},
			{A64SysReg_VPIDR_EL2, "vpidr_el2"},
			{A64SysReg_VMPIDR_EL2, "vmpidr_el2"},
			{A64SysReg_SCTLR_EL1, "sctlr_el1"},
			{A64SysReg_SCTLR_EL2, "sctlr_el2"},
			{A64SysReg_SCTLR_EL3, "sctlr_el3"},
			{A64SysReg_ACTLR_EL1, "actlr_el1"},
			{A64SysReg_ACTLR_EL2, "actlr_el2"},
			{A64SysReg_ACTLR_EL3, "actlr_el3"},
			{A64SysReg_CPACR_EL1, "cpacr_el1"},
			{A64SysReg_HCR_EL2, "hcr_el2"},
			{A64SysReg_SCR_EL3, "scr_el3"},
			{A64SysReg_MDCR_EL2, "mdcr_el2"},
			{A64SysReg_SDER32_EL3, "sder32_el3"},
			{A64SysReg_CPTR_EL2, "cptr_el2"},
			{A64SysReg_CPTR_EL3, "cptr_el3"},
			{A64SysReg_HSTR_EL2, "hstr_el2"},
			{A64SysReg_HACR_EL2, "hacr_el2"},
			{A64SysReg_MDCR_EL3, "mdcr_el3"},
			{A64SysReg_TTBR0_EL1, "ttbr0_el1"},
			{A64SysReg_TTBR0_EL2, "ttbr0_el2"},
			{A64SysReg_TTBR0_EL3, "ttbr0_el3"},
			{A64SysReg_TTBR1_EL1, "ttbr1_el1"},
			{A64SysReg_TCR_EL1, "tcr_el1"},
			{A64SysReg_TCR_EL2, "tcr_el2"},
			{A64SysReg_TCR_EL3, "tcr_el3"},
			{A64SysReg_VTTBR_EL2, "vttbr_el2"},
			{A64SysReg_VTCR_EL2, "vtcr_el2"},
			{A64SysReg_DACR32_EL2, "dacr32_el2"},
			{A64SysReg_SPSR_EL1, "spsr_el1"},
			{A64SysReg_SPSR_EL2, "spsr_el2"},
			{A64SysReg_SPSR_EL3, "spsr_el3"},
			{A64SysReg_ELR_EL1, "elr_el1"},
			{A64SysReg_ELR_EL2, "elr_el2"},
			{A64SysReg_ELR_EL3, "elr_el3"},
			{A64SysReg_SP_EL0, "sp_el0"},
			{A64SysReg_SP_EL1, "sp_el1"},
			{A64SysReg_SP_EL2, "sp_el2"},
			{A64SysReg_SPSel, "spsel"},
			{A64SysReg_NZCV, "nzcv"},
			{A64SysReg_DAIF, "daif"},
			{A64SysReg_CurrentEL, "currentel"},
			{A64SysReg_SPSR_irq, "spsr_irq"},
			{A64SysReg_SPSR_abt, "spsr_abt"},
			{A64SysReg_SPSR_und, "spsr_und"},
			{A64SysReg_SPSR_fiq, "spsr_fiq"},
			{A64SysReg_FPCR, "fpcr"},
			{A64SysReg_FPSR, "fpsr"},
			{A64SysReg_DSPSR_EL0, "dspsr_el0"},
			{A64SysReg_DLR_EL0, "dlr_el0"},
			{A64SysReg_IFSR32_EL2, "ifsr32_el2"},
			{A64SysReg_AFSR0_EL1, "afsr0_el1"},
			{A64SysReg_AFSR0_EL2, "afsr0_el2"},
			{A64SysReg_AFSR0_EL3, "afsr0_el3"},
			{A64SysReg_AFSR1_EL1, "afsr1_el1"},
			{A64SysReg_AFSR1_EL2, "afsr1_el2"},
			{A64SysReg_AFSR1_EL3, "afsr1_el3"},
			{A64SysReg_ESR_EL1, "esr_el1"},
			{A64SysReg_ESR_EL2, "esr_el2"},
			{A64SysReg_ESR_EL3, "esr_el3"},
			{A64SysReg_FPEXC32_EL2, "fpexc32_el2"},
			{A64SysReg_FAR_EL1, "far_el1"},
			{A64SysReg_FAR_EL2, "far_el2"},
			{A64SysReg_FAR_EL3, "far_el3"},
			{A64SysReg_HPFAR_EL2, "hpfar_el2"},
			{A64SysReg_PAR_EL1, "par_el1"},
			{A64SysReg_PMCR_EL0, "pmcr_el0"},
			{A64SysReg_PMCNTENSET_EL0, "pmcntenset_el0"},
			{A64SysReg_PMCNTENCLR_EL0, "pmcntenclr_el0"},
			{A64SysReg_PMOVSCLR_EL0, "pmovsclr_el0"},
			{A64SysReg_PMSELR_EL0, "pmselr_el0"},
			{A64SysReg_PMCCNTR_EL0, "pmccntr_el0"},
			{A64SysReg_PMXEVTYPER_EL0, "pmxevtyper_el0"},
			{A64SysReg_PMXEVCNTR_EL0, "pmxevcntr_el0"},
			{A64SysReg_PMUSERENR_EL0, "pmuserenr_el0"},
			{A64SysReg_PMINTENSET_EL1, "pmintenset_el1"},
			{A64SysReg_PMINTENCLR_EL1, "pmintenclr_el1"},
			{A64SysReg_PMOVSSET_EL0, "pmovsset_el0"},
			{A64SysReg_MAIR_EL1, "mair_el1"},
			{A64SysReg_MAIR_EL2, "mair_el2"},
			{A64SysReg_MAIR_EL3, "mair_el3"},
			{A64SysReg_AMAIR_EL1, "amair_el1"},
			{A64SysReg_AMAIR_EL2, "amair_el2"},
			{A64SysReg_AMAIR_EL3, "amair_el3"},
			{A64SysReg_VBAR_EL1, "vbar_el1"},
			{A64SysReg_VBAR_EL2, "vbar_el2"},
			{A64SysReg_VBAR_EL3, "vbar_el3"},
			{A64SysReg_RMR_EL1, "rmr_el1"},
			{A64SysReg_RMR_EL2, "rmr_el2"},
			{A64SysReg_RMR_EL3, "rmr_el3"},
			{A64SysReg_CONTEXTIDR_EL1, "contextidr_el1"},
			{A64SysReg_TPIDR_EL0, "tpidr_el0"},
			{A64SysReg_TPIDR_EL2, "tpidr_el2"},
			{A64SysReg_TPIDR_EL3, "tpidr_el3"},
			{A64SysReg_TPIDRRO_EL0, "tpidrro_el0"},
			{A64SysReg_TPIDR_EL1, "tpidr_el1"},
			{A64SysReg_CNTFRQ_EL0, "cntfrq_el0"},
			{A64SysReg_CNTVOFF_EL2, "cntvoff_el2"},
			{A64SysReg_CNTKCTL_EL1, "cntkctl_el1"},
			{A64SysReg_CNTHCTL_EL2, "cnthctl_el2"},
			{A64SysReg_CNTP_TVAL_EL0, "cntp_tval_el0"},
			{A64SysReg_CNTHP_TVAL_EL2, "cnthp_tval_el2"},
			{A64SysReg_CNTPS_TVAL_EL1, "cntps_tval_el1"},
			{A64SysReg_CNTP_CTL_EL0, "cntp_ctl_el0"},
			{A64SysReg_CNTHP_CTL_EL2, "cnthp_ctl_el2"},
			{A64SysReg_CNTPS_CTL_EL1, "cntps_ctl_el1"},
			{A64SysReg_CNTP_CVAL_EL0, "cntp_cval_el0"},
			{A64SysReg_CNTHP_CVAL_EL2, "cnthp_cval_el2"},
			{A64SysReg_CNTPS_CVAL_EL1, "cntps_cval_el1"},
			{A64SysReg_CNTV_TVAL_EL0, "cntv_tval_el0"},
			{A64SysReg_CNTV_CTL_EL0, "cntv_ctl_el0"},
			{A64SysReg_CNTV_CVAL_EL0, "cntv_cval_el0"},
			{A64SysReg_PMEVCNTR0_EL0, "pmevcntr0_el0"},
			{A64SysReg_PMEVCNTR1_EL0, "pmevcntr1_el0"},
			{A64SysReg_PMEVCNTR2_EL0, "pmevcntr2_el0"},
			{A64SysReg_PMEVCNTR3_EL0, "pmevcntr3_el0"},
			{A64SysReg_PMEVCNTR4_EL0, "pmevcntr4_el0"},
			{A64SysReg_PMEVCNTR5_EL0, "pmevcntr5_el0"},
			{A64SysReg_PMEVCNTR6_EL0, "pmevcntr6_el0"},
			{A64SysReg_PMEVCNTR7_EL0, "pmevcntr7_el0"},
			{A64SysReg_PMEVCNTR8_EL0, "pmevcntr8_el0"},
			{A64SysReg_PMEVCNTR9_EL0, "pmevcntr9_el0"},
			{A64SysReg_PMEVCNTR10_EL0, "pmevcntr10_el0"},
			{A64SysReg_PMEVCNTR11_EL0, "pmevcntr11_el0"},
			{A64SysReg_PMEVCNTR12_EL0, "pmevcntr12_el0"},
			{A64SysReg_PMEVCNTR13_EL0, "pmevcntr13_el0"},
			{A64SysReg_PMEVCNTR14_EL0, "pmevcntr14_el0"},
			{A64SysReg_PMEVCNTR15_EL0, "pmevcntr15_el0"},
			{A64SysReg_PMEVCNTR16_EL0, "pmevcntr16_el0"},
			{A64SysReg_PMEVCNTR17_EL0, "pmevcntr17_el0"},
			{A64SysReg_PMEVCNTR18_EL0, "pmevcntr18_el0"},
			{A64SysReg_PMEVCNTR19_EL0, "pmevcntr19_el0"},
			{A64SysReg_PMEVCNTR20_EL0, "pmevcntr20_el0"},
			{A64SysReg_PMEVCNTR21_EL0, "pmevcntr21_el0"},
			{A64SysReg_PMEVCNTR22_EL0, "pmevcntr22_el0"},
			{A64SysReg_PMEVCNTR23_EL0, "pmevcntr23_el0"},
			{A64SysReg_PMEVCNTR24_EL0, "pmevcntr24_el0"},
			{A64SysReg_PMEVCNTR25_EL0, "pmevcntr25_el0"},
			{A64SysReg_PMEVCNTR26_EL0, "pmevcntr26_el0"},
			{A64SysReg_PMEVCNTR27_EL0, "pmevcntr27_el0"},
			{A64SysReg_PMEVCNTR28_EL0, "pmevcntr28_el0"},
			{A64SysReg_PMEVCNTR29_EL0, "pmevcntr29_el0"},
			{A64SysReg_PMEVCNTR30_EL0, "pmevcntr30_el0"},
			{A64SysReg_PMCCFILTR_EL0, "pmccfiltr_el0"},
			{A64SysReg_PMEVTYPER0_EL0, "pmevtyper0_el0"},
			{A64SysReg_PMEVTYPER1_EL0, "pmevtyper1_el0"},
			{A64SysReg_PMEVTYPER2_EL0, "pmevtyper2_el0"},
			{A64SysReg_PMEVTYPER3_EL0, "pmevtyper3_el0"},
			{A64SysReg_PMEVTYPER4_EL0, "pmevtyper4_el0"},
			{A64SysReg_PMEVTYPER5_EL0, "pmevtyper5_el0"},
			{A64SysReg_PMEVTYPER6_EL0, "pmevtyper6_el0"},
			{A64SysReg_PMEVTYPER7_EL0, "pmevtyper7_el0"},
			{A64SysReg_PMEVTYPER8_EL0, "pmevtyper8_el0"},
			{A64SysReg_PMEVTYPER9_EL0, "pmevtyper9_el0"},
			{A64SysReg_PMEVTYPER10_EL0, "pmevtyper10_el0"},
			{A64SysReg_PMEVTYPER11_EL0, "pmevtyper11_el0"},
			{A64SysReg_PMEVTYPER12_EL0, "pmevtyper12_el0"},
			{A64SysReg_PMEVTYPER13_EL0, "pmevtyper13_el0"},
			{A64SysReg_PMEVTYPER14_EL0, "pmevtyper14_el0"},
			{A64SysReg_PMEVTYPER15_EL0, "pmevtyper15_el0"},
			{A64SysReg_PMEVTYPER16_EL0, "pmevtyper16_el0"},
			{A64SysReg_PMEVTYPER17_EL0, "pmevtyper17_el0"},
			{A64SysReg_PMEVTYPER18_EL0, "pmevtyper18_el0"},
			{A64SysReg_PMEVTYPER19_EL0, "pmevtyper19_el0"},
			{A64SysReg_PMEVTYPER20_EL0, "pmevtyper20_el0"},
			{A64SysReg_PMEVTYPER21_EL0, "pmevtyper21_el0"},
			{A64SysReg_PMEVTYPER22_EL0, "pmevtyper22_el0"},
			{A64SysReg_PMEVTYPER23_EL0, "pmevtyper23_el0"},
			{A64SysReg_PMEVTYPER24_EL0, "pmevtyper24_el0"},
			{A64SysReg_PMEVTYPER25_EL0, "pmevtyper25_el0"},
			{A64SysReg_PMEVTYPER26_EL0, "pmevtyper26_el0"},
			{A64SysReg_PMEVTYPER27_EL0, "pmevtyper27_el0"},
			{A64SysReg_PMEVTYPER28_EL0, "pmevtyper28_el0"},
			{A64SysReg_PMEVTYPER29_EL0, "pmevtyper29_el0"},
			{A64SysReg_PMEVTYPER30_EL0, "pmevtyper30_el0"},

			// Trace registers
			{A64SysReg_TRCPRGCTLR, "trcprgctlr"},
			{A64SysReg_TRCPROCSELR, "trcprocselr"},
			{A64SysReg_TRCCONFIGR, "trcconfigr"},
			{A64SysReg_TRCAUXCTLR, "trcauxctlr"},
			{A64SysReg_TRCEVENTCTL0R, "trceventctl0r"},
			{A64SysReg_TRCEVENTCTL1R, "trceventctl1r"},
			{A64SysReg_TRCSTALLCTLR, "trcstallctlr"},
			{A64SysReg_TRCTSCTLR, "trctsctlr"},
			{A64SysReg_TRCSYNCPR, "trcsyncpr"},
			{A64SysReg_TRCCCCTLR, "trcccctlr"},
			{A64SysReg_TRCBBCTLR, "trcbbctlr"},
			{A64SysReg_TRCTRACEIDR, "trctraceidr"},
			{A64SysReg_TRCQCTLR, "trcqctlr"},
			{A64SysReg_TRCVICTLR, "trcvictlr"},
			{A64SysReg_TRCVIIECTLR, "trcviiectlr"},
			{A64SysReg_TRCVISSCTLR, "trcvissctlr"},
			{A64SysReg_TRCVIPCSSCTLR, "trcvipcssctlr"},
			{A64SysReg_TRCVDCTLR, "trcvdctlr"},
			{A64SysReg_TRCVDSACCTLR, "trcvdsacctlr"},
			{A64SysReg_TRCVDARCCTLR, "trcvdarcctlr"},
			{A64SysReg_TRCSEQEVR0, "trcseqevr0"},
			{A64SysReg_TRCSEQEVR1, "trcseqevr1"},
			{A64SysReg_TRCSEQEVR2, "trcseqevr2"},
			{A64SysReg_TRCSEQRSTEVR, "trcseqrstevr"},
			{A64SysReg_TRCSEQSTR, "trcseqstr"},
			{A64SysReg_TRCEXTINSELR, "trcextinselr"},
			{A64SysReg_TRCCNTRLDVR0, "trccntrldvr0"},
			{A64SysReg_TRCCNTRLDVR1, "trccntrldvr1"},
			{A64SysReg_TRCCNTRLDVR2, "trccntrldvr2"},
			{A64SysReg_TRCCNTRLDVR3, "trccntrldvr3"},
			{A64SysReg_TRCCNTCTLR0, "trccntctlr0"},
			{A64SysReg_TRCCNTCTLR1, "trccntctlr1"},
			{A64SysReg_TRCCNTCTLR2, "trccntctlr2"},
			{A64SysReg_TRCCNTCTLR3, "trccntctlr3"},
			{A64SysReg_TRCCNTVR0, "trccntvr0"},
			{A64SysReg_TRCCNTVR1, "trccntvr1"},
			{A64SysReg_TRCCNTVR2, "trccntvr2"},
			{A64SysReg_TRCCNTVR3, "trccntvr3"},
			{A64SysReg_TRCIMSPEC0, "trcimspec0"},
			{A64SysReg_TRCIMSPEC1, "trcimspec1"},
			{A64SysReg_TRCIMSPEC2, "trcimspec2"},
			{A64SysReg_TRCIMSPEC3, "trcimspec3"},
			{A64SysReg_TRCIMSPEC4, "trcimspec4"},
			{A64SysReg_TRCIMSPEC5, "trcimspec5"},
			{A64SysReg_TRCIMSPEC6, "trcimspec6"},
			{A64SysReg_TRCIMSPEC7, "trcimspec7"},
			{A64SysReg_TRCRSCTLR2, "trcrsctlr2"},
			{A64SysReg_TRCRSCTLR3, "trcrsctlr3"},
			{A64SysReg_TRCRSCTLR4, "trcrsctlr4"},
			{A64SysReg_TRCRSCTLR5, "trcrsctlr5"},
			{A64SysReg_TRCRSCTLR6, "trcrsctlr6"},
			{A64SysReg_TRCRSCTLR7, "trcrsctlr7"},
			{A64SysReg_TRCRSCTLR8, "trcrsctlr8"},
			{A64SysReg_TRCRSCTLR9, "trcrsctlr9"},
			{A64SysReg_TRCRSCTLR10, "trcrsctlr10"},
			{A64SysReg_TRCRSCTLR11, "trcrsctlr11"},
			{A64SysReg_TRCRSCTLR12, "trcrsctlr12"},
			{A64SysReg_TRCRSCTLR13, "trcrsctlr13"},
			{A64SysReg_TRCRSCTLR14, "trcrsctlr14"},
			{A64SysReg_TRCRSCTLR15, "trcrsctlr15"},
			{A64SysReg_TRCRSCTLR16, "trcrsctlr16"},
			{A64SysReg_TRCRSCTLR17, "trcrsctlr17"},
			{A64SysReg_TRCRSCTLR18, "trcrsctlr18"},
			{A64SysReg_TRCRSCTLR19, "trcrsctlr19"},
			{A64SysReg_TRCRSCTLR20, "trcrsctlr20"},
			{A64SysReg_TRCRSCTLR21, "trcrsctlr21"},
			{A64SysReg_TRCRSCTLR22, "trcrsctlr22"},
			{A64SysReg_TRCRSCTLR23, "trcrsctlr23"},
			{A64SysReg_TRCRSCTLR24, "trcrsctlr24"},
			{A64SysReg_TRCRSCTLR25, "trcrsctlr25"},
			{A64SysReg_TRCRSCTLR26, "trcrsctlr26"},
			{A64SysReg_TRCRSCTLR27, "trcrsctlr27"},
			{A64SysReg_TRCRSCTLR28, "trcrsctlr28"},
			{A64SysReg_TRCRSCTLR29, "trcrsctlr29"},
			{A64SysReg_TRCRSCTLR30, "trcrsctlr30"},
			{A64SysReg_TRCRSCTLR31, "trcrsctlr31"},
			{A64SysReg_TRCSSCCR0, "trcssccr0"},
			{A64SysReg_TRCSSCCR1, "trcssccr1"},
			{A64SysReg_TRCSSCCR2, "trcssccr2"},
			{A64SysReg_TRCSSCCR3, "trcssccr3"},
			{A64SysReg_TRCSSCCR4, "trcssccr4"},
			{A64SysReg_TRCSSCCR5, "trcssccr5"},
			{A64SysReg_TRCSSCCR6, "trcssccr6"},
			{A64SysReg_TRCSSCCR7, "trcssccr7"},
			{A64SysReg_TRCSSCSR0, "trcsscsr0"},
			{A64SysReg_TRCSSCSR1, "trcsscsr1"},
			{A64SysReg_TRCSSCSR2, "trcsscsr2"},
			{A64SysReg_TRCSSCSR3, "trcsscsr3"},
			{A64SysReg_TRCSSCSR4, "trcsscsr4"},
			{A64SysReg_TRCSSCSR5, "trcsscsr5"},
			{A64SysReg_TRCSSCSR6, "trcsscsr6"},
			{A64SysReg_TRCSSCSR7, "trcsscsr7"},
			{A64SysReg_TRCSSPCICR0, "trcsspcicr0"},
			{A64SysReg_TRCSSPCICR1, "trcsspcicr1"},
			{A64SysReg_TRCSSPCICR2, "trcsspcicr2"},
			{A64SysReg_TRCSSPCICR3, "trcsspcicr3"},
			{A64SysReg_TRCSSPCICR4, "trcsspcicr4"},
			{A64SysReg_TRCSSPCICR5, "trcsspcicr5"},
			{A64SysReg_TRCSSPCICR6, "trcsspcicr6"},
			{A64SysReg_TRCSSPCICR7, "trcsspcicr7"},
			{A64SysReg_TRCPDCR, "trcpdcr"},
			{A64SysReg_TRCACVR0, "trcacvr0"},
			{A64SysReg_TRCACVR1, "trcacvr1"},
			{A64SysReg_TRCACVR2, "trcacvr2"},
			{A64SysReg_TRCACVR3, "trcacvr3"},
			{A64SysReg_TRCACVR4, "trcacvr4"},
			{A64SysReg_TRCACVR5, "trcacvr5"},
			{A64SysReg_TRCACVR6, "trcacvr6"},
			{A64SysReg_TRCACVR7, "trcacvr7"},
			{A64SysReg_TRCACVR8, "trcacvr8"},
			{A64SysReg_TRCACVR9, "trcacvr9"},
			{A64SysReg_TRCACVR10, "trcacvr10"},
			{A64SysReg_TRCACVR11, "trcacvr11"},
			{A64SysReg_TRCACVR12, "trcacvr12"},
			{A64SysReg_TRCACVR13, "trcacvr13"},
			{A64SysReg_TRCACVR14, "trcacvr14"},
			{A64SysReg_TRCACVR15, "trcacvr15"},
			{A64SysReg_TRCACATR0, "trcacatr0"},
			{A64SysReg_TRCACATR1, "trcacatr1"},
			{A64SysReg_TRCACATR2, "trcacatr2"},
			{A64SysReg_TRCACATR3, "trcacatr3"},
			{A64SysReg_TRCACATR4, "trcacatr4"},
			{A64SysReg_TRCACATR5, "trcacatr5"},
			{A64SysReg_TRCACATR6, "trcacatr6"},
			{A64SysReg_TRCACATR7, "trcacatr7"},
			{A64SysReg_TRCACATR8, "trcacatr8"},
			{A64SysReg_TRCACATR9, "trcacatr9"},
			{A64SysReg_TRCACATR10, "trcacatr10"},
			{A64SysReg_TRCACATR11, "trcacatr11"},
			{A64SysReg_TRCACATR12, "trcacatr12"},
			{A64SysReg_TRCACATR13, "trcacatr13"},
			{A64SysReg_TRCACATR14, "trcacatr14"},
			{A64SysReg_TRCACATR15, "trcacatr15"},
			{A64SysReg_TRCDVCVR0, "trcdvcvr0"},
			{A64SysReg_TRCDVCVR1, "trcdvcvr1"},
			{A64SysReg_TRCDVCVR2, "trcdvcvr2"},
			{A64SysReg_TRCDVCVR3, "trcdvcvr3"},
			{A64SysReg_TRCDVCVR4, "trcdvcvr4"},
			{A64SysReg_TRCDVCVR5, "trcdvcvr5"},
			{A64SysReg_TRCDVCVR6, "trcdvcvr6"},
			{A64SysReg_TRCDVCVR7, "trcdvcvr7"},
			{A64SysReg_TRCDVCMR0, "trcdvcmr0"},
			{A64SysReg_TRCDVCMR1, "trcdvcmr1"},
			{A64SysReg_TRCDVCMR2, "trcdvcmr2"},
			{A64SysReg_TRCDVCMR3, "trcdvcmr3"},
			{A64SysReg_TRCDVCMR4, "trcdvcmr4"},
			{A64SysReg_TRCDVCMR5, "trcdvcmr5"},
			{A64SysReg_TRCDVCMR6, "trcdvcmr6"},
			{A64SysReg_TRCDVCMR7, "trcdvcmr7"},
			{A64SysReg_TRCCIDCVR0, "trccidcvr0"},
			{A64SysReg_TRCCIDCVR1, "trccidcvr1"},
			{A64SysReg_TRCCIDCVR2, "trccidcvr2"},
			{A64SysReg_TRCCIDCVR3, "trccidcvr3"},
			{A64SysReg_TRCCIDCVR4, "trccidcvr4"},
			{A64SysReg_TRCCIDCVR5, "trccidcvr5"},
			{A64SysReg_TRCCIDCVR6, "trccidcvr6"},
			{A64SysReg_TRCCIDCVR7, "trccidcvr7"},
			{A64SysReg_TRCVMIDCVR0, "trcvmidcvr0"},
			{A64SysReg_TRCVMIDCVR1, "trcvmidcvr1"},
			{A64SysReg_TRCVMIDCVR2, "trcvmidcvr2"},
			{A64SysReg_TRCVMIDCVR3, "trcvmidcvr3"},
			{A64SysReg_TRCVMIDCVR4, "trcvmidcvr4"},
			{A64SysReg_TRCVMIDCVR5, "trcvmidcvr5"},
			{A64SysReg_TRCVMIDCVR6, "trcvmidcvr6"},
			{A64SysReg_TRCVMIDCVR7, "trcvmidcvr7"},
			{A64SysReg_TRCCIDCCTLR0, "trccidcctlr0"},
			{A64SysReg_TRCCIDCCTLR1, "trccidcctlr1"},
			{A64SysReg_TRCVMIDCCTLR0, "trcvmidcctlr0"},
			{A64SysReg_TRCVMIDCCTLR1, "trcvmidcctlr1"},
			{A64SysReg_TRCITCTRL, "trcitctrl"},
			{A64SysReg_TRCCLAIMSET, "trcclaimset"},
			{A64SysReg_TRCCLAIMCLR, "trcclaimclr"},

			// GICv3 registers
			{A64SysReg_ICC_BPR1_EL1, "icc_bpr1_el1"},
			{A64SysReg_ICC_BPR0_EL1, "icc_bpr0_el1"},
			{A64SysReg_ICC_PMR_EL1, "icc_pmr_el1"},
			{A64SysReg_ICC_CTLR_EL1, "icc_ctlr_el1"},
			{A64SysReg_ICC_CTLR_EL3, "icc_ctlr_el3"},
			{A64SysReg_ICC_SRE_EL1, "icc_sre_el1"},
			{A64SysReg_ICC_SRE_EL2, "icc_sre_el2"},
			{A64SysReg_ICC_SRE_EL3, "icc_sre_el3"},
			{A64SysReg_ICC_IGRPEN0_EL1, "icc_igrpen0_el1"},
			{A64SysReg_ICC_IGRPEN1_EL1, "icc_igrpen1_el1"},
			{A64SysReg_ICC_IGRPEN1_EL3, "icc_igrpen1_el3"},
			{A64SysReg_ICC_SEIEN_EL1, "icc_seien_el1"},
			{A64SysReg_ICC_AP0R0_EL1, "icc_ap0r0_el1"},
			{A64SysReg_ICC_AP0R1_EL1, "icc_ap0r1_el1"},
			{A64SysReg_ICC_AP0R2_EL1, "icc_ap0r2_el1"},
			{A64SysReg_ICC_AP0R3_EL1, "icc_ap0r3_el1"},
			{A64SysReg_ICC_AP1R0_EL1, "icc_ap1r0_el1"},
			{A64SysReg_ICC_AP1R1_EL1, "icc_ap1r1_el1"},
			{A64SysReg_ICC_AP1R2_EL1, "icc_ap1r2_el1"},
			{A64SysReg_ICC_AP1R3_EL1, "icc_ap1r3_el1"},
			{A64SysReg_ICH_AP0R0_EL2, "ich_ap0r0_el2"},
			{A64SysReg_ICH_AP0R1_EL2, "ich_ap0r1_el2"},
			{A64SysReg_ICH_AP0R2_EL2, "ich_ap0r2_el2"},
			{A64SysReg_ICH_AP0R3_EL2, "ich_ap0r3_el2"},
			{A64SysReg_ICH_AP1R0_EL2, "ich_ap1r0_el2"},
			{A64SysReg_ICH_AP1R1_EL2, "ich_ap1r1_el2"},
			{A64SysReg_ICH_AP1R2_EL2, "ich_ap1r2_el2"},
			{A64SysReg_ICH_AP1R3_EL2, "ich_ap1r3_el2"},
			{A64SysReg_ICH_HCR_EL2, "ich_hcr_el2"},
			{A64SysReg_ICH_MISR_EL2, "ich_misr_el2"},
			{A64SysReg_ICH_VMCR_EL2, "ich_vmcr_el2"},
			{A64SysReg_ICH_VSEIR_EL2, "ich_vseir_el2"},
			{A64SysReg_ICH_LR0_EL2, "ich_lr0_el2"},
			{A64SysReg_ICH_LR1_EL2, "ich_lr1_el2"},
			{A64SysReg_ICH_LR2_EL2, "ich_lr2_el2"},
			{A64SysReg_ICH_LR3_EL2, "ich_lr3_el2"},
			{A64SysReg_ICH_LR4_EL2, "ich_lr4_el2"},
			{A64SysReg_ICH_LR5_EL2, "ich_lr5_el2"},
			{A64SysReg_ICH_LR6_EL2, "ich_lr6_el2"},
			{A64SysReg_ICH_LR7_EL2, "ich_lr7_el2"},
			{A64SysReg_ICH_LR8_EL2, "ich_lr8_el2"},
			{A64SysReg_ICH_LR9_EL2, "ich_lr9_el2"},
			{A64SysReg_ICH_LR10_EL2, "ich_lr10_el2"},
			{A64SysReg_ICH_LR11_EL2, "ich_lr11_el2"},
			{A64SysReg_ICH_LR12_EL2, "ich_lr12_el2"},
			{A64SysReg_ICH_LR13_EL2, "ich_lr13_el2"},
			{A64SysReg_ICH_LR14_EL2, "ich_lr14_el2"},
			{A64SysReg_ICH_LR15_EL2, "ich_lr15_el2"},
			{A64SysReg_MDCCSR_EL0, "mdccsr_el0"},
			{A64SysReg_DBGDTRRX_EL0, "dbgdtrrx_el0"},
			{A64SysReg_MDRAR_EL1, "mdrar_el1"},
			{A64SysReg_OSLSR_EL1, "oslsr_el1"},
			{A64SysReg_DBGAUTHSTATUS_EL1, "dbgauthstatus_el1"},
			{A64SysReg_PMCEID0_EL0, "pmceid0_el0"},
			{A64SysReg_PMCEID1_EL0, "pmceid1_el0"},
			{A64SysReg_MIDR_EL1, "midr_el1"},
			{A64SysReg_CCSIDR_EL1, "ccsidr_el1"},
			{A64SysReg_CLIDR_EL1, "clidr_el1"},
			{A64SysReg_CTR_EL0, "ctr_el0"},
			{A64SysReg_MPIDR_EL1, "mpidr_el1"},
			{A64SysReg_REVIDR_EL1, "revidr_el1"},
			{A64SysReg_AIDR_EL1, "aidr_el1"},
			{A64SysReg_DCZID_EL0, "dczid_el0"},
			{A64SysReg_ID_PFR0_EL1, "id_pfr0_el1"},
			{A64SysReg_ID_PFR1_EL1, "id_pfr1_el1"},
			{A64SysReg_ID_DFR0_EL1, "id_dfr0_el1"},
			{A64SysReg_ID_AFR0_EL1, "id_afr0_el1"},
			{A64SysReg_ID_MMFR0_EL1, "id_mmfr0_el1"},
			{A64SysReg_ID_MMFR1_EL1, "id_mmfr1_el1"},
			{A64SysReg_ID_MMFR2_EL1, "id_mmfr2_el1"},
			{A64SysReg_ID_MMFR3_EL1, "id_mmfr3_el1"},
			{A64SysReg_ID_ISAR0_EL1, "id_isar0_el1"},
			{A64SysReg_ID_ISAR1_EL1, "id_isar1_el1"},
			{A64SysReg_ID_ISAR2_EL1, "id_isar2_el1"},
			{A64SysReg_ID_ISAR3_EL1, "id_isar3_el1"},
			{A64SysReg_ID_ISAR4_EL1, "id_isar4_el1"},
			{A64SysReg_ID_ISAR5_EL1, "id_isar5_el1"},
			{A64SysReg_ID_A64PFR0_EL1, "id_aa64pfr0_el1"},
			{A64SysReg_ID_A64PFR1_EL1, "id_aa64pfr1_el1"},
			{A64SysReg_ID_A64DFR0_EL1, "id_aa64dfr0_el1"},
			{A64SysReg_ID_A64DFR1_EL1, "id_aa64dfr1_el1"},
			{A64SysReg_ID_A64AFR0_EL1, "id_aa64afr0_el1"},
			{A64SysReg_ID_A64AFR1_EL1, "id_aa64afr1_el1"},
			{A64SysReg_ID_A64ISAR0_EL1, "id_aa64isar0_el1"},
			{A64SysReg_ID_A64ISAR1_EL1, "id_aa64isar1_el1"},
			{A64SysReg_ID_A64MMFR0_EL1, "id_aa64mmfr0_el1"},
			{A64SysReg_ID_A64MMFR1_EL1, "id_aa64mmfr1_el1"},
			{A64SysReg_MVFR0_EL1, "mvfr0_el1"},
			{A64SysReg_MVFR1_EL1, "mvfr1_el1"},
			{A64SysReg_MVFR2_EL1, "mvfr2_el1"},
			{A64SysReg_RVBAR_EL1, "rvbar_el1"},
			{A64SysReg_RVBAR_EL2, "rvbar_el2"},
			{A64SysReg_RVBAR_EL3, "rvbar_el3"},
			{A64SysReg_ISR_EL1, "isr_el1"},
			{A64SysReg_CNTPCT_EL0, "cntpct_el0"},
			{A64SysReg_CNTVCT_EL0, "cntvct_el0"},

			// Trace registers
			{A64SysReg_TRCSTATR, "trcstatr"},
			{A64SysReg_TRCIDR8, "trcidr8"},
			{A64SysReg_TRCIDR9, "trcidr9"},
			{A64SysReg_TRCIDR10, "trcidr10"},
			{A64SysReg_TRCIDR11, "trcidr11"},
			{A64SysReg_TRCIDR12, "trcidr12"},
			{A64SysReg_TRCIDR13, "trcidr13"},
			{A64SysReg_TRCIDR0, "trcidr0"},
			{A64SysReg_TRCIDR1, "trcidr1"},
			{A64SysReg_TRCIDR2, "trcidr2"},
			{A64SysReg_TRCIDR3, "trcidr3"},
			{A64SysReg_TRCIDR4, "trcidr4"},
			{A64SysReg_TRCIDR5, "trcidr5"},
			{A64SysReg_TRCIDR6, "trcidr6"},
			{A64SysReg_TRCIDR7, "trcidr7"},
			{A64SysReg_TRCOSLSR, "trcoslsr"},
			{A64SysReg_TRCPDSR, "trcpdsr"},
			{A64SysReg_TRCDEVAFF0, "trcdevaff0"},
			{A64SysReg_TRCDEVAFF1, "trcdevaff1"},
			{A64SysReg_TRCLSR, "trclsr"},
			{A64SysReg_TRCAUTHSTATUS, "trcauthstatus"},
			{A64SysReg_TRCDEVARCH, "trcdevarch"},
			{A64SysReg_TRCDEVID, "trcdevid"},
			{A64SysReg_TRCDEVTYPE, "trcdevtype"},
			{A64SysReg_TRCPIDR4, "trcpidr4"},
			{A64SysReg_TRCPIDR5, "trcpidr5"},
			{A64SysReg_TRCPIDR6, "trcpidr6"},
			{A64SysReg_TRCPIDR7, "trcpidr7"},
			{A64SysReg_TRCPIDR0, "trcpidr0"},
			{A64SysReg_TRCPIDR1, "trcpidr1"},
			{A64SysReg_TRCPIDR2, "trcpidr2"},
			{A64SysReg_TRCPIDR3, "trcpidr3"},
			{A64SysReg_TRCCIDR0, "trccidr0"},
			{A64SysReg_TRCCIDR1, "trccidr1"},
			{A64SysReg_TRCCIDR2, "trccidr2"},
			{A64SysReg_TRCCIDR3, "trccidr3"},

			// GICv3 registers
			{A64SysReg_ICC_IAR1_EL1, "icc_iar1_el1"},
			{A64SysReg_ICC_IAR0_EL1, "icc_iar0_el1"},
			{A64SysReg_ICC_HPPIR1_EL1, "icc_hppir1_el1"},
			{A64SysReg_ICC_HPPIR0_EL1, "icc_hppir0_el1"},
			{A64SysReg_ICC_RPR_EL1, "icc_rpr_el1"},
			{A64SysReg_ICH_VTR_EL2, "ich_vtr_el2"},
			{A64SysReg_ICH_EISR_EL2, "ich_eisr_el2"},
			{A64SysReg_ICH_ELSR_EL2, "ich_elsr_el2"},

			// PSTATE - those are probably not registers
			{ARM64_PSTATE_SPSEL, "spsel"},
			{ARM64_PSTATE_DAIFSET, "daifset"},
			{ARM64_PSTATE_DAIFCLR, "daifclr"},
	};

	_reg2name = std::move(r2n);
}

void Capstone2LlvmIrTranslatorArm64_impl::initializeRegTypeMap()
{
	auto* i1 = llvm::IntegerType::getInt1Ty(_module->getContext());
	auto* i8 = llvm::IntegerType::getInt8Ty(_module->getContext());
	auto* i16 = llvm::IntegerType::getInt16Ty(_module->getContext());
	auto* i32 = llvm::IntegerType::getInt32Ty(_module->getContext());
	auto* i64 = llvm::IntegerType::getInt64Ty(_module->getContext());
	auto* i128 = llvm::IntegerType::getInt128Ty(_module->getContext());

	//auto* f16 = llvm::Type::getHalfTy(_module->getContext());
	auto* f32 = llvm::Type::getFloatTy(_module->getContext());
	auto* f64 = llvm::Type::getDoubleTy(_module->getContext());
	auto* f128 = llvm::Type::getFP128Ty(_module->getContext());

	std::map<uint32_t, llvm::Type*> r2t =
	{
		// General purpose registers.
		//
		{ARM64_REG_X0, i64},
		{ARM64_REG_X1, i64},
		{ARM64_REG_X2, i64},
		{ARM64_REG_X3, i64},
		{ARM64_REG_X4, i64},
		{ARM64_REG_X5, i64},
		{ARM64_REG_X6, i64},
		{ARM64_REG_X7, i64},
		{ARM64_REG_X8, i64},
		{ARM64_REG_X9, i64},
		{ARM64_REG_X10, i64},
		{ARM64_REG_X11, i64},
		{ARM64_REG_X12, i64},
		{ARM64_REG_X13, i64},
		{ARM64_REG_X14, i64},
		{ARM64_REG_X15, i64},
		{ARM64_REG_X16, i64},
		{ARM64_REG_X17, i64},
		{ARM64_REG_X18, i64},
		{ARM64_REG_X19, i64},
		{ARM64_REG_X20, i64},
		{ARM64_REG_X21, i64},
		{ARM64_REG_X22, i64},
		{ARM64_REG_X23, i64},
		{ARM64_REG_X24, i64},
		{ARM64_REG_X25, i64},
		{ARM64_REG_X26, i64},
		{ARM64_REG_X27, i64},
		{ARM64_REG_X28, i64},

		// Lower 32 bits of 64{xN} regs
		//
		{ARM64_REG_W0, i32},
		{ARM64_REG_W1, i32},
		{ARM64_REG_W2, i32},
		{ARM64_REG_W3, i32},
		{ARM64_REG_W4, i32},
		{ARM64_REG_W5, i32},
		{ARM64_REG_W6, i32},
		{ARM64_REG_W7, i32},
		{ARM64_REG_W8, i32},
		{ARM64_REG_W9, i32},
		{ARM64_REG_W10, i32},
		{ARM64_REG_W11, i32},
		{ARM64_REG_W12, i32},
		{ARM64_REG_W13, i32},
		{ARM64_REG_W14, i32},
		{ARM64_REG_W15, i32},
		{ARM64_REG_W16, i32},
		{ARM64_REG_W17, i32},
		{ARM64_REG_W18, i32},
		{ARM64_REG_W19, i32},
		{ARM64_REG_W20, i32},
		{ARM64_REG_W21, i32},
		{ARM64_REG_W22, i32},
		{ARM64_REG_W23, i32},
		{ARM64_REG_W24, i32},
		{ARM64_REG_W25, i32},
		{ARM64_REG_W26, i32},
		{ARM64_REG_W27, i32},
		{ARM64_REG_W28, i32},
		{ARM64_REG_W29, i32},
		{ARM64_REG_W30, i32},

		// FP&SIMD Regs
		// Vector
		{ARM64_REG_V0, i128},
		{ARM64_REG_V1, i128},
		{ARM64_REG_V2, i128},
		{ARM64_REG_V3, i128},
		{ARM64_REG_V4, i128},
		{ARM64_REG_V5, i128},
		{ARM64_REG_V6, i128},
		{ARM64_REG_V7, i128},
		{ARM64_REG_V8, i128},
		{ARM64_REG_V9, i128},
		{ARM64_REG_V10, i128},
		{ARM64_REG_V11, i128},
		{ARM64_REG_V12, i128},
		{ARM64_REG_V13, i128},
		{ARM64_REG_V14, i128},
		{ARM64_REG_V15, i128},
		{ARM64_REG_V16, i128},
		{ARM64_REG_V17, i128},
		{ARM64_REG_V18, i128},
		{ARM64_REG_V19, i128},
		{ARM64_REG_V20, i128},
		{ARM64_REG_V21, i128},
		{ARM64_REG_V22, i128},
		{ARM64_REG_V23, i128},
		{ARM64_REG_V24, i128},
		{ARM64_REG_V25, i128},
		{ARM64_REG_V26, i128},
		{ARM64_REG_V27, i128},
		{ARM64_REG_V28, i128},
		{ARM64_REG_V29, i128},
		{ARM64_REG_V30, i128},
		{ARM64_REG_V31, i128},

		// FP
		{ARM64_REG_Q0, f128},
		{ARM64_REG_Q1, f128},
		{ARM64_REG_Q2, f128},
		{ARM64_REG_Q3, f128},
		{ARM64_REG_Q4, f128},
		{ARM64_REG_Q5, f128},
		{ARM64_REG_Q6, f128},
		{ARM64_REG_Q7, f128},
		{ARM64_REG_Q8, f128},
		{ARM64_REG_Q9, f128},
		{ARM64_REG_Q10, f128},
		{ARM64_REG_Q11, f128},
		{ARM64_REG_Q12, f128},
		{ARM64_REG_Q13, f128},
		{ARM64_REG_Q14, f128},
		{ARM64_REG_Q15, f128},
		{ARM64_REG_Q16, f128},
		{ARM64_REG_Q17, f128},
		{ARM64_REG_Q18, f128},
		{ARM64_REG_Q19, f128},
		{ARM64_REG_Q20, f128},
		{ARM64_REG_Q21, f128},
		{ARM64_REG_Q22, f128},
		{ARM64_REG_Q23, f128},
		{ARM64_REG_Q24, f128},
		{ARM64_REG_Q25, f128},
		{ARM64_REG_Q26, f128},
		{ARM64_REG_Q27, f128},
		{ARM64_REG_Q28, f128},
		{ARM64_REG_Q29, f128},
		{ARM64_REG_Q30, f128},
		{ARM64_REG_Q31, f128},

		{ARM64_REG_D0, f64},
		{ARM64_REG_D1, f64},
		{ARM64_REG_D2, f64},
		{ARM64_REG_D3, f64},
		{ARM64_REG_D4, f64},
		{ARM64_REG_D5, f64},
		{ARM64_REG_D6, f64},
		{ARM64_REG_D7, f64},
		{ARM64_REG_D8, f64},
		{ARM64_REG_D9, f64},
		{ARM64_REG_D10, f64},
		{ARM64_REG_D11, f64},
		{ARM64_REG_D12, f64},
		{ARM64_REG_D13, f64},
		{ARM64_REG_D14, f64},
		{ARM64_REG_D15, f64},
		{ARM64_REG_D16, f64},
		{ARM64_REG_D17, f64},
		{ARM64_REG_D18, f64},
		{ARM64_REG_D19, f64},
		{ARM64_REG_D20, f64},
		{ARM64_REG_D21, f64},
		{ARM64_REG_D22, f64},
		{ARM64_REG_D23, f64},
		{ARM64_REG_D24, f64},
		{ARM64_REG_D25, f64},
		{ARM64_REG_D26, f64},
		{ARM64_REG_D27, f64},
		{ARM64_REG_D28, f64},
		{ARM64_REG_D29, f64},
		{ARM64_REG_D30, f64},
		{ARM64_REG_D31, f64},

		{ARM64_REG_S0, f32},
		{ARM64_REG_S1, f32},
		{ARM64_REG_S2, f32},
		{ARM64_REG_S3, f32},
		{ARM64_REG_S4, f32},
		{ARM64_REG_S5, f32},
		{ARM64_REG_S6, f32},
		{ARM64_REG_S7, f32},
		{ARM64_REG_S8, f32},
		{ARM64_REG_S9, f32},
		{ARM64_REG_S10, f32},
		{ARM64_REG_S11, f32},
		{ARM64_REG_S12, f32},
		{ARM64_REG_S13, f32},
		{ARM64_REG_S14, f32},
		{ARM64_REG_S15, f32},
		{ARM64_REG_S16, f32},
		{ARM64_REG_S17, f32},
		{ARM64_REG_S18, f32},
		{ARM64_REG_S19, f32},
		{ARM64_REG_S20, f32},
		{ARM64_REG_S21, f32},
		{ARM64_REG_S22, f32},
		{ARM64_REG_S23, f32},
		{ARM64_REG_S24, f32},
		{ARM64_REG_S25, f32},
		{ARM64_REG_S26, f32},
		{ARM64_REG_S27, f32},
		{ARM64_REG_S28, f32},
		{ARM64_REG_S29, f32},
		{ARM64_REG_S30, f32},
		{ARM64_REG_S31, f32},

		// Instead of 16bit floats which are not supported in llvm
		// we use 16bit integers, so we can generate meaningfull
		// pseudo instructions instead of crashing.
		{ARM64_REG_H0, i16},
		{ARM64_REG_H1, i16},
		{ARM64_REG_H2, i16},
		{ARM64_REG_H3, i16},
		{ARM64_REG_H4, i16},
		{ARM64_REG_H5, i16},
		{ARM64_REG_H6, i16},
		{ARM64_REG_H7, i16},
		{ARM64_REG_H8, i16},
		{ARM64_REG_H9, i16},
		{ARM64_REG_H10, i16},
		{ARM64_REG_H11, i16},
		{ARM64_REG_H12, i16},
		{ARM64_REG_H13, i16},
		{ARM64_REG_H14, i16},
		{ARM64_REG_H15, i16},
		{ARM64_REG_H16, i16},
		{ARM64_REG_H17, i16},
		{ARM64_REG_H18, i16},
		{ARM64_REG_H19, i16},
		{ARM64_REG_H20, i16},
		{ARM64_REG_H21, i16},
		{ARM64_REG_H22, i16},
		{ARM64_REG_H23, i16},
		{ARM64_REG_H24, i16},
		{ARM64_REG_H25, i16},
		{ARM64_REG_H26, i16},
		{ARM64_REG_H27, i16},
		{ARM64_REG_H28, i16},
		{ARM64_REG_H29, i16},
		{ARM64_REG_H30, i16},
		{ARM64_REG_H31, i16},

		{ARM64_REG_B0, i8},
		{ARM64_REG_B1, i8},
		{ARM64_REG_B2, i8},
		{ARM64_REG_B3, i8},
		{ARM64_REG_B4, i8},
		{ARM64_REG_B5, i8},
		{ARM64_REG_B6, i8},
		{ARM64_REG_B7, i8},
		{ARM64_REG_B8, i8},
		{ARM64_REG_B9, i8},
		{ARM64_REG_B10, i8},
		{ARM64_REG_B11, i8},
		{ARM64_REG_B12, i8},
		{ARM64_REG_B13, i8},
		{ARM64_REG_B14, i8},
		{ARM64_REG_B15, i8},
		{ARM64_REG_B16, i8},
		{ARM64_REG_B17, i8},
		{ARM64_REG_B18, i8},
		{ARM64_REG_B19, i8},
		{ARM64_REG_B20, i8},
		{ARM64_REG_B21, i8},
		{ARM64_REG_B22, i8},
		{ARM64_REG_B23, i8},
		{ARM64_REG_B24, i8},
		{ARM64_REG_B25, i8},
		{ARM64_REG_B26, i8},
		{ARM64_REG_B27, i8},
		{ARM64_REG_B28, i8},
		{ARM64_REG_B29, i8},
		{ARM64_REG_B30, i8},
		{ARM64_REG_B31, i8},

		// Special registers.

		// FP Frame pointer
		{ARM64_REG_X29, i64},

		// LP Link register
		{ARM64_REG_X30, i64},

		// Stack pointer
		{ARM64_REG_SP, i64},
		{ARM64_REG_WSP, i32},

		// Zero
		{ARM64_REG_XZR, i64},
		{ARM64_REG_WZR, i32},

		// CPSR flags.
		//
		{ARM64_REG_CPSR_N, i1},
		{ARM64_REG_CPSR_Z, i1},
		{ARM64_REG_CPSR_C, i1},
		{ARM64_REG_CPSR_V, i1},

		// Program counter.
		{ARM64_REG_PC, i64},

		// System registers.
		{A64SysReg_OSDTRRX_EL1, i64},
		{A64SysReg_OSDTRTX_EL1, i64},
		{A64SysReg_TEECR32_EL1, i64},
		{A64SysReg_MDCCINT_EL1, i64},
		{A64SysReg_MDSCR_EL1, i64},
		{A64SysReg_DBGDTR_EL0, i64},
		{A64SysReg_OSECCR_EL1, i64},
		{A64SysReg_DBGVCR32_EL2, i64},
		{A64SysReg_DBGBVR0_EL1, i64},
		{A64SysReg_DBGBVR1_EL1, i64},
		{A64SysReg_DBGBVR2_EL1, i64},
		{A64SysReg_DBGBVR3_EL1, i64},
		{A64SysReg_DBGBVR4_EL1, i64},
		{A64SysReg_DBGBVR5_EL1, i64},
		{A64SysReg_DBGBVR6_EL1, i64},
		{A64SysReg_DBGBVR7_EL1, i64},
		{A64SysReg_DBGBVR8_EL1, i64},
		{A64SysReg_DBGBVR9_EL1, i64},
		{A64SysReg_DBGBVR10_EL1, i64},
		{A64SysReg_DBGBVR11_EL1, i64},
		{A64SysReg_DBGBVR12_EL1, i64},
		{A64SysReg_DBGBVR13_EL1, i64},
		{A64SysReg_DBGBVR14_EL1, i64},
		{A64SysReg_DBGBVR15_EL1, i64},
		{A64SysReg_DBGBCR0_EL1, i64},
		{A64SysReg_DBGBCR1_EL1, i64},
		{A64SysReg_DBGBCR2_EL1, i64},
		{A64SysReg_DBGBCR3_EL1, i64},
		{A64SysReg_DBGBCR4_EL1, i64},
		{A64SysReg_DBGBCR5_EL1, i64},
		{A64SysReg_DBGBCR6_EL1, i64},
		{A64SysReg_DBGBCR7_EL1, i64},
		{A64SysReg_DBGBCR8_EL1, i64},
		{A64SysReg_DBGBCR9_EL1, i64},
		{A64SysReg_DBGBCR10_EL1, i64},
		{A64SysReg_DBGBCR11_EL1, i64},
		{A64SysReg_DBGBCR12_EL1, i64},
		{A64SysReg_DBGBCR13_EL1, i64},
		{A64SysReg_DBGBCR14_EL1, i64},
		{A64SysReg_DBGBCR15_EL1, i64},
		{A64SysReg_DBGWVR0_EL1, i64},
		{A64SysReg_DBGWVR1_EL1, i64},
		{A64SysReg_DBGWVR2_EL1, i64},
		{A64SysReg_DBGWVR3_EL1, i64},
		{A64SysReg_DBGWVR4_EL1, i64},
		{A64SysReg_DBGWVR5_EL1, i64},
		{A64SysReg_DBGWVR6_EL1, i64},
		{A64SysReg_DBGWVR7_EL1, i64},
		{A64SysReg_DBGWVR8_EL1, i64},
		{A64SysReg_DBGWVR9_EL1, i64},
		{A64SysReg_DBGWVR10_EL1, i64},
		{A64SysReg_DBGWVR11_EL1, i64},
		{A64SysReg_DBGWVR12_EL1, i64},
		{A64SysReg_DBGWVR13_EL1, i64},
		{A64SysReg_DBGWVR14_EL1, i64},
		{A64SysReg_DBGWVR15_EL1, i64},
		{A64SysReg_DBGWCR0_EL1, i64},
		{A64SysReg_DBGWCR1_EL1, i64},
		{A64SysReg_DBGWCR2_EL1, i64},
		{A64SysReg_DBGWCR3_EL1, i64},
		{A64SysReg_DBGWCR4_EL1, i64},
		{A64SysReg_DBGWCR5_EL1, i64},
		{A64SysReg_DBGWCR6_EL1, i64},
		{A64SysReg_DBGWCR7_EL1, i64},
		{A64SysReg_DBGWCR8_EL1, i64},
		{A64SysReg_DBGWCR9_EL1, i64},
		{A64SysReg_DBGWCR10_EL1, i64},
		{A64SysReg_DBGWCR11_EL1, i64},
		{A64SysReg_DBGWCR12_EL1, i64},
		{A64SysReg_DBGWCR13_EL1, i64},
		{A64SysReg_DBGWCR14_EL1, i64},
		{A64SysReg_DBGWCR15_EL1, i64},
		{A64SysReg_TEEHBR32_EL1, i64},
		{A64SysReg_OSDLR_EL1, i64},
		{A64SysReg_DBGPRCR_EL1, i64},
		{A64SysReg_DBGCLAIMSET_EL1, i64},
		{A64SysReg_DBGCLAIMCLR_EL1, i64},
		{A64SysReg_CSSELR_EL1, i64},
		{A64SysReg_VPIDR_EL2, i64},
		{A64SysReg_VMPIDR_EL2, i64},
		{A64SysReg_CPACR_EL1, i64},
		{A64SysReg_SCTLR_EL1, i64},
		{A64SysReg_SCTLR_EL2, i64},
		{A64SysReg_SCTLR_EL3, i64},
		{A64SysReg_ACTLR_EL1, i64},
		{A64SysReg_ACTLR_EL2, i64},
		{A64SysReg_ACTLR_EL3, i64},
		{A64SysReg_HCR_EL2, i64},
		{A64SysReg_SCR_EL3, i64},
		{A64SysReg_MDCR_EL2, i64},
		{A64SysReg_SDER32_EL3, i64},
		{A64SysReg_CPTR_EL2, i64},
		{A64SysReg_CPTR_EL3, i64},
		{A64SysReg_HSTR_EL2, i64},
		{A64SysReg_HACR_EL2, i64},
		{A64SysReg_MDCR_EL3, i64},
		{A64SysReg_TTBR0_EL1, i64},
		{A64SysReg_TTBR0_EL2, i64},
		{A64SysReg_TTBR0_EL3, i64},
		{A64SysReg_TTBR1_EL1, i64},
		{A64SysReg_TCR_EL1, i64},
		{A64SysReg_TCR_EL2, i64},
		{A64SysReg_TCR_EL3, i64},
		{A64SysReg_VTTBR_EL2, i64},
		{A64SysReg_VTCR_EL2, i64},
		{A64SysReg_DACR32_EL2, i64},
		{A64SysReg_SPSR_EL1, i64},
		{A64SysReg_SPSR_EL2, i64},
		{A64SysReg_SPSR_EL3, i64},
		{A64SysReg_ELR_EL1, i64},
		{A64SysReg_ELR_EL2, i64},
		{A64SysReg_ELR_EL3, i64},
		{A64SysReg_SP_EL0, i64},
		{A64SysReg_SP_EL1, i64},
		{A64SysReg_SP_EL2, i64},
		{A64SysReg_SPSel, i64},
		{A64SysReg_NZCV, i64},
		{A64SysReg_DAIF, i64},
		{A64SysReg_CurrentEL, i64},
		{A64SysReg_SPSR_irq, i64},
		{A64SysReg_SPSR_abt, i64},
		{A64SysReg_SPSR_und, i64},
		{A64SysReg_SPSR_fiq, i64},
		{A64SysReg_FPCR, i64},
		{A64SysReg_FPSR, i64},
		{A64SysReg_DSPSR_EL0, i64},
		{A64SysReg_DLR_EL0, i64},
		{A64SysReg_IFSR32_EL2, i64},
		{A64SysReg_AFSR0_EL1, i64},
		{A64SysReg_AFSR0_EL2, i64},
		{A64SysReg_AFSR0_EL3, i64},
		{A64SysReg_AFSR1_EL1, i64},
		{A64SysReg_AFSR1_EL2, i64},
		{A64SysReg_AFSR1_EL3, i64},
		{A64SysReg_ESR_EL1, i64},
		{A64SysReg_ESR_EL2, i64},
		{A64SysReg_ESR_EL3, i64},
		{A64SysReg_FPEXC32_EL2, i64},
		{A64SysReg_FAR_EL1, i64},
		{A64SysReg_FAR_EL2, i64},
		{A64SysReg_FAR_EL3, i64},
		{A64SysReg_HPFAR_EL2, i64},
		{A64SysReg_PAR_EL1, i64},
		{A64SysReg_PMCR_EL0, i64},
		{A64SysReg_PMCNTENSET_EL0, i64},
		{A64SysReg_PMCNTENCLR_EL0, i64},
		{A64SysReg_PMOVSCLR_EL0, i64},
		{A64SysReg_PMSELR_EL0, i64},
		{A64SysReg_PMCCNTR_EL0, i64},
		{A64SysReg_PMXEVTYPER_EL0, i64},
		{A64SysReg_PMXEVCNTR_EL0, i64},
		{A64SysReg_PMUSERENR_EL0, i64},
		{A64SysReg_PMINTENSET_EL1, i64},
		{A64SysReg_PMINTENCLR_EL1, i64},
		{A64SysReg_PMOVSSET_EL0, i64},
		{A64SysReg_MAIR_EL1, i64},
		{A64SysReg_MAIR_EL2, i64},
		{A64SysReg_MAIR_EL3, i64},
		{A64SysReg_AMAIR_EL1, i64},
		{A64SysReg_AMAIR_EL2, i64},
		{A64SysReg_AMAIR_EL3, i64},
		{A64SysReg_VBAR_EL1, i64},
		{A64SysReg_VBAR_EL2, i64},
		{A64SysReg_VBAR_EL3, i64},
		{A64SysReg_RMR_EL1, i64},
		{A64SysReg_RMR_EL2, i64},
		{A64SysReg_RMR_EL3, i64},
		{A64SysReg_CONTEXTIDR_EL1, i64},
		{A64SysReg_TPIDR_EL0, i64},
		{A64SysReg_TPIDR_EL2, i64},
		{A64SysReg_TPIDR_EL3, i64},
		{A64SysReg_TPIDRRO_EL0, i64},
		{A64SysReg_TPIDR_EL1, i64},
		{A64SysReg_CNTFRQ_EL0, i64},
		{A64SysReg_CNTVOFF_EL2, i64},
		{A64SysReg_CNTKCTL_EL1, i64},
		{A64SysReg_CNTHCTL_EL2, i64},
		{A64SysReg_CNTP_TVAL_EL0, i64},
		{A64SysReg_CNTHP_TVAL_EL2, i64},
		{A64SysReg_CNTPS_TVAL_EL1, i64},
		{A64SysReg_CNTP_CTL_EL0, i64},
		{A64SysReg_CNTHP_CTL_EL2, i64},
		{A64SysReg_CNTPS_CTL_EL1, i64},
		{A64SysReg_CNTP_CVAL_EL0, i64},
		{A64SysReg_CNTHP_CVAL_EL2, i64},
		{A64SysReg_CNTPS_CVAL_EL1, i64},
		{A64SysReg_CNTV_TVAL_EL0, i64},
		{A64SysReg_CNTV_CTL_EL0, i64},
		{A64SysReg_CNTV_CVAL_EL0, i64},
		{A64SysReg_PMEVCNTR0_EL0, i64},
		{A64SysReg_PMEVCNTR1_EL0, i64},
		{A64SysReg_PMEVCNTR2_EL0, i64},
		{A64SysReg_PMEVCNTR3_EL0, i64},
		{A64SysReg_PMEVCNTR4_EL0, i64},
		{A64SysReg_PMEVCNTR5_EL0, i64},
		{A64SysReg_PMEVCNTR6_EL0, i64},
		{A64SysReg_PMEVCNTR7_EL0, i64},
		{A64SysReg_PMEVCNTR8_EL0, i64},
		{A64SysReg_PMEVCNTR9_EL0, i64},
		{A64SysReg_PMEVCNTR10_EL0, i64},
		{A64SysReg_PMEVCNTR11_EL0, i64},
		{A64SysReg_PMEVCNTR12_EL0, i64},
		{A64SysReg_PMEVCNTR13_EL0, i64},
		{A64SysReg_PMEVCNTR14_EL0, i64},
		{A64SysReg_PMEVCNTR15_EL0, i64},
		{A64SysReg_PMEVCNTR16_EL0, i64},
		{A64SysReg_PMEVCNTR17_EL0, i64},
		{A64SysReg_PMEVCNTR18_EL0, i64},
		{A64SysReg_PMEVCNTR19_EL0, i64},
		{A64SysReg_PMEVCNTR20_EL0, i64},
		{A64SysReg_PMEVCNTR21_EL0, i64},
		{A64SysReg_PMEVCNTR22_EL0, i64},
		{A64SysReg_PMEVCNTR23_EL0, i64},
		{A64SysReg_PMEVCNTR24_EL0, i64},
		{A64SysReg_PMEVCNTR25_EL0, i64},
		{A64SysReg_PMEVCNTR26_EL0, i64},
		{A64SysReg_PMEVCNTR27_EL0, i64},
		{A64SysReg_PMEVCNTR28_EL0, i64},
		{A64SysReg_PMEVCNTR29_EL0, i64},
		{A64SysReg_PMEVCNTR30_EL0, i64},
		{A64SysReg_PMCCFILTR_EL0, i64},
		{A64SysReg_PMEVTYPER0_EL0, i64},
		{A64SysReg_PMEVTYPER1_EL0, i64},
		{A64SysReg_PMEVTYPER2_EL0, i64},
		{A64SysReg_PMEVTYPER3_EL0, i64},
		{A64SysReg_PMEVTYPER4_EL0, i64},
		{A64SysReg_PMEVTYPER5_EL0, i64},
		{A64SysReg_PMEVTYPER6_EL0, i64},
		{A64SysReg_PMEVTYPER7_EL0, i64},
		{A64SysReg_PMEVTYPER8_EL0, i64},
		{A64SysReg_PMEVTYPER9_EL0, i64},
		{A64SysReg_PMEVTYPER10_EL0, i64},
		{A64SysReg_PMEVTYPER11_EL0, i64},
		{A64SysReg_PMEVTYPER12_EL0, i64},
		{A64SysReg_PMEVTYPER13_EL0, i64},
		{A64SysReg_PMEVTYPER14_EL0, i64},
		{A64SysReg_PMEVTYPER15_EL0, i64},
		{A64SysReg_PMEVTYPER16_EL0, i64},
		{A64SysReg_PMEVTYPER17_EL0, i64},
		{A64SysReg_PMEVTYPER18_EL0, i64},
		{A64SysReg_PMEVTYPER19_EL0, i64},
		{A64SysReg_PMEVTYPER20_EL0, i64},
		{A64SysReg_PMEVTYPER21_EL0, i64},
		{A64SysReg_PMEVTYPER22_EL0, i64},
		{A64SysReg_PMEVTYPER23_EL0, i64},
		{A64SysReg_PMEVTYPER24_EL0, i64},
		{A64SysReg_PMEVTYPER25_EL0, i64},
		{A64SysReg_PMEVTYPER26_EL0, i64},
		{A64SysReg_PMEVTYPER27_EL0, i64},
		{A64SysReg_PMEVTYPER28_EL0, i64},
		{A64SysReg_PMEVTYPER29_EL0, i64},
		{A64SysReg_PMEVTYPER30_EL0, i64},

		// Trace registers
		{A64SysReg_TRCPRGCTLR, i64},
		{A64SysReg_TRCPROCSELR, i64},
		{A64SysReg_TRCCONFIGR, i64},
		{A64SysReg_TRCAUXCTLR, i64},
		{A64SysReg_TRCEVENTCTL0R, i64},
		{A64SysReg_TRCEVENTCTL1R, i64},
		{A64SysReg_TRCSTALLCTLR, i64},
		{A64SysReg_TRCTSCTLR, i64},
		{A64SysReg_TRCSYNCPR, i64},
		{A64SysReg_TRCCCCTLR, i64},
		{A64SysReg_TRCBBCTLR, i64},
		{A64SysReg_TRCTRACEIDR, i64},
		{A64SysReg_TRCQCTLR, i64},
		{A64SysReg_TRCVICTLR, i64},
		{A64SysReg_TRCVIIECTLR, i64},
		{A64SysReg_TRCVISSCTLR, i64},
		{A64SysReg_TRCVIPCSSCTLR, i64},
		{A64SysReg_TRCVDCTLR, i64},
		{A64SysReg_TRCVDSACCTLR, i64},
		{A64SysReg_TRCVDARCCTLR, i64},
		{A64SysReg_TRCSEQEVR0, i64},
		{A64SysReg_TRCSEQEVR1, i64},
		{A64SysReg_TRCSEQEVR2, i64},
		{A64SysReg_TRCSEQRSTEVR, i64},
		{A64SysReg_TRCSEQSTR, i64},
		{A64SysReg_TRCEXTINSELR, i64},
		{A64SysReg_TRCCNTRLDVR0, i64},
		{A64SysReg_TRCCNTRLDVR1, i64},
		{A64SysReg_TRCCNTRLDVR2, i64},
		{A64SysReg_TRCCNTRLDVR3, i64},
		{A64SysReg_TRCCNTCTLR0, i64},
		{A64SysReg_TRCCNTCTLR1, i64},
		{A64SysReg_TRCCNTCTLR2, i64},
		{A64SysReg_TRCCNTCTLR3, i64},
		{A64SysReg_TRCCNTVR0, i64},
		{A64SysReg_TRCCNTVR1, i64},
		{A64SysReg_TRCCNTVR2, i64},
		{A64SysReg_TRCCNTVR3, i64},
		{A64SysReg_TRCIMSPEC0, i64},
		{A64SysReg_TRCIMSPEC1, i64},
		{A64SysReg_TRCIMSPEC2, i64},
		{A64SysReg_TRCIMSPEC3, i64},
		{A64SysReg_TRCIMSPEC4, i64},
		{A64SysReg_TRCIMSPEC5, i64},
		{A64SysReg_TRCIMSPEC6, i64},
		{A64SysReg_TRCIMSPEC7, i64},
		{A64SysReg_TRCRSCTLR2, i64},
		{A64SysReg_TRCRSCTLR3, i64},
		{A64SysReg_TRCRSCTLR4, i64},
		{A64SysReg_TRCRSCTLR5, i64},
		{A64SysReg_TRCRSCTLR6, i64},
		{A64SysReg_TRCRSCTLR7, i64},
		{A64SysReg_TRCRSCTLR8, i64},
		{A64SysReg_TRCRSCTLR9, i64},
		{A64SysReg_TRCRSCTLR10, i64},
		{A64SysReg_TRCRSCTLR11, i64},
		{A64SysReg_TRCRSCTLR12, i64},
		{A64SysReg_TRCRSCTLR13, i64},
		{A64SysReg_TRCRSCTLR14, i64},
		{A64SysReg_TRCRSCTLR15, i64},
		{A64SysReg_TRCRSCTLR16, i64},
		{A64SysReg_TRCRSCTLR17, i64},
		{A64SysReg_TRCRSCTLR18, i64},
		{A64SysReg_TRCRSCTLR19, i64},
		{A64SysReg_TRCRSCTLR20, i64},
		{A64SysReg_TRCRSCTLR21, i64},
		{A64SysReg_TRCRSCTLR22, i64},
		{A64SysReg_TRCRSCTLR23, i64},
		{A64SysReg_TRCRSCTLR24, i64},
		{A64SysReg_TRCRSCTLR25, i64},
		{A64SysReg_TRCRSCTLR26, i64},
		{A64SysReg_TRCRSCTLR27, i64},
		{A64SysReg_TRCRSCTLR28, i64},
		{A64SysReg_TRCRSCTLR29, i64},
		{A64SysReg_TRCRSCTLR30, i64},
		{A64SysReg_TRCRSCTLR31, i64},
		{A64SysReg_TRCSSCCR0, i64},
		{A64SysReg_TRCSSCCR1, i64},
		{A64SysReg_TRCSSCCR2, i64},
		{A64SysReg_TRCSSCCR3, i64},
		{A64SysReg_TRCSSCCR4, i64},
		{A64SysReg_TRCSSCCR5, i64},
		{A64SysReg_TRCSSCCR6, i64},
		{A64SysReg_TRCSSCCR7, i64},
		{A64SysReg_TRCSSCSR0, i64},
		{A64SysReg_TRCSSCSR1, i64},
		{A64SysReg_TRCSSCSR2, i64},
		{A64SysReg_TRCSSCSR3, i64},
		{A64SysReg_TRCSSCSR4, i64},
		{A64SysReg_TRCSSCSR5, i64},
		{A64SysReg_TRCSSCSR6, i64},
		{A64SysReg_TRCSSCSR7, i64},
		{A64SysReg_TRCSSPCICR0, i64},
		{A64SysReg_TRCSSPCICR1, i64},
		{A64SysReg_TRCSSPCICR2, i64},
		{A64SysReg_TRCSSPCICR3, i64},
		{A64SysReg_TRCSSPCICR4, i64},
		{A64SysReg_TRCSSPCICR5, i64},
		{A64SysReg_TRCSSPCICR6, i64},
		{A64SysReg_TRCSSPCICR7, i64},
		{A64SysReg_TRCPDCR, i64},
		{A64SysReg_TRCACVR0, i64},
		{A64SysReg_TRCACVR1, i64},
		{A64SysReg_TRCACVR2, i64},
		{A64SysReg_TRCACVR3, i64},
		{A64SysReg_TRCACVR4, i64},
		{A64SysReg_TRCACVR5, i64},
		{A64SysReg_TRCACVR6, i64},
		{A64SysReg_TRCACVR7, i64},
		{A64SysReg_TRCACVR8, i64},
		{A64SysReg_TRCACVR9, i64},
		{A64SysReg_TRCACVR10, i64},
		{A64SysReg_TRCACVR11, i64},
		{A64SysReg_TRCACVR12, i64},
		{A64SysReg_TRCACVR13, i64},
		{A64SysReg_TRCACVR14, i64},
		{A64SysReg_TRCACVR15, i64},
		{A64SysReg_TRCACATR0, i64},
		{A64SysReg_TRCACATR1, i64},
		{A64SysReg_TRCACATR2, i64},
		{A64SysReg_TRCACATR3, i64},
		{A64SysReg_TRCACATR4, i64},
		{A64SysReg_TRCACATR5, i64},
		{A64SysReg_TRCACATR6, i64},
		{A64SysReg_TRCACATR7, i64},
		{A64SysReg_TRCACATR8, i64},
		{A64SysReg_TRCACATR9, i64},
		{A64SysReg_TRCACATR10, i64},
		{A64SysReg_TRCACATR11, i64},
		{A64SysReg_TRCACATR12, i64},
		{A64SysReg_TRCACATR13, i64},
		{A64SysReg_TRCACATR14, i64},
		{A64SysReg_TRCACATR15, i64},
		{A64SysReg_TRCDVCVR0, i64},
		{A64SysReg_TRCDVCVR1, i64},
		{A64SysReg_TRCDVCVR2, i64},
		{A64SysReg_TRCDVCVR3, i64},
		{A64SysReg_TRCDVCVR4, i64},
		{A64SysReg_TRCDVCVR5, i64},
		{A64SysReg_TRCDVCVR6, i64},
		{A64SysReg_TRCDVCVR7, i64},
		{A64SysReg_TRCDVCMR0, i64},
		{A64SysReg_TRCDVCMR1, i64},
		{A64SysReg_TRCDVCMR2, i64},
		{A64SysReg_TRCDVCMR3, i64},
		{A64SysReg_TRCDVCMR4, i64},
		{A64SysReg_TRCDVCMR5, i64},
		{A64SysReg_TRCDVCMR6, i64},
		{A64SysReg_TRCDVCMR7, i64},
		{A64SysReg_TRCCIDCVR0, i64},
		{A64SysReg_TRCCIDCVR1, i64},
		{A64SysReg_TRCCIDCVR2, i64},
		{A64SysReg_TRCCIDCVR3, i64},
		{A64SysReg_TRCCIDCVR4, i64},
		{A64SysReg_TRCCIDCVR5, i64},
		{A64SysReg_TRCCIDCVR6, i64},
		{A64SysReg_TRCCIDCVR7, i64},
		{A64SysReg_TRCVMIDCVR0, i64},
		{A64SysReg_TRCVMIDCVR1, i64},
		{A64SysReg_TRCVMIDCVR2, i64},
		{A64SysReg_TRCVMIDCVR3, i64},
		{A64SysReg_TRCVMIDCVR4, i64},
		{A64SysReg_TRCVMIDCVR5, i64},
		{A64SysReg_TRCVMIDCVR6, i64},
		{A64SysReg_TRCVMIDCVR7, i64},
		{A64SysReg_TRCCIDCCTLR0, i64},
		{A64SysReg_TRCCIDCCTLR1, i64},
		{A64SysReg_TRCVMIDCCTLR0, i64},
		{A64SysReg_TRCVMIDCCTLR1, i64},
		{A64SysReg_TRCITCTRL, i64},
		{A64SysReg_TRCCLAIMSET, i64},
		{A64SysReg_TRCCLAIMCLR, i64},

		// GICv3 registers
		{A64SysReg_ICC_BPR1_EL1, i64},
		{A64SysReg_ICC_BPR0_EL1, i64},
		{A64SysReg_ICC_PMR_EL1, i64},
		{A64SysReg_ICC_CTLR_EL1, i64},
		{A64SysReg_ICC_CTLR_EL3, i64},
		{A64SysReg_ICC_SRE_EL1, i64},
		{A64SysReg_ICC_SRE_EL2, i64},
		{A64SysReg_ICC_SRE_EL3, i64},
		{A64SysReg_ICC_IGRPEN0_EL1, i64},
		{A64SysReg_ICC_IGRPEN1_EL1, i64},
		{A64SysReg_ICC_IGRPEN1_EL3, i64},
		{A64SysReg_ICC_SEIEN_EL1, i64},
		{A64SysReg_ICC_AP0R0_EL1, i64},
		{A64SysReg_ICC_AP0R1_EL1, i64},
		{A64SysReg_ICC_AP0R2_EL1, i64},
		{A64SysReg_ICC_AP0R3_EL1, i64},
		{A64SysReg_ICC_AP1R0_EL1, i64},
		{A64SysReg_ICC_AP1R1_EL1, i64},
		{A64SysReg_ICC_AP1R2_EL1, i64},
		{A64SysReg_ICC_AP1R3_EL1, i64},
		{A64SysReg_ICH_AP0R0_EL2, i64},
		{A64SysReg_ICH_AP0R1_EL2, i64},
		{A64SysReg_ICH_AP0R2_EL2, i64},
		{A64SysReg_ICH_AP0R3_EL2, i64},
		{A64SysReg_ICH_AP1R0_EL2, i64},
		{A64SysReg_ICH_AP1R1_EL2, i64},
		{A64SysReg_ICH_AP1R2_EL2, i64},
		{A64SysReg_ICH_AP1R3_EL2, i64},
		{A64SysReg_ICH_HCR_EL2, i64},
		{A64SysReg_ICH_MISR_EL2, i64},
		{A64SysReg_ICH_VMCR_EL2, i64},
		{A64SysReg_ICH_VSEIR_EL2, i64},
		{A64SysReg_ICH_LR0_EL2, i64},
		{A64SysReg_ICH_LR1_EL2, i64},
		{A64SysReg_ICH_LR2_EL2, i64},
		{A64SysReg_ICH_LR3_EL2, i64},
		{A64SysReg_ICH_LR4_EL2, i64},
		{A64SysReg_ICH_LR5_EL2, i64},
		{A64SysReg_ICH_LR6_EL2, i64},
		{A64SysReg_ICH_LR7_EL2, i64},
		{A64SysReg_ICH_LR8_EL2, i64},
		{A64SysReg_ICH_LR9_EL2, i64},
		{A64SysReg_ICH_LR10_EL2, i64},
		{A64SysReg_ICH_LR11_EL2, i64},
		{A64SysReg_ICH_LR12_EL2, i64},
		{A64SysReg_ICH_LR13_EL2, i64},
		{A64SysReg_ICH_LR14_EL2, i64},
		{A64SysReg_ICH_LR15_EL2, i64},

		// enum A64SysRegROValues
		{A64SysReg_MDCCSR_EL0, i64},
		{A64SysReg_DBGDTRRX_EL0, i64},
		{A64SysReg_MDRAR_EL1, i64},
		{A64SysReg_OSLSR_EL1, i64},
		{A64SysReg_DBGAUTHSTATUS_EL1, i64},
		{A64SysReg_PMCEID0_EL0, i64},
		{A64SysReg_PMCEID1_EL0, i64},
		{A64SysReg_MIDR_EL1, i64},
		{A64SysReg_CCSIDR_EL1, i64},
		{A64SysReg_CLIDR_EL1, i64},
		{A64SysReg_CTR_EL0, i64},
		{A64SysReg_MPIDR_EL1, i64},
		{A64SysReg_REVIDR_EL1, i64},
		{A64SysReg_AIDR_EL1, i64},
		{A64SysReg_DCZID_EL0, i64},
		{A64SysReg_ID_PFR0_EL1, i64},
		{A64SysReg_ID_PFR1_EL1, i64},
		{A64SysReg_ID_DFR0_EL1, i64},
		{A64SysReg_ID_AFR0_EL1, i64},
		{A64SysReg_ID_MMFR0_EL1, i64},
		{A64SysReg_ID_MMFR1_EL1, i64},
		{A64SysReg_ID_MMFR2_EL1, i64},
		{A64SysReg_ID_MMFR3_EL1, i64},
		{A64SysReg_ID_ISAR0_EL1, i64},
		{A64SysReg_ID_ISAR1_EL1, i64},
		{A64SysReg_ID_ISAR2_EL1, i64},
		{A64SysReg_ID_ISAR3_EL1, i64},
		{A64SysReg_ID_ISAR4_EL1, i64},
		{A64SysReg_ID_ISAR5_EL1, i64},
		{A64SysReg_ID_A64PFR0_EL1, i64},
		{A64SysReg_ID_A64PFR1_EL1, i64},
		{A64SysReg_ID_A64DFR0_EL1, i64},
		{A64SysReg_ID_A64DFR1_EL1, i64},
		{A64SysReg_ID_A64AFR0_EL1, i64},
		{A64SysReg_ID_A64AFR1_EL1, i64},
		{A64SysReg_ID_A64ISAR0_EL1, i64},
		{A64SysReg_ID_A64ISAR1_EL1, i64},
		{A64SysReg_ID_A64MMFR0_EL1, i64},
		{A64SysReg_ID_A64MMFR1_EL1, i64},
		{A64SysReg_MVFR0_EL1, i64},
		{A64SysReg_MVFR1_EL1, i64},
		{A64SysReg_MVFR2_EL1, i64},
		{A64SysReg_RVBAR_EL1, i64},
		{A64SysReg_RVBAR_EL2, i64},
		{A64SysReg_RVBAR_EL3, i64},
		{A64SysReg_ISR_EL1, i64},
		{A64SysReg_CNTPCT_EL0, i64},
		{A64SysReg_CNTVCT_EL0, i64},

		// Trace registers
		{A64SysReg_TRCSTATR, i64},
		{A64SysReg_TRCIDR8, i64},
		{A64SysReg_TRCIDR9, i64},
		{A64SysReg_TRCIDR10, i64},
		{A64SysReg_TRCIDR11, i64},
		{A64SysReg_TRCIDR12, i64},
		{A64SysReg_TRCIDR13, i64},
		{A64SysReg_TRCIDR0, i64},
		{A64SysReg_TRCIDR1, i64},
		{A64SysReg_TRCIDR2, i64},
		{A64SysReg_TRCIDR3, i64},
		{A64SysReg_TRCIDR4, i64},
		{A64SysReg_TRCIDR5, i64},
		{A64SysReg_TRCIDR6, i64},
		{A64SysReg_TRCIDR7, i64},
		{A64SysReg_TRCOSLSR, i64},
		{A64SysReg_TRCPDSR, i64},
		{A64SysReg_TRCDEVAFF0, i64},
		{A64SysReg_TRCDEVAFF1, i64},
		{A64SysReg_TRCLSR, i64},
		{A64SysReg_TRCAUTHSTATUS, i64},
		{A64SysReg_TRCDEVARCH, i64},
		{A64SysReg_TRCDEVID, i64},
		{A64SysReg_TRCDEVTYPE, i64},
		{A64SysReg_TRCPIDR4, i64},
		{A64SysReg_TRCPIDR5, i64},
		{A64SysReg_TRCPIDR6, i64},
		{A64SysReg_TRCPIDR7, i64},
		{A64SysReg_TRCPIDR0, i64},
		{A64SysReg_TRCPIDR1, i64},
		{A64SysReg_TRCPIDR2, i64},
		{A64SysReg_TRCPIDR3, i64},
		{A64SysReg_TRCCIDR0, i64},
		{A64SysReg_TRCCIDR1, i64},
		{A64SysReg_TRCCIDR2, i64},
		{A64SysReg_TRCCIDR3, i64},

		// GICv3 registers
		{A64SysReg_ICC_IAR1_EL1, i64},
		{A64SysReg_ICC_IAR0_EL1, i64},
		{A64SysReg_ICC_HPPIR1_EL1, i64},
		{A64SysReg_ICC_HPPIR0_EL1, i64},
		{A64SysReg_ICC_RPR_EL1, i64},
		{A64SysReg_ICH_VTR_EL2, i64},
		{A64SysReg_ICH_EISR_EL2, i64},
		{A64SysReg_ICH_ELSR_EL2, i64},

		{ARM64_PSTATE_SPSEL, i64},
		{ARM64_PSTATE_DAIFSET, i64},
		{ARM64_PSTATE_DAIFCLR, i64},
	};

	_reg2type = std::move(r2t);
}

void Capstone2LlvmIrTranslatorArm64_impl::initializePseudoCallInstructionIDs()
{
	_callInsnIds =
	{
		ARM64_INS_BL,
		ARM64_INS_BLR,
		ARM64_INS_BR,
	};

	_returnInsnIds =
	{
		ARM64_INS_RET,
		ARM64_INS_ERET,
	};

	_branchInsnIds =
	{
		ARM64_INS_B,
	};

	_condBranchInsnIds =
	{
		ARM64_INS_CBNZ,
		ARM64_INS_CBZ,
		ARM64_INS_TBNZ,
		ARM64_INS_TBZ,
	};

	_controlFlowInsnIds =
	{

	};
}

void Capstone2LlvmIrTranslatorArm64_impl::initializeRegistersParentMapToOther(
		const std::vector<arm64_reg>& rs,
		arm64_reg other)
{
	for (auto r : rs)
	{
		_reg2parentMap.insert(std::make_pair(r, other));
	}
}

void Capstone2LlvmIrTranslatorArm64_impl::initializeRegistersParentMap()
{
	// Last element in vector is its own parent.
	std::vector<std::vector<arm64_reg>> rss =
	{
			//         32             64
			{ARM64_REG_W0,  ARM64_REG_X0},
			{ARM64_REG_W1,  ARM64_REG_X1},
			{ARM64_REG_W2,  ARM64_REG_X2},
			{ARM64_REG_W3,  ARM64_REG_X3},
			{ARM64_REG_W4,  ARM64_REG_X4},
			{ARM64_REG_W5,  ARM64_REG_X5},
			{ARM64_REG_W6,  ARM64_REG_X6},
			{ARM64_REG_W7,  ARM64_REG_X7},
			{ARM64_REG_W8,  ARM64_REG_X8},
			{ARM64_REG_W9,  ARM64_REG_X9},
			{ARM64_REG_W10, ARM64_REG_X10},
			{ARM64_REG_W11, ARM64_REG_X11},
			{ARM64_REG_W12, ARM64_REG_X12},
			{ARM64_REG_W13, ARM64_REG_X13},
			{ARM64_REG_W14, ARM64_REG_X14},
			{ARM64_REG_W15, ARM64_REG_X15},
			{ARM64_REG_W16, ARM64_REG_X16},
			{ARM64_REG_W17, ARM64_REG_X17},
			{ARM64_REG_W18, ARM64_REG_X18},
			{ARM64_REG_W19, ARM64_REG_X19},
			{ARM64_REG_W20, ARM64_REG_X20},
			{ARM64_REG_W21, ARM64_REG_X21},
			{ARM64_REG_W22, ARM64_REG_X22},
			{ARM64_REG_W23, ARM64_REG_X23},
			{ARM64_REG_W24, ARM64_REG_X24},
			{ARM64_REG_W25, ARM64_REG_X25},
			{ARM64_REG_W26, ARM64_REG_X26},
			{ARM64_REG_W27, ARM64_REG_X27},
			{ARM64_REG_W28, ARM64_REG_X28},
			{ARM64_REG_W29, ARM64_REG_X29},
			{ARM64_REG_W30, ARM64_REG_X30},

			{ARM64_REG_WSP, ARM64_REG_SP},
			{ARM64_REG_WZR, ARM64_REG_XZR},
	};

	for (std::vector<arm64_reg>& rs : rss)
	{
		initializeRegistersParentMapToOther(rs, rs.back());
	}
}

//
//==============================================================================
// Instruction translation map initialization.
//==============================================================================
//

std::map<
	std::size_t,
	void (Capstone2LlvmIrTranslatorArm64_impl::*)(
			cs_insn* i,
			cs_arm64*,
			llvm::IRBuilder<>&)>
Capstone2LlvmIrTranslatorArm64_impl::_i2fm =
{
	{ARM_INS_INVALID, nullptr},

	{ARM64_INS_ABS, nullptr},
	{ARM64_INS_ADC, &Capstone2LlvmIrTranslatorArm64_impl::translateAdc},
	{ARM64_INS_ADDHN, nullptr},
	{ARM64_INS_ADDHN2, nullptr},
	{ARM64_INS_ADDP, nullptr},
	{ARM64_INS_ADD, &Capstone2LlvmIrTranslatorArm64_impl::translateAdd},
	{ARM64_INS_ADDV, nullptr},
	{ARM64_INS_ADR, &Capstone2LlvmIrTranslatorArm64_impl::translateAdr},
	{ARM64_INS_ADRP, &Capstone2LlvmIrTranslatorArm64_impl::translateAdr},
	{ARM64_INS_AESD, nullptr},
	{ARM64_INS_AESE, nullptr},
	{ARM64_INS_AESIMC, nullptr},
	{ARM64_INS_AESMC, nullptr},
	{ARM64_INS_AND, &Capstone2LlvmIrTranslatorArm64_impl::translateAnd},
	{ARM64_INS_ASR, &Capstone2LlvmIrTranslatorArm64_impl::translateShifts},
	{ARM64_INS_B, &Capstone2LlvmIrTranslatorArm64_impl::translateB},
	{ARM64_INS_BFM, nullptr},
	{ARM64_INS_BIC, &Capstone2LlvmIrTranslatorArm64_impl::translateAnd},
	{ARM64_INS_BIF, nullptr},
	{ARM64_INS_BIT, nullptr},
	{ARM64_INS_BL, &Capstone2LlvmIrTranslatorArm64_impl::translateBl},
	{ARM64_INS_BLR, &Capstone2LlvmIrTranslatorArm64_impl::translateBr},
	{ARM64_INS_BR, &Capstone2LlvmIrTranslatorArm64_impl::translateBr},
	{ARM64_INS_BRK, nullptr},
	{ARM64_INS_BSL, nullptr},
	{ARM64_INS_CBNZ, &Capstone2LlvmIrTranslatorArm64_impl::translateCbnz},
	{ARM64_INS_CBZ, &Capstone2LlvmIrTranslatorArm64_impl::translateCbnz},
	{ARM64_INS_CCMN, &Capstone2LlvmIrTranslatorArm64_impl::translateCondCompare},
	{ARM64_INS_CCMP, &Capstone2LlvmIrTranslatorArm64_impl::translateCondCompare},
	{ARM64_INS_CLREX, nullptr},
	{ARM64_INS_CLS, nullptr},
	{ARM64_INS_CLZ, &Capstone2LlvmIrTranslatorArm64_impl::translateClz},
	{ARM64_INS_CMEQ, nullptr},
	{ARM64_INS_CMGE, nullptr},
	{ARM64_INS_CMGT, nullptr},
	{ARM64_INS_CMHI, nullptr},
	{ARM64_INS_CMHS, nullptr},
	{ARM64_INS_CMLE, nullptr},
	{ARM64_INS_CMLT, nullptr},
	{ARM64_INS_CMTST, nullptr},
	{ARM64_INS_CNT, nullptr},
	{ARM64_INS_MOV, &Capstone2LlvmIrTranslatorArm64_impl::translateMov},
	{ARM64_INS_CRC32B, nullptr},
	{ARM64_INS_CRC32CB, nullptr},
	{ARM64_INS_CRC32CH, nullptr},
	{ARM64_INS_CRC32CW, nullptr},
	{ARM64_INS_CRC32CX, nullptr},
	{ARM64_INS_CRC32H, nullptr},
	{ARM64_INS_CRC32W, nullptr},
	{ARM64_INS_CRC32X, nullptr},
	{ARM64_INS_CSEL, &Capstone2LlvmIrTranslatorArm64_impl::translateCsel},
	{ARM64_INS_CSINC, &Capstone2LlvmIrTranslatorArm64_impl::translateCondSelOp},
	{ARM64_INS_CSINV, &Capstone2LlvmIrTranslatorArm64_impl::translateCondSelOp},
	{ARM64_INS_CSNEG, &Capstone2LlvmIrTranslatorArm64_impl::translateCondSelOp},
	{ARM64_INS_DCPS1, nullptr},
	{ARM64_INS_DCPS2, nullptr},
	{ARM64_INS_DCPS3, nullptr},
	{ARM64_INS_DMB, nullptr},
	{ARM64_INS_DRPS, nullptr},
	{ARM64_INS_DSB, nullptr},
	{ARM64_INS_DUP, nullptr},
	{ARM64_INS_EON, &Capstone2LlvmIrTranslatorArm64_impl::translateEor},
	{ARM64_INS_EOR, &Capstone2LlvmIrTranslatorArm64_impl::translateEor},
	{ARM64_INS_ERET, nullptr},
	{ARM64_INS_EXTR, &Capstone2LlvmIrTranslatorArm64_impl::translateExtr},
	{ARM64_INS_EXT, nullptr},
	{ARM64_INS_FABD, nullptr},
	{ARM64_INS_FABS, &Capstone2LlvmIrTranslatorArm64_impl::translateFUnaryOp},
	{ARM64_INS_FACGE, nullptr},
	{ARM64_INS_FACGT, nullptr},
	{ARM64_INS_FADD, &Capstone2LlvmIrTranslatorArm64_impl::translateFAdd},
	{ARM64_INS_FADDP, nullptr},
	{ARM64_INS_FCCMP, &Capstone2LlvmIrTranslatorArm64_impl::translateFCCmp},
	{ARM64_INS_FCCMPE, nullptr},
	{ARM64_INS_FCMEQ, nullptr},
	{ARM64_INS_FCMGE, nullptr},
	{ARM64_INS_FCMGT, nullptr},
	{ARM64_INS_FCMLE, nullptr},
	{ARM64_INS_FCMLT, nullptr},
	{ARM64_INS_FCMP, &Capstone2LlvmIrTranslatorArm64_impl::translateFCmp},
	{ARM64_INS_FCMPE, nullptr},
	{ARM64_INS_FCSEL, &Capstone2LlvmIrTranslatorArm64_impl::translateFCsel},
	{ARM64_INS_FCVTAS, nullptr},
	{ARM64_INS_FCVTAU, nullptr},
	{ARM64_INS_FCVT, &Capstone2LlvmIrTranslatorArm64_impl::translateFCvt},
	{ARM64_INS_FCVTL, nullptr},
	{ARM64_INS_FCVTL2, nullptr},
	{ARM64_INS_FCVTMS, nullptr},
	{ARM64_INS_FCVTMU, nullptr},
	{ARM64_INS_FCVTNS, nullptr},
	{ARM64_INS_FCVTNU, nullptr},
	{ARM64_INS_FCVTN, nullptr},
	{ARM64_INS_FCVTN2, nullptr},
	{ARM64_INS_FCVTPS, nullptr},
	{ARM64_INS_FCVTPU, nullptr},
	{ARM64_INS_FCVTXN, nullptr},
	{ARM64_INS_FCVTXN2, nullptr},
	{ARM64_INS_FCVTZS, &Capstone2LlvmIrTranslatorArm64_impl::translateFCvtz},
	{ARM64_INS_FCVTZU, &Capstone2LlvmIrTranslatorArm64_impl::translateFCvtz},
	{ARM64_INS_FDIV, &Capstone2LlvmIrTranslatorArm64_impl::translateFDiv},
	{ARM64_INS_FMADD, &Capstone2LlvmIrTranslatorArm64_impl::translateFMadd},
	{ARM64_INS_FMAX, &Capstone2LlvmIrTranslatorArm64_impl::translateFMinMax},
	{ARM64_INS_FMAXNM, &Capstone2LlvmIrTranslatorArm64_impl::translateFMinMaxNum},
	{ARM64_INS_FMAXNMP, nullptr},
	{ARM64_INS_FMAXNMV, nullptr},
	{ARM64_INS_FMAXP, nullptr},
	{ARM64_INS_FMAXV, nullptr},
	{ARM64_INS_FMIN, &Capstone2LlvmIrTranslatorArm64_impl::translateFMinMax},
	{ARM64_INS_FMINNM, &Capstone2LlvmIrTranslatorArm64_impl::translateFMinMaxNum},
	{ARM64_INS_FMINNMP, nullptr},
	{ARM64_INS_FMINNMV, nullptr},
	{ARM64_INS_FMINP, nullptr},
	{ARM64_INS_FMINV, nullptr},
	{ARM64_INS_FMLA, nullptr},
	{ARM64_INS_FMLS, nullptr},
	{ARM64_INS_FMOV, &Capstone2LlvmIrTranslatorArm64_impl::translateFMov},
	{ARM64_INS_FMSUB, &Capstone2LlvmIrTranslatorArm64_impl::translateFMsub},
	{ARM64_INS_FMUL, &Capstone2LlvmIrTranslatorArm64_impl::translateFMul},
	{ARM64_INS_FMULX, nullptr},
	{ARM64_INS_FNEG, &Capstone2LlvmIrTranslatorArm64_impl::translateFUnaryOp},
	{ARM64_INS_FNMADD, &Capstone2LlvmIrTranslatorArm64_impl::translateFMadd},
	{ARM64_INS_FNMSUB, &Capstone2LlvmIrTranslatorArm64_impl::translateFMsub},
	{ARM64_INS_FNMUL, &Capstone2LlvmIrTranslatorArm64_impl::translateFMul},
	{ARM64_INS_FRECPE, nullptr},
	{ARM64_INS_FRECPS, nullptr},
	{ARM64_INS_FRECPX, nullptr},
	{ARM64_INS_FRINTA, nullptr},
	{ARM64_INS_FRINTI, nullptr},
	{ARM64_INS_FRINTM, nullptr},
	{ARM64_INS_FRINTN, nullptr},
	{ARM64_INS_FRINTP, nullptr},
	{ARM64_INS_FRINTX, nullptr},
	{ARM64_INS_FRINTZ, nullptr},
	{ARM64_INS_FRSQRTE, nullptr},
	{ARM64_INS_FRSQRTS, nullptr},
	{ARM64_INS_FSQRT, &Capstone2LlvmIrTranslatorArm64_impl::translateFUnaryOp},
	{ARM64_INS_FSUB, &Capstone2LlvmIrTranslatorArm64_impl::translateFSub},
	{ARM64_INS_HINT, nullptr},
	{ARM64_INS_HLT, nullptr},
	{ARM64_INS_HVC, nullptr},
	{ARM64_INS_INS, nullptr},

	{ARM64_INS_ISB, nullptr},
	{ARM64_INS_LD1, nullptr},
	{ARM64_INS_LD1R, nullptr},
	{ARM64_INS_LD2R, nullptr},
	{ARM64_INS_LD2, nullptr},
	{ARM64_INS_LD3R, nullptr},
	{ARM64_INS_LD3, nullptr},
	{ARM64_INS_LD4, nullptr},
	{ARM64_INS_LD4R, nullptr},

	{ARM64_INS_LDARB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDARH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDAR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDAXP, &Capstone2LlvmIrTranslatorArm64_impl::translateLdp},
	{ARM64_INS_LDAXRB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDAXRH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDAXR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDNP, &Capstone2LlvmIrTranslatorArm64_impl::translateLdp},
	{ARM64_INS_LDP, &Capstone2LlvmIrTranslatorArm64_impl::translateLdp},
	{ARM64_INS_LDPSW, &Capstone2LlvmIrTranslatorArm64_impl::translateLdp},
	{ARM64_INS_LDRB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDRH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDRSB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDRSH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDRSW, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDTRB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDTRH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDTRSB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},

	{ARM64_INS_LDTRSH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDTRSW, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDTR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDURB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDUR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDURH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDURSB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDURSH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDURSW, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDXP, &Capstone2LlvmIrTranslatorArm64_impl::translateLdp},
	{ARM64_INS_LDXRB, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDXRH, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LDXR, &Capstone2LlvmIrTranslatorArm64_impl::translateLdr},
	{ARM64_INS_LSL, &Capstone2LlvmIrTranslatorArm64_impl::translateShifts},
	{ARM64_INS_LSR, &Capstone2LlvmIrTranslatorArm64_impl::translateShifts},
	{ARM64_INS_MADD, &Capstone2LlvmIrTranslatorArm64_impl::translateMul},
	{ARM64_INS_MLA, nullptr},
	{ARM64_INS_MLS, nullptr},
	{ARM64_INS_MOVI, &Capstone2LlvmIrTranslatorArm64_impl::translateMovi},
	{ARM64_INS_MOVK, &Capstone2LlvmIrTranslatorArm64_impl::translateMovk},
	{ARM64_INS_MOVN, &Capstone2LlvmIrTranslatorArm64_impl::translateMov},
	{ARM64_INS_MOVZ, &Capstone2LlvmIrTranslatorArm64_impl::translateMov},
	{ARM64_INS_MRS, nullptr},
	{ARM64_INS_MSR, nullptr},
	{ARM64_INS_MSUB, &Capstone2LlvmIrTranslatorArm64_impl::translateMul},
	{ARM64_INS_MUL, &Capstone2LlvmIrTranslatorArm64_impl::translateMul},
	{ARM64_INS_MVNI, nullptr},
	{ARM64_INS_NEG, &Capstone2LlvmIrTranslatorArm64_impl::translateNeg},
	{ARM64_INS_NOT, nullptr},
	{ARM64_INS_ORN, &Capstone2LlvmIrTranslatorArm64_impl::translateOrr},
	{ARM64_INS_ORR, &Capstone2LlvmIrTranslatorArm64_impl::translateOrr},
	{ARM64_INS_PMULL2, nullptr},
	{ARM64_INS_PMULL, nullptr},
	{ARM64_INS_PMUL, nullptr},
	{ARM64_INS_PRFM, nullptr},
	{ARM64_INS_PRFUM, nullptr},
	{ARM64_INS_RADDHN, nullptr},
	{ARM64_INS_RADDHN2, nullptr},
	{ARM64_INS_RBIT, &Capstone2LlvmIrTranslatorArm64_impl::translateRev},
	{ARM64_INS_RET, &Capstone2LlvmIrTranslatorArm64_impl::translateRet},
	{ARM64_INS_REV16, nullptr},
	{ARM64_INS_REV32, nullptr},
	{ARM64_INS_REV64, nullptr},
	{ARM64_INS_REV, &Capstone2LlvmIrTranslatorArm64_impl::translateRev},
	{ARM64_INS_ROR, &Capstone2LlvmIrTranslatorArm64_impl::translateShifts},
	{ARM64_INS_RSHRN2, nullptr},
	{ARM64_INS_RSHRN, nullptr},
	{ARM64_INS_RSUBHN, nullptr},
	{ARM64_INS_RSUBHN2, nullptr},
	{ARM64_INS_SABAL2, nullptr},
	{ARM64_INS_SABAL, nullptr},

	{ARM64_INS_SABA, nullptr},
	{ARM64_INS_SABDL2, nullptr},
	{ARM64_INS_SABDL, nullptr},
	{ARM64_INS_SABD, nullptr},
	{ARM64_INS_SADALP, nullptr},
	{ARM64_INS_SADDLP, nullptr},
	{ARM64_INS_SADDLV, nullptr},
	{ARM64_INS_SADDL2, nullptr},
	{ARM64_INS_SADDL, nullptr},
	{ARM64_INS_SADDW2, nullptr},
	{ARM64_INS_SADDW, nullptr},
	{ARM64_INS_SBC, &Capstone2LlvmIrTranslatorArm64_impl::translateSbc},
	{ARM64_INS_SBFM, nullptr},
	{ARM64_INS_SCVTF, &Capstone2LlvmIrTranslatorArm64_impl::translateFCvtf},
	{ARM64_INS_SDIV, &Capstone2LlvmIrTranslatorArm64_impl::translateDiv},
	{ARM64_INS_SHA1C, nullptr},
	{ARM64_INS_SHA1H, nullptr},
	{ARM64_INS_SHA1M, nullptr},
	{ARM64_INS_SHA1P, nullptr},
	{ARM64_INS_SHA1SU0, nullptr},
	{ARM64_INS_SHA1SU1, nullptr},
	{ARM64_INS_SHA256H2, nullptr},
	{ARM64_INS_SHA256H, nullptr},
	{ARM64_INS_SHA256SU0, nullptr},
	{ARM64_INS_SHA256SU1, nullptr},
	{ARM64_INS_SHADD, nullptr},
	{ARM64_INS_SHLL2, nullptr},
	{ARM64_INS_SHLL, nullptr},
	{ARM64_INS_SHL, nullptr},
	{ARM64_INS_SHRN2, nullptr},
	{ARM64_INS_SHRN, nullptr},
	{ARM64_INS_SHSUB, nullptr},
	{ARM64_INS_SLI, nullptr},
	{ARM64_INS_SMADDL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_SMAXP, nullptr},
	{ARM64_INS_SMAXV, nullptr},
	{ARM64_INS_SMAX, nullptr},
	{ARM64_INS_SMC, nullptr},
	{ARM64_INS_SMINP, nullptr},
	{ARM64_INS_SMINV, nullptr},
	{ARM64_INS_SMIN, nullptr},
	{ARM64_INS_SMLAL2, nullptr},
	{ARM64_INS_SMLAL, nullptr},
	{ARM64_INS_SMLSL2, nullptr},
	{ARM64_INS_SMLSL, nullptr},
	{ARM64_INS_SMOV, nullptr},
	{ARM64_INS_SMSUBL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_SMULH, &Capstone2LlvmIrTranslatorArm64_impl::translateMulh},
	{ARM64_INS_SMULL2, nullptr},
	{ARM64_INS_SMULL, &Capstone2LlvmIrTranslatorArm64_impl::translateMull},
	{ARM64_INS_SQABS, nullptr},
	{ARM64_INS_SQADD, nullptr},
	{ARM64_INS_SQDMLAL, nullptr},
	{ARM64_INS_SQDMLAL2, nullptr},
	{ARM64_INS_SQDMLSL, nullptr},
	{ARM64_INS_SQDMLSL2, nullptr},
	{ARM64_INS_SQDMULH, nullptr},
	{ARM64_INS_SQDMULL, nullptr},
	{ARM64_INS_SQDMULL2, nullptr},
	{ARM64_INS_SQNEG, nullptr},
	{ARM64_INS_SQRDMULH, nullptr},
	{ARM64_INS_SQRSHL, nullptr},
	{ARM64_INS_SQRSHRN, nullptr},
	{ARM64_INS_SQRSHRN2, nullptr},
	{ARM64_INS_SQRSHRUN, nullptr},
	{ARM64_INS_SQRSHRUN2, nullptr},
	{ARM64_INS_SQSHLU, nullptr},
	{ARM64_INS_SQSHL, nullptr},
	{ARM64_INS_SQSHRN, nullptr},
	{ARM64_INS_SQSHRN2, nullptr},
	{ARM64_INS_SQSHRUN, nullptr},
	{ARM64_INS_SQSHRUN2, nullptr},
	{ARM64_INS_SQSUB, nullptr},
	{ARM64_INS_SQXTN2, nullptr},
	{ARM64_INS_SQXTN, nullptr},
	{ARM64_INS_SQXTUN2, nullptr},
	{ARM64_INS_SQXTUN, nullptr},
	{ARM64_INS_SRHADD, nullptr},
	{ARM64_INS_SRI, nullptr},
	{ARM64_INS_SRSHL, nullptr},
	{ARM64_INS_SRSHR, nullptr},
	{ARM64_INS_SRSRA, nullptr},
	{ARM64_INS_SSHLL2, nullptr},
	{ARM64_INS_SSHLL, nullptr},
	{ARM64_INS_SSHL, nullptr},
	{ARM64_INS_SSHR, nullptr},
	{ARM64_INS_SSRA, nullptr},
	{ARM64_INS_SSUBL2, nullptr},
	{ARM64_INS_SSUBL, nullptr},
	{ARM64_INS_SSUBW2, nullptr},
	{ARM64_INS_SSUBW, nullptr},
	{ARM64_INS_ST1, nullptr},
	{ARM64_INS_ST2, nullptr},
	{ARM64_INS_ST3, nullptr},
	{ARM64_INS_ST4, nullptr},
	{ARM64_INS_STLRB, nullptr},
	{ARM64_INS_STLRH, nullptr},
	{ARM64_INS_STLR, nullptr},
	{ARM64_INS_STLXP, nullptr},
	{ARM64_INS_STLXRB, nullptr},
	{ARM64_INS_STLXRH, nullptr},
	{ARM64_INS_STLXR, nullptr},
	{ARM64_INS_STNP, &Capstone2LlvmIrTranslatorArm64_impl::translateStp},
	{ARM64_INS_STP, &Capstone2LlvmIrTranslatorArm64_impl::translateStp},
	{ARM64_INS_STRB, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STR, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STRH, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STTRB, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STTRH, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STTR, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STURB, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STUR, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STURH, &Capstone2LlvmIrTranslatorArm64_impl::translateStr},
	{ARM64_INS_STXP, nullptr},
	{ARM64_INS_STXRB, nullptr},
	{ARM64_INS_STXRH, nullptr},
	{ARM64_INS_STXR, nullptr},
	{ARM64_INS_SUBHN, nullptr},
	{ARM64_INS_SUBHN2, nullptr},
	{ARM64_INS_SUB, &Capstone2LlvmIrTranslatorArm64_impl::translateSub},
	{ARM64_INS_SUQADD, nullptr},
	{ARM64_INS_SVC, nullptr},
	{ARM64_INS_SYSL, nullptr},
	{ARM64_INS_SYS, nullptr},
	{ARM64_INS_TBL, nullptr},
	{ARM64_INS_TBNZ, &Capstone2LlvmIrTranslatorArm64_impl::translateTbnz},
	{ARM64_INS_TBX, nullptr},
	{ARM64_INS_TBZ, &Capstone2LlvmIrTranslatorArm64_impl::translateTbnz},
	{ARM64_INS_TRN1, nullptr},
	{ARM64_INS_TRN2, nullptr},
	{ARM64_INS_UABAL2, nullptr},
	{ARM64_INS_UABAL, nullptr},
	{ARM64_INS_UABA, nullptr},
	{ARM64_INS_UABDL2, nullptr},
	{ARM64_INS_UABDL, nullptr},
	{ARM64_INS_UABD, nullptr},
	{ARM64_INS_UADALP, nullptr},
	{ARM64_INS_UADDLP, nullptr},
	{ARM64_INS_UADDLV, nullptr},
	{ARM64_INS_UADDL2, nullptr},
	{ARM64_INS_UADDL, nullptr},
	{ARM64_INS_UADDW2, nullptr},
	{ARM64_INS_UADDW, nullptr},
	{ARM64_INS_UBFM, nullptr},
	{ARM64_INS_UCVTF, &Capstone2LlvmIrTranslatorArm64_impl::translateFCvtf},
	{ARM64_INS_UDIV, &Capstone2LlvmIrTranslatorArm64_impl::translateDiv},
	{ARM64_INS_UHADD, nullptr},
	{ARM64_INS_UHSUB, nullptr},
	{ARM64_INS_UMADDL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_UMAXP, nullptr},
	{ARM64_INS_UMAXV, nullptr},
	{ARM64_INS_UMAX, nullptr},
	{ARM64_INS_UMINP, nullptr},
	{ARM64_INS_UMINV, nullptr},
	{ARM64_INS_UMIN, nullptr},
	{ARM64_INS_UMLAL2, nullptr},
	{ARM64_INS_UMLAL, nullptr},
	{ARM64_INS_UMLSL2, nullptr},
	{ARM64_INS_UMLSL, nullptr},
	{ARM64_INS_UMOV, nullptr},
	{ARM64_INS_UMSUBL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_UMULH, &Capstone2LlvmIrTranslatorArm64_impl::translateMulh},
	{ARM64_INS_UMULL2, nullptr},
	{ARM64_INS_UMULL, &Capstone2LlvmIrTranslatorArm64_impl::translateMull},
	{ARM64_INS_UQADD, nullptr},
	{ARM64_INS_UQRSHL, nullptr},
	{ARM64_INS_UQRSHRN, nullptr},
	{ARM64_INS_UQRSHRN2, nullptr},
	{ARM64_INS_UQSHL, nullptr},
	{ARM64_INS_UQSHRN, nullptr},
	{ARM64_INS_UQSHRN2, nullptr},
	{ARM64_INS_UQSUB, nullptr},
	{ARM64_INS_UQXTN2, nullptr},
	{ARM64_INS_UQXTN, nullptr},
	{ARM64_INS_URECPE, nullptr},
	{ARM64_INS_URHADD, nullptr},
	{ARM64_INS_URSHL, nullptr},
	{ARM64_INS_URSHR, nullptr},
	{ARM64_INS_URSQRTE, nullptr},
	{ARM64_INS_URSRA, nullptr},
	{ARM64_INS_USHLL2, nullptr},
	{ARM64_INS_USHLL, nullptr},
	{ARM64_INS_USHL, nullptr},
	{ARM64_INS_USHR, nullptr},
	{ARM64_INS_USQADD, nullptr},
	{ARM64_INS_USRA, nullptr},
	{ARM64_INS_USUBL2, nullptr},
	{ARM64_INS_USUBL, nullptr},
	{ARM64_INS_USUBW2, nullptr},
	{ARM64_INS_USUBW, nullptr},
	{ARM64_INS_UZP1, nullptr},
	{ARM64_INS_UZP2, nullptr},
	{ARM64_INS_XTN2, nullptr},
	{ARM64_INS_XTN, nullptr},
	{ARM64_INS_ZIP1, nullptr},
	{ARM64_INS_ZIP2, nullptr},

	// alias insn
	{ARM64_INS_MNEG, &Capstone2LlvmIrTranslatorArm64_impl::translateMul},
	{ARM64_INS_UMNEGL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_SMNEGL, &Capstone2LlvmIrTranslatorArm64_impl::translateMulOpl},
	{ARM64_INS_NOP, &Capstone2LlvmIrTranslatorArm64_impl::translateNop},
	{ARM64_INS_YIELD, nullptr},
	{ARM64_INS_WFE, nullptr},
	{ARM64_INS_WFI, nullptr},
	{ARM64_INS_SEV, nullptr},
	{ARM64_INS_SEVL, nullptr},
	{ARM64_INS_NGC, &Capstone2LlvmIrTranslatorArm64_impl::translateNgc},
	{ARM64_INS_SBFIZ, nullptr},
	{ARM64_INS_UBFIZ, nullptr},
	{ARM64_INS_SBFX, nullptr},
	{ARM64_INS_UBFX, nullptr},
	{ARM64_INS_BFI, nullptr},
	{ARM64_INS_BFXIL, nullptr},
	{ARM64_INS_CMN, &Capstone2LlvmIrTranslatorArm64_impl::translateAdd},
	{ARM64_INS_MVN, &Capstone2LlvmIrTranslatorArm64_impl::translateMov},
	{ARM64_INS_TST, &Capstone2LlvmIrTranslatorArm64_impl::translateAnd},
	{ARM64_INS_CSET, &Capstone2LlvmIrTranslatorArm64_impl::translateCset},
	{ARM64_INS_CINC, &Capstone2LlvmIrTranslatorArm64_impl::translateCondOp},
	{ARM64_INS_CSETM, &Capstone2LlvmIrTranslatorArm64_impl::translateCset},
	{ARM64_INS_CINV, &Capstone2LlvmIrTranslatorArm64_impl::translateCondOp},
	{ARM64_INS_CNEG, &Capstone2LlvmIrTranslatorArm64_impl::translateCondOp},
	{ARM64_INS_SXTB, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_SXTH, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_SXTW, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_CMP, &Capstone2LlvmIrTranslatorArm64_impl::translateSub},
	{ARM64_INS_UXTB, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_UXTH, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_UXTW, &Capstone2LlvmIrTranslatorArm64_impl::translateExtensions},
	{ARM64_INS_IC, nullptr},
	{ARM64_INS_DC, nullptr},
	{ARM64_INS_AT, nullptr},
	{ARM64_INS_TLBI, nullptr},

	{ARM64_INS_NEGS, &Capstone2LlvmIrTranslatorArm64_impl::translateNeg},
	{ARM64_INS_NGCS, &Capstone2LlvmIrTranslatorArm64_impl::translateNgc},

	{ARM64_INS_ENDING, nullptr}
};

} // namespace capstone2llvmir
} // namespace retdec
