# -*- coding: utf-8 -*-

"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'
# This will get replaced with a git SHA1 when you do a git archive
__revision__ = '383851c5975cb70ab0af528e768b0f13b62e43dd'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'
# This will get replaced with a git SHA1 when you do a git archive
__revision__ = '383851c5975cb70ab0af528e768b0f13b62e43dd'

ACCEPTABLE_MISSING_DOCS = {
    "CharacterWidget": ['updateFontMerging(bool enable)'],
    "CloughTocherInterpolator": ['setTriangulation(NormVecDecorator *tin)'],
    "DualEdgeTriangulation": ['DualEdgeTriangulation(int nop, Triangulation *decorator)', 'setDecorator(Triangulation *d)'],
    "HalfEdge": ['HalfEdge(int dual, int next, int point, bool mbreak, bool forced)'],
    "NormVecDecorator": ['NormVecDecorator(Triangulation *tin)'],
    "ParametricLine": ['add(ParametricLine *pl)=0', 'calcFirstDer(float t, Vector3D *v)=0', 'calcPoint(float t, QgsPoint *p)=0', 'calcSecDer(float t, Vector3D *v)=0', 'changeDirection()=0', 'getControlPoint(int number) const =0', 'getControlPoly() const =0', 'getDegree() const =0', 'getParent() const =0', 'remove(int i)=0', 'setControlPoly(QVector< QgsPoint *> *cp)=0', 'setParent(ParametricLine *paral)=0'],
    "QgisInterface": ['actionAbout()=0', 'actionAddAllToOverview()=0', 'actionAddFeature()=0', 'actionAddOgrLayer()=0', 'actionAddPart()=0', 'actionAddPgLayer()=0', 'actionAddRasterLayer()=0', 'actionAddRing()=0', 'actionAddToOverview()=0', 'actionAddWmsLayer()=0', 'actionAllEdits()=0', 'actionCancelAllEdits()=0', 'actionCancelEdits()=0', 'actionCheckQgisVersion()=0', 'actionCopyFeatures()=0', 'actionCopyLayerStyle()=0', 'actionCustomProjection()=0', 'actionCutFeatures()=0', 'actionDeletePart()=0', 'actionDeleteRing()=0', 'actionDeleteSelected()=0', 'actionDuplicateLayer()=0', 'actionExit()=0', 'actionHelpContents()=0', 'actionHideAllLayers()=0', 'actionHideSelectedLayers()=0', 'actionLayerProperties()=0', 'actionLayerSaveAs()=0', 'actionManagePlugins()=0', 'actionMoveFeature()=0', 'actionNewProject()=0', 'actionNewVectorLayer()=0', 'actionOpenFieldCalculator()=0', 'actionOpenProject()=0', 'actionOpenTable()=0', 'actionOptions()=0', 'actionPasteFeatures()=0', 'actionPasteLayerStyle()=0', 'actionPluginListSeparator()=0', 'actionProjectProperties()=0', 'actionQgisHomePage()=0', 'actionRemoveAllFromOverview()=0', 'actionRollbackAllEdits()=0', 'actionRollbackEdits()=0', 'actionSaveActiveLayerEdits()=0', 'actionSaveAllEdits()=0', 'actionSaveEdits()=0', 'actionSaveMapAsImage()=0', 'actionSaveProject()=0', 'actionSaveProjectAs()=0', 'actionShowAllLayers()=0', 'actionShowPythonDialog()=0', 'actionShowSelectedLayers()=0', 'actionSimplifyFeature()=0', 'actionSplitFeatures()=0', 'actionSplitParts()=0', 'actionToggleEditing()=0', 'actionToggleFullScreen()=0', 'actionVertexTool()=0', 'advancedDigitizeToolBar()=0', 'attributesToolBar()=0', 'databaseMenu()=0', 'databaseToolBar()=0', 'digitizeToolBar()=0', 'editMenu()=0', 'fileToolBar()=0', 'firstRightStandardMenu()=0', 'helpMenu()=0', 'helpToolBar()=0', 'layerMenu()=0', 'layerToolBar()=0', 'layerTreeView()=0', 'mapNavToolToolBar()=0', 'newLayerMenu()=0', 'pluginManagerInterface()=0', 'pluginMenu()=0', 'pluginToolBar()=0', 'rasterMenu()=0', 'rasterToolBar()=0', 'settingsMenu()=0', 'shapeDigitizeToolBar()=0', 'vectorMenu()=0', 'vectorToolBar()=0', 'viewMenu()=0', 'webMenu()=0', 'webToolBar()=0', 'windowMenu()=0'],
    "QgisPlugin": ['name()'],
    "QgisVisitor": ['QgisVisitor(QList< QgsFeatureId > &list)'],
    "QgsAbstractFeatureIteratorFromSource": ['QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)'],
    "QgsAbstractFeatureSource": ['iteratorClosed(QgsAbstractFeatureIterator *it)', 'iteratorOpened(QgsAbstractFeatureIterator *it)'],
    "QgsAbstractGeometry": ['QgsAbstractGeometry(const QgsAbstractGeometry &geom)'],
    "QgsAbstractLabelProvider": ['Flag'],
    "QgsAction": ['ActionType'],
    "QgsActionMenu": ['ActionType', 'reinit()'],
    "QgsAdvancedDigitizingCanvasItem": ['QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)'],
    "QgsAlignRaster": ['gridOffset() const', 'setGridOffset(QPointF offset)'],
    "QgsApplication": ['QgsApplication(int &argc, char **argv, bool GUIenabled, const QString &profileFolder=QString(), const QString &platformName="desktop")'],
    "QgsAspectFilter": ['QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)'],
    "QgsAttributeDialog": ['attributeForm()', 'feature()'],
    "QgsAttributeEditorContext": ['FormMode', 'QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)', 'QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)', 'parentContext() const'],
    "QgsAttributeEditorElement": ['AttributeEditorType'],
    "QgsAttributeForm": ['QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)', 'feature()'],
    "QgsAttributeFormInterface": ['QgsAttributeFormInterface(QgsAttributeForm *form)', 'acceptChanges(const QgsFeature &feature)', 'feature()', 'featureChanged()', 'form()', 'initForm()'],
    "QgsAttributeFormLegacyInterface": ['QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)'],
    "QgsAttributeTableAction": ['execute()', 'featureForm()'],
    "QgsAttributeTableDelegate": ['setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)'],
    "QgsAttributeTableFilterModel": ['fidToIndexList(QgsFeatureId fid)', 'mapFromMaster(const QModelIndex &sourceIndex) const', 'mapToMaster(const QModelIndex &proxyIndex) const'],
    "QgsAttributeTableMapLayerAction": ['QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)', 'execute()'],
    "QgsAttributeTableModel": ['Role', 'finished()', 'idToIndex(QgsFeatureId id) const', 'idToIndexList(QgsFeatureId id) const'],
    "QgsAttributeTableView": ['_q_selectRow(int row)', 'finished()', 'repaintRequested()', 'repaintRequested(const QModelIndexList &indexes)', 'selectRow(int row)', 'setModel(QgsAttributeTableFilterModel *filterModel)'],
    "QgsAttributeTypeLoadDialog": ['QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)'],
    "QgsAuthCertInfo": ['trustCacheRebuilt()'],
    "QgsAuthMethodConfig": ['setMethod(const QString &method)', 'setUri(const QString &uri)'],
    "QgsBlurWidget": ['QgsBlurWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsBrightnessContrastFilter": ['QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)', 'brightness() const', 'contrast() const', 'setBrightness(int brightness)', 'setContrast(int contrast)'],
    "QgsBrowserModel": ['ItemDataRole', 'QgsBrowserModel(QObject *parent=nullptr)', 'beginInsertItems(QgsDataItem *parent, int first, int last)', 'beginRemoveItems(QgsDataItem *parent, int first, int last)', 'connectItem(QgsDataItem *item)', 'dataItem(const QModelIndex &idx) const', 'endInsertItems()', 'endRemoveItems()', 'findItem(QgsDataItem *item, QgsDataItem *parent=nullptr) const', 'itemDataChanged(QgsDataItem *item)', 'itemStateChanged(QgsDataItem *item, QgsDataItem::State oldState)', 'removeRootItems()', 'updateProjectHome()'],
    "QgsBrowserTreeView": ['hasExpandedDescendant(const QModelIndex &index) const', 'setSettingsSection(const QString &section)'],
    "QgsBrowserWatcher": ['QgsBrowserWatcher(QgsDataItem *item)', 'finished(QgsDataItem *item, const QVector< QgsDataItem *> &items)', 'item() const'],
    "QgsBrushStyleComboBox": ['QgsBrushStyleComboBox(QWidget *parent=nullptr)', 'brushStyle() const', 'iconForBrush(Qt::BrushStyle style)', 'setBrushStyle(Qt::BrushStyle style)'],
    "QgsBusyIndicatorDialog": ['message() const', 'setMessage(const QString &message)'],
    "QgsCacheIndexFeatureId": ['QgsCacheIndexFeatureId(QgsVectorLayerCache *)'],
    "QgsCategorizedSymbolRenderer": ['QgsCategorizedSymbolRenderer(const QString &attrName=QString(), const QgsCategoryList &categories=QgsCategoryList())', 'addCategory(const QgsRendererCategory &category)', 'categories() const', 'classAttribute() const', 'deleteAllCategories()', 'deleteCategory(int catIndex)', 'rebuildHash()', 'setClassAttribute(const QString &attr)', 'sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)', 'sortByValue(Qt::SortOrder order=Qt::AscendingOrder)', 'updateCategoryLabel(int catIndex, const QString &label)', 'updateCategorySymbol(int catIndex, QgsSymbol *symbol)', 'updateCategoryValue(int catIndex, const QVariant &value)'],
    "QgsCategorizedSymbolRendererWidget": ['QgsCategorizedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'addCategories()', 'addCategory()', 'categoriesDoubleClicked(const QModelIndex &idx)', 'categoryColumnChanged(const QString &field)', 'changeCategorizedSymbol()', 'changeCategorySymbol()', 'create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'deleteAllCategories()', 'deleteCategories()', 'populateCategories()', 'rowsMoved()', 'selectedCategoryList()', 'showSymbolLevels()', 'updateCategorizedSymbolIcon()', 'updateUiFromRenderer()'],
    "QgsCentroidFillSymbolLayer": ['create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'pointOnSurface() const', 'setPointOnSurface(bool pointOnSurface)'],
    "QgsCharacterSelectorDialog": ['QgsCharacterSelectorDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)', 'selectCharacter(bool *gotChar, const QFont &font, const QString &style)'],
    "QgsCheckBoxConfigDlg": ['QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)'],
    "QgsCheckboxWidgetFactory": ['QgsCheckboxWidgetFactory(const QString &name)'],
    "QgsCheckboxWidgetWrapper": ['QgsCheckboxWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsClassificationWidgetWrapper": ['QgsClassificationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsClassificationWidgetWrapperFactory": ['QgsClassificationWidgetWrapperFactory(const QString &name)'],
    "QgsClipToMinMaxEnhancement": ['QgsClipToMinMaxEnhancement(Qgis::DataType, double, double)'],
    "QgsClipper": ['trimPolygon(QPolygonF &pts, const QgsRectangle &clipRect)'],
    "QgsCodeEditor": ['foldingVisible()', 'getMonospaceFont()', 'isFixedPitch(const QFont &font)', 'marginVisible()'],
    "QgsCollapsibleGroupBox": ['QgsCollapsibleGroupBox(QWidget *parent=nullptr, QgsSettings *settings=nullptr)', 'QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QgsSettings *settings=nullptr)', 'init()', 'saveCheckedState()', 'saveCollapsedState()', 'saveKey() const', 'setSettings(QgsSettings *settings)'],
    "QgsCollapsibleGroupBoxBasic": ['QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)', 'QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)', 'checkClicked(bool ckd)', 'checkToggled(bool ckd)', 'clearModifiers()', 'init()', 'titleRect() const', 'toggleCollapsed()', 'updateStyle()'],
    "QgsColorBrewerPalette": ['listSchemeColors(const QString &schemeName, int colors)', 'listSchemeVariants(const QString &schemeName)', 'listSchemes()'],
    "QgsColorEffectWidget": ['QgsColorEffectWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsColorSwatchDelegate": ['QgsColorSwatchDelegate(QWidget *parent=nullptr)'],
    "QgsColorWidgetFactory": ['QgsColorWidgetFactory(const QString &name)'],
    "QgsColorWidgetWrapper": ['QgsColorWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsCompoundCurve": ['QgsCompoundCurve(const QgsCompoundCurve &curve)'],
    "QgsConditionalLayerStyles": ['rowStyles()'],
    "QgsConditionalStyle": ['QgsConditionalStyle(const QString &rule)', 'QgsConditionalStyle(const QgsConditionalStyle &other)'],
    "QgsConnectionPoolGroup": ['QgsConnectionPoolGroup(const QString &ci)', 'initTimer(QObject *parent)', 'invalidateConnections()', 'onConnectionExpired()', 'release(T conn)'],
    "QgsConstWkbPtr": ['QgsConstWkbPtr(const unsigned char *p, int size)', 'operator const unsigned char *() const', 'operator+=(int n)', 'operator-=(int n)', 'operator>>(char &v) const', 'operator>>(double &v) const', 'operator>>(float &r) const', 'operator>>(int &v) const', 'operator>>(unsigned int &v) const'],
    "QgsContrastEnhancement": ['QgsContrastEnhancement(Qgis::DataType datatype=Qgis::Byte)', 'QgsContrastEnhancement(const QgsContrastEnhancement &ce)', 'contrastEnhancementAlgorithm() const', 'readXml(const QDomElement &elem)', 'writeXml(QDomDocument &doc, QDomElement &parentElem) const'],
    "QgsContrastEnhancementFunction": ['QgsContrastEnhancementFunction(Qgis::DataType, double, double)', 'QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)'],
    "QgsCptCityAllRampsItem": ['QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem *> &items)'],
    "QgsCptCityArchive": ['QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())', 'archiveName() const', 'archiveRegistry()', 'baseDir() const', 'baseDir(QString archiveName)', 'clearArchives()', 'copyingFileName(const QString &dirName) const', 'copyingInfo(const QString &fileName)', 'defaultArchive()', 'defaultBaseDir()', 'descFileName(const QString &dirName) const', 'description(const QString &fileName)', 'findFileName(const QString &target, const QString &startDir, const QString &baseDir)', 'initArchive(const QString &archiveName, const QString &archiveBaseDir)', 'initArchives(bool loadAll=false)', 'initDefaultArchive()', 'isEmpty()', 'rootItems() const', 'selectionItems() const', 'setBaseDir(const QString &dirName)'],
    "QgsCptCityBrowserModel": ['QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)', 'ViewType', 'addRootItems()', 'beginInsertItems(QgsCptCityDataItem *parent, int first, int last)', 'beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)', 'connectItem(QgsCptCityDataItem *item)', 'endInsertItems()', 'endRemoveItems()', 'findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const', 'refresh(const QModelIndex &index=QModelIndex())', 'refresh(const QString &path)', 'reload()', 'removeRootItems()'],
    "QgsCptCityCollectionItem": ['QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)', 'addChild(QgsCptCityDataItem *item)', 'childrenRamps(bool recursive)', 'setPopulated()'],
    "QgsCptCityColorRamp": ['cloneGradientRamp() const', 'copy(const QgsCptCityColorRamp *other)', 'copyingFileName() const', 'copyingInfo() const', 'create(const QgsStringMap &properties=QgsStringMap())', 'descFileName() const', 'fileLoaded() const', 'fileName() const', 'hasMultiStops() const', 'loadFile()', 'loadPalette()', 'schemeName() const', 'setName(const QString &schemeName, const QString &variantName=QString(), const QStringList &variantList=QStringList())', 'setSchemeName(const QString &schemeName)', 'setVariantList(const QStringList &variantList)', 'setVariantName(const QString &variantName)', 'variantList() const', 'variantName() const'],
    "QgsCptCityColorRampItem": ['QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)', 'QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)', 'init()', 'ramp() const'],
    "QgsCptCityDataItem": ['QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)', 'Type', 'acceptDrop()', 'actions()', 'addChildItem(QgsCptCityDataItem *child, bool refresh=false)', 'beginInsertItems(QgsCptCityDataItem *parent, int first, int last)', 'beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)', 'children() const', 'createChildren()', 'deleteChildItem(QgsCptCityDataItem *child)', 'endInsertItems()', 'endRemoveItems()', 'equal(const QgsCptCityDataItem *other)', 'findItem(QVector< QgsCptCityDataItem *> items, QgsCptCityDataItem *item)', 'handleDrop(const QMimeData *, Qt::DropAction)', 'hasChildren()', 'icon()', 'icon(QSize size)', 'info() const', 'isPopulated()', 'isValid()', 'leafCount() const', 'name() const', 'paramWidget()', 'parent() const', 'path() const', 'populate()', 'refresh()', 'removeChildItem(QgsCptCityDataItem *child)', 'rowCount()', 'setIcon(const QIcon &icon)', 'setParent(QgsCptCityDataItem *parent)', 'setToolTip(const QString &msg)', 'shortInfo() const', 'toolTip() const', 'type() const'],
    "QgsCptCityDirectoryItem": ['QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)', 'dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)', 'dirEntries() const', 'rampsMap()'],
    "QgsCptCitySelectionItem": ['QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)', 'parseXml()', 'selectionsList() const'],
    "QgsCredentials": ['get(const QString &realm, QString &username, QString &password, const QString &message=QString())', 'getMasterPassword(QString &password, bool stored=false)', 'put(const QString &realm, const QString &username, const QString &password)'],
    "QgsCurvePolygon": ['QgsCurvePolygon(const QgsCurvePolygon &p)', 'exteriorRing() const', 'interiorRing(int i) const', 'numInteriorRings() const'],
    "QgsDartMeasurement": ['QgsDartMeasurement(const QString &name, Type type, const QString &value)', 'Type', 'send() const', 'toString() const'],
    "QgsDashSpaceDialog": ['dashDotVector() const'],
    "QgsDataCollectionItem": ['QgsDataCollectionItem(QgsDataItem *parent, const QString &name, const QString &path=QString())', 'addChild(QgsDataItem *item)', 'iconDataCollection()', 'iconDir()'],
    "QgsDataDefinedRotationDialog": ['QgsDataDefinedRotationDialog(const QList< QgsSymbol *> &symbolList, QgsVectorLayer *layer)'],
    "QgsDataDefinedSizeDialog": ['QgsDataDefinedSizeDialog(const QList< QgsSymbol *> &symbolList, QgsVectorLayer *layer)'],
    "QgsDataDefinedValueDialog": ['dataDefinedChanged()'],
    "QgsDataDefinedWidthDialog": ['QgsDataDefinedWidthDialog(const QList< QgsSymbol *> &symbolList, QgsVectorLayer *layer)'],
    "QgsDataItem": ['Capability', 'State', 'Type', 'beginInsertItems(QgsDataItem *parent, int first, int last)', 'beginRemoveItems(QgsDataItem *parent, int first, int last)', 'capabilities2() const', 'children() const', 'childrenCreated()', 'dataChanged(QgsDataItem *item)', 'deleteLater(QVector< QgsDataItem *> &items)', 'endInsertItems()', 'endRemoveItems()', 'findItem(QVector< QgsDataItem *> items, QgsDataItem *item)', 'hasChildren()', 'icon()', 'paramWidget()', 'path() const', 'populate(bool foreground=false)', 'populate(const QVector< QgsDataItem *> &children)', 'refresh()', 'rowCount()', 'setIcon(const QIcon &icon)', 'setIconName(const QString &iconName)', 'setPath(const QString &path)', 'setToolTip(const QString &msg)', 'stateChanged(QgsDataItem *item, QgsDataItem::State oldState)', 'toolTip() const', 'type() const'],
    "QgsDataProvider": ['DataCapability'],
    "QgsDataSourceUri": ['SslMode'],
    "QgsDateTimeEdit": ['allowNull() const'],
    "QgsDateTimeEditConfig": ['QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)'],
    "QgsDateTimeEditFactory": ['QgsDateTimeEditFactory(const QString &name)'],
    "QgsDateTimeEditWrapper": ['QgsDateTimeEditWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QWidget *parent=nullptr)'],
    "QgsDefaultRasterLayerLegend": ['QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)'],
    "QgsDefaultVectorLayerLegend": ['QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)'],
    "QgsDerivativeFilter": ['QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)'],
    "QgsDetailedItemData": ['category() const', 'detail() const', 'icon() const', 'isCheckable() const', 'isChecked() const', 'isEnabled() const', 'isRenderedAsWidget() const', 'setCategory(const QString &category)', 'setCheckable(const bool flag)', 'setChecked(const bool flag)', 'setDetail(const QString &detail)', 'setEnabled(bool flag)', 'setIcon(const QPixmap &icon)', 'setTitle(const QString &title)', 'title() const'],
    "QgsDetailedItemDelegate": ['horizontalSpacing() const', 'setHorizontalSpacing(int value)', 'setVerticalSpacing(int value)', 'verticalSpacing() const'],
    "QgsDetailedItemWidget": ['setChecked(bool flag)', 'setData(const QgsDetailedItemData &data)'],
    "QgsDiagram": ['QgsDiagram(const QgsDiagram &other)', 'clearCache()'],
    "QgsDiagramLayerSettings": ['Placement'],
    "QgsDiagramRenderer": ['QgsDiagramRenderer(const QgsDiagramRenderer &other)', 'diagram() const', 'rendererName() const =0', 'setDiagram(QgsDiagram *d)'],
    "QgsDiagramSettings": ['LabelPlacementMethod'],
    "QgsDial": ['setMaximum(const QVariant &max)', 'setMinimum(const QVariant &min)', 'setSingleStep(const QVariant &step)', 'setValue(const QVariant &value)', 'valueChanged(const QVariant &)', 'variantValue() const'],
    "QgsDirectoryItem": ['Column', 'QgsDirectoryItem(QgsDataItem *parent, const QString &name, const QString &path)', 'dirPath() const', 'directoryChanged()', 'init()'],
    "QgsDirectoryParamWidget": ['QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)', 'showHideColumn()'],
    "QgsDrawSourceWidget": ['QgsDrawSourceWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsDualView": ['openConditionalStyles()'],
    "QgsDummyConfigDlg": ['QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)'],
    "QgsDxfExport": ['QgsDxfExport(const QgsDxfExport &dxfExport)', 'SymbologyExport'],
    "QgsDxfPaintDevice": ['QgsDxfPaintDevice(QgsDxfExport *dxf)', 'setDrawingSize(QSizeF size)', 'setLayer(const QString &layer)', 'setOutputSize(const QRectF &r)', 'setShift(QPointF shift)'],
    "QgsDxfPaintEngine": ['QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)', 'layer() const', 'setLayer(const QString &layer)', 'setShift(QPointF shift)'],
    "QgsEditorWidgetRegistry": ['createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QVariantMap &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())'],
    "QgsEffectDrawModeComboBox": ['QgsEffectDrawModeComboBox(QWidget *parent SIP_TRANSFERTHIS=nullptr)'],
    "QgsEffectStack": ['QgsEffectStack(const QgsEffectStack &other)'],
    "QgsEllipseSymbolLayer": ['create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'setStrokeStyle(Qt::PenStyle strokeStyle)', 'setStrokeWidth(double w)', 'setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)', 'setSymbolHeight(double h)', 'setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)', 'setSymbolName(const QString &name)', 'setSymbolWidth(double w)', 'setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)', 'strokeStyle() const', 'strokeWidth() const', 'strokeWidthMapUnitScale() const', 'symbolHeight() const', 'symbolHeightMapUnitScale() const', 'symbolName() const', 'symbolWidth() const', 'symbolWidthMapUnitScale() const'],
    "QgsEncodingFileDialog": ['pbnCancelAll_clicked()', 'saveUsedEncoding()'],
    "QgsEnumerationWidgetFactory": ['QgsEnumerationWidgetFactory(const QString &name)'],
    "QgsEnumerationWidgetWrapper": ['QgsEnumerationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsErrorItem": ['QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)'],
    "QgsErrorMessage": ['file() const', 'function() const', 'line() const', 'message() const', 'tag() const'],
    "QgsExpression": ['BuiltinFunctions()', 'Functions()', 'SpatialOperator'],
    "QgsExpressionBuilderDialog": ['QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &key="generic", const QgsExpressionContext &context=QgsExpressionContext())', 'expressionText()', 'setExpressionText(const QString &text)'],
    "QgsExpressionBuilderWidget": ['isExpressionValid()', 'loadFieldNames(const QgsFields &fields)'],
    "QgsExpressionFieldBuffer": ['expressions() const'],
    "QgsExpressionHighlighter": ['QgsExpressionHighlighter(QTextDocument *parent=nullptr)', 'addFields(const QStringList &fieldList)'],
    "QgsExpressionItem": ['ItemType', 'QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)', 'QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)', 'getExpressionText() const'],
    "QgsExternalResourceWidget": ['DocumentViewerContent', 'setDocumentPath(const QVariant &documentPath)'],
    "QgsExternalResourceWidgetFactory": ['QgsExternalResourceWidgetFactory(const QString &name)'],
    "QgsExternalResourceWidgetWrapper": ['QgsExternalResourceWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsFeatureIterator": ['close()', 'nextFeature(QgsFeature &f)', 'rewind()'],
    "QgsFeatureIteratorDataStream": ['readNextEntry()'],
    "QgsFeatureListModel": ['Role', 'displayExpression() const', 'featureByIndex(const QModelIndex &index, QgsFeature &feat)', 'fidToIdx(const QgsFeatureId fid) const', 'fidToIndexList(QgsFeatureId fid)', 'idxToFid(const QModelIndex &index) const', 'layerCache()', 'mapFromMaster(const QModelIndex &sourceIndex) const', 'mapSelectionFromMaster(const QItemSelection &selection) const', 'mapSelectionToMaster(const QItemSelection &selection) const', 'mapToMaster(const QModelIndex &proxyIndex) const', 'masterModel()', 'setSourceModel(QgsAttributeTableFilterModel *sourceModel)'],
    "QgsFeatureListView": ['repaintRequested()', 'repaintRequested(const QModelIndexList &indexes)'],
    "QgsFeatureListViewDelegate": ['Element', 'QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)', 'editButtonClicked(QModelIndex &index)', 'positionToElement(QPoint pos)', 'setCurrentFeatureEdited(bool state)', 'setEditSelectionModel(QItemSelectionModel *editSelectionModel)', 'setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)'],
    "QgsFeatureModel": ['fidToIndex(QgsFeatureId fid)=0'],
    "QgsFeatureRenderer": ['QgsFeatureRenderer(const QString &type)', 'setUsingSymbolLevels(bool usingSymbolLevels)', 'type() const', 'usingSymbolLevels() const'],
    "QgsFeatureRequest": ['Flag', 'flags() const'],
    "QgsFeatureSelectionModel": ['QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)', 'setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)'],
    "QgsFieldComboBox": ['indexChanged(int i)'],
    "QgsFieldExpressionWidget": ['currentFieldChanged()', 'isExpressionValid(const QString &expressionStr)', 'setLeftHandButtonStyle(bool isLeft)'],
    "QgsFieldValidator": ['QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat="yyyy-MM-dd")', 'dateFormat() const'],
    "QgsFields": ['FieldOrigin'],
    "QgsFillSymbol": ['QgsFillSymbol(const QgsSymbolLayerList &layers=QgsSymbolLayerList())', 'renderPolygon(const QPolygonF &points, QList< QPolygonF > *rings, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)', 'setAngle(double angle)'],
    "QgsFillSymbolLayer": ['QgsFillSymbolLayer(bool locked=false)', 'angle() const', 'renderPolygon(const QPolygonF &points, QList< QPolygonF > *rings, QgsSymbolRenderContext &context)=0', 'setAngle(double angle)'],
    "QgsFontMarkerSymbolLayer": ['QgsFontMarkerSymbolLayer(const QString &fontFamily=DEFAULT_FONTMARKER_FONT, QChar chr=DEFAULT_FONTMARKER_CHR, double pointSize=DEFAULT_FONTMARKER_SIZE, const QColor &color=DEFAULT_FONTMARKER_COLOR, double angle=DEFAULT_FONTMARKER_ANGLE)', 'character() const', 'create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'fontFamily() const', 'setCharacter(QChar ch)', 'setFontFamily(const QString &family)'],
    "QgsFontMarkerSymbolLayerWidget": ['setAngle(double angle)', 'setCharacter(QChar chr)', 'setColor(const QColor &color)', 'setFontFamily(const QFont &font)', 'setSize(double size)'],
    "QgsGenericFeatureSelectionManager": ['QgsGenericFeatureSelectionManager(QObject *parent=nullptr)', 'QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)'],
    "QgsGeometry::Error": ['Error(const QString &m)', 'Error(const QString &m, const QgsPointXY &p)', 'hasWhere()', 'what()', 'where()'],
    "QgsGeometryCollection": ['QgsGeometryCollection(const QgsGeometryCollection &c)'],
    "QgsGeometryEngine": ['QgsGeometryEngine(const QgsAbstractGeometry *geometry)', 'area(QString *errorMsg=nullptr) const =0', 'buffer(double distance, int segments, QString *errorMsg=nullptr) const =0', 'buffer(double distance, int segments, int endCapStyle, int joinStyle, double miterLimit, QString *errorMsg=nullptr) const =0', 'envelope(QString *errorMsg=nullptr) const =0', 'interpolate(double distance, QString *errorMsg=nullptr) const =0', 'isEmpty(QString *errorMsg) const =0', 'isValid(QString *errorMsg=nullptr) const =0', 'length(QString *errorMsg=nullptr) const =0', 'offsetCurve(double distance, int segments, int joinStyle, double miterLimit, QString *errorMsg=nullptr) const =0', 'simplify(double tolerance, QString *errorMsg=nullptr) const =0'],
    "QgsGeometryGeneratorSymbolLayer": ['create(const QgsStringMap &properties)'],
    "QgsGeometryRubberBand": ['IconType', 'QgsGeometryRubberBand(QgsMapCanvas *mapCanvas, QgsWkbTypes::GeometryType geomType=QgsWkbTypes::LineGeometry)'],
    "QgsGeometryValidator": ['addError(const QgsGeometry::Error &)', 'errorFound(const QgsGeometry::Error &)', 'stop()'],
    "QgsGeos": ['coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)', 'fromGeosPolygon(const GEOSGeometry *geos)', 'getGEOSHandler()'],
    "QgsGlowEffect": ['QgsGlowEffect(const QgsGlowEffect &other)'],
    "QgsGlowWidget": ['QgsGlowWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsGml": ['QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)', 'dataReadProgress(int progress)', 'totalStepsUpdate(int totalSteps)'],
    "QgsGmlFeatureClass": ['QgsGmlFeatureClass(const QString &name, const QString &path)', 'fieldIndex(const QString &name)', 'fields()', 'geometryAttributes()', 'path() const'],
    "QgsGpsConnection": ['Status', 'nmeaSentenceReceived(const QString &substring)', 'stateChanged(const QgsGpsInformation &info)'],
    "QgsGpsConnectionRegistry": ['connectionList() const'],
    "QgsGpsDetector": ['QgsGpsDetector(const QString &portName)', 'advance()', 'availablePorts()', 'connDestroyed(QObject *)', 'detected(QgsGpsConnection *)', 'detected(const QgsGpsInformation &)', 'detectionFailed()'],
    "QgsGpsdConnection": ['QgsGpsdConnection(const QString &host, qint16 port, const QString &device)'],
    "QgsGradientFillSymbolLayer": ['GradientColorType', 'GradientCoordinateMode', 'GradientSpread', 'GradientType', 'QgsGradientFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, GradientColorType gradientColorType=SimpleTwoColor, GradientType gradientType=Linear, GradientCoordinateMode coordinateMode=Feature, GradientSpread gradientSpread=Pad)', 'create(const QgsStringMap &properties=QgsStringMap())', 'offset() const', 'offsetMapUnitScale() const', 'offsetUnit() const', 'referencePoint1() const', 'referencePoint1IsCentroid() const', 'referencePoint2() const', 'referencePoint2IsCentroid() const', 'setColor2(const QColor &color2)', 'setCoordinateMode(GradientCoordinateMode coordinateMode)', 'setGradientColorType(GradientColorType gradientColorType)', 'setGradientSpread(GradientSpread gradientSpread)', 'setGradientType(GradientType gradientType)', 'setOffsetMapUnitScale(const QgsMapUnitScale &scale)'],
    "QgsGradientFillSymbolLayerWidget": ['setColor(const QColor &color)', 'setColor2(const QColor &color)', 'setCoordinateMode(int index)', 'setGradientSpread(int index)', 'setGradientType(int index)'],
    "QgsGraduatedSymbolRenderer": ['GraduatedMethod', 'Mode', 'QgsGraduatedSymbolRenderer(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())', 'addClass(QgsSymbol *symbol)', 'classAttribute() const', 'deleteAllClasses()', 'deleteClass(int idx)', 'mode() const', 'ranges() const', 'setClassAttribute(const QString &attr)', 'setMode(Mode mode)', 'sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)', 'sortByValue(Qt::SortOrder order=Qt::AscendingOrder)', 'updateRangeLabel(int rangeIndex, const QString &label)', 'updateRangeLowerValue(int rangeIndex, double value)', 'updateRangeSymbol(int rangeIndex, QgsSymbol *symbol)', 'updateRangeUpperValue(int rangeIndex, double value)'],
    "QgsGraduatedSymbolRendererWidget": ['QgsGraduatedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'changeCurrentValue(QStandardItem *item)', 'changeGraduatedSymbol()', 'changeRange(int rangeIdx)', 'changeRangeSymbol(int rangeIdx)', 'changeSelectedSymbols()', 'classifyGraduated()', 'connectUpdateHandlers()', 'create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'disconnectUpdateHandlers()', 'findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const', 'graduatedColumnChanged(const QString &field)', 'labelFormatChanged()', 'modelDataChanged()', 'rangesClicked(const QModelIndex &idx)', 'rangesDoubleClicked(const QModelIndex &idx)', 'reapplyColorRamp()', 'reapplySizes()', 'refreshRanges(bool reset=false)', 'rowsMoved()', 'rowsOrdered()', 'selectedRanges()', 'showSymbolLevels()', 'updateGraduatedSymbolIcon()', 'updateUiFromRenderer(bool updateCount=true)'],
    "QgsGroupBoxCollapseButton": ['QgsGroupBoxCollapseButton(QWidget *parent=nullptr)', 'altDown() const', 'setAltDown(bool updown)', 'setShiftDown(bool shiftdown)', 'shiftDown() const'],
    "QgsHeatmapRenderer": ['convertFromRenderer(const QgsFeatureRenderer *renderer)'],
    "QgsHiddenWidgetFactory": ['QgsHiddenWidgetFactory(const QString &name)'],
    "QgsHiddenWidgetWrapper": ['QgsHiddenWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsHillshadeFilter": ['QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)', 'lightAngle() const', 'lightAzimuth() const', 'setLightAngle(float angle)', 'setLightAzimuth(float azimuth)'],
    "QgsHueSaturationFilter": ['GrayscaleMode', 'QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)', 'colorizeColor() const', 'colorizeOn() const', 'colorizeStrength() const', 'grayscaleMode() const', 'saturation() const', 'setColorizeColor(const QColor &colorizeColor)', 'setColorizeOn(bool colorizeOn)', 'setColorizeStrength(int colorizeStrength)', 'setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)', 'setSaturation(int saturation)'],
    "QgsIFeatureSelectionManager": ['QgsIFeatureSelectionManager(QObject *parent)'],
    "QgsIdentifyMenu": ['MenuLevel', 'allowMultipleReturn()', 'execWithSingleResult()', 'maxFeatureDisplay()', 'maxLayerDisplay()', 'resultsIfExternalAction()', 'showFeatureActions()'],
    "QgsImageFillSymbolLayer": ['applyDataDefinedSettings(QgsSymbolRenderContext &context)', 'setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)', 'strokeWidthMapUnitScale() const'],
    "QgsInterpolator": ['QgsInterpolator(const QList< QgsInterpolator::LayerData > &layerData)'],
    "QgsLUDialog": ['QgsLUDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)', 'lowerValue() const', 'setLowerValue(const QString &val)', 'setUpperValue(const QString &val)', 'upperValue() const'],
    "QgsLabelCandidate": ['QgsLabelCandidate(const QRectF &r, double c)'],
    "QgsLabelPosition": ['QgsLabelPosition(int id, double r, const QVector< QgsPointXY > &corners, const QgsRectangle &rect, double w, double h, const QString &layer, const QString &labeltext, const QFont &labelfont, bool upside_down, bool diagram=false, bool pinned=false, const QString &providerId=QString())'],
    "QgsLabelSorter": ['QgsLabelSorter(const QgsMapSettings &mapSettings)', 'operator()(pal::LabelPosition *lp1, pal::LabelPosition *lp2) const'],
    "QgsLabelingEngine": ['processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)'],
    "QgsLayerItem": ['LayerType', 'QgsLayerItem(QgsDataItem *parent, const QString &name, const QString &path, const QString &uri, LayerType layerType, const QString &providerKey)', 'iconDefault()', 'iconLine()', 'iconPoint()', 'iconPolygon()', 'iconRaster()', 'iconTable()'],
    "QgsLayerPropertiesWidget": ['changeLayer(QgsSymbolLayer *)', 'changed()', 'emitSignalChanged()', 'layerTypeChanged()', 'populateLayerTypes()', 'updateSymbolLayerWidget(QgsSymbolLayer *layer)'],
    "QgsLayerTreeGroup": ['QgsLayerTreeGroup(const QgsLayerTreeGroup &other)', 'nodeVisibilityChanged(QgsLayerTreeNode *node)'],
    "QgsLayerTreeLayer": ['QgsLayerTreeLayer(QgsMapLayer *layer)', 'QgsLayerTreeLayer(const QgsLayerTreeLayer &other)', 'attachToLayer()', 'layer() const', 'layerId() const'],
    "QgsLayerTreeMapCanvasBridge": ['autoSetupOnFirstLayer() const', 'mapCanvas() const', 'rootGroup() const'],
    "QgsLayerTreeModel": ['Flag', 'addLegendToLayer(QgsLayerTreeLayer *nodeL)', 'connectToLayer(QgsLayerTreeLayer *nodeLayer)', 'connectToLayers(QgsLayerTreeGroup *parentGroup)', 'connectToRootNode()', 'disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)', 'disconnectFromLayers(QgsLayerTreeGroup *parentGroup)', 'disconnectFromRootNode()', 'iconGroup()', 'indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const', 'invalidateLegendMapBasedData()', 'layerLegendChanged()', 'layerNeedsUpdate()', 'legendCleanup()', 'legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const', 'legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const', 'legendInvalidateMapBasedData()', 'legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const', 'legendNodeDataChanged()', 'legendNodeFlags(QgsLayerTreeModelLegendNode *node) const', 'legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const', 'legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const', 'legendParent(QgsLayerTreeModelLegendNode *legendNode) const', 'legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const', 'legendRootRowCount(QgsLayerTreeLayer *nL) const', 'nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)', 'nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)', 'nodeLayerLoaded()', 'nodeLayerWillBeUnloaded()', 'nodeRemovedChildren()', 'nodeVisibilityChanged(QgsLayerTreeNode *node)', 'nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)', 'nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)', 'removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)'],
    "QgsLayerTreeModelLegendNode": ['LegendNodeRoles', 'isEmbeddedInParent() const', 'isScaleOK(double scale) const', 'setEmbeddedInParent(bool embedded)', 'setUserLabel(const QString &userLabel)', 'userLabel() const'],
    "QgsLayerTreeNode": ['QgsLayerTreeNode(const QgsLayerTreeNode &other)'],
    "QgsLayerTreeRegistryBridge": ['groupRemovedChildren()', 'groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)', 'isEnabled() const', 'layersAdded(const QList< QgsMapLayer *> &layers)', 'layersWillBeRemoved(const QStringList &layerIds)', 'newLayersVisible() const', 'removeLayersFromRegistry(const QStringList &layerIds)', 'setEnabled(bool enabled)', 'setNewLayersVisible(bool enabled)'],
    "QgsLayerTreeView": ['layerForIndex(const QModelIndex &index) const', 'modelRowsInserted(const QModelIndex &index, int start, int end)', 'modelRowsRemoved()', 'onCurrentChanged()', 'onExpandedChanged(QgsLayerTreeNode *node, bool expanded)', 'onModelReset()', 'updateExpandedStateFromNode(QgsLayerTreeNode *node)', 'updateExpandedStateToNode(const QModelIndex &index)'],
    "QgsLayerTreeViewDefaultActions": ['QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)', 'actionAddGroup(QObject *parent=nullptr)', 'actionGroupSelected(QObject *parent=nullptr)', 'actionRemoveGroupOrLayer(QObject *parent=nullptr)', 'actionRenameGroupOrLayer(QObject *parent=nullptr)', 'actionShowFeatureCount(QObject *parent=nullptr)', 'actionShowInOverview(QObject *parent=nullptr)', 'actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)', 'actionZoomToLayer(QgsMapCanvas *canvas, QObject *parent=nullptr)', 'addGroup()', 'groupSelected()', 'removeGroupOrLayer()', 'renameGroupOrLayer()', 'showFeatureCount()', 'showInOverview()', 'uniqueGroupName(QgsLayerTreeGroup *parentGroup)', 'zoomToGroup()', 'zoomToGroup(QgsMapCanvas *canvas)', 'zoomToLayer()', 'zoomToLayer(QgsMapCanvas *canvas)', 'zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer *> &layers)'],
    "QgsLegendRenderer": ['nodeLegendStyle(QgsLayerTreeNode *node, QgsLayerTreeModel *model)', 'setNodeLegendStyle(QgsLayerTreeNode *node, QgsLegendStyle::Style style)'],
    "QgsLegendSettings": ['boxSpace() const', 'columnCount() const', 'columnSpace() const', 'dpi() const', 'equalColumnWidth() const', 'fontColor() const', 'lineSpacing() const', 'mmPerMapUnit() const', 'setBoxSpace(double s)', 'setColumnCount(int c)', 'setColumnSpace(double s)', 'setDpi(int dpi)', 'setEqualColumnWidth(bool s)', 'setFontColor(const QColor &c)', 'setLineSpacing(double s)', 'setMmPerMapUnit(double mmPerMapUnit)', 'setSplitLayer(bool s)', 'setStyle(QgsLegendStyle::Style s, const QgsLegendStyle &style)', 'setSymbolSize(QSizeF s)', 'setTitle(const QString &t)', 'setUseAdvancedEffects(bool use)', 'setWmsLegendSize(QSizeF s)', 'setWrapChar(const QString &t)', 'splitLayer() const', 'symbolSize() const', 'title() const', 'useAdvancedEffects() const', 'wmsLegendSize() const', 'wrapChar() const'],
    "QgsLegendStyle": ['Style', 'margin(Side side)', 'readXml(const QDomElement &elem, const QDomDocument &doc)', 'setMargin(Side side, double margin)', 'writeXml(const QString &name, QDomElement &elem, QDomDocument &doc) const'],
    "QgsLegendSymbolItem": ['QgsLegendSymbolItem(const QgsLegendSymbolItem &other)'],
    "QgsLinePatternFillSymbolLayer": ['create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'distanceMapUnitScale() const', 'lineAngle() const', 'lineWidth() const', 'lineWidthMapUnitScale() const', 'offset() const', 'offsetMapUnitScale() const', 'ogrFeatureStyleWidth(double widthScaleFactor) const', 'setDistanceMapUnitScale(const QgsMapUnitScale &scale)', 'setLineAngle(double a)', 'setLineWidth(double w)', 'setLineWidthMapUnitScale(const QgsMapUnitScale &scale)', 'setOffset(double offset)', 'setOffsetMapUnitScale(const QgsMapUnitScale &scale)'],
    "QgsLineSymbol": ['QgsLineSymbol(const QgsSymbolLayerList &layers=QgsSymbolLayerList())', 'renderPolyline(const QPolygonF &points, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)', 'setWidth(double width)', 'width() const'],
    "QgsLineSymbolLayer": ['QgsLineSymbolLayer(bool locked=false)', 'offset() const', 'offsetMapUnitScale() const', 'renderPolygonStroke(const QPolygonF &points, QList< QPolygonF > *rings, QgsSymbolRenderContext &context)', 'renderPolyline(const QPolygonF &points, QgsSymbolRenderContext &context)=0', 'setOffset(double offset)', 'setOffsetMapUnitScale(const QgsMapUnitScale &scale)', 'setWidth(double width)', 'setWidthMapUnitScale(const QgsMapUnitScale &scale)', 'width() const', 'widthMapUnitScale() const'],
    "QgsLinearMinMaxEnhancement": ['QgsLinearMinMaxEnhancement(Qgis::DataType, double, double)'],
    "QgsLinearMinMaxEnhancementWithClip": ['QgsLinearMinMaxEnhancementWithClip(Qgis::DataType, double, double)'],
    "QgsLinearlyInterpolatedDiagramRenderer": ['classificationAttributeExpression() const', 'classificationAttributeIsExpression() const', 'lowerSize() const', 'lowerValue() const', 'setClassificationAttributeExpression(const QString &expression)', 'setClassificationAttributeIsExpression(bool isExpression)', 'setDiagramSettings(const QgsDiagramSettings &s)', 'setLowerSize(QSizeF s)', 'setLowerValue(double val)', 'setUpperSize(QSizeF s)', 'setUpperValue(double val)', 'upperSize() const', 'upperValue() const'],
    "QgsLongLongValidator": ['QgsLongLongValidator(QObject *parent)', 'QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)', 'bottom() const', 'setBottom(qint64 bottom)', 'setRange(qint64 bottom, qint64 top)', 'setTop(qint64 top)', 'top() const'],
    "QgsManageConnectionsDialog": ['Mode', 'Type', 'clearSelection()', 'doExportImport()', 'selectAll()', 'selectionChanged()'],
    "QgsMapCanvas": ['clearExtentHistory()', 'setCurrentLayer(QgsMapLayer *layer)'],
    "QgsMapCanvasSnappingUtils": ['QgsMapCanvasSnappingUtils(QgsMapCanvas *canvas, QObject *parent=nullptr)'],
    "QgsMapLayer": ['readSld(const QDomNode &node, QString &errorMessage)'],
    "QgsMapLayerAction": ['Target'],
    "QgsMapLayerComboBox": ['indexChanged(int i)', 'rowsChanged()'],
    "QgsMapLayerLegendUtils": ['hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)', 'hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)', 'legendNodeOrder(QgsLayerTreeLayer *nodeLayer)', 'legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)', 'setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)', 'setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)'],
    "QgsMapLayerModel": ['addLayers(const QList< QgsMapLayer *> &layers)', 'removeLayers(const QStringList &layerIds)'],
    "QgsMapLayerProxyModel": ['Filter', 'filters() const'],
    "QgsMapLayerRenderer": ['QgsMapLayerRenderer(const QString &layerID)'],
    "QgsMapOverviewCanvas": ['QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)', 'enableAntiAliasing(bool flag)', 'mapRenderingFinished()', 'updateFullExtent()'],
    "QgsMapRendererCustomPainterJob": ['QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)'],
    "QgsMapRendererJob": ['QgsMapRendererJob(const QgsMapSettings &settings)'],
    "QgsMapRendererParallelJob": ['QgsMapRendererParallelJob(const QgsMapSettings &settings)'],
    "QgsMapRendererQImageJob": ['QgsMapRendererQImageJob(const QgsMapSettings &settings)'],
    "QgsMapRendererSequentialJob": ['QgsMapRendererSequentialJob(const QgsMapSettings &settings)', 'internalFinished()'],
    "QgsMapSettings": ['mapToPixel() const', 'readXml(QDomNode &node)', 'updateDerived()', 'writeXml(QDomNode &node, QDomDocument &doc)'],
    "QgsMapToPixel": ['toMapCoordinates(int x, int y) const', 'toMapPoint(double x, double y) const', 'transform() const', 'transform(QgsPointXY *p) const'],
    "QgsMapToolAdvancedDigitizing": ['cadDockWidget() const'],
    "QgsMapToolEdit": ['QgsMapToolEdit(QgsMapCanvas *canvas)', 'createGeometryRubberBand(QgsWkbTypes::GeometryType geometryType=QgsWkbTypes::LineGeometry, bool alternativeBand=false) const'],
    "QgsMapToolIdentify": ['IdentifyMode', 'Type', 'changedRasterResults(QList< QgsMapToolIdentify::IdentifyResult > &)', 'formatChanged(QgsRasterLayer *layer)', 'identifyMessage(const QString &)', 'identifyProgress(int, int)', 'identifyRasterLayer(QList< QgsMapToolIdentify::IdentifyResult > *results, QgsRasterLayer *layer, QgsPointXY point, const QgsRectangle &viewExtent, double mapUnitsPerPixel)', 'identifyVectorLayer(QList< QgsMapToolIdentify::IdentifyResult > *results, QgsVectorLayer *layer, const QgsPointXY &point)'],
    "QgsMapToolIdentifyFeature": ['featureIdentified(QgsFeatureId)', 'featureIdentified(const QgsFeature &)'],
    "QgsMarkerLineSymbolLayer": ['QgsMarkerLineSymbolLayer(bool rotateMarker=DEFAULT_MARKERLINE_ROTATE, double interval=DEFAULT_MARKERLINE_INTERVAL)', 'intervalMapUnitScale() const', 'markerAngle(const QPolygonF &points, bool isRing, int vertex)', 'renderPolylineCentral(const QPolygonF &points, QgsSymbolRenderContext &context)', 'renderPolylineInterval(const QPolygonF &points, QgsSymbolRenderContext &context)', 'renderPolylineVertex(const QPolygonF &points, QgsSymbolRenderContext &context, Placement placement=Vertex)', 'setIntervalMapUnitScale(const QgsMapUnitScale &scale)'],
    "QgsMarkerLineSymbolLayerWidget": ['setInterval(double val)', 'setOffsetAlongLine(double val)'],
    "QgsMarkerSymbol": ['QgsMarkerSymbol(const QgsSymbolLayerList &layers=QgsSymbolLayerList())', 'renderPoint(QPointF point, const QgsFeature *f, QgsRenderContext &context, int layer=-1, bool selected=false)', 'scaleMethod()', 'setScaleMethod(QgsSymbol::ScaleMethod scaleMethod)'],
    "QgsMasterPasswordResetDialog": ['QgsMasterPasswordResetDialog(QWidget *parent=nullptr)', 'requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)'],
    "QgsMessageBar": ['currentItem()'],
    "QgsMessageBarItem": ['setDuration(int duration)', 'setIcon(const QIcon &icon)', 'setLevel(Qgis::MessageLevel level)', 'setText(const QString &text)', 'setTitle(const QString &title)', 'setWidget(QWidget *widget)'],
    "QgsMessageLog": ['messageReceived(bool received)', 'messageReceived(const QString &message, const QString &tag, Qgis::MessageLevel level)'],
    "QgsMessageLogConsole": ['logMessage(const QString &message, const QString &tag, Qgis::MessageLevel level)'],
    "QgsMessageViewer": ['QgsMessageViewer(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags, bool deleteOnClose=true)', 'checkBoxState()', 'setCheckBoxQgsSettingsLabel(const QString &label)', 'setCheckBoxState(Qt::CheckState state)', 'setCheckBoxText(const QString &text)', 'setCheckBoxVisible(bool visible)', 'setMessageAsHtml(const QString &msg)', 'setMessageAsPlainText(const QString &msg)'],
    "QgsMimeDataUtils": ['decodeUriList(const QMimeData *data)', 'encodeUriList(const UriList &layers)', 'isUriList(const QMimeData *data)'],
    "QgsMultiBandColorRenderer": ['QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)', 'blueBand() const', 'blueContrastEnhancement() const', 'create(const QDomElement &elem, QgsRasterInterface *input)', 'greenBand() const', 'greenContrastEnhancement() const', 'redBand() const', 'redContrastEnhancement() const', 'setBlueBand(int band)', 'setGreenBand(int band)', 'setRedBand(int band)'],
    "QgsMultiBandColorRendererWidget": ['QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())', 'create(QgsRasterLayer *layer, const QgsRectangle &extent)', 'setFromRenderer(const QgsRasterRenderer *r)'],
    "QgsMultiRenderChecker": ['setControlPathPrefix(const QString &prefix)'],
    "QgsNetworkAccessManager": ['QgsNetworkAccessManager(QObject *parent=nullptr)', 'requestAboutToBeCreated(QNetworkAccessManager::Operation, const QNetworkRequest &, QIODevice *)', 'requestCreated(QNetworkReply *)', 'requestTimedOut(QNetworkReply *)'],
    "QgsNewMemoryLayerDialog": ['QgsNewMemoryLayerDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)'],
    "QgsNewNameDialog": ['fullNames(const QString &name, const QStringList &extensions)', 'highlightText(const QString &text)', 'matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)', 'nameChanged()'],
    "QgsNewVectorLayerDialog": ['QgsNewVectorLayerDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)'],
    "QgsNineCellFilter": ['cellSizeX() const', 'cellSizeY() const', 'inputNodataValue() const', 'outputNodataValue() const', 'setCellSizeX(double size)', 'setCellSizeY(double size)', 'setInputNodataValue(double value)', 'setOutputNodataValue(double value)', 'setZFactor(double factor)', 'zFactor() const'],
    "QgsOWSSourceSelect": ['addWmsListItem(const QDomElement &el, int row, int column)', 'addWmsListRow(const QDomElement &item, int row)', 'enableLayersForCrs(QTreeWidgetItem *item)'],
    "QgsOfflineEditing": ['ProgressMode'],
    "QgsOptionsDialogBase": ['setSettings(QgsSettings *settings)', 'updateWindowTitle()', 'warnAboutMissingObjects()'],
    "QgsPaintEffect": ['QgsPaintEffect(const QgsPaintEffect &other)'],
    "QgsPaintEffectWidget": ['QgsPaintEffectWidget(QWidget *parent=nullptr)'],
    "QgsPaintEngineHack": ['fixEngineFlags(QPaintEngine *engine)', 'fixFlags()'],
    "QgsPalLayerSettings": ['DirectionSymbols', 'MultiLineAlign', 'QgsPalLayerSettings(const QgsPalLayerSettings &s)', 'QuadrantPosition', 'UpsideDownLabels', 'calculateLabelSize(const QFontMetricsF *fm, QString text, double &labelX, double &labelY, QgsFeature *f=nullptr, QgsRenderContext *context=nullptr)'],
    "QgsPalettedRasterRenderer": ['create(const QDomElement &elem, QgsRasterInterface *input)'],
    "QgsPalettedRendererWidget": ['QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())', 'create(QgsRasterLayer *layer, const QgsRectangle &extent)', 'setFromRenderer(const QgsRasterRenderer *r)'],
    "QgsPenCapStyleComboBox": ['QgsPenCapStyleComboBox(QWidget *parent=nullptr)', 'penCapStyle() const', 'setPenCapStyle(Qt::PenCapStyle style)'],
    "QgsPenJoinStyleComboBox": ['QgsPenJoinStyleComboBox(QWidget *parent=nullptr)', 'penJoinStyle() const', 'setPenJoinStyle(Qt::PenJoinStyle style)'],
    "QgsPenStyleComboBox": ['QgsPenStyleComboBox(QWidget *parent=nullptr)', 'iconForPen(Qt::PenStyle style)', 'penStyle() const', 'setPenStyle(Qt::PenStyle style)'],
    "QgsPixmapLabel": ['setPixmap(const QPixmap &)'],
    "QgsPluginLayer": ['QgsPluginLayer(const QString &layerType, const QString &layerName=QString())'],
    "QgsPluginLayerType": ['QgsPluginLayerType(const QString &name)', 'name()'],
    "QgsPointDisplacementRendererWidget": ['QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)'],
    "QgsPointLocator": ['destroyIndex()', 'rebuildIndex(int maxFeaturesToIndex=-1)'],
    "QgsPointLocator_Stream": ['QgsPointLocator_Stream(const QLinkedList< RTree::Data *> &dataList)'],
    "QgsPointLocator_VisitorEdgesInRect": ['QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)'],
    "QgsPointLocator_VisitorNearestEdge": ['QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)'],
    "QgsPointLocator_VisitorNearestVertex": ['QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)'],
    "QgsPointPatternFillSymbolLayer": ['create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'displacementX() const', 'displacementXMapUnitScale() const', 'displacementY() const', 'displacementYMapUnitScale() const', 'distanceX() const', 'distanceXMapUnitScale() const', 'distanceY() const', 'distanceYMapUnitScale() const', 'setDisplacementX(double d)', 'setDisplacementXMapUnitScale(const QgsMapUnitScale &scale)', 'setDisplacementY(double d)', 'setDisplacementYMapUnitScale(const QgsMapUnitScale &scale)', 'setDistanceX(double d)', 'setDistanceXMapUnitScale(const QgsMapUnitScale &scale)', 'setDistanceY(double d)', 'setDistanceYMapUnitScale(const QgsMapUnitScale &scale)'],
    "QgsPreviewEffect": ['PreviewMode', 'QgsPreviewEffect(QObject *parent)'],
    "QgsProject": ['readBoolEntry(const QString &scope, const QString &key, bool def=false, bool *ok=nullptr) const', 'readDoubleEntry(const QString &scope, const QString &key, double def=0, bool *ok=nullptr) const', 'readEntry(const QString &scope, const QString &key, const QString &def=QString(), bool *ok=nullptr) const', 'readNumEntry(const QString &scope, const QString &key, int def=0, bool *ok=nullptr) const', 'relationManager() const'],
    "QgsProjectFileTransform": ['convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)', 'updateRevision(const QgsProjectVersion &version)'],
    "QgsProjectVersion": ['QgsProjectVersion(const QString &string)', 'QgsProjectVersion(int major, int minor, int sub, const QString &name="")', 'majorVersion()', 'minorVersion()', 'subVersion()', 'text()'],
    "QgsProviderMetadata": ['QgsProviderMetadata(const QString &_key, const QString &_description, const QString &_library)'],
    "QgsProviderRegistry": ['registerGuis(QWidget *widget)'],
    "QgsPythonRunner": ['evalCommand(QString command, QString &result)=0', 'runCommand(QString command, QString messageOnError=QString())=0'],
    "QgsQueryBuilder": ['clear()', 'setDatasourceDescription(const QString &uri)', 'setSql(const QString &sqlStatement)', 'sql()'],
    "QgsRangeConfigDlg": ['QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)', 'rangeWidgetChanged(int index)'],
    "QgsRangeWidgetFactory": ['QgsRangeWidgetFactory(const QString &name)'],
    "QgsRangeWidgetWrapper": ['QgsRangeWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor, QWidget *parent=nullptr)'],
    "QgsRaster": ['ColorInterpretation', 'IdentifyFormat', 'RasterBuildPyramids', 'RasterProgressType', 'RasterPyramidsFormat'],
    "QgsRasterBandStats": ['Stats'],
    "QgsRasterBlock": ['applyNoDataValues(const QgsRasterRangeList &rangeList)', 'dataTypeSize() const', 'toString() const', 'typeSize(int dataType)'],
    "QgsRasterCalcNode": ['QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)', 'QgsRasterCalcNode(QgsRasterMatrix *matrix)', 'QgsRasterCalcNode(const QString &rasterName)', 'QgsRasterCalcNode(double number)', 'parseRasterCalcString(const QString &str, QString &parserErrorMsg)', 'setLeft(QgsRasterCalcNode *left)', 'setRight(QgsRasterCalcNode *right)', 'type() const'],
    "QgsRasterChecker": ['report()'],
    "QgsRasterDataProvider": ['QgsRasterDataProvider(const QString &uri)', 'colorInterpretationName(int bandNo) const', 'colorName(int colorInterpretation) const', 'colorTable(int bandNo) const', 'identifyFormatFromName(const QString &formatName)', 'identifyFormatLabel(QgsRaster::IdentifyFormat format)', 'identifyFormatName(QgsRaster::IdentifyFormat format)', 'identifyFormatToCapability(QgsRaster::IdentifyFormat format)', 'setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)'],
    "QgsRasterDrawer": ['QgsRasterDrawer(QgsRasterIterator *iterator)'],
    "QgsRasterFileWriter": ['Mode', 'QgsRasterFileWriter(const QString &outputUrl)', 'WriterError', 'buildPyramidsFlag() const', 'createOptions() const', 'maxTileHeight() const', 'maxTileWidth() const', 'outputFormat() const', 'outputProviderKey() const', 'pyramidsConfigOptions() const', 'pyramidsFormat() const', 'pyramidsList() const', 'pyramidsResampling() const', 'setBuildPyramidsFlag(QgsRaster::RasterBuildPyramids f)', 'setCreateOptions(const QStringList &list)', 'setMaxTileHeight(int h)', 'setMaxTileWidth(int w)', 'setOutputFormat(const QString &format)', 'setOutputProviderKey(const QString &key)', 'setPyramidsConfigOptions(const QStringList &list)', 'setPyramidsFormat(QgsRaster::RasterPyramidsFormat f)', 'setPyramidsList(const QList< int > &list)', 'setPyramidsResampling(const QString &str)', 'setTiledMode(bool t)', 'tiledMode() const'],
    "QgsRasterFillSymbolLayer": ['FillCoordinateMode', 'QgsRasterFillSymbolLayer(const QString &imageFilePath=QString())', 'create(const QgsStringMap &properties=QgsStringMap())'],
    "QgsRasterFormatSaveOptionsWidget": ['QgsRasterFormatSaveOptionsWidget(QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &format="GTiff", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider="gdal")', 'Type', 'apply()', 'optionsChanged()'],
    "QgsRasterInterface": ['QgsRasterInterface(QgsRasterInterface *input=nullptr)', 'dataTypeSize(int bandNo)', 'yBlockSize() const', 'ySize() const'],
    "QgsRasterIterator": ['QgsRasterIterator(QgsRasterInterface *input)', 'input() const', 'maximumTileHeight() const', 'maximumTileWidth() const', 'setMaximumTileHeight(int h)', 'setMaximumTileWidth(int w)', 'stopRasterRead(int bandNumber)'],
    "QgsRasterLayer": ['brightnessFilter() const', 'hueSaturationFilter() const', 'isValidRasterFileName(const QString &fileNameQString)', 'renderer() const', 'showStatusMessage(const QString &message)'],
    "QgsRasterLayerRenderer": ['QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)'],
    "QgsRasterLayerSaveAsDialog": ['CrsState', 'Mode', 'ResolutionState', 'addToCanvas() const', 'buildPyramidsFlag() const', 'createOptions() const', 'hideFormat()', 'hideOutput()', 'maximumTileSizeX() const', 'maximumTileSizeY() const', 'mode() const', 'nColumns() const', 'nRows() const', 'noData() const', 'outputCrs()', 'outputFileName() const', 'outputFormat() const', 'outputRectangle() const', 'pyramidsConfigOptions() const', 'pyramidsFormat() const', 'pyramidsList() const', 'pyramidsResamplingMethod() const', 'tileMode() const', 'xResolution() const', 'yResolution() const'],
    "QgsRasterMatrix": ['OneArgOperator', 'QgsRasterMatrix(const QgsRasterMatrix &m)', 'TwoArgOperator', 'acosinus()', 'asinus()', 'atangens()', 'changeSign()', 'cosinus()', 'divide(const QgsRasterMatrix &other)', 'equal(const QgsRasterMatrix &other)', 'greaterEqual(const QgsRasterMatrix &other)', 'greaterThan(const QgsRasterMatrix &other)', 'lesserEqual(const QgsRasterMatrix &other)', 'lesserThan(const QgsRasterMatrix &other)', 'log()', 'log10()', 'logicalAnd(const QgsRasterMatrix &other)', 'logicalOr(const QgsRasterMatrix &other)', 'multiply(const QgsRasterMatrix &other)', 'nColumns() const', 'nRows() const', 'nodataValue() const', 'notEqual(const QgsRasterMatrix &other)', 'number() const', 'power(const QgsRasterMatrix &other)', 'setData(int cols, int rows, double *data, double nodataValue)', 'setNodataValue(double d)', 'sinus()', 'squareRoot()', 'tangens()'],
    "QgsRasterMinMaxWidget": ['setBands(const QList< int > &bands)'],
    "QgsRasterNuller": ['QgsRasterNuller(QgsRasterInterface *input=nullptr)', 'noData(int bandNo) const', 'setNoData(int bandNo, const QgsRasterRangeList &noData)'],
    "QgsRasterPipe": ['QgsRasterPipe(const QgsRasterPipe &pipe)', 'Role', 'at(int idx) const', 'brightnessFilter() const', 'hueSaturationFilter() const', 'last() const', 'nuller() const', 'projector() const', 'provider() const', 'renderer() const', 'resampleFilter() const', 'size() const'],
    "QgsRasterProjector": ['precision() const', 'precisionLabel(Precision precision)', 'setPrecision(Precision precision)'],
    "QgsRasterPyramidsOptionsWidget": ['apply()', 'checkAllLevels(bool checked)', 'configOptions() const', 'createOptionsWidget()', 'overviewList() const', 'overviewListChanged()', 'pyramidsFormat() const', 'resamplingMethod() const', 'setRasterFileName(const QString &file)', 'setRasterLayer(QgsRasterLayer *rasterLayer)', 'someValueChanged()'],
    "QgsRasterRange": ['max() const', 'min() const', 'setMax(double max)', 'setMin(double min)'],
    "QgsRasterRenderer": ['alphaBand() const', 'rasterTransparency() const', 'setAlphaBand(int band)', 'setRasterTransparency(QgsRasterTransparency *t)', 'type() const', 'usesTransparency() const'],
    "QgsRasterRendererRegistry": ['entries() const', 'insert(const QgsRasterRendererRegistryEntry &entry)', 'insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)', 'rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const', 'renderersList() const'],
    "QgsRasterRendererWidget": ['QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)', 'max(int index=0)', 'min(int index=0)', 'rasterLayer() const', 'renderer()=0', 'selectedBand(int index=0)', 'setMax(const QString &value, int index=0)', 'setMin(const QString &value, int index=0)', 'setRasterLayer(QgsRasterLayer *layer)', 'setStdDev(const QString &value)', 'stdDev()'],
    "QgsRasterResampleFilter": ['QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)', 'maxOversampling() const', 'setMaxOversampling(double os)', 'zoomedInResampler() const', 'zoomedOutResampler() const'],
    "QgsRasterResampler": ['resample(const QImage &srcImage, QImage &dstImage)=0'],
    "QgsRasterShader": ['QgsRasterShader(double minimumValue=0.0, double maximumValue=255.0)', 'rasterShaderFunction()', 'rasterShaderFunction() const'],
    "QgsRasterShaderFunction": ['QgsRasterShaderFunction(double minimumValue=0.0, double maximumValue=255.0)', 'legendSymbologyItems(QList< QPair< QString, QColor > > &symbolItems) const', 'minimumMaximumRange() const'],
    "QgsRelationEditorWidget": ['setEditorContext(const QgsAttributeEditorContext &context)', 'setFeature(const QgsFeature &feature)', 'setRelationFeature(const QgsRelation &relation, const QgsFeature &feature)'],
    "QgsRelationReferenceConfigDlg": ['QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)'],
    "QgsRelationReferenceFactory": ['QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)'],
    "QgsRelationReferenceWidget": ['CanvasExtent', 'QgsRelationReferenceWidget(QWidget *parent)', 'foreignKeyChanged(const QVariant &)', 'init()', 'setAllowMapIdentification(bool allowMapIdentification)', 'setEditorContext(const QgsAttributeEditorContext &context, QgsMapCanvas *canvas, QgsMessageBar *messageBar)', 'setEmbedForm(bool display)', 'setOpenFormButtonVisible(bool openFormButtonVisible)', 'setReadOnlySelector(bool readOnly)', 'setRelation(const QgsRelation &relation, bool allowNullValue)', 'setRelationEditable(bool editable)'],
    "QgsRelief": ['QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)', 'addReliefColorClass(const QgsRelief::ReliefColor &color)', 'clearReliefColors()', 'reliefColors() const', 'setReliefColors(const QList< QgsRelief::ReliefColor > &c)', 'setZFactor(double factor)', 'zFactor() const'],
    "QgsRenderChecker": ['controlImagePath() const', 'elapsedTime()', 'matchPercent()', 'matchTarget()', 'mismatchCount()', 'report()', 'setControlPathSuffix(const QString &name)', 'setElapsedTimeTarget(int target)', 'setRenderedImage(const QString &imageFileName)'],
    "QgsRenderContext": ['QgsRenderContext(const QgsRenderContext &rh)', 'drawEditingInformation() const', 'extent() const', 'forceVectorOutput() const', 'mapToPixel() const', 'renderingStopped() const', 'selectionColor() const', 'setDrawEditingInformation(bool b)', 'setExtent(const QgsRectangle &extent)', 'setForceVectorOutput(bool force)', 'setMapToPixel(const QgsMapToPixel &mtp)', 'setRenderingStopped(bool stopped)', 'setSelectionColor(const QColor &color)', 'setUseRenderingOptimization(bool enabled)', 'setVectorSimplifyMethod(const QgsVectorSimplifyMethod &simplifyMethod)'],
    "QgsRendererAbstractMetadata": ['QgsRendererAbstractMetadata(const QString &name, const QString &visibleName, const QIcon &icon=QIcon())', 'createRendererFromSld(QDomElement &elem, QgsWkbTypes::GeometryType geomType)', 'icon() const', 'name() const', 'setIcon(const QIcon &icon)', 'visibleName() const'],
    "QgsRendererCategory": ['dump() const', 'label() const', 'setLabel(const QString &label)', 'setSymbol(QgsSymbol *s)', 'setValue(const QVariant &value)', 'swap(QgsRendererCategory &other)', 'symbol() const', 'toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const', 'value() const'],
    "QgsRendererRange": ['QgsRendererRange(const QgsRendererRange &range)', 'QgsRendererRange(double lowerValue, double upperValue, QgsSymbol *symbol, const QString &label, bool render=true)', 'dump() const', 'label() const', 'lowerValue() const', 'operator<(const QgsRendererRange &other) const', 'renderState() const', 'setLabel(const QString &label)', 'setLowerValue(double lowerValue)', 'setRenderState(bool render)', 'setSymbol(QgsSymbol *s)', 'setUpperValue(double upperValue)', 'swap(QgsRendererRange &other)', 'symbol() const', 'upperValue() const'],
    "QgsRendererRangeLabelFormat": ['QgsRendererRangeLabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)', 'format() const', 'formatNumber(double value) const', 'labelForRange(const QgsRendererRange &range) const', 'precision() const', 'saveToDomElement(QDomElement &element)', 'setFormat(const QString &format)', 'setFromDomElement(QDomElement &element)', 'setPrecision(int precision)', 'setTrimTrailingZeroes(bool trimTrailingZeroes)', 'trimTrailingZeroes() const'],
    "QgsRendererRulePropsDialog": ['buildExpression()', 'rule()', 'testFilter()'],
    "QgsRendererWidget": ['QgsRendererWidget(QgsVectorLayer *layer, QgsStyle *style)', 'contextMenuViewCategories(QPoint p)', 'copy()', 'paste()', 'refreshSymbolView()'],
    "QgsRuggednessFilter": ['QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)'],
    "QgsRuleBasedLabelProvider": ['QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)'],
    "QgsRuleBasedLabeling": ['rootRule()', 'rootRule() const'],
    "QgsRuleBasedRenderer": ['FeatureFlags', 'createFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType)', 'rootRule()'],
    "QgsRuleBasedRenderer::Rule": ['dependsOnScale() const', 'initFilter()', 'label() const', 'save(QDomDocument &doc, QgsSymbolMap &symbolMap) const', 'setLabel(const QString &label)', 'symbol()', 'toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const'],
    "QgsRuleBasedRendererModel": ['clearFeatureCounts()', 'finishedAddingRules()', 'insertRule(const QModelIndex &parent, int before, QgsRuleBasedRenderer::Rule *newrule)', 'removeRule(const QModelIndex &index)', 'ruleForIndex(const QModelIndex &index) const', 'updateRule(const QModelIndex &index)', 'updateRule(const QModelIndex &parent, int row)', 'willAddRules(const QModelIndex &parent, int count)'],
    "QgsRuleBasedRendererWidget": ['QgsRuleBasedRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'addRule()', 'clearFeatureCounts()', 'countFeatures()', 'create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'currentRule()', 'currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())', 'editRule()', 'editRule(const QModelIndex &index)', 'refineRule(int type)', 'refineRuleCategories()', 'refineRuleRanges()', 'refineRuleScales()', 'refineRuleScalesGui(const QModelIndexList &index)', 'removeRule()', 'restoreSectionWidths()', 'saveSectionWidth(int section, int oldSize, int newSize)', 'selectedRules()', 'selectedRulesChanged()', 'setRenderingOrder()'],
    "QgsRunProcess": ['create(const QString &action, bool capture)', 'dialogGone()', 'processError(QProcess::ProcessError)', 'processExit(int, QProcess::ExitStatus)', 'stderrAvailable()', 'stdoutAvailable()'],
    "QgsSVGFillSymbolLayer": ['QgsSVGFillSymbolLayer(const QByteArray &svgData, double width=20, double rotation=0.0)', 'create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'patternWidth() const', 'patternWidthMapUnitScale() const', 'setPatternWidth(double width)', 'setPatternWidthMapUnitScale(const QgsMapUnitScale &scale)', 'setSvgFilePath(const QString &svgPath)', 'setSvgFillColor(const QColor &c)', 'setSvgStrokeColor(const QColor &c)', 'setSvgStrokeWidth(double w)', 'setSvgStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)', 'svgFilePath() const', 'svgFillColor() const', 'svgStrokeColor() const', 'svgStrokeWidth() const', 'svgStrokeWidthMapUnitScale() const'],
    "QgsSVGFillSymbolLayerWidget": ['insertIcons()'],
    "QgsScopeLogger": ['QgsScopeLogger(const char *file, const char *func, int line)'],
    "QgsSearchQueryBuilder": ['loadQuery()', 'saveQuery()'],
    "QgsShadowEffectWidget": ['QgsShadowEffectWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsShapeburstFillSymbolLayer": ['QgsShapeburstFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, ShapeburstColorType colorType=SimpleTwoColor, int blurRadius=0, bool useWholeShape=true, double maxDistance=5)', 'ShapeburstColorType', 'create(const QgsStringMap &properties=QgsStringMap())', 'distanceMapUnitScale() const', 'offsetMapUnitScale() const', 'setDistanceMapUnitScale(const QgsMapUnitScale &scale)', 'setOffsetMapUnitScale(const QgsMapUnitScale &scale)'],
    "QgsShapeburstFillSymbolLayerWidget": ['setColor(const QColor &color)', 'setColor2(const QColor &color)'],
    "QgsSimpleFillSymbolLayer": ['QgsSimpleFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &strokeColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle strokeStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double strokeWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)', 'brushStyle() const', 'create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'offset()', 'offsetMapUnitScale() const', 'penJoinStyle() const', 'setBrushStyle(Qt::BrushStyle style)', 'setOffset(QPointF offset)', 'setOffsetMapUnitScale(const QgsMapUnitScale &scale)', 'setPenJoinStyle(Qt::PenJoinStyle style)', 'setStrokeStyle(Qt::PenStyle strokeStyle)', 'setStrokeWidth(double strokeWidth)', 'setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)', 'strokeStyle() const', 'strokeWidth() const', 'strokeWidthMapUnitScale() const'],
    "QgsSimpleFillSymbolLayerWidget": ['setColor(const QColor &color)', 'setStrokeColor(const QColor &color)'],
    "QgsSimpleLineSymbolLayer": ['QgsSimpleLineSymbolLayer(const QColor &color=DEFAULT_SIMPLELINE_COLOR, double width=DEFAULT_SIMPLELINE_WIDTH, Qt::PenStyle penStyle=DEFAULT_SIMPLELINE_PENSTYLE)', 'create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'customDashPatternMapUnitScale() const', 'customDashVector() const', 'drawInsidePolygon() const', 'penCapStyle() const', 'penJoinStyle() const', 'penStyle() const', 'setCustomDashPatternMapUnitScale(const QgsMapUnitScale &scale)', 'setCustomDashVector(const QVector< qreal > &vector)', 'setDrawInsidePolygon(bool drawInsidePolygon)', 'setPenCapStyle(Qt::PenCapStyle style)', 'setPenJoinStyle(Qt::PenJoinStyle style)', 'setPenStyle(Qt::PenStyle style)', 'setUseCustomDashPattern(bool b)', 'useCustomDashPattern() const'],
    "QgsSimpleLineSymbolLayerWidget": ['updatePatternIcon()'],
    "QgsSimpleMarkerSymbolLayerWidget": ['setColorFill(const QColor &color)', 'setColorStroke(const QColor &color)'],
    "QgsSimplifyMethod": ['MethodType'],
    "QgsSingleBandColorDataRenderer": ['QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)', 'create(const QDomElement &elem, QgsRasterInterface *input)'],
    "QgsSingleBandGrayRenderer": ['Gradient', 'QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)', 'contrastEnhancement() const', 'create(const QDomElement &elem, QgsRasterInterface *input)', 'gradient() const', 'grayBand() const', 'setGradient(Gradient gradient)', 'setGrayBand(int band)'],
    "QgsSingleBandGrayRendererWidget": ['QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())', 'create(QgsRasterLayer *layer, const QgsRectangle &extent)', 'setFromRenderer(const QgsRasterRenderer *r)'],
    "QgsSingleBandPseudoColorRenderer": ['classificationMax() const', 'classificationMin() const', 'create(const QDomElement &elem, QgsRasterInterface *input)', 'setClassificationMax(double max)', 'setClassificationMin(double min)'],
    "QgsSingleBandPseudoColorRendererWidget": ['QgsSingleBandPseudoColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())', 'create(QgsRasterLayer *layer, const QgsRectangle &extent)', 'setFromRenderer(const QgsRasterRenderer *r)'],
    "QgsSingleCategoryDiagramRenderer": ['setDiagramSettings(const QgsDiagramSettings &s)'],
    "QgsSingleSymbolRenderer": ['QgsSingleSymbolRenderer(QgsSymbol *symbol)', 'createFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType)', 'setSymbol(QgsSymbol *s)', 'symbol() const'],
    "QgsSingleSymbolRendererWidget": ['QgsSingleSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)', 'create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)'],
    "QgsSlider": ['setMaximum(const QVariant &max)', 'setMinimum(const QVariant &min)', 'setSingleStep(const QVariant &step)', 'setValue(const QVariant &value)', 'valueChanged(const QVariant &)', 'variantValue() const'],
    "QgsSlopeFilter": ['QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)'],
    "QgsSmartGroupCondition": ['QgsSmartGroupCondition(int id, QWidget *parent=nullptr)', 'destruct()', 'removed(int)'],
    "QgsSmartGroupEditorDialog": ['QgsSmartGroupEditorDialog(QgsStyle *style, QWidget *parent=nullptr)'],
    "QgsSnappingUtils": ['IndexingStrategy', 'mapSettings() const', 'snapToMap(const QgsPointXY &pointMap, QgsPointLocator::MatchFilter *filter=nullptr)'],
    "QgsSpatialIndexCopyVisitor": ['QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)'],
    "QgsSpatialIndexData": ['QgsSpatialIndexData(const QgsSpatialIndexData &other)', 'initTree(IDataStream *inputStream=nullptr)'],
    "QgsStyleExportImportDialog": ['Mode', 'QgsStyleExportImportDialog(QgsStyle *style, QWidget *parent=nullptr, Mode mode=Export)', 'browse()', 'doExportImport()', 'importTypeChanged(int)'],
    "QgsStyleGroupSelectionDialog": ['QgsStyleGroupSelectionDialog(QgsStyle *style, QWidget *parent=nullptr)'],
    "QgsStyleManagerDialog": ['QgsStyleManagerDialog(QgsStyle *style, QWidget *parent SIP_TRANSFERTHIS=nullptr)', 'addColorRamp(QAction *action)', 'addItem()', 'currentItemName()', 'currentItemType()', 'editColorRamp()', 'editItem()', 'editSymbol()', 'exportItems()', 'exportItemsPNG()', 'exportItemsSVG()', 'exportSelectedItemsImages(const QString &dir, const QString &format, QSize size)', 'groupChanged(const QModelIndex &)', 'groupRenamed(QStandardItem *)', 'importItems()', 'itemChanged(QStandardItem *item)', 'removeColorRamp()', 'removeItem()', 'removeSymbol()'],
    "QgsSublayersDialog": ['ProviderType'],
    "QgsSvgMarkerSymbolLayer": ['create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'setStrokeWidth(double w)', 'setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)', 'strokeWidth() const', 'strokeWidthMapUnitScale() const'],
    "QgsSvgMarkerSymbolLayerWidget": ['populateList()', 'setGuiForSvg(const QgsSvgMarkerSymbolLayer *layer)'],
    "QgsSvgSelectorGroupsModel": ['QgsSvgSelectorGroupsModel(QObject *parent)'],
    "QgsSvgSelectorWidget": ['currentSvgPath() const', 'populateList()', 'svgSelected(const QString &path)'],
    "QgsSymbol": ['QgsSymbol(SymbolType type, const QgsSymbolLayerList &layers)', 'color() const', 'dump() const', 'layer() const', 'mapUnitScale() const', 'setColor(const QColor &color)', 'setMapUnitScale(const QgsMapUnitScale &scale)', 'toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const', 'type() const'],
    "QgsSymbolLayer": ['QgsSymbolLayer(QgsSymbol::SymbolType type, bool locked=false)', 'drawPreviewIcon(QgsSymbolRenderContext &context, QSize size)=0', 'isLocked() const', 'mapUnitScale() const', 'ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const', 'renderingPass() const', 'setLocked(bool locked)', 'setMapUnitScale(const QgsMapUnitScale &scale)', 'setRenderingPass(int renderingPass)', 'startRender(QgsSymbolRenderContext &context)=0', 'stopRender(QgsSymbolRenderContext &context)=0', 'toSld(QDomDocument &doc, QDomElement &element, const QgsStringMap &props) const', 'type() const'],
    "QgsSymbolLayerAbstractMetadata": ['QgsSymbolLayerAbstractMetadata(const QString &name, const QString &visibleName, QgsSymbol::SymbolType type)', 'name() const', 'type() const', 'visibleName() const'],
    "QgsSymbolLayerUtils": ['clearSymbolMap(QgsSymbolMap &symbols)', 'convertPolygonSymbolizerToPointMarker(QDomElement &element, QgsSymbolLayerList &layerList)', 'createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)', 'createFillLayerFromSld(QDomElement &element)', 'createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)', 'createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)', 'createLineLayerFromSld(QDomElement &element)', 'createMarkerLayerFromSld(QDomElement &element)', 'createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)', 'createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)', 'createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)', 'createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)', 'createSymbolLayerListFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType, QgsSymbolLayerList &layers)', 'createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)', 'decodeBlendMode(const QString &s)', 'decodeBrushStyle(const QString &str)', 'decodeColor(const QString &str)', 'decodeMapUnitScale(const QString &str)', 'decodePenCapStyle(const QString &str)', 'decodePenJoinStyle(const QString &str)', 'decodePenStyle(const QString &str)', 'decodeRealVector(const QString &s)', 'decodeScaleMethod(const QString &str)', 'decodeSldAlpha(const QString &str)', 'decodeSldBrushStyle(const QString &str)', 'decodeSldFontStyle(const QString &str)', 'decodeSldFontWeight(const QString &str)', 'decodeSldLineCapStyle(const QString &str)', 'decodeSldLineJoinStyle(const QString &str)', 'decodeSldRealVector(const QString &s)', 'displacementFromSldElement(QDomElement &element, QPointF &offset)', 'drawStippledBackground(QPainter *painter, QRect rect)', 'encodeBrushStyle(Qt::BrushStyle style)', 'encodeColor(const QColor &color)', 'encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)', 'encodePenCapStyle(Qt::PenCapStyle style)', 'encodePenJoinStyle(Qt::PenJoinStyle style)', 'encodePenStyle(Qt::PenStyle style)', 'encodeRealVector(const QVector< qreal > &v)', 'encodeScaleMethod(QgsSymbol::ScaleMethod scaleMethod)', 'encodeSldAlpha(int alpha)', 'encodeSldBrushStyle(Qt::BrushStyle style)', 'encodeSldFontStyle(QFont::Style style)', 'encodeSldFontWeight(int weight)', 'encodeSldLineCapStyle(Qt::PenCapStyle style)', 'encodeSldLineJoinStyle(Qt::PenJoinStyle style)', 'encodeSldRealVector(const QVector< qreal > &v)', 'externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)', 'externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)', 'externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)', 'externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)', 'fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)', 'fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())', 'functionFromSldElement(QDomElement &element, QString &function)', 'geometryFromSldElement(QDomElement &element, QString &geomFunc)', 'getSvgParameterList(QDomElement &element)', 'getVendorOptionList(QDomElement &element)', 'hasExternalGraphic(QDomElement &element)', 'hasWellKnownMark(QDomElement &element)', 'labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)', 'lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)', 'needEllipseMarker(QDomElement &element)', 'needFontMarker(QDomElement &element)', 'needLinePatternFill(QDomElement &element)', 'needMarkerLine(QDomElement &element)', 'needPointPatternFill(QDomElement &element)', 'needSvgFill(QDomElement &element)', 'needSvgMarker(QDomElement &element)', 'onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)', 'opacityFromSldElement(QDomElement &element, QString &alphaFunc)', 'parseProperties(QDomElement &element)', 'rotationFromSldElement(QDomElement &element, QString &rotationFunc)', 'saveProperties(QgsStringMap props, QDomDocument &doc, QDomElement &element)', 'wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &strokeColor, Qt::PenStyle strokeStyle, double strokeWidth=-1, double size=-1)'],
    "QgsSymbolLayerWidget": ['setSymbolLayer(QgsSymbolLayer *layer)=0', 'symbolLayer()=0', 'updateDataDefinedProperty()'],
    "QgsSymbolLevelItem": ['QgsSymbolLevelItem(QgsSymbol *symbol, int layer)', 'layer()', 'symbol()'],
    "QgsSymbolLevelsDialog": ['setForceOrderingEnabled(bool enabled)'],
    "QgsSymbolRenderContext": ['mapUnitScale() const', 'outputLineWidth(double width) const', 'outputPixelSize(double size) const', 'selected() const', 'setFeature(const QgsFeature *f)', 'setMapUnitScale(const QgsMapUnitScale &scale)', 'setSelected(bool selected)'],
    "QgsSymbolSelectorDialog": ['addLayer()', 'currentLayer()', 'layerChanged()', 'loadSymbol()', 'lockLayer()', 'moveLayerByOffset(int offset)', 'moveLayerDown()', 'moveLayerUp()', 'removeLayer()', 'setWidget(QWidget *widget)', 'symbolModified()', 'updateLayerPreview()', 'updateLockButton()', 'updatePreview()', 'updateUi()'],
    "QgsSymbolsListWidget": ['addSymbolToStyle()', 'changed()', 'clipFeaturesToggled(bool checked)', 'openStyleManager()', 'saveSymbol()', 'setLineWidth(double width)', 'setMarkerAngle(double angle)', 'setMarkerSize(double size)', 'setSymbolColor(const QColor &color)', 'setSymbolFromStyle(const QModelIndex &index)', 'symbolAddedToStyle(const QString &name, QgsSymbol *symbol)', 'updateDataDefinedLineWidth()', 'updateDataDefinedMarkerAngle()', 'updateDataDefinedMarkerSize()'],
    "QgsTextDiagram": ['Orientation', 'Shape'],
    "QgsTextEditConfigDlg": ['QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)'],
    "QgsTextEditWidgetFactory": ['QgsTextEditWidgetFactory(const QString &name)'],
    "QgsTextEditWrapper": ['QgsTextEditWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsTotalCurvatureFilter": ['QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)'],
    "QgsTransaction": ['QgsTransaction(const QString &connString)'],
    "QgsTransformWidget": ['QgsTransformWidget(QWidget *parent=nullptr)', 'create()'],
    "QgsUniqueValueWidgetFactory": ['QgsUniqueValueWidgetFactory(const QString &name)'],
    "QgsUniqueValuesConfigDlg": ['QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)'],
    "QgsUniqueValuesWidgetWrapper": ['QgsUniqueValuesWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsUnitSelectionWidget": ['changed()'],
    "QgsUuidWidgetFactory": ['QgsUuidWidgetFactory(const QString &name)'],
    "QgsUuidWidgetWrapper": ['QgsUuidWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsValueMapConfigDlg": ['QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)', 'updateMap(const QMap< QString, QVariant > &map, bool insertNull)'],
    "QgsValueMapWidgetFactory": ['QgsValueMapWidgetFactory(const QString &name)'],
    "QgsValueMapWidgetWrapper": ['QgsValueMapWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsValueRelationConfigDlg": ['QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)', 'editExpression()'],
    "QgsValueRelationSearchWidgetWrapper": ['value() const'],
    "QgsValueRelationWidgetFactory": ['QgsValueRelationWidgetFactory(const QString &name)'],
    "QgsValueRelationWidgetWrapper": ['QgsValueRelationWidgetWrapper(QgsVectorLayer *vl, int fieldIdx, QWidget *editor=nullptr, QWidget *parent=nullptr)'],
    "QgsVectorDataProvider": ['convertValue(QVariant::Type type, const QString &value)'],
    "QgsVectorFieldSymbolLayer": ['AngleOrientation', 'AngleUnits', 'VectorFieldType', 'angleOrientation() const', 'angleUnits() const', 'create(const QgsStringMap &properties=QgsStringMap())', 'createFromSld(QDomElement &element)', 'distanceMapUnitScale() const', 'scale() const', 'setAngleOrientation(AngleOrientation orientation)', 'setAngleUnits(AngleUnits units)', 'setDistanceMapUnitScale(const QgsMapUnitScale &scale)', 'setScale(double s)', 'setVectorFieldType(VectorFieldType type)', 'setXAttribute(const QString &attribute)', 'setYAttribute(const QString &attribute)', 'vectorFieldType() const', 'xAttribute() const', 'yAttribute() const'],
    "QgsVectorFileWriter": ['OptionType', 'SymbologyExport', 'WriterError', 'driverMetadata(const QString &driverName, MetaData &driverMetadata)', 'setSymbologyExport(QgsVectorFileWriter::SymbologyExport symExport)', 'symbologyExport() const'],
    "QgsVectorFileWriter::BoolOption": ['BoolOption(const QString &docString, bool defaultValue)'],
    "QgsVectorFileWriter::HiddenOption": ['HiddenOption(const QString &value)'],
    "QgsVectorFileWriter::IntOption": ['IntOption(const QString &docString, int defaultValue)'],
    "QgsVectorFileWriter::Option": ['Option(const QString &docString, QgsVectorFileWriter::OptionType type)'],
    "QgsVectorFileWriter::SetOption": ['SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)'],
    "QgsVectorFileWriter::StringOption": ['StringOption(const QString &docString, const QString &defaultValue=QString())'],
    "QgsVectorLayer": ['diagramLayerSettings() const', 'diagramRenderer() const', 'setDiagramLayerSettings(const QgsDiagramLayerSettings &s)', 'vectorJoins() const'],
    "QgsVectorLayerCache": ['QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)'],
    "QgsVectorLayerEditBuffer": ['QgsVectorLayerEditBuffer(QgsVectorLayer *layer)', 'attributeAdded(int idx)', 'attributeDeleted(int idx)', 'attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)', 'committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)', 'committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)', 'committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)', 'committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)', 'committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)', 'featureAdded(QgsFeatureId fid)', 'featureDeleted(QgsFeatureId fid)', 'undoIndexChanged(int index)', 'updateFields(QgsFields &fields)', 'updateLayerFields()'],
    "QgsVectorLayerEditPassthrough": ['QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)'],
    "QgsVectorLayerEditUtils": ['QgsVectorLayerEditUtils(QgsVectorLayer *layer)'],
    "QgsVectorLayerFeatureIterator": ['QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)'],
    "QgsVectorLayerJoinBuffer": ['QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)', 'vectorJoins() const'],
    "QgsVectorLayerRenderer": ['QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)'],
    "QgsVectorLayerSelectionManager": ['QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)'],
    "QgsVertexId": ['QgsVertexId(int _part=-1, int _ring=-1, int _vertex=-1, VertexType _type=SegmentVertex)', 'VertexType', 'isValid(const QgsAbstractGeometry *geom) const', 'partEqual(QgsVertexId o) const', 'ringEqual(QgsVertexId o) const', 'vertexEqual(QgsVertexId o) const'],
    "QgsVertexMarker": ['QgsVertexMarker(QgsMapCanvas *mapCanvas)', 'setCenter(const QgsPointXY &point)', 'setIconSize(int iconSize)', 'setIconType(int iconType)', 'setPenWidth(int width)'],
    "QgsWkbException": ['QgsWkbException(QString const &what)'],
    "QgsWkbPtr": ['QgsWkbPtr(unsigned char *p, int size)', 'operator unsigned char *() const', 'operator+=(int n)', 'operator>>(QgsWkbTypes::Type &v) const', 'operator>>(char &v) const', 'operator>>(double &v) const', 'operator>>(float &r) const', 'operator>>(int &v) const', 'operator>>(unsigned int &v) const'],
    "QgsXmlUtils": ['readRectangle(const QDomElement &element)', 'writeRectangle(const QgsRectangle &rect, QDomDocument &doc)'],
    "QgsZipItem": ['QgsZipItem(QgsDataItem *parent, const QString &name, const QString &filePath, const QString &path)', 'QgsZipItem(QgsDataItem *parent, const QString &name, const QString &path)', 'getZipFileList()', 'iconZip()', 'vsiPrefix(const QString &uri)'],
    "TriDecorator": ['TriDecorator(Triangulation *t)'],
    "pal::CostCalculator": ['setPolygonCandidatesCost(int nblp, QList< LabelPosition * > &lPos, RTree< pal::FeaturePart *, double, 2, double > *obstacles, double bbx[4], double bby[4])'],
    "pal::FeaturePart": ['FeaturePart(const FeaturePart &other)', 'addSizePenalty(int nbp, QList< LabelPosition *> &lPos, double bbx[4], double bby[4])', 'getLabelDistance() const', 'getLabelHeight() const', 'getLabelWidth() const'],
    "pal::GeomFunction": ['cross_product(double x1, double y1, double x2, double y2, double x3, double y3)', 'dist_euc2d(double x1, double y1, double x2, double y2)', 'dist_euc2d_sq(double x1, double y1, double x2, double y2)', 'findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)'],
    "pal::LabelInfo": ['LabelInfo(int num, double height, double maxinangle=20.0, double maxoutangle=-20.0)'],
    "pal::LabelPosition": ['countFullOverlapCallback(LabelPosition *lp, void *ctx)', 'countOverlapCallback(LabelPosition *lp, void *ctx)', 'getHeight() const', 'getNextPart() const', 'getNumOverlaps() const', 'getPartId() const', 'getProblemFeatureId() const', 'getQuadrant() const', 'getReversed() const', 'getUpsideDown() const', 'getWidth() const', 'insertIntoIndex(RTree< LabelPosition *, double, 2, double > *index)', 'isInConflictMultiPart(LabelPosition *lp)', 'isInConflictSinglePart(LabelPosition *lp)', 'polygonObstacleCallback(pal::FeaturePart *obstacle, void *ctx)', 'removeFromIndex(RTree< LabelPosition *, double, 2, double > *index)', 'removeOverlapCallback(LabelPosition *lp, void *ctx)', 'resetNumOverlaps()', 'setNextPart(LabelPosition *next)', 'setPartId(int id)'],
    "pal::Layer": ['LabelMode', 'UpsideDownLabels', 'displayAll() const'],
    "pal::Pal": ['FnIsCanceled)(void *ctx)', 'solveProblem(Problem *prob, bool displayAll)'],
    "pal::PointSet": ['PointSet(const PointSet &ps)', 'PointSet(double x, double y)', 'PointSet(int nbPoints, double *x, double *y)', 'compute_chull_bbox()', 'createGeosGeom() const', 'deleteCoords()', 'extractShape(int nbPtSh, int imin, int imax, int fps, int fpe, double fptx, double fpty)', 'getBoundingBox(double min[2], double max[2]) const', 'getCentroid(double &px, double &py, bool forceInside=false) const', 'getGeosType() const', 'getNumPoints() const', 'invalidateGeos()', 'preparedGeom() const'],
    "pal::PolygonCostCalculator": ['PolygonCostCalculator(LabelPosition *lp)', 'getCost()', 'getLabel()', 'update(pal::PointSet *pset)'],
    "pal::PriorityQueue": ['decreaseKey(int key)', 'downheap(int id)', 'getBest()', 'getId(int key)', 'getSize()', 'getSizeByPos()', 'insert(int key, double p)', 'isIn(int key)', 'print()', 'remove(int key)', 'setPriority(int key, double new_p)', 'sort()', 'upheap(int key)'],
    "pal::Problem": ['compareLabelArea(pal::LabelPosition *l1, pal::LabelPosition *l2)', 'compute_feature_cost(SubPart *part, int feat_id, int label_id, int *nbOverlap)', 'compute_subsolution_cost(SubPart *part, int *s, int *nbOverlap)', 'getFeatureCandidate(int fi, int ci)', 'getFeatureCandidateCount(int i)', 'getNumFeatures()', 'getSolution(bool returnInactive)', 'getStats()', 'init_sol_falp()', 'initialization()', 'popmusic_tabu(SubPart *part)', 'reduce()', 'subPart(int r, int featseed, int *isIn)'],
    "pal::Util": ['unmulti(const GEOSGeometry *the_geom)']
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    "QgsDerivativeFilter",
    "QgsLayerTreeEmbeddedConfigWidget",
    "QgsCptCityDirectoryItem",
    "QgsDataDefinedRotationDialog",
    "QgsAttributeTypeLoadDialog",
    "QgsProject",
    "QgsDirectoryParamWidget",
    "QgsLegendModel",
    "QgsLayerTreeNode",
    "QgsSlopeFilter",
    "QgsPointLocator_VisitorArea",
    "pal::InternalException::Full",
    "QgsPluginLayer",
    "QgsGeometryValidator",
    "QgsLineSymbol",
    "QgsFeatureListViewDelegate",
    "QgsHighlight",
    "pal::Sol",
    "QgsServer",
    "QgsOSMXmlImport",
    "QgsDiagramLabelFeature",
    "QgsPanelWidgetStack",
    "QgsMapUnitScaleDialog",
    "QgsDoubleSpinBox",
    "QgsSingleBandPseudoColorRenderer",
    "QgsRasterLayerSaveAsDialog",
    "QgsSvgSelectorDialog",
    "QgsRendererRulePropsWidget",
    "QgsErrorItem",
    "QgsCheckboxWidgetFactory",
    "QgsComposerLayerItem",
    "Triangulation",
    "QgsGlowWidget",
    "QgsVectorFileWriter::Option",
    "QgsColorSwatchDelegate",
    "QgsTextEditWrapper",
    "QgsCaseInsensitiveLexerSQL",
    "QgsServerInterface",
    "QgsAuthMethodPlugins",
    "QgsMapSettings",
    "QgsLayerDefinition",
    "pal::InternalException::WrongGeometry",
    "QgsRasterDrawer",
    "QgsOgcUtils",
    "QgsMapLayerStyleManagerWidget",
    "QgsCoordinateTransformCache",
    "QgsRangeWidgetWrapper",
    "QgsFeatureIteratorDataStream",
    "QgsSimpleLineSymbolLayerWidget",
    "QgsContrastEnhancement",
    "QgsHillshadeFilter",
    "QgsCachedFeatureIterator",
    "QgsAuthCrypto",
    "QgsAuthSslErrorsDialog",
    "QgsRendererRegistry",
    "QgsExpression",
    "Node",
    "QgsFeatureListModel",
    "QgsAuthMethodMetadata",
    "QgsComposerScaleBar",
    "QgsExpression::Function",
    "QgsMultiBandColorRendererWidget",
    "QgsFeatureRequest::OrderByClause",
    "QgsColorWidgetAction",
    "Bezier3D",
    "QgsSQLStatement::NodeJoin",
    "QgsPoint",
    "QgsSLConnect",
    "QgsConditionalStyle",
    "QgsExpression::NodeList",
    "QgsSingleSymbolRendererWidget",
    "QgsDbFilterProxyModel",
    "QgsRasterShaderFunction",
    "QgsBrushStyleComboBox",
    "QgsSVGFillSymbolLayer",
    "QgsPluginLayerRegistry",
    "pal::PalException::UnknownFeature",
    "QgsMapLayerActionRegistry",
    "QgsMapToolIdentify",
    "QgsTableWidgetItem",
    "QgsFontMarkerSymbolLayerWidget",
    "QgsLabel",
    "QgsColorSwatchGridAction",
    "QgsRelation",
    "QgsVectorGradientColorRampDialog",
    "QgsSQLStatement::NodeBetweenOperator",
    "QgsScaleBarStyle",
    "QgsMapToolIdentifyFeature",
    "QgsMultiBandColorRenderer",
    "QgsGraphBuilderInterface",
    "QgsComposerHtml",
    "QgsRasterPyramidsOptionsWidget",
    "QgsColorRampShader",
    "QgsMapUnitScale",
    "pal::Util",
    "QgsGpsdConnection",
    "pal::PointSet",
    "QgsDateTimeEditWrapper",
    "NormVecDecorator",
    "Qgis",
    "QgsDetailedItemWidget",
    "QgsDataDefinedSizeDialog",
    "QgsDxfExport",
    "QgsIdentifyMenu",
    "QgsRendererRange",
    "QgsDiagramSettings",
    "QgsDataItemProviderRegistry",
    "QgsSymbolSelectorDialog",
    "QgsComposerFrame",
    "QgsFontMarkerSymbolLayer",
    "QgsSpinBox",
    "QgsAction",
    "QgsSQLComposerDialog::SQLValidatorCallback",
    "QgsGpsDetector",
    "QgsExpressionHighlighter",
    "QgsMapToPixelSimplifier",
    "QgsVectorColorBrewerColorRampDialog",
    "QgsCptCityAllRampsItem",
    "QgsOSMWay",
    "QgsLabelingEngineInterface",
    "QgsEditorConfigWidget",
    "QgsDataProvider",
    "QgsLayerTreeView",
    "QgsActionManager",
    "QgsSQLStatement::NodeColumnRef",
    "QgsLocaleNumC",
    "QgsRasterChecker",
    "QgsNumericScaleBarStyle",
    "QgsVectorLayerUndoCommandDeleteFeature",
    "QgsTextEditConfigDlg",
    "QgsOgcUtilsExprToFilter",
    "QgsOSMNode",
    "QgsAuthSslConfigWidget",
    "QgsPixmapLabel",
    "QgsAuthConfigIdEdit",
    "QgsVectorLayerTools",
    "QgsBlendModeComboBox",
    "QgsConstWkbSimplifierPtr",
    "QgsRelief",
    "QgsFeature",
    "QgsProjectBadLayerHandler",
    "QgsCptCityCollectionItem",
    "QgsGridFileWriter",
    "QgsVectorLayerUndoCommandDeleteAttribute",
    "QgsWebView",
    "QgsAbstractCacheIndex",
    "QgsIFeatureSelectionManager",
    "QgsInvertedPolygonRenderer",
    "QgsSQLComposerDialog",
    "QgsNetworkAccessManager",
    "QgsLayerPropertiesWidget",
    "QgsRasterRendererRegistry",
    "QgsRasterRendererWidget",
    "pal::PalException::FeatureExists",
    "QgsAttributeTableFilterModel",
    "QgsComposerView",
    "QgsVectorFileWriter::SetOption",
    "QgsLinearMinMaxEnhancementWithClip",
    "QgsMapCanvas::CanvasProperties",
    "QgsLabelFeature",
    "QgsSymbolLayer",
    "QgsMapRendererJob",
    "QgsQueryBuilder",
    "QgsSQLStatement::Visitor",
    "QgsCentroidFillSymbolLayer",
    "QgsTreeWidgetItem",
    "QgsSvgMarkerSymbolLayerWidget",
    "QgsSingleCategoryDiagramRenderer",
    "QgsSurface",
    "QgsOgcUtilsSQLStatementToFilter",
    "QgsPalettedRendererWidget",
    "QgsLabelSearchTree",
    "QgsSQLStatement::NodeTableDef",
    "QgsComposerUtils",
    "QgsRasterCalcNode",
    "QgsTextEditWidgetFactory",
    "QgsUniqueValueWidgetFactory",
    "QgsMapLayerAction",
    "QgsNumericSortTreeWidgetItem",
    "QgsPkiBundle",
    "QgsVectorLayerLabelProvider",
    "QgsTextAnnotationItem",
    "QgsPluginManagerInterface",
    "QgsFeatureListView",
    "QgsOSMDownload",
    "QgsAdvancedDigitizingDockWidget::CadConstraint",
    "QgsSimpleMarkerSymbolLayerWidget",
    "QgsTolerance",
    "QgsRasterLayer",
    "QgsComposerObject",
    "QgsMapHitTest",
    "QgsLegendRenderer",
    "QgsColorWidgetFactory",
    "QgsWidgetWrapper",
    "QgsRangeWidgetFactory",
    "QgsPointCompare",
    "QgsComposerAttributeTableCompareV2",
    "QgsCptCityColorRamp",
    "QgsAttributeEditorContext",
    "QgsSymbologyConversion",
    "QgsAttributeEditorRelation",
    "QgsPointDisplacementRendererWidget",
    "QgsOSMDatabase",
    "QgsAbstractGeometrySimplifier",
    "QgsComposerMapItem",
    "QgsProviderExtentCalcEvent",
    "pal::PolygonCostCalculator",
    "pal::Pal",
    "QgsMapRendererCustomPainterJob",
    "QgsExternalResourceWidget",
    "QgsRasterShader",
    "QgsOverlayAnalyzer",
    "QgsComposerLegend",
    "QgsCachedFeatureWriterIterator",
    "QgsComposerTextTable",
    "QgsNineCellFilter",
    "QgsSymbolLayerAbstractMetadata",
    "QgsPointLocator",
    "QgsAuthCertInfo",
    "QgsAttributeTableMapLayerAction",
    "QgsFeatureSelectionDlg",
    "QgsAuthConfigEdit",
    "QgsAuthMethodConfig",
    "QgsVectorLayerUndoCommandAddFeature",
    "QgsAuthConfigEditor",
    "QgsCharacterSelectorDialog",
    "QgsSpatialIndex",
    "QgsAbstractFeatureIterator",
    "QgsMapCanvasMap",
    "QgsShapeburstFillSymbolLayer",
    "QgsVectorLayerJoinBuffer",
    "QgsTextLabelFeature",
    "QgsPkiConfigBundle",
    "QgsCredentialsNone",
    "QgsPenCapStyleComboBox",
    "QgsAuthConfigSelect",
    "QgsFeatureRequest",
    "QgsExpression::NodeInOperator",
    "QgsTotalCurvatureFilter",
    "QgsGeometry",
    "QgsDummyConfigDlg",
    "QgsBrowserModel",
    "QgsRenderContext",
    "QgsSingleBandGrayRendererWidget",
    "QgsAttributeEditorElement",
    "QgsAbstractLabelProvider",
    "QgsSQLStatement::NodeInOperator",
    "QgsComposerGroupItem",
    "QgsLineSymbolLayer",
    "QgsSublayersDialog",
    "QgsMapOverviewCanvas",
    "QgsRasterRenderer",
    "QgsRelationReferenceFactory",
    "QgsContrastEnhancementFunction",
    "QgsMarkerSymbolLayer",
    "QgsGroupWmsDataDialog",
    "QgsVectorLayerInterruptionCheckerDuringCountSymbolFeatures",
    "QgsSymbolRenderContext",
    "QgsValueRelationSearchWidgetWrapper",
    "DualEdgeTriangulation",
    "QgsRasterFileWriter",
    "QgsGraphDirector",
    "QgsTransectSample",
    "QgsFeatureRenderer",
    "QgsExpressionBuilderDialog",
    "QgsMapLayer",
    "QgsOptionsDialogBase",
    "QgsGraphArc",
    "QgsMapCanvasLayer",
    "QgsErrorMessage",
    "QgsAuthImportIdentityDialog",
    "QgsExpressionItem",
    "pal::LabelInfo",
    "QgsStatisticalSummary",
    "pal::PalException::ValueNotInRange",
    "QgsRendererAbstractMetadata",
    "QgsLegendModel",
    "QgsSQLStatement::NodeLiteral",
    "QgsEnumerationWidgetWrapper",
    "pal::PalStat",
    "QgsRuleBasedRendererWidget",
    "QgsOfflineEditing",
    "GEOSGeomScopedPtr",
    "QgsIDWInterpolator",
    "QgsPointLocator_VisitorEdgesInRect",
    "QgsEffectStack",
    "QgsRasterTransparencyWidget",
    "QgsRasterPipe",
    "QgsSvgSelectorWidget",
    "QgsEditorWidgetFactory",
    "QgsExpressionContextScope",
    "QgsVectorLayerSimpleLabeling",
    "QgsLayerTreeEmbeddedWidgetRegistry",
    "QgsOSMTags",
    "QgsScaleUtils",
    "QgsDataCollectionItem",
    "QgsFeatureSelectionModel",
    "QgsSimpleMarkerSymbolLayer",
    "QgsRasterProjector",
    "QgsGradientFillSymbolLayer",
    "QgsAuthSslConfigDialog",
    "QgsEditorWidgetWrapper",
    "QgsDrawSourceWidget",
    "QgsOWSSourceSelect",
    "QgsException",
    "QgsAttributeTableDelegate",
    "QgsVectorLayerDiagramProvider",
    "QgsVectorLayerUndoCommandAddAttribute",
    "QgsDialog",
    "QgsAuthSslImportDialog",
    "QgsVectorColorRamp",
    "QgsCustomLayerOrderWidget",
    "QgsStyleGroupSelectionDialog",
    "QgsAdvancedDigitizingCanvasItem",
    "QgsComposerItemGroup",
    "pal::CostCalculator",
    "QgsAuthCertTrustPolicyComboBox",
    "QgsExtentGroupBox",
    "QgsValueRelationConfigDlg",
    "QgsVectorLayerImport",
    "QgsPenJoinStyleComboBox",
    "pal::InternalException::NoLabelPosition",
    "QgsDateTimeStatisticalSummary",
    "QgsNewVectorLayerDialog",
    "QgsLinearMinMaxEnhancement",
    "QgsComposerModel",
    "QgsSymbolLayerUtils",
    "QgsConstWkbPtr",
    "QgsLongLongValidator",
    "QgsSimpleFillSymbolLayerWidget",
    "QgsCptCityArchive",
    "QgsComposerArrow",
    "QgsAttributeFormLegacyInterface",
    "QgsProjectItem",
    "QgsMapToolEmitPoint",
    "QgsClassificationWidgetWrapperFactory",
    "QgsCollapsibleGroupBox",
    "Qgs25DRendererWidget",
    "QgsExpression::NodeColumnRef",
    "QgsComposition",
    "QgsMapCanvas",
    "QgsLayerTreeEmbeddedWidgetProvider",
    "QgsPaintEffect",
    "QgsHiddenWidgetFactory",
    "QgsLinePatternFillSymbolLayerWidget",
    "QgsComposerLegendItem",
    "QgsQtLocationConnection",
    "QgsUnitSelectionWidget",
    "QgsMapTip",
    "QgsGraphBuilder",
    "QgsMarkerSymbol",
    "QgsDiagramRenderer",
    "QgsExpression::NodeLiteral",
    "QgsNewGeoPackageLayerDialog",
    "pal::InternalException::UnknownGeometry",
    "QgsVectorColorBrewerColorRamp",
    "QgsProperty",
    "QgsDoubleBoxScaleBarStyle",
    "QgsPanelWidgetWrapper",
    "QgsBusyIndicatorDialog",
    "QgsSymbolSelectorWidget",
    "QgsPieDiagram",
    "QgsInternalGeometryEngine",
    "QgsMasterPasswordResetDialog",
    "QgsVectorFileWriter::StringOption",
    "QgsComposerItem",
    "QgsSvgAnnotationItem",
    "QgsOSMElement",
    "QgsSvgCacheEntry",
    "QgsCptCityBrowserModel",
    "QgsPointLocator_VisitorNearestVertex",
    "QgsCheckboxWidgetWrapper",
    "QgsAuthServersEditor",
    "QgsGradientFillSymbolLayerWidget",
    "QgsNetworkDiskCache",
    "QgsFillSymbolLayer",
    "QgsRendererRulePropsDialog",
    "QgsSymbolLevelsDialog",
    "QWebPage",
    "QgsPointLocator_VisitorNearestEdge",
    "QgsStringStatisticalSummary",
    "QgsLabelComponent",
    "QgsDateTimeEditFactory",
    "CharacterWidget",
    "QgsAdvancedDigitizingDockWidget",
    "QgsColorEffectWidget",
    "QgsCsException",
    "QgsMapLayerStyleManager",
    "QgsZipItem",
    "QgsComposerMultiFrameCommand",
    "QgsAttributeEditorField",
    "QgsMessageOutput",
    "QgsSQLStatement::NodeCast",
    "QgsCoordinateReferenceSystem",
    "QgsLayerTreeModelLegendNode",
    "QgsScaleVisibilityDialog",
    "QgsTransactionGroup",
    "QgsDistanceArea",
    "QgsLayerTreeGroup",
    "QgsMapToolPan",
    "QgsVectorLayerFeatureIterator",
    "QgsDxfPaintEngine",
    "QgsSvgMarkerSymbolLayer",
    "QgsCategorizedSymbolRendererWidget",
    "QgsAuthConfigSslServer",
    "QgsBrightnessContrastFilter",
    "QgsMultiRenderChecker",
    "QgsLabelSorter",
    "QgsComposerShape",
    "QgsLayerItem",
    "QgsAuthCertEditors",
    "QgsMapRendererParallelJob",
    "QgsRasterCalculator",
    "QgsStyle",
    "QgsLegacyHelpers",
    "QgsRuleBasedRenderer",
    "QgsDrawSourceEffect",
    "QgsLayerTreeLayer",
    "pal::PalException::NotImplemented",
    "QgsDxfLabelProvider",
    "QgsCptCitySelectionItem",
    "QgsRendererCategory",
    "QgsDataItem",
    "QgsComposerAttributeTableColumnModelV2",
    "QgsSQLStatement::NodeSelect",
    "QgsSymbolsListWidget",
    "QgsGraduatedSymbolRenderer",
    "QgsRasterPyramid",
    "QgsAnimatedIcon",
    "QgsDataItemProvider",
    "QgsScaleRangeWidget",
    "QgsEncodingFileDialog",
    "QgsProviderCountCalcEvent",
    "QgsDxfPaintDevice",
    "QgsRasterInterface",
    "QgsExternalResourceWidgetFactory",
    "QgsAuthIdentitiesEditor",
    "QgsValueMapConfigDlg",
    "QgsAbstractFeatureIteratorFromSource",
    "QgsDirectoryItem",
    "QgsRelationEditorWidget",
    "QgsColorBrewerPalette",
    "QgsTextDiagram",
    "QgsRuleBasedRendererModel",
    "QgsExpression::NodeFunction",
    "QgsAuthCertInfoDialog",
    "QgsColorWidgetWrapper",
    "QgsPenStyleComboBox",
    "QgsNewHttpConnection",
    "QgsExpression::NodeCondition",
    "QgsValueMapWidgetWrapper",
    "QgsZonalStatistics",
    "QgsRasterRange",
    "QgsSymbol",
    "QgsLegendInterface",
    "QgsTopologyPreservingSimplifier",
    "QgsInterpolator",
    "QgsVirtualLayerDefinition::SourceLayer",
    "QgsScaleComboBox",
    "QgsMessageLogConsole",
    "QgsMessageOutputConsole",
    "QgsImageOperation",
    "QgsRasterIdentifyResult",
    "QgsMapThemeCollection::PresetRecord",
    "QgsRunProcess",
    "QgsRasterIterator",
    "QgsExpression::StaticFunction",
    "QgsProjectionSelector",
    "QgsProjectVersion",
    "QgsFieldValidator",
    "QgsRasterFillSymbolLayerWidget",
    "QgsUserInputDockWidget",
    "QgsLabelAttributes",
    "QgsAuthCertUtils",
    "QgsSymbolLayerRegistry",
    "QgsSlider",
    "QgsColorSchemeList",
    "QgsLayerTreeModel",
    "QgsCategorizedSymbolRenderer",
    "QgsLinearlyInterpolatedDiagramRenderer",
    "QgsOwsConnection",
    "QgsGenericProjectionSelector",
    "QgsColorSchemeModel",
    "QgsBlurWidget",
    "QgsSQLStatement::NodeColumnSorted",
    "QgsNewMemoryLayerDialog",
    "QgsFileDropEdit",
    "QgsRelationReferenceConfigDlg",
    "QgsComposerMergeCommand",
    "QgsApplication",
    "QgsDateTimeEdit",
    "QgsDxfRuleBasedLabelProvider",
    "Line3D",
    "QgsAuthGuiUtils",
    "QgsVectorLayerRendererInterruptionChecker",
    "pal::Problem",
    "QgsComposerStyleItem",
    "QgsValueMapSearchWidgetWrapper",
    "QgsPalettedRasterRenderer",
    "QgsArcProperter",
    "QgsWkbException",
    "QgsRuntimeProfiler",
    "QgsSvgSelectorGroupsModel",
    "QgsSingleBandGrayRenderer",
    "QgsCubicRasterResampler",
    "QgsEllipseSymbolLayerWidget",
    "QgsField",
    "QgsCheckBoxConfigDlg",
    "ParametricLine",
    "QgsDiagram",
    "QgsCredentialsConsole",
    "QgsLogger",
    "QgsEllipseSymbolLayer",
    "QgsMapServiceException",
    "pal::Feats",
    "QgsArrowSymbolLayerWidget",
    "QgsVectorLayerEditBuffer",
    "QgsEditFormConfig",
    "QgsEnumerationWidgetFactory",
    "QgsGraphVertex",
    "QgsVector",
    "QgsComposerTable",
    "QgsDataDefinedWidthDialog",
    "QgsRectangle",
    "QgsSQLStatement::Node",
    "QgsTransaction",
    "QgsComposerTableColumn",
    "QgsMarkerLineSymbolLayerWidget",
    "QgsHttpTransaction",
    "QgsImageFillSymbolLayer",
    "QgsBilinearRasterResampler",
    "QgsNetworkReplyParser",
    "QgsRenderChecker",
    "QgsFeatureIterator",
    "pal::LabelPosition",
    "QgsExpressionSelectionDialog",
    "QgsAuthImportCertDialog",
    "QgsSymbolLayerWidget",
    "QgsColorDialog",
    "QgsLabelPosition",
    "QgsDiagramLayerSettings",
    "QgsAnnotationItem",
    "QgsStyleExportImportDialog",
    "QgsHeatmapRendererWidget",
    "QgsLabelCandidate",
    "QgsLegendSettings",
    "QgsColorRampComboBox",
    "QgisPlugin",
    "QgsRasterResampleFilter",
    "QgsMapLayerStyle",
    "QgsCoordinateTransform",
    "QgsSizeScaleWidget",
    "QgsPluginLayerType",
    "QgsClipper",
    "pal::GeomFunction",
    "QgsMapToolZoom",
    "QgsLUDialog",
    "QgsScopeLogger",
    "QgsMapMouseEvent",
    "QgsMapToolEdit",
    "QgsTicksScaleBarStyle",
    "QgsFavouritesItem",
    "QgsMapRendererQImageJob",
    "QgsGraphAnalyzer",
    "QgsMessageLog",
    "QgsExpressionContext",
    "QgsSingleSymbolRenderer",
    "QgsMapRenderer",
    "QgsPointLocator_Stream",
    "QgsGroupBoxCollapseButton",
    "QgsCredentials",
    "QgsSnappingUtils",
    "QgsDistanceArcProperter",
    "QgsVectorLayerEditUtils",
    "QgsHistogramDiagram",
    "QgsVectorFileWriter",
    "QgsDateTimeEditConfig",
    "QgsUuidWidgetFactory",
    "QgsMapRendererSequentialJob",
    "QgsLinePatternFillSymbolLayer",
    "QgsPointSample",
    "QgsObjectCustomProperties",
    "QgsRelationReferenceWidgetWrapper",
    "QgsMapToolAdvancedDigitizing",
    "QgsValueRelationWidgetFactory",
    "QgsGraduatedSymbolRendererWidget",
    "QgsComposerItemCommand",
    "QgsBrowserWatcher",
    "pal::PalException",
    "QgsIndexedFeature",
    "QgsPropertyKey",
    "QgsMessageViewer",
    "QgsShadowEffectWidget",
    "QgsEditorWidgetRegistry",
    "QgsColorSwatchGrid",
    "QgsDataDefinedValueDialog",
    "QgsGmlStreamingParser::LayerProperties",
    "QgsSmartGroupCondition",
    "QgsAuthEditorWidgets",
    "QgsFileWidget",
    "QgsFeatureModel",
    "QgsExpressionItemSearchProxy",
    "QgsRuleBasedLabeling",
    "QgsRendererMetadata",
    "QgsExpressionBuilderWidget",
    "pal::Layer",
    "QgsSingleBandColorDataRenderer",
    "QgsMapCanvasItem",
    "QgsGmlFeatureClass",
    "QgsVectorFieldSymbolLayer",
    "HalfEdge",
    "QgsAuthMethodRegistry",
    "QgsGraph",
    "QgsSingleBoxScaleBarStyle",
    "pal::InternalException",
    "QgsPalLayerSettings",
    "TriangleInterpolator",
    "QgsCptCityColorRampItem",
    "QgsPaintEngineHack",
    "QgsLineVectorLayerDirector",
    "QgsSVGFillSymbolLayerWidget",
    "QgsGradientStop",
    "QgsDualView",
    "QgsSpatialIndexCopyVisitor",
    "QgsVectorGradientColorRamp",
    "QgsNMEAConnection",
    "QgsAttributeDialog",
    "QgsProjectBadLayerGuiHandler",
    "QgsComposerMouseHandles",
    "QgsAuthCertManager",
    "QgsGeometryCache",
    "QgsAccessControlFilter",
    "QgsVectorDataProvider",
    "QgsSQLStatement::RecursiveVisitor",
    "QgsAuthTrustedCAsDialog",
    "pal::FeaturePart",
    "QgsError",
    "QgsComposerTableSortColumnsProxyModel",
    "QgsRasterHistogramWidget",
    "QgsOSMNodeIterator",
    "pal::PalException::LayerExists",
    "QgsMessageBar",
    "QgsUuidWidgetWrapper",
    "QgsExpression::Node",
    "QgsUniqueValuesWidgetWrapper",
    "pal::InternalException::Empty",
    "QgisVisitor",
    "QgsVectorLayerUndoCommandChangeAttribute",
    "QgsFormAnnotationItem",
    "QgsConnectionPool",
    "QgsGpsConnectionRegistry",
    "QgsExpression::NodeBinaryOperator",
    "QgsAttributeEditor",
    "QgsSingleBandPseudoColorRendererWidget",
    "QgsVectorLayerUndoCommandChangeGeometry",
    "QgsGenericFeatureSelectionManager",
    "QgsExternalResourceConfigDlg",
    "QgsWkbPtr",
    "QgsSymbolLayerMetadata",
    "QgsDiagramInterpolationSettings",
    "QgsRasterBandStats",
    "QgsSQLStatement::NodeBinaryOperator",
    "QgsPanelWidget",
    "QgsRasterResampler",
    "QgsRelationManager",
    "QgsGeometry::Error",
    "QgsMessageLogViewer",
    "QgsVectorLayer",
    "QgsSpatialIndexData",
    "QgsComposerRuler",
    "QgsPointPatternFillSymbolLayerWidget",
    "QgsCptCityDataItem",
    "QgsRandomColors",
    "QgsGeometryAnalyzer",
    "QgsVectorRandomColorRamp",
    "QgsComposerMultiFrame",
    "QgsValueMapWidgetFactory",
    "QgsXmlUtils",
    "QgsAlignRaster",
    "QgsVectorFileWriter::BoolOption",
    "QgsPalLabeling",
    "QgsRendererPropertiesDialog",
    "QgsMessageBarItem",
    "QgsRasterMinMaxWidget",
    "QgsServerFilter",
    "QgsVectorRandomColorRampDialog",
    "QgsAttributeTableAction",
    "QgsMarkerLineSymbolLayer",
    "QgsHtmlAnnotationItem",
    "QgsVectorLayerFeatureSource",
    "QgsAtlasComposition",
    "QgsSQLComposerDialog::TableSelectedCallback",
    "QgsConnectionPoolGroup",
    "QgisInterface",
    "QgsFillSymbol",
    "QgsPointPatternFillSymbolLayer",
    "QgsComposerMap",
    "QgsSourceSelectItemDelegate",
    "LinTriangleInterpolator",
    "QgsDefaultSearchWidgetWrapper",
    "QgsAttributes",
    "QgsSQLStatementCollectTableNames",
    "QgsComposerSymbolItem",
    "QgsLayerDefinition::DependencySorter",
    "QWebFrame",
    "QgsRaster",
    "QgsDial",
    "QgsRubberBand",
    "QgsConditionalLayerStyles",
    "QgsCacheIndexFeatureId",
    "QgsCptCityColorRampDialog",
    "QgsFilterLineEdit",
    "QgsNetworkContentFetcher",
    "QgsComposerPicture",
    "QgsExpression::WhenThen",
    "QgsSimpleLineSymbolLayer",
    "QgsClipToMinMaxEnhancement",
    "QgsAddRemoveMultiFrameCommand",
    "QgsFields",
    "QgsGeometryGeneratorSymbolLayerWidget",
    "pal::PalException::UnknownLayer",
    "QgsAttributeTableModel",
    "QgsMapLayerRenderer",
    "QgsDetailedItemData",
    "QgsMapTool",
    "QgsVectorLayerUndoCommand",
    "QgsComposerMultiFrameMergeCommand",
    "QgsRequestHandler",
    "QgsAddRemoveItemCommand",
    "QgsAuthManager",
    "QgsGroupUngroupItemsCommand",
    "QgsPaperItem",
    "QgsSQLStatement::NodeList",
    "QgsSvgCache",
    "QgsDatumTransformDialog",
    "QgsFieldExpressionWidget",
    "QgsCollapsibleGroupBoxBasic",
    "QgsHiddenWidgetWrapper",
    "QgsCredentialDialog",
    "QgsScaleCalculator",
    "QgsVectorFileWriter::HiddenOption",
    "QgsVectorLayerEditPassthrough",
    "QgsSymbolLevelItem",
    "QgsVertexMarker",
    "QgsRasterFormatSaveOptionsWidget",
    "QgsValueRelationWidgetWrapper",
    "QgsComposerAttributeTableCompare",
    "QgsRuggednessFilter",
    "QgsTrackedVectorLayerTools",
    "QgsLayerTreeMapCanvasBridge",
    "QgsMapToolCapture",
    "QgsSearchWidgetWrapper",
    "QgsDetailedItemDelegate",
    "QgsRasterMatrix",
    "QgsGpsConnection",
    "QgsMapCanvasTracer",
    "QgsComposerAttributeTable",
    "QgsSQLStatement::NodeSelectedColumn",
    "QgsGeos",
    "QgsRelationWidgetWrapper",
    "QgsColorButton",
    "QgsSvgSelectorListModel",
    "QgsGmlSchema",
    "QgsErrorDialog",
    "QgsComposerTableSortColumnsProxyModelV2",
    "QgsSourceSelectDialog",
    "QgsMapToPixel",
    "Vector3D",
    "QgsGeometryGeneratorSymbolLayer",
    "QgsAttributeEditorContainer",
    "pal::PriorityQueue",
    "QgsLegendStyle",
    "QgsRasterDataProvider",
    "QgsProjectBadLayerDefaultHandler",
    "QgsPropertyValue",
    "QgsVectorFileWriter::IntOption",
    "QgsRasterBlock",
    "QgsRasterNuller",
    "QgsPythonRunner",
    "QgsSQLStatement::NodeFunction",
    "QgsSQLStatement::NodeUnaryOperator",
    "QgsSearchQueryBuilder",
    "QgsOSMWayIterator",
    "QgsVirtualLayerDefinitionUtils",
    "QgsAttributeForm",
    "QgsVirtualLayerDefinition",
    "QgsAspectFilter",
    "QgsManageConnectionsDialog",
    "QgsRasterTransparency",
    "QgsCapabilitiesCache",
    "Qgs25DRenderer",
    "QgsMapCanvasRendererSync",
    "QgsRendererRasterPropertiesWidget",
    "QgsVectorLayerCache",
    "QgsAuthConfigUriEdit",
    "QgsProjectFileTransform",
    "QgsFontUtils",
    "QgsLayerTreeRegistryBridge",
    "QgsPreviewEffect",
    "QgsRasterHistogram",
    "QgsComposerEffect",
    "QgsRuleBasedLabelProvider",
    "QgsPoint",
    "QgsRangeConfigDlg",
    "QgsShapeburstFillSymbolLayerWidget",
    "QgsSimpleFillSymbolLayer",
    "QgsVectorFieldSymbolLayerWidget",
    "QgsClassificationWidgetWrapper",
    "CloughTocherInterpolator",
    "QgsUniqueValuesConfigDlg",
    "QgsLabelingEngine",
    "QgsMimeDataUtils",
    "QgsTransformWidget",
    "QgsExpression::NodeUnaryOperator",
    "QgsStyleManagerDialog",
    "QgsAttributeTableView",
    "QgsAttributeFormInterface",
    "QgsFeatureStore",
    "QgsExternalResourceWidgetWrapper",
    "TriDecorator",
    "QgsAuthMethodEdit",
    "QgsRelation::FieldPair",
    "QgsTINInterpolator",
    "QgsScaleWidget",
    "QgsDataItemProviderFromPlugin",
    "QgsExpression::Visitor",
    "QgsGeometryRubberBand",
    "QgsComposerAttributeTableV2",
    "QgsCentroidFillSymbolLayerWidget",
    "QgsRendererWidget",
    "QgsComposerLabel",
    "QgsRuleBasedRenderer::Rule",
    "QgsMapRendererCache",
    "QgsDataSourceUri",
    "QgsVectorLayerSelectionManager",
    "QgsPaperGrid",
    "QgsDashSpaceDialog",
    "QgsPointDisplacementRenderer",
    "QgsSmartGroupEditorDialog",
    "QgsMapToolTouch",
    "QgsComposerRasterSymbolItem",
    "QgsComposerAttributeTableColumnModel",
    "QgsGml",
    "QgsAuthAuthoritiesEditor",
    "QgsHueSaturationFilter",
    "QgsRelationReferenceWidget",
    "QWebSettings",
    "QgsPointLocator_DumpTree",
    "QgsProviderRegistry",
    "QgsProviderMetadata",
    "QgsApplyDialog",
    "QgsRuleBasedLabeling::Rule",
    "QgsActionMenu",
    "QgsAuthMethod",
    "QgsDartMeasurement",
    "QgsExpressionNode::NodeList",
    "QgsExpressionFunction",
    "QgsExpressionNode",
    "QgsExpressionNodeBinaryOperator",
    "QgsExpressionNodeColumnRef",
    "QgsExpressionNodeCondition",
    "QgsExpressionNodeFunction",
    "QgsExpressionNodeInOperator",
    "QgsExpressionNodeLiteral",
    "QgsExpressionNodeUnaryOperator",
    "QgsStaticExpressionFunction",
    "QgsExpressionNodeCondition::WhenThen"
]

ACCEPTABLE_MISSING_BRIEF = ['QgsBrushStyleComboBox',
                            'QgsHiddenWidgetFactory',
                            'QgsLabelCandidate',
                            'QgsIDWInterpolator',
                            'QgsFeatureSelectionModel',
                            'QgsColorWidgetFactory',
                            'QgsFieldValidator',
                            'QgsPointCompare',
                            'QgsSvgSelectorWidget',
                            'QgsGeometryGeneratorSymbolLayer',
                            'QgsSurface',
                            'QgsSvgAnnotationItem',
                            'QgsCptCityColorRampDialog',
                            'QgsRangeConfigDlg',
                            'QgsAttributeFormInterface',
                            'QgsExpression::NodeUnaryOperator',
                            'QgsSymbolLayerWidget',
                            'pal::PriorityQueue',
                            'QgsVectorLayerEditUtils',
                            'QgsArcProperter',
                            'QgsSimpleMarkerSymbolLayerWidget',
                            'QgsBrowserWatcher',
                            'QgsRandomColors',
                            'QgsVectorLayerEditPassthrough',
                            'QgsDial',
                            'QgsVectorColorBrewerColorRampDialog',
                            'QgsFontMarkerSymbolLayerWidget',
                            'QgsSymbolLevelItem',
                            'QgsGroupBoxCollapseButton',
                            'QgsVectorFieldSymbolLayerWidget',
                            'QgsCentroidFillSymbolLayerWidget',
                            'QgsEnumerationWidgetWrapper',
                            'QgsError',
                            'QgsRendererRangeLabelFormat',
                            'QgsMimeDataUtils',
                            'QgsRangeWidgetFactory',
                            'QgsCptCityArchive',
                            'QgsRasterRendererWidget',
                            'QgsGmlSchema',
                            'HalfEdge',
                            'QgsDateTimeEditFactory',
                            'QgsVectorFileWriter::BoolOption',
                            'QgsRasterFillSymbolLayerWidget',
                            'QgsVectorRandomColorRampDialog',
                            'QgsSymbolRenderContext',
                            'QgsErrorDialog',
                            'QgsExpressionHighlighter',
                            'QgsExpression::NodeLiteral',
                            'pal::CostCalculator',
                            'QgsFillSymbolLayer',
                            'QgsMultiBandColorRendererWidget',
                            'QgsRuleBasedLabeling::Rule',
                            'QgsSpatialIndexCopyVisitor',
                            'QgsSVGFillSymbolLayerWidget',
                            'QgsDataDefinedWidthDialog',
                            'QgsShapeburstFillSymbolLayer',
                            'QgsLegacyHelpers',
                            'QgsLineSymbolLayer',
                            'QgsWkbPtr',
                            'QgsSymbolLayer',
                            'QgsVectorFileWriter::StringOption',
                            'QgsSymbolLevelsDialog',
                            'QgsPenJoinStyleComboBox',
                            'QgsValueRelationWidgetFactory',
                            'QgsGlowWidget',
                            'QgsDummyConfigDlg',
                            'QgsExpression::NodeFunction',
                            'QgsSvgSelectorGroupsModel',
                            'QgsAttributeTypeLoadDialog',
                            'QgsDirectoryParamWidget',
                            'QgsCategorizedSymbolRenderer',
                            'QgsQtLocationConnection',
                            'QgsPropertyKey',
                            'QgsRuntimeProfiler',
                            'QgsVectorFileWriter::Option',
                            'QgsSymbol',
                            'QgsRendererRange',
                            'QgsRasterCalcNode',
                            'QgsMessageBarItem',
                            'QgsVectorFileWriter::SetOption',
                            'QgsCacheIndexFeatureId',
                            'QgsRasterProjector',
                            'QgsPropertyValue',
                            'QgsAttributeTableFilterModel',
                            'QgsSingleSymbolRendererWidget',
                            'QgsValueMapConfigDlg',
                            'QgsSmartGroupCondition',
                            'QgsMarkerLineSymbolLayerWidget',
                            'QgsExpression::NodeList',
                            'QgsSymbolSelectorDialog',
                            'QgsPalLayerSettings',
                            'QgsTextEditConfigDlg',
                            'QgsWkbException',
                            'QgsSingleBandPseudoColorRendererWidget',
                            'QgsRuleBasedLabeling',
                            'QgsDxfExport',
                            'pal::GeomFunction',
                            'QgsRasterLayerSaveAsDialog',
                            'QgsStyle',
                            'QgsSizeScaleWidget',
                            'QgsSymbolsListWidget',
                            'QgsFontMarkerSymbolLayer',
                            'QgsLUDialog',
                            'QgsLegendInterface',
                            'QgsSublayersDialog',
                            'QgsDrawSourceWidget',
                            'QgsSingleBandGrayRendererWidget',
                            'QgsRelationEditorWidget',
                            'QgsFeatureSelectionDlg',
                            'QgsDataDefinedRotationDialog',
                            'QgsRendererPropertiesDialog',
                            'QgsDistanceArcProperter',
                            'QgsComposerLayerItem',
                            'QgsRelationReferenceFactory',
                            'QgsLongLongValidator',
                            'QgsExpression::WhenThen',
                            'QgsVectorFileWriter::IntOption',
                            'QgsUniqueValueWidgetFactory',
                            'QgsRelationReferenceWidget',
                            'QgsSLConnect',
                            'pal::LabelPosition',
                            'Node',
                            'QgsRendererRulePropsDialog',
                            'Qgs25DRendererWidget',
                            'QgsPalLabeling',
                            'QgsTextDiagram',
                            'QgsMapToolCapture',
                            'QgsConstWkbSimplifierPtr',
                            'QgsTextEditWidgetFactory',
                            'QgsNewVectorLayerDialog',
                            'QgsLogger',
                            'CharacterWidget',
                            'QgsPointDisplacementRendererWidget',
                            'QgsProjectFileTransform',
                            'QgsExpression::NodeInOperator',
                            'QgsLocaleNumC',
                            'QgsDatumTransformDialog',
                            'QgsColorRampComboBox',
                            'QgsGeometryValidator',
                            'QgsValueRelationConfigDlg',
                            'QgsComposerSymbolItem',
                            'QgsScaleRangeWidget',
                            'QgsPieDiagram',
                            'QgsVectorGradientColorRampDialog',
                            'QgsPluginManagerInterface',
                            'QgsAttributeTableMapLayerAction',
                            'QgsConstWkbPtr',
                            'QgsStyleExportImportDialog',
                            'QgsBrowserModel',
                            'QgsUniqueValuesConfigDlg',
                            'QgsStyleGroupSelectionDialog',
                            'QgsScaleVisibilityDialog',
                            'QgsSpatialIndex',
                            'QgsFeatureModel',
                            'QgsSvgMarkerSymbolLayerWidget',
                            'QgsFeatureListModel',
                            'QgsDataDefinedSizeDialog',
                            'QgsColorEffectWidget',
                            'QgsComposerStyleItem',
                            'QgsWebPage',
                            'QgsRelationReferenceConfigDlg',
                            'QgsVectorLayerEditBuffer',
                            'QgsGraduatedSymbolRendererWidget',
                            'QgsSimpleLineSymbolLayer',
                            'QgsSingleSymbolRenderer',
                            'QgsComposerHtml',
                            'QgisInterface',
                            'QgsRuleBasedLabelProvider',
                            'QgsPointPatternFillSymbolLayer',
                            'QgsGradientFillSymbolLayer',
                            'QgsLinearlyInterpolatedDiagramRenderer',
                            'QgsGradientFillSymbolLayerWidget',
                            'QgsSlider',
                            'QgsPointPatternFillSymbolLayerWidget',
                            'QgsAttributeForm',
                            'pal::Sol',
                            'QgsCptCityColorRamp',
                            'QgsComposerMultiFrameCommand',
                            'QgsSimpleLineSymbolLayerWidget',
                            'QgsValueMapWidgetFactory',
                            'QgsRelation',
                            'QgsInvertedPolygonRenderer',
                            'QgsExpression::Node',
                            'QgsTransformWidget',
                            'QgsGroupWmsDataDialog',
                            'QgsColorBrewerPalette',
                            'LinTriangleInterpolator',
                            'QgsFontUtils',
                            'QgsDxfPaintEngine',
                            'QgsPenStyleComboBox',
                            'QgsRendererRulePropsWidget',
                            'QgsSimpleFillSymbolLayer',
                            'QgsExpression::NodeCondition',
                            'QgsClassificationWidgetWrapperFactory',
                            'QgsClassificationWidgetWrapper',
                            'QgsErrorMessage',
                            'QgsRelationWidgetWrapper',
                            'Qgs25DRenderer',
                            'QgsTrackedVectorLayerTools',
                            'QgsSymbolLayerUtils',
                            'QgsComposerRasterSymbolItem',
                            'QgsPoint',
                            'QgsGeometryGeneratorSymbolLayerWidget',
                            'QgsVectorLayerFeatureIterator',
                            'QgsFeatureRenderer',
                            'QgsRasterMinMaxWidget',
                            'QgsDateTimeEditConfig',
                            'QgsSvgCacheEntry',
                            'QgsShapeburstFillSymbolLayerWidget',
                            'QgsMapLayerConfigWidgetFactory',
                            'QgsManageConnectionsDialog',
                            'QgsSvgSelectorListModel',
                            'QgsMarkerLineSymbolLayer',
                            'QgsScopeLogger',
                            'QgsExpression::NodeColumnRef',
                            'QgsCheckBoxConfigDlg',
                            'QgsDockWidget',
                            'QgsUuidWidgetFactory',
                            'QgsFeatureListViewDelegate',
                            'QgsOfflineEditing',
                            'QgsLabelPosition',
                            'QgsEnumerationWidgetFactory',
                            'QgsLinePatternFillSymbolLayerWidget',
                            'QgsSvgSelectorDialog',
                            'QgsGeometryCache',
                            'QgsRuleBasedRendererWidget',
                            'QgsScaleUtils',
                            'QgsMarkerSymbol',
                            'QgsPalettedRendererWidget',
                            'QgsPenCapStyleComboBox',
                            'QgsVectorFileWriter::HiddenOption',
                            'QgsExternalResourceWidgetFactory',
                            'QgsComposerGroupItem',
                            'QgsAttributeTableAction',
                            'QgsEditFormConfig',
                            'QgsCategorizedSymbolRendererWidget',
                            'QgsNewMemoryLayerDialog',
                            'QgsEllipseSymbolLayerWidget',
                            'QgsExpression::NodeBinaryOperator',
                            'QgsCentroidFillSymbolLayer',
                            'DualEdgeTriangulation',
                            'QgsLineSymbol',
                            'QgsHillshadeFilter',
                            'QgsServerInterface',
                            'QgsLayerPropertiesWidget',
                            'QgsLinePatternFillSymbolLayer',
                            'QgsAttributeDialog',
                            'QgsGeometry::Error',
                            'QgsRasterMatrix',
                            'QgsComposerEffect',
                            'QgsArrowSymbolLayerWidget',
                            'QgsFillSymbol',
                            'QgsVectorLayerSelectionManager',
                            'pal::PointSet',
                            'QgsSimpleFillSymbolLayerWidget',
                            'ParametricLine',
                            'QgsGraduatedSymbolRenderer',
                            'QgsExternalResourceConfigDlg',
                            'QgsHistogramDiagram',
                            'QgsBlurWidget',
                            'QgsShadowEffectWidget',
                            'QgsRendererRasterPropertiesWidget',
                            'QgsVectorColorBrewerColorRamp',
                            'QgsTransactionGroup',
                            'pal::Util',
                            'QgsDartMeasurement',
                            'QgsSvgMarkerSymbolLayer',
                            'QgsAlignRaster',
                            'QgsCheckboxWidgetFactory',
                            'QgsAddRemoveMultiFrameCommand',
                            'QgsCptCityBrowserModel',
                            'QgsSmartGroupEditorDialog',
                            'QgsHeatmapRendererWidget',
                            'QgsStyleManagerDialog']


if __name__ == '__main__':
    for k in sorted(list(ACCEPTABLE_MISSING_DOCS.keys())):
        print('    "{}": {},'.format(k, sorted(ACCEPTABLE_MISSING_DOCS[k])))
