# -*- coding: utf-8 -*-

"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'

ACCEPTABLE_MISSING_DOCS = {
    "QgsDial": ["variantValue() const", "setMaximum(const QVariant &max)", "valueChanged(const QVariant &)", "setSingleStep(const QVariant &step)", "setValue(const QVariant &value)", "setMinimum(const QVariant &min)"],
    "QgsMapLayerAction": ["Target"],
    "QgsSvgSelectorGroupsModel": ["QgsSvgSelectorGroupsModel(QObject *parent)"],
    "QgsLinePatternFillSymbolLayer": ["ogrFeatureStyleWidth(double widthScaleFactor) const"],
    "QgsImageFillSymbolLayer": ["applyDataDefinedSettings(QgsSymbolRenderContext &context)"],
    "QgsDiagramLayerSettings": ["Placement"],
    "QgsRenderChecker": ["matchPercent()", "matchTarget()", "mismatchCount()", "controlImagePath() const", "report()", "setControlPathSuffix(const QString &name)", "setElapsedTimeTarget(int target)", "setRenderedImage(const QString &imageFileName)", "elapsedTime()"],
    "pal::FeaturePart": ["FeaturePart(const FeaturePart &other)"],
    "QgsRasterResampleFilter": ["zoomedOutResampler() const", "QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)", "maxOversampling() const", "zoomedInResampler() const", "setMaxOversampling(double os)"],
    "QgsMarkerSymbol": ["scaleMethod()", "setScaleMethod(QgsSymbol::ScaleMethod scaleMethod)"],
    "QgsLinearlyInterpolatedDiagramRenderer": ["setUpperSize(QSizeF s)", "setUpperValue(double val)", "setDiagramSettings(const QgsDiagramSettings &s)", "setLowerSize(QSizeF s)", "classificationAttributeIsExpression() const", "classificationAttributeExpression() const", "setClassificationAttributeIsExpression(bool isExpression)", "lowerValue() const", "upperValue() const", "lowerSize() const", "upperSize() const", "setLowerValue(double val)", "setClassificationAttributeExpression(const QString &expression)"],
    "QgsTextDiagram": ["Orientation", "Shape"],
    "QgsShapeburstFillSymbolLayer": ["QgsShapeburstFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, ShapeburstColorType colorType=SimpleTwoColor, int blurRadius=0, bool useWholeShape=true, double maxDistance=5)", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "ShapeburstColorType", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "offsetMapUnitScale() const", "distanceMapUnitScale() const"],
    "QgsCptCityArchive": ["archiveRegistry()", "descFileName(const QString &dirName) const", "rootItems() const", "initArchive(const QString &archiveName, const QString &archiveBaseDir)", "copyingInfo(const QString &fileName)", "findFileName(const QString &target, const QString &startDir, const QString &baseDir)", "archiveName() const", "description(const QString &fileName)", "initArchives(bool loadAll=false)", "copyingFileName(const QString &dirName) const", "initDefaultArchive()", "clearArchives()", "baseDir(QString archiveName)", "selectionItems() const", "isEmpty()", "baseDir() const", "defaultArchive()", "defaultBaseDir()", "QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())", "setBaseDir(const QString &dirName)"],
    "QgsAspectFilter": ["QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsValueRelationConfigDlg": ["QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)", "editExpression()"],
    "QgsGeometryMultipartCheck": ["ResolutionMethod", "QgsGeometryMultipartCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsFillSymbol": ["setAngle(double angle)"],
    "QgsDataDefinedValueDialog": ["dataDefinedChanged()"],
    "QgisVisitor": ["QgisVisitor(QList< QgsFeatureId > &list)"],
    "QgsLabelCandidate": ["QgsLabelCandidate(const QRectF &r, double c)"],
    "QgsGeometrySliverPolygonCheck": ["factoryId()", "QgsGeometrySliverPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()"],
    "QgsMarkerLineSymbolLayerWidget": ["setInterval(double val)", "setOffsetAlongLine(double val)"],
    "QgsRelationReferenceFactory": ["QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)"],
    "QgsPaintEngineHack": ["fixFlags()", "fixEngineFlags(QPaintEngine *engine)"],
    "QgsFieldExpressionWidget": ["isExpressionValid(const QString &expressionStr)", "setLeftHandButtonStyle(bool isLeft)", "currentFieldChanged()"],
    "QgsGradientFillSymbolLayer": ["setGradientSpread(GradientSpread gradientSpread)", "setGradientType(GradientType gradientType)", "referencePoint2IsCentroid() const", "GradientType", "setGradientColorType(GradientColorType gradientColorType)", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "offsetMapUnitScale() const", "setColor2(const QColor &color2)", "setCoordinateMode(GradientCoordinateMode coordinateMode)", "QgsGradientFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, const QColor &color2=Qt::white, GradientColorType gradientColorType=SimpleTwoColor, GradientType gradientType=Linear, GradientCoordinateMode coordinateMode=Feature, GradientSpread gradientSpread=Pad)", "referencePoint1() const", "GradientColorType", "offset() const", "GradientSpread", "referencePoint1IsCentroid() const", "offsetUnit() const", "referencePoint2() const", "GradientCoordinateMode"],
    "QgsValueRelationSearchWidgetWrapper": ["value() const"],
    "QgsMasterPasswordResetDialog": ["requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)", "QgsMasterPasswordResetDialog(QWidget *parent=nullptr)"],
    "QgsPointPatternFillSymbolLayer": ["setDisplacementY(double d)", "distanceYMapUnitScale() const", "setDistanceXMapUnitScale(const QgsMapUnitScale &scale)", "setDistanceY(double d)", "displacementXMapUnitScale() const", "createFromSld(QDomElement &element)", "displacementY() const", "setDisplacementX(double d)", "setDisplacementXMapUnitScale(const QgsMapUnitScale &scale)", "distanceX() const", "setDisplacementYMapUnitScale(const QgsMapUnitScale &scale)", "setDistanceYMapUnitScale(const QgsMapUnitScale &scale)", "displacementYMapUnitScale() const", "displacementX() const", "distanceY() const", "distanceXMapUnitScale() const", "setDistanceX(double d)"],
    "QgsDerivativeFilter": ["QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsGeometryCollection": ["QgsGeometryCollection(const QgsGeometryCollection &c)"],
    "QgsLayerTreeRegistryBridge": ["newLayersVisible() const", "isEnabled() const", "groupRemovedChildren()", "setEnabled(bool enabled)", "layersAdded(const QList< QgsMapLayer * > &layers)", "setNewLayersVisible(bool enabled)", "groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "layersWillBeRemoved(const QStringList &layerIds)", "removeLayersFromRegistry(const QStringList &layerIds)"],
    "QgsGpsConnection": ["nmeaSentenceReceived(const QString &substring)", "Status", "stateChanged(const QgsGpsInformation &info)"],
    "QgsAbstractFeatureIteratorFromSource": ["QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsRasterDataProvider": ["identifyFormatFromName(const QString &formatName)", "identifyFormatName(QgsRaster::IdentifyFormat format)", "setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)", "colorName(int colorInterpretation) const", "identifyFormatLabel(QgsRaster::IdentifyFormat format)", "colorTable(int bandNo) const", "colorInterpretationName(int bandNo) const", "identifyFormatToCapability(QgsRaster::IdentifyFormat format)"],
    "QgsSymbolLayer": ["mapUnitScale() const", "drawPreviewIcon(QgsSymbolRenderContext &context, QSize size)=0", "setLocked(bool locked)", "type() const", "setMapUnitScale(const QgsMapUnitScale &scale)", "toSld(QDomDocument &doc, QDomElement &element, const QgsStringMap &props) const", "isLocked() const", "QgsSymbolLayer(QgsSymbol::SymbolType type, bool locked=false)", "ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const"],
    "QgsLUDialog": ["setUpperValue(const QString &val)", "setLowerValue(const QString &val)", "lowerValue() const", "upperValue() const", "QgsLUDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsErrorMessage": ["line() const", "message() const", "function() const", "file() const", "tag() const"],
    "QgsFeatureModel": ["fidToIndex(QgsFeatureId fid)=0"],
    "QgsSimpleMarkerSymbolLayerWidget": ["setColorFill(const QColor &color)", "setColorStroke(const QColor &color)"],
    "QgsGenericFeatureSelectionManager": ["QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)", "QgsGenericFeatureSelectionManager(QObject *parent=nullptr)"],
    "QgsMimeDataUtils": ["decodeUriList(const QMimeData *data)", "isUriList(const QMimeData *data)"],
    "QgsRuleBasedLabelProvider": ["QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)"],
    "QgsRasterLayer": ["showStatusMessage(const QString &message)", "isValidRasterFileName(const QString &fileNameQString)"],
    "QgsDiagramRenderer": ["rendererName() const =0", "diagram() const", "QgsDiagramRenderer(const QgsDiagramRenderer &other)", "setDiagram(QgsDiagram *d)"],
    "QgsSymbolLevelsDialog": ["setForceOrderingEnabled(bool enabled)"],
    "QgsRasterRenderer": ["setAlphaBand(int band)", "type() const", "setRasterTransparency(QgsRasterTransparency *t)", "alphaBand() const", "usesTransparency() const", "rasterTransparency() const"],
    "QgsGeometryPointCoveredByLineCheck": ["ResolutionMethod", "QgsGeometryPointCoveredByLineCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsRenderContext": ["setUseRenderingOptimization(bool enabled)", "QgsRenderContext(const QgsRenderContext &rh)"],
    "QgsFontMarkerSymbolLayerWidget": ["setAngle(double angle)", "setSize(double size)", "setFontFamily(const QFont &font)", "setColor(const QColor &color)"],
    "QgsDataDefinedWidthDialog": ["QgsDataDefinedWidthDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsCredentials": ["getMasterPassword(QString &password, bool stored=false)"],
    "QgsDiagramSettings": ["LabelPlacementMethod"],
    "QgsRelief": ["setReliefColors(const QList< QgsRelief::ReliefColor > &c)", "clearReliefColors()", "reliefColors() const", "QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)", "setZFactor(double factor)", "zFactor() const", "addReliefColorClass(const QgsRelief::ReliefColor &color)"],
    "QgsSymbolLayerWidget": ["updateDataDefinedProperty()", "symbolLayer()=0", "setSymbolLayer(QgsSymbolLayer *layer)=0"],
    "QgsSpatialIndexCopyVisitor": ["QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)"],
    "QgsNewNameDialog": ["highlightText(const QString &text)", "nameChanged()", "fullNames(const QString &name, const QStringList &extensions)", "matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)"],
    "QgisInterface": ["actionDuplicateLayer()=0", "actionManagePlugins()=0", "actionOpenFieldCalculator()=0", "actionSaveEdits()=0", "actionNewVectorLayer()=0", "actionPluginListSeparator()=0", "actionHideAllLayers()=0", "actionAllEdits()=0", "actionShowAllLayers()=0", "actionAddAllToOverview()=0", "actionShowPythonDialog()=0", "actionShowSelectedLayers()=0", "actionRemoveAllFromOverview()=0", "actionQgisHomePage()=0", "actionCopyLayerStyle()=0", "actionOpenTable()=0", "pluginManagerInterface()=0", "actionRollbackAllEdits()=0", "actionLayerSaveAs()=0", "actionRollbackEdits()=0", "actionAddRasterLayer()=0", "actionToggleFullScreen()=0", "actionCustomProjection()=0", "actionCancelEdits()=0", "actionToggleEditing()=0", "actionAddOgrLayer()=0", "actionAbout()=0", "actionCancelAllEdits()=0", "actionPasteLayerStyle()=0", "actionOptions()=0", "layerTreeView()=0", "actionLayerProperties()=0", "actionSaveAllEdits()=0", "actionSaveActiveLayerEdits()=0", "actionAddPgLayer()=0", "actionAddToOverview()=0", "actionHelpContents()=0", "actionCheckQgisVersion()=0", "actionAddWmsLayer()=0", "actionHideSelectedLayers()=0"],
    "QgsLayerTreeView": ["onModelReset()", "layerForIndex(const QModelIndex &index) const", "updateExpandedStateToNode(const QModelIndex &index)", "modelRowsRemoved()", "updateExpandedStateFromNode(QgsLayerTreeNode *node)", "modelRowsInserted(const QModelIndex &index, int start, int end)", "onExpandedChanged(QgsLayerTreeNode *node, bool expanded)", "onCurrentChanged()"],
    "QgsLinearMinMaxEnhancement": ["QgsLinearMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsActionMenu": ["reinit()", "ActionType"],
    "QgsMessageBar": ["currentItem()"],
    "QgsMapToolAdvancedDigitizing": ["cadDockWidget() const"],
    "QgsLayerTreeNode": ["QgsLayerTreeNode(const QgsLayerTreeNode &other)"],
    "QgsRendererRangeLabelFormat": ["precision() const", "setPrecision(int precision)", "trimTrailingZeroes() const", "saveToDomElement(QDomElement &element)", "formatNumber(double value) const", "setFormat(const QString &format)", "format() const", "labelForRange(const QgsRendererRange &range) const", "setFromDomElement(QDomElement &element)", "setTrimTrailingZeroes(bool trimTrailingZeroes)", "QgsRendererRangeLabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)"],
    "QgsAbstractLabelProvider": ["Flag"],
    "QgsGeometrySelfContactCheck": ["ResolutionMethod", "factoryDescription()", "QgsGeometrySelfContactCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsEffectDrawModeComboBox": ["QgsEffectDrawModeComboBox(QWidget *parent SIP_TRANSFERTHIS=nullptr)"],
    "QgsSimplifyMethod": ["MethodType"],
    "QgsVectorLayerJoinBuffer": ["vectorJoins() const", "QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)"],
    "QgsExpressionHighlighter": ["addFields(const QStringList &fieldList)", "QgsExpressionHighlighter(QTextDocument *parent=nullptr)"],
    "QgisPlugin": ["name()"],
    "QgsMapLayerComboBox": ["rowsChanged()", "indexChanged(int i)"],
    "QgsAdvancedDigitizingCanvasItem": ["QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)"],
    "QgsFillSymbolLayer": ["renderPolygon(const QPolygonF &points, QList< QPolygonF > *rings, QgsSymbolRenderContext &context)=0", "setAngle(double angle)", "angle() const", "QgsFillSymbolLayer(bool locked=false)"],
    "QgsRendererRange": ["setRenderState(bool render)", "setUpperValue(double upperValue)", "setSymbol(QgsSymbol *s)", "label() const", "swap(QgsRendererRange &other)", "operator<(const QgsRendererRange &other) const", "symbol() const", "QgsRendererRange(double lowerValue, double upperValue, QgsSymbol *symbol, const QString &label, bool render=true)", "dump() const", "lowerValue() const", "setLabel(const QString &label)", "setLowerValue(double lowerValue)", "renderState() const", "upperValue() const", "QgsRendererRange(const QgsRendererRange &range)"],
    "QgsPointLocator_Stream": ["QgsPointLocator_Stream(const QLinkedList< RTree::Data * > &dataList)"],
    "QgsRunProcess": ["create(const QString &action, bool capture)"],
    "QgsVectorFileWriter::HiddenOption": ["HiddenOption(const QString &value)"],
    "QgsLayerTreeMapCanvasBridge": ["autoSetupOnFirstLayer() const", "rootGroup() const", "mapCanvas() const"],
    "QgsDrawSourceWidget": ["create()", "QgsDrawSourceWidget(QWidget *parent=nullptr)"],
    "QgsAttributeFormLegacyInterface": ["QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)"],
    "QgsStyleGroupSelectionDialog": ["QgsStyleGroupSelectionDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsGeometryLineLayerIntersectionCheck": ["ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "QgsGeometryLineLayerIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsFeatureRenderer": ["QgsFeatureRenderer(const QString &type)", "type() const", "setUsingSymbolLevels(bool usingSymbolLevels)", "usingSymbolLevels() const"],
    "QgsConnectionPoolGroup": ["onConnectionExpired()", "initTimer(QObject *parent)", "QgsConnectionPoolGroup(const QString &ci)", "release(T conn)", "invalidateConnections()"],
    "QgsGeometryDangleCheck": ["ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "QgsGeometryDangleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsLayerTreeGroup": ["nodeVisibilityChanged(QgsLayerTreeNode *node)", "QgsLayerTreeGroup(const QgsLayerTreeGroup &other)"],
    "QgsRelationEditorWidget": ["setRelationFeature(const QgsRelation &relation, const QgsFeature &feature)", "setEditorContext(const QgsAttributeEditorContext &context)", "setFeature(const QgsFeature &feature)"],
    "QgsContrastEnhancementFunction": ["QgsContrastEnhancementFunction(Qgis::DataType, double, double)", "QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)"],
    "QgsGeometryPointInPolygonCheck": ["QgsGeometryPointInPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsPluginLayer": ["QgsPluginLayer(const QString &layerType, const QString &layerName=QString())"],
    "QgsSymbolLayerUtils": ["decodeScaleMethod(const QString &str)", "decodeSldAlpha(const QString &str)", "decodeSldLineJoinStyle(const QString &str)", "encodeSldRealVector(const QVector< qreal > &v)", "externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)", "externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)", "needSvgFill(QDomElement &element)", "hasExternalGraphic(QDomElement &element)", "opacityFromSldElement(QDomElement &element, QString &alphaFunc)", "geometryFromSldElement(QDomElement &element, QString &geomFunc)", "encodeSldAlpha(int alpha)", "getVendorOptionList(QDomElement &element)", "createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)", "decodeBlendMode(const QString &s)", "encodeColor(const QColor &color)", "encodeScaleMethod(QgsSymbol::ScaleMethod scaleMethod)", "encodeSldLineCapStyle(Qt::PenCapStyle style)", "externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)", "functionFromSldElement(QDomElement &element, QString &function)", "rotationFromSldElement(QDomElement &element, QString &rotationFunc)", "createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)", "convertPolygonSymbolizerToPointMarker(QDomElement &element, QgsSymbolLayerList &layerList)", "encodeBrushStyle(Qt::BrushStyle style)", "createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)", "createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)", "createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)", "decodePenJoinStyle(const QString &str)", "drawStippledBackground(QPainter *painter, QRect rect)", "encodePenJoinStyle(Qt::PenJoinStyle style)", "needFontMarker(QDomElement &element)", "displacementFromSldElement(QDomElement &element, QPointF &offset)", "encodeRealVector(const QVector< qreal > &v)", "lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)", "needMarkerLine(QDomElement &element)", "needSvgMarker(QDomElement &element)", "parseProperties(QDomElement &element)", "needPointPatternFill(QDomElement &element)", "onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)", "clearSymbolMap(QgsSymbolMap &symbols)", "labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)", "saveProperties(QgsStringMap props, QDomDocument &doc, QDomElement &element)", "decodePenStyle(const QString &str)", "encodeSldFontWeight(int weight)", "encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)", "getSvgParameterList(QDomElement &element)", "createMarkerLayerFromSld(QDomElement &element)", "encodeSldBrushStyle(Qt::BrushStyle style)", "createSymbolLayerListFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType, QgsSymbolLayerList &layers)", "decodeSldBrushStyle(const QString &str)", "decodeSldFontWeight(const QString &str)", "encodePenStyle(Qt::PenStyle style)", "hasWellKnownMark(QDomElement &element)", "decodeMapUnitScale(const QString &str)", "decodePenCapStyle(const QString &str)", "createLineLayerFromSld(QDomElement &element)", "decodeSldFontStyle(const QString &str)", "decodeColor(const QString &str)", "decodeRealVector(const QString &s)", "encodeSldLineJoinStyle(Qt::PenJoinStyle style)", "encodeSldFontStyle(QFont::Style style)", "decodeSldRealVector(const QString &s)", "createFillLayerFromSld(QDomElement &element)", "createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)", "createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)", "decodeSldLineCapStyle(const QString &str)", "externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)", "fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)", "fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())", "needEllipseMarker(QDomElement &element)", "needLinePatternFill(QDomElement &element)", "encodePenCapStyle(Qt::PenCapStyle style)", "createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)", "decodeBrushStyle(const QString &str)", "wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &strokeColor, Qt::PenStyle strokeStyle, double strokeWidth=-1, double size=-1)"],
    "QgsGeometryChecker": ["QgsGeometryChecker(const QList< QgsGeometryCheck * > &checks, QgsGeometryCheckContext *context, const QMap< QString, QgsFeaturePool * > &featurePools)", "fixError(QgsGeometryCheckError *error, int method, bool triggerRepaint=false)", "getContext() const", "getMessages() const", "setMergeAttributeIndices(const QMap< QString, int > &mergeAttributeIndices)", "errorUpdated(QgsGeometryCheckError *error, bool statusChanged)", "errorAdded(QgsGeometryCheckError *error)", "progressValue(int value)", "getChecks() const", "featurePools() const", "execute(int *totalSteps=nullptr)"],
    "QgsCategorizedSymbolRenderer": ["rebuildHash()"],
    "QgsRasterRendererWidget": ["max(int index=0)", "setStdDev(const QString &value)", "setMax(const QString &value, int index=0)", "setRasterLayer(QgsRasterLayer *layer)", "setMin(const QString &value, int index=0)", "QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)", "renderer()=0", "stdDev()", "min(int index=0)", "rasterLayer() const", "selectedBand(int index=0)"],
    "QgsMapLayerProxyModel": ["Filter"],
    "QgsLabelSorter": ["QgsLabelSorter(const QgsMapSettings &mapSettings)", "operator()(pal::LabelPosition *lp1, pal::LabelPosition *lp2) const"],
    "QgsValueMapConfigDlg": ["QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsSublayersDialog": ["ProviderType"],
    "QgsMapRendererParallelJob": ["QgsMapRendererParallelJob(const QgsMapSettings &settings)"],
    "QgsDefaultRasterLayerLegend": ["QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)"],
    "QgsRasterFormatSaveOptionsWidget": ["QgsRasterFormatSaveOptionsWidget(QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &format=\"GTiff\", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider=\"gdal\")", "apply()", "optionsChanged()", "Type"],
    "TriDecorator": ["TriDecorator(Triangulation *t)"],
    "QgsSingleBandColorDataRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)", "QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)"],
    "QgsUnitSelectionWidget": ["changed()"],
    "QgsMapToolIdentifyFeature": ["featureIdentified(const QgsFeature &)", "featureIdentified(QgsFeatureId)"],
    "QgsPixmapLabel": ["setPixmap(const QPixmap &)"],
    "QgsSimpleLineSymbolLayerWidget": ["updatePatternIcon()"],
    "QgsGeometrySelfIntersectionCheckError": ["QgsGeometrySelfIntersectionCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsVertexId vertexId, const QgsGeometryUtils::SelfIntersection &intersection)", "intersection() const"],
    "QgsGpsdConnection": ["QgsGpsdConnection(const QString &host, qint16 port, const QString &device)"],
    "QgsRelationReferenceConfigDlg": ["QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsFeatureListModel": ["displayExpression() const", "mapSelectionFromMaster(const QItemSelection &selection) const", "mapFromMaster(const QModelIndex &sourceIndex) const", "fidToIndexList(QgsFeatureId fid)", "featureByIndex(const QModelIndex &index, QgsFeature &feat)", "mapSelectionToMaster(const QItemSelection &selection) const", "masterModel()", "mapToMaster(const QModelIndex &proxyIndex) const", "Role", "setSourceModel(QgsAttributeTableFilterModel *sourceModel)"],
    "QgsRasterPipe": ["size() const", "last() const", "hueSaturationFilter() const", "nuller() const", "renderer() const", "projector() const", "at(int idx) const", "Role", "brightnessFilter() const", "QgsRasterPipe(const QgsRasterPipe &pipe)", "provider() const", "resampleFilter() const"],
    "QgsMessageBarItem": ["setWidget(QWidget *widget)", "setDuration(int duration)", "setTitle(const QString &title)", "setLevel(Qgis::MessageLevel level)", "setText(const QString &text)", "setIcon(const QIcon &icon)"],
    "QgsCptCityBrowserModel": ["addRootItems()", "endInsertItems()", "endRemoveItems()", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)", "findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const", "refresh(const QModelIndex &index=QModelIndex())", "reload()", "removeRootItems()", "refresh(const QString &path)", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "ViewType", "connectItem(QgsCptCityDataItem *item)"],
    "QgsTransaction": ["QgsTransaction(const QString &connString)"],
    "HalfEdge": ["HalfEdge(int dual, int next, int point, bool mbreak, bool forced)"],
    "QgsBrushStyleComboBox": ["iconForBrush(Qt::BrushStyle style)", "setBrushStyle(Qt::BrushStyle style)", "brushStyle() const", "QgsBrushStyleComboBox(QWidget *parent=nullptr)"],
    "QgsGeometryEngine": ["interpolate(double distance, QString *errorMsg=nullptr) const =0", "area(QString *errorMsg=nullptr) const =0", "isEmpty(QString *errorMsg) const =0", "envelope(QString *errorMsg=nullptr) const =0", "QgsGeometryEngine(const QgsAbstractGeometry *geometry)", "offsetCurve(double distance, int segments, int joinStyle, double miterLimit, QString *errorMsg=nullptr) const =0", "buffer(double distance, int segments, int endCapStyle, int joinStyle, double miterLimit, QString *errorMsg=nullptr) const =0", "length(QString *errorMsg=nullptr) const =0", "buffer(double distance, int segments, QString *errorMsg=nullptr) const =0", "simplify(double tolerance, QString *errorMsg=nullptr) const =0"],
    "QgsDartMeasurement": ["QgsDartMeasurement(const QString &name, Type type, const QString &value)", "toString() const", "Type", "send() const"],
    "QgsCptCityDirectoryItem": ["dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "rampsMap()", "dirEntries() const"],
    "QgsMapToPixel": ["transform() const", "transform(QgsPointXY *p) const"],
    "NormVecDecorator": ["NormVecDecorator(Triangulation *tin)"],
    "QgsDirectoryItem": ["directoryChanged()", "init()", "QgsDirectoryItem(QgsDataItem *parent, const QString &name, const QString &path)"],
    "QgsRasterInterface": ["ySize() const", "dataTypeSize(int bandNo)", "QgsRasterInterface(QgsRasterInterface *input=nullptr)", "yBlockSize() const"],
    "QgsSymbol": ["QgsSymbol(SymbolType type, const QgsSymbolLayerList &layers)"],
    "QgsVectorLayerFeatureIterator": ["QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsOptionsDialogBase": ["warnAboutMissingObjects()", "setSettings(QgsSettings *settings)", "updateWindowTitle()"],
    "QgsPythonRunner": ["runCommand(QString command, QString messageOnError=QString())=0", "evalCommand(QString command, QString &result)=0"],
    "QgsGeometryValidator": ["stop()", "addError(const QgsGeometry::Error &)"],
    "QgsMultiRenderChecker": ["setControlPathPrefix(const QString &prefix)"],
    "QgsExternalResourceWidget": ["setDocumentPath(const QVariant &documentPath)", "DocumentViewerContent"],
    "QgsGeometrySelfIntersectionCheck": ["ResolutionMethod", "QgsGeometrySelfIntersectionCheck(const QgsGeometryCheckContext *context, const QVariantMap &configuration=QVariantMap())"],
    "QgsAttributeTableModel": ["finished()", "idToIndex(QgsFeatureId id) const", "Role", "idToIndexList(QgsFeatureId id) const"],
    "QgsMapToolIdentify": ["identifyVectorLayer(QList< QgsMapToolIdentify::IdentifyResult > *results, QgsVectorLayer *layer, const QgsPointXY &point)", "identifyRasterLayer(QList< QgsMapToolIdentify::IdentifyResult > *results, QgsRasterLayer *layer, QgsPointXY point, const QgsRectangle &viewExtent, double mapUnitsPerPixel)", "identifyMessage(const QString &)", "formatChanged(QgsRasterLayer *layer)", "Type", "IdentifyMode", "identifyProgress(int, int)", "changedRasterResults(QList< QgsMapToolIdentify::IdentifyResult > &)"],
    "QgsStyleManagerDialog": ["editColorRamp()", "addColorRamp(QAction *action)", "currentItemName()", "currentItemType()", "editSymbol()"],
    "QgsRangeConfigDlg": ["QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)", "rangeWidgetChanged(int index)"],
    "QgsGeos": ["fromGeosPolygon(const GEOSGeometry *geos)", "getGEOSHandler()", "coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)"],
    "QgsSymbolsListWidget": ["setLineWidth(double width)", "clipFeaturesToggled(bool checked)", "setMarkerAngle(double angle)", "setSymbolColor(const QColor &color)", "setMarkerSize(double size)", "updateDataDefinedMarkerAngle()", "changed()", "updateDataDefinedLineWidth()", "updateDataDefinedMarkerSize()"],
    "QgsAlignRaster": ["gridOffset() const", "setGridOffset(QPointF offset)"],
    "QgsLayerTreeModel": ["connectToRootNode()", "addLegendToLayer(QgsLayerTreeLayer *nodeL)", "legendCleanup()", "nodeLayerWillBeUnloaded()", "legendRootRowCount(QgsLayerTreeLayer *nL) const", "layerLegendChanged()", "iconGroup()", "removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendNodeFlags(QgsLayerTreeModelLegendNode *node) const", "legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const", "legendInvalidateMapBasedData()", "layerNeedsUpdate()", "nodeLayerLoaded()", "nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "disconnectFromRootNode()", "nodeRemovedChildren()", "indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const", "legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const", "disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "invalidateLegendMapBasedData()", "disconnectFromLayers(QgsLayerTreeGroup *parentGroup)", "connectToLayer(QgsLayerTreeLayer *nodeLayer)", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const", "nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendNodeDataChanged()", "nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const", "legendParent(QgsLayerTreeModelLegendNode *legendNode) const", "connectToLayers(QgsLayerTreeGroup *parentGroup)", "Flag"],
    "QgsRuleBasedRenderer": ["FeatureFlags", "createFromSld(QDomElement &element, QgsWkbTypes::GeometryType geomType)", "rootRule()"],
    "QgsGml": ["dataReadProgress(int progress)", "QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)", "totalStepsUpdate(int totalSteps)"],
    "QgsDummyConfigDlg": ["QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)"],
    "QgsRendererCategory": ["swap(QgsRendererCategory &other)"],
    "QgsAttributeTableDelegate": ["setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgsMapSettings": ["mapToPixel() const", "updateDerived()", "writeXml(QDomNode &node, QDomDocument &doc)", "readXml(QDomNode &node)"],
    "QgsAttributeEditorContext": ["parentContext() const", "FormMode", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)"],
    "QgsRasterLayerRenderer": ["QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsGeometryDuplicateNodesCheck": ["ResolutionMethod", "factoryDescription()", "QgsGeometryDuplicateNodesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsRasterDrawer": ["QgsRasterDrawer(QgsRasterIterator *iterator)"],
    "pal::LabelPosition": ["getReversed() const", "setPartId(int id)", "getUpsideDown() const", "getQuadrant() const", "resetNumOverlaps()", "getPartId() const", "getHeight() const", "getProblemFeatureId() const", "getNumOverlaps() const", "getWidth() const"],
    "QgsPointLocator_VisitorEdgesInRect": ["QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsGpsConnectionRegistry": ["connectionList() const"],
    "QgsAuthCertInfo": ["trustCacheRebuilt()"],
    "QgsIFeatureSelectionManager": ["QgsIFeatureSelectionManager(QObject *parent)"],
    "QgsRaster": ["RasterPyramidsFormat", "RasterBuildPyramids", "IdentifyFormat", "ColorInterpretation", "RasterProgressType"],
    "QgsVectorLayerEditPassthrough": ["QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)"],
    "QgsFeatureListView": ["repaintRequested(const QModelIndexList &indexes)", "repaintRequested()"],
    "QgsGeometryTypeCheck": ["factoryDescription()", "factoryCompatibleGeometryTypes()", "QgsGeometryTypeCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, int allowedTypes)", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "pal::Layer": ["displayAll() const", "UpsideDownLabels"],
    "QgsSVGFillSymbolLayerWidget": ["insertIcons()"],
    "QgsPointLocator_VisitorNearestEdge": ["QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsPreviewEffect": ["QgsPreviewEffect(QObject *parent)", "PreviewMode"],
    "QgsGeometryAreaCheck": ["ResolutionMethod", "factoryDescription()", "factoryCheckType()", "factoryCompatibleGeometryTypes()", "QgsGeometryAreaCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsHillshadeFilter": ["setLightAzimuth(float azimuth)", "lightAngle() const", "lightAzimuth() const", "setLightAngle(float angle)", "QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)"],
    "QgsBrowserWatcher": ["item() const", "finished(QgsDataItem *item, const QVector< QgsDataItem * > &items)", "QgsBrowserWatcher(QgsDataItem *item)"],
    "QgsEffectStack": ["QgsEffectStack(const QgsEffectStack &other)"],
    "QgsDxfExport": ["SymbologyExport"],
    "QgsProjectVersion": ["QgsProjectVersion(int major, int minor, int sub, const QString &name=\"\")", "minorVersion()", "majorVersion()", "QgsProjectVersion(const QString &string)", "text()", "subVersion()"],
    "QgsSingleBandPseudoColorRenderer": ["setClassificationMax(double max)", "classificationMax() const", "classificationMin() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "setClassificationMin(double min)"],
    "QgsPointLocator_VisitorNearestVertex": ["QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "pal::Problem": ["init_sol_falp()", "reduce()"],
    "QgsSnappingUtils": ["mapSettings() const", "IndexingStrategy"],
    "QgsAuthMethodConfig": ["setMethod(const QString &method)", "setUri(const QString &uri)"],
    "QgsSingleSymbolRendererWidget": ["QgsSingleSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsGeometryDuplicateCheckError": ["QgsGeometryDuplicateCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QMap< QString, QgsFeaturePool * > &featurePools, const QMap< QString, QList< QgsFeatureId >> &duplicates)", "duplicates() const"],
    "QgsPaintEffect": ["QgsPaintEffect(const QgsPaintEffect &other)"],
    "QgsRasterShader": ["rasterShaderFunction()", "rasterShaderFunction() const", "QgsRasterShader(double minimumValue=0.0, double maximumValue=255.0)"],
    "QgsZipItem": ["iconZip()", "vsiPrefix(const QString &uri)", "getZipFileList()", "QgsZipItem(QgsDataItem *parent, const QString &name, const QString &path)", "QgsZipItem(QgsDataItem *parent, const QString &name, const QString &filePath, const QString &path)"],
    "QgsSvgMarkerSymbolLayer": ["setStrokeWidth(double w)", "createFromSld(QDomElement &element)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "create(const QgsStringMap &properties=QgsStringMap())", "strokeWidth() const", "strokeWidthMapUnitScale() const"],
    "QgsPalettedRasterRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsGeometry::Error": ["Error(const QString &m)", "Error(const QString &m, const QgsPointXY &p)"],
    "QgsInterpolator": ["QgsInterpolator(const QList< QgsInterpolator::LayerData > &layerData)"],
    "QgsLayerPropertiesWidget": ["updateSymbolLayerWidget(QgsSymbolLayer *layer)", "changed()", "changeLayer(QgsSymbolLayer *)", "layerTypeChanged()", "emitSignalChanged()", "populateLayerTypes()"],
    "QgsHeatmapRenderer": ["convertFromRenderer(const QgsFeatureRenderer *renderer)"],
    "QgsSymbolSelectorDialog": ["updateLayerPreview()", "layerChanged()", "removeLayer()", "updatePreview()", "moveLayerDown()", "lockLayer()", "addLayer()", "symbolModified()", "moveLayerUp()"],
    "QgsRasterBlock": ["applyNoDataValues(const QgsRasterRangeList &rangeList)", "typeSize(int dataType)", "toString() const", "dataTypeSize() const"],
    "QgsGeometryCheckerUtils": ["canDeleteVertex(const QgsAbstractGeometry *geom, int iPart, int iRing)", "pointOnLine(const QgsPoint &p, const QgsLineString *line, double tol, bool excludeExtremities=false)", "filter1DTypes(QgsAbstractGeometry *geom)", "lineIntersections(const QgsLineString *line1, const QgsLineString *line2, double tol)", "createGeomEngine(const QgsAbstractGeometry *geometry, double tolerance)", "getGeomPart(QgsAbstractGeometry *geom, int partIdx)", "sharedEdgeLength(const QgsAbstractGeometry *geom1, const QgsAbstractGeometry *geom2, double tol)", "polygonRings(const QgsPolygon *polygon)", "getGeomPart(const QgsAbstractGeometry *geom, int partIdx)"],
    "QgsColorSwatchDelegate": ["QgsColorSwatchDelegate(QWidget *parent=nullptr)"],
    "QgsAttributeEditorElement": ["AttributeEditorType"],
    "QgsLegendSymbolItem": ["QgsLegendSymbolItem(const QgsLegendSymbolItem &other)"],
    "QgsConstWkbPtr": ["operator>>(char &v) const", "operator>>(int &v) const", "QgsConstWkbPtr(const unsigned char *p, int size)", "operator+=(int n)", "operator-=(int n)", "operator>>(unsigned int &v) const", "operator>>(float &r) const", "operator const unsigned char *() const", "operator>>(double &v) const"],
    "QgsCharacterSelectorDialog": ["QgsCharacterSelectorDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsPalLayerSettings": ["MultiLineAlign", "QuadrantPosition", "QgsPalLayerSettings(const QgsPalLayerSettings &s)", "DirectionSymbols", "UpsideDownLabels"],
    "QgsEncodingFileDialog": ["pbnCancelAll_clicked()", "saveUsedEncoding()"],
    "QgsTextEditConfigDlg": ["QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsNineCellFilter": ["setCellSizeY(double size)", "setOutputNodataValue(double value)", "cellSizeY() const", "outputNodataValue() const", "setZFactor(double factor)", "setCellSizeX(double size)", "zFactor() const", "setInputNodataValue(double value)", "cellSizeX() const", "inputNodataValue() const"],
    "QgsDualView": ["openConditionalStyles()"],
    "QgsMapRendererSequentialJob": ["internalFinished()", "QgsMapRendererSequentialJob(const QgsMapSettings &settings)"],
    "QgsDetailedItemWidget": ["setData(const QgsDetailedItemData &data)", "setChecked(bool flag)"],
    "QgsDateTimeEditConfig": ["QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsGroupBoxCollapseButton": ["QgsGroupBoxCollapseButton(QWidget *parent=nullptr)", "setAltDown(bool updown)", "setShiftDown(bool shiftdown)", "shiftDown() const", "altDown() const"],
    "QgsConditionalStyle": ["QgsConditionalStyle(const QgsConditionalStyle &other)", "QgsConditionalStyle(const QString &rule)"],
    "QgsGeometryFollowBoundariesCheck": ["factoryDescription()", "QgsGeometryFollowBoundariesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, QgsVectorLayer *checkLayer)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsBrightnessContrastFilter": ["brightness() const", "setBrightness(int brightness)", "contrast() const", "QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)", "setContrast(int contrast)", "gamma() const", "setGamma(double gamma)"],
    "QgsDxfPaintDevice": ["setShift(QPointF shift)", "QgsDxfPaintDevice(QgsDxfExport *dxf)", "setDrawingSize(QSizeF size)", "setLayer(const QString &layer)", "setOutputSize(const QRectF &r)"],
    "QgsLongLongValidator": ["top() const", "QgsLongLongValidator(QObject *parent)", "setTop(qint64 top)", "bottom() const", "setRange(qint64 bottom, qint64 top)", "QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)", "setBottom(qint64 bottom)"],
    "QgsHueSaturationFilter": ["QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)", "colorizeStrength() const", "colorizeColor() const", "saturation() const", "setSaturation(int saturation)", "setColorizeOn(bool colorizeOn)", "setColorizeStrength(int colorizeStrength)", "colorizeOn() const", "GrayscaleMode", "grayscaleMode() const", "setColorizeColor(const QColor &colorizeColor)", "setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)"],
    "QgsFeatureRequest": ["flags() const", "Flag"],
    "QgsVectorLayer": ["diagramLayerSettings() const", "diagramRenderer() const", "setDiagramLayerSettings(const QgsDiagramLayerSettings &s)", "vectorJoins() const"],
    "QgsSingleBandGrayRendererWidget": ["QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &extent)", "setFromRenderer(const QgsRasterRenderer *r)"],
    "QgsXmlUtils": ["writeRectangle(const QgsRectangle &rect, QDomDocument &doc)", "readRectangle(const QDomElement &element)"],
    "QgsAction": ["ActionType"],
    "QgsVectorFileWriter::BoolOption": ["BoolOption(const QString &docString, bool defaultValue)"],
    "QgsSimpleFillSymbolLayer": ["QgsSimpleFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &strokeColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle strokeStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double strokeWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)", "setBrushStyle(Qt::BrushStyle style)", "setOffset(QPointF offset)", "setPenJoinStyle(Qt::PenJoinStyle style)", "setStrokeWidth(double strokeWidth)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "strokeStyle() const", "offsetMapUnitScale() const", "createFromSld(QDomElement &element)", "strokeWidth() const", "offset()", "strokeWidthMapUnitScale() const", "penJoinStyle() const", "brushStyle() const", "setStrokeStyle(Qt::PenStyle strokeStyle)"],
    "QgsDetailedItemDelegate": ["setVerticalSpacing(int value)", "verticalSpacing() const", "setHorizontalSpacing(int value)", "horizontalSpacing() const"],
    "QgsDxfPaintEngine": ["setShift(QPointF shift)", "setLayer(const QString &layer)", "layer() const", "QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)"],
    "QgsExpressionItem": ["ItemType", "getExpressionText() const", "QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)"],
    "QgsGlowWidget": ["QgsGlowWidget(QWidget *parent=nullptr)", "create()"],
    "QgsVectorFileWriter": ["symbologyExport() const", "setSymbologyExport(QgsVectorFileWriter::SymbologyExport symExport)", "driverMetadata(const QString &driverName, MetaData &driverMetadata)", "OptionType", "SymbologyExport", "WriterError"],
    "QgsDiagram": ["QgsDiagram(const QgsDiagram &other)", "clearCache()"],
    "QgsExpressionBuilderWidget": ["isExpressionValid()", "loadFieldNames(const QgsFields &fields)"],
    "QgsCompoundCurve": ["QgsCompoundCurve(const QgsCompoundCurve &curve)"],
    "QgsFieldComboBox": ["indexChanged(int i)"],
    "QgsRasterRendererRegistry": ["insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)", "entries() const", "insert(const QgsRasterRendererRegistryEntry &entry)", "rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const", "renderersList() const"],
    "QgsCptCityColorRamp": ["copy(const QgsCptCityColorRamp *other)", "setName(const QString &schemeName, const QString &variantName=QString(), const QStringList &variantList=QStringList())", "loadPalette()", "setSchemeName(const QString &schemeName)", "hasMultiStops() const", "cloneGradientRamp() const", "fileLoaded() const", "setVariantList(const QStringList &variantList)", "schemeName() const", "variantList() const", "copyingFileName() const", "loadFile()", "copyingInfo() const", "fileName() const", "create(const QgsStringMap &properties=QgsStringMap())", "setVariantName(const QString &variantName)", "descFileName() const", "variantName() const"],
    "QgsVectorLayerEditUtils": ["QgsVectorLayerEditUtils(QgsVectorLayer *layer)"],
    "CharacterWidget": ["updateFontMerging(bool enable)"],
    "QgsSearchQueryBuilder": ["loadQuery()", "saveQuery()"],
    "QgsVectorLayerSelectionManager": ["QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)"],
    "QgsCurvePolygon": ["QgsCurvePolygon(const QgsCurvePolygon &p)"],
    "QgsSmartGroupCondition": ["removed(int)", "QgsSmartGroupCondition(int id, QWidget *parent=nullptr)", "destruct()"],
    "QgsAttributeTypeLoadDialog": ["QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)"],
    "QgsCentroidFillSymbolLayer": ["pointOnSurface() const", "setPointOnSurface(bool pointOnSurface)", "createFromSld(QDomElement &element)"],
    "QgsWkbPtr": ["operator>>(char &v) const", "operator>>(int &v) const", "operator>>(QgsWkbTypes::Type &v) const", "operator+=(int n)", "QgsWkbPtr(unsigned char *p, int size)", "operator>>(unsigned int &v) const", "operator>>(float &r) const", "operator>>(double &v) const", "operator unsigned char *() const"],
    "QgsFeatureSelectionModel": ["setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)", "QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)"],
    "QgsMapRendererCustomPainterJob": ["QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)"],
    "QgsMapLayerModel": ["addLayers(const QList< QgsMapLayer * > &layers)", "removeLayers(const QStringList &layerIds)"],
    "QgsDefaultVectorLayerLegend": ["QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)"],
    "QgsRasterChecker": ["report()"],
    "QgsDataDefinedRotationDialog": ["QgsDataDefinedRotationDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsGraduatedSymbolRendererWidget": ["rangesClicked(const QModelIndex &idx)", "updateUiFromRenderer(bool updateCount=true)", "modelDataChanged()", "disconnectUpdateHandlers()", "refreshRanges(bool reset=false)", "selectedRanges()", "changeRange(int rangeIdx)", "changeCurrentValue(QStandardItem *item)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "labelFormatChanged()", "showSymbolLevels()", "changeRangeSymbol(int rangeIdx)", "QgsGraduatedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "changeSelectedSymbols()", "connectUpdateHandlers()", "rowsOrdered()", "rowsMoved()", "findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const", "reapplyColorRamp()", "graduatedColumnChanged(const QString &field)", "classifyGraduated()", "rangesDoubleClicked(const QModelIndex &idx)", "reapplySizes()"],
    "QgsTransformWidget": ["QgsTransformWidget(QWidget *parent=nullptr)", "create()"],
    "QgsShapeburstFillSymbolLayerWidget": ["setColor(const QColor &color)", "setColor2(const QColor &color)"],
    "QgsMapLayer": ["readSld(const QDomNode &node, QString &errorMessage)"],
    "QgsUniqueValuesConfigDlg": ["QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsRuleBasedRendererModel": ["updateRule(const QModelIndex &index)", "finishedAddingRules()", "clearFeatureCounts()", "updateRule(const QModelIndex &parent, int row)", "willAddRules(const QModelIndex &parent, int count)", "removeRule(const QModelIndex &index)", "ruleForIndex(const QModelIndex &index) const", "insertRule(const QModelIndex &parent, int before, QgsRuleBasedRenderer::Rule *newrule)"],
    "pal::PointSet": ["getGeosType() const", "PointSet(double x, double y)", "invalidateGeos()", "PointSet(int nbPoints, double *x, double *y)", "getCentroid(double &px, double &py, bool forceInside=false) const", "createGeosGeom() const", "getNumPoints() const", "deleteCoords()", "preparedGeom() const", "PointSet(const PointSet &ps)"],
    "QgsLayerTreeLayer": ["attachToLayer()", "QgsLayerTreeLayer(QgsMapLayer *layer)", "QgsLayerTreeLayer(const QgsLayerTreeLayer &other)"],
    "QgsExpressionBuilderDialog": ["QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &key=\"generic\", const QgsExpressionContext &context=QgsExpressionContext())", "setExpressionText(const QString &text)", "expressionText()"],
    "QgsBusyIndicatorDialog": ["message() const", "setMessage(const QString &message)"],
    "QgsRuleBasedLabeling": ["rootRule() const", "rootRule()"],
    "QgsRasterCalcNode": ["QgsRasterCalcNode(double number)", "type() const", "QgsRasterCalcNode(QgsRasterMatrix *matrix)", "parseRasterCalcString(const QString &str, QString &parserErrorMsg)", "QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)", "setLeft(QgsRasterCalcNode *left)", "setRight(QgsRasterCalcNode *right)", "QgsRasterCalcNode(const QString &rasterName)"],
    "QgsVectorFileWriter::StringOption": ["StringOption(const QString &docString, const QString &defaultValue=QString())"],
    "QgsOWSSourceSelect": ["addWmsListItem(const QDomElement &el, int row, int column)", "enableLayersForCrs(QTreeWidgetItem *item)", "addWmsListRow(const QDomElement &item, int row)"],
    "DualEdgeTriangulation": ["setDecorator(Triangulation *d)", "DualEdgeTriangulation(int nop, Triangulation *decorator)"],
    "CloughTocherInterpolator": ["setTriangulation(NormVecDecorator *tin)"],
    "QgsGeometryGeneratorSymbolLayer": ["create(const QgsStringMap &properties)"],
    "QgsGeometryAngleCheck": ["ResolutionMethod", "factoryDescription()", "QgsGeometryAngleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsAttributeTableAction": ["execute()", "featureForm()"],
    "QgsLinearMinMaxEnhancementWithClip": ["QgsLinearMinMaxEnhancementWithClip(Qgis::DataType, double, double)"],
    "QgsSlopeFilter": ["QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsAttributeForm": ["QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)", "feature()"],
    "pal::PriorityQueue": ["sort()", "remove(int key)", "decreaseKey(int key)", "downheap(int id)", "insert(int key, double p)", "print()", "setPriority(int key, double new_p)", "getSize()", "getSizeByPos()", "upheap(int key)", "getBest()", "getId(int key)", "isIn(int key)"],
    "QgsShadowEffectWidget": ["create()", "QgsShadowEffectWidget(QWidget *parent=nullptr)"],
    "QgsSymbolLayerAbstractMetadata": ["type() const", "visibleName() const", "QgsSymbolLayerAbstractMetadata(const QString &name, const QString &visibleName, QgsSymbol::SymbolType type)", "name() const"],
    "QgsQueryBuilder": ["clear()", "sql()", "setDatasourceDescription(const QString &uri)", "setSql(const QString &sqlStatement)"],
    "QgsMapRendererJob": ["QgsMapRendererJob(const QgsMapSettings &settings)"],
    "QgsAbstractGeometry": ["QgsAbstractGeometry(const QgsAbstractGeometry &geom)"],
    "QgsGeometryHoleCheck": ["ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "QgsGeometryHoleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsVectorFileWriter::Option": ["Option(const QString &docString, QgsVectorFileWriter::OptionType type)"],
    "QgsBrowserTreeView": ["hasExpandedDescendant(const QModelIndex &index) const", "setSettingsSection(const QString &section)"],
    "QgsRuleBasedRendererWidget": ["selectedRulesChanged()", "editRule(const QModelIndex &index)", "currentRule()", "clearFeatureCounts()", "QgsRuleBasedRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "setRenderingOrder()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "restoreSectionWidths()", "refineRuleScales()", "editRule()", "refineRuleRanges()", "removeRule()", "countFeatures()", "selectedRules()", "refineRuleScalesGui(const QModelIndexList &index)", "saveSectionWidth(int section, int oldSize, int newSize)", "addRule()", "currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())", "refineRule(int type)", "refineRuleCategories()"],
    "QgsPenCapStyleComboBox": ["setPenCapStyle(Qt::PenCapStyle style)", "QgsPenCapStyleComboBox(QWidget *parent=nullptr)", "penCapStyle() const"],
    "QgsScopeLogger": ["QgsScopeLogger(const char *file, const char *func, int line)"],
    "QgsGeometrySegmentLengthCheck": ["ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "QgsGeometrySegmentLengthCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsGeometryContainedCheckError": ["containingFeature() const", "QgsGeometryContainedCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QgsGeometryCheckerUtils::LayerFeature &containingFeature)"],
    "QgsEllipseSymbolLayer": ["setStrokeWidth(double w)", "strokeStyle() const", "symbolName() const", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolHeight(double h)", "symbolHeightMapUnitScale() const", "createFromSld(QDomElement &element)", "setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)", "symbolWidth() const", "symbolWidthMapUnitScale() const", "create(const QgsStringMap &properties=QgsStringMap())", "symbolHeight() const", "setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)", "strokeWidth() const", "setSymbolWidth(double w)", "strokeWidthMapUnitScale() const", "setSymbolName(const QString &name)", "setStrokeStyle(Qt::PenStyle strokeStyle)"],
    "QgsMultiBandColorRendererWidget": ["setFromRenderer(const QgsRasterRenderer *r)", "create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsContrastEnhancement": ["contrastEnhancementAlgorithm() const", "QgsContrastEnhancement(const QgsContrastEnhancement &ce)", "writeXml(QDomDocument &doc, QDomElement &parentElem) const", "readXml(const QDomElement &elem)", "QgsContrastEnhancement(Qgis::DataType datatype=Qgis::DataType::Byte)"],
    "QgsCollapsibleGroupBoxBasic": ["checkClicked(bool ckd)", "toggleCollapsed()", "updateStyle()", "titleRect() const", "checkToggled(bool ckd)", "QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)", "init()", "QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)", "clearModifiers()"],
    "QgsFeatureListViewDelegate": ["setCurrentFeatureEdited(bool state)", "setEditSelectionModel(QItemSelectionModel *editSelectionModel)", "Element", "setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)", "editButtonClicked(QModelIndex &index)", "positionToElement(QPoint pos)", "QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)"],
    "QgsManageConnectionsDialog": ["doExportImport()", "Mode", "selectAll()", "Type", "clearSelection()", "selectionChanged()"],
    "QgsFieldValidator": ["dateFormat() const", "QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat=\"yyyy-MM-dd\")"],
    "QgsDataCollectionItem": ["QgsDataCollectionItem(QgsDataItem *parent, const QString &name, const QString &path=QString())", "addChild(QgsDataItem *item)"],
    "QgsPaintEffectWidget": ["QgsPaintEffectWidget(QWidget *parent=nullptr)"],
    "pal::Pal": ["FnIsCanceled)(void *ctx)"],
    "QgsColorBrewerPalette": ["listSchemeColors(const QString &schemeName, int colors)", "listSchemeVariants(const QString &schemeName)", "listSchemes()"],
    "pal::Util": ["unmulti(const GEOSGeometry *the_geom)"],
    "QgsCodeEditor": ["marginVisible()", "foldingVisible()", "isFixedPitch(const QFont &font)", "getMonospaceFont()"],
    "QgsVectorFileWriter::IntOption": ["IntOption(const QString &docString, int defaultValue)"],
    "QgsWkbException": ["QgsWkbException(QString const &what)"],
    "QgsGeometryRubberBand": ["IconType", "QgsGeometryRubberBand(QgsMapCanvas *mapCanvas, QgsWkbTypes::GeometryType geomType=QgsWkbTypes::LineGeometry)"],
    "QgsGeometryLineIntersectionCheck": ["ResolutionMethod", "QgsGeometryLineIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsSymbolRenderContext": ["setFeature(const QgsFeature *f)"],
    "QgsVertexMarker": ["setIconSize(int iconSize)", "setIconType(int iconType)", "setCenter(const QgsPointXY &point)", "QgsVertexMarker(QgsMapCanvas *mapCanvas)", "setPenWidth(int width)"],
    "QgsRasterFileWriter": ["buildPyramidsFlag() const", "setPyramidsConfigOptions(const QStringList &list)", "setPyramidsResampling(const QString &str)", "setPyramidsList(const QList< int > &list)", "maxTileWidth() const", "outputFormat() const", "outputProviderKey() const", "setOutputFormat(const QString &format)", "setTiledMode(bool t)", "setBuildPyramidsFlag(QgsRaster::RasterBuildPyramids f)", "maxTileHeight() const", "setMaxTileWidth(int w)", "WriterError", "setMaxTileHeight(int h)", "setPyramidsFormat(QgsRaster::RasterPyramidsFormat f)", "pyramidsFormat() const", "pyramidsConfigOptions() const", "createOptions() const", "pyramidsList() const", "tiledMode() const", "pyramidsResampling() const", "QgsRasterFileWriter(const QString &outputUrl)", "Mode", "setCreateOptions(const QStringList &list)", "setOutputProviderKey(const QString &key)"],
    "QgsCategorizedSymbolRendererWidget": ["categoryColumnChanged(const QString &field)", "QgsCategorizedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "addCategory()", "deleteAllCategories()", "deleteCategories()", "selectedCategoryList()", "updateUiFromRenderer()", "changeCategorizedSymbol()", "rowsMoved()", "showSymbolLevels()", "changeCategorySymbol()", "populateCategories()", "addCategories()", "categoriesDoubleClicked(const QModelIndex &idx)"],
    "QgsMapOverviewCanvas": ["enableAntiAliasing(bool flag)", "updateFullExtent()", "mapRenderingFinished()", "QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)"],
    "pal::GeomFunction": ["dist_euc2d(double x1, double y1, double x2, double y2)", "cross_product(double x1, double y1, double x2, double y2, double x3, double y3)", "findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)", "dist_euc2d_sq(double x1, double y1, double x2, double y2)"],
    "QgsRuleBasedRenderer::Rule": ["label() const", "symbol()", "toSld(QDomDocument &doc, QDomElement &element, QgsStringMap props) const", "save(QDomDocument &doc, QgsSymbolMap &symbolMap) const", "setLabel(const QString &label)", "dependsOnScale() const", "initFilter()"],
    "QgsErrorItem": ["QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)"],
    "QgsRendererRulePropsDialog": ["testFilter()", "buildExpression()", "rule()"],
    "QgsSvgMarkerSymbolLayerWidget": ["setGuiForSvg(const QgsSvgMarkerSymbolLayer *layer)", "populateList()"],
    "QgsGeometryTypeCheckError": ["QgsGeometryTypeCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsWkbTypes::Type flatType)"],
    "QgsGmlFeatureClass": ["QgsGmlFeatureClass(const QString &name, const QString &path)", "fields()", "path() const", "geometryAttributes()", "fieldIndex(const QString &name)"],
    "QgsRasterProjector": ["precisionLabel(Precision precision)", "precision() const", "setPrecision(Precision precision)"],
    "QgsVectorDataProvider": ["convertValue(QVariant::Type type, const QString &value)"],
    "QgsRasterNuller": ["noData(int bandNo) const", "QgsRasterNuller(QgsRasterInterface *input=nullptr)", "setNoData(int bandNo, const QgsRasterRangeList &noData)"],
    "QgsRasterBandStats": ["Stats"],
    "QgsGlowEffect": ["QgsGlowEffect(const QgsGlowEffect &other)"],
    "pal::LabelInfo": ["LabelInfo(int num, double height, double maxinangle=20.0, double maxoutangle=-20.0)"],
    "QgsSmartGroupEditorDialog": ["QgsSmartGroupEditorDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsMultiBandColorRenderer": ["redContrastEnhancement() const", "setRedBand(int band)", "setBlueBand(int band)", "blueContrastEnhancement() const", "QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)", "greenContrastEnhancement() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "setGreenBand(int band)", "blueBand() const", "redBand() const", "greenBand() const"],
    "QgsSlider": ["variantValue() const", "setMaximum(const QVariant &max)", "valueChanged(const QVariant &)", "setSingleStep(const QVariant &step)", "setValue(const QVariant &value)", "setMinimum(const QVariant &min)"],
    "QgsVectorLayerCache": ["QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)"],
    "QgsDirectoryParamWidget": ["showHideColumn()", "QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)"],
    "QgsAttributeDialog": ["attributeForm()", "feature()"],
    "QgsRasterPyramidsOptionsWidget": ["resamplingMethod() const", "configOptions() const", "apply()", "overviewList() const", "checkAllLevels(bool checked)", "someValueChanged()", "createOptionsWidget()", "setRasterFileName(const QString &file)", "pyramidsFormat() const", "setRasterLayer(QgsRasterLayer *rasterLayer)", "overviewListChanged()"],
    "QgsVertexId": ["vertexEqual(QgsVertexId o) const", "ringEqual(QgsVertexId o) const", "isValid(const QgsAbstractGeometry *geom) const", "QgsVertexId(int _part=-1, int _ring=-1, int _vertex=-1, VertexType _type=SegmentVertex)", "VertexType", "partEqual(QgsVertexId o) const"],
    "QgsPointLocator": ["destroyIndex()", "rebuildIndex(int maxFeaturesToIndex=-1)"],
    "QgsVectorFileWriter::SetOption": ["SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)"],
    "QgsAbstractFeatureSource": ["iteratorClosed(QgsAbstractFeatureIterator *it)", "iteratorOpened(QgsAbstractFeatureIterator *it)"],
    "QgsApplication": ["QgsApplication(int &argc, char **argv, bool GUIenabled, const QString &profileFolder=QString(), const QString &platformName=\"desktop\")"],
    "QgsLayerItem": ["iconPoint()", "iconPolygon()", "iconTable()", "iconRaster()", "QgsLayerItem(QgsDataItem *parent, const QString &name, const QString &path, const QString &uri, LayerType layerType, const QString &providerKey)", "LayerType", "iconLine()", "iconDefault()"],
    "QgsLayerTreeModelLegendNode": ["LegendNodeRoles", "isScaleOK(double scale) const", "isEmbeddedInParent() const", "setUserLabel(const QString &userLabel)", "setEmbeddedInParent(bool embedded)", "userLabel() const"],
    "QgsCheckBoxConfigDlg": ["QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsCptCityColorRampItem": ["QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)", "init()", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)", "ramp() const"],
    "QgsSingleCategoryDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)"],
    "QgsRelationReferenceWidget": ["CanvasExtent", "setEditorContext(const QgsAttributeEditorContext &context, QgsMapCanvas *canvas, QgsMessageBar *messageBar)", "QgsRelationReferenceWidget(QWidget *parent)", "setAllowMapIdentification(bool allowMapIdentification)", "setOpenFormButtonVisible(bool openFormButtonVisible)", "setReadOnlySelector(bool readOnly)", "setRelationEditable(bool editable)", "init()", "setEmbedForm(bool display)", "setRelation(const QgsRelation &relation, bool allowNullValue)"],
    "QgsRasterLayerSaveAsDialog": ["buildPyramidsFlag() const", "outputRectangle() const", "maximumTileSizeY() const", "nRows() const", "outputFormat() const", "nColumns() const", "ResolutionState", "pyramidsResamplingMethod() const", "pyramidsFormat() const", "hideOutput()", "yResolution() const", "pyramidsConfigOptions() const", "maximumTileSizeX() const", "hideFormat()", "createOptions() const", "tileMode() const", "pyramidsList() const", "mode() const", "xResolution() const", "noData() const", "CrsState", "Mode", "outputFileName() const", "outputCrs()"],
    "QgsCptCityCollectionItem": ["setPopulated()", "childrenRamps(bool recursive)", "addChild(QgsCptCityDataItem *item)", "QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)"],
    "QgsFields": ["FieldOrigin"],
    "QgsLegendSettings": ["columnCount() const", "wrapChar() const", "setUseAdvancedEffects(bool use)", "dpi() const", "splitLayer() const", "setSymbolSize(QSizeF s)", "lineSpacing() const", "columnSpace() const", "useAdvancedEffects() const", "symbolSize() const", "setWrapChar(const QString &t)", "setWmsLegendSize(QSizeF s)", "setTitle(const QString &t)", "setMmPerMapUnit(double mmPerMapUnit)", "boxSpace() const", "title() const", "setFontColor(const QColor &c)", "setStyle(QgsLegendStyle::Style s, const QgsLegendStyle &style)", "setEqualColumnWidth(bool s)", "setSplitLayer(bool s)", "mmPerMapUnit() const", "wmsLegendSize() const", "setColumnSpace(double s)", "setBoxSpace(double s)", "fontColor() const", "setDpi(int dpi)", "equalColumnWidth() const", "setLineSpacing(double s)", "setColumnCount(int c)"],
    "QgsRuggednessFilter": ["QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsExpression": ["Functions()", "BuiltinFunctions()", "SpatialOperator"],
    "QgsGraduatedSymbolRenderer": ["GraduatedMethod", "addClass(QgsSymbol *symbol)", "updateRangeLabel(int rangeIndex, const QString &label)", "ranges() const", "setClassAttribute(const QString &attr)", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "QgsGraduatedSymbolRenderer(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())", "sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "updateRangeUpperValue(int rangeIndex, double value)", "deleteAllClasses()", "deleteClass(int idx)", "updateRangeSymbol(int rangeIndex, QgsSymbol *symbol)", "updateRangeLowerValue(int rangeIndex, double value)", "classAttribute() const"],
    "QgsSingleBandGrayRenderer": ["gradient() const", "Gradient", "create(const QDomElement &elem, QgsRasterInterface *input)", "setGrayBand(int band)", "setGradient(Gradient gradient)", "grayBand() const", "QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)", "contrastEnhancement() const"],
    "QgsMapLayerLegendUtils": ["setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)", "legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)", "hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "legendNodeOrder(QgsLayerTreeLayer *nodeLayer)"],
    "QgsBlurWidget": ["create()", "QgsBlurWidget(QWidget *parent=nullptr)"],
    "QgsVectorFieldSymbolLayer": ["VectorFieldType", "AngleOrientation", "setAngleOrientation(AngleOrientation orientation)", "angleUnits() const", "createFromSld(QDomElement &element)", "setYAttribute(const QString &attribute)", "create(const QgsStringMap &properties=QgsStringMap())", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "vectorFieldType() const", "angleOrientation() const", "distanceMapUnitScale() const", "setAngleUnits(AngleUnits units)", "setVectorFieldType(VectorFieldType type)", "scale() const", "yAttribute() const", "AngleUnits", "setScale(double s)", "setXAttribute(const QString &attribute)", "xAttribute() const"],
    "QgsLineSymbolLayer": ["QgsLineSymbolLayer(bool locked=false)", "setWidthMapUnitScale(const QgsMapUnitScale &scale)", "widthMapUnitScale() const"],
    "QgsBrowserModel": ["beginRemoveItems(QgsDataItem *parent, int first, int last)", "endInsertItems()", "endRemoveItems()", "updateProjectHome()", "itemStateChanged(QgsDataItem *item, QgsDataItem::State oldState)", "beginInsertItems(QgsDataItem *parent, int first, int last)", "ItemDataRole", "itemDataChanged(QgsDataItem *item)", "removeRootItems()"],
    "QgsOfflineEditing": ["ProgressMode"],
    "QgsAttributeTableView": ["repaintRequested(const QModelIndexList &indexes)", "repaintRequested()", "finished()", "selectRow(int row)", "setModel(QgsAttributeTableFilterModel *filterModel)", "_q_selectRow(int row)"],
    "QgsDataItem": ["children() const", "rowCount()", "type() const", "endRemoveItems()", "deleteLater(QVector< QgsDataItem * > &items)", "State", "setPath(const QString &path)", "findItem(QVector< QgsDataItem * > items, QgsDataItem *item)", "Capability", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "endInsertItems()", "refresh()", "populate(const QVector< QgsDataItem * > &children)", "dataChanged(QgsDataItem *item)", "toolTip() const", "childrenCreated()", "hasChildren()", "beginInsertItems(QgsDataItem *parent, int first, int last)", "Type", "icon()", "stateChanged(QgsDataItem *item, QgsDataItem::State oldState)", "setIconName(const QString &iconName)", "path() const", "populate(bool foreground=false)", "setIcon(const QIcon &icon)", "setToolTip(const QString &msg)"],
    "QgsCollapsibleGroupBox": ["saveCheckedState()", "saveCollapsedState()", "setSettings(QgsSettings *settings)", "QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "init()", "saveKey() const", "QgsCollapsibleGroupBox(QWidget *parent=nullptr, QgsSettings *settings=nullptr)"],
    "QgsEditorWidgetRegistry": ["createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QVariantMap &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())"],
    "QgsGeometryDegeneratePolygonCheck": ["ResolutionMethod", "factoryDescription()", "factoryCompatibleGeometryTypes()", "QgsGeometryDegeneratePolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsRendererAbstractMetadata": ["createRendererFromSld(QDomElement &elem, QgsWkbTypes::GeometryType geomType)"],
    "QgsCptCitySelectionItem": ["QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "parseXml()", "selectionsList() const"],
    "QgsLabelingEngine": ["processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)"],
    "QgsAttributeFormInterface": ["acceptChanges(const QgsFeature &feature)", "form()", "feature()", "QgsAttributeFormInterface(QgsAttributeForm *form)", "initForm()", "featureChanged()"],
    "QgsProjectFileTransform": ["updateRevision(const QgsProjectVersion &version)", "convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)"],
    "QgsColorEffectWidget": ["QgsColorEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsAttributeTableMapLayerAction": ["execute()", "QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)"],
    "QgsGeometryDuplicateCheck": ["ResolutionMethod", "factoryDescription()", "QgsGeometryDuplicateCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsCptCityAllRampsItem": ["QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem * > &items)"],
    "QgsMapCanvas": ["clearExtentHistory()", "setCurrentLayer(QgsMapLayer *layer)"],
    "QgsRendererWidget": ["contextMenuViewCategories(QPoint p)", "paste()", "copy()", "QgsRendererWidget(QgsVectorLayer *layer, QgsStyle *style)", "refreshSymbolView()"],
    "QgsPalettedRendererWidget": ["QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())", "create(QgsRasterLayer *layer, const QgsRectangle &extent)", "setFromRenderer(const QgsRasterRenderer *r)"],
    "QgsMapToolEdit": ["QgsMapToolEdit(QgsMapCanvas *canvas)", "createGeometryRubberBand(QgsWkbTypes::GeometryType geometryType=QgsWkbTypes::LineGeometry, bool alternativeBand=false) const"],
    "QgsRasterShaderFunction": ["minimumMaximumRange() const", "QgsRasterShaderFunction(double minimumValue=0.0, double maximumValue=255.0)"],
    "QgsSimpleFillSymbolLayerWidget": ["setStrokeColor(const QColor &color)", "setColor(const QColor &color)"],
    "QgsAttributeTableFilterModel": ["mapFromMaster(const QModelIndex &sourceIndex) const", "fidToIndexList(QgsFeatureId fid)", "mapToMaster(const QModelIndex &proxyIndex) const"],
    "QgsMessageViewer": ["setCheckBoxState(Qt::CheckState state)", "setMessageAsPlainText(const QString &msg)", "setCheckBoxQgsSettingsLabel(const QString &label)", "setCheckBoxVisible(bool visible)", "setMessageAsHtml(const QString &msg)", "checkBoxState()", "setCheckBoxText(const QString &text)", "QgsMessageViewer(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags, bool deleteOnClose=true)"],
    "QgsCacheIndexFeatureId": ["QgsCacheIndexFeatureId(QgsVectorLayerCache *)"],
    "QgsGeometryContainedCheck": ["ResolutionMethod", "factoryDescription()", "QgsGeometryContainedCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryId()", "factoryIsCompatible(QgsVectorLayer *layer)"],
    "QgsPenJoinStyleComboBox": ["penJoinStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)", "QgsPenJoinStyleComboBox(QWidget *parent=nullptr)"],
    "QgsVectorLayerRenderer": ["QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)"],
    "QgsClipToMinMaxEnhancement": ["QgsClipToMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsMapRendererQImageJob": ["QgsMapRendererQImageJob(const QgsMapSettings &settings)"],
    "QgsDataDefinedSizeDialog": ["QgsDataDefinedSizeDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsLayerTreeViewDefaultActions": ["actionRemoveGroupOrLayer(QObject *parent=nullptr)", "uniqueGroupName(QgsLayerTreeGroup *parentGroup)", "renameGroupOrLayer()", "actionRenameGroupOrLayer(QObject *parent=nullptr)", "addGroup()", "groupSelected()", "zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer * > &layers)", "actionShowFeatureCount(QObject *parent=nullptr)", "showInOverview()", "zoomToGroup(QgsMapCanvas *canvas)", "actionShowInOverview(QObject *parent=nullptr)", "showFeatureCount()", "zoomToGroup()", "actionAddGroup(QObject *parent=nullptr)", "QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)", "removeGroupOrLayer()", "actionZoomToLayer(QgsMapCanvas *canvas, QObject *parent=nullptr)", "zoomToLayer(QgsMapCanvas *canvas)", "actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)", "actionGroupSelected(QObject *parent=nullptr)", "zoomToLayer()"],
    "QgsStyleExportImportDialog": ["doExportImport()", "importTypeChanged(int)"],
    "QgsRasterMatrix": ["divide(const QgsRasterMatrix &other)", "greaterEqual(const QgsRasterMatrix &other)", "lesserThan(const QgsRasterMatrix &other)", "notEqual(const QgsRasterMatrix &other)", "log10()", "logicalAnd(const QgsRasterMatrix &other)", "QgsRasterMatrix(const QgsRasterMatrix &m)", "tangens()", "atangens()", "logicalOr(const QgsRasterMatrix &other)", "nRows() const", "asinus()", "equal(const QgsRasterMatrix &other)", "nColumns() const", "log()", "greaterThan(const QgsRasterMatrix &other)", "OneArgOperator", "cosinus()", "multiply(const QgsRasterMatrix &other)", "setNodataValue(double d)", "setData(int cols, int rows, double *data, double nodataValue)", "number() const", "TwoArgOperator", "power(const QgsRasterMatrix &other)", "lesserEqual(const QgsRasterMatrix &other)", "changeSign()", "acosinus()", "nodataValue() const", "squareRoot()", "sinus()"],
    "QgsGpsDetector": ["advance()", "QgsGpsDetector(const QString &portName)", "connDestroyed(QObject *)", "detectionFailed()", "availablePorts()", "detected(const QgsGpsInformation &)"],
    "QgsClipper": ["trimPolygon(QPolygonF &pts, const QgsRectangle &clipRect)"],
    "QgsPointDisplacementRendererWidget": ["QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsVectorLayerEditBuffer": ["attributeAdded(int idx)", "QgsVectorLayerEditBuffer(QgsVectorLayer *layer)", "featureDeleted(QgsFeatureId fid)", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)", "attributeDeleted(int idx)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "featureAdded(QgsFeatureId fid)", "updateLayerFields()", "committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "updateFields(QgsFields &fields)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "undoIndexChanged(int index)"],
    "ParametricLine": ["setParent(ParametricLine *paral)=0", "getDegree() const =0", "calcPoint(float t, QgsPoint *p)=0", "add(ParametricLine *pl)=0", "calcFirstDer(float t, Vector3D *v)=0", "getControlPoint(int number) const =0", "remove(int i)=0", "setControlPoly(QVector< QgsPoint * > *cp)=0", "calcSecDer(float t, Vector3D *v)=0", "changeDirection()=0", "getControlPoly() const =0", "getParent() const =0"],
    "QgsGradientFillSymbolLayerWidget": ["setGradientSpread(int index)", "setCoordinateMode(int index)", "setColor2(const QColor &color)", "setGradientType(int index)", "setColor(const QColor &color)"],
    "QgsIdentifyMenu": ["resultsIfExternalAction()", "MenuLevel", "execWithSingleResult()", "maxFeatureDisplay()", "allowMultipleReturn()", "showFeatureActions()", "maxLayerDisplay()"],
    "QgsProject": ["readDoubleEntry(const QString &scope, const QString &key, double def=0, bool *ok=nullptr) const", "readNumEntry(const QString &scope, const QString &key, int def=0, bool *ok=nullptr) const", "readBoolEntry(const QString &scope, const QString &key, bool def=false, bool *ok=nullptr) const", "readEntry(const QString &scope, const QString &key, const QString &def=QString(), bool *ok=nullptr) const", "relationManager() const"],
    "QgsTotalCurvatureFilter": ["QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsNetworkAccessManager": ["QgsNetworkAccessManager(QObject *parent=nullptr)", "requestTimedOut(QNetworkReply *)"],
    "QgsRasterMinMaxWidget": ["setBands(const QList< int > &bands)"],
    "QgsSymbolLevelItem": ["QgsSymbolLevelItem(QgsSymbol *symbol, int layer)"],
    "QgsPluginLayerType": ["name()", "QgsPluginLayerType(const QString &name)"],
    "QgsFeatureIterator": ["nextFeature(QgsFeature &f)", "close()", "rewind()"],
    "QgsExpressionFieldBuffer": ["expressions() const"],
    "QgsSvgSelectorWidget": ["svgSelected(const QString &path)", "currentSvgPath() const", "populateList()"],
    "QgsPenStyleComboBox": ["QgsPenStyleComboBox(QWidget *parent=nullptr)", "penStyle() const", "setPenStyle(Qt::PenStyle style)", "iconForPen(Qt::PenStyle style)"],
    "QgsCptCityDataItem": ["paramWidget()", "addChildItem(QgsCptCityDataItem *child, bool refresh=false)", "findItem(QVector< QgsCptCityDataItem * > items, QgsCptCityDataItem *item)", "isValid()", "children() const", "rowCount()", "name() const", "QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)", "leafCount() const", "type() const", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "endRemoveItems()", "deleteChildItem(QgsCptCityDataItem *child)", "createChildren()", "actions()", "icon(QSize size)", "populate()", "refresh()", "endInsertItems()", "setParent(QgsCptCityDataItem *parent)", "handleDrop(const QMimeData *, Qt::DropAction)", "hasChildren()", "toolTip() const", "acceptDrop()", "parent() const", "Type", "icon()", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "isPopulated()", "info() const", "removeChildItem(QgsCptCityDataItem *child)", "equal(const QgsCptCityDataItem *other)", "path() const", "shortInfo() const", "setIcon(const QIcon &icon)", "setToolTip(const QString &msg)"]
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    'QgsAuthConfigIdEdit',
    'QgsDial',
    'QgsMapLayerAction',
    'QgsSvgSelectorGroupsModel',
    'QgsLinePatternFillSymbolLayer',
    'QgsImageFillSymbolLayer',
    'QgsAuthMethodRegistry',
    'QgsExpressionNodeFunction',
    'QgsSQLStatement::Visitor',
    'QgsDiagramLayerSettings',
    'QgsRenderChecker',
    'QgsSQLStatement::NodeColumnSorted',
    'pal::FeaturePart',
    'QgsRasterResampleFilter',
    'QgsPluginManagerInterface',
    'QgsAttributes',
    'QgsRangeWidgetFactory',
    'QgsMarkerSymbol',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsAspectFilter',
    'QgsValueRelationConfigDlg',
    'QgsOgcUtils',
    'QgsGeometryMultipartCheck',
    'QgsFillSymbol',
    'QgsArrowSymbolLayerWidget',
    'QgsDataDefinedValueDialog',
    'QgsCheckboxWidgetFactory',
    'QgisVisitor',
    'QgsVectorLayerFeatureSource',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsPaintEngineHack',
    'QgsFieldExpressionWidget',
    'QgsGradientFillSymbolLayer',
    'QgsValueRelationSearchWidgetWrapper',
    'QgsMasterPasswordResetDialog',
    'QgsPointPatternFillSymbolLayer',
    'QgsDerivativeFilter',
    'QgsSymbolLayerMetadata',
    'QgsGpsConnection',
    'QgsAbstractFeatureIteratorFromSource',
    'QgsDiagramLabelFeature',
    'QgsRasterDataProvider',
    'QgsSymbolLayer',
    'QgsGpsInformation',
    'QgsActionManager',
    'QgsLUDialog',
    'QgsPointLocator_DumpTree',
    'QgsExpressionNodeBinaryOperator',
    'QgsErrorMessage',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsAuthMethodEdit',
    'QgsGenericFeatureSelectionManager',
    'QgsSQLComposerDialog::TableSelectedCallback',
    'QgsAbstractCacheIndex',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsExternalResourceWidgetWrapper',
    'QgsRuntimeProfiler',
    'QgsRasterLayer',
    'QgsMarkerSymbolLayer',
    'QgsAdvancedDigitizingDockWidget::CadConstraint',
    'QgsScaleCalculator',
    'QgsRelation',
    'QgsDiagramRenderer',
    'QgsAttributeEditorRelation',
    'QgsSymbolLevelsDialog',
    'QgsRasterRenderer',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsRenderContext',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsConnectionPool',
    'QgsProjectBadLayerHandler',
    'QgsMarkerLineSymbolLayer',
    'QgsTextLabelFeature',
    'QgsLineSymbol',
    'QgsDataDefinedWidthDialog',
    'pal::InternalException',
    'QgsCredentials',
    'QgsHistogramDiagram',
    'QgsDiagramSettings',
    'QgsSQLStatement::NodeCast',
    'QgsVectorLayerUndoCommandChangeGeometry',
    'QgsRelief',
    'QgsCsException',
    'QgsMessageLogViewer',
    'QgsDateTimeEdit',
    'QgsBilinearRasterResampler',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'QgsExpressionNode::NodeList',
    'QgsVirtualLayerDefinitionUtils',
    'QgisInterface',
    'QgsAuthIdentitiesEditor',
    'QgsLinearMinMaxEnhancement',
    'QgsActionMenu',
    'QgsMessageBar',
    'QgsMapToolAdvancedDigitizing',
    'QgsWidgetWrapper',
    'pal::CostCalculator',
    'QgsGeometrySelfContactCheck',
    'QgsSQLStatement::RecursiveVisitor',
    'QgsVectorLayerJoinBuffer',
    'QgsRequestHandler',
    'QgsExpressionHighlighter',
    'QgisPlugin',
    'QgsExpressionNodeLiteral',
    'QgsAuthConfigEdit',
    'QgsAdvancedDigitizingCanvasItem',
    'QgsFillSymbolLayer',
    'QgsVectorLayerTools',
    'QgsRendererRange',
    'QgsPointLocator_Stream',
    'QgsSQLStatement::NodeLiteral',
    'QgsRunProcess',
    'QgsDataProvider',
    'QgsVectorFileWriter::HiddenOption',
    'QgsRasterHistogram',
    'QgsDashSpaceDialog',
    'QgsCubicRasterResampler',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsAttributeFormLegacyInterface',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsAuthEditorWidgets',
    'QgsFeatureRenderer',
    'pal::PalException::UnknownFeature',
    'QgsConnectionPoolGroup',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsContrastEnhancementFunction',
    'QgsGeometryPointInPolygonCheck',
    'QgsPluginLayer',
    'QgsDiagramInterpolationSettings',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsAuthConfigSslServer',
    'QgsVirtualLayerDefinition::SourceLayer',
    'QgsLabelSorter',
    'QgsSQLStatement::NodeBinaryOperator',
    'QgsLayerDefinition',
    'QgsMapUnitScaleDialog',
    'QgsSpinBox',
    'QgsExpressionNode',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsEditorWidgetFactory',
    'QgsMessageOutput',
    'QgsProviderRegistry',
    'QgsEditorConfigWidget',
    'QgsRasterFormatSaveOptionsWidget',
    'TriDecorator',
    'QgsHiddenWidgetWrapper',
    'QgsAuthAuthoritiesEditor',
    'QgsSingleBandColorDataRenderer',
    'QgsLabelPosition',
    'QgsSQLStatement::NodeList',
    'QgsUnitSelectionWidget',
    'QgsMapToolIdentifyFeature',
    'QgsGraphAnalyzer',
    'QgsUniqueValuesWidgetWrapper',
    'QgsSQLStatement::NodeUnaryOperator',
    'QgsPixmapLabel',
    'QgsDxfRuleBasedLabelProvider',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsStaticExpressionFunction',
    'QgsDetailedItemData',
    'QgsGpsdConnection',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsRasterPipe',
    'QgsScaleVisibilityDialog',
    'QgsMessageBarItem',
    'pal::Feats',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'QgsTransaction',
    'QgsSQLStatement::NodeInOperator',
    'QgsFileWidget',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsAccessControlFilter',
    'QgsSQLComposerDialog::SQLValidatorCallback',
    'QgsRasterHistogramWidget',
    'QgsEditorWidgetWrapper',
    'QgsExpressionItemSearchProxy',
    'QgsDartMeasurement',
    'QgsCptCityDirectoryItem',
    'QgsMapToPixel',
    'QgsDateTimeEditFactory',
    'NormVecDecorator',
    'QgsMapCanvas::CanvasProperties',
    'LinTriangleInterpolator',
    'QWebFrame',
    'QgsDirectoryItem',
    'QgsRasterInterface',
    'QgsSymbol',
    'QgsExpressionFunction',
    'QgsRelationManager',
    'QgsRasterTransparencyWidget',
    'QgsPieDiagram',
    'QgsAuthConfigSelect',
    'QgsInternalGeometryEngine',
    'QgsVectorLayerFeatureIterator',
    'QgsOptionsDialogBase',
    'QgsPythonRunner',
    'QgsGeometryValidator',
    'QgsRasterRange',
    'QgsExternalResourceWidget',
    'QgsGeometrySelfIntersectionCheck',
    'QgsAttributeTableModel',
    'QgsMapToolIdentify',
    'QgsSQLStatement::NodeTableDef',
    'QgsStyleManagerDialog',
    'QgsRangeConfigDlg',
    'QgsFilterLineEdit',
    'QgsGeos',
    'QgsException',
    'QgsSymbolsListWidget',
    'QgsRuleBasedRenderer',
    'Qgis',
    'QgsCoordinateReferenceSystem',
    'QgsAuthMethodPlugins',
    'QgsSQLStatement::NodeSelectedColumn',
    'QgsGml',
    'QgsDummyConfigDlg',
    'QgsRendererCategory',
    'QgsRasterResampler',
    'QgsEnumerationWidgetFactory',
    'QgsSvgCache',
    'QgsAttributeTableDelegate',
    'QgsFeature',
    'QgsSatelliteInfo',
    'QgsAuthGuiUtils',
    'QgsAttributeEditorContext',
    'QgsGeometryDuplicateNodesCheck',
    'QgsRasterDrawer',
    'QgsBlendModeComboBox',
    'QgsExpressionNodeCondition::WhenThen',
    'pal::InternalException::WrongGeometry',
    'QgsAbstractGeometrySimplifier',
    'pal::LabelPosition',
    'QgsPointLocator_VisitorEdgesInRect',
    'QgsAuthConfigUriEdit',
    'QgsGpsConnectionRegistry',
    'QgsAuthCertInfo',
    'QgsPanelWidgetStack',
    'QgsGmlStreamingParser::LayerProperties',
    'QgsIFeatureSelectionManager',
    'QgsRaster',
    'QgsVectorLayerEditPassthrough',
    'QgsFeatureListView',
    'QgsGeometryTypeCheck',
    'QgsAuthSslErrorsDialog',
    'pal::Layer',
    'QgsSQLStatement::NodeSelect',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsAdvancedDigitizingDockWidget',
    'QgsPointLocator_VisitorNearestEdge',
    'QgsAuthCertTrustPolicyComboBox',
    'QgsPreviewEffect',
    'QgsGeometryAreaCheck',
    'QgsVectorLayerUndoCommand',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsAttributeEditorField',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsProjectVersion',
    'QgsSingleBandPseudoColorRenderer',
    'QgsAuthSslConfigDialog',
    'QgsOgcUtilsExprToFilter',
    'QgsOgcUtilsSQLStatementToFilter',
    'QgsPointLocator_VisitorNearestVertex',
    'QgsTransactionGroup',
    'QgsTolerance',
    'pal::Problem',
    'QgsAuthMethod',
    'QgsStyle',
    'QgsTextEditWrapper',
    'QgsAuthMethodConfig',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsRasterShader',
    'QgsAuthSslConfigWidget',
    'pal::PalException::NotImplemented',
    'QgsZipItem',
    'QgsSvgMarkerSymbolLayer',
    'QgsPalettedRasterRenderer',
    'QgsGraphDirector',
    'QgsRectangle',
    'QgsGeometry::Error',
    'QgsServerInterface',
    'QgsInterpolator',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsExpressionSelectionDialog',
    'QgsRasterBlock',
    'QgsSingleBandPseudoColorRendererWidget',
    'QgsRubberBand',
    'QgsAttributeEditorElement',
    'QgsHighlight',
    'QgsConstWkbPtr',
    'QgsCharacterSelectorDialog',
    'QgsMapTip',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsGeometry',
    'QgsValueMapSearchWidgetWrapper',
    'QgsMapCanvasItem',
    'QgsEncodingFileDialog',
    'QgsRendererRulePropsWidget',
    'QgsFeatureStore',
    'QgsIDWInterpolator',
    'pal::InternalException::Empty',
    'QgsTextEditConfigDlg',
    'QgsConditionalLayerStyles',
    'QgsExpressionNodeUnaryOperator',
    'QgsMessageOutputConsole',
    'QgsRelationReferenceWidgetWrapper',
    'QgsRasterCalculator',
    'QgsNineCellFilter',
    'Triangulation',
    'QgsDualView',
    'QgsAuthCrypto',
    'QgsDetailedItemWidget',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsConditionalStyle',
    'QgsGeometryFollowBoundariesCheck',
    'QgsBrightnessContrastFilter',
    'QgsDxfPaintDevice',
    'QgsLongLongValidator',
    'QgsMapLayerActionRegistry',
    'QgsHueSaturationFilter',
    'QgsPanelWidget',
    'QgsTextEditWidgetFactory',
    'QgsCachedFeatureWriterIterator',
    'QgsVectorLayerRendererInterruptionChecker',
    'QgsCredentialsNone',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsFeatureRequest',
    'QgsVectorLayer',
    'QgsSingleBandGrayRendererWidget',
    'QgsXmlUtils',
    'Vector3D',
    'QgsMapToolZoom',
    'QgsMapToolPan',
    'QgsRangeWidgetWrapper',
    'QgsPluginLayerRegistry',
    'QgsAction',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDetailedItemDelegate',
    'QgsDxfPaintEngine',
    'QgsExpressionItem',
    'QgsDateTimeEditWrapper',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsVectorFileWriter',
    'QgsSQLComposerDialog',
    'QgsMapToolCapture',
    'pal::InternalException::UnknownGeometry',
    'QgsDiagram',
    'QgsExpressionBuilderWidget',
    'QgsRendererRasterPropertiesWidget',
    'QgsRasterRendererRegistry',
    'TriangleInterpolator',
    'QgsDxfLabelProvider',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'CharacterWidget',
    'QgsSearchQueryBuilder',
    'QgsMessageLogConsole',
    'QgsVectorLayerSelectionManager',
    'QgsVector',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsMapUnitScale',
    'QgsFeatureSelectionModel',
    'QgsVectorLayerUndoCommandDeleteAttribute',
    'QgsRasterChecker',
    'QgsPkiBundle',
    'QgsAbstractFeatureIterator',
    'QgsScaleWidget',
    'QgsDataDefinedRotationDialog',
    'QgsAuthTrustedCAsDialog',
    'QgsAuthCertUtils',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsCredentialDialog',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsSpatialIndex',
    'QgsAnimatedIcon',
    'QgsRasterIterator',
    'QgsMapLayer',
    'QgsVectorLayerUndoCommandChangeAttribute',
    'QgsUniqueValuesConfigDlg',
    'QgsRuleBasedRendererModel',
    'QgsHeatmapRendererWidget',
    'QgsCapabilitiesCache',
    'QgsScaleUtils',
    'QgsError',
    'pal::PointSet',
    'QgsExpressionBuilderDialog',
    'QgsExpressionNodeColumnRef',
    'QgsBusyIndicatorDialog',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'pal::InternalException::Full',
    'QgsRendererMetadata',
    'QgsNetworkReplyParser',
    'QgsDefaultSearchWidgetWrapper',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsOWSSourceSelect',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'DualEdgeTriangulation',
    'CloughTocherInterpolator',
    'QgsTableWidgetItem',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsZonalStatistics',
    'QgsLinearMinMaxEnhancementWithClip',
    'QgsSlopeFilter',
    'QgsValueRelationWidgetWrapper',
    'QgsSymbolLayerRegistry',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsSymbolLayerAbstractMetadata',
    'QgsQueryBuilder',
    'QgsSQLStatement::NodeColumnRef',
    'QgsVirtualLayerDefinition',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsProviderMetadata',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsValueMapWidgetWrapper',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsAuthMethodMetadata',
    'QgsMapServiceException',
    'QgsEllipseSymbolLayer',
    'QgsMultiBandColorRendererWidget',
    'QgsContrastEnhancement',
    'QgsCollapsibleGroupBoxBasic',
    'pal::PalException::LayerExists',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsDataCollectionItem',
    'QgsPalLabeling',
    'pal::Pal',
    'QgsAuthCertManager',
    'QgsSymbolSelectorWidget',
    'QgsLabelSearchTree',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsProjectItem',
    'QgsVectorFileWriter::IntOption',
    'QgsWkbException',
    'QgsGeometryRubberBand',
    'QgsGeometryLineIntersectionCheck',
    'QgsAuthCertEditors',
    'QgsSymbolRenderContext',
    'QgsVertexMarker',
    'QgsRasterFileWriter',
    'QgsCategorizedSymbolRendererWidget',
    'QgsMapOverviewCanvas',
    'pal::GeomFunction',
    'QgsRuleBasedRenderer::Rule',
    'QgsErrorItem',
    'QgsRendererRulePropsDialog',
    'QgsGraphBuilderInterface',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsServerFilter',
    'QgsDataSourceUri',
    'QgsGeometryTypeCheckError',
    'QgsGmlFeatureClass',
    'QgsRasterProjector',
    'QgsTopologyPreservingSimplifier',
    'QgsMapToPixelSimplifier',
    'QgsNewVectorLayerDialog',
    'QgsRendererRegistry',
    'QgsVectorDataProvider',
    'QgsRasterNuller',
    'QgsMapMouseEvent',
    'QgsRasterBandStats',
    'QgsAuthManager',
    'QgsPointDisplacementRenderer',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsPanelWidgetWrapper',
    'QgsCredentialsConsole',
    'QgsDoubleSpinBox',
    'QgsVectorLayerUndoCommandAddAttribute',
    'pal::LabelInfo',
    'pal::PalException::UnknownLayer',
    'QgsSmartGroupEditorDialog',
    'QgsMultiBandColorRenderer',
    'QgsAuthConfigEditor',
    'QgsSimpleLineSymbolLayer',
    'QgsMapTool',
    'QgsSlider',
    'QgsVectorLayerCache',
    'QgsDirectoryParamWidget',
    'QgsAttributeDialog',
    'QgsRasterPyramidsOptionsWidget',
    'QgsVectorFileWriter::SetOption',
    'QgsPkiConfigBundle',
    'QgsApplication',
    'pal::PalStat',
    'QgsLayerDefinition::DependencySorter',
    'QgsNewMemoryLayerDialog',
    'QgsLayerItem',
    'QgsNetworkDiskCache',
    'QgsVectorLayerUndoCommandDeleteFeature',
    'QWebPage',
    'pal::PalException',
    'QgsCheckBoxConfigDlg',
    'QgsCptCityColorRampItem',
    'QgsEnumerationWidgetWrapper',
    'QgsSingleCategoryDiagramRenderer',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsCptCityCollectionItem',
    'QgsCheckboxWidgetWrapper',
    'QgsFields',
    'QgsVectorLayerUndoCommandAddFeature',
    'QgsGraphBuilder',
    'QgsRuggednessFilter',
    'QgsDialog',
    'QgsExpression',
    'QgsApplyDialog',
    'QgsGraduatedSymbolRenderer',
    'QgsColorWidgetWrapper',
    'QgsExpressionNodeCondition',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsSingleBandGrayRenderer',
    'QgsRasterTransparency',
    'QgsWebView',
    'QgsGeometryCheckFactoryT',
    'QgsMapToolEmitPoint',
    'QgsBlurWidget',
    'QgsLogger',
    'QgsPointLocator_VisitorArea',
    'QgsScaleComboBox',
    'QgsVectorFieldSymbolLayer',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsBrowserModel',
    'QgsSQLStatementCollectTableNames',
    'QgsOfflineEditing',
    'QgsMessageLog',
    'QgsDistanceArea',
    'QgsAttributeTableView',
    'QgsField',
    'pal::PalException::ValueNotInRange',
    'QgsExpressionNodeInOperator',
    'QgsColorRampShader',
    'QgsDataItem',
    'QgsGridFileWriter',
    'QgsCollapsibleGroupBox',
    'QgsValueMapWidgetFactory',
    'QgsEditorWidgetRegistry',
    'QgsSQLStatement::Node',
    'QgsRasterPyramid',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsRendererAbstractMetadata',
    'QgsNewHttpConnection',
    'QWebSettings',
    'QgsExternalResourceWidgetFactory',
    'QgsMapLayerStyleManagerWidget',
    'QgsCptCitySelectionItem',
    'QgsEditFormConfig',
    'QgsAuthServersEditor',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'pal::PalException::FeatureExists',
    'QgsAuthSslImportDialog',
    'QgsLegendStyle',
    'QgsRelation::FieldPair',
    'QgsServer',
    'Bezier3D',
    'QgsAuthImportCertDialog',
    'QgsIndexedFeature',
    'QgsGeometryDuplicateCheck',
    'QgsCptCityAllRampsItem',
    'QgsScaleRangeWidget',
    'QgsCoordinateTransform',
    'QgsMapCanvas',
    'QgsRendererWidget',
    'QgsPalettedRendererWidget',
    'QgsMapToolEdit',
    'QgsRasterShaderFunction',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsMessageViewer',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsClipToMinMaxEnhancement',
    'QgsDataDefinedSizeDialog',
    'QgsSVGFillSymbolLayer',
    'QgsAuthImportIdentityDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsNewGeoPackageLayerDialog',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsGpsDetector',
    'QgsSQLStatement::NodeFunction',
    'QgsClipper',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsUuidWidgetWrapper',
    'ParametricLine',
    'QgsSQLStatement::NodeBetweenOperator',
    'QgsSvgSelectorListModel',
    'QgsGradientFillSymbolLayerWidget',
    'pal::InternalException::NoLabelPosition',
    'QgsIdentifyMenu',
    'QgsRasterFillSymbolLayerWidget',
    'QgsOwsConnection',
    'QgsAttributeEditorContainer',
    'QgsProject',
    'QgsTotalCurvatureFilter',
    'QgsSimpleMarkerSymbolLayer',
    'QgsNetworkAccessManager',
    'QgsSQLStatement::NodeJoin',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsPluginLayerType',
    'QgsSearchWidgetWrapper',
    'QgsCachedFeatureIterator',
    'QgsFeatureIterator',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsCptCityDataItem',
    'QgsAuthCertInfoDialog',
    'QgsRasterIdentifyResult'
]

ACCEPTABLE_MISSING_BRIEF = [
    'QgsDial',
    'QgsPluginManagerInterface',
    'QgsRangeWidgetFactory',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsValueRelationConfigDlg',
    'QgsGeometryMultipartCheck',
    'QgsArrowSymbolLayerWidget',
    'QgsCheckboxWidgetFactory',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsGradientFillSymbolLayer',
    'QgsPointPatternFillSymbolLayer',
    'QgsSymbolLayer',
    'QgsLUDialog',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsRuntimeProfiler',
    'QgsRelation',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsDataDefinedWidthDialog',
    'QgsHistogramDiagram',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'pal::CostCalculator',
    'QgsRendererRangeLabelFormat',
    'QgsGeometrySelfContactCheck',
    'QgsExpressionHighlighter',
    'QgsFillSymbolLayer',
    'QgsRendererRange',
    'QgsVectorFileWriter::HiddenOption',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsFeatureRenderer',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsGeometryPointInPolygonCheck',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsLabelPosition',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsMessageBarItem',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsDartMeasurement',
    'QgsDateTimeEditFactory',
    'QgsPieDiagram',
    'QgsVectorLayerFeatureIterator',
    'QgsGeometryValidator',
    'QgsGeometrySelfIntersectionCheck',
    'QgsRangeConfigDlg',
    'QgsSymbolsListWidget',
    'QgsDummyConfigDlg',
    'QgsEnumerationWidgetFactory',
    'QgsGeometryDuplicateNodesCheck',
    'QgsVectorLayerEditPassthrough',
    'QgsGeometryTypeCheck',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsGeometryAreaCheck',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsTransactionGroup',
    'QgsStyle',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsSvgMarkerSymbolLayer',
    'QgsGeometry::Error',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsConstWkbPtr',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsRendererRulePropsWidget',
    'QgsTextEditConfigDlg',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsGeometryFollowBoundariesCheck',
    'QgsLongLongValidator',
    'QgsTextEditWidgetFactory',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsSingleBandGrayRendererWidget',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDxfPaintEngine',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsMapToolCapture',
    'QgsRendererRasterPropertiesWidget',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'QgsVectorLayerSelectionManager',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsFeatureSelectionModel',
    'QgsDataDefinedRotationDialog',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsUniqueValuesConfigDlg',
    'QgsHeatmapRendererWidget',
    'QgsScaleUtils',
    'pal::PointSet',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'QgsRuleBasedLabeling',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsMultiBandColorRendererWidget',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsPalLabeling',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsVectorFileWriter::IntOption',
    'QgsGeometryLineIntersectionCheck',
    'QgsSymbolRenderContext',
    'QgsCategorizedSymbolRendererWidget',
    'pal::GeomFunction',
    'QgsRendererRulePropsDialog',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsGeometryTypeCheckError',
    'QgsNewVectorLayerDialog',
    'QgsRuleBasedLabeling::Rule',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsSmartGroupEditorDialog',
    'QgsSlider',
    'QgsAttributeDialog',
    'QgsVectorFileWriter::SetOption',
    'QgsNewMemoryLayerDialog',
    'QgsCheckBoxConfigDlg',
    'QgsEnumerationWidgetWrapper',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsGraduatedSymbolRenderer',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsBlurWidget',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsOfflineEditing',
    'QgsValueMapWidgetFactory',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsExternalResourceWidgetFactory',
    'QgsEditFormConfig',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'QgsGeometryDuplicateCheck',
    'QgsPalettedRendererWidget',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsDataDefinedSizeDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsGradientFillSymbolLayerWidget',
    'QgsRasterFillSymbolLayerWidget',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg'
]

if __name__ == '__main__':
    for k in sorted(list(ACCEPTABLE_MISSING_DOCS.keys())):
        print('    "{}": {},'.format(k, sorted(ACCEPTABLE_MISSING_DOCS[k])))
