--
-- in-db 1 band float 32 raster
--

DROP TABLE IF EXISTS "public"."raster_tiled_3035" CASCADE;
DROP TABLE IF EXISTS "o_2_raster_tiled_3035" CASCADE;
DROP TABLE IF EXISTS "o_4_raster_tiled_3035" CASCADE;

CREATE TABLE "raster_tiled_3035" ("rid" serial PRIMARY KEY,"rast" raster,"filename" text);
CREATE TABLE "o_2_raster_tiled_3035" ("rid" serial PRIMARY KEY,"rast" raster,"filename" text);
CREATE TABLE "o_4_raster_tiled_3035" ("rid" serial PRIMARY KEY,"rast" raster,"filename" text);
INSERT INTO "raster_tiled_3035" ("rast","filename") VALUES ('0100000100000000000000394000000000000039C000000000D9204F41000000008F8B424100000000000000000000000000000000DB0B0000060005004A003C1CC66A610843880B0E431CC2194306342543B7633C43861858436E0A1143BBAD194359612743A12B334317BE4343DECE59432B621B43F0E42843132B3843AC824043E6CF48436E465A435C4D2D430FA63D43F87A4843B5494A4349454E4374F35B43906E41433AB54C43B056504358575243B1EC574322615F43'::raster,'raster_tiled_3035.tif');
INSERT INTO "o_2_raster_tiled_3035" ("rast","filename") VALUES ('0100000100000000000000494000000000000049C000000000D9204F41000000008F8B424100000000000000000000000000000000DB0B0000030003004A003C1CC6880B0E430634254386185843F0E42843AC8240436E465A433AB54C435857524322615F43'::raster,'raster_tiled_3035.tif');
INSERT INTO "o_4_raster_tiled_3035" ("rast","filename") VALUES ('0100000100000000000000594000000000000059C000000000D9204F41000000008F8B424100000000000000000000000000000000DB0B0000020001004A003C1CC6F0E42843E6CF4843'::raster,'raster_tiled_3035.tif');
CREATE INDEX ON "raster_tiled_3035" USING gist (st_convexhull("rast"));
ANALYZE "raster_tiled_3035";
CREATE INDEX ON "o_2_raster_tiled_3035" USING gist (st_convexhull("rast"));
ANALYZE "o_2_raster_tiled_3035";
CREATE INDEX ON "o_4_raster_tiled_3035" USING gist (st_convexhull("rast"));
ANALYZE "o_4_raster_tiled_3035";
SELECT AddRasterConstraints('','raster_tiled_3035','rast',TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,TRUE,TRUE,TRUE,TRUE,TRUE);
SELECT AddRasterConstraints('','o_2_raster_tiled_3035','rast',TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,TRUE,TRUE,TRUE,TRUE,TRUE);
SELECT AddRasterConstraints('','o_4_raster_tiled_3035','rast',TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,TRUE,TRUE,TRUE,TRUE,TRUE);
SELECT AddOverviewConstraints('','o_2_raster_tiled_3035','rast','','raster_tiled_3035','rast',2);
SELECT AddOverviewConstraints('','o_4_raster_tiled_3035','rast','','raster_tiled_3035','rast',4);
