
Initial setup

  $ . $TESTDIR/_exc-util.sh

=== B.1 Prune on non-targeted common changeset ===

.. {{{
..     ⊗ B
..     |
..     ◕ A
..     |
..     ● O
.. }}}
..
.. Marker exist from:
..
..  * B (prune)
..
.. Command run:
..
..  * hg push -r O
..  * hg push
..
.. Expected exchange:
..
..  * B (prune)


  $ setuprepos B.1
  creating test repo for test case B.1
  - pulldest
  - main
  - pushdest
  cd into `main` and proceed with env setup
  $ cd main
  $ mkcommit A
  $ mkcommit B
  $ hg prune -qd '0 0' .
  $ hg log -G --hidden
  x  f6fbb35d8ac9 (draft): B
  |
  @  f5bc6836db60 (draft): A
  |
  o  a9bdc8b26820 (public): O
  
  $ hg debugobsolete
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  $ cd ..
  $ cd ..


  $ cp -r B.1 B.1.a
  $ cp -r B.1 B.1.b

Actual Test (explicit push version)
-----------------------------------

  $ dotest B.1.a A
  ## Running testcase B.1.a
  # testing echange of "A" (f5bc6836db60)
  ## initial state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing "A" from main to pushdest
  pushing to pushdest
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 2 nodes
  OBSEXC: pushing 1 markers (89 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  ## pulling "f5bc6836db60" from main into pulldest
  pulling from main
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (89 bytes)
  OBSEXC: 1 markers added
  OBSEXC: DONE
  (run 'hg update' to get a working copy)
  ## post pull state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}

Actual Test (bare push version)
-----------------------------------

  $ dotest B.1.b
  ## Running testcase B.1.b
  ## initial state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  # obstore: pulldest
  ## pushing from main to pushdest
  pushing to pushdest
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: computing relevant nodes
  OBSEXC: computing markers relevant to 2 nodes
  OBSEXC: pushing 1 markers (89 bytes)
  OBSEXC: DONE
  ## post push state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  ## pulling from main into pulldest
  pulling from main
  searching for changes
  adding changesets
  adding manifests
  adding file changes
  added 1 changesets with 1 changes to 1 files
  OBSEXC: pull obsolescence markers
  OBSEXC: merging obsolescence markers (89 bytes)
  OBSEXC: 1 markers added
  OBSEXC: DONE
  (run 'hg update' to get a working copy)
  ## post pull state
  # obstore: main
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pushdest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
  # obstore: pulldest
  f6fbb35d8ac958bbe70035e4c789c18471cdc0af 0 {'date': '0 0', 'p1': 'f5bc6836db60e308a17ba08bf050154ba9c4fad7', 'user': 'test'}
