#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) Duncan Macleod (2018)
#
# This file is part of GWpy.
#
# GWpy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# GWpy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GWpy.  If not, see <http://www.gnu.org/licenses/>.

"""Test setup for gwpy
"""

import warnings

import numpy

from matplotlib import use

# ignore errors due from pyplot.show() using Agg
warnings.filterwarnings('ignore', message=".*non-GUI backend.*")

# set random seed to 1 for reproducability
numpy.random.seed(1)

# force Agg for all tests
use('agg', warn=False, force=True)
