from typing import Optional

from .. import BaseProvider, ElementsType

localized = True


class Provider(BaseProvider):
    jobs: ElementsType = (
        "Academic librarian",
        "Accommodation manager",
        "Accountant, chartered",
        "Accountant, chartered certified",
        "Accountant, chartered management",
        "Accountant, chartered public finance",
        "Accounting technician",
        "Actor",
        "Actuary",
        "Acupuncturist",
        "Administrator",
        "Administrator, arts",
        "Administrator, charities/voluntary organisations",
        "Administrator, Civil Service",
        "Administrator, education",
        "Administrator, local government",
        "Administrator, sports",
        "Adult guidance worker",
        "Adult nurse",
        "Advertising account executive",
        "Advertising account planner",
        "Advertising art director",
        "Advertising copywriter",
        "Advice worker",
        "Aeronautical engineer",
        "Agricultural consultant",
        "Agricultural engineer",
        "Aid worker",
        "Air broker",
        "Air cabin crew",
        "Air traffic controller",
        "Airline pilot",
        "Ambulance person",
        "Amenity horticulturist",
        "Analytical chemist",
        "Animal nutritionist",
        "Animal technologist",
        "Animator",
        "Applications developer",
        "Arboriculturist",
        "Archaeologist",
        "Architect",
        "Architectural technologist",
        "Archivist",
        "Armed forces logistics/support/administrative officer",
        "Armed forces operational officer",
        "Armed forces technical officer",
        "Armed forces training and education officer",
        "Art gallery manager",
        "Art therapist",
        "Artist",
        "Arts administrator",
        "Arts development officer",
        "Associate Professor",
        "Astronomer",
        "Audiological scientist",
        "Automotive engineer",
        "Banker",
        "Barista",
        "Barrister",
        "Barrister's clerk",
        "Best boy",
        "Biochemist, clinical",
        "Biomedical engineer",
        "Biomedical scientist",
        "Bonds trader",
        "Bookseller",
        "Brewing technologist",
        "Broadcast engineer",
        "Broadcast journalist",
        "Broadcast presenter",
        "Building control surveyor",
        "Building services engineer",
        "Building surveyor",
        "Buyer, industrial",
        "Buyer, retail",
        "Cabin crew",
        "Call centre manager",
        "Camera operator",
        "Careers adviser",
        "Careers information officer",
        "Cartographer",
        "Catering manager",
        "Ceramics designer",
        "Charity fundraiser",
        "Charity officer",
        "Chartered accountant",
        "Chartered certified accountant",
        "Chartered legal executive (England and Wales)",
        "Chartered loss adjuster",
        "Chartered management accountant",
        "Chartered public finance accountant",
        "Chemical engineer",
        "Chemist, analytical",
        "Chief Executive Officer",
        "Chief Financial Officer",
        "Chief Marketing Officer",
        "Chief of Staff",
        "Chief Operating Officer",
        "Chief Strategy Officer",
        "Chief Technology Officer",
        "Child psychotherapist",
        "Chiropodist",
        "Chiropractor",
        "Civil engineer, consulting",
        "Civil engineer, contracting",
        "Civil Service administrator",
        "Civil Service fast streamer",
        "Claims inspector/assessor",
        "Clinical biochemist",
        "Clinical cytogeneticist",
        "Clinical embryologist",
        "Clinical molecular geneticist",
        "Clinical psychologist",
        "Clinical research associate",
        "Clinical scientist, histocompatibility and immunogenetics",
        "Clothing/textile technologist",
        "Colour technologist",
        "Commercial art gallery manager",
        "Commercial horticulturist",
        "Commercial/residential surveyor",
        "Commissioning editor",
        "Communications engineer",
        "Community arts worker",
        "Community development worker",
        "Community education officer",
        "Community pharmacist",
        "Company secretary",
        "Comptroller",
        "Computer games developer",
        "Conference centre manager",
        "Conservation officer, historic buildings",
        "Conservation officer, nature",
        "Conservator, furniture",
        "Conservator, museum/gallery",
        "Consulting civil engineer",
        "Contracting civil engineer",
        "Contractor",
        "Control and instrumentation engineer",
        "Copy",
        "Copywriter, advertising",
        "Corporate investment banker",
        "Corporate treasurer",
        "Counselling psychologist",
        "Counsellor",
        "Curator",
        "Customer service manager",
        "Cytogeneticist",
        "Dance movement psychotherapist",
        "Dancer",
        "Data processing manager",
        "Data scientist",
        "Database administrator",
        "Dealer",
        "Dentist",
        "Designer, blown glass/stained glass",
        "Designer, ceramics/pottery",
        "Designer, exhibition/display",
        "Designer, fashion/clothing",
        "Designer, furniture",
        "Designer, graphic",
        "Designer, industrial/product",
        "Designer, interior/spatial",
        "Designer, jewellery",
        "Designer, multimedia",
        "Designer, television/film set",
        "Designer, textile",
        "Development worker, community",
        "Development worker, international aid",
        "Diagnostic radiographer",
        "Dietitian",
        "Diplomatic Services operational officer",
        "Dispensing optician",
        "Doctor, general practice",
        "Doctor, hospital",
        "Dramatherapist",
        "Drilling engineer",
        "Early years teacher",
        "Ecologist",
        "Economist",
        "Editor, commissioning",
        "Editor, film/video",
        "Editor, magazine features",
        "Editorial assistant",
        "Education administrator",
        "Education officer, community",
        "Education officer, environmental",
        "Education officer, museum",
        "Educational psychologist",
        "Electrical engineer",
        "Electronics engineer",
        "Embryologist, clinical",
        "Emergency planning/management officer",
        "Energy engineer",
        "Energy manager",
        "Engineer, aeronautical",
        "Engineer, agricultural",
        "Engineer, automotive",
        "Engineer, biomedical",
        "Engineer, broadcasting (operations)",
        "Engineer, building services",
        "Engineer, chemical",
        "Engineer, civil (consulting)",
        "Engineer, civil (contracting)",
        "Engineer, communications",
        "Engineer, control and instrumentation",
        "Engineer, drilling",
        "Engineer, electrical",
        "Engineer, electronics",
        "Engineer, energy",
        "Engineer, land",
        "Engineer, maintenance",
        "Engineer, maintenance (IT)",
        "Engineer, manufacturing",
        "Engineer, manufacturing systems",
        "Engineer, materials",
        "Engineer, mining",
        "Engineer, petroleum",
        "Engineer, production",
        "Engineer, site",
        "Engineer, structural",
        "Engineer, technical sales",
        "Engineer, water",
        "Engineering geologist",
        "English as a foreign language teacher",
        "English as a second language teacher",
        "Environmental consultant",
        "Environmental education officer",
        "Environmental health practitioner",
        "Environmental manager",
        "Equality and diversity officer",
        "Equities trader",
        "Ergonomist",
        "Estate agent",
        "Estate manager/land agent",
        "Event organiser",
        "Exercise physiologist",
        "Exhibition designer",
        "Exhibitions officer, museum/gallery",
        "Facilities manager",
        "Farm manager",
        "Fashion designer",
        "Fast food restaurant manager",
        "Field seismologist",
        "Field trials officer",
        "Film/video editor",
        "Financial adviser",
        "Financial controller",
        "Financial manager",
        "Financial planner",
        "Financial risk analyst",
        "Financial trader",
        "Fine artist",
        "Firefighter",
        "Fish farm manager",
        "Fisheries officer",
        "Fitness centre manager",
        "Food technologist",
        "Forensic psychologist",
        "Forensic scientist",
        "Forest/woodland manager",
        "Freight forwarder",
        "Furniture conservator/restorer",
        "Furniture designer",
        "Further education lecturer",
        "Futures trader",
        "Gaffer",
        "Games developer",
        "Garment/textile technologist",
        "General practice doctor",
        "Geneticist, molecular",
        "Geochemist",
        "Geographical information systems officer",
        "Geologist, engineering",
        "Geologist, wellsite",
        "Geophysical data processor",
        "Geophysicist/field seismologist",
        "Geoscientist",
        "Glass blower/designer",
        "Government social research officer",
        "Graphic designer",
        "Haematologist",
        "Health and safety adviser",
        "Health and safety inspector",
        "Health physicist",
        "Health promotion specialist",
        "Health service manager",
        "Health visitor",
        "Herbalist",
        "Heritage manager",
        "Herpetologist",
        "Higher education careers adviser",
        "Higher education lecturer",
        "Historic buildings inspector/conservation officer",
        "Holiday representative",
        "Homeopath",
        "Horticultural consultant",
        "Horticultural therapist",
        "Horticulturist, amenity",
        "Horticulturist, commercial",
        "Hospital doctor",
        "Hospital pharmacist",
        "Hotel manager",
        "Housing manager/officer",
        "Human resources officer",
        "Hydrogeologist",
        "Hydrographic surveyor",
        "Hydrologist",
        "Illustrator",
        "Immigration officer",
        "Immunologist",
        "Industrial buyer",
        "Industrial/product designer",
        "Information officer",
        "Information systems manager",
        "Insurance account manager",
        "Insurance broker",
        "Insurance claims handler",
        "Insurance risk surveyor",
        "Insurance underwriter",
        "Intelligence analyst",
        "Interior and spatial designer",
        "International aid/development worker",
        "Interpreter",
        "Investment analyst",
        "Investment banker, corporate",
        "Investment banker, operational",
        "IT consultant",
        "IT sales professional",
        "IT technical support officer",
        "IT trainer",
        "Jewellery designer",
        "Journalist, broadcasting",
        "Journalist, magazine",
        "Journalist, newspaper",
        "Land",
        "Land/geomatics surveyor",
        "Landscape architect",
        "Lawyer",
        "Learning disability nurse",
        "Learning mentor",
        "Lecturer, further education",
        "Lecturer, higher education",
        "Legal executive",
        "Legal secretary",
        "Leisure centre manager",
        "Lexicographer",
        "Librarian, academic",
        "Librarian, public",
        "Licensed conveyancer",
        "Lighting technician, broadcasting/film/video",
        "Lobbyist",
        "Local government officer",
        "Location manager",
        "Logistics and distribution manager",
        "Loss adjuster, chartered",
        "Magazine features editor",
        "Magazine journalist",
        "Maintenance engineer",
        "Make",
        "Management consultant",
        "Manufacturing engineer",
        "Manufacturing systems engineer",
        "Marine scientist",
        "Market researcher",
        "Marketing executive",
        "Materials engineer",
        "Mechanical engineer",
        "Media buyer",
        "Media planner",
        "Medical illustrator",
        "Medical laboratory scientific officer",
        "Medical physicist",
        "Medical sales representative",
        "Medical secretary",
        "Medical technical officer",
        "Mental health nurse",
        "Merchandiser, retail",
        "Merchant navy officer",
        "Metallurgist",
        "Meteorologist",
        "Microbiologist",
        "Midwife",
        "Minerals surveyor",
        "Mining engineer",
        "Mudlogger",
        "Multimedia programmer",
        "Multimedia specialist",
        "Museum education officer",
        "Museum/gallery conservator",
        "Museum/gallery curator",
        "Museum/gallery exhibitions officer",
        "Music therapist",
        "Music tutor",
        "Musician",
        "Nature conservation officer",
        "Naval architect",
        "Network engineer",
        "Neurosurgeon",
        "Newspaper journalist",
        "Nurse, adult",
        "Nurse, children's",
        "Nurse, learning disability",
        "Nurse, mental health",
        "Nutritional therapist",
        "Occupational hygienist",
        "Occupational psychologist",
        "Occupational therapist",
        "Oceanographer",
        "Office manager",
        "Oncologist",
        "Operational investment banker",
        "Operational researcher",
        "Operations geologist",
        "Ophthalmologist",
        "Optician, dispensing",
        "Optometrist",
        "Orthoptist",
        "Osteopath",
        "Outdoor activities/education manager",
        "Paediatric nurse",
        "Paramedic",
        "Passenger transport manager",
        "Patent attorney",
        "Patent examiner",
        "Pathologist",
        "Pension scheme manager",
        "Pensions consultant",
        "Personal assistant",
        "Personnel officer",
        "Petroleum engineer",
        "Pharmacist, community",
        "Pharmacist, hospital",
        "Pharmacologist",
        "Photographer",
        "Physicist, medical",
        "Physiological scientist",
        "Physiotherapist",
        "Phytotherapist",
        "Pilot, airline",
        "Planning and development surveyor",
        "Plant breeder/geneticist",
        "Podiatrist",
        "Police officer",
        "Politician's assistant",
        "Presenter, broadcasting",
        "Press photographer",
        "Press sub",
        "Primary school teacher",
        "Print production planner",
        "Printmaker",
        "Prison officer",
        "Private music teacher",
        "Probation officer",
        "Producer, radio",
        "Producer, television/film/video",
        "Product designer",
        "Product manager",
        "Product/process development scientist",
        "Production assistant, radio",
        "Production assistant, television",
        "Production designer, theatre/television/film",
        "Production engineer",
        "Production manager",
        "Professor Emeritus",
        "Programme researcher, broadcasting/film/video",
        "Programmer, applications",
        "Programmer, multimedia",
        "Programmer, systems",
        "Proofreader",
        "Psychiatric nurse",
        "Psychiatrist",
        "Psychologist, clinical",
        "Psychologist, counselling",
        "Psychologist, educational",
        "Psychologist, forensic",
        "Psychologist, occupational",
        "Psychologist, prison and probation services",
        "Psychologist, sport and exercise",
        "Psychotherapist",
        "Psychotherapist, child",
        "Psychotherapist, dance movement",
        "Public affairs consultant",
        "Public house manager",
        "Public librarian",
        "Public relations account executive",
        "Public relations officer",
        "Publishing copy",
        "Publishing rights manager",
        "Purchasing manager",
        "Quality manager",
        "Quantity surveyor",
        "Quarry manager",
        "Race relations officer",
        "Radiation protection practitioner",
        "Radio broadcast assistant",
        "Radio producer",
        "Radiographer, diagnostic",
        "Radiographer, therapeutic",
        "Ranger/warden",
        "Records manager",
        "Recruitment consultant",
        "Recycling officer",
        "Regulatory affairs officer",
        "Research officer, government",
        "Research officer, political party",
        "Research officer, trade union",
        "Research scientist (life sciences)",
        "Research scientist (maths)",
        "Research scientist (medical)",
        "Research scientist (physical sciences)",
        "Restaurant manager",
        "Restaurant manager, fast food",
        "Retail banker",
        "Retail buyer",
        "Retail manager",
        "Retail merchandiser",
        "Risk analyst",
        "Risk manager",
        "Runner, broadcasting/film/video",
        "Rural practice surveyor",
        "Sales executive",
        "Sales professional, IT",
        "Sales promotion account executive",
        "Science writer",
        "Scientific laboratory technician",
        "Scientist, audiological",
        "Scientist, biomedical",
        "Scientist, clinical (histocompatibility and immunogenetics)",
        "Scientist, forensic",
        "Scientist, marine",
        "Scientist, physiological",
        "Scientist, product/process development",
        "Scientist, research (life sciences)",
        "Scientist, research (maths)",
        "Scientist, research (medical)",
        "Scientist, research (physical sciences)",
        "Scientist, water quality",
        "Secondary school teacher",
        "Secretary/administrator",
        "Secretary, company",
        "Seismic interpreter",
        "Senior tax professional/tax inspector",
        "Set designer",
        "Ship broker",
        "Site engineer",
        "Social research officer, government",
        "Social researcher",
        "Social worker",
        "Software engineer",
        "Soil scientist",
        "Solicitor",
        "Solicitor, Scotland",
        "Sound technician, broadcasting/film/video",
        "Special educational needs teacher",
        "Special effects artist",
        "Speech and language therapist",
        "Sport and exercise psychologist",
        "Sports administrator",
        "Sports coach",
        "Sports development officer",
        "Sports therapist",
        "Stage manager",
        "Statistician",
        "Structural engineer",
        "Sub",
        "Surgeon",
        "Surveyor, building",
        "Surveyor, building control",
        "Surveyor, commercial/residential",
        "Surveyor, hydrographic",
        "Surveyor, insurance",
        "Surveyor, land/geomatics",
        "Surveyor, minerals",
        "Surveyor, mining",
        "Surveyor, planning and development",
        "Surveyor, quantity",
        "Surveyor, rural practice",
        "Systems analyst",
        "Systems developer",
        "Tax adviser",
        "Tax inspector",
        "Teacher, adult education",
        "Teacher, early years/pre",
        "Teacher, English as a foreign language",
        "Teacher, music",
        "Teacher, primary school",
        "Teacher, secondary school",
        "Teacher, special educational needs",
        "Teaching laboratory technician",
        "Technical author",
        "Technical brewer",
        "Technical sales engineer",
        "TEFL teacher",
        "Telecommunications researcher",
        "Television camera operator",
        "Television floor manager",
        "Television production assistant",
        "Television/film/video producer",
        "Textile designer",
        "Theatre director",
        "Theatre manager",
        "Theatre stage manager",
        "Theme park manager",
        "Therapeutic radiographer",
        "Therapist, art",
        "Therapist, drama",
        "Therapist, horticultural",
        "Therapist, music",
        "Therapist, nutritional",
        "Therapist, occupational",
        "Therapist, speech and language",
        "Therapist, sports",
        "Tour manager",
        "Tourism officer",
        "Tourist information centre manager",
        "Town planner",
        "Toxicologist",
        "Trade mark attorney",
        "Trade union research officer",
        "Trading standards officer",
        "Training and development officer",
        "Translator",
        "Transport planner",
        "Travel agency manager",
        "Tree surgeon",
        "Veterinary surgeon",
        "Video editor",
        "Visual merchandiser",
        "Volunteer coordinator",
        "Warden/ranger",
        "Warehouse manager",
        "Waste management officer",
        "Water engineer",
        "Water quality scientist",
        "Web designer",
        "Wellsite geologist",
        "Writer",
        "Youth worker",
    )

    def job(self, min_length: Optional[int] = None, max_length: Optional[int] = None) -> str:
        return self.random_element(self.jobs, min_length, max_length)
