/* PSPP - a program for statistical analysis.
   Copyright (C) 2018 Free Sonftware Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef OUTPUT_GROUP_ITEM_H
#define OUTPUT_GROUP_ITEM_H 1

/* Grouping items.

   A group-open item marks the beginning of a group of related output items.  A
   later group-close item ends the group.  Groups can nest. */

#include <stdbool.h>
#include "output/output-item.h"

/* A group_open item. */
struct group_open_item
  {
    struct output_item output_item;
    char *command_name;
  };

struct group_open_item *group_open_item_create (const char *command_name);

/* A group_close item. */
struct group_close_item
  {
    struct output_item output_item;
  };
struct group_close_item *group_close_item_create (void);

/* This boilerplate for group_open_item, a subclass of output_item, was
   autogenerated by mk-class-boilerplate. */

#include <assert.h>
#include "libpspp/cast.h"

extern const struct output_item_class group_open_item_class;

/* Returns true if SUPER is a group_open_item, otherwise false. */
static inline bool
is_group_open_item (const struct output_item *super)
{
  return super->class == &group_open_item_class;
}

/* Returns SUPER converted to group_open_item.  SUPER must be a
   group_open_item, as reported by is_group_open_item. */
static inline struct group_open_item *
to_group_open_item (const struct output_item *super)
{
  assert (is_group_open_item (super));
  return UP_CAST (super, struct group_open_item, output_item);
}

/* Returns INSTANCE converted to output_item. */
static inline struct output_item *
group_open_item_super (const struct group_open_item *instance)
{
  return CONST_CAST (struct output_item *, &instance->output_item);
}

/* Increments INSTANCE's reference count and returns INSTANCE. */
static inline struct group_open_item *
group_open_item_ref (const struct group_open_item *instance)
{
  return to_group_open_item (output_item_ref (&instance->output_item));
}

/* Decrements INSTANCE's reference count, then destroys INSTANCE if
   the reference count is now zero. */
static inline void
group_open_item_unref (struct group_open_item *instance)
{
  output_item_unref (&instance->output_item);
}

/* Returns true if INSTANCE's reference count is greater than 1,
   false otherwise. */
static inline bool
group_open_item_is_shared (const struct group_open_item *instance)
{
  return output_item_is_shared (&instance->output_item);
}

void group_open_item_submit (struct group_open_item *);

/* This boilerplate for group_close_item, a subclass of output_item, was
   autogenerated by mk-class-boilerplate. */

#include <assert.h>
#include "libpspp/cast.h"

extern const struct output_item_class group_close_item_class;

/* Returns true if SUPER is a group_close_item, otherwise false. */
static inline bool
is_group_close_item (const struct output_item *super)
{
  return super->class == &group_close_item_class;
}

/* Returns SUPER converted to group_close_item.  SUPER must be a
   group_close_item, as reported by is_group_close_item. */
static inline struct group_close_item *
to_group_close_item (const struct output_item *super)
{
  assert (is_group_close_item (super));
  return UP_CAST (super, struct group_close_item, output_item);
}

/* Returns INSTANCE converted to output_item. */
static inline struct output_item *
group_close_item_super (const struct group_close_item *instance)
{
  return CONST_CAST (struct output_item *, &instance->output_item);
}

/* Increments INSTANCE's reference count and returns INSTANCE. */
static inline struct group_close_item *
group_close_item_ref (const struct group_close_item *instance)
{
  return to_group_close_item (output_item_ref (&instance->output_item));
}

/* Decrements INSTANCE's reference count, then destroys INSTANCE if
   the reference count is now zero. */
static inline void
group_close_item_unref (struct group_close_item *instance)
{
  output_item_unref (&instance->output_item);
}

/* Returns true if INSTANCE's reference count is greater than 1,
   false otherwise. */
static inline bool
group_close_item_is_shared (const struct group_close_item *instance)
{
  return output_item_is_shared (&instance->output_item);
}

void group_close_item_submit (struct group_close_item *);

#endif /* output/group-item.h */
