/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.obfuscate.ClassObfuscator;
import proguard.util.Processable;

public class KotlinMultiFileFacadeFixer
implements KotlinMetadataVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
        String packagePrefix = ClassUtil.internalPackagePrefix(ClassObfuscator.hasOriginalClassName(clazz) ? clazz.getName() : ClassObfuscator.newClassName(clazz));
        for (Clazz referencedPartClass : kotlinMultiFileFacadeKindMetadata.referencedPartClasses) {
            if (!KotlinMultiFileFacadeFixer.dontObfuscate(referencedPartClass)) continue;
            packagePrefix = ClassUtil.internalPackagePrefix(referencedPartClass.getName());
            break;
        }
        for (Clazz ref : kotlinMultiFileFacadeKindMetadata.referencedPartClasses) {
            ClassObfuscator.setNewClassName(ref, packagePrefix + ClassUtil.internalShortClassName(ClassObfuscator.hasOriginalClassName(ref) ? ref.getName() : ClassObfuscator.newClassName(ref)));
        }
        String className = ClassObfuscator.newClassName(clazz);
        if (className == null) {
            className = clazz.getName();
        }
        ClassObfuscator.setNewClassName(clazz, packagePrefix + ClassUtil.internalShortClassName(className));
    }

    private static boolean dontObfuscate(Processable processable) {
        return (processable.getProcessingFlags() & 0x400000) != 0;
    }
}

