/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.renderer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.renderer.MemberViewModel;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MethodViewModel
extends MemberViewModel {
    private Clazz[] referencedClasses;
    private Map<String, Object> attributes;

    public static MethodViewModel render(Clazz clazz, Method method) {
        MethodViewModel viewModel = new MethodViewModel(clazz, method);
        viewModel.referencedClasses = MethodViewModel.renderReferenceClasses(method);
        viewModel.attributes = MethodViewModel.renderAttribute(clazz, method);
        return viewModel;
    }

    private MethodViewModel(Clazz clazz, Method method) {
        super(clazz, method);
    }

    public String renderPreview() {
        return ClassUtil.externalFullMethodDescription(((Clazz)this.model.key).getName(), ((Member)this.model.value).getAccessFlags(), ((Member)this.model.value).getName((Clazz)this.model.key), ((Member)this.model.value).getDescriptor((Clazz)this.model.key));
    }

    private static Clazz[] renderReferenceClasses(Method method) {
        final ArrayList referencedClasses = new ArrayList();
        method.referencedClassesAccept(new ClassVisitor(){

            @Override
            public void visitAnyClass(Clazz clazz) {
                referencedClasses.add(clazz);
            }
        });
        return referencedClasses.toArray(new Clazz[referencedClasses.size()]);
    }

    private static Map<String, Object> renderAttribute(Clazz clazz, Method method) {
        final TreeMap<String, Object> attributeList = new TreeMap<String, Object>();
        method.accept(clazz, new MemberVisitor(){

            @Override
            public void visitAnyMember(Clazz clazz, Member member) {
            }

            @Override
            public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                programMethod.attributesAccept(programClass, new AttributeVisitor(){
                    List<String> exceptionAttributeList = new ArrayList<String>();

                    @Override
                    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
                        StringWriter stringWriter = new StringWriter();
                        codeAttribute.accept(clazz, method, (AttributeVisitor)new ClassPrinter(new PrintWriter(stringWriter)));
                        stringWriter.flush();
                        attributeList.put("code", stringWriter.toString());
                    }

                    @Override
                    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
                        StringWriter stringWriter = new StringWriter();
                        exceptionsAttribute.accept(clazz, method, (AttributeVisitor)new ClassPrinter(new PrintWriter(stringWriter)));
                        stringWriter.flush();
                        this.exceptionAttributeList.add(stringWriter.toString());
                        if (!attributeList.containsKey("exceptions")) {
                            attributeList.put("exceptions", this.exceptionAttributeList);
                        }
                    }
                });
            }
        });
        return attributeList;
    }
}

