/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io.kotlin;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlinx.metadata.Flag;
import kotlinx.metadata.FlagsKt;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.KmClass;
import kotlinx.metadata.KmClassifier;
import kotlinx.metadata.KmConstantValue;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmContract;
import kotlinx.metadata.KmDeclarationContainer;
import kotlinx.metadata.KmEffect;
import kotlinx.metadata.KmEffectExpression;
import kotlinx.metadata.KmEffectInvocationKind;
import kotlinx.metadata.KmEffectType;
import kotlinx.metadata.KmFlexibleTypeUpperBound;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmLambda;
import kotlinx.metadata.KmPackage;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmTypeAlias;
import kotlinx.metadata.KmTypeParameter;
import kotlinx.metadata.KmTypeProjection;
import kotlinx.metadata.KmValueParameter;
import kotlinx.metadata.KmVariance;
import kotlinx.metadata.KmVersion;
import kotlinx.metadata.KmVersionRequirement;
import kotlinx.metadata.KmVersionRequirementLevel;
import kotlinx.metadata.KmVersionRequirementVersionKind;
import kotlinx.metadata.jvm.JvmExtensionsKt;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFlag;
import kotlinx.metadata.jvm.JvmMetadataUtil;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AllElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectInvocationKind;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinEffectType;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementLevel;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementVersionKind;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinCommonFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinContractVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitor.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinVersionRequirementVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.AnnotationConstructor;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataWriter
implements ClassVisitor,
KotlinMetadataVisitor,
ElementValueVisitor {
    private final ClassVisitor extraClassVisitor;
    private int k;
    private int[] mv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    private ConstantPoolEditor constantPoolEditor;
    private ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private KotlinMetadataInitializer.MetadataType currentType;
    private final BiConsumer<Clazz, String> errorHandler;
    private static final KotlinMetadataVersion COMPATIBLE_VERSION = new KotlinMetadataVersion(KotlinClassMetadata.COMPATIBLE_METADATA_VERSION);
    private KotlinMetadataVersion version;

    @Deprecated
    public KotlinMetadataWriter(WarningPrinter warningPrinter) {
        this(warningPrinter, null);
    }

    @Deprecated
    public KotlinMetadataWriter(WarningPrinter warningPrinter, ClassVisitor extraClassVisitor) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message), extraClassVisitor);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler) {
        this(errorHandler, null);
    }

    public KotlinMetadataWriter(BiConsumer<Clazz, String> errorHandler, ClassVisitor extraClassVisitor) {
        this.errorHandler = errorHandler;
        this.extraClassVisitor = extraClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.kotlinMetadataAccept(this);
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        KotlinMetadataVersion originalVersion = new KotlinMetadataVersion(kotlinMetadata.mv);
        this.version = originalVersion.canBeWritten() ? originalVersion : COMPATIBLE_VERSION;
        switch (kotlinMetadata.k) {
            case 1: {
                kotlinMetadata.accept(clazz, new KotlinClassConstructor());
                break;
            }
            case 2: {
                kotlinMetadata.accept(clazz, new KotlinFileFacadeConstructor());
                break;
            }
            case 3: {
                kotlinMetadata.accept(clazz, new KotlinSyntheticClassConstructor());
                break;
            }
            case 4: {
                kotlinMetadata.accept(clazz, new KotlinMultiFileFacadeConstructor());
                break;
            }
            case 5: {
                kotlinMetadata.accept(clazz, new KotlinMultiFilePartConstructor());
            }
        }
        Metadata metadata = JvmMetadataUtil.Metadata(this.k, this.mv, this.d1, this.d2, this.xs, this.pn, this.xi);
        KotlinClassMetadata md = KotlinClassMetadata.read(metadata);
        if (md == null) {
            String version = this.mv == null ? "unknown" : Arrays.stream(this.mv).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + " (version " + version + "). Not processing the metadata for this class.");
            return;
        }
        this.constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        try {
            clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)new AllElementValueVisitor(this))))));
        }
        catch (IllegalArgumentException e) {
            this.errorHandler.accept(clazz, "Invalid Kotlin metadata annotation for " + clazz.getName() + " (invalid Kotlin metadata field names). Not writing the metadata for this class.");
        }
        clazz.accept(this.constantPoolShrinker);
        if (this.extraClassVisitor != null) {
            clazz.accept(this.extraClassVisitor);
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(constantElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case k: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.k);
                break;
            }
            case xi: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addIntegerConstant(this.xi);
                break;
            }
            case xs: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.xs);
                break;
            }
            case pn: {
                constantElementValue.u2constantValueIndex = this.constantPoolEditor.addUtf8Constant(this.pn);
            }
        }
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.currentType = KotlinMetadataInitializer.MetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        switch (this.currentType) {
            case mv: {
                arrayElementValue.u2elementValuesCount = this.mv.length;
                ElementValue[] newMvElementValues = new ElementValue[this.mv.length];
                for (int k = 0; k < this.mv.length; ++k) {
                    newMvElementValues[k] = new ConstantElementValue('I', 0, this.constantPoolEditor.addIntegerConstant(this.mv[k]));
                }
                arrayElementValue.elementValues = newMvElementValues;
                break;
            }
            case d1: {
                arrayElementValue.u2elementValuesCount = this.d1.length;
                ElementValue[] newD1ElementValues = new ElementValue[this.d1.length];
                for (int k = 0; k < this.d1.length; ++k) {
                    newD1ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d1[k]));
                }
                arrayElementValue.elementValues = newD1ElementValues;
                break;
            }
            case d2: {
                arrayElementValue.u2elementValuesCount = this.d2.length;
                ElementValue[] newD2ElementValues = new ElementValue[this.d2.length];
                for (int k = 0; k < this.d2.length; ++k) {
                    newD2ElementValues[k] = new ConstantElementValue('s', 0, this.constantPoolEditor.addUtf8Constant(this.d2[k]));
                }
                arrayElementValue.elementValues = newD2ElementValues;
            }
        }
    }

    private static JvmMethodSignature toKotlinJvmMethodSignature(MethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        return new JvmMethodSignature(jvmMethodSignature.method, jvmMethodSignature.descriptor.toString());
    }

    private static JvmFieldSignature toKotlinJvmFieldSignature(FieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new JvmFieldSignature(jvmFieldSignature.memberName, jvmFieldSignature.descriptor);
    }

    private static KmVersionRequirementVersionKind toKmVersionRequirementVersionKind(KotlinVersionRequirementVersionKind kotlinVersionRequirementVersionKind) {
        switch (kotlinVersionRequirementVersionKind) {
            case API_VERSION: {
                return KmVersionRequirementVersionKind.API_VERSION;
            }
            case COMPILER_VERSION: {
                return KmVersionRequirementVersionKind.COMPILER_VERSION;
            }
            case LANGUAGE_VERSION: {
                return KmVersionRequirementVersionKind.LANGUAGE_VERSION;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementVersionKind.");
    }

    private static KmVersionRequirementLevel toKmVersionRequirementLevel(KotlinVersionRequirementLevel kotlinVersionRequirementLevel) {
        switch (kotlinVersionRequirementLevel) {
            case ERROR: {
                return KmVersionRequirementLevel.ERROR;
            }
            case HIDDEN: {
                return KmVersionRequirementLevel.HIDDEN;
            }
            case WARNING: {
                return KmVersionRequirementLevel.WARNING;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinVersionRequirementLevel.");
    }

    private static KmEffectType toKmEffectType(KotlinEffectType effectType) {
        switch (effectType) {
            case CALLS: {
                return KmEffectType.CALLS;
            }
            case RETURNS_CONSTANT: {
                return KmEffectType.RETURNS_CONSTANT;
            }
            case RETURNS_NOT_NULL: {
                return KmEffectType.RETURNS_NOT_NULL;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KotlinEffectType.");
    }

    private static KmEffectInvocationKind toKmEffectInvocationKind(KotlinEffectInvocationKind invocationKind) {
        if (invocationKind == null) {
            return null;
        }
        switch (invocationKind) {
            case AT_MOST_ONCE: {
                return KmEffectInvocationKind.AT_MOST_ONCE;
            }
            case EXACTLY_ONCE: {
                return KmEffectInvocationKind.EXACTLY_ONCE;
            }
            case AT_LEAST_ONCE: {
                return KmEffectInvocationKind.AT_LEAST_ONCE;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
    }

    private static KmVariance toKmVariance(KotlinTypeVariance variance) {
        switch (variance) {
            case IN: {
                return KmVariance.IN;
            }
            case INVARIANT: {
                return KmVariance.INVARIANT;
            }
            case OUT: {
                return KmVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private static KmProperty toKmProperty(KotlinPropertyMetadata kotlinPropertyMetadata) {
        return new KmProperty(KotlinMetadataWriter.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
    }

    private static KmFunction toKmFunction(KotlinFunctionMetadata kotlinFunctionMetadata) {
        return new KmFunction(KotlinMetadataWriter.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
    }

    private static KmTypeAlias toKmTypeAlias(KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        return new KmTypeAlias(KotlinMetadataWriter.convertTypeAliasFlags(kotlinTypeAliasMetadata.flags), kotlinTypeAliasMetadata.name);
    }

    private static Set<Flag> convertCommonFlags(KotlinCommonFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.hasAnnotations) {
            flagSet.add(Flag.HAS_ANNOTATIONS);
        }
        return flagSet;
    }

    private static Set<Flag> convertVisibilityFlags(KotlinVisibilityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isInternal) {
            flagSet.add(Flag.IS_INTERNAL);
        }
        if (flags.isLocal) {
            flagSet.add(Flag.IS_LOCAL);
        }
        if (flags.isPrivate) {
            flagSet.add(Flag.IS_PRIVATE);
        }
        if (flags.isProtected) {
            flagSet.add(Flag.IS_PROTECTED);
        }
        if (flags.isPublic) {
            flagSet.add(Flag.IS_PUBLIC);
        }
        if (flags.isPrivateToThis) {
            flagSet.add(Flag.IS_PRIVATE_TO_THIS);
        }
        return flagSet;
    }

    private static Set<Flag> convertModalityFlags(KotlinModalityFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isAbstract) {
            flagSet.add(Flag.IS_ABSTRACT);
        }
        if (flags.isFinal) {
            flagSet.add(Flag.IS_FINAL);
        }
        if (flags.isOpen) {
            flagSet.add(Flag.IS_OPEN);
        }
        if (flags.isSealed) {
            flagSet.add(Flag.IS_SEALED);
        }
        return flagSet;
    }

    private static int convertFunctionFlags(KotlinFunctionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(KotlinMetadataWriter.convertModalityFlags(flags.modality));
        if (flags.isDeclaration) {
            flagSet.add(Flag.Function.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Function.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Function.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Function.IS_SYNTHESIZED);
        }
        if (flags.isOperator) {
            flagSet.add(Flag.Function.IS_OPERATOR);
        }
        if (flags.isInfix) {
            flagSet.add(Flag.Function.IS_INFIX);
        }
        if (flags.isInline) {
            flagSet.add(Flag.Function.IS_INLINE);
        }
        if (flags.isTailrec) {
            flagSet.add(Flag.Function.IS_TAILREC);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Function.IS_EXTERNAL);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Function.IS_SUSPEND);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertTypeFlags(KotlinTypeFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        if (flags.isNullable) {
            flagSet.add(Flag.Type.IS_NULLABLE);
        }
        if (flags.isSuspend) {
            flagSet.add(Flag.Type.IS_SUSPEND);
        }
        if (flags.isDefinitelyNonNull) {
            flagSet.add(Flag.Type.IS_DEFINITELY_NON_NULL);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertTypeParameterFlags(KotlinTypeParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        if (flags.isReified) {
            flagSet.add(Flag.TypeParameter.IS_REIFIED);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertTypeAliasFlags(KotlinTypeAliasFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertPropertyFlags(KotlinPropertyFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(KotlinMetadataWriter.convertModalityFlags(flags.modality));
        if (flags.isDeclared) {
            flagSet.add(Flag.Property.IS_DECLARATION);
        }
        if (flags.isFakeOverride) {
            flagSet.add(Flag.Property.IS_FAKE_OVERRIDE);
        }
        if (flags.isDelegation) {
            flagSet.add(Flag.Property.IS_DELEGATION);
        }
        if (flags.isSynthesized) {
            flagSet.add(Flag.Property.IS_SYNTHESIZED);
        }
        if (flags.isVar) {
            flagSet.add(Flag.Property.IS_VAR);
        }
        if (flags.hasGetter) {
            flagSet.add(Flag.Property.HAS_GETTER);
        }
        if (flags.hasSetter) {
            flagSet.add(Flag.Property.HAS_SETTER);
        }
        if (flags.isConst) {
            flagSet.add(Flag.Property.IS_CONST);
        }
        if (flags.isLateinit) {
            flagSet.add(Flag.Property.IS_LATEINIT);
        }
        if (flags.hasConstant) {
            flagSet.add(Flag.Property.HAS_CONSTANT);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.Property.IS_EXTERNAL);
        }
        if (flags.isDelegated) {
            flagSet.add(Flag.Property.IS_DELEGATED);
        }
        if (flags.isExpect) {
            flagSet.add(Flag.Property.IS_EXPECT);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertPropertyJvmFlags(KotlinPropertyFlags flags) {
        return flags.isMovedFromInterfaceCompanion ? FlagsKt.flagsOf(JvmFlag.Property.IS_MOVED_FROM_INTERFACE_COMPANION) : 0;
    }

    private static int convertClassJvmFlags(KotlinClassFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isCompiledInCompatibilityMode) {
            flagSet.add(JvmFlag.Class.IS_COMPILED_IN_COMPATIBILITY_MODE);
        }
        if (flags.hasMethodBodiesInInterface) {
            flagSet.add(JvmFlag.Class.HAS_METHOD_BODIES_IN_INTERFACE);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertPropertyAccessorFlags(KotlinPropertyAccessorFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
        flagSet.addAll(KotlinMetadataWriter.convertModalityFlags(flags.modality));
        if (!flags.isDefault) {
            flagSet.add(Flag.PropertyAccessor.IS_NOT_DEFAULT);
        }
        if (flags.isInline) {
            flagSet.add(Flag.PropertyAccessor.IS_INLINE);
        }
        if (flags.isExternal) {
            flagSet.add(Flag.PropertyAccessor.IS_EXTERNAL);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertValueParameterFlags(KotlinValueParameterFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
        if (flags.hasDefaultValue) {
            flagSet.add(Flag.ValueParameter.DECLARES_DEFAULT_VALUE);
        }
        if (flags.isNoInline) {
            flagSet.add(Flag.ValueParameter.IS_NOINLINE);
        }
        if (flags.isCrossInline) {
            flagSet.add(Flag.ValueParameter.IS_CROSSINLINE);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    private static int convertEffectExpressionFlags(KotlinEffectExpressionFlags flags) {
        HashSet<Flag> flagSet = new HashSet<Flag>();
        if (flags.isNullCheckPredicate) {
            flagSet.add(Flag.EffectExpression.IS_NULL_CHECK_PREDICATE);
        }
        if (flags.isNegated) {
            flagSet.add(Flag.EffectExpression.IS_NEGATED);
        }
        return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
    }

    static /* synthetic */ int[] access$1702(KotlinMetadataWriter x0, int[] x1) {
        x0.mv = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1802(KotlinMetadataWriter x0, String[] x1) {
        x0.d1 = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1902(KotlinMetadataWriter x0, String[] x1) {
        x0.d2 = x1;
        return x1;
    }

    private class VersionRequirementConstructor
    implements KotlinVersionRequirementVisitor {
        private KmVersionRequirement kmVersionRequirement;
        private KmConstructor kmConstructor;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;

        VersionRequirementConstructor(KmConstructor kmConstructor) {
            this.kmConstructor = kmConstructor;
        }

        VersionRequirementConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        VersionRequirementConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        VersionRequirementConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        VersionRequirementConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        @Override
        public void visitClassVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmClass.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitConstructorVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmConstructor.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitPropertyVersionRequirement(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmProperty.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitFunctionVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmFunction.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitTypeAliasVersionRequirement(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement = new KmVersionRequirement();
            this.visitAnyVersionRequirement(clazz, kotlinVersionRequirementMetadata);
            this.kmTypeAlias.getVersionRequirements().add(this.kmVersionRequirement);
        }

        @Override
        public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
            this.kmVersionRequirement.kind = KotlinMetadataWriter.toKmVersionRequirementVersionKind(kotlinVersionRequirementMetadata.kind);
            this.kmVersionRequirement.level = KotlinMetadataWriter.toKmVersionRequirementLevel(kotlinVersionRequirementMetadata.level);
            this.kmVersionRequirement.setErrorCode(kotlinVersionRequirementMetadata.errorCode);
            this.kmVersionRequirement.setMessage(kotlinVersionRequirementMetadata.message);
            KmVersion kmVersion = new KmVersion(kotlinVersionRequirementMetadata.major, kotlinVersionRequirementMetadata.minor, kotlinVersionRequirementMetadata.patch);
            this.kmVersionRequirement.setVersion(kmVersion);
        }
    }

    private class KotlinMultiFilePartConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private KmPackage kmPackage;

        KotlinMultiFilePartConstructor() {
            this(new KmPackage());
        }

        private KotlinMultiFilePartConstructor(KmPackage kmPackage) {
            super(kmPackage);
            this.kmPackage = kmPackage;
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.propertiesAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.functionsAccept(clazz, this);
            kotlinMultiFilePartKindMetadata.typeAliasesAccept(clazz, this);
            for (KotlinPropertyMetadata propertyMetadata : kotlinMultiFilePartKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties(this.kmPackage).add(KotlinMetadataWriter.toKmProperty(propertyMetadata));
            }
            Metadata metadata = KotlinClassMetadata.Companion.writeMultiFileClassPart(this.kmPackage, kotlinMultiFilePartKindMetadata.facadeName, KotlinMetadataWriter.this.version.toArray(), kotlinMultiFilePartKindMetadata.xi).getAnnotationData();
            KotlinMetadataWriter.this.k = metadata.k();
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1802(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1902(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.xi = metadata.xi();
            KotlinMetadataWriter.this.xs = metadata.xs();
            KotlinMetadataWriter.this.pn = metadata.pn();
        }
    }

    private class KotlinMultiFileFacadeConstructor
    implements KotlinMetadataVisitor {
        private KotlinMultiFileFacadeConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            Metadata metadata = KotlinClassMetadata.Companion.writeMultiFileClassFacade(kotlinMultiFileFacadeKindMetadata.partClassNames, KotlinMetadataWriter.this.version.toArray(), kotlinMultiFileFacadeKindMetadata.xi).getAnnotationData();
            KotlinMetadataWriter.this.k = metadata.k();
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1802(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1902(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.xi = metadata.xi();
            KotlinMetadataWriter.this.xs = metadata.xs();
            KotlinMetadataWriter.this.pn = metadata.pn();
        }
    }

    private class KotlinSyntheticClassConstructor
    implements KotlinMetadataVisitor,
    KotlinFunctionVisitor {
        private KmLambda kmLambda = new KmLambda();

        KotlinSyntheticClassConstructor() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            Metadata metadata;
            if (kotlinSyntheticClassKindMetadata.flavor == KotlinSyntheticClassKindMetadata.Flavor.LAMBDA) {
                kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
                metadata = KotlinClassMetadata.Companion.writeLambda(this.kmLambda, KotlinMetadataWriter.this.version.toArray(), kotlinSyntheticClassKindMetadata.xi).getAnnotationData();
            } else {
                metadata = KotlinClassMetadata.Companion.writeSyntheticClass(KotlinMetadataWriter.this.version.toArray(), kotlinSyntheticClassKindMetadata.xi).getAnnotationData();
            }
            KotlinMetadataWriter.this.k = metadata.k();
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1802(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1902(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.xi = metadata.xi();
            KotlinMetadataWriter.this.xs = metadata.xs();
            KotlinMetadataWriter.this.pn = metadata.pn();
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunction kmFunction = new KmFunction(KotlinMetadataWriter.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new ValueParameterConstructor(kmFunction));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinSyntheticClassKindMetadata, new TypeParameterConstructor(kmFunction));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinSyntheticClassKindMetadata, new VersionRequirementConstructor(kmFunction));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinSyntheticClassKindMetadata, new ContractConstructor(kmFunction));
            JvmExtensionsKt.setSignature(kmFunction, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature));
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                JvmExtensionsKt.setLambdaClassOriginName(kmFunction, kotlinFunctionMetadata.lambdaClassOriginName);
            }
            this.kmLambda.setFunction(kmFunction);
        }
    }

    private class KotlinFileFacadeConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor {
        private KmPackage kmPackage;

        KotlinFileFacadeConstructor() {
            this(new KmPackage());
        }

        private KotlinFileFacadeConstructor(KmPackage kmPackage) {
            super(kmPackage);
            this.kmPackage = kmPackage;
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            kotlinFileFacadeKindMetadata.propertiesAccept(clazz, this);
            kotlinFileFacadeKindMetadata.functionsAccept(clazz, this);
            kotlinFileFacadeKindMetadata.typeAliasesAccept(clazz, this);
            for (KotlinPropertyMetadata propertyMetadata : kotlinFileFacadeKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties(this.kmPackage).add(KotlinMetadataWriter.toKmProperty(propertyMetadata));
            }
            Metadata metadata = KotlinClassMetadata.Companion.writeFileFacade(this.kmPackage, KotlinMetadataWriter.this.version.toArray(), kotlinFileFacadeKindMetadata.xi).getAnnotationData();
            KotlinMetadataWriter.this.k = metadata.k();
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1802(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1902(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.xi = metadata.xi();
            KotlinMetadataWriter.this.xs = metadata.xs();
            KotlinMetadataWriter.this.pn = metadata.pn();
        }
    }

    private class TypeParameterConstructor
    implements KotlinTypeParameterVisitor {
        private KmTypeParameter kmTypeParameter;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;

        TypeParameterConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        TypeParameterConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        TypeParameterConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        TypeParameterConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        @Override
        public void visitClassTypeParameter(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = new KmTypeParameter(KotlinMetadataWriter.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmClass.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitPropertyTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = new KmTypeParameter(KotlinMetadataWriter.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmProperty.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitFunctionTypeParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = new KmTypeParameter(KotlinMetadataWriter.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmFunction.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitAliasTypeParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            this.kmTypeParameter = new KmTypeParameter(KotlinMetadataWriter.convertTypeParameterFlags(kotlinTypeParameterMetadata.flags), kotlinTypeParameterMetadata.name, kotlinTypeParameterMetadata.id, KotlinMetadataWriter.toKmVariance(kotlinTypeParameterMetadata.variance));
            this.visitAnyTypeParameter(clazz, kotlinTypeParameterMetadata);
            this.kmTypeAlias.getTypeParameters().add(this.kmTypeParameter);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.kmTypeParameter));
            kotlinTypeParameterMetadata.annotationsAccept(clazz, new AnnotationConstructor(kmAnnotation -> JvmExtensionsKt.getAnnotations(this.kmTypeParameter).add((KmAnnotation)kmAnnotation)));
        }
    }

    private class TypeConstructor
    implements KotlinTypeVisitor {
        private KmType kmType;
        private KmType nestedKmType;
        private KmValueParameter kmValueParameter;
        private KmClass kmClass;
        private KmProperty kmProperty;
        private KmFunction kmFunction;
        private KmTypeAlias kmTypeAlias;
        private KmTypeParameter kmTypeParameter;
        private KmEffectExpression kmEffectExpression;

        TypeConstructor(KmType nestedKmType) {
            this.nestedKmType = nestedKmType;
        }

        TypeConstructor(KmValueParameter kmValueParameter) {
            this.kmValueParameter = kmValueParameter;
        }

        TypeConstructor(KmClass kmClass) {
            this.kmClass = kmClass;
        }

        TypeConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        TypeConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        TypeConstructor(KmTypeAlias kmTypeAlias) {
            this.kmTypeAlias = kmTypeAlias;
        }

        TypeConstructor(KmTypeParameter kmTypeParameter) {
            this.kmTypeParameter = kmTypeParameter;
        }

        TypeConstructor(KmEffectExpression kmEffectExpression) {
            this.kmEffectExpression = kmEffectExpression;
        }

        @Override
        public void visitTypeUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeMetadata upperBound) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(boundedType.flags));
            this.visitAnyType(clazz, upperBound);
            KmFlexibleTypeUpperBound kmFlexibleTypeUpperBound = new KmFlexibleTypeUpperBound(this.kmType, upperBound.flexibilityID);
            this.nestedKmType.setFlexibleTypeUpperBound(kmFlexibleTypeUpperBound);
        }

        @Override
        public void visitAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeMetadata abbreviation) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(abbreviatedType.flags));
            this.visitAnyType(clazz, abbreviation);
            this.nestedKmType.setAbbreviatedType(this.kmType);
        }

        @Override
        public void visitParameterUpperBound(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeMetadata upperBound) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(upperBound.flags));
            this.visitAnyType(clazz, upperBound);
            this.kmTypeParameter.getUpperBounds().add(this.kmType);
        }

        @Override
        public void visitTypeOfIsExpression(Clazz clazz, KotlinEffectExpressionMetadata kotlinEffectExprMetadata, KotlinTypeMetadata typeOfIs) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(typeOfIs.flags));
            this.visitAnyType(clazz, typeOfIs);
            this.kmEffectExpression.setInstanceType(this.kmType);
        }

        @Override
        public void visitTypeArgument(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinTypeMetadata typeArgument) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(typeArgument.flags));
            this.visitAnyType(clazz, typeArgument);
            KmTypeProjection kmTypeProjection = new KmTypeProjection(KotlinMetadataWriter.toKmVariance(typeArgument.variance), this.kmType);
            this.nestedKmType.getArguments().add(kmTypeProjection);
        }

        @Override
        public void visitStarProjection(Clazz clazz, KotlinTypeMetadata typeWithStarArg) {
            this.nestedKmType.getArguments().add(KmTypeProjection.STAR);
        }

        @Override
        public void visitOuterClass(Clazz clazz, KotlinTypeMetadata innerClass, KotlinTypeMetadata outerClass) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(outerClass.flags));
            this.visitAnyType(clazz, outerClass);
            this.nestedKmType.setOuterType(this.kmType);
        }

        @Override
        public void visitConstructorValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitConstructorValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitInlineClassUnderlyingPropertyType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            if (kotlinMetadata.underlyingPropertyName != null) {
                this.kmClass.setInlineClassUnderlyingPropertyName(kotlinMetadata.underlyingPropertyName);
            }
            if (kotlinMetadata.underlyingPropertyType != null) {
                this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinMetadata.underlyingPropertyType.flags));
                this.kmClass.setInlineClassUnderlyingType(this.kmType);
            }
            this.visitAnyType(clazz, kotlinTypeMetadata);
        }

        @Override
        public void visitSuperType(Clazz clazz, KotlinClassKindMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmClass.getSupertypes().add(this.kmType);
        }

        @Override
        public void visitPropertyType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.returnType = this.kmType;
        }

        @Override
        public void visitPropertyReceiverType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.setReceiverParameterType(this.kmType);
        }

        @Override
        public void visitPropertyValParamType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitPropertyValParamVarArgType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.setVarargElementType(this.kmType);
        }

        @Override
        public void visitFunctionReturnType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.setReturnType(this.kmType);
        }

        @Override
        public void visitFunctionReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.setReceiverParameterType(this.kmType);
        }

        @Override
        public void visitFunctionContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmFunction.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitClassContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmClass.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitPropertyContextReceiverType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmProperty.getContextReceiverTypes().add(this.kmType);
        }

        @Override
        public void visitFunctionValParamType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.type = this.kmType;
        }

        @Override
        public void visitFunctionValParamVarArgType(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmValueParameter.setVarargElementType(this.kmType);
        }

        @Override
        public void visitAliasUnderlyingType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmTypeAlias.underlyingType = this.kmType;
        }

        @Override
        public void visitAliasExpandedType(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinTypeMetadata kotlinTypeMetadata) {
            this.kmType = new KmType(KotlinMetadataWriter.convertTypeFlags(kotlinTypeMetadata.flags));
            this.visitAnyType(clazz, kotlinTypeMetadata);
            this.kmTypeAlias.setExpandedType(this.kmType);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            KmClassifier classifier;
            if (kotlinTypeMetadata.className != null) {
                String className = kotlinTypeMetadata.className.replace('$', '.');
                KmClassifier.Class classifier2 = new KmClassifier.Class(className);
                this.kmType.classifier = classifier2;
            }
            if (kotlinTypeMetadata.typeParamID >= 0) {
                classifier = new KmClassifier.TypeParameter(kotlinTypeMetadata.typeParamID);
                this.kmType.classifier = classifier;
            }
            if (kotlinTypeMetadata.aliasName != null) {
                classifier = new KmClassifier.TypeAlias(kotlinTypeMetadata.aliasName);
                this.kmType.classifier = classifier;
            }
            kotlinTypeMetadata.abbreviationAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.outerClassAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.typeArgumentsAccept(clazz, new TypeConstructor(this.kmType));
            kotlinTypeMetadata.upperBoundsAccept(clazz, new TypeConstructor(this.kmType));
            JvmExtensionsKt.setRaw(this.kmType, kotlinTypeMetadata.isRaw);
            kotlinTypeMetadata.annotationsAccept(clazz, new AnnotationConstructor(kmAnnotation -> JvmExtensionsKt.getAnnotations(this.kmType).add((KmAnnotation)kmAnnotation)));
        }
    }

    private class ValueParameterConstructor
    implements KotlinValueParameterVisitor {
        private KmValueParameter kmValueParameter;
        private KmConstructor kmConstructor;
        private KmProperty kmProperty;
        private KmFunction kmFunction;

        ValueParameterConstructor(KmConstructor kmConstructor) {
            this.kmConstructor = kmConstructor;
        }

        ValueParameterConstructor(KmProperty kmProperty) {
            this.kmProperty = kmProperty;
        }

        ValueParameterConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(KotlinMetadataWriter.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmConstructor.getValueParameters().add(this.kmValueParameter);
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(KotlinMetadataWriter.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmProperty.setSetterParameter(this.kmValueParameter);
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            this.kmValueParameter = new KmValueParameter(KotlinMetadataWriter.convertValueParameterFlags(kotlinValueParameterMetadata.flags), kotlinValueParameterMetadata.parameterName);
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)new TypeConstructor(this.kmValueParameter));
            this.kmFunction.getValueParameters().add(this.kmValueParameter);
        }
    }

    private class KotlinClassConstructor
    extends KotlinDeclarationContainerConstructor
    implements KotlinMetadataVisitor,
    KotlinConstructorVisitor {
        KmClass kmClass;

        KotlinClassConstructor() {
            this(new KmClass());
        }

        private KotlinClassConstructor(KmClass kmClass) {
            super(kmClass);
            this.kmClass = kmClass;
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            this.kmClass.setFlags(this.convertClassFlags(kotlinClassKindMetadata.flags));
            this.kmClass.setName(kotlinClassKindMetadata.className.replace('$', '.'));
            if (kotlinClassKindMetadata.companionObjectName != null) {
                this.kmClass.setCompanionObject(kotlinClassKindMetadata.companionObjectName);
            }
            kotlinClassKindMetadata.propertiesAccept(clazz, this);
            kotlinClassKindMetadata.functionsAccept(clazz, this);
            kotlinClassKindMetadata.typeAliasesAccept(clazz, this);
            for (String enumEntry : kotlinClassKindMetadata.enumEntryNames) {
                this.kmClass.getEnumEntries().add(enumEntry);
            }
            for (String nestedClass : kotlinClassKindMetadata.nestedClassNames) {
                this.kmClass.getNestedClasses().add(nestedClass);
            }
            for (String sealedSubClass : kotlinClassKindMetadata.sealedSubclassNames) {
                this.kmClass.getSealedSubclasses().add(sealedSubClass.replace('$', '.'));
            }
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, new TypeConstructor(this.kmClass));
            kotlinClassKindMetadata.typeParametersAccept(clazz, new TypeParameterConstructor(this.kmClass));
            kotlinClassKindMetadata.contextReceiverTypesAccept(clazz, new TypeConstructor(this.kmClass));
            kotlinClassKindMetadata.versionRequirementAccept(clazz, new VersionRequirementConstructor(this.kmClass));
            kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, new TypeConstructor(this.kmClass));
            for (KotlinPropertyMetadata propertyMetadata : kotlinClassKindMetadata.localDelegatedProperties) {
                JvmExtensionsKt.getLocalDelegatedProperties(this.kmClass).add(KotlinMetadataWriter.toKmProperty(propertyMetadata));
            }
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                JvmExtensionsKt.setAnonymousObjectOriginName(this.kmClass, kotlinClassKindMetadata.anonymousObjectOriginName);
            }
            JvmExtensionsKt.setJvmFlags(this.kmClass, KotlinMetadataWriter.convertClassJvmFlags(kotlinClassKindMetadata.flags));
            Metadata metadata = KotlinClassMetadata.Companion.writeClass(this.kmClass, KotlinMetadataWriter.this.version.toArray(), kotlinClassKindMetadata.xi).getAnnotationData();
            KotlinMetadataWriter.this.k = metadata.k();
            KotlinMetadataWriter.access$1702(KotlinMetadataWriter.this, metadata.mv());
            KotlinMetadataWriter.access$1802(KotlinMetadataWriter.this, metadata.d1());
            KotlinMetadataWriter.access$1902(KotlinMetadataWriter.this, metadata.d2());
            KotlinMetadataWriter.this.xi = metadata.xi();
            KotlinMetadataWriter.this.xs = metadata.xs();
            KotlinMetadataWriter.this.pn = metadata.pn();
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            KmConstructor kmConstructor = new KmConstructor(this.convertConstructorFlags(kotlinConstructorMetadata.flags));
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, new ValueParameterConstructor(kmConstructor));
            kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, new VersionRequirementConstructor(kmConstructor));
            if (kotlinConstructorMetadata.jvmSignature != null) {
                JvmExtensionsKt.setSignature(kmConstructor, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinConstructorMetadata.jvmSignature));
            }
            this.kmClass.getConstructors().add(kmConstructor);
        }

        private int convertClassFlags(KotlinClassFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
            flagSet.addAll(KotlinMetadataWriter.convertModalityFlags(flags.modality));
            if (flags.isUsualClass) {
                flagSet.add(Flag.Class.IS_CLASS);
            }
            if (flags.isInterface) {
                flagSet.add(Flag.Class.IS_INTERFACE);
            }
            if (flags.isEnumClass) {
                flagSet.add(Flag.Class.IS_ENUM_CLASS);
            }
            if (flags.isEnumEntry) {
                flagSet.add(Flag.Class.IS_ENUM_ENTRY);
            }
            if (flags.isAnnotationClass) {
                flagSet.add(Flag.Class.IS_ANNOTATION_CLASS);
            }
            if (flags.isObject) {
                flagSet.add(Flag.Class.IS_OBJECT);
            }
            if (flags.isCompanionObject) {
                flagSet.add(Flag.Class.IS_COMPANION_OBJECT);
            }
            if (flags.isInner) {
                flagSet.add(Flag.Class.IS_INNER);
            }
            if (flags.isData) {
                flagSet.add(Flag.Class.IS_DATA);
            }
            if (flags.isExternal) {
                flagSet.add(Flag.Class.IS_EXTERNAL);
            }
            if (flags.isExpect) {
                flagSet.add(Flag.Class.IS_EXPECT);
            }
            if (flags.isInline) {
                flagSet.add(Flag.Class.IS_INLINE);
            }
            if (flags.isValue) {
                flagSet.add(Flag.Class.IS_VALUE);
            }
            if (flags.isFun) {
                flagSet.add(Flag.Class.IS_FUN);
            }
            return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
        }

        private int convertConstructorFlags(KotlinConstructorFlags flags) {
            HashSet<Flag> flagSet = new HashSet<Flag>();
            flagSet.addAll(KotlinMetadataWriter.convertCommonFlags(flags.common));
            flagSet.addAll(KotlinMetadataWriter.convertVisibilityFlags(flags.visibility));
            if (flags.isPrimary) {
                flagSet.add(Flag.Constructor.IS_PRIMARY);
            }
            if (flags.isSecondary) {
                flagSet.add(Flag.Constructor.IS_SECONDARY);
            }
            if (flags.hasNonStableParameterNames) {
                flagSet.add(Flag.Constructor.HAS_NON_STABLE_PARAMETER_NAMES);
            }
            return FlagsKt.flagsOf(flagSet.toArray(new Flag[0]));
        }
    }

    private class KotlinDeclarationContainerConstructor
    implements KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinTypeAliasVisitor {
        KmDeclarationContainer kmDeclarationContainer;
        KmProperty kmProperty;

        KotlinDeclarationContainerConstructor(KmDeclarationContainer kmDeclarationContainer) {
            this.kmDeclarationContainer = kmDeclarationContainer;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.contextReceiverTypesAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(this.kmProperty));
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(this.kmProperty));
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(this.kmProperty));
            kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(this.kmProperty));
            JvmExtensionsKt.setJvmFlags(this.kmProperty, KotlinMetadataWriter.convertPropertyJvmFlags(kotlinPropertyMetadata.flags));
            JvmExtensionsKt.setGetterSignature(this.kmProperty, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.getterSignature));
            JvmExtensionsKt.setSetterSignature(this.kmProperty, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.setterSignature));
            JvmExtensionsKt.setFieldSignature(this.kmProperty, KotlinMetadataWriter.toKotlinJvmFieldSignature(kotlinPropertyMetadata.backingFieldSignature));
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                JvmExtensionsKt.setSyntheticMethodForAnnotations(this.kmProperty, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.syntheticMethodForAnnotations));
            }
            if (kotlinPropertyMetadata.syntheticMethodForDelegate != null) {
                JvmExtensionsKt.setSyntheticMethodForDelegate(this.kmProperty, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinPropertyMetadata.syntheticMethodForDelegate));
            }
        }

        @Override
        public void visitProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmProperty = new KmProperty(KotlinMetadataWriter.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
            this.kmDeclarationContainer.getProperties().add(this.kmProperty);
        }

        @Override
        public void visitDelegatedProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            this.kmProperty = new KmProperty(KotlinMetadataWriter.convertPropertyFlags(kotlinPropertyMetadata.flags), kotlinPropertyMetadata.name, KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.getterFlags), KotlinMetadataWriter.convertPropertyAccessorFlags(kotlinPropertyMetadata.setterFlags));
            this.visitAnyProperty(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata);
            this.kmDeclarationContainer.getProperties().add(this.kmProperty);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            KmFunction kmFunction = new KmFunction(KotlinMetadataWriter.convertFunctionFlags(kotlinFunctionMetadata.flags), kotlinFunctionMetadata.name);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinDeclarationContainerMetadata, new ValueParameterConstructor(kmFunction));
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.contextReceiverTypesAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmFunction));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmFunction));
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmFunction));
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinDeclarationContainerMetadata, new ContractConstructor(kmFunction));
            JvmExtensionsKt.setSignature(kmFunction, KotlinMetadataWriter.toKotlinJvmMethodSignature(kotlinFunctionMetadata.jvmSignature));
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                JvmExtensionsKt.setLambdaClassOriginName(kmFunction, kotlinFunctionMetadata.lambdaClassOriginName);
            }
            this.kmDeclarationContainer.getFunctions().add(kmFunction);
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            KmTypeAlias kmTypeAlias = new KmTypeAlias(KotlinMetadataWriter.convertTypeAliasFlags(kotlinTypeAliasMetadata.flags), kotlinTypeAliasMetadata.name);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, new TypeParameterConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, new TypeConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, new VersionRequirementConstructor(kmTypeAlias));
            kotlinTypeAliasMetadata.annotationsAccept(clazz, new AnnotationConstructor(annotion -> kmTypeAlias.getAnnotations().add((KmAnnotation)annotion)));
            this.kmDeclarationContainer.getTypeAliases().add(kmTypeAlias);
        }

        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }
    }

    private class EffectExprConstructor
    implements KotlinEffectExprVisitor {
        private KmEffectExpression kmEffectExpression;
        private KmEffect kmEffect;
        private KmEffectExpression nestedKmEffectExpression;

        private EffectExprConstructor(KmEffect kmEffect) {
            this.kmEffect = kmEffect;
        }

        private EffectExprConstructor(KmEffectExpression nestedKmEffectExpression) {
            this.nestedKmEffectExpression = nestedKmEffectExpression;
        }

        @Override
        public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression.setFlags(KotlinMetadataWriter.convertEffectExpressionFlags(kotlinEffectExpressionMetadata.flags));
            this.kmEffectExpression.setParameterIndex(kotlinEffectExpressionMetadata.parameterIndex);
            if (kotlinEffectExpressionMetadata.hasConstantValue) {
                this.kmEffectExpression.setConstantValue(new KmConstantValue(kotlinEffectExpressionMetadata.constantValue));
            }
            kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.kmEffectExpression));
            kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, new EffectExprConstructor(this.kmEffectExpression));
            kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, new TypeConstructor(this.kmEffectExpression));
        }

        @Override
        public void visitAndRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
            this.nestedKmEffectExpression.getAndArguments().addAll(this.kmEffectExpression.getAndArguments());
        }

        @Override
        public void visitOrRHSExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata lhs, KotlinEffectExpressionMetadata rhs) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, rhs);
            this.nestedKmEffectExpression.getOrArguments().addAll(this.kmEffectExpression.getOrArguments());
        }

        @Override
        public void visitConstructorArgExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
            this.kmEffect.getConstructorArguments().add(this.kmEffectExpression);
        }

        @Override
        public void visitConclusionExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
            this.kmEffectExpression = new KmEffectExpression();
            this.visitAnyEffectExpression(clazz, kotlinEffectMetadata, kotlinEffectExpressionMetadata);
            this.kmEffect.setConclusion(this.kmEffectExpression);
        }
    }

    private class EffectConstructor
    implements KotlinEffectVisitor {
        private KmContract kmContract;

        private EffectConstructor(KmContract kmContract) {
            this.kmContract = kmContract;
        }

        @Override
        public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
            KmEffect kmEffect = new KmEffect(KotlinMetadataWriter.toKmEffectType(kotlinEffectMetadata.effectType), KotlinMetadataWriter.toKmEffectInvocationKind(kotlinEffectMetadata.invocationKind));
            kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, new EffectExprConstructor(kmEffect));
            kotlinEffectMetadata.constructorArgumentAccept(clazz, new EffectExprConstructor(kmEffect));
            this.kmContract.getEffects().add(kmEffect);
        }
    }

    private class ContractConstructor
    implements KotlinContractVisitor {
        private KmFunction kmFunction;

        ContractConstructor(KmFunction kmFunction) {
            this.kmFunction = kmFunction;
        }

        @Override
        public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
            KmContract kmContract = new KmContract();
            kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, new EffectConstructor(kmContract));
            this.kmFunction.setContract(kmContract);
        }
    }
}

