/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.fixer.kotlin.KotlinAnnotationFlagFixer;
import proguard.pass.Pass;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.shrink.ClassShrinker;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.KotlinModuleShrinker;
import proguard.shrink.KotlinShrinker;
import proguard.shrink.ShortestClassUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.SimpleUsageMarker;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;
import proguard.util.PrintWriterUtil;

public class Shrinker
implements Pass {
    private static final Logger logger = LogManager.getLogger(Shrinker.class);
    private final Configuration configuration;
    private final boolean afterOptimizer;

    public Shrinker(Configuration configuration, boolean afterOptimizer) {
        this.configuration = configuration;
        this.afterOptimizer = afterOptimizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Shrinking...");
        if (this.configuration.whyAreYouKeeping != null && !this.afterOptimizer) {
            logger.info("Explaining why classes and class members are being kept...");
        }
        if (this.configuration.printUsage != null && !this.afterOptimizer) {
            logger.info("Printing usage to [" + PrintWriterUtil.fileName(this.configuration.printUsage) + "]...");
        }
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        appView.programClassPool.classesAccept(new ClassCleaner());
        appView.libraryClassPool.classesAccept(new ClassCleaner());
        SimpleUsageMarker simpleUsageMarker = this.configuration.whyAreYouKeeping == null || this.afterOptimizer ? new SimpleUsageMarker() : new ShortestUsageMarker();
        ClassUsageMarker classUsageMarker = this.configuration.whyAreYouKeeping == null || this.afterOptimizer ? new ClassUsageMarker(simpleUsageMarker) : new ShortestClassUsageMarker((ShortestUsageMarker)simpleUsageMarker, "is kept by a directive in the configuration.\n\n");
        new UsageMarker(this.configuration).mark(appView.programClassPool, appView.libraryClassPool, appView.resourceFilePool, simpleUsageMarker, classUsageMarker);
        if (this.configuration.whyAreYouKeeping != null && !this.afterOptimizer) {
            ShortestUsagePrinter shortestUsagePrinter = new ShortestUsagePrinter((ShortestUsageMarker)classUsageMarker.getUsageMarker(), this.configuration.verbose, out);
            ClassPoolVisitor whyClassPoolvisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.whyAreYouKeeping, shortestUsagePrinter, shortestUsagePrinter);
            appView.programClassPool.accept(whyClassPoolvisitor);
            appView.libraryClassPool.accept(whyClassPoolvisitor);
        }
        if (this.configuration.printUsage != null && !this.afterOptimizer) {
            PrintWriter usageWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printUsage);
            try {
                appView.programClassPool.classesAcceptAlphabetically(new UsagePrinter(simpleUsageMarker, true, usageWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printUsage, usageWriter);
            }
        }
        ClassPool newProgramClassPool = new ClassPool();
        appView.programClassPool.classesAccept(new UsedClassFilter(simpleUsageMarker, new MultiClassVisitor(new ClassShrinker(simpleUsageMarker), new ClassPoolFiller(newProgramClassPool))));
        appView.libraryClassPool.classesAccept(new UsedClassFilter(simpleUsageMarker, new ClassShrinker(simpleUsageMarker)));
        if (this.configuration.keepKotlinMetadata) {
            newProgramClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinShrinker(simpleUsageMarker)));
            newProgramClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinAnnotationFlagFixer()));
            appView.resourceFilePool.resourceFilesAccept(new ResourceFileProcessingFlagFilter(0, 32768, new KotlinModuleShrinker(simpleUsageMarker)));
        }
        int newProgramClassPoolSize = newProgramClassPool.size();
        ClassCounter originalClassCounter = new ClassCounter();
        appView.programClassPool.classesAccept(new ClassProcessingFlagFilter(0, 512, originalClassCounter));
        ClassCounter newClassCounter = new ClassCounter();
        newProgramClassPool.classesAccept(new ClassProcessingFlagFilter(0, 512, newClassCounter));
        logger.info("Removing unused program classes and class elements...");
        logger.info("  Original number of program classes:            {}", (Object)originalClassCounter.getCount());
        logger.info("  Final number of program classes:               {}", (Object)newClassCounter.getCount());
        if (newClassCounter.getCount() != newProgramClassPoolSize) {
            logger.info("  Final number of program and injected classes:  {}", (Object)newProgramClassPoolSize);
        }
        if (!(newProgramClassPoolSize != 0 || this.configuration.warn != null && this.configuration.warn.isEmpty())) {
            if (this.configuration.ignoreWarnings) {
                logger.warn("Warning: the output jar is empty. Did you specify the proper '-keep' options?");
            } else {
                throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
            }
        }
        appView.programClassPool.clear();
        newProgramClassPool.classesAccept(new ClassPoolFiller(appView.programClassPool));
    }
}

