/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.FinalFieldAssignmentMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.ProgramMethodOptimizationInfo;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;
import proguard.util.ProcessingFlagSetter;

public abstract class MethodInliner
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
MemberVisitor,
ExceptionInfoVisitor,
LineNumberInfoVisitor {
    protected static final int MAXIMUM_INLINED_CODE_LENGTH_JVM = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "8"));
    protected static final int MAXIMUM_INLINED_CODE_LENGTH_android = Integer.parseInt(System.getProperty("maximum.inlined.code.length", "32"));
    protected static final int MAXIMUM_RESULTING_CODE_LENGTH_JSE = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "7000"));
    protected static final int MAXIMUM_RESULTING_CODE_LENGTH_JME = Integer.parseInt(System.getProperty("maximum.resulting.code.length", "2000"));
    protected static final int MAXIMUM_RESULTING_CODE_LENGTH_JVM = 65535;
    static final int METHOD_DUMMY_START_LINE_NUMBER = 0;
    static final int INLINED_METHOD_END_LINE_NUMBER = -1;
    private static final Logger logger = LogManager.getLogger(MethodInliner.class);
    protected final boolean microEdition;
    protected final boolean android;
    protected final int maxResultingCodeLength;
    protected final boolean allowAccessModification;
    protected final boolean usesOptimizationInfo;
    protected final InstructionVisitor extraInlinedInvocationVisitor;
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
    private final MemberVisitor accessMethodMarker = new OptimizationInfoMemberFilter(new AllAttributeVisitor(new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new AccessMethodMarker()))));
    private final AttributeVisitor methodInvocationMarker = new AllInstructionVisitor(new MethodInvocationMarker());
    private final StackSizeComputer stackSizeComputer = new StackSizeComputer();
    private ProgramClass targetClass;
    private ProgramMethod targetMethod;
    private ConstantAdder constantAdder;
    private ExceptionInfoAdder exceptionInfoAdder;
    private int estimatedResultingCodeLength;
    private boolean inlining;
    private Stack inliningMethods = new Stack();
    private boolean emptyInvokingStack;
    private boolean coveredByCatchAllHandler;
    private int exceptionInfoCount;
    private int uninitializedObjectCount;
    private int variableOffset;
    private boolean inlined;
    private boolean inlinedAny;
    private boolean copiedLineNumbers;
    private String source;
    private int minimumLineNumberIndex;

    public MethodInliner(boolean microEdition, boolean android, boolean allowAccessModification) {
        this(microEdition, android, allowAccessModification, null);
    }

    public MethodInliner(boolean microEdition, boolean android, boolean allowAccessModification, InstructionVisitor extraInlinedInvocationVisitor) {
        this(microEdition, android, MethodInliner.defaultMaxResultingCodeLength(microEdition), allowAccessModification, true, extraInlinedInvocationVisitor);
    }

    public MethodInliner(boolean microEdition, boolean android, int maxResultingCodeLength, boolean allowAccessModification, boolean usesOptimizationInfo, InstructionVisitor extraInlinedInvocationVisitor) {
        if (maxResultingCodeLength > 65535) {
            throw new IllegalArgumentException("Maximum resulting code length cannot exceed 65535");
        }
        this.microEdition = microEdition;
        this.android = android;
        this.maxResultingCodeLength = maxResultingCodeLength;
        this.allowAccessModification = allowAccessModification;
        this.usesOptimizationInfo = usesOptimizationInfo;
        this.extraInlinedInvocationVisitor = extraInlinedInvocationVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        block4: {
            try {
                this.visitCodeAttribute0(clazz, method, codeAttribute);
            }
            catch (RuntimeException ex) {
                logger.error("Unexpected error while inlining method:");
                logger.error("  Target class   = [{}]", (Object)this.targetClass.getName());
                logger.error("  Target method  = [{}{}]", (Object)this.targetMethod.getName(this.targetClass), (Object)this.targetMethod.getDescriptor(this.targetClass));
                if (this.inlining) {
                    logger.error("  Inlined class  = [{}]", (Object)clazz.getName());
                    logger.error("  Inlined method = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                }
                logger.error("  Exception      = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage(), (Object)ex);
                logger.error("Not inlining this method");
                logger.debug("{}", () -> {
                    StringWriter sw = new StringWriter();
                    this.targetMethod.accept(this.targetClass, (MemberVisitor)new ClassPrinter(new PrintWriter(sw)));
                    return sw.toString();
                });
                if (this.inlining) {
                    logger.debug("{}", () -> {
                        StringWriter sw = new StringWriter();
                        method.accept(clazz, new ClassPrinter(new PrintWriter(sw)));
                        return sw.toString();
                    });
                }
                if (!logger.getLevel().isLessSpecificThan(Level.DEBUG)) break block4;
                throw ex;
            }
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.inlining) {
            this.targetClass = (ProgramClass)clazz;
            this.targetMethod = (ProgramMethod)method;
            this.constantAdder = new ConstantAdder(this.targetClass);
            this.exceptionInfoAdder = new ExceptionInfoAdder(this.targetClass, this.codeAttributeComposer);
            this.estimatedResultingCodeLength = codeAttribute.u4codeLength;
            this.inliningMethods.clear();
            this.uninitializedObjectCount = method.getName(clazz).equals("<init>") ? 1 : 0;
            this.inlinedAny = false;
            this.codeAttributeComposer.reset();
            this.stackSizeComputer.visitCodeAttribute(clazz, method, codeAttribute);
            this.copyCode(clazz, method, codeAttribute);
            if (this.inlinedAny) {
                this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
                if (this.usesOptimizationInfo) {
                    method.accept(clazz, this.accessMethodMarker);
                }
            }
            this.targetClass = null;
            this.targetMethod = null;
            this.constantAdder = null;
        } else if (this.shouldInline(clazz, method, codeAttribute) && this.estimatedResultingCodeLength + codeAttribute.u4codeLength < this.maxResultingCodeLength) {
            logger.debug("MethodInliner: inlining [{}.{}{}] in [{}.{}{}]", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz), (Object)this.targetClass.getName(), (Object)this.targetMethod.getName(this.targetClass), (Object)this.targetMethod.getDescriptor(this.targetClass));
            this.estimatedResultingCodeLength += codeAttribute.u4codeLength;
            this.storeParameters(clazz, method);
            this.copyCode(clazz, method, codeAttribute);
            this.inlined = true;
            this.inlinedAny = true;
        }
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.source = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ':' + lineNumberTableAttribute.getLowestLineNumber() + ':' + lineNumberTableAttribute.getHighestLineNumber() : null;
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        this.copiedLineNumbers = true;
    }

    private void storeParameters(Clazz clazz, Method method) {
        String parameterType;
        int parameterIndex;
        String descriptor = method.getDescriptor(clazz);
        boolean isStatic = (method.getAccessFlags() & 8) != 0;
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        int parameterOffset = isStatic ? 0 : 1;
        String[] parameterTypes = new String[parameterSize];
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        for (parameterIndex = 0; parameterIndex < parameterSize; ++parameterIndex) {
            parameterTypes[parameterIndex] = parameterType = internalTypeEnumeration.nextType();
            if (ClassUtil.internalTypeSize(parameterType) != 2) continue;
            ++parameterIndex;
        }
        this.codeAttributeComposer.beginCodeFragment(parameterSize + 1);
        for (parameterIndex = parameterSize - 1; parameterIndex >= 0; --parameterIndex) {
            byte opcode;
            parameterType = parameterTypes[parameterIndex];
            if (parameterType == null) continue;
            switch (parameterType.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    opcode = 54;
                    break;
                }
                case 'J': {
                    opcode = 55;
                    break;
                }
                case 'F': {
                    opcode = 56;
                    break;
                }
                case 'D': {
                    opcode = 57;
                    break;
                }
                default: {
                    opcode = 58;
                }
            }
            this.codeAttributeComposer.appendInstruction(parameterSize - parameterIndex - 1, new VariableInstruction(opcode, this.variableOffset + parameterOffset + parameterIndex));
        }
        if (!isStatic) {
            this.codeAttributeComposer.appendInstruction(parameterSize, new VariableInstruction(58, this.variableOffset));
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    private void copyCode(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        String source;
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        codeAttribute.exceptionsAccept(clazz, method, this.exceptionInfoAdder);
        this.targetMethod.accept(this.targetClass, (MemberVisitor)new ProcessingFlagSetter(method.getProcessingFlags() & 0x800));
        this.copiedLineNumbers = false;
        this.minimumLineNumberIndex = 0;
        codeAttribute.attributesAccept(clazz, method, this);
        if (!this.copiedLineNumbers) {
            source = this.inlining ? clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0" : null;
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(0, 0, source)) + 1;
        }
        if (this.inlining) {
            source = clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0";
            this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, new ExtendedLineNumberInfo(codeAttribute.u4codeLength, -1, source)) + 1;
        }
        this.codeAttributeComposer.endCodeFragment();
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        if (this.inlining) {
            switch (simpleInstruction.opcode) {
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (offset < codeAttribute.u4codeLength - 1) {
                        BranchInstruction branchInstruction = new BranchInstruction(-56, codeAttribute.u4codeLength - offset);
                        this.codeAttributeComposer.appendInstruction(offset, branchInstruction);
                    } else {
                        this.codeAttributeComposer.appendLabel(offset);
                    }
                    return;
                }
            }
        }
        this.codeAttributeComposer.appendInstruction(offset, simpleInstruction);
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (this.inlining) {
            variableInstruction.variableIndex += this.variableOffset;
        }
        this.codeAttributeComposer.appendInstruction(offset, variableInstruction);
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: {
                ++this.uninitializedObjectCount;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.inlined = false;
                this.codeAttributeComposer.appendLabel(offset);
                this.emptyInvokingStack = !this.inlining && this.stackSizeComputer.isReachable(offset) && this.stackSizeComputer.getStackSizeAfter(offset) == 0;
                this.variableOffset += codeAttribute.u2maxLocals;
                this.coveredByCatchAllHandler = false;
                this.exceptionInfoCount = 0;
                codeAttribute.exceptionsAccept(clazz, method, offset, this);
                this.coveredByCatchAllHandler = this.exceptionInfoCount <= 0 || this.coveredByCatchAllHandler;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                this.variableOffset -= codeAttribute.u2maxLocals;
                if (!this.inlined) break;
                if (this.extraInlinedInvocationVisitor != null) {
                    this.extraInlinedInvocationVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
                return;
            }
        }
        if (this.inlining) {
            constantInstruction.constantIndex = this.constantAdder.addConstant(clazz, constantInstruction.constantIndex);
        }
        this.codeAttributeComposer.appendInstruction(offset, constantInstruction);
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        anyMethodrefConstant.referencedMethodAccept(this);
    }

    @Override
    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int accessFlags = programMethod.getAccessFlags();
        logger.trace("MethodInliner: checking [{}.{}{}] in [{}.{}{}]", (Object)programClass.getName(), (Object)programMethod.getName(programClass), (Object)programMethod.getDescriptor(programClass), (Object)this.targetClass.getName(), (Object)this.targetMethod.getName(this.targetClass), (Object)this.targetMethod.getDescriptor(this.targetClass));
        if (!(!this.DEBUG("Access?") || (accessFlags & 0x1A) == 0 || !this.DEBUG("Interface?") || (programClass.getAccessFlags() & 0x200) != 0 && !this.canInlineMethodFromInterface(programClass, programMethod) || !this.DEBUG("Synchronized?") || (accessFlags & 0x520) != 0 || !this.DEBUG("Init?") || programMethod.getName(programClass).equals("<init>") || !this.DEBUG("Self?") || programMethod.equals(this.targetMethod) && programClass.equals(this.targetClass) || !this.DEBUG("Recurse?") || this.inliningMethods.contains(programMethod) || !this.DEBUG("Version?") || this.targetClass.u4version < programClass.u4version || !this.DEBUG("Super?") || this.usesOptimizationInfo && (KeepMarker.isKept(programMethod) || (SuperInvocationMarker.invokesSuperMethods(programMethod) || DynamicInvocationMarker.invokesDynamically(programMethod)) && !programClass.equals(this.targetClass) || !this.DEBUG("Branch?") || BackwardBranchMarker.branchesBackward(programMethod) && this.uninitializedObjectCount != 0 || !this.DEBUG("Access private?") || !this.allowAccessModification && (AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) || AccessMethodMarker.accessesPackageCode(programMethod) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName()))) || !this.DEBUG("Access private in subclass?") || AccessMethodMarker.accessesPrivateCode(programMethod) && !programClass.equals(this.targetClass) && this.targetClass.extendsOrImplements(programClass) || !this.DEBUG("Access protected?") || AccessMethodMarker.accessesProtectedCode(programMethod) && !programClass.equals(this.targetClass) || !this.DEBUG("Synchronization?") || SynchronizedBlockMethodMarker.hasSynchronizedBlock(programMethod) && !this.coveredByCatchAllHandler || !this.DEBUG("Final fields?") || FinalFieldAssignmentMarker.assignsFinalField(programMethod) || !this.DEBUG("Catch?") || CatchExceptionMarker.catchesExceptions(programMethod) && !this.emptyInvokingStack || !this.DEBUG("Stack?") || NonEmptyStackReturnMarker.returnsWithNonEmptyStack(programMethod) || !this.DEBUG("Side effects?") || SideEffectClassChecker.mayHaveSideEffects(this.targetClass, programClass, programMethod)))) {
            boolean oldInlining = this.inlining;
            this.inlining = true;
            this.inliningMethods.push(programMethod);
            programMethod.attributesAccept(programClass, this);
            if (this.usesOptimizationInfo) {
                if (!KeepMarker.isKept(this.targetMethod)) {
                    ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(this.targetMethod).merge(MethodOptimizationInfo.getMethodOptimizationInfo(programMethod));
                }
                programMethod.attributesAccept(programClass, this.methodInvocationMarker);
            }
            this.inlining = oldInlining;
            this.inliningMethods.pop();
        } else if (programMethod.getName(programClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (libraryMethod.getName(libraryClass).equals("<init>")) {
            --this.uninitializedObjectCount;
        }
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        block3: {
            try {
                String newSource = lineNumberInfo.getSource() != null ? lineNumberInfo.getSource() : this.source;
                LineNumberInfo newLineNumberInfo = newSource != null ? new ExtendedLineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber, newSource) : new LineNumberInfo(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber);
                this.minimumLineNumberIndex = this.codeAttributeComposer.insertLineNumber(this.minimumLineNumberIndex, newLineNumberInfo) + 1;
            }
            catch (IllegalArgumentException e) {
                if (!logger.getLevel().isLessSpecificThan(Level.DEBUG)) break block3;
                logger.error("Invalid line number while inlining method:");
                logger.error("  Target class   = [{}]", (Object)this.targetClass.getName());
                logger.error("  Target method  = [{}{}]", (Object)this.targetMethod.getName(this.targetClass), (Object)this.targetMethod.getDescriptor(this.targetClass));
                if (this.inlining) {
                    logger.error("  Inlined class  = [{}]", (Object)clazz.getName());
                    logger.error("  Inlined method = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                }
                logger.error("  Exception      = [{}] ({})", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        ++this.exceptionInfoCount;
        this.coveredByCatchAllHandler |= exceptionInfo.u2catchType == 0;
    }

    private static int defaultMaxResultingCodeLength(boolean microEdition) {
        return microEdition ? MAXIMUM_RESULTING_CODE_LENGTH_JME : MAXIMUM_RESULTING_CODE_LENGTH_JSE;
    }

    private boolean DEBUG(String string) {
        logger.trace("  {}", (Object)string);
        return true;
    }

    private boolean returnsIntLike(String methodDescriptor) {
        char returnChar = methodDescriptor.charAt(methodDescriptor.length() - 1);
        return returnChar == 'Z' || returnChar == 'B' || returnChar == 'C' || returnChar == 'S';
    }

    private boolean canInlineMethodFromInterface(ProgramClass sourceClass, ProgramMethod sourceMethod) {
        return sourceClass.equals(this.targetClass) && (sourceMethod.getAccessFlags() & 2) != 0;
    }

    protected abstract boolean shouldInline(Clazz var1, Method var2, CodeAttribute var3);
}

