/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.visitor;

import java.io.PrintWriter;
import java.util.Map;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;
import proguard.resources.kotlinmodule.visitor.KotlinModuleVisitor;

public class KotlinModulePrinter
implements ResourceFileVisitor,
KotlinModuleVisitor,
KotlinModulePackageVisitor {
    private static final String INDENTATION = "  ";
    private final PrintWriter pw;
    private int indentation;
    private String missingRefIndicator;

    public KotlinModulePrinter() {
        this(new PrintWriter(System.out, true), "! ");
    }

    public KotlinModulePrinter(PrintWriter pw, String missingRefIndicator) {
        this.pw = pw;
        this.missingRefIndicator = missingRefIndicator;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        this.println("_____________________________________________________________________");
        this.println("[MODL] " + kotlinModule.name + " from file(" + kotlinModule.fileName + ")");
        this.indent();
        kotlinModule.modulePackagesAccept(this);
        this.outdent();
    }

    @Override
    public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage kotlinModulePart) {
        this.println("[MPKG] \"" + kotlinModulePart.fqName + "\"");
        this.indent();
        for (int i = 0; i < kotlinModulePart.fileFacadeNames.size(); ++i) {
            String fileFacadeName = kotlinModulePart.fileFacadeNames.get(i);
            this.println("[FFAC] " + this.hasRefIndicator(kotlinModulePart.referencedFileFacades.get(i)) + fileFacadeName);
        }
        kotlinModulePart.multiFileClassParts.values().stream().distinct().forEachOrdered(multiFileFacadeName -> {
            this.println("[MFAC] " + multiFileFacadeName);
            this.indent();
            kotlinModulePart.multiFileClassParts.entrySet().stream().filter(e -> ((String)e.getValue()).equals(multiFileFacadeName)).map(Map.Entry::getKey).forEachOrdered(multiFilePartName -> this.println("[MPRT] " + this.hasRefIndicator(kotlinModulePart.referencedMultiFileParts.get(multiFilePartName)) + multiFilePartName));
            this.outdent();
        });
        this.outdent();
    }

    private void indent() {
        ++this.indentation;
    }

    private void outdent() {
        --this.indentation;
    }

    private void println(String string) {
        this.print(string);
        this.println();
    }

    private void print(String string) {
        for (int index = 0; index < this.indentation; ++index) {
            this.pw.print(INDENTATION);
        }
        this.pw.print(string);
    }

    private void println() {
        this.pw.println();
    }

    private String hasRefIndicator(Object arg) {
        return arg == null ? this.missingRefIndicator : "";
    }
}

