/*
 * Decompiled with CFR 0.152.
 */
package proguard.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.util.ListUtil;

public class ClassPathElement
extends Path {
    private String filter;
    private String apkFilter;
    private String jarFilter;
    private String aarFilter;
    private String warFilter;
    private String earFilter;
    private String zipFilter;

    public ClassPathElement(Project project) {
        super(project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendClassPathEntriesTo(ClassPath classPath, boolean output) {
        String[] fileNames;
        File baseDir = this.getProject().getBaseDir();
        if (this.isReference()) {
            DataType referencedObject = this.getCheckedRef(DataType.class, DataType.class.getName());
            if (referencedObject instanceof Path) {
                Path path = (Path)referencedObject;
                fileNames = path.list();
            } else {
                if (!(referencedObject instanceof AbstractFileSet)) throw new BuildException("The refid attribute doesn't point to a <path> element or a <fileset> element");
                AbstractFileSet fileSet = (AbstractFileSet)referencedObject;
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                baseDir = scanner.getBasedir();
                fileNames = scanner.getIncludedFiles();
            }
        } else {
            fileNames = this.list();
        }
        if (output && fileNames.length != 1) {
            throw new BuildException("The <outjar> element must specify exactly one file or directory [" + fileNames.length + "]");
        }
        for (int index = 0; index < fileNames.length; ++index) {
            String fileName = fileNames[index];
            File file = new File(fileName);
            ClassPathEntry entry = new ClassPathEntry(file.isAbsolute() ? file : new File(baseDir, fileName), output);
            entry.setFilter(ListUtil.commaSeparatedList(this.filter));
            entry.setApkFilter(ListUtil.commaSeparatedList(this.apkFilter));
            entry.setJarFilter(ListUtil.commaSeparatedList(this.jarFilter));
            entry.setAarFilter(ListUtil.commaSeparatedList(this.aarFilter));
            entry.setWarFilter(ListUtil.commaSeparatedList(this.warFilter));
            entry.setEarFilter(ListUtil.commaSeparatedList(this.earFilter));
            entry.setZipFilter(ListUtil.commaSeparatedList(this.zipFilter));
            classPath.add(entry);
        }
    }

    public void setFile(File file) {
        this.setLocation(file);
    }

    public void setDir(File file) {
        this.setLocation(file);
    }

    public void setName(File file) {
        this.setLocation(file);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setApkfilter(String apkFilter) {
        this.apkFilter = apkFilter;
    }

    public void setJarfilter(String jarFilter) {
        this.jarFilter = jarFilter;
    }

    public void setAarfilter(String aarFilter) {
        this.aarFilter = aarFilter;
    }

    public void setWarfilter(String warFilter) {
        this.warFilter = warFilter;
    }

    public void setEarfilter(String earFilter) {
        this.earFilter = earFilter;
    }

    public void setZipfilter(String zipFilter) {
        this.zipFilter = zipFilter;
    }
}

