/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.operators;

import java.util.ListIterator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.ListAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.StackAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractStateFactory;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;

public class JvmDefaultReduceOperator<StateT extends LatticeAbstractState<StateT>>
implements ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature>,
JvmAbstractStateFactory<StateT> {
    private final boolean reduceHeap;

    public JvmDefaultReduceOperator() {
        this(true);
    }

    public JvmDefaultReduceOperator(boolean reduceHeap) {
        this.reduceHeap = reduceHeap;
    }

    public JvmAbstractState<StateT> reduce(AbstractState expandedInitialState, JvmCfaNode blockEntryNode, Call call) {
        if (!(expandedInitialState instanceof JvmAbstractState)) {
            throw new IllegalArgumentException("The operator works on JVM states, states of type " + expandedInitialState.getClass().getName() + " are not supported");
        }
        JvmAbstractState initialJvmState = (JvmAbstractState)expandedInitialState.copy();
        initialJvmState.setProgramLocation(blockEntryNode);
        ListAbstractState localVariables = new ListAbstractState();
        StackAbstractState callStack = new StackAbstractState();
        JvmFrameAbstractState frame = new JvmFrameAbstractState(localVariables, callStack);
        int i = 0;
        if (call.getTarget().descriptor.argumentTypes != null) {
            int argSize = call.getJvmArgumentSize();
            ListIterator<String> iterator2 = call.getTarget().descriptor.argumentTypes.listIterator(call.getTarget().descriptor.argumentTypes.size());
            while (iterator2.hasPrevious()) {
                String type = iterator2.previous();
                int size = ClassUtil.internalTypeSize(type);
                Object state = initialJvmState.peek(i++);
                localVariables.set(argSize - size, state, null);
                if (size == 2) {
                    state = initialJvmState.peek(i++);
                    localVariables.set(argSize - size + 1, state, null);
                }
                argSize -= size;
            }
        }
        MapAbstractState staticFields = initialJvmState.getStaticFields();
        this.reduceStaticFields(staticFields);
        if (!call.isStatic()) {
            Object state = initialJvmState.peek(i++);
            localVariables.set(0, state, null);
        }
        JvmHeapAbstractState heap = initialJvmState.getHeap();
        if (this.reduceHeap) {
            this.reduceHeap(heap, frame, initialJvmState.getStaticFields());
        }
        return this.createJvmAbstractState(initialJvmState.getProgramLocation(), frame, heap, initialJvmState.getStaticFields());
    }

    protected void reduceStaticFields(MapAbstractState<String, StateT> staticFields) {
    }

    protected void reduceHeap(JvmHeapAbstractState<StateT> heap, JvmFrameAbstractState<StateT> reducedFrame, MapAbstractState<String, StateT> reducedStaticFields) {
    }
}

