/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.DelegateAbstractDomain;
import proguard.analysis.cpa.defaults.MergeJoinOperator;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.defaults.StopJoinOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.CompositeHeapJvmAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.CompositeHeapTransferRelation;
import proguard.analysis.cpa.jvm.domain.reference.JvmCompositeHeapExpandOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmCompositeHeapReduceOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceExpandOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceReduceOperator;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceTransferRelation;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.domain.taint.JvmBasicTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintCpa;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintExpandOperator;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintReduceOperator;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransferRelation;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.state.heap.JvmForgetfulHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapPrincipalAbstractState;
import proguard.analysis.cpa.jvm.util.JvmBamCpaRun;
import proguard.analysis.cpa.state.HashMapAbstractStateFactory;
import proguard.analysis.cpa.state.MapAbstractStateFactory;
import proguard.classfile.MethodSignature;

public class JvmTaintBamCpaRun<OuterAbstractStateT extends AbstractState>
extends JvmBamCpaRun<SimpleCpa, SetAbstractState<JvmTaintSource>, OuterAbstractStateT> {
    private final Set<? extends JvmTaintSource> taintSources;
    private final MethodSignature mainMethodSignature;
    private final MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory;
    private final MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory;
    private final MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory;
    private final MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory;
    private final MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory;

    protected JvmTaintBamCpaRun(JvmCfa cfa, Set<? extends JvmTaintSource> taintSources, MethodSignature mainMethodSignature, int maxCallStackDepth, HeapModel heapModel, AbortOperator abortOperator, boolean reduceHeap, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory, MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory, MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory) {
        super(cfa, maxCallStackDepth, heapModel, abortOperator, reduceHeap);
        this.taintSources = taintSources;
        this.mainMethodSignature = mainMethodSignature;
        this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
        this.principalHeapMapAbstractStateFactory = principalHeapMapAbstractStateFactory;
        this.principalHeapNodeMapAbstractStateFactory = principalHeapNodeMapAbstractStateFactory;
        this.followerHeapMapAbstractStateFactory = followerHeapMapAbstractStateFactory;
        this.followerHeapNodeMapAbstractStateFactory = followerHeapNodeMapAbstractStateFactory;
    }

    @Override
    public SimpleCpa createIntraproceduralCPA() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return new JvmTaintCpa(this.taintSources);
            }
            case TREE: 
            case TAINT_TREE: {
                DelegateAbstractDomain abstractDomain = new DelegateAbstractDomain();
                return new SimpleCpa(abstractDomain, new CompositeHeapTransferRelation(Arrays.asList(new JvmReferenceTransferRelation(), new JvmTaintTransferRelation(JvmTaintCpa.createSourcesMap(this.taintSources)))), new MergeJoinOperator(abstractDomain), new StopJoinOperator(abstractDomain));
            }
        }
        throw new IllegalArgumentException("Heap model " + this.heapModel.name() + " is not supported by " + this.getClass().getName());
    }

    @Override
    public ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createReduceOperator() {
        switch (this.heapModel) {
            case TREE: 
            case TAINT_TREE: {
                return new JvmCompositeHeapReduceOperator(Arrays.asList(new JvmReferenceReduceOperator(this.reduceHeap), new JvmTaintReduceOperator(this.reduceHeap)));
            }
        }
        return super.createReduceOperator();
    }

    @Override
    public ExpandOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> createExpandOperator() {
        JvmTaintExpandOperator jvmExpandOperator = new JvmTaintExpandOperator(this.cfa, JvmTaintCpa.createSourcesMap(this.taintSources), this.reduceHeap);
        switch (this.heapModel) {
            case FORGETFUL: {
                return jvmExpandOperator;
            }
            case TREE: 
            case TAINT_TREE: {
                return new JvmCompositeHeapExpandOperator(Arrays.asList(new JvmReferenceExpandOperator(this.cfa, this.reduceHeap), jvmExpandOperator));
            }
        }
        throw new IllegalArgumentException("Heap model " + this.heapModel.name() + " is not supported by " + this.getClass().getName());
    }

    @Override
    public MethodSignature getMainSignature() {
        return this.mainMethodSignature;
    }

    @Override
    public Collection<OuterAbstractStateT> getInitialStates() {
        switch (this.heapModel) {
            case FORGETFUL: {
                return Collections.singleton(new JvmAbstractState<SetAbstractState<JvmTaintSource>>((JvmCfaNode)this.cfa.getFunctionEntryNode(this.mainMethodSignature), new JvmFrameAbstractState(), new JvmForgetfulHeapAbstractState<SetAbstractState>(SetAbstractState.bottom), this.staticFieldMapAbstractStateFactory.createMapAbstractState()));
            }
            case TREE: 
            case TAINT_TREE: {
                JvmReferenceAbstractState principalState = new JvmReferenceAbstractState((JvmCfaNode)this.cfa.getFunctionEntryNode(this.mainMethodSignature), new JvmFrameAbstractState<SetAbstractState<Reference>>(), new JvmTreeHeapPrincipalAbstractState(this.principalHeapMapAbstractStateFactory, this.principalHeapNodeMapAbstractStateFactory), this.principalHeapNodeMapAbstractStateFactory.createMapAbstractState());
                return Collections.singleton(new CompositeHeapJvmAbstractState(Arrays.asList(principalState, new JvmTaintAbstractState((JvmCfaNode)this.cfa.getFunctionEntryNode(this.mainMethodSignature), new JvmFrameAbstractState<SetAbstractState<JvmTaintSource>>(), this.heapModel == HeapModel.TAINT_TREE ? new JvmTaintTreeHeapFollowerAbstractState(principalState, SetAbstractState.bottom, this.followerHeapMapAbstractStateFactory.createMapAbstractState(), this.followerHeapMapAbstractStateFactory, this.followerHeapNodeMapAbstractStateFactory) : new JvmBasicTaintTreeHeapFollowerAbstractState(principalState, SetAbstractState.bottom, this.followerHeapMapAbstractStateFactory.createMapAbstractState(), this.followerHeapMapAbstractStateFactory, this.followerHeapNodeMapAbstractStateFactory), this.staticFieldMapAbstractStateFactory.createMapAbstractState()))));
            }
        }
        throw new IllegalStateException("Invalid heap model: " + this.heapModel.name());
    }

    public static class Builder
    extends JvmBamCpaRun.Builder {
        protected MethodSignature mainSignature;
        protected Set<? extends JvmTaintSource> taintSources = Collections.emptySet();
        protected MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();
        protected MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.getInstance();

        @Override
        public JvmTaintBamCpaRun<?> build() {
            if (this.cfa == null || this.mainSignature == null) {
                throw new IllegalStateException("CFA and the main signature must be set");
            }
            return new JvmTaintBamCpaRun(this.cfa, this.taintSources, this.mainSignature, this.maxCallStackDepth, this.heapModel, this.abortOperator, this.reduceHeap, this.staticFieldMapAbstractStateFactory, this.principalHeapMapAbstractStateFactory, this.principalHeapNodeMapAbstractStateFactory, this.followerHeapMapAbstractStateFactory, this.followerHeapNodeMapAbstractStateFactory);
        }

        @Override
        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            return (Builder)super.setMaxCallStackDepth(maxCallStackDepth);
        }

        @Override
        public Builder setAbortOperator(AbortOperator abortOperator) {
            return (Builder)super.setAbortOperator(abortOperator);
        }

        @Override
        public Builder setReduceHeap(boolean reduceHeap) {
            return (Builder)super.setReduceHeap(reduceHeap);
        }

        @Override
        public Builder setCfa(JvmCfa cfa) {
            return (Builder)super.setCfa(cfa);
        }

        @Override
        public Builder setHeapModel(HeapModel heapModel) {
            return (Builder)super.setHeapModel(heapModel);
        }

        public Builder setTaintSources(Set<? extends JvmTaintSource> taintSources) {
            this.taintSources = taintSources;
            return this;
        }

        public Builder setMainSignature(MethodSignature mainSignature) {
            this.mainSignature = mainSignature;
            return this;
        }

        public Builder setStaticFieldMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> staticFieldMapAbstractStateFactory) {
            this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
            return this;
        }

        public Builder setPrincipalHeapMapAbstractStateFactory(MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<Reference>>> principalHeapMapAbstractStateFactory) {
            this.principalHeapMapAbstractStateFactory = principalHeapMapAbstractStateFactory;
            return this;
        }

        public Builder setPrincipalHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<Reference>> principalHeapNodeMapAbstractStateFactory) {
            this.principalHeapNodeMapAbstractStateFactory = principalHeapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setFollowerHeapMapAbstractStateFactory(MapAbstractStateFactory<Reference, HeapNode<SetAbstractState<JvmTaintSource>>> followerHeapMapAbstractStateFactory) {
            this.followerHeapMapAbstractStateFactory = followerHeapMapAbstractStateFactory;
            return this;
        }

        public Builder setFollowerHeapNodeMapAbstractStateFactory(MapAbstractStateFactory<String, SetAbstractState<JvmTaintSource>> followerHeapNodeMapAbstractStateFactory) {
            this.followerHeapNodeMapAbstractStateFactory = followerHeapNodeMapAbstractStateFactory;
            return this;
        }
    }
}

