/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.util.ArrayUtil;

class TypeArgumentFinder
implements InstructionVisitor,
ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final PartialEvaluator partialEvaluator;
    String[] typeArgumentClasses;

    TypeArgumentFinder(ClassPool programClassPool, ClassPool libraryClassPool, PartialEvaluator partialEvaluator) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.partialEvaluator = partialEvaluator;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        if (variableInstruction.canonicalOpcode() == 25) {
            LastStoreFinder lastStoreFinder = new LastStoreFinder(variableInstruction.variableIndex);
            codeAttribute.instructionsAccept(clazz, method, 0, offset, lastStoreFinder);
            if (lastStoreFinder.lastStore != null) {
                TracedStack stackBeforeStore = this.partialEvaluator.getStackBefore(lastStoreFinder.lastStoreOffset);
                InstructionOffsetValue instructionOffsetValue = stackBeforeStore.getTopProducerValue(0).instructionOffsetValue();
                TypeTokenSignatureFinder typeTokenFinder = new TypeTokenSignatureFinder();
                for (int offsetIndex = 0; offsetIndex < instructionOffsetValue.instructionOffsetCount(); ++offsetIndex) {
                    int instructionOffset = instructionOffsetValue.instructionOffset(offsetIndex);
                    codeAttribute.instructionAccept(clazz, method, instructionOffset, typeTokenFinder);
                }
                if (typeTokenFinder.typeTokenSignature != null) {
                    Clazz[] referencedClasses;
                    this.typeArgumentClasses = new String[0];
                    for (Clazz referencedClass : referencedClasses = ((TypeTokenSignatureFinder)typeTokenFinder).typeTokenSignature.referencedClasses) {
                        if (referencedClass == null || referencedClass.getName().equals("com/google/gson/reflect/TypeToken")) continue;
                        this.typeArgumentClasses = ArrayUtil.add(this.typeArgumentClasses, this.typeArgumentClasses.length, referencedClass.getName());
                    }
                }
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: 
            case 18: 
            case 19: 
            case 20: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.typeArgumentClasses = new String[]{refConstant.getClassName(clazz)};
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.typeArgumentClasses = new String[]{classConstant.getName(clazz)};
    }

    private class TypeTokenSignatureFinder
    implements InstructionVisitor,
    ConstantVisitor,
    AttributeVisitor {
        private SignatureAttribute typeTokenSignature;

        private TypeTokenSignatureFinder() {
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
            if (methodrefConstant.referencedClass != null && "com/google/gson/reflect/TypeToken".equals(methodrefConstant.referencedClass.getName()) && "getType".equals(methodrefConstant.getName(clazz))) {
                TypeArgumentFinder.this.programClassPool.classAccept(methodrefConstant.getClassName(clazz), new AllAttributeVisitor(this));
                TypeArgumentFinder.this.libraryClassPool.classAccept(methodrefConstant.getClassName(clazz), new AllAttributeVisitor(this));
            }
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            this.typeTokenSignature = signatureAttribute;
        }
    }

    private static class LastStoreFinder
    implements InstructionVisitor {
        private final int variableIndex;
        private int lastStoreOffset;
        private VariableInstruction lastStore;

        public LastStoreFinder(int variableIndex) {
            this.variableIndex = variableIndex;
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.variableIndex == this.variableIndex && variableInstruction.canonicalOpcode() == 58) {
                this.lastStoreOffset = offset;
                this.lastStore = variableInstruction;
            }
        }
    }
}

