/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationSimplifier
implements AttributeVisitor,
InstructionVisitor {
    private static final int POS_ZERO_FLOAT_BITS = Float.floatToIntBits(0.0f);
    private static final long POS_ZERO_DOUBLE_BITS = Double.doubleToLongBits(0.0);
    private static final Logger logger = LogManager.getLogger(EvaluationSimplifier.class);
    private final boolean predictNullPointerExceptions;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final SideEffectInstructionChecker sideEffectInstructionChecker;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);

    public EvaluationSimplifier(boolean predictNullPointerExceptions) {
        this(new PartialEvaluator(), null, predictNullPointerExceptions);
    }

    public EvaluationSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor extraInstructionVisitor, boolean predictNullPointerExceptions) {
        this.predictNullPointerExceptions = predictNullPointerExceptions;
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = extraInstructionVisitor;
        this.sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true, predictNullPointerExceptions);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        block2: {
            try {
                this.visitCodeAttribute0(clazz, method, codeAttribute);
            }
            catch (RuntimeException ex) {
                logger.error("Unexpected error while simplifying instructions after partial evaluation:");
                logger.error("  Class       = [{}]", (Object)clazz.getName());
                logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                logger.error("Not optimizing this method");
                logger.debug("{}", () -> {
                    StringWriter sw = new StringWriter();
                    method.accept(clazz, new ClassPrinter(new PrintWriter(sw)));
                    return sw.toString();
                });
                if (!logger.getLevel().isLessSpecificThan(Level.DEBUG)) break block2;
                throw ex;
            }
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        logger.debug("EvaluationSimplifier [{}.{}{}]", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 108: 
            case 112: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceIntegerPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(offset, 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 109: 
            case 113: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceLongPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(offset, 2)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 110: 
            case 114: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceFloatPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(offset, 3)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case 111: 
            case 115: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceDoublePushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isDivisionByZero(offset, 4)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/ArithmeticException");
                break;
            }
            case -66: 
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceIntegerPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -128: 
            case -126: 
            case -120: 
            case -117: 
            case -114: 
            case -111: 
            case -110: 
            case -109: 
            case 96: 
            case 100: 
            case 104: 
            case 116: 
            case 120: 
            case 122: 
            case 124: 
            case 126: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) break;
                this.replaceIntegerPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case 47: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceLongPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -127: 
            case -125: 
            case -123: 
            case -116: 
            case -113: 
            case 97: 
            case 101: 
            case 105: 
            case 117: 
            case 121: 
            case 123: 
            case 125: 
            case 127: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) break;
                this.replaceLongPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case 48: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceFloatPushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -122: 
            case -119: 
            case -112: 
            case 98: 
            case 102: 
            case 106: 
            case 118: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) break;
                this.replaceFloatPushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case 49: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceDoublePushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case -121: 
            case -118: 
            case -115: 
            case 99: 
            case 103: 
            case 107: 
            case 119: {
                if (this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) break;
                this.replaceDoublePushInstruction(clazz, offset, simpleInstruction);
                break;
            }
            case 50: {
                if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, simpleInstruction)) {
                    this.replaceReferencePushInstruction(clazz, offset, simpleInstruction);
                    break;
                }
                if (!this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                if (!this.predictNullPointerExceptions || !this.isNullReference(offset, simpleInstruction.stackPopCount(clazz) - 1)) break;
                this.replaceByException(clazz, offset, simpleInstruction, "java/lang/NullPointerException");
            }
        }
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.replaceIntegerPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.replaceLongPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.replaceFloatPushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.replaceDoublePushInstruction(clazz, offset, variableInstruction, variableIndex);
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.replaceReferencePushInstruction(clazz, offset, variableInstruction);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.deleteReferencePopInstruction(clazz, offset, variableInstruction);
                break;
            }
            case -87: {
                this.replaceBranchInstruction(clazz, offset, variableInstruction);
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -71: {
                if (this.predictNullPointerExceptions && this.isNullReference(offset, constantInstruction.stackPopCount(clazz) - 1)) {
                    this.replaceByException(clazz, offset, constantInstruction, "java/lang/NullPointerException");
                    break;
                }
            }
            case -78: 
            case -76: 
            case -72: {
                if (constantInstruction.stackPushCount(clazz) <= 0 || this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, constantInstruction)) break;
                this.replaceAnyPushInstruction(clazz, offset, constantInstruction);
                break;
            }
            case -64: {
                this.replaceReferencePushInstruction(clazz, offset, constantInstruction);
            }
        }
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -89: 
            case -56: {
                break;
            }
            case -88: 
            case -55: {
                this.replaceJsrInstruction(clazz, offset, branchInstruction);
                break;
            }
            default: {
                this.replaceBranchInstruction(clazz, offset, branchInstruction);
            }
        }
    }

    @Override
    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        this.replaceBranchInstruction(clazz, offset, tableSwitchInstruction);
        if (!this.codeAttributeEditor.isModified(offset)) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, offset, tableSwitchInstruction);
            if (!this.codeAttributeEditor.isModified(offset)) {
                this.cleanUpSwitchInstruction(clazz, offset, tableSwitchInstruction);
                this.trimSwitchInstruction(clazz, offset, tableSwitchInstruction);
            }
        }
    }

    @Override
    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.replaceBranchInstruction(clazz, offset, lookUpSwitchInstruction);
        if (!this.codeAttributeEditor.isModified(offset)) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, offset, lookUpSwitchInstruction);
            if (!this.codeAttributeEditor.isModified(offset)) {
                this.cleanUpSwitchInstruction(clazz, offset, lookUpSwitchInstruction);
                this.trimSwitchInstruction(clazz, offset, lookUpSwitchInstruction);
            }
        }
    }

    private void replaceAnyPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            switch (pushedValue.computationalType()) {
                case 1: {
                    this.replaceIntegerPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 2: {
                    this.replaceLongPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 3: {
                    this.replaceFloatPushInstruction(clazz, offset, instruction);
                    break;
                }
                case 4: {
                    this.replaceDoublePushInstruction(clazz, offset, instruction);
                    break;
                }
                case 5: {
                    this.replaceReferencePushInstruction(clazz, offset, instruction);
                }
            }
        }
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceIntegerPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceIntegerPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            int value = pushedValue.integerValue().value();
            if ((short)value == value) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)17, value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction replacementInstruction = new ConstantInstruction(18, constantPoolEditor.addIntegerConstant(value));
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)21, variableIndex);
                break;
            }
        }
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceLongPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceLongPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            long value = pushedValue.longValue().value();
            if (value == 0L || value == 1L) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)9, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction replacementInstruction = new ConstantInstruction(20, constantPoolEditor.addLongConstant(value));
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex)) || variables.load(variableIndex + 1) == null || variables.load(variableIndex + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)22, variableIndex);
            }
        }
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceFloatPushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceFloatPushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            float value = pushedValue.floatValue().value();
            if (value == 0.0f && Float.floatToIntBits(value) == POS_ZERO_FLOAT_BITS || value == 1.0f || value == 2.0f) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)11, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction replacementInstruction = new ConstantInstruction(18, constantPoolEditor.addFloatConstant(value));
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex))) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)23, variableIndex);
            }
        }
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.replaceDoublePushInstruction(clazz, offset, instruction, this.partialEvaluator.getVariablesBefore(offset).size());
    }

    private void replaceDoublePushInstruction(Clazz clazz, int offset, Instruction instruction, int maxVariableIndex) {
        Value pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
        if (pushedValue.isParticular()) {
            double value = pushedValue.doubleValue().value();
            if (value == 0.0 && Double.doubleToLongBits(value) == POS_ZERO_DOUBLE_BITS || value == 1.0) {
                this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)14, (int)value);
            } else {
                ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
                ConstantInstruction replacementInstruction = new ConstantInstruction(20, constantPoolEditor.addDoubleConstant(value));
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        } else if (pushedValue.isSpecific()) {
            TracedVariables variables = this.partialEvaluator.getVariablesBefore(offset);
            for (int variableIndex = 0; variableIndex < maxVariableIndex; ++variableIndex) {
                if (!pushedValue.equals(variables.load(variableIndex)) || variables.load(variableIndex + 1) == null || variables.load(variableIndex + 1).computationalType() != 7) continue;
                this.replaceVariablePushInstruction(clazz, offset, instruction, (byte)24, variableIndex);
            }
        }
    }

    private void replaceReferencePushInstruction(Clazz clazz, int offset, Instruction instruction) {
        ReferenceValue pushedValue = this.partialEvaluator.getStackAfter(offset).getTop(0).referenceValue();
        if (pushedValue.isNull() == 1) {
            this.replaceConstantPushInstruction(clazz, offset, instruction, (byte)1, 0);
        }
    }

    private void replaceConstantPushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int value) {
        SimpleInstruction replacementInstruction = new SimpleInstruction(replacementOpcode, value);
        this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
    }

    private void replaceVariablePushInstruction(Clazz clazz, int offset, Instruction instruction, byte replacementOpcode, int variableIndex) {
        VariableInstruction replacementInstruction = new VariableInstruction(replacementOpcode, variableIndex);
        this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
    }

    private void replaceJsrInstruction(Clazz clazz, int offset, BranchInstruction branchInstruction) {
        int subroutineStart = offset + branchInstruction.branchOffset;
        if (!this.partialEvaluator.isSubroutineReturning(subroutineStart) || this.partialEvaluator.branchOrigins(subroutineStart).instructionOffsetCount() == 1) {
            this.replaceBranchInstruction(clazz, offset, branchInstruction);
        } else if (!this.partialEvaluator.isTraced(offset + branchInstruction.length(offset))) {
            this.replaceByInfiniteLoop(clazz, offset + branchInstruction.length(offset), branchInstruction);
        }
    }

    private void deleteReferencePopInstruction(Clazz clazz, int offset, Instruction instruction) {
        if (this.partialEvaluator.isSubroutineStart(offset) && (!this.partialEvaluator.isSubroutineReturning(offset) || this.partialEvaluator.branchOrigins(offset).instructionOffsetCount() == 1)) {
            logger.debug("  Deleting store of subroutine return address {}", (Object)instruction.toString(offset));
            this.codeAttributeEditor.deleteInstruction(offset);
        }
    }

    private void replaceBranchInstruction(Clazz clazz, int offset, Instruction instruction) {
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        if (branchTargets != null && branchTargets.instructionOffsetCount() == 1) {
            int branchOffset = branchTargets.instructionOffset(0) - offset;
            if (branchOffset == instruction.length(offset)) {
                logger.debug("  Ignoring zero branch instruction at [{}]", (Object)offset);
            } else {
                BranchInstruction replacementInstruction = new BranchInstruction(-89, branchOffset);
                this.replaceInstruction(clazz, offset, instruction, replacementInstruction);
            }
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        ReferenceValue referenceValue;
        int producerOffset;
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getStackBefore(offset).getTopProducerValue(0).instructionOffsetValue();
        if (producerOffsets.instructionOffsetCount() == 1 && codeAttribute.code[producerOffset = producerOffsets.instructionOffset(0)] == 46 && !this.codeAttributeEditor.isModified(producerOffset) && (referenceValue = this.partialEvaluator.getStackBefore(producerOffset).getTop(1).referenceValue()).isParticular()) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, producerOffset, offset, tableSwitchInstruction, referenceValue);
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int loadOffset, int switchOffset, TableSwitchInstruction tableSwitchInstruction, ReferenceValue mappingValue) {
        ParticularValueFactory valueFactory = new ParticularValueFactory();
        int[] jumpOffsets = tableSwitchInstruction.jumpOffsets;
        int[] newJumpOffsets = new int[mappingValue.arrayLength(valueFactory).value()];
        for (int index = 0; index < newJumpOffsets.length; ++index) {
            int switchCase = mappingValue.integerArrayLoad(valueFactory.createIntegerValue(index), valueFactory).value();
            newJumpOffsets[index] = switchCase >= tableSwitchInstruction.lowCase && switchCase <= tableSwitchInstruction.highCase ? jumpOffsets[switchCase - tableSwitchInstruction.lowCase] : tableSwitchInstruction.defaultOffset;
        }
        tableSwitchInstruction.lowCase = 0;
        tableSwitchInstruction.highCase = newJumpOffsets.length - 1;
        tableSwitchInstruction.jumpOffsets = newJumpOffsets;
        this.replaceSimpleEnumSwitchInstruction(clazz, loadOffset, switchOffset, (SwitchInstruction)tableSwitchInstruction);
        this.cleanUpSwitchInstruction(clazz, switchOffset, tableSwitchInstruction);
        this.trimSwitchInstruction(clazz, switchOffset, tableSwitchInstruction);
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookupSwitchInstruction) {
        ReferenceValue referenceValue;
        int producerOffset;
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getStackBefore(offset).getTopProducerValue(0).instructionOffsetValue();
        if (producerOffsets.instructionOffsetCount() == 1 && codeAttribute.code[producerOffset = producerOffsets.instructionOffset(0)] == 46 && !this.codeAttributeEditor.isModified(producerOffset) && (referenceValue = this.partialEvaluator.getStackBefore(producerOffset).getTop(1).referenceValue()).isParticular()) {
            this.replaceSimpleEnumSwitchInstruction(clazz, codeAttribute, producerOffset, offset, lookupSwitchInstruction, referenceValue);
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, CodeAttribute codeAttribute, int loadOffset, int switchOffset, LookUpSwitchInstruction lookupSwitchInstruction, ReferenceValue mappingValue) {
        ParticularValueFactory valueFactory = new ParticularValueFactory();
        int[] cases = lookupSwitchInstruction.cases;
        int[] jumpOffsets = lookupSwitchInstruction.jumpOffsets;
        int[] newJumpOffsets = new int[mappingValue.arrayLength(valueFactory).value()];
        for (int index = 0; index < newJumpOffsets.length; ++index) {
            int switchCase = mappingValue.integerArrayLoad(valueFactory.createIntegerValue(index), valueFactory).value();
            int caseIndex = Arrays.binarySearch(cases, switchCase);
            newJumpOffsets[index] = caseIndex >= 0 ? jumpOffsets[caseIndex] : lookupSwitchInstruction.defaultOffset;
        }
        TableSwitchInstruction replacementSwitchInstruction = new TableSwitchInstruction(-86, lookupSwitchInstruction.defaultOffset, 0, newJumpOffsets.length - 1, newJumpOffsets);
        this.replaceSimpleEnumSwitchInstruction(clazz, loadOffset, switchOffset, (SwitchInstruction)replacementSwitchInstruction);
        this.cleanUpSwitchInstruction(clazz, switchOffset, replacementSwitchInstruction);
        this.trimSwitchInstruction(clazz, switchOffset, replacementSwitchInstruction);
    }

    private void cleanUpSwitchInstruction(Clazz clazz, int offset, SwitchInstruction switchInstruction) {
        InstructionOffsetValue branchTargets = this.partialEvaluator.branchTargets(offset);
        int defaultOffset = branchTargets.instructionOffset(branchTargets.instructionOffsetCount() - 1) - offset;
        SwitchInstruction replacementInstruction = null;
        int[] jumpOffsets = switchInstruction.jumpOffsets;
        for (int index = 0; index < jumpOffsets.length; ++index) {
            if (branchTargets.contains(offset + jumpOffsets[index])) continue;
            jumpOffsets[index] = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (!branchTargets.contains(offset + switchInstruction.defaultOffset)) {
            switchInstruction.defaultOffset = defaultOffset;
            replacementInstruction = switchInstruction;
        }
        if (replacementInstruction != null) {
            this.replaceInstruction(clazz, offset, switchInstruction, replacementInstruction);
        }
    }

    private void trimSwitchInstruction(Clazz clazz, int offset, TableSwitchInstruction tableSwitchInstruction) {
        int highIndex;
        int lowIndex;
        int defaultOffset = tableSwitchInstruction.defaultOffset;
        int[] jumpOffsets = tableSwitchInstruction.jumpOffsets;
        int length = jumpOffsets.length;
        for (lowIndex = 0; lowIndex < length && jumpOffsets[lowIndex] == defaultOffset; ++lowIndex) {
        }
        for (highIndex = length - 1; highIndex >= 0 && jumpOffsets[highIndex] == defaultOffset; --highIndex) {
        }
        int newLength = highIndex - lowIndex + 1;
        if (newLength < length) {
            if (newLength <= 0) {
                BranchInstruction replacementInstruction = new BranchInstruction(-89, defaultOffset);
                this.replaceInstruction(clazz, offset, tableSwitchInstruction, replacementInstruction);
            } else {
                int[] newJumpOffsets = new int[newLength];
                System.arraycopy(jumpOffsets, lowIndex, newJumpOffsets, 0, newLength);
                tableSwitchInstruction.jumpOffsets = newJumpOffsets;
                tableSwitchInstruction.lowCase += lowIndex;
                tableSwitchInstruction.highCase -= length - newLength - lowIndex;
                this.replaceInstruction(clazz, offset, tableSwitchInstruction, tableSwitchInstruction);
            }
        }
    }

    private void trimSwitchInstruction(Clazz clazz, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        int length;
        int defaultOffset = lookUpSwitchInstruction.defaultOffset;
        int[] jumpOffsets = lookUpSwitchInstruction.jumpOffsets;
        int newLength = length = jumpOffsets.length;
        for (int index = 0; index < length; ++index) {
            if (jumpOffsets[index] != defaultOffset) continue;
            --newLength;
        }
        if (newLength < length) {
            if (newLength <= 0) {
                BranchInstruction replacementInstruction = new BranchInstruction(-89, defaultOffset);
                this.replaceInstruction(clazz, offset, lookUpSwitchInstruction, replacementInstruction);
            } else {
                int[] cases = lookUpSwitchInstruction.cases;
                int[] newJumpOffsets = new int[newLength];
                int[] newCases = new int[newLength];
                int newIndex = 0;
                for (int index = 0; index < length; ++index) {
                    if (jumpOffsets[index] == defaultOffset) continue;
                    newJumpOffsets[newIndex] = jumpOffsets[index];
                    newCases[newIndex++] = cases[index];
                }
                lookUpSwitchInstruction.jumpOffsets = newJumpOffsets;
                lookUpSwitchInstruction.cases = newCases;
                this.replaceInstruction(clazz, offset, lookUpSwitchInstruction, lookUpSwitchInstruction);
            }
        }
    }

    private boolean isDivisionByZero(int offset, int computationType) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(offset);
        Value divisor = tracedStack.getTop(0);
        switch (computationType) {
            case 1: {
                return divisor.computationalType() == 1 && divisor.isParticular() && divisor.integerValue().value() == 0;
            }
            case 2: {
                return divisor.computationalType() == 2 && divisor.isParticular() && divisor.longValue().value() == 0L;
            }
            case 3: {
                return divisor.computationalType() == 3 && divisor.isParticular() && divisor.floatValue().value() == 0.0f;
            }
            case 4: {
                return divisor.computationalType() == 4 && divisor.isParticular() && divisor.doubleValue().value() == 0.0;
            }
        }
        return false;
    }

    private boolean isNullReference(int offset, int popStackEntryIndex) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(offset);
        Value objectRef = tracedStack.getTop(popStackEntryIndex);
        return objectRef.computationalType() == 5 && objectRef.isParticular() && objectRef.referenceValue().isNull() == 1;
    }

    private void replaceByException(Clazz clazz, int offset, Instruction instruction, String exceptionClass) {
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
        Instruction[] replacementInstructions = new Instruction[]{new ConstantInstruction(-69, constantPoolEditor.addClassConstant(exceptionClass, null)), new SimpleInstruction(89), new ConstantInstruction(-73, constantPoolEditor.addMethodrefConstant(exceptionClass, "<init>", "()V", null, null)), new SimpleInstruction(-65)};
        logger.debug("  Replacing instruction by explicit exception {}", (Object)exceptionClass);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstructions);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset, Instruction instruction) {
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        logger.debug("  Replacing unreachable instruction by infinite loop {}", (Object)((Instruction)replacementInstruction).toString(offset));
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int offset, Instruction instruction, Instruction replacementInstruction) {
        int popCount = instruction.stackPopCount(clazz) - replacementInstruction.stackPopCount(clazz);
        this.insertPopInstructions(offset, popCount);
        logger.debug("  Replacing instruction {} -> {}{}", (Object)instruction.toString(offset), (Object)replacementInstruction.toString(), (Object)(popCount == 0 ? "" : " (" + popCount + " pops)"));
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int offset, int popCount) {
        switch (popCount) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstructions);
                break;
            }
        }
    }

    private void replaceSimpleEnumSwitchInstruction(Clazz clazz, int loadOffset, int switchOffset, SwitchInstruction replacementSwitchInstruction) {
        logger.debug("  Replacing switch instruction at [{}] -> [{}] swap + pop, {})", (Object)switchOffset, (Object)loadOffset, (Object)replacementSwitchInstruction.toString(switchOffset));
        this.codeAttributeEditor.replaceInstruction(loadOffset, new Instruction[]{new SimpleInstruction(95), new SimpleInstruction(87)});
        this.codeAttributeEditor.replaceInstruction(switchOffset, replacementSwitchInstruction);
        if (this.extraInstructionVisitor != null) {
            replacementSwitchInstruction.accept(clazz, null, null, switchOffset, this.extraInstructionVisitor);
        }
    }
}

