/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.io.File;

public class JavaUtil {
    public static int currentJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.endsWith("-ea")) {
            version = version.substring(0, version.length() - 3);
        }
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(46);
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static File getCurrentJavaHome() {
        if (JavaUtil.currentJavaVersion() > 8) {
            return new File(System.getProperty("java.home"));
        }
        return new File(System.getProperty("java.home")).getParentFile();
    }

    public static File getRtJar() {
        File currentJavaHome = JavaUtil.getCurrentJavaHome();
        if (new File(currentJavaHome, "jre").exists()) {
            return new File(currentJavaHome, "jre" + File.separator + "lib" + File.separator + "rt.jar");
        }
        return new File(currentJavaHome, "lib" + File.separator + "rt.jar");
    }

    public static File getJmodBase() {
        return new File(JavaUtil.getCurrentJavaHome(), "jmods" + File.separator + "java.base.jmod");
    }
}

