/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.xmlgraphics.util.Service;

public class ContentHandlerFactoryRegistry {
    private static Log log = LogFactory.getLog(ContentHandlerFactoryRegistry.class);
    private Map factories = new HashMap();

    public ContentHandlerFactoryRegistry() {
        this.discover();
    }

    public void addContentHandlerFactory(String classname) {
        try {
            ContentHandlerFactory factory = (ContentHandlerFactory)Class.forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.addContentHandlerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an " + ContentHandlerFactory.class.getName());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addContentHandlerFactory(ContentHandlerFactory factory) {
        String[] ns;
        for (String n : ns = factory.getSupportedNamespaces()) {
            this.factories.put(n, factory);
        }
    }

    public ContentHandlerFactory getFactory(String namespaceURI) {
        ContentHandlerFactory factory = (ContentHandlerFactory)this.factories.get(namespaceURI);
        return factory;
    }

    private void discover() {
        Iterator<Object> providers = Service.providers(ContentHandlerFactory.class);
        if (providers != null) {
            while (providers.hasNext()) {
                ContentHandlerFactory factory = (ContentHandlerFactory)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding ContentHandlerFactory: " + factory.getClass().getName());
                    }
                    this.addContentHandlerFactory(factory);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding ContentHandlerFactory", e);
                }
            }
        }
    }
}

