/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmi.XmiClassDiagramAbstract;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import org.w3c.dom.Element;

public class XmiClassDiagramArgo
extends XmiClassDiagramAbstract
implements XmlDiagramTransformer {
    public XmiClassDiagramArgo(ClassDiagram classDiagram) throws ParserConfigurationException {
        super(classDiagram);
        for (IEntity iEntity : classDiagram.getLeafsvalues()) {
            Element cla;
            if (!classDiagram.isStandaloneForArgo(iEntity) || (cla = this.createEntityNode(iEntity)) == null) continue;
            this.ownedElement.appendChild(cla);
            this.done.add(iEntity);
        }
        for (Link link : classDiagram.getLinks()) {
            this.addLink(link);
        }
    }

    private void addLink(Link link) {
        if (link.isHidden() || link.isInvis()) {
            return;
        }
        String assId = "ass" + this.classDiagram.getUniqueSequence();
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        association.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.classDiagram));
        if (link.getLabel() != null) {
            association.setAttribute("name", this.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.document.createElement("UML:AssociationEnd");
        end1.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end1.setAttribute("association", assId);
        end1.setAttribute("type", link.getEntity1().getUid());
        if (link.getQuantifier1() != null) {
            end1.setAttribute("name", this.forXMI(link.getQuantifier1()));
        }
        Element endparticipant1 = this.document.createElement("UML:AssociationEnd.participant");
        if (this.done.contains(link.getEntity1())) {
            endparticipant1.appendChild(this.createEntityNodeRef(link.getEntity1()));
        } else {
            Element element = this.createEntityNode(link.getEntity1());
            if (element == null) {
                return;
            }
            endparticipant1.appendChild(element);
            this.done.add(link.getEntity1());
        }
        end1.appendChild(endparticipant1);
        connection.appendChild(end1);
        Element end2 = this.document.createElement("UML:AssociationEnd");
        end2.setAttribute("xmi.id", "end" + this.classDiagram.getUniqueSequence());
        end2.setAttribute("association", assId);
        end2.setAttribute("type", link.getEntity2().getUid());
        if (link.getQuantifier2() != null) {
            end2.setAttribute("name", this.forXMI(link.getQuantifier2()));
        }
        Element endparticipant2 = this.document.createElement("UML:AssociationEnd.participant");
        if (this.done.contains(link.getEntity2())) {
            endparticipant2.appendChild(this.createEntityNodeRef(link.getEntity2()));
        } else {
            Element element = this.createEntityNode(link.getEntity2());
            if (element == null) {
                return;
            }
            endparticipant2.appendChild(element);
            this.done.add(link.getEntity2());
        }
        end2.appendChild(endparticipant2);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElement.appendChild(association);
    }

    private Element createEntityNodeRef(IEntity entity) {
        Element cla = this.document.createElement("UML:Class");
        cla.setAttribute("xmi.idref", entity.getUid());
        return cla;
    }
}

