/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverPolygonEps
implements UDriver<UPolygon, EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPolygon shape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        HColor back;
        double[] points = new double[shape.getPoints().size() * 2];
        int i = 0;
        for (XPoint2D pt : shape.getPoints()) {
            points[i++] = pt.getX() + x;
            points[i++] = pt.getY() + y;
        }
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            for (int j = 0; j < points.length; j += 2) {
                if (clip.isInside(points[j], points[j + 1])) continue;
                return;
            }
        }
        if (shape.getDeltaShadow() != 0.0) {
            eps.epsPolygonShadow(shape.getDeltaShadow(), points);
        }
        if ((back = param.getBackcolor()) instanceof HColorGradient) {
            eps.setStrokeColor(param.getColor().toColor(mapper));
            eps.epsPolygon((HColorGradient)back, mapper, points);
        } else {
            eps.setFillColor(back.toColor(mapper));
            eps.setStrokeColor(param.getColor().toColor(mapper));
            eps.epsPolygon(points);
        }
    }
}

