/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.awt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.svek.PointDirected;
import net.sourceforge.plantuml.svek.Side;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ClusterPosition {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public ClusterPosition(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public ClusterPosition(XPoint2D min, XPoint2D max) {
        this(min.x, min.y, max.x, max.y);
    }

    public ClusterPosition move(double deltaX, double deltaY) {
        return new ClusterPosition(this.minX + deltaX, this.minY + deltaY, this.maxX + deltaX, this.maxY + deltaY);
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public boolean contains(double x, double y) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY;
    }

    public ClusterPosition merge(ClusterPosition other) {
        return new ClusterPosition(Math.min(this.minX, other.minX), Math.min(this.minY, other.minY), Math.max(this.maxX, other.maxX), Math.max(this.maxY, other.maxY));
    }

    public ClusterPosition merge(XPoint2D point) {
        double x = point.getX();
        double y = point.getY();
        return new ClusterPosition(Math.min(this.minX, x), Math.min(this.minY, y), Math.max(this.maxX, x), Math.max(this.maxY, y));
    }

    public boolean contains(XPoint2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public String toString() {
        return "minX=" + this.minX + " maxX=" + this.maxX + " minY=" + this.minY + " maxY=" + this.maxY;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public final double getMaxX() {
        return this.maxX;
    }

    public final double getMaxY() {
        return this.maxY;
    }

    public PointDirected getIntersection(XCubicCurve2D bez) {
        if (this.contains(bez.x1, bez.y1) == this.contains(bez.x2, bez.y2)) {
            return null;
        }
        double dist = bez.getP1().distance(bez.getP2());
        if (dist < 2.0) {
            double angle = BezierUtils.getStartingAngle(bez);
            return new PointDirected(bez.getP1(), angle);
        }
        XCubicCurve2D left = new XCubicCurve2D();
        XCubicCurve2D right = new XCubicCurve2D();
        bez.subdivide(left, right);
        PointDirected int1 = this.getIntersection(left);
        if (int1 != null) {
            return int1;
        }
        PointDirected int2 = this.getIntersection(right);
        if (int2 != null) {
            return int2;
        }
        throw new IllegalStateException();
    }

    public XPoint2D getPointCenter() {
        return new XPoint2D((this.minX + this.maxX) / 2.0, (this.minY + this.maxY) / 2.0);
    }

    public ClusterPosition withMinX(double d) {
        return new ClusterPosition(d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, d, this.maxY);
    }

    public ClusterPosition addMaxX(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + d, this.maxY);
    }

    public ClusterPosition addMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, this.maxY + d);
    }

    public ClusterPosition addMinX(double d) {
        return new ClusterPosition(this.minX + d, this.minY, this.maxX, this.maxY);
    }

    public ClusterPosition addMinY(double d) {
        return new ClusterPosition(this.minX, this.minY + d, this.maxX, this.maxY);
    }

    public ClusterPosition withMinY(double d) {
        return new ClusterPosition(this.minX, d, this.maxX, this.maxY);
    }

    public ClusterPosition withMaxY(double d) {
        return new ClusterPosition(this.minX, this.minY, this.maxX, d);
    }

    public XPoint2D getProjectionOnFrontier(XPoint2D pt) {
        double x = pt.getX();
        double y = pt.getY();
        if (x > this.maxX && y >= this.minY && y <= this.maxY) {
            return new XPoint2D(this.maxX - 1.0, y);
        }
        if (x < this.minX && y >= this.minY && y <= this.maxY) {
            return new XPoint2D(this.minX + 1.0, y);
        }
        if (y > this.maxY && x >= this.minX && x <= this.maxX) {
            return new XPoint2D(x, this.maxY - 1.0);
        }
        if (y < this.minY && x >= this.minX && x <= this.maxX) {
            return new XPoint2D(x, this.minY + 1.0);
        }
        return new XPoint2D(x, y);
    }

    public ClusterPosition delta(double m1, double m2) {
        return new ClusterPosition(this.minX, this.minY, this.maxX + m1, this.maxY + m2);
    }

    public XDimension2D getDimension() {
        return new XDimension2D(this.maxX - this.minX, this.maxY - this.minY);
    }

    public UTranslate getPosition() {
        return new UTranslate(this.getMinX(), this.getMinY());
    }

    public boolean isPointJustUpper(XPoint2D pt) {
        return pt.getX() >= this.minX && pt.getX() <= this.maxX && pt.getY() <= this.minY;
    }

    public Side getClosestSide(XPoint2D pt) {
        double distEast;
        double distNorth = Math.abs(this.minY - pt.getY());
        double distSouth = Math.abs(this.maxY - pt.getY());
        double distWest = Math.abs(this.minX - pt.getX());
        if (this.isSmallerThan(distNorth, distWest, distEast = Math.abs(this.maxX - pt.getX()), distSouth)) {
            return Side.NORTH;
        }
        if (this.isSmallerThan(distSouth, distNorth, distWest, distEast)) {
            return Side.SOUTH;
        }
        if (this.isSmallerThan(distEast, distNorth, distWest, distSouth)) {
            return Side.EAST;
        }
        if (this.isSmallerThan(distWest, distNorth, distEast, distSouth)) {
            return Side.WEST;
        }
        return null;
    }

    private boolean isSmallerThan(double value, double a, double b, double c) {
        return value <= a && value <= b && value <= c;
    }
}

